﻿var map;
var mapObj=new Object();
var pageCount=0;
var markers=new Array();/*楼盘标签*/
var trackStationMarkers=new Array();/*地铁站标签*/
var projInfos=new Array();
var timeoutHandle=null;
var markTimeHandles=[];
function $(id){ return document.getElementById(id);}
var trackMarkerClass="icon_subway";
var schoolDistrcit=[];
var schoolDistrcits=[];
var RailwayInfo=[];
var RailwayInfos=[];
var AntSaleMap=function()
{
    this.isDrag=false;/*是否拖动搜索*/
    this.isDrive=false;/*是否驾车*/
    this.isKeyWord=false;/*是否关键字搜索*/
    this.isSchool=false;/*学区房搜索*/
    this.keyMarker=null;/*关键字标签*/
    this.keyPoint=null;/*关键字坐标*/
    this.schoolMarker=null;/*学区标签*/
    this.trackMarker=null;/*地铁标签*/
    this.areaMaker=null;/*区域标签*/
    this.keyWord="";/*关键字*/
    this.keyAddress="";/*关键字地址*/
	this.url="";
    this.searchtype="0";/*0为正常搜索模式，1为区域搜索，2为地铁，3为学区，4为关键字*/
    this.isDriveFirst=true;/*驾车是否第一次加载*/
    this.isLineSelect=false;/*是否只为地铁线搜索*/
    this.initBaseControl();
    this.initMap();
    if(searchInfo.trackline==""){ searchInfo.trackline=searchInfo.isTrack=="1"?Railways1[0].name:""; };
    this.initDistrictControl("district",Districts1,Area1,"area");
    TrackSearchOnline=="Y"?this.initDistrictControl("track",Railways1,railway_station1,"track"):$("track").style.display="none";
    this.initPriceControl("price",Price1[0],"price");
    this.initAreaControl("area","area");
    this.initRoomControl("room",Room1,"room");
    Railways1.shift();
    this.icon=this.createIcon();
    if(searchInfo.schoolId!=""&&searchInfo.schoolName!=""){
        $("schoolTitle").innerHTML=searchInfo.schoolName;
        var school={id:searchInfo.schoolId,name:searchInfo.schoolName,point:new GLatLng(mapInfo.py,mapInfo.px)};
        this.searchtype="3";
        this.isSchool=false;
        this.getSchoolMarker(school);
        this.getSchoolProj();
    }
    else if(searchInfo.keyword!=""){
        this.getHouseByKey();
    }
    else{
        if(searchInfo.district==""&&searchInfo.comarea==""&&searchInfo.trackline==""&&searchInfo.trackstation==""){ this.getHousePoint(); }
        else { this.loadCityMap() ;}
    }
    this.newcode=searchInfo.projcode;
    this.initTipSearchControl();
    mapObj=this;
}
//初始化地图
AntSaleMap.prototype.initMap=function()
{
    this.mapContainer=$("map");
    this.map=new GMap2(this.mapContainer);
    this.map.setCenter(new GLatLng(mapInfo.py,mapInfo.px), mapInfo.mapZoom);
    var customUI = this.map.getDefaultUI();
    customUI.maptypes.hybrid = false;
    customUI.maptypes.physical = false;
    customUI.maptypes.satellite=false;
    G_NORMAL_MAP.getMinimumResolution = function (){
        return 8;
    };
    G_NORMAL_MAP.getMaximumResolution = function (){
        return 18;
    };
    G_SATELLITE_MAP.getMinimumResolution = function (){
        return 8;
    };
    G_SATELLITE_MAP.getMaximumResolution = function (){
        return 18;
    };
    this.map.setUI(customUI);
	this.map.enableScrollWheelZoom();
    this.map.addControl(new GScaleControl());
    this.map.addControl(new GOverviewMapControl());
    this.zoomStart();
    this.zoomEnd();
    this.moveStart();
    this.moveEnd();
    map=this.map;
}
//获取区域坐标
AntSaleMap.prototype.getAreaPoint=function()
{
    var E = 100;
    var mapsize=this.map.getSize();
    var G = this.map.fromContainerPixelToLatLng(new GPoint(64, E/2));
    var D = this.map.fromContainerPixelToLatLng(new GPoint(mapsize.width-E/2, mapsize.height-E/2));
    this.x1=G.lng();
    this.x2=D.lng();
    this.y1=D.lat();
    this.y2=G.lat();
}
//缩放事件
AntSaleMap.prototype.zoomEnd=function()
{
    GEvent.addListener(this.map, "zoomend", function ()
    {
        if(!mapObj.isDrive)
        {
            window.clearTimeout(timeoutHandle);
        }
    })
}
//缩放事件
AntSaleMap.prototype.zoomStart=function()
{
    GEvent.addListener(this.map, "zoomstart", function ()
    {
        mapObj.isDrag=true;
    })
}
//移动事件
AntSaleMap.prototype.moveStart=function()
{
    GEvent.addListener(this.map, "movestart", function ()
    {
        mapObj.isDrag=true;
        window.clearTimeout(timeoutHandle);
    })
}
AntSaleMap.prototype.moveEnd=function()
{
    GEvent.addListener(this.map, "moveend", function ()
    {
        mapObj.hideTip();
        if(mapObj.isDrag&&!mapObj.isDrive&&!mapObj.isKeyWord&&!mapObj.isSchool)
        {
            mapObj.initPageIndex();
            timeoutHandle = window.setTimeout(function(){mapObj.getHousePoint();}, 800)
        }
    })
}
//区域地铁查询
AntSaleMap.prototype.loadCityMap=function()
{
    this.isDrag=false;
    this.isKeyWord=false;
    this.hideTip();
    this.initPageIndex();
    var url="/public/xml.aspx?action=GetCityPoint&district="+escape(searchInfo.district)+"&comarea="+escape(searchInfo.comarea)+"&trackline="+escape(searchInfo.trackline)+"&trackstation="+escape(searchInfo.trackstation)+"&istrack="+searchInfo.isTrack;
    Xml.Request(url,null,function()
    {
        var content=this.responseXML.getElementsByTagName('point');
        if(content.length>0)
        {
            var px="",py="";
            var areaObj={};
            for(i=0;i<content.length;i++)
            {  
                for(j=0;j<content[i].childNodes.length;j++)
                {
                    if(content[i].childNodes[j].nodeName=="px")px=content[i].childNodes[j].firstChild? content[i].childNodes[j].firstChild.data : '';
                    if(content[i].childNodes[j].nodeName=="py")py=content[i].childNodes[j].firstChild? content[i].childNodes[j].firstChild.data : '';
                }
                if(i==0&&px!=""&&py!="")
                {
                    areaObj.point=new GLatLng(py,px);
                    if(searchInfo.isTrack=="1")
                    {
                        mapObj.searchtype="2";
                        //是否仅选择地铁线。
                        if(!mapObj.isLineSelect)
                        { 
                            mapInfo.zoom=mapInfo.trackZoom; 
                            areaObj.name=searchInfo.trackstation;
                            mapObj.getTrackMarker(areaObj);
                        }
                    }
                    else
                    {
                        mapObj.searchtype="1";
                        mapInfo.zoom=mapInfo.mapZoom;
                        areaObj.name=searchInfo.comarea!=""?searchInfo.comarea:searchInfo.district;
                        mapObj.getAreaMarker(areaObj);
                    }
                    map.setCenter(new GLatLng(py,px),mapInfo.zoom);
                    mapObj.getHousePoint();
                }
                else if(i==0&&(px==""||py==""))
                {
                    map.setCenter(new GLatLng(mapInfo.py,mapInfo.px),searchInfo.isTrack=="1"?mapInfo.trackZoom:mapInfo.mapZoom);
                    mapObj.getHousePoint();
                    searchInfo.isTrack="0";
                }
            }
        }
        else
        {
            map.setCenter(new GLatLng(mapInfo.py,mapInfo.px),searchInfo.isTrack=="1"?mapInfo.trackZoom:mapInfo.mapZoom);
            mapObj.getHousePoint();
            searchInfo.isTrack="0";
        }
    },null,false)
}
//关键字查询
AntSaleMap.prototype.getHouseByKey=function()
{
    this.isKeyWord=true;
    var url="/public/Xml.aspx?action=ShowPointKeyword&q="+escape(searchInfo.keyword); 
	
    Xml.Request(url,null,function()
    {
        var content=this.responseXML.getElementsByTagName('point'); 
        var keyword=this.responseXML.getElementsByTagName('keyword'); 
        var newcode=this.responseXML.getElementsByTagName('newcode'); 
        var keyaddress=this.responseXML.getElementsByTagName('address'); 
        var keyurl=this.responseXML.getElementsByTagName('url'); 
        mapObj.keyWord=keyword[0].firstChild?keyword[0].firstChild.data:"";
        mapObj.newcode=newcode[0].firstChild?newcode[0].firstChild.data:"";
        mapObj.keyAddress=keyaddress[0].firstChild?keyaddress[0].firstChild.data:"";
        mapObj.url=keyurl[0].firstChild?keyurl[0].firstChild.data:"";
        if(content.length>0)
        {
            var px="",py="";
            for(i=0;i<content.length;i++)
            {  
                for(j=0;j<content[i].childNodes.length;j++)
                {
                    if(content[i].childNodes[j].nodeName=="px")px=content[i].childNodes[j].firstChild? content[i].childNodes[j].firstChild.data : '';
                    if(content[i].childNodes[j].nodeName=="py")py=content[i].childNodes[j].firstChild? content[i].childNodes[j].firstChild.data : '';
                }
                if(i==0&&px!=""&&py!="")
                {
                    map.setCenter(new GLatLng(py,px),map.getZoom());
                    mapObj.getHousePoint();
                    //this.keyPoint=new GLatLng(py,px);     //error    
                }
                else
                {
                    mapObj.getHousePoint();
                }
            }
        }
    });
}

AntSaleMap.prototype.hideOther=function()
{
    if(mapInfo.maptype!="")
    {
        $("drive").style.display=this.isDriveFirst?"":"none";
    }
    this.isDriveFirst=false;
    $("drive_start").style.display="none";
    $("drive_end").style.display="none";
    $("btnBuilding").checked=true;
    this.isDrive=false;
}
//获取楼盘坐标
AntSaleMap.prototype.getHousePoint=function()
{
    this.showMessage();
    /*if(searchInfo.purpose=="")
    {
        $("ckbZZ").checked=true;
        $("ckbBS").checked=true;
    }*/
    this.getAreaPoint();
    if(this.isDrag||this.isKeyWord) {
    }
    var isLine=this.isLineSelect?"1":"0";
    searchInfo.isSchool=this.isSchool?"1":"0";
    var url="/public/xml.aspx?action=GetSalePointer&district="+escape(searchInfo.district)+"&comarea="+escape(searchInfo.comarea)+"&trackline="+escape(searchInfo.trackline)+"&trackstation="+escape(searchInfo.trackstation)+"&istrack="+searchInfo.isTrack+"&pricemax="+searchInfo.pricemax+"&pricemin="+searchInfo.pricemin+"&areamax="+searchInfo.areamax+"&areamin="+searchInfo.areamin+"&room="+searchInfo.room+"&purpose="+escape(searchInfo.purpose)+"&orderby="+searchInfo.orderby+"&x1="+this.x1+"&y1="+this.y1+"&x2="+this.x2+"&y2="+this.y2+"&page="+searchInfo.pageIndex+"&schoolprojcodes="+searchInfo.schoolProjcodes+"&isschool="+searchInfo.isSchool+"&isline="+isLine;
	
	Xml.Request(url,null,function()
    {
        projInfos=new Array();
        var content=this.responseXML.getElementsByTagName('project');
        var allcount=this.responseXML.getElementsByTagName('allcount');
        var listurlObj=this.responseXML.getElementsByTagName('listurl');
        var listurl=listurlObj[0].firstChild?listurlObj[0].firstChild.data:"";
        var loupancount=allcount[0].firstChild?allcount[0].firstChild.data:"";
        if(content.length>0)
        {
            var newcode="",projname="",address="", esfnum="",purpose="",px="",py="";
            var projObj=new Object();
            for(i=0;i<content.length;i++) 
            {  
                for(j=0;j<content[i].childNodes.length;j++)
                {
                    if(content[i].childNodes[j].nodeName=="newcode")newcode=content[i].childNodes[j].firstChild? content[i].childNodes[j].firstChild.data : '';
                    if(content[i].childNodes[j].nodeName=="projname")projname=content[i].childNodes[j].firstChild? content[i].childNodes[j].firstChild.data : '';
                    if(content[i].childNodes[j].nodeName=="address")address=content[i].childNodes[j].firstChild? content[i].childNodes[j].firstChild.data : '';
                    if(content[i].childNodes[j].nodeName=="purpose")purpose=content[i].childNodes[j].firstChild? content[i].childNodes[j].firstChild.data : '';
                    if(content[i].childNodes[j].nodeName=="esfnum")esfnum=content[i].childNodes[j].firstChild? content[i].childNodes[j].firstChild.data : '';
                    if(content[i].childNodes[j].nodeName=="px")px=content[i].childNodes[j].firstChild? content[i].childNodes[j].firstChild.data : '';
                    if(content[i].childNodes[j].nodeName=="py")py=content[i].childNodes[j].firstChild? content[i].childNodes[j].firstChild.data : '';		        
                }
                projObj={projcode:newcode,projnum:esfnum,projname:projname,address:address,purpose:purpose,point:new GLatLng(py,px),pointer:new BMap.Point(px,py)};
                projInfos.push(projObj);
            }
        }
        mapObj.hideMessage(loupancount);
        mapObj.clearMarker();
        mapObj.drawMarker();
        if(mapObj.searchtype=="1")
        {
            mapObj.addAreaMarker();
        }
        else if(mapObj.searchtype=="2")
        {
            mapObj.addTrackMarker();
        }
        else if(mapObj.searchtype=="3")
        {
            mapObj.addSchoolMarker();
            
        }
        else
        {
            mapObj.addKeyMarker();
        }
        
    },null,false);
}
//添加楼盘标签
AntSaleMap.prototype.drawMarker=function()
{
    var icon=this.icon;
    markers=new Array();    
    for(var i=0;i<projInfos.length;i++)
    {
        if(projInfos[i].projcode==mapObj.newcode&&!this.isSchool)
        continue;
        var purpose=projInfos[i].purpose;
        var houseid="house"+i;
        var numid="num"+i;
        var bkid="bk"+i;
        var closeid="close"+i;
        var html="";
        if(searchInfo.purpose=="住宅"){
            purpose="住宅";
        }
        else if(searchInfo.purpose=="别墅"){
            purpose="别墅";
        }

        if(purpose=="住宅")
        {
            html+="<div class='maskleft' onmouseover=\"_onMouseOver(this.id,'"+numid+"','"+bkid+"','"+closeid+"')\" onmouseout=\"_onMouseOut(this.id,'"+numid+"','"+bkid+"','zz','"+closeid+"')\" onclick=\"_onClickced(this,'"+numid+"','"+bkid+"','zz','"+closeid+"')\" isclicked='0' id='"+houseid+"'>"
            html+=projInfos[i].projname+"<label  id='"+numid+"' style='display:none'>&nbsp;<strong>"+projInfos[i].projnum+"</strong>套</label><input type='button' value='' id='"+closeid+"'  onclick=\"closeMarker(this)\" style='display:none'/><div class='maskright' id='"+bkid+"'/></div>";
        }
        else if(purpose=="别墅")
        {
            html+="<div class='maskleft0' onmouseover=\"_onMouseOver(this.id,'"+numid+"','"+bkid+"','"+closeid+"')\" onmouseout=\"_onMouseOut(this.id,'"+numid+"','"+bkid+"','bs','"+closeid+"')\" onclick=\"_onClickced(this,'"+numid+"','"+bkid+"','bs','"+closeid+"')\" isclicked='0' id='"+houseid+"'>"
            html+=projInfos[i].projname+"<label  id='"+numid+"' style='display:none'><strong>"+projInfos[i].projnum+"</strong>套</label><input type='button' value=''  id='"+closeid+"'  onclick=\"closeMarker(this)\" style='display:none'/><div class='maskright0' id='"+bkid+"'/></div>";
        }
               
        var opts={labelText:html,icon:icon,clickable:true};
		var labelmarker=new ComplexCustomOverlay(projInfos[i].point,i,this,projInfos[i].projname,'',projInfos[i].projcode,projInfos[i].pointer,opts);
        this.addMarker(i,labelmarker,this.map);

        /*var labelmarker=new LabeledMarker(projInfos[i].point,opts);
        labelmarker.projname = projInfos[i].projname;
        labelmarker.address=projInfos[i].address;
        labelmarker.housecount=projInfos[i].projnum;
        labelmarker.projcode=projInfos[i].projcode;
        labelmarker.point=projInfos[i].point;
        this.initMarker(labelmarker,i); 
        this.addMarker(i,labelmarker,this.map);
        markers.push(labelmarker);*/
    }
}
AntSaleMap.prototype._openTip = function(_pointer)
{
	mapObj.initTipControl();
	document.popups['maptip'].onclose = function(){_IsSetval = false;_setProvmarkState();};
	$("txtProjname").innerHTML=mapObj.keyWord;
	var projurl=mapObj.url;
	$("txtProjname").href=projurl;
	$("txtProjname").target="_blank";
	var cpoint=this.map.getCenter();
	var pp=this.map.fromLatLngToContainerPixel(_pointer);
	var cp=this.map.fromLatLngToContainerPixel(cpoint);
	var maptipLeft=pp.x+7;
	var maptipWidth=512;
	var maptipHeight=440;
	var maptipTop=120;
	if(pp.x>cp.x||pp.x>(maptipWidth+10)){
	maptipLeft=maptipLeft-maptipWidth-14;
	$("larrow").style.display="none";
	$("rarrow").style.display="";
	}
	else{
		$("larrow").style.display="";
		$("rarrow").style.display="none";
	}
	var cMaptipTop=cp.y-maptipHeight/2;
	var cMaptipBottom=cMaptipTop+maptipHeight;
	if((cMaptipTop+20)<pp.y&&pp.y<(cMaptipBottom-20)){
		maptipTop=114+cMaptipTop;
		$("larrow").style.top=parseInt(pp.y-cMaptipTop)+"px";
		$("rarrow").style.top=parseInt(pp.y-cMaptipTop)+"px";
	}
	else if(pp.y<(cMaptipTop+20)){
		maptipTop=114;
		$("larrow").style.top=parseInt(pp.y)+"px";
		$("rarrow").style.top=parseInt(pp.y)+"px";
	}
	else if(pp.y>(cMaptipBottom-20)){
		maptipTop=110+cMaptipTop*2;
		$("larrow").style.top=parseInt(pp.y-cMaptipTop*2+3)+"px";
		$("rarrow").style.top=parseInt(pp.y-cMaptipTop*2+3)+"px";
	}
	document.popups['maptip'].position =maptipLeft+","+maptipTop;
	document.popups['maptip'].open();
	searchInfo.projcode=mapObj.newcode;
	mapObj.getHouseData();
	mapObj.loadPageBar();
}
AntSaleMap.prototype.openTip = function(mm_,_pointer,_projname,_communityurl,_projcode)
{
	var me = this;
 	try{
		if($("house"+mm_)&&$("house"+mm_).style.display=="none"){
			 mapObj.hideTip();return;
		}
	 }catch(e){}
	 mapObj.initTipControl();
	 InitDriveInfo();
	 this.isProjDrive=true;
	 searchDriveInfo.end_x=_pointer.lng;
	 searchDriveInfo.end_y=_pointer.lat;
	 searchOtherInfo.x=_pointer.lng;
	 searchOtherInfo.y=_pointer.lat;
	$("txtEnd").value=_projname;
	$("txtEnd").disabled=true;
	document.popups['maptip'].onclose = function(){_IsSetval = false;_setProvmarkState();};
	$("txtProjname").innerHTML=_projname;
	 $("txtProjname").href=_communityurl;
	$("txtProjname").target="_blank";
	var cpoint=this.map.getCenter();
	var ppointer=new GLatLng( _pointer.lat ,_pointer.lng);
	var pp=this.map.fromLatLngToContainerPixel(ppointer);
	var cp=map.fromLatLngToContainerPixel(cpoint);
	var maptipLeft=pp.x+7;
	var maptipWidth=512;
	var maptipHeight=440;
	var maptipTop=120;
	if(pp.x>cp.x||pp.x>(maptipWidth+10)){
		maptipLeft=maptipLeft-maptipWidth-14;
		$("larrow").style.display="none";
		$("rarrow").style.display="";
	}
	else{
		$("larrow").style.display="";
		$("rarrow").style.display="none";
	}
	var cMaptipTop=cp.y-maptipHeight/2;
	var cMaptipBottom=cMaptipTop+maptipHeight;
	if((cMaptipTop+20)<pp.y&&pp.y<(cMaptipBottom-20)){
		maptipTop=114+cMaptipTop;
		$("larrow").style.top=parseInt(pp.y-cMaptipTop)+"px";
		$("rarrow").style.top=parseInt(pp.y-cMaptipTop)+"px";
	}
	else if(pp.y<(cMaptipTop+20)){
		maptipTop=114;
		$("larrow").style.top=parseInt(pp.y)+"px";
		$("rarrow").style.top=parseInt(pp.y)+"px";
	}
	else if(pp.y>(cMaptipBottom-20)){
		maptipTop=110+cMaptipTop*2;
		$("larrow").style.top=parseInt(pp.y-cMaptipTop*2+3)+"px";
		$("rarrow").style.top=parseInt(pp.y-cMaptipTop*2+3)+"px";
	}
	document.popups['maptip'].position =maptipLeft+","+maptipTop;
	document.popups['maptip'].open();
	searchInfo.projcode=_projcode;
	mapObj.getHouseData();
	mapObj.loadPageBar();
}
//初始化标签
AntSaleMap.prototype.initMarker=function(marker,i)
{
    GEvent.addListener(marker,"click",function()
    {
        try{
            if($("house"+i)&&$("house"+i).style.display=="none"){
                 mapObj.hideTip();return;
            }
        }catch(e){}
        mapObj.initTipControl();
        InitDriveInfo();
        isProjDrive=true;
        searchDriveInfo.end_x=marker.point.lng();
        searchDriveInfo.end_y=marker.point.lat();
        searchOtherInfo.x=marker.point.lng();
        searchOtherInfo.y=marker.point.lat();
        $("txtEnd").value=marker.projname;
        $("txtEnd").disabled=true;
        document.popups['maptip'].onclose = function(){_IsSetval = false;_setProvmarkState();};
        $("txtProjname").innerHTML=marker.projname;
        var projurl=marker.communityurl;
        $("txtProjname").href=projurl;
        $("txtProjname").target="_blank";
        var cpoint=map.getCenter();
        var pp=map.fromLatLngToContainerPixel(marker.point);
        var cp=map.fromLatLngToContainerPixel(cpoint);
        var maptipLeft=pp.x+7;
        var maptipWidth=512;
        var maptipHeight=440;
        var maptipTop=120;
        if(pp.x>cp.x||pp.x>(maptipWidth+10)){
            maptipLeft=maptipLeft-maptipWidth-14;
            $("larrow").style.display="none";
            $("rarrow").style.display="";
        }
        else{
            $("larrow").style.display="";
            $("rarrow").style.display="none";
        }
        var cMaptipTop=cp.y-maptipHeight/2;
        var cMaptipBottom=cMaptipTop+maptipHeight;
        if((cMaptipTop+20)<pp.y&&pp.y<(cMaptipBottom-20)){
            maptipTop=114+cMaptipTop;
            $("larrow").style.top=parseInt(pp.y-cMaptipTop)+"px";
            $("rarrow").style.top=parseInt(pp.y-cMaptipTop)+"px";
        }
        else if(pp.y<(cMaptipTop+20)){
            maptipTop=114;
            $("larrow").style.top=parseInt(pp.y)+"px";
            $("rarrow").style.top=parseInt(pp.y)+"px";
        }
        else if(pp.y>(cMaptipBottom-20)){
            maptipTop=110+cMaptipTop*2;
            $("larrow").style.top=parseInt(pp.y-cMaptipTop*2+3)+"px";
            $("rarrow").style.top=parseInt(pp.y-cMaptipTop*2+3)+"px";
        }
        document.popups['maptip'].position =maptipLeft+","+maptipTop;
        document.popups['maptip'].open();
        searchInfo.projcode=marker.projcode;
        mapObj.getHouseData();
        mapObj.loadPageBar();
    })
}
//标签鼠标事件
function _onMouseOver(objHouse,objNum,objBk,objbtn)
{ 
    var numDiv=$(objNum);//套数
    var houseDiv = $(objHouse);//楼盘名称 
    var objBk=$(objBk);
    var objbtn=$(objbtn);
    var pNode= houseDiv.parentNode;
    if(pNode)
    {
       pNode.style.zIndex= 10001;
    }
    houseDiv.className = 'left_hover';
    objBk.className="right_hover";
    objbtn.style.display = ''; 
    numDiv.style.display = ''; 
}
function _onMouseOut(objHouse,objNum,objBk,type,objbtn)
{ 
    var numDiv=$(objNum);//套数
    var houseDiv = $(objHouse);//楼盘名称 
    var objBk=$(objBk);
    var objbtn=$(objbtn);
    var isClicked = houseDiv.getAttribute("isclicked")=="1";
    if (!isClicked) {   
        numDiv.style.display = 'none';
        objbtn.style.display="none";
        if(type=="bs") {
            houseDiv.className = "maskleft0";
            objBk.className="maskright0";
        }
        else {
            houseDiv.className = "maskleft";
            objBk.className="maskright";
        }       
        
        houseDiv.parentNode.style.zIndex= -1;
    }
    else {
        houseDiv.parentNode.style.zIndex= 10001;
    }
}
var _CurrentEle= null;//设置标签对象 
var _IsSetval = false;//标签是否被选中
setInterval("_setSelected();","500");
function _onClickced(markEle,objNum,objBk,type,objbtn)
{
    if(_CurrentEle)
    {
        _setProvmarkState();
    }
    if(markEle)
    {
        markEle.setAttribute("isclicked","1");
        _CurrentEle = new Object();
        _CurrentEle.current = markEle;
        _CurrentEle.numDiv=$(objNum);
        _CurrentEle.bkDiv=$(objBk);
        _CurrentEle.objbtn=$(objbtn);
        _CurrentEle.bkType=type;
        var pNode= markEle.parentNode;
        _IsSetval=true;
        if(pNode){
            markEle.className="left_hover";
            $(objNum).style.display = ''; 
            $(objBk).className="right_hover";
            pNode.style.zIndex= 10001;
        }
        
    }
}
function _setProvmarkState()
{
    if(_CurrentEle){
        var proEle = _CurrentEle.current;
        var numDiv = _CurrentEle.numDiv;
        var objBk =_CurrentEle.bkDiv;
        var objbtn=_CurrentEle.objbtn;
        var bkType = _CurrentEle.bkType;
        if(proEle)
        {
            if(numDiv) {
                numDiv.style.display = 'none';
            }
            if(objbtn) {
                objbtn.style.display = 'none';
            }
            if(bkType=="zz") {
                proEle.className = "maskleft";
                objBk.className="maskright";
            }
            else {
                proEle.className = "maskleft0";
                objBk.className="maskright0";
            }
            proEle.setAttribute("isclicked","0");
            var pNode= proEle.parentNode;
            if(pNode) {
                pNode.style.zIndex= 0;
            }
        }
    }
}
function _setSelected()
{
    if(_IsSetval)
    {
        if(_CurrentEle)
        {
            var proEle = _CurrentEle.current;
            var pNode=proEle.parentNode;
            if(pNode)
            {
                pNode.style.zIndex= 10001;
            }
        }
    }
}
function closeMarker(obj)
{
    var pNode=obj.parentNode;
    if(pNode){
        pNode.style.display="none";
    }
}
//获取房源数据
AntSaleMap.prototype.getHouseData=function()
{
    var pricemax=searchInfo.tippricemax;
    var pricemin=searchInfo.tippricemin;
    var areamin=searchInfo.tipareamin;
    var areamax=searchInfo.tipareamax;
    var room=searchInfo.tiproom;
    var loadmsg='<div style="margin:0 auto; top:50%; padding-top:150px;text-align:center; width:200px;"><img src="'+imgurl+'load_18x18.gif">数据加载中...</div>';
    this.fillHouseSpace(loadmsg);
    var startDate= new Date()
    var url="/public/xml.aspx?action=getHouseData&purpose="+escape(searchInfo.purpose)+"&projcodes="+searchInfo.projcode+"&pricemax="+pricemax+"&pricemin="+pricemin+"&areamax="+areamax+"&areamin="+areamin+"&room="+room+"&orderby="+searchInfo.orderby+"&page="+searchInfo.tipPageIndex+"&isbest="+searchInfo.isbest;
    //window.open(url);
    Xml.Request(url,null,function()
    {
        var houseInfo=this.responseXML.getElementsByTagName('houseinfo');
        var agentInfo=this.responseXML.getElementsByTagName('agent');
        var allcount=this.responseXML.getElementsByTagName('allcount');
        var projprice=this.responseXML.getElementsByTagName('projprice');
		var listUrl=this.responseXML.getElementsByTagName('listurl');
		var CommunityPrice=this.responseXML.getElementsByTagName('CommunityPrice');
		$("txtProjname").href=listUrl[0].firstChild?listUrl[0].firstChild.data:"";
		$("lblhousecount").innerHTML=allcount[0].firstChild?allcount[0].firstChild.data:"";
		$("lblPrice").innerHTML=CommunityPrice[0].firstChild?CommunityPrice[0].firstChild.data:"";
        var dvInnerHtml = '';
        if(houseInfo &&houseInfo.length>0)
        {
            var isAppend = false;
            var pBulidarea = '',pRoom = '',hall='',pPrice = '',registdate='',pHouseimg = '',pUrl = '',title="",floor="",totalfloor="",isbest="";
            for(i=0;i<houseInfo.length;i++)
            {  
				if(i==0)
					$("dvHouseSpace").innerHTML="";
                for(j=0;j<houseInfo[i].childNodes.length;j++){
                    if(houseInfo[i].childNodes[j].nodeName=="bulidarea")pBulidarea=houseInfo[i].childNodes[j].firstChild? houseInfo[i].childNodes[j].firstChild.data : '';
                    if(houseInfo[i].childNodes[j].nodeName=="title")title=houseInfo[i].childNodes[j].firstChild? houseInfo[i].childNodes[j].firstChild.data : '';
                    if(houseInfo[i].childNodes[j].nodeName=="floor")floor=houseInfo[i].childNodes[j].firstChild? houseInfo[i].childNodes[j].firstChild.data : '';
                    if(houseInfo[i].childNodes[j].nodeName=="totalfloor")totalfloor=houseInfo[i].childNodes[j].firstChild? houseInfo[i].childNodes[j].firstChild.data : '';
                    if(houseInfo[i].childNodes[j].nodeName=="room")pRoom=houseInfo[i].childNodes[j].firstChild? houseInfo[i].childNodes[j].firstChild.data : '';
                    if(houseInfo[i].childNodes[j].nodeName=="hall")hall=houseInfo[i].childNodes[j].firstChild? houseInfo[i].childNodes[j].firstChild.data : '';
                    if(houseInfo[i].childNodes[j].nodeName=="price")pPrice=houseInfo[i].childNodes[j].firstChild? houseInfo[i].childNodes[j].firstChild.data : '';
                    if(houseInfo[i].childNodes[j].nodeName=="houseimg")pHouseimg=houseInfo[i].childNodes[j].firstChild? houseInfo[i].childNodes[j].firstChild.data : '';
                    if(houseInfo[i].childNodes[j].nodeName=="houseurl")pUrl=houseInfo[i].childNodes[j].firstChild? houseInfo[i].childNodes[j].firstChild.data : '';
                    if(houseInfo[i].childNodes[j].nodeName=="registdate")registdate=houseInfo[i].childNodes[j].firstChild? houseInfo[i].childNodes[j].firstChild.data : '';
                    if(houseInfo[i].childNodes[j].nodeName=="isbest")isbest=houseInfo[i].childNodes[j].firstChild? houseInfo[i].childNodes[j].firstChild.data : '';

                }
                title=title.length>40?title.substring(0,40):title;

				dvInnerHtml ="<LI onmouseover='this.className=\"list_hover\"' onmouseout='this.className=\"\"'>";
				var avgPrice="---";
				if(pPrice==0){
					pPrice="面议";
				}
				else{
					pPrice=pPrice+"万";	
					avgPrice=parseInt((parseFloat(pPrice)*10000)/parseFloat(pBulidarea))+"元/平米"
				}
				dvInnerHtml +=" <DIV class=price>"+pPrice+"</DIV>";
				dvInnerHtml +="<DIV class=proimg><A  href='"+pUrl+"' target=_blank>";
				dvInnerHtml +="<IMG height=40 src='"+pHouseimg+"' width=53 border=0></A></DIV> ";
				dvInnerHtml +="<DIV class=proname>";
				dvInnerHtml +="<P class=title><A href='"+pUrl+"' target=_blank>"+title+"</A>&nbsp;";
				if(isbest=="1"){
                    dvInnerHtml+="<img src=\""+imgurl+"AntMoreImg.gif\" align=\"absmiddle\" />";
                }
				dvInnerHtml +="</P>";
				dvInnerHtml +="<P>"+pRoom+"室"+hall+"厅，"+pBulidarea+"平米，"+floor+"/"+totalfloor+"层，";
				dvInnerHtml +="<font>"+avgPrice+"</font>，<SPAN>"+registdate+"</SPAN></P></DIV>";
				
				dvInnerHtml +="</LI>";
				
				$("dvHouseSpace").innerHTML=$("dvHouseSpace").innerHTML+dvInnerHtml
            }
            if(dvInnerHtml){
				//$("dvHouseSpace").innerHTML=dvInnerHtml
                //mapObj.fillHouseSpace(dvInnerHtml);
            }
        }
        else
        {
            mapObj.fillHouseSpace("<div style=\"padding:120px;text-align:center;\">没有找到任何房源！</div>");
        }
        mapObj.loadPageBar();
    },null,false);
}
AntSaleMap.prototype.fillHouseSpace=function(html)
{
    $("dvHouseSpace").innerHTML=html;
}
//分页控件
AntSaleMap.prototype.loadPageBar= function()
{
    var projcode=searchInfo.projcode;
    var pIndex= searchInfo.tipPageIndex;
    var pageNavibar = '';
    var pIntCount = parseInt($("lblhousecount").innerHTML);
    pageCount = pIntCount>0 && pIntCount >=6 ?(pIntCount%6==0?pIntCount/6:pIntCount/6+1):1;
    pageCount=parseInt(pageCount);
    if(pageCount >1)
    {
        if(pIndex==1)
        {
        	pageNavibar+="<td width=160px></td><td align=center><span class=\"total_pages\">"+pIndex+"/"+pageCount+"页</span></td><td width=160px><a href=\"javascript:void(0)\" onclick=\"mapObj.goNext();\"  class=\"page_next\" >下一页</a></td>";
		}
        else if(pIndex==pageCount)
        {
			pageNavibar+="<td width=160px><a href=\"javascript:void(0)\" onclick=\"mapObj.goPre();\"  class=\"page_prev\">上一页</a></td><td align=center><span class=\"total_pages\">"+pIndex+"/"+pageCount+"页</span></td><td width=160px></td>"; 
		}
        else{ 
			pageNavibar+="<td width=160px><a href=\"javascript:void(0)\" onclick=\"mapObj.goPre();\"  class=\"page_prev\">上一页</a></td><td align=center><span class=\"total_pages\">"+pIndex+"/"+pageCount+"页</span></td><td width=160px><a href=\"javascript:void(0)\" onclick=\"mapObj.goNext();\"  class=\"page_next\">下一页</a></td>";
		}
    }
    else
	{
		pageNavibar+="<td><span class=\"total_pages\">"+pIndex+"/"+pageCount+"页</span></td>";
	}
	pageNavibar="<table width=100%><tr>"+pageNavibar+"</tr></table>"
	document.getElementById("pageNavibar").innerHTML=pageNavibar;
}
//翻页
AntSaleMap.prototype.goPre=function (){
    var pIndex= searchInfo.tipPageIndex;
    var pageNavibar="<span class=\"total_pages\">"+pIndex+"/"+pageCount+"页</span>";
    document.getElementById("pageNavibar").innerHTML=pageNavibar;
    var prepIndex=searchInfo.tipPageIndex;
    searchInfo.tipPageIndex=parseInt(prepIndex)-1;
    this.getHouseData();
}
AntSaleMap.prototype.goNext=function(){
    var pIndex= searchInfo.tipPageIndex;
    var pageNavibar="<span class=\"total_pages\">"+pIndex+"/"+pageCount+"页</span>";
    document.getElementById("pageNavibar").innerHTML=pageNavibar;
    var nextpIndex=searchInfo.tipPageIndex;
    searchInfo.tipPageIndex=parseInt(nextpIndex)+1;
    this.getHouseData();
}
//每30毫秒加载一个楼盘标签
AntSaleMap.prototype.addMarker=function(i,marker)
{
    var markTimeHandle=window.setTimeout(function()
    {
        map.addOverlay(marker);
    },  i* 30)
    markTimeHandles[i]=markTimeHandle;
}
//清除楼盘标签
AntSaleMap.prototype.clearMarker=function()
{
    if(isProjOther)
    {
        for(var i=0;i<markers.length;i++)
        {
            map.removeOverlay(markers[i]);
            if(this.keyMarker){
                map.removeOverlay(this.keyMarker);
            }
        }
    }
    else{
        map.clearOverlays();
    }
}
//清除加载标签的定时器
AntSaleMap.prototype.clearMarkTimeHandle=function()
{
    for(var i=0;i<markTimeHandles.length;i++)
    {
        window.clearTimeout(markTimeHandles[i]);
    }
}
//loading show
AntSaleMap.prototype.showMessage=function()
{
    this.hideTip();
    this.hideOther();
    //closeOterSearch();
    $("message").style.display="";
    $("btnmore").style.display="none";
    $("result").style.display="none";
}
//loading hide
AntSaleMap.prototype.hideMessage=function(loupancount)
{
    this.hideTip();
    $("lblProjectCount").innerHTML=loupancount;
    if(loupancount>50)$("btnmore").style.display="";
    $("message").style.display="none";
    $("result").style.display="";
    //$("ckbZZ").disabled=true;
    //$("ckbBS").disabled=true;
    $('dbox').style.display='none';
}
//创建标签图标
AntSaleMap.prototype.createIcon=function()
{
    var icon=new GIcon();
    icon.image = imgurl+"marker_trans.png";
    icon.shadow = imgurl+"marker_trans.png";
    icon.iconSize = new GSize(21, 35);
    icon.shadowSize = new GSize(37, 35);
    icon.iconAnchor = new GPoint(10, 35);
    icon.infoWindowAnchor = new GPoint(10, 3);
    return icon;     
}
///隐藏Tip框
AntSaleMap.prototype.hideTip=function()
{
    if(document.popup != null)
    {
        document.popup.hide(true);
        searchInfo.tipPageIndex=1;
    }
}
//创建区域和地铁下拉菜单（区域控件）
AntSaleMap.prototype.initDistrictControl=function(containerId,level1,level2,type)
{
    if($(containerId))
    {
        //头部菜单
        var Container=$(containerId);
        Container.style.display="";
        this.offsetWidth=Container.offsetWidth;
        this.offsetTop=Container.offsetTop;
        var Itemheader=document.createElement("dl");
        Itemheader.style.display="none";
        Itemheader.className="pull-downgg";
        if(type=="track"){
            Itemheader.style.left="203px";
        }
        var tempCount=20;
        level1.unshift({name:type=="track"?"线路不限":"区域不限",index:-1});
        var level1Length=level1.length;
        if(level1Length>tempCount){
            Itemheader.style.width="170px";
        }
        Itemheader.style.position="absolute";
        for(var i=0;i<level1.length;i++)
        {
            var areaItem=document.createElement("dd");
            var areaItemText=document.createElement("div");
            areaItemText.style.width="100%";
            areaItemText.innerHTML=level1[i].name;
            areaItemText.value=level1[i].name;
            if(level1Length>tempCount)
            {
                JustBroswer()=="IE"?areaItem.style.styleFloat="left":areaItem.style.cssFloat="left";
            }
           
            areaItem.setAttribute("index",level1[i].index);
            areaItem.appendChild(areaItemText);
			
            areaItem.parentElem=this;
            //是否存在二级菜单
            if(level2[level1[i].index]&&level2[level1[i].index].length>1)
            {
                areaItem.className="havesecondmenu";
                var secondOption=document.createElement("ul");
                secondOption.style.display="none";
                secondOption.style.position="absolute";
                if(level1Length>tempCount){
                    if(i%2==0) secondOption.style.left=parseInt(this.offsetWidth-40)+"px";
                    else secondOption.style.left=parseInt(this.offsetWidth+45)+"px";
                    secondOption.style.top=(this.offsetTop+parseInt(i/2)*20-5)+"px";
                }
                else{
					if(JustBroswer()== 'IE')
					{
						secondOption.style.left=parseInt(this.offsetWidth-1)+"px";
						secondOption.style.top=(this.offsetTop+i*22-1)+"px";
					}
					else{
						secondOption.style.left=parseInt(this.offsetWidth-1)+"px";
						secondOption.style.top=(this.offsetTop+i*22-119)+"px";	
					}
                }
                secondOption.style.width="255px";
                secondOption.style.backgroundColor="#FFFFE6";
                secondOption.style.borderTop="1px solid #ff9900";
                secondOption.style.borderRight="1px solid #ff9900";
                secondOption.style.borderBottom="1px solid #ff9900";
                secondOption.style.color="#BA1400";
                secondOption.setAttribute("id",type+level1[i].index);
                secondOption.parentElem=areaItem;
                for(var j=0;j<level2[level1[i].index].length;j++)
                {
                    var secondOptionItem=document.createElement("li");
					secondOptionItem.style.width="80px";
                    secondOptionItem.style.paddingLeft="5px";
                    if(type=="track")
                    {
                        secondOptionItem.innerHTML=level2[level1[i].index][j];
                    }
                    else
                    {
                        secondOptionItem.innerHTML=level2[level1[i].index][j].substring(2,level2[level1[i].index][j].length);
                    }
                    secondOptionItem.area1=level1[i].name;
                    secondOptionItem.area2=secondOptionItem.innerHTML;
                    if(type=="track")
                    {
                        if(secondOptionItem.area2==searchInfo.trackstation&&searchInfo.trackline!=""&&searchInfo.trackstation!=""&&searchInfo.isTrack=="1")
                        { 
                            $("trackTitle").innerHTML=this.isLineSelect?searchInfo.trackline:searchInfo.trackstation;
                        }
                    }
                    else
                    {
                        if(secondOptionItem.area2==searchInfo.comarea&&searchInfo.district!=""&&searchInfo.comarea!=""&&searchInfo.isTrack=="0")
                        { 
                            $("districtTitle").innerHTML=searchInfo.comarea;
                        };
                    }
                    secondOptionItem.onclick=function()
                    {
						$("districtTitle").innerHTML=this.innerHTML;
						searchInfo.isTrack="0";
						searchInfo.district=this.area1;
						searchInfo.comarea=this.area2;
						this.parentNode.style.display="none";
						this.parentNode.parentNode.parentNode.style.display="none";
                        mapObj.loadCityMap();
                    }
                    secondOptionItem.onmouseover=function()
                    {
                        this.style.backgroundColor="#FE9B05";
						this.style.color="#FFFFFF";
                        this.style.fontWeight="normal";                            
                    }
                    secondOptionItem.onmouseout=function()
                    {
                        this.style.backgroundColor="#FFFFE6";
                        this.style.color="#BA1400";
                        this.style.fontWeight="normal";
                    }
                    secondOption.appendChild(secondOptionItem);
                }
                areaItem.appendChild(secondOption);
            }
            areaItem.onmouseover=function()
            {
                this.style.backgroundColor="#FE9B05";
                this.style.color="#FFFFFF";
                this.index=this.getAttribute("index");
                if($(type+this.index))
                {
                    $(type+this.index).style.display="";
                    this.style.fontWeight="normal";
                }
            }
            areaItem.onmouseout=function()
            {
                this.style.backgroundColor="#FFFFE6";
                this.style.fontWeight="normal";
                this.style.color="#BA1400";
                if($(type+this.index))
                {
                    $(type+this.index).style.display="none";
                }
            }
            areaItemText.onclick=function()
            {
				$("districtTitle").innerHTML=this.value;
				searchInfo.isTrack="0";
				searchInfo.district=this.value=="区域不限"?"":this.value;
				searchInfo.comarea="";
                mapObj.loadCityMap();
                if($(type+this.parentNode.index))
                {
                    $(type+this.parentNode.index).style.display="none";
                }
                this.parentNode.parentNode.style.display="none";
            }
            Itemheader.appendChild(areaItem);
        }
		
        Container.appendChild(Itemheader);
        Container.onmouseover=function(){
            Itemheader.style.display="";
        }
        Container.onmouseout=function(){
            Itemheader.style.display="none";
        }
	    
    }
}
//创建价格控件
AntSaleMap.prototype.initPriceControl=function(containerid,content,type)
{
    var Container=$(containerid);
    var Itemheader=document.createElement("dl");
    Itemheader.style.display="none";
    Itemheader.className="pull-down";
    Itemheader.style.left=(Container.offsetLeft)+"px";
    if(JustBroswer()== 'IE')
	    Itemheader.style.marginTop="15px";
	else 
	    Itemheader.style.marginTop="-2px";
    var ItemUnit=document.createElement("dd");
    ItemUnit.innerHTML=content.unit;
    ItemUnit.style.color="orange";
    Itemheader.appendChild(ItemUnit);
    for(var i=0;i<content.text.length+1;i++)
    {
        var Item=document.createElement("dd");
        Item.pricemin="";
        Item.pricemax="";
        if(i==content.text.length)
        {
            //Item.innerHTML="<input type='integer' size='1' id='priceMin'/> - <input type='integer' size='1'  id='priceMax'/><input type='button' value='确定'  onclick=\"getUserDefine('price',this)\"/>";
        }
        else 
        {
            if(i==0) { 
                Item.innerHTML="价格不限"; 
            }
            else {
                Item.innerHTML=content.text[i];
            }
            var price=content.value[i].split(',');
            if(price&&price.length>1) {
                Item.pricemin=price[0];
                Item.pricemax=price[1];
            }
            this.initItem(Item,type);
        }
        if(searchInfo.pricemax==Item.pricemax&&searchInfo.pricemin==Item.pricemin&&(searchInfo.pricemin!=""||searchInfo.pricemax!=""))
        {
            $("priceTitle").innerHTML=Item.innerHTML;
        }
		if(Item.innerHTML.length>0){
        	Itemheader.appendChild(Item);
		}
    }
    Container.appendChild(Itemheader);
    Container.onmouseover=function()
    {
        Itemheader.style.display="";
    }
    Container.onmouseout=function()
    {
        Itemheader.style.display="none";
    }
}
//创建面积控件
AntSaleMap.prototype.initAreaControl=function(containerid,type)
{
    var Container=$(containerid);
    var Itemheader=document.createElement("dl");
    Itemheader.style.display="none";
    Itemheader.className="pull-down";
    Itemheader.style.left=(Container.offsetLeft)+"px";
    if(JustBroswer()== 'IE')
	    Itemheader.style.marginTop="15px";
	else 
	    Itemheader.style.marginTop="-2px";	
	
    var ItemUnit=document.createElement("dd");
    ItemUnit.innerHTML="单位(平米)";
    ItemUnit.style.color="orange";
    Itemheader.appendChild(ItemUnit);
    var areaName=areaNameTemp.split(',');
    var areaValue=areaValueTemp.split(',');
    for(var i=0;i<areaName.length+1;i++)
    {
        var Item=document.createElement("dd");
        Item.areamin="";
        Item.areamax="";
        if(i==areaName.length)
        {
            //Item.innerHTML="<input type='integer' size='3' id='areaMin'/> - <input type='integer' size='3'  id='areaMax'/><input type='button' value='确定' onclick=\"getUserDefine('area',this)\"/>";
        }
        else
        {
            var area=areaValue[i].split('-');
            if(area&&area.length>1) {
                Item.areamin=area[0];
                Item.areamax=area[1];
            }
            Item.innerHTML=areaName[i].replace("平米","");
            this.initItem(Item,type);
        }
        if(searchInfo.areamax==Item.areamax&&searchInfo.areamin==Item.areamin&&(searchInfo.areamax!=""||searchInfo.areamin!=""))
        {
            $("areaTitle").innerHTML=Item.innerHTML;
        }
		if(Item.innerHTML.length>0)
		{
        	Itemheader.appendChild(Item,type);
		}
    }
    Container.appendChild(Itemheader);
    Container.onmouseover=function() {
        Itemheader.style.display="";
    }
    Container.onmouseout=function() {
        Itemheader.style.display="none";
    }
}
//创建户型控件
AntSaleMap.prototype.initRoomControl=function(containerid,content,type)
{
    var Container=$(containerid);
    var Itemheader=document.createElement("dl");
    Itemheader.style.display="none";
    Itemheader.className="pull-down";
    Itemheader.style.left=(Container.offsetLeft)+"px";
    if(JustBroswer()== 'IE')
	    Itemheader.style.marginTop="15px";
	else 
	    Itemheader.style.marginTop="-2px";
    for(var i=0;i<content.length;i++)
    {
        var Item=document.createElement("dd");
        if(i==0) Item.innerHTML="户型不限"; 
        else Item.innerHTML=content[i].name;
        Item.value=content[i].value;
        if(searchInfo.room==Item.value&&searchInfo.room!="")
        {
            $("roomTitle").innerHTML=Item.innerHTML;
        }
        this.initItem(Item,type);
        Itemheader.appendChild(Item);
    }
    Container.appendChild(Itemheader);
    Container.onmouseover=function()
    {
        Itemheader.style.display="";
    }
    Container.onmouseout=function()
    {
        Itemheader.style.display="none";
    }
}
function getUserDefine(type,obj)
{
    if(type=="price")
    {
        if($("priceMax").value!=""||$("priceMin").value!="")
        {
            try
            {
                if(parseInt($("priceMax").value)<parseInt($("priceMin").value))
                {
                    alert("价格条件输入有误！");
                    $("priceMax").value="";
                    $("priceMin").value="";
                    return;
                }
                
            }catch(e)
            { 
                alert("价格条件输入有误！");
                $("priceMax").value="";
                $("priceMin").value="";
                return;
            }
            $("priceMax").onclick=function(){ $("priceMax").focus(); };
            $("priceMin").onclick=function(){ $("priceMin").focus(); };
            searchInfo.pricemax=$("priceMax").value;
            searchInfo.pricemin=$("priceMin").value;
            $(type+"Title").innerHTML=searchInfo.pricemin+"-"+searchInfo.pricemax;
            mapObj.initPageIndex();
            mapObj.getHousePoint();
        }
    }
    else if(type=="area")
    {
        if($("areaMax").value!=""||$("areaMin").value!="")
        {
            try
            {
                if(parseInt($("areaMax").value)<parseInt($("areaMin").value))
                {
                    alert("面积条件输入有误！");
                    $("areaMax").value="";
                    $("areaMin").value="";
                    return;
                }
                
            }catch(e){ alert("面积条件输入有误！");$("areaMax").value="";$("areaMin").value;return;}
            $("areaMax").onclick=function(){ $("areaMax").focus(); };
            $("areaMin").onclick=function(){ $("areaMin").focus(); };
            searchInfo.areamax=$("areaMax").value;
            searchInfo.areamin=$("areaMin").value;
            $(type+"Title").innerHTML=searchInfo.areamin+"-"+searchInfo.areamax;
            mapObj.getHousePoint();
        }
    }
    obj.parentNode.parentNode.style.display="none";
}
//初始化价格面积户型控件
AntSaleMap.prototype.initItem=function(Item,type)
{
    Item.onmouseover=function()
    {
        this.style.backgroundColor="#49AEFD";
        this.style.color="#ffffff";
    }
    Item.onmouseout=function()
    {
        this.style.backgroundColor="white";
        this.style.color="#04c";
    }
    Item.onclick=function()
    {   
        $(type+"Title").innerHTML=this.innerHTML;
        this.parentNode.style.display="none";
        if(type=="price")
        {
            searchInfo.pricemax=this.pricemax;
            searchInfo.pricemin=this.pricemin;
        }
        else if(type=="area")
        {
            searchInfo.areamax=this.areamax
            searchInfo.areamin=this.areamin
        }
        else if(type=="room")
        {
            searchInfo.room=this.value;
        }
        mapObj.isDrag=false;
        mapObj.isKeyWord=false;
        mapObj.initPageIndex();
        mapObj.getHousePoint();
    }
}

//基础控件加载
AntSaleMap.prototype.initBaseControl=function()
{
    this.mapOffsetHeight=JustBroswer()=="IE"?182:182;
    $("map").style.height=(document.documentElement.clientHeight-this.mapOffsetHeight)+"px";
    /*if(searchInfo.purpose=="住宅") {
        $("ckbBS").checked=false;
    }
    else if(searchInfo.purpose=="别墅") {
        $("ckbZZ").checked=false;
    }
	*/
    this.initOtherControlLeft();
    this.initOtherControlTop();
    if(searchInfo.keyword!="") {
        $("keyword").value=searchInfo.keyword;
        $("keyword").style.color = '#000000';
        this.keyWord=searchInfo.keyword;
        this.isKeyWord=true;
    }
    if(mapInfo.maptype=="drive") {
        $("drive").style.display="";
        $("other").style.display="none";
        if(this.isKeyWord){
            searchDriveInfo.end_x=mapInfo.px;
            searchDriveInfo.end_y=mapInfo.py;
            if(("txtStart").value!="")isProjDrive=true;
            $("txtEnd").value=searchInfo.keyword;
            $("txtEnd").disabled=true;
        }
    }
    else if(mapInfo.maptype=="other"){
        $("other").style.display="";
        $("drive").style.display="none";
        this.isDriveFirst=false;
    }
}
//初始化tip上的筛选按钮
AntSaleMap.prototype.initTipSearchControl=function()
{
    this.initTipPrice();
    this.initTipArea();
    this.initTipRoom();
}
AntSaleMap.prototype.initTipPrice=function()
{
    if(JustBroswer()== 'IE')
        $("tipPrice").style.marginTop="14px";
	else 
	    $("tipPrice").style.marginTop="-8px";	
    var ItemUnit=document.createElement("dd");
    ItemUnit.innerHTML="单位(万元)";
    ItemUnit.style.color="orange";
    $("tipPrice").appendChild(ItemUnit);
    for(var i=0;i<Price1[0].text.length;i++)
    {
        var dd=document.createElement("dd");
        dd.innerHTML=Price1[0].text[i].replace('不限','价格不限');
        if(i==0){
            dd.minPrice="";
            dd.maxPrice="";
        }
        else{
            dd.minPrice=Price1[0].value[i].split(',')[0];
            dd.maxPrice=Price1[0].value[i].split(',')[1];
        }
        dd.onmouseover=function(i)
        {
            this.style.backgroundColor="#49AEFD";
			this.style.color="white";
		}
		dd.onmouseout=function()
        {
            this.style.backgroundColor="white";
            this.style.color="#0256B8";
        }
        dd.onclick=function()
        {
			searchInfo.tipPageIndex=1;
            searchInfo.tippricemax=this.maxPrice;
            searchInfo.tippricemin=this.minPrice;
            this.parentNode.style.display='none';
            $("tipPriceTitle").innerHTML=this.innerHTML;
            mapObj.getHouseData();
        }
        $("tipPrice").appendChild(dd);
    }
}
AntSaleMap.prototype.initTipArea=function()
{
    if(JustBroswer()== 'IE')
    	$("tipArea").style.marginTop="14px";
	else 
	    $("tipArea").style.marginTop="-8px";	
    var AreaText=areaNameTemp.split(',');
    var AreaValue=areaValueTemp.split(',');
    var ItemUnit=document.createElement("dd");
    ItemUnit.innerHTML="单位(平米)";
    ItemUnit.style.color="orange";
    $("tipArea").appendChild(ItemUnit);
    for(var i=0;i<AreaText.length;i++)
    {
        var dd=document.createElement("dd");
        dd.innerHTML=AreaText[i].replace('平米','');
        if(i==0){
            dd.minArea="";
            dd.maxArea="";
        }
        else{
            dd.minArea=AreaValue[i].split('-')[0];
            dd.maxArea=AreaValue[i].split('-')[1];
        }
        dd.onclick=function()
        {
            searchInfo.tipareamax=this.maxArea;
            searchInfo.tipareamin=this.minArea;
            this.parentNode.style.display='none';
            $("tipAreaTitle").innerHTML=this.innerHTML;
			searchInfo.tipPageIndex=1;
            mapObj.getHouseData();
        }
        dd.onmouseover=function(i)
        {
            this.style.backgroundColor="#49AEFD";
			this.style.color="white";
		}
		dd.onmouseout=function()
        {
            this.style.backgroundColor="white";
            this.style.color="#0256B8";
        }	
        $("tipArea").appendChild(dd);
    }
}
AntSaleMap.prototype.initTipRoom=function()
{
    if(JustBroswer()== 'IE')
	    $("tipRoom").style.marginTop="14px";
	else 
	    $("tipRoom").style.marginTop="-8px";
    for(var i=0;i<Room1.length;i++)
    {
        var dd=document.createElement("dd");
        dd.innerHTML=Room1[i].name.replace('不限','户型不限');
        dd.room=Room1[i].value;
        dd.onclick=function(){
			searchInfo.tipPageIndex=1;
            searchInfo.tiproom=this.room;
            this.parentNode.style.display='none';
            $("tipRoomTitle").innerHTML=this.innerHTML;
            mapObj.getHouseData();
        }
        dd.onmouseover=function(i)
        {
            this.style.backgroundColor="#49AEFD";
			this.style.color="white";
		}
		dd.onmouseout=function()
        {
            this.style.backgroundColor="white";
            this.style.color="#0256B8";
        }
        $("tipRoom").appendChild(dd);
    }
}
//初始化周边相关控件顶部边距
AntSaleMap.prototype.initOtherControlTop=function()
{
    $("otherIcon").style.display="none";
    $("otherIcon").style.top=(this.mapOffsetHeight+5)+"px";
    $("other").style.top=this.mapOffsetHeight+"px";
    $("drive").style.top=this.mapOffsetHeight+"px";
    $("drive_start").style.top=this.mapOffsetHeight+"px";
    $("drive_end").style.top=this.mapOffsetHeight+"px";
}
//初始化周边相关控件左边距
AntSaleMap.prototype.initOtherControlLeft=function(){
    this.otherListLeft=document.documentElement.clientWidth-198;
    $("otherIcon").style.left=(document.documentElement.clientWidth-110)+"px";
    $("other").style.left=this.otherListLeft+"px";
    $("drive").style.left=this.otherListLeft+"px";
    $("drive_start").style.left=this.otherListLeft+"px";
    $("drive_end").style.left=this.otherListLeft+"px";
}
//打开TIP时初始化相应控件
AntSaleMap.prototype.initTipControl=function()
{
    mapObj.hideTip();
    searchInfo.tipPageIndex=1;
    searchInfo.orderby="";
    searchInfo.isbest=0;
    $("btnIsBest").checked=false;
    $("tipPriceTitle").innerHTML=$("priceTitle").innerHTML;
    $("tipAreaTitle").innerHTML=$("areaTitle").innerHTML;
    $("tipRoomTitle").innerHTML=$("roomTitle").innerHTML;
    searchInfo.tippricemin=searchInfo.pricemin;
    searchInfo.tippricemax=searchInfo.pricemax;
    searchInfo.tipareamin=searchInfo.areamin;
    searchInfo.tipareamax=searchInfo.areamax;
    searchInfo.tiproom=searchInfo.room;
}
//多图房源
$("btnIsBest").onclick=function()
{
    this.disabled=true;
    searchInfo.isbest=this.checked?1:0;
    searchInfo.tipPageIndex=1;
    mapObj.getHouseData();
    this.disabled=false;
}
//打开TIP时初始化相应控件
AntSaleMap.prototype.addKeyLog=function()
{
    
}
//关键字搜索
function getByKey()
{
    mapObj.searchtype="4";
    mapObj.hideTip();
    mapObj.initPageIndex();
    if($("keyword").value=="请输入地域名或小区全称") { $("keyword").value="";}
    searchInfo.keyword=$("keyword").value;
    mapObj.getHouseByKey();
    //增加关键字日志
    mapObj.addKeyLog();
}

function setNormal()
{
   
}
//地图视图
$("spanNormal").onclick=function()
{
    var htm=this.innerHTML.toLowerCase();
    if(htm.indexOf('</a>')>-1)
    {
        map.setMapType(G_NORMAL_MAP);
        this.innerHTML="地图视图";
        $("spanSatellite").innerHTML="<a href='javascript:void(0)' class='Ant'>卫星视图</a>";
    }
}
//卫星视图
$("spanSatellite").onclick=function()
{
    var htm=this.innerHTML.toLowerCase();
    if(htm.indexOf('</a>')>-1)
    {
        map.setMapType(G_SATELLITE_MAP);        
        this.innerHTML="卫星视图";
        $("spanNormal").innerHTML="<a href='javascript:void(0)' class='Ant'>地图视图</a>";
    }
}
//选择物业类型
function purposeChange()
{
    mapObj.initPageIndex();
    /*$("ckbZZ").disabled=true;
    $("ckbBS").disabled=true;
    if($("ckbZZ").checked&&$("ckbBS").checked) {
        searchInfo.purpose="";
    }
    else if(!$("ckbZZ").checked&&!$("ckbBS").checked) {
        searchInfo.purpose="";
        mapObj.clearMarkTimeHandle();
        mapObj.clearMarker();
        mapObj.hideMessage(0);
        $("btnmore").style.display="none";
        return;
    }
    else if($("ckbZZ").checked&&!$("ckbBS").checked) {
        searchInfo.purpose="住宅";
    }
    else {
        searchInfo.purpose="别墅";
    }
	*/
    mapObj.getHousePoint();
}
AntSaleMap.prototype.initPageIndex=function()
{
    searchInfo.pageIndex=1;
    $("btnmore").innerHTML="下50个小区>>"
}
function getMoreHousePoint()
{
    $("btnmore").disabled=true;
    var total=parseInt($("lblProjectCount").innerHTML);
    var maxIndex=parseInt(total/50)+1;
    var mapIndex=searchInfo.pageIndex;
    if($("btnmore").innerHTML=="下50个小区&gt;&gt;"){
        if( mapIndex<2 ) searchInfo.pageIndex=2;
    }
    else searchInfo.pageIndex=1;
    mapObj.getHousePoint();
    searchInfo.pageIndex=searchInfo.pageIndex+1;
    if(searchInfo.pageIndex>maxIndex){ $("btnmore").innerHTML="<<返回"; }
    else{ $("btnmore").innerHTML="下50个小区>>"; }
    $("btnmore").disabled=false;
}
function closeDbox()
{
    $('dbox').style.display='none';
    $('keyword').value='';
    $('keyword').focus();
}
window.onload=function(){
    var antsalemap=new AntSaleMap();
}
//释放内存资源
window.onunload=function(){
    GUnload();
    timeoutHandle=null;
    markTimeHandles=null;
    mapObj=null;
}
window.onresize=function(){
	//alert(mapObj.mapOffsetHeight);
    var mapHeight=parseInt(document.documentElement.clientHeight)-mapObj.mapOffsetHeight;
    var bodyScroll=document.body.getAttribute("scroll");
    if(mapHeight<450) {
        mapHeight=450;
        document.body.setAttribute("scroll","");
    }
    else {
        document.body.setAttribute("scroll","no");
    }
	if(mapHeight)
	{
    	$("map").style.height=mapHeight+"px";
   		 mapObj.initOtherControlLeft();
	}
    if(typeof map!="undefined") map.checkResize();
}
JustBroswer=function(){
    return navigator.appName == 'Microsoft Internet Explorer'?"IE": "FireFox";
}
/*学区房*/
var schoolTimeOut=[];
var schoolList=new Array();
var schoolLoadOver=new Array();
var districtSchools=new Array();//区县学校大全
AntSaleMap.prototype.initSchoolControl=function()
{
    $("selectSchool").style.display="";
    if(schoolDistrcit.length>0)
    {
        for(var i=0;i<schoolDistrcit.length;i++)
        {
            var dd=document.createElement("dd");
            dd.innerHTML=schoolDistrcit[i];
            dd.value=schoolDistrcit[i];
            dd.index=i;
            dd.style. cursor="auto";
            dd.onmouseover=function(i)
            {
				this.style.backgroundColor="#49AEFD";
				this.style.color="white";
				if(schoolLoadOver[this.index]&&schoolLoadOver[this.index]==true)
				{
                    if($("schoollist"+this.index)){ $("schoollist"+this.index).style.display=""; }
				}
				else
				{
			        if(districtSchools[this.index]&&districtSchools[this.index].length>0)
			        { 
			            mapObj.showSchool(districtSchools[this.index],this.index,this);
			            if(schoolTimeOut){
			                for(var i=0;i<schoolTimeOut.length;i++){
			                    window.clearTimeOut(schoolTimeout[i]);
			                }
			            }
			            schoolLoadOver[this.index]=true;
			        }
				}
            }
            dd.onmouseout=function()
            {
                this.style.backgroundColor="white";
                this.style.color="#0256B8";
                if($("schoollist"+this.index)){ $("schoollist"+this.index).style.display="none"; }
            }
            this.getSchoolList(i,schoolDistrcit[i]);
            $("dlSchoolDisrict").appendChild(dd);
        }
    }
}
$("selectSchool").onmouseover=function()
{
    $('dlSchoolDisrict').style.display=""; 
}
$("selectSchool").onmouseout=function()
{
    $('dlSchoolDisrict').style.display="none";
}
AntSaleMap.prototype.showSchool=function(schools,index,item)
{
    var schoolDiv=document.createElement("div");
    schoolDiv.className="schoollist";
    schoolDiv.style.left="85px"
    schoolDiv.style.top="-1px";
    schoolDiv.style.zIndex=1000;
    schoolDiv.setAttribute("id","schoollist"+index);
    var nuerySchools=new Array();
    var highSchools=new Array();
    for(var i=0;i<schools.length;i++)
    {
        if(schools[i].type=="小学")
        {
            nuerySchools.push(schools[i]);
        }
        else if(schools[i].type=="中学")
        {
            highSchools.push(schools[i]);
        }
    }
    var nuerySchoolDiv=document.createElement("div");
    nuerySchoolDiv.className="school_main";
    for(var i=0;i<nuerySchools.length+1;i++)
    {
        if(i==0)
        {
            var p=document.createElement("p");
            p.className="school_name";
            p.innerHTML="小学";
            nuerySchoolDiv.appendChild(p);
        }
        else
        {
            var pItem=document.createElement("p");
            pItem.innerHTML=nuerySchools[i-1].name;
            pItem.value=nuerySchools[i-1].name;
            pItem.sid=nuerySchools[i-1].id;
            pItem.px=nuerySchools[i-1].px;
            pItem.py=nuerySchools[i-1].py;
            pItem.onclick=function()
            {
                if(this.parentNode.parentNode)
                {
                    this.parentNode.parentNode.style.display="none";
                }
                mapObj.schoolSelect(this);
            }
            pItem.onmouseover=function()
            {
                this.style.backgroundColor="#49AEFD";
				this.style.color="white";
            }
            pItem.onmouseout=function()
            {
                this.style.backgroundColor="white";
                this.style.color="#0256B8";
            }
            nuerySchoolDiv.appendChild(pItem);
        }
    }
    var highSchoolDiv=document.createElement("div");
    highSchoolDiv.className="school_main";
    highSchoolDiv.style.paddingRight="0px";
    for(var i=0;i<highSchools.length+1;i++)
    {
        if(i==0)
        {
            var p=document.createElement("p");
            p.className="school_name";
            p.innerHTML="中学";
            highSchoolDiv.appendChild(p);
        }
        else
        {
            var pItem=document.createElement("p");
            pItem.innerHTML=highSchools[i-1].name;
            pItem.value=highSchools[i-1].name;
            pItem.sid=highSchools[i-1].id;
            pItem.px=highSchools[i-1].px;
            pItem.py=highSchools[i-1].py;
            pItem.onclick=function()
            {
                if(this.parentNode.parentNode)
                {
                    this.parentNode.parentNode.style.display="none";
                }
                mapObj.schoolSelect(this);
            }
            pItem.onmouseover=function()
            {
                this.style.backgroundColor="#49AEFD";
				this.style.color="white";
            }
            pItem.onmouseout=function()
            {
                this.style.backgroundColor="white";
                this.style.color="#0256B8";
            }
            highSchoolDiv.appendChild(pItem);
        }
    }
    if(nuerySchools.length>0)
         schoolDiv.appendChild(nuerySchoolDiv);
    if(highSchools.length>0)
        schoolDiv.appendChild(highSchoolDiv);
    var schoolHeight=22*parseInt(index);
    schoolDiv.style.top=schoolHeight+"px";
    schoolDiv.style.display=schools.length>0?"":"none";
    item.appendChild(schoolDiv);
}

//区域标签
AntSaleMap.prototype.addAreaMarker=function()
{
    if(this.areaMarker)
    {
        this.map.addOverlay(this.areaMarker);
        var oDiv=$("areaMarkerDiv");
        if(oDiv){
            oDiv.parentNode.style.zIndex= 1000;
        }
    }
}
//获取区域标签
AntSaleMap.prototype.getAreaMarker=function(areaObj)
{
    var icon=this.icon;
    var html='<div style="position: absolute;left:-9px;top:-52px;" id="areaMarkerDiv"><div class="placemask"><div class="place">'+areaObj.name+'</div><div class="flag"></div></div>'
    var opts={labelText:html,icon:icon,clickable:true};
	var labelmarker=new _ComplexCustomOverlay(areaObj.point,this,opts);
	this.areaMarker=labelmarker;
    /*var labelmarker=new LabeledMarker(areaObj.point,opts);
    labelmarker.point = areaObj.point;
    labelmarker.name=areaObj.name;
    this.areaMarker=labelmarker;*/
}
//地铁标签
AntSaleMap.prototype.addTrackMarker=function()
{
    if(this.isLineSelect)
    {
        /*选中地铁线则加载所有地铁站标签*/
        this.getAllTrackByLine();
    }
    else
    {
        if(this.trackMarker)
        {
            this.map.addOverlay(this.trackMarker);
            var oDiv=$("trackMarkerDiv");
            if(oDiv){
                oDiv.parentNode.style.zIndex= 1000;
            }
        }
    }
}
//根据地铁线获取全部地铁站
AntSaleMap.prototype.getAllTrackByLine=function()
{
    
}
AntSaleMap.prototype.AddAllTrackMarker=function()
{
    for(var i=0;i<trackStationMarkers.length;i++)
    {
        var icon=this.icon;
        var html='<div class="tagleft" style="left:-2px;top:-40px" id="trackStation'+i+'"><span class="'+trackMarkerClass+'">'+trackStationMarkers[i].name+'</span><div class="tagright"/></div></div>';
        var opts={labelText:html,icon:icon,clickable:true};
        var labelmarker=new LabeledMarker(trackStationMarkers[i].point,opts);
        this.initTrackStationMarker(labelmarker,trackStationMarkers[i].name);
        map.addOverlay(labelmarker);
        var oDiv=$("trackStation"+i);
        if(oDiv){
            oDiv.parentNode.style.zIndex= 100*i;
        }
    }
}
/*初始化地铁站点标记*/
AntSaleMap.prototype.initTrackStationMarker=function(stationMarker,trackName)
{
    GEvent.addListener(stationMarker,"click",function()
    {
        searchInfo.trackstation=trackName;
        $("trackTitle").innerHTML=trackName;
        mapObj.isLineSelect=false;
        mapObj.loadCityMap();
    })
}
//获取地铁标签
AntSaleMap.prototype.getTrackMarker=function(trackObj)
{
    var icon=this.icon;
    var html='<div class="tagleft" style="left:-2px;top:-40px;cursor:auto" id="trackMarkerDiv"><span class="'+trackMarkerClass+'">'+trackObj.name+'</span><div class="tagright"/></div></div>';
    var opts={labelText:html,icon:icon,clickable:false};
    var labelmarker=new LabeledMarker(trackObj.point,opts);
    labelmarker.point = trackObj.point;
    labelmarker.name=trackObj.name;
    this.trackMarker=labelmarker;
}
//学区标签
AntSaleMap.prototype.addSchoolMarker=function()
{
    if(this.schoolMarker)
    {
        this.map.addOverlay(this.schoolMarker);
        var oDiv=$("schoolMarkerDiv");
        if(oDiv){
            oDiv.parentNode.style.zIndex= 1000;
        }
    }
}
//获取学区房标签
AntSaleMap.prototype.getSchoolMarker=function(schoolObj)
{
    var icon=this.icon;
    var html='<div class="tagleft" style="left:-2px;top:-40px" id="schoolMarkerDiv"><span class="icon_school">'+schoolObj.name+'</span><div class="tagright"/></div></div>';
    var opts={labelText:html,icon:icon,clickable:true};
    var labelmarker=new LabeledMarker(schoolObj.point,opts);
    labelmarker.point = schoolObj.point;
    labelmarker.id=schoolObj.id;
    labelmarker.name=schoolObj.name;
    this.initSchoolMarker(labelmarker,this.map); 
    this.schoolMarker=labelmarker;
}
//初始化学区房标签
AntSaleMap.prototype.initSchoolMarker=function(schoolmarker)
{
    GEvent.addListener(schoolmarker,"click",function()
    {
        mapObj.initTipControl();
        var cpoint=map.getCenter();
        var pp=map.fromLatLngToContainerPixel(schoolmarker.point);
        var cp=map.fromLatLngToContainerPixel(cpoint);
        var maptipLeft=pp.x+7;
        var maptipWidth=360;
        var maptipHeight=280;
        var maptipTop=120;
        if(pp.x>cp.x||pp.x>(maptipWidth+10)){
            maptipLeft=maptipLeft-maptipWidth-14;
            $("slarrow").style.display="none";
            $("srarrow").style.display="";
        }
        else{
            $("slarrow").style.display="";
            $("srarrow").style.display="none";
        }
        var cMaptipTop=cp.y-maptipHeight/2;
        var cMaptipBottom=cMaptipTop+maptipHeight;
        if((cMaptipTop+20)<pp.y&&pp.y<(cMaptipBottom-20)){
            maptipTop=114+cMaptipTop;
            $("slarrow").style.top=parseInt(pp.y-cMaptipTop)+"px";
            $("srarrow").style.top=parseInt(pp.y-cMaptipTop)+"px";
        }
        else if(pp.y<(cMaptipTop+20)){
            maptipTop=114;
            $("slarrow").style.top=parseInt(pp.y)+"px";
            $("srarrow").style.top=parseInt(pp.y)+"px";
        }
        else if(pp.y>(cMaptipBottom-20)){
            maptipTop=110+cMaptipTop*2;
            $("slarrow").style.top=parseInt(pp.y-cMaptipTop*2+3)+"px";
            $("srarrow").style.top=parseInt(pp.y-cMaptipTop*2+3)+"px";
        }
        document.popups['maptipschool'].position =maptipLeft+","+maptipTop;
        document.popups['maptipschool'].open();
        mapObj.getSchoolDataById(schoolmarker.id);
    })
}
//关键字标签
AntSaleMap.prototype.addKeyMarker=function()
{
    if(searchInfo.keyword!="") {
        if(this.keyMarker!=null) {
            if(this.isKeyWord) {
                this.map.removeOverlay(this.keyMarker);
                this.initKeyMarker();
            }
            else{
                
                this.map.addOverlay(this.keyMarker); 
                if(this.newcode!=typeof('undefined')&&this.newcode!=""){
                    if($("divkeyMarker"))
                    $("divkeyMarker").style.cursor="pointer";
                }
            }
        }
        else {            
            this.initKeyMarker();
        }
    }
}
//初始化关键字标签
AntSaleMap.prototype.initKeyMarker=function()
{   
    if(mapObj.newcode!="")
    {
        var html='<div style="position: absolute;" id="divkeyMarker"><div class="left_hover" >'+this.keyWord+'<div class="right_hover" /></div></div>'
        var opts={labelText:html,icon:this.icon,clickable:true};
        this.keyPoint=this.map.getCenter();
       this.keyMarker=new _ComplexCustomOverlay(this.keyPoint,this,opts);
        if($("divkeyMarker"))
        	$("divkeyMarker").style.cursor="pointer";
       map.addOverlay(this.keyMarker);
    }
    else
    {
        if(searchInfo.keyword!=cityname&&searchInfo.keyword!=cityname+"市"&&searchInfo.keyword!=(cityname+"市")&&searchInfo.keyword!=(cityname)&&(this.keyWord=="中国"+cityname||this.keyWord=="中国"+cityname))
        {   
            var errKeyWord= searchInfo.keyword; 
            if(errKeyWord.length>12)
              errKeyWord=errKeyWord.substring(0,12);
            $("spanKeyWord").innerHTML=errKeyWord;
            $("dbox").style.left=(document.documentElement.clientWidth - 350) / 2+"px";
            $("dbox").style.top =(document.documentElement.clientHeight - 150) / 2 + document.documentElement.scrollTop+"px";
            $("dbox").style.zIndex=100;                       
            $("dbox").style.display="";
        }  
        else
        {
            var html='<div style="position: absolute;left:-9px;top:-52px;" id="divkeyMarker"><div class="placemask"><div class="place">'+this.keyWord+'</div><div class="flag"></div></div>'
            var opts={labelText:html,icon:this.icon,clickable:true};
            this.keyPoint=this.map.getCenter();
            //this.keyMarker=new LabeledMarker(this.keyPoint,opts);
            //this.map.addOverlay(this.keyMarker); 
        }     
    }
    this.isKeyWord=false;
    var oDiv=$("divkeyMarker");
    if(oDiv){
        oDiv.parentNode.style.zIndex= 100;
    }
}
//获取学校信息
AntSaleMap.prototype.getSchoolDataById=function(sid)
{
   
}

/*给对象添加事件*/
AntSaleMap.prototype.addEvent=function(element, eventType, handler)
{
	if (document.addEventListener)
	{
		element.addEventListener(eventType, handler, false);
	}
	else if (document.attachEvent)
	{
		element.attachEvent("on" + eventType, handler);
	}
}

var lineNext=$("lineNext");
var linePre=$("linePre");
if(lineNext&&linePre)
{
    lineNext.onclick=function()
    {
        if(currLine)
        {
            currLine.style.display="none";
        }
        if(currLineNext)
        {
            currLineNext.style.display="none";
        }
        if(currLinePre)
        {
            currLinePre.style.display="none";
        }
        if(lineMiddleIndex>0)
        {
            lineMiddleIndex=lineMiddleIndex+1;
            if($("trackgentline"+lineMiddleIndex))
            {
                currLine=$("trackgentline"+lineMiddleIndex);
                currLine.style.display="block";
            }
            if($("trackgentline"+(lineMiddleIndex-1)))
            {
                currLinePre=$("trackgentline"+(lineMiddleIndex-1));
                currLinePre.style.display="block";
            }
            if($("trackgentline"+(lineMiddleIndex+1)))
            {
                currLineNext=$("trackgentline"+(lineMiddleIndex+1));
                currLineNext.style.display="block";
            }
            if(lineMiddleIndex<2)
            {
                linePre.style.display="none";
            }
            else if(lineMiddleIndex>(Railways1.length-3))
            {
                lineNext.style.display="none";
            }
            else
            {
                linePre.style.display="block";
                lineNext.style.display="block";
            }
        }
    }
    linePre.onclick=function()
    {
        if(currLine)
        {
            currLine.style.display="none";
        }
        if(currLineNext)
        {
            currLineNext.style.display="none";
        }
        if(currLinePre)
        {
            currLinePre.style.display="none";
        }
        lineMiddleIndex=lineMiddleIndex-1;
        if($("trackgentline"+lineMiddleIndex))
        {
            currLine=$("trackgentline"+lineMiddleIndex);
            currLine.style.display="block";
        }
        if($("trackgentline"+(lineMiddleIndex-1)))
        {
            currLinePre=$("trackgentline"+(lineMiddleIndex-1));
            currLinePre.style.display="block";
        }
        if($("trackgentline"+(lineMiddleIndex+1)))
        {
            currLineNext=$("trackgentline"+(lineMiddleIndex+1));
            currLineNext.style.display="block";
        }
        if(lineMiddleIndex<2)
        {
            linePre.style.display="none";
        }
        else if(lineMiddleIndex>(Railways1.length-3))
        {
            lineNext.style.display="none";
        }
        else
        {
            linePre.style.display="block";
            lineNext.style.display="block";
        }
    }
}