﻿/**
* 实例化MapApi，添加搜索等操作
*/
jQuery(function($){
	jQuery("#AntInfoNavLink_Help").hover(function(){
		jQuery("#AntInfo-menu_Help").show();
		jQuery("#AntInfoNavLink_Helpa").removeClass();
		jQuery("#AntInfoNavLink_Helpa").addClass('AntInfoHelpCurrent');
	},function(){
		jQuery("#AntInfo-menu_Help").hide();
		jQuery("#AntInfoNavLink_Helpa").removeClass();
		jQuery("#AntInfoNavLink_Helpa").addClass('AntInfoHelp');
	});
	jQuery("#AntInfoNavLink_Company").hover(function(){
		jQuery("#AntInfo-menu_Company").show();
		jQuery("#AntInfoNavLink_Companya").removeClass();
		jQuery("#AntInfoNavLink_Companya").addClass('AntInfoHelpCurrent');
	},function(){
		jQuery("#AntInfo-menu_Company").hide();
		jQuery("#AntInfoNavLink_Companya").removeClass();
		jQuery("#AntInfoNavLink_Companya").addClass('AntInfoHelp');
	});
	jQuery("#AntInfoNavLink_daohang").hover(function(){
		jQuery("#AntInfo-menu_daohang").show();
		jQuery("#AntInfoNavLink_daohanga").removeClass();
		jQuery("#AntInfoNavLink_daohanga").addClass('AntInfoHelpCurrent');
	},function(){
		jQuery("#AntInfo-menu_daohang").hide();
		jQuery("#AntInfoNavLink_daohanga").removeClass();
		jQuery("#AntInfoNavLink_daohanga").addClass('AntInfoHelp');
	});
});

var districtname = "";
var paramsname = "";
var roundname = "";
var searchname = "";
var purposename = "";
var pricevalue = "";
var defaultValue={
	"keyword":{"text":"请输入您要查询的楼盘名称，如：雅戈尔太阳城","value":"雅戈尔太阳城"},
	"zhs_key":{"text":"请输入您要查询的装饰公司名称","value":""},
	"jcc_key":{"text":"请输入您要查询的商家名称","value":""},
	"nearfindname":{"text":"如：现代大道","value":"现代大道"},
	"nearfindtype":{"text":"如：餐厅","value":"餐厅"},
	"busstartname":{"text":"如：东环路","value":"东环路"},
	"busendname":{"text":"如：相城大道","value":"相城大道"},
	"busstationname":{"text":"请输入公交站名，如：乐桥","value":"乐桥"},
	"buslinenum":{"text":"请输入公交线路，如：68","value":"68"},
	"startarea":{"text":"如：干将路","value":"干将路"},
	"endarea":{"text":"如：观前街","value":"观前街"}
};



var SFMap = {
	map:null,
	zoomMax:19,
	zoomMin:12,
	metaMarkers:null,
	dragSearch:true,
	isDragend:true,
	mapDragTimeOut:null,
	//用来存储当前页面上所有点的信息
	markerList:{},
	keyPointMarker:null,
	firstLoad:true,
	autoView:false,
	titleText:'',

	setMapType:function(node)
	{
		var txt = node.innerHTML;
		var mType = G_NORMAL_MAP;
		if(txt.indexOf('卫星') > -1)
		{
			mType = G_SATELLITE_MAP;
		}
		this.map.setMapType(mType);
		var str="";
		if(txt=="卫星视图")
		{
			str='<a href="javascript:;" onclick="SFMap.setMapType(this);" Class="Ant">地图视图</a> - <a href="javascript:;" >卫星视图</a>';
		}
		else {
			str='<a href="javascript:;">地图视图</a> - <a href="javascript:;" onclick="SFMap.setMapType(this);" Class="Ant"" >卫星视图</a>';	
		}
		ViewMap.innerHTML = str;
		
	},
	openTipById:function(newCode)
	{
		var mNode = $id('tip'+newCode);
		if(mNode)
		{
			if(document.all)
			{
				mNode.click();
			}
			else
			{
				var evt = document.createEvent('MouseEvents');
				evt.initEvent('click', true, true);
				mNode.dispatchEvent(evt);
			}
		}
	},
	closeTip:function()
	{
		this.map.closeTip();
	},
	toggleDrag:function(node, isClick)
	{
		if(node.checked)
		{
			this.dragSearch = false;
		}
		else
		{
			this.dragSearch = true;
			if(isClick) this.searchResult();
		}
	},
	setDragSearch:function(flg)
	{
		this.dragSearch = flg;
		$id('lock').checked = (!flg);
	},
	getDragSearch:function()
	{
		return this.dragSearch;
	},
	desName:'楼盘',
	init:function()
	{
		this.map = new MapApi('map_canvas', cityy, cityx, mapsize);
		if(filePath.indexOf('zhuangshi') > -1)
		{
			this.desName = '装饰公司';
			this.cookieName = 'map_fav_zs';
		}
		if(filePath.indexOf('company') > -1)
		{
			this.desName = '商家';
			this.cookieName = 'map_fav_jcc';
		}
		if(filePath.indexOf('360') > -1)
		{
			this.desName = '全景';
			this.cookieName = 'map_fav_quan';
		}
	},

	//区县和商圈，先以区县或商圈文字请求出中心点，把地图移动，然后再搜索即可
	getCenter:function(dname,pname) {
		var me = this;
		var pname = pname || '';
		me.isDragend = false;
		if('' == dname || '全部区县' == dname)
		{
			me.map.setCenter(cityy,cityx,mapsize);
			me.searchResult();
			return;
		}
		
		var showGetCenter = function (originalRequest)	{
			var objxml = originalRequest.responseXML;
			var result = objxml.getElementsByTagName("result")[0];
			if(!result) return;
			var status = result.getElementsByTagName("status")[0].firstChild.data;
			if(status == 0)
			{
				return;
			}
			else
			{
				var x = 181;
				if(result.getElementsByTagName("x")[0].firstChild != null)
				{
					x = result.getElementsByTagName("x")[0].firstChild.data;
				}
				var y = 91;
				if(result.getElementsByTagName("y")[0].firstChild != null)
				{
					y = result.getElementsByTagName("y")[0].firstChild.data;
				}
				if(Math.abs(y*1)<=90&&Math.abs(x*1)<=180)
				{
					//me.map.panTo(y,x);
					//me.map.setZoom(mapsize);
					me.map.setCenter(y,x,mapsize);
					me.searchResult();
				}
			}
		};

		var url = '/public/xml.aspx?action=getcenter';
		var method = 'post';
		var params = {'cname':escape(searchcondition['cityname']),'dname':escape(dname),'pname':escape(pname),'random':Math.random()};
		var xhr = new SFXHR(url, method, params, showGetCenter);

	},
	keepkw:false,
	kwHouse:false,
	searchKeyword:function(page, flg, keyword)
	{
		//alert('searchKeyword');
		var me = this;
		SFUI.hideId('jczbresult');
		if($id('panel_keyword')) $id('panel_keyword').style.display='none';
		var page = page || 0;
		page = parseInt(page);
		//me.isDragend = false;
		var flg = flg || 'house';
		var inputKeyword = $id('keyword');
		var autoChange = keyword ? false : true;
		var keyword = keyword || inputKeyword.value;
		keyword = keyword.replace(/(^\s*)|(\s*$)/g, "");
		keyword = keyword.replace(/\s/g,"");
		me.setDragSearch(false);
		//alert(keyword);
		//如果是有关键字的，先搜索
		if(keyword != '' && keyword != inputKeyword.defaultValue)
		{
			var checkboxs = {sell_pre:2,sell_now:1,sell_out:0,rent_now:3};//,rent_sell:4};
			for(var i in checkboxs)
			{
				if($id(i)) $id(i).checked = true;
			}
			var kHouseOnComplete = function(origRequest)
			{
				me.isDragend = true;
				SFUI.showId('map_total');
				SFUI.hideId('map_loading');
				var jsonText = origRequest.responseText;
				//alert(jsonText);
				try
				{
					var result = eval('('+jsonText+')');
					var status = result.status;
				}
				catch(e)
				{
					alert('系统错误，请重试！');
					return;
				}
				var allnum = 'undefined' != typeof result.allnum ? result.allnum : 0;
				if(0 == allnum && autoChange)
				{
					me.searchKeyword(0, 'key', keyword);
					return;
				}
				me.markerList = {};
				me.map.clearMarkers();
				me.map.clearOverlays();

				result.title = me.titleText;
				//把对数据的处理放到这里来
				if(allnum > 0)
				{
					if(result.hits.hit.newCode) result.hits.hit = [result.hits.hit];
					var hits = result.hits.hit;
					var metaMarkers = me.getMetaMarkers(hits);
					me.showResult(metaMarkers);
					result.hits.hit = metaMarkers;
				}
				else
				{
					result.words = '<li>选定区域。</li><li>尝试不同关键字。</li>';
				}
				if(me.keyPointMarker)
				{
					me.map.addKeyMarker(me.keyPointMarker);
					me.keyPointMarker = null;
				}
				me.showList(result);
			};
			var kOnComplete = function(origRequest){
				var jsonText = origRequest.responseText;
				try
				{
					var keyPoint = eval('('+jsonText+')');
				}
				catch(e)
				{
					alert('系统错误！');
					return;
				}
				if(1 == keyPoint.status)
				{
					if(keyPoint.y && keyPoint.x && Math.abs(keyPoint.y*1) <= 90 &&Math.abs(keyPoint.x*1) <= 180)
					{
						me.keyPointMarker = keyPoint;
						//var isDragendSave = SFMap.isDragend;
						//SFMap.isDragend = false;
						me.map.setCenter(keyPoint.y,keyPoint.x,mapsize);
						//SFMap.isDragend = isDragendSave;
						me.keepkw = true;
						me.searchResult(0,1);
						return;
					}
				}
				//alert('没有搜索到"'+keyword+'"相关的结果!');
				kOnFailure();
			};
			var kOnFailure = function(){
				//alert('没有搜索到"'+keyword+'"相关的结果!');
				SFUI.showId('map_total');
				SFUI.hideId('map_loading');
				me.markerList = {};
				me.map.clearMarkers();
				me.map.clearOverlays();
				var result = {'status':0, 'allnum':0, 'words':'<li>选定区域。</li><li>尝试不同关键字。</li>', 'title':me.titleText};
				me.showList(result);
				//return;
			};

			var kMethod = 'post';
			var kParams = {'keyword':escape(keyword), 'output':'json', 'random':Math.random()};
			var homeParams = {'city':escape(city), 'cname':escape(searchcondition['cityname']),'dearlertype':2};
			var type_cn = '楼盘';
			var url = '/public/xml.aspx?action=ShowBuild';
			var btype = 'house';
			
			if ('装饰公司' == me.desName)
			{
				if('house' == flg) kParams = SFUtil.objMerge(homeParams,kParams);
				type_cn = '公司';
				url = 'aa.aspx';
				btype = 'zhuangshi';
			}
			else if ('商家' == me.desName)
			{
				if('house' == flg) kParams = SFUtil.objMerge(homeParams,kParams);
				type_cn = '商家';
				url = '/public/xml.aspx?action=Showcompany';
				btype = 'company';
			}
			else if ('全景' == me.desName)
			{
				if('360' == flg) kParams = SFUtil.objMerge(homeParams,kParams);
				type_cn = '全景';
				url = '/public/xml.aspx?action=show360';
				btype = '360';
			}
			else
			{
				kParams.city = searchcondition['cityname'];
				kParams.ks = 1;
			}
			var keyPointUrl =  url;
			
			var titleword = (SFUtil.getStrlen(keyword) > 4) ? SFUtil.subStrcn(keyword,4)+'.' : keyword;
			me.titleText = '<div onclick="SFMap.searchKeyword(0,\'house\',\''+keyword+'\')" class="s4">名为<strong>'+titleword
					+'</strong>的'+type_cn+'</div><div onclick="SFMap.searchKeyword(0,\'key\',\''+keyword+'\')" class="s5"><strong>'+titleword+'</strong>附近的'+type_cn+'</div>';
			if('house' == flg)
			{
				me.kwHouse = true;
				SFMap.keepkw = false;
				var completeFunction = kHouseOnComplete;
				kParams.cname = searchcondition['cityname'];
				kParams.page = page;
			}
			else
			{
				me.kwHouse = false;
				me.keepkw = true;
				kParams.city = searchcondition['cityname'];
				kParams.btype = btype;
				me.titleText = '<div onclick="SFMap.searchKeyword(0,\'house\',\''+keyword+'\')" class="s5">名为<strong>'+titleword
					+'</strong>的'+type_cn+'</div><div onclick="SFMap.searchKeyword(0,\'key\',\''+keyword+'\')" class="s4"><strong>'+titleword+'</strong>附近的'+type_cn+'</div>';
				var completeFunction = kOnComplete;
			}
			
			var kXhr = new SFXHR(keyPointUrl, kMethod, kParams, completeFunction, kOnFailure, me.onLoading);
			return;
		}
		else
		{
			alert('请输入关键字');
		}
	},
	gotosearch:function(page)
	{
		var me = this;
		var page = page || 0;
		page = parseInt(page);
		if(me.keepkw)
		{
			me.searchResult(page,1);
		}
		else if(me.kwHouse)
		{
			me.searchKeyword(page);
		}
		else
		{
			me.searchResult(page);
		}
	},
	//执行搜索
	searchResult:function(page,keepKeyword,keepSort)
	{
		var me = this;
		var page = page || 0;
		var inputKeyword = $id('keyword');
		var keyword = inputKeyword.value;
		me.kwHouse = false;
		var keepKeyword = (me.keepkw && keepKeyword && ('' != keyword) && (keyword != inputKeyword.defaultValue));
		me.keepkw = keepKeyword;
		me.isDragend = true;
		SFUI.hideId('jczbresult');
		SFUI.showPeer('rightmenu1');

		var searchBounds = this.map.gethdBounds();
		var params = {'city':city,'cname':searchcondition['cityname'],'page':page,'output':'json','random':Math.random()};
		var type_cn = '楼盘';
		if ('装饰公司' == me.desName)
		{
			type_cn = '公司';
			var url =  'public/xml.aspx?action=showzx';
			params.cid = zssearch.cid;
			if(zssearch.dealerid > 0 && me.firstLoad) params.dealerid = zssearch.dealerid;
			params.dearlertype = 2;
			if(keepKeyword)
			{
				me.setDragSearch(false);
			}
			else
			{
				var district = $id('district').value;
				var len = (district.indexOf(',') > 0) ? district.indexOf(',') : district.length;
				params.district = district.substring(0,len);
				params.did = district.substring(len+1);
			}
			params = SFUtil.objMerge(searchBounds,params);
		}
		else if ('商家' == me.desName)
		{
			type_cn = '商家';
			var url =  '/public/xml.aspx?action=showcompany';
			if(keepKeyword)
			{
				me.setDragSearch(false);
			}
			else if($id('subway').value)// && SFMap.map.viewAuto)
			{
				params.subway = $id('subway').value;
			}
			var district = $id('district').value;
			var len = (district.indexOf(',') > 0) ? district.indexOf(',') : district.length;
			params.district = district.substring(0,len);
			params.did = district.substring(len+1);
			params = SFUtil.objMerge(searchBounds,params);
		}
		else if ('全景' == me.desName)
		{
			type_cn = '全景';
			var url =  '/public/xml.aspx?action=show360';
			if(keepKeyword)
			{
				me.setDragSearch(false);
			}
			var purposes = $id('purposes').value;
			if(''!= purposes && purposes.indexOf('不限') < 0)
			{
				var temppurp = purposes.split(",");
				params.purposes = temppurp[1];
			}
			params = SFUtil.objMerge(searchBounds,params);
		}
		else
		{
			var url =  '/public/xml.aspx?action=showbuild';
			
			if(searchcondition.newcode && me.firstLoad)
			{
				params.newcode = searchcondition.newcode;
			}
			var checkboxs = {sell_pre:1,sell_now:0,sell_out:2};//,rent_sell:4};
			var sale_arr = [];
			for(var i in checkboxs)
			{
				if($id(i) && $id(i).checked) sale_arr.push(checkboxs[i]);
			}
			var sale_len = 5;
			if(!$id('rent_now')) sale_len = 3;
			if(sale_len == 5 && (($id('sell_now') && $id('sell_now').checked) || ($id('rent_now') && $id('rent_now').checked)))
			{
				sale_arr.push(4);
			}
			var sale = (sale_arr.length == sale_len) ? '' : sale_arr.join(',');
			if (!keepKeyword)
			{
				if (sale_arr.length > 0) {
					var purposes = $id('purposes').value;
					if(''!= purposes && purposes.indexOf('不限') < 0)
					{
						var temppurp = purposes.split(",");
						params.purposes = temppurp[1];
					}
					params.price = $id('price').value;
					params.opentime = $id('opentime').value;
					params.sale = sale;
					var district = $id('district').value;
					var len = (district.indexOf(',') > 0) ? district.indexOf(',') : district.length;
					params.districts = district.substring(0, len);
					params.params = $id('area').value;
					params.round = $id('round').value;
					params.subway = escape($id('subway').value);
				}
				else {
					alert('请至少选择一种销售状态进行搜索');
					return false;
				}
			}
			else {
				$id('lock').checked = true;

				if(sale_arr.length < 1)
				{
					alert('请至少选择一种销售状态进行搜索');
					return false;
				}
				params.ks = keyword;
				params.sale = sale;
				//params.keyword = keyword;
			}
			//判断一下是否要保留排序
			//if(!keepSort && 0 == page) $id('sort').value = '';
			var sort = $id('sort').value;
			params.sort = sort;
			//没有环线或轨道条件时，再传递当前地图范围坐标的参数；GET 传参数时轨道和环线不加范围，但是区县和商圈还要加范围
			//if(!((params.round || params.subway) && SFMap.map.viewAuto) && (!me.firstLoad || (''==searchcondition.round && ''==searchcondition.subwayname))) {
			me.autoView = !me.firstLoad && !params.districts && !params.round && !params.subway && !keepKeyword && me.autoView;
			if(!me.autoView && !(params.round && SFMap.map.viewAuto) && (!me.firstLoad || (''==searchcondition.round && ''==searchcondition.subwayname))) {
				params = SFUtil.objMerge(searchBounds,params);
				SFMap.map.setViewAuto(false);
			}
			if(me.autoView)
			{
				me.toggleDrag($id('lock'));
				me.autoView = false;
				me.map.setCenter(cityy,cityx,mapsize);
				if(!me.dragSearch) me.searchResult();
				return;
			}
		}
		var method = 'post';
		var titleword = '';
		var words = '<li>缩放地图。</li><li>重新选定区域。</li><li>尝试输入关键字。</li>';
		if(me.keepkw)
		{
			titleword = (SFUtil.getStrlen(keyword) > 4) ? SFUtil.subStrcn(keyword,4)+'.' : keyword;
			me.titleText = '<div onclick="SFMap.searchKeyword(0,\'house\',\''+keyword+'\')" class="s5">名为<strong>'+titleword
				+'</strong>的'+type_cn+'</div><div onclick="SFMap.searchKeyword(0,\'key\',\''+keyword+'\')" class="s4"><strong>'+titleword+'</strong>附近的'+type_cn+'</div>';
			words = '<li>选定区域。</li><li>尝试不同关键字。</li>';
		}
		else if('undefined' != typeof params.params && params.params.length > 0)
		{
			titleword = (SFUtil.getStrlen(params.params) > 12) ? SFUtil.subStrcn(params.params,12)+'.' : params.params;
			me.titleText = '<div class="s1"></div><div class="s2"><strong>'+titleword+'</strong>附近的'+type_cn+'</div><div class="s3"></div>';
		}
		else
		{
			me.titleText = '<div class="s1"></div><div class="s2">该区域的'+type_cn+'</div><div class="s3"></div>';
		}

		var onComplete = function(origRequest)
		{
			SFUI.showId('map_total');
			SFUI.hideId('map_loading');
			try
			{
				var json = origRequest.responseText;
				var result = eval('(' + json + ')');
				var status = result.status;
			}
			catch(e)
			{
				alert('系统错误，请重试！');
				return;
			}

			//把清除坐标放到离重新显示结果最近的地方
			me.markerList = {};
			me.map.clearMarkers();
			if($id('subway') && '' == $id('subway').value)
			{
				me.map.clearOverlays();
			}

			result.words = words;
			result.title = me.titleText;

			if(0 == status)
			{
				var allnum = 0;
				result.allnum = 0;
			}
			else
			{
				var allnum = result.allnum;
			}
			//把对数据的处理放到这里来
			if(allnum > 0)
			{
				if(result.hits.hit.newCode) result.hits.hit = [result.hits.hit];
				var hits = result.hits.hit;
				//var hits = result.hits;
				var metaMarkers = me.getMetaMarkers(hits);
				me.showResult(metaMarkers);
				result.hits.hit = metaMarkers;
			}
			if(me.keyPointMarker)
			{
				me.map.addKeyMarker(me.keyPointMarker);
				me.keyPointMarker = null;
			}

			me.showList(result);

			//搜索完之后加上跳转到驾车或者周边的动作
			if(!me.firstLoad)
			{
				return true;
			}
			me.firstLoad = false;
			//listtype 和 searchcondition.listtype用的是同一个值
			if(!listtype || (!searchcondition.newcode && !zssearch.dealerid))
			{
				return true;
			}
			var infoId = searchcondition.newcode || zssearch.dealerid
			var info = SFMap.markerList[infoId];
			if(!info)
			{
				alert('无法获得' + me.desName + '的位置');
				return true;
			}
			if('jc' == listtype)
			{
				if('' != searchcondition.drivertype && 'end' != searchcondition.drivertype)
				{
					SearchOther.filltempdrive(info.title, info.newCode, 's');
					$id('tempdriverend').value = searchcondition.driverpoint;
				}
				else
				{
					SearchOther.filltempdrive(info.title, info.newCode);
					$id('tempdriverstart').value = searchcondition.driverpoint;
				}
			}
			else
			{
				SearchOther.filltempsearch(info.title,info.newCode);
				var searchName = searchcondition.searchname || '';
				if (searchName)
				{
					$id('tempneartype').value = searchName;
					SearchOther.gotosearchnear();
				}
			}
		};
		var onFailure = function()
		{
			alert('系统错误！');
		};
		//window.open(url);
		var xhr = new SFXHR(url, method, params, onComplete, onFailure, me.onLoading);
	},
	onLoading:function()
	{
		SFUI.hideId('map_total');
		SFUI.showId('map_loading');
		var titleText = SFMap.titleText ? SFMap.titleText : '该区域的楼盘';
		$id('tab_div0').innerHTML = '<div class="searchinfobt">'+titleText+'</div><div class="inforightnr">'+
			'<table width="80%" cellspacing="0" cellpadding="0" border="0" align="center"><tr><td style="padding: 20px 0pt;"><img width="18" height="18" align="absmiddle" src="'+
			imgPath+'load_18x18.gif" alt="">&nbsp;&nbsp;正在搜索，请稍候...</td></tr></table></div>';
	},
	info2url:
	{
		picAddress:function(info)
		{
			var pic = info.picAddress;
			return pic;
		},
		houseImg:function(info)
		{
			return info.PhotoUrl;
		},
		activUrl:function(info)
		{
			return info.PlainUrl;
		},
		detailUrl:function(info)
		{
			return info.BuildUrl;
		}
	},
	getMetaMarkers:function(hits)
	{
		var me = this;
		var metaMarkers = [];
		if(!hits) return metaMarkers;
		var cookieStr = SFUtil.getCookie(me.cookieName);
		if ('装饰公司' == me.desName)
		{
			for(var i=0; i<hits.length; i++)
			{
				var info = hits[i];
				if('' == info.surl) info.surl = 'javascript:alert(\'无此店铺详情\')';
				if('' == info.lurl) info.lurl = '';
				if('' == info.linkman) info.linkman = '暂无';
				if('' == info.phone) info.phone = '暂无';
				if('' == info.add) info.add = '暂无';
				info.title_s = info.title;
				if('' == info.title)
				{
					info.title = '暂无';
					info.title_s = '暂无';
				}
				else
				{
					var strlen = SFUtil.getStrlen(info.title);
					if(strlen > 36) info.title_s = SFUtil.subStrcn(info.title,36);
				}
				//是否已收藏
				if (cookieStr.indexOf(info.newCode) > -1 )
				{
					info.fav = '<span style="color:#999">[已收藏]</span>';
				}
				else
				{
					info.fav = '[<a href="javascript:;" onclick="SFMap.addFavorite(\'' + info.newCode + '\',this);//Clickstat.optClickHandler(\'list\',\'addfavorite\',\''+info.newCode+'\',\''+info.title+'\');">收藏</a>]';
				}
				me.markerList[info.newCode] = info;
				metaMarkers.push(info);
			}
		}
		else if ('商家' == me.desName)
		{
			for(var i=0; i<hits.length; i++)
			{
				var info = hits[i];
				info.surl = '';
				if('' == info.phone) info.phone = '暂无';
				if('' == info.add) info.add = '暂无';
				info.title_s = info.title;
				info.price_type = '电话：';
				if('' == info.title)
				{
					info.title = '暂无';
					info.title_s = '暂无';
				}
				else
				{
					var strlen = SFUtil.getStrlen(info.title);
					if(strlen > 36) info.title_s = SFUtil.subStrcn(info.title,36);
				}
				//是否已收藏
				if (cookieStr.indexOf(info.newCode) > -1 )
				{
					info.fav = '<span style="color:#999">[已收藏]</span>';
				}
				else
				{
					info.fav = '[<a href="javascript:;" onclick="SFMap.addFavorite(\'' + info.newCode + '\',this);//Clickstat.optClickHandler(\'list\',\'addfavorite\',\''+info.newCode+'\',\''+info.title+'\');">收藏</a>]';
				}
				me.markerList[info.newCode] = info;
				metaMarkers.push(info);
			}
		}
		else if ('全景' == me.desName)
		{
			for(var i=0; i<hits.length; i++)
			{
				var info = hits[i];
				info.surl = '';
				if('' == info.phone) info.phone = '暂无';
				if('' == info.add) info.add = '暂无';
				info.title_s = info.title;
				info.price_type = '电话：';
				if('' == info.title)
				{
					info.title = '暂无';
					info.title_s = '暂无';
				}
				else
				{
					var strlen = SFUtil.getStrlen(info.title);
					if(strlen > 36) info.title_s = SFUtil.subStrcn(info.title,36);
				}
				info.detailUrl = me.info2url.detailUrl(info);
				//是否已收藏
				if (cookieStr.indexOf(info.newCode) > -1 )
				{
					info.fav = '<span style="color:#999">[已收藏]</span>';
				}
				else
				{
					info.fav = '[<a href="javascript:;" onclick="SFMap.addFavorite(\'' + info.newCode + '\',this);//Clickstat.optClickHandler(\'list\',\'addfavorite\',\''+info.newCode+'\',\''+info.title+'\');">收藏</a>]';
				}
				me.markerList[info.newCode] = info;
				metaMarkers.push(info);
			}
		}
		else
		{
			for(var i=0; i<hits.length; i++)
			{
				var info = hits[i];
				var scArr = {'0':'待售', '1':'在售','2':'售磬'};
				info.saling_cn = '';
				if('undefined' != typeof info.saling && 'undefined' != typeof scArr[info.saling])
				{
					info.saling_cn = '（'+scArr[info.saling]+'）';
				}
				info.picAddress = me.info2url.picAddress(info);
				if('' != info.bbs) info.bbs = '[<a href="'+info.bbs+'" target="_blank" >业主论坛</a>]';
				info.detailUrl = me.info2url.detailUrl(info);
				info.houseImg = me.info2url.houseImg(info);
				info.imgTitle = '楼盘相册' ;
				info.activUrl = me.info2url.activUrl(info);
				if('' == info.tel) info.tel = '暂无';
				if('' == info.purpose) info.purpose = '暂无';
				if('' == info.startTime) info.startTime = '暂无';
				if('' == info.developer) info.developer = '暂无';
				if('' == info.address) info.address = '暂无';
				if('' == info.price_type) info.price_type = '均价：';
				if('' == info.price_num || '' == info.price_unit)
				{
					info.price_num = '';
					info.price_unit = '暂无';
					info.price_d = '';
				}
				else
				{
					info.price_d = '<li class="link1">'+info.price_type+' <span>'+info.price_num+'</span>'+info.price_unit+'</li>';
				}
				info.title_s = info.title;
				if('' == info.title)
				{
					info.title = '暂无';
					info.title_s = '暂无';
				}
				else
				{
					var strlen = SFUtil.getStrlen(info.title);
					if(strlen > 36) info.title_s = SFUtil.subStrcn(info.title,36);
				}
				//是否已收藏
				if (cookieStr.indexOf(info.newCode) > -1 )
				{
					info.fav = '<span style="color:#999">[已收藏]</span>';
				}
				else
				{
					info.fav = '[<a href="javascript:;" onclick="SFMap.addFavorite(\'' + info.newCode + '\',this);//Clickstat.optClickHandler(\'list\',\'addfavorite\',\''+info.newCode+'\',\''+info.title+'\');">收藏</a>]';
				}
				me.markerList[info.newCode] = info;
				if(me.keyPointMarker && me.keyPointMarker.name == info.title)
				{
					metaMarkers.unshift(info);
				}
				else
				{
					metaMarkers.push(info);
				}
			}
		}
		return metaMarkers;
	},
	showResult:function(metaMarkers)
	{
		//alert('showResult');
		var isDragendSave = this.isDragend;
		this.isDragend = false;
		this.map.drawMarkers(metaMarkers);
		//alert(this.isDragend);
		this.isDragend = isDragendSave;
	},
	showList:function(dataAll)
	{
		//alert('showList');
		var me = this;
		var allCount = parseInt(dataAll.allnum);
		if (dataAll.status != 0 && allCount > 0) {
			var dataList = dataAll.hits.hit;
			//var dataList = dataAll.hits;
			var pagenow = parseInt(dataAll.pagenow);
			var pagemax = parseInt(dataAll.maxpage);
			//alert('showList');
			var result = {};
			result.title = dataAll.title;
			result.allcount = '共<span>' + allCount + '</span>条结果';
			if ('楼盘' != me.desName)
			{
				result.sortStr = '';
			}
			else
			{
				var sortVal = $id('sort').value;
				var sortVS = {pa:'价格升序', pd:'价格降序'};
				if(sortVS[sortVal])
				{
					result.sortStr = sortVS[sortVal];
				}
				else
				{
					result.sortStr = '排序方式';
				}
			}
			var view = '';
			var templateList = $id('template_list').value;
			var templateResult = $id('template_result').value;
			for(var i in dataList)
			{
				var v = dataList[i];
				view += SFUI.templateFetch(templateList, v);
			}
			//alert(view);
			result.list = view;
			var pager = '';
			if(pagenow > 2)
			{
				pager += '<span>[<a href="javascript:;" onclick="SFMap.gotosearch('+(pagenow-1)+');">上一页</a>]</span>';
			}
			if(pagenow > 2 && pagemax > 3)
			{
				pager += '<span>[<a href="javascript:;" onclick="SFMap.gotosearch(0);">1</a>]</span>...';
				if(pagenow==pagemax) pager += '<span>[<a href="javascript:;" onclick="SFMap.gotosearch(\''+(pagenow-1)+'\');">'+(pagenow-1)+'</a>]</span>'+pagenow;
				else pager += pagenow+' <span>[<a href="javascript:;" onclick="SFMap.gotosearch('+(pagenow+1)+');">'+(pagenow+1)+'</a>]</span>';
			}
			else if(pagemax > 1)
			{
				var end = (pagemax > 3) ? 3 : pagemax;
				for(i=1; i<=end; i++)
				{
					if(i==pagenow) pager += pagenow;
					else pager += '<span>[<a href="javascript:;" onclick="SFMap.gotosearch('+(i)+');">'+i+'</a>]</span>';
				}
			}
			if(pagenow < pagemax)
			{
				pager += '<span>[<a href="javascript:;" onclick="SFMap.gotosearch('+(pagenow+1)+');">下一页</a>]</span>';
			}
			pager += ' 共'+pagemax+'页';
			result.pager = pager;
			var resultView = SFUI.templateFetch(templateResult, result);
			$id('tab_div0').innerHTML = resultView;
			var showName = (me.desName.length > 2) ? '商家' : me.desName;
			var tipTotal = '在这里找到了<font>'+allCount+'</font>个'+showName;
			$id('map_total').innerHTML = tipTotal;
			var cookieStr = SFUtil.getCookie('com_s');
			if (allCount > 50 ) {  //&& !cookieStr
				var fdtip = {};
				fdtip.words = '您可以选择“区域”快速定位';
				fdtip.iknow = 'SFMapUI.iKnow(\'com_s\');';
				var templatefdtip = $id('template_fdtips').value;
				var fdtipValue = SFUI.templateFetch(templatefdtip, fdtip);
				var fdtipDiv = $id('fdtip');
				fdtipDiv.innerHTML = fdtipValue;
				var pos = SFUI.getAbsPoint($id('district_a'));
				fdtipDiv.style.display = 'block';
				fdtipDiv.style.top = (pos.y-fdtipDiv.offsetHeight)+'px';
				fdtipDiv.style.left = (pos.x+15)+'px';
			}
			//filePath 变量定义在 index_header.html 里
			//tipTotal += '&nbsp;&nbsp;<a href="javascript:;" onclick="SFUI.hideId(\'map_total\');"><img src="'+imgPath+'img/icon_title10.gif" alt="关闭" /></a>';
			SFMapUI.autoResize();
		}
		else
		{
			var showName = (me.desName.length > 2) ? '商家' : me.desName;
			$id('map_total').innerHTML = '在这里找到了<font>0</font>个'+showName;
			var templateResult = $id('template_notfound').value;
			var resultView = SFUI.templateFetch(templateResult, dataAll);
			$id('tab_div0').innerHTML = resultView;
		}
	},
	cookieName:'map_fav',
	cookieMax: 10,
	cookieDays: 30,
	//如果记全部详情, 4 个楼盘就接近 4KB 了,只能记主要信息了
	addFavorite:function(newCode,item)
	{
		var me = this;
		//var mNode = $id('tip'+newCode);
		var detail = this.markerList[newCode];
		//if(mNode)
		if(detail)
		{
			//var detail = mNode.provalue;
			var info = {'newCode':detail.newCode, 'title':detail.title};
			//alert(iterate(info ));
			var cookieStr = SFUtil.getCookie(this.cookieName);

			if (cookieStr.indexOf(SFUtil.obj2str(info)) > -1 ) {
				alert('您已收藏此' + me.desName + '!');
			}
			else {
				var cookieValue = ('' == cookieStr) ? [] : eval(cookieStr);
				var favNum = cookieValue.length;
				//alert(favNum );
				if (favNum >= this.cookieMax) {
					alert('您最多可以收藏'+this.cookieMax+'个' + me.desName + '！您可以在收藏列表中删除不想再收藏的' + me.desName + '。');
				}
				else {
					cookieValue.push(info);
					cookieStr = SFUtil.obj2str(cookieValue);
					SFUtil.setCookie(this.cookieName,cookieStr, this.cookieDays);
					if(item)
					{
						var itemParent = item.parentNode;
						itemParent.innerHTML = '<span style="color:#999">[已收藏]</span>';
					}
				}
			}
		}
		else
		{
			alert('无法收藏此' + me.desName + '！');
		}
	},
	delFavorite:function(newCode, aLink)
	{
		if(!newCode) return;
		//先删除节点
		var barFav = aLink.parentNode.parentNode;
		var listFav = barFav.parentNode;
		listFav.removeChild(barFav);
		//再隐藏标点
		this.map.hideMarker(newCode);

		//再删除 cookie
		var cookieStr = SFUtil.getCookie(this.cookieName);

		var cookieValue = ('' == cookieStr) ? [] : eval(cookieStr);
		var cookieNow = [];
		for(var i=0; i<cookieValue.length; i++)
		{
			if(newCode == cookieValue[i].newCode) {
				continue;
			}
			else {
				cookieNow.push(cookieValue[i]);
			}
		}
		cookieStr = SFUtil.obj2str(cookieNow);
		SFUtil.setCookie(this.cookieName,cookieStr, this.setCookie);
	},
	clearFavorite:function()
	{
		if(!confirm('确定要清除收藏？'))
		{
			return;
		}
		var container = $id('map_fav');
		var checkboxes = container.getElementsByTagName('input');
		//alert(checkboxes.length);
		var newCode = '';
		for (var i=0; i<checkboxes.length;i++ ) {
			newCode = checkboxes[i].value;
			//再隐藏标点
			this.map.hideMarker(newCode);
		}
		container.innerHTML = '您还没有收藏';
		SFUtil.setCookie(this.cookieName,'',0);
	},
	//列表全部收藏
	showFavorite:function()
	{
		var me = this;
		me.map.clearMarkers();
		me.map.clearOverlays();
		me.isDragend = false;
		var cookieStr = SFUtil.getCookie(this.cookieName);
		var cookieValue = ('' == cookieStr) ? [] : eval(cookieStr);
		var favNum = cookieValue.length;
		//alert(favNum );
		var view = '';
		if (0 == favNum) {
			view = '';
		}
		else {
			var template = $id('template_fav').value;
			var idList = [];
			for (var i=0;i < favNum; i++) {
				//alert(i + cookieValue[i].title);
				view += SFUI.templateFetch(template, cookieValue[i]);
				idList.push(cookieValue[i].newCode);
			}
			//alert(idList.join());
			//执行搜索
			//var searchBounds = this.map.gethdBounds();
			var params = {'cname':searchcondition['cityname'],'newcode_list':idList.join(),'output':'json','random':Math.random()};
			//params = SFUtil.objMerge(searchBounds,params);
			
			var url = '/public/xml.aspx?action=ShowBuild';
			if ('装饰公司' == me.desName)
			{
				params.cid = zssearch.cid;
				url = filePath + 'aa.aspx';
			}
			else if ('商家' == me.desName)
			{
				url =  '/public/xml.aspx?action=showcompany';
			}
			else if ('全景' == me.desName)
			{
				url =  '/public/xml.aspx?action=show360';
			}
			var method = 'post';
			var me = this;
			var onComplete = function(origRequest)
			{
				var json = origRequest.responseText;
				try
				{
					var result = eval('(' + json + ')');
					var status = result.status;
					me.markerList = {};
				}
				catch(e)
				{
					alert('系统错误，请重试！');
					return;
				}
				if(0 == status)
				{
					var allnum = 0;
				}
				else
				{
					var allnum = result.allnum;
				}
				//处理数据
				if(allnum > 0)
				{
					if(result.hits.hit.newCode) result.hits.hit = [result.hits.hit];
					var hits = result.hits.hit;
					var metaMarkers = me.getMetaMarkers(hits);
					me.showResult(metaMarkers);
				}
			};
			var onFailure = function()
			{
				alert('系统错误，请稍后再试。');
			};
			var xhr = new SFXHR(url, method, params, onComplete, onFailure);
		}
		//$id('map_fav').innerHTML = (''==view) ? '您还没有收藏' : '<table>' + view + '</table>';
		if(''==view)
		{
			SFUI.hideId('haveFav');
			SFUI.showId('noFav');
		}
		else
		{
			SFUI.hideId('noFav');
			if($id('map_fav')) $id('map_fav').innerHTML = '<table>' + view + '</table>';
			SFUI.showId('haveFav');
		}
	},
	//切换某条收藏的显示或隐藏
	toggleFav:function(checkbox) {
		var newCode = checkbox.value;
		var detail = this.markerList[newCode];
		var nodeId = 'tip'+newCode;
		var mNode = $id(nodeId);
		if(mNode)
		{
			var domMark = mNode.parentNode;
			var nodeFav = $id('map_fav'+newCode);
			var show = '';
			var titleLink = '';
			//var detail = mNode.provalue;
			//选中时链接可点，未选中时链接变普通文本
			if (checkbox.checked) {
				show = 'block';
				//SFUtil.eventAdd(nodeFav, 'click', function() { alert(nodeFav );SFMap.openTipById(newCode);});尝试用事件处理未果，还是用 innerHTMl 吧
				titleLink = '<a href="javascript:;" onclick="SFMap.openTipById('+newCode+');">'+detail.title+'</a>';
			}
			else {
				show = 'none';
				titleLink = detail.title;
				//SFUtil.eventAdd(nodeFav, 'click', function() { alert(nodeFav ); return false;});
			}
			domMark.style.display = show;
			nodeFav.innerHTML = titleLink;
		}
	},
	condInit:function()
	{
		if (searchcondition.purpose){
			var val = '';
			for (var i=0;i<Purposes.length;i++)
			{
				if (Purposes[i].name == searchcondition.purpose)
				{
					val = Purposes[i].name +','+Purposes[i].index;
					break;
				}
			}
			//alert(val);
			SFUI.setInputA('purposes',val,searchcondition.purpose);
		}
		if (searchcondition.price){
			var pricecondition= '';
			if(searchcondition.price.indexOf('以下')>-1)
			{
				pricecondition = "[,"+searchcondition.price.substr(0,searchcondition.price.indexOf('以下'))+"]";
			}
			else if(searchcondition.price.indexOf('以上')>-1)
			{
				pricecondition = "["+searchcondition.price.substr(0,searchcondition.price.indexOf('以上'))+",]";
			}
			else
			{
				var tempprice = searchcondition.price.split("-");
				pricecondition = "["+tempprice[0]+","+tempprice[1]+"]";
			}
			//alert(val);
			SFUI.setInputA('price',pricecondition,searchcondition.price);
		}
		if (searchcondition.district){
			var val = '';
			for (var i=0;i<Districts.length;i++)
			{
				if (Districts[i].name == searchcondition.district)
				{
					val = Districts[i].name +','+Districts[i].index;
					break;
				}
			}
			if (searchcondition.area){
				SFUI.setA('district_a',searchcondition.area);
				SFUI.setInput('district',val);
				SFUI.setInput('area',searchcondition.area);
				SFMap.getCenter(searchcondition.district,searchcondition.area);
			}
			else{
				SFUI.setInputA('district',val,searchcondition.district);
				SFMap.getCenter(searchcondition.district);
			}
		}
		if (searchcondition.round){
			SFUI.setInputA("round",searchcondition.round,searchcondition.round);
		}
		if (!searchcondition.district && !searchcondition.round && searchcondition.subwayname){
			SFUI.setInputA("subway",searchcondition.subwayname,searchcondition.subwayname);
		}
		if (searchcondition.keyword){
			SFUI.setInput('keyword',searchcondition.keyword);
			SFMap.searchKeyword();
		}
	}
};

(function() {
        var ie = ! -[1, ];
        var wk = /webkit\/(\d+)/i.test(navigator.userAgent) && (RegExp.$1 < 525);
        var fn = [];
        var run = function() { for (var i = 0; i < fn.length; i++) fn[i](); };
        var d = document;
        d.ready = function(f) {
            if (!ie && !wk && d.addEventListener)
                return d.addEventListener('DOMContentLoaded', f, false);
            if (fn.push(f) > 1) return;
            if (ie)
                (function() {
                    if (document.readyState=="complete") run();
                    else document.onreadystatechange = function(){ if(document.readyState=="complete") run();}
                })();
            else if (wk)
                var t = setInterval(function() {
                    if (/^(loaded|complete)$/.test(d.readyState))
                        clearInterval(t), run();
                }, 0);
        };
    })();

//SFUtil.eventAdd(window, 'load', function(){
document.ready(function() {
	//把index_header.html里的放到这里来
	SFMap.condInit();
	SFMapUI.init();
	SFMap.init();
	SearchOther.init();
	var map = SFMap.map;
	//如果有 GET 传递来district和keyword两个参数，由 JS 程序在别处执行搜索，其他的在这里统一执行
	if (!searchcondition.keyword){
		SFMap.searchResult();
	}
	map.addEvent(map,'moveend',function(){
		SFMap.closeTip();
		SFUI.hideId('subway_station_tip');
		SFMap.toggleDrag($id('lock'));
		if(!SFMap.dragSearch || !SFMap.isDragend) return;
		if(null !== SFMap.mapDragTimeOut)
		{
			clearTimeout(SFMap.mapDragTimeOut);
		}
		SFMap.mapDragTimeOut = setTimeout(function(){SFMap.searchResult();},500);
	});
	map.addEvent(map,'click',function(){
		map.enableScrollWheel();
	});
	//map.hideMarker();
});

//关闭窗口时释放内存
SFUtil.eventAdd(window, 'unload', function(){GUnload();});