﻿/**
 * @author zen
 * Date:2009-8-25
 */


$(document).ready(function(){
	document.body.onclick = function(e){
		var e = e|| window.event;
		var obj = e.srcElement || e.target;
		countHint(obj);
	}
})




var Public={}
/*
* 
* Cookie 控制
*/
Public.Cookie = {};
Public.Cookie.Set = function(name, value, hours){
  var expire = "";
  if(hours != null){
    expire = new Date((new Date()).getTime() + hours * 3600000);
    expire = "; expires=" + expire.toGMTString();
  }else{
      expire = new Date((new Date()).getTime() + 24 * 365 * 3600000);
      expire = "; expires=" + expire.toGMTString();
  }
  document.cookie = name + "=" + escape(value) + expire;
}

Public.Cookie.Get = function(name){
  var cookieValue = "";
  var search = name + "=";
  if(document.cookie.length > 0){ 
    offset = document.cookie.indexOf(search);
    if (offset != -1){ 
      offset += search.length;
      end = document.cookie.indexOf(";", offset);
      if (end == -1) end = document.cookie.length;
      cookieValue = unescape(document.cookie.substring(offset, end))
    }
  }
  return cookieValue;
}


function addBookmark(title,url) {
    if (window.sidebar) {
        window.sidebar.addPanel(title, url,"");
    } else if( document.all ) {
        window.external.AddFavorite( url, title);
    } else if( window.opera && window.print ) {
        return true;
    }
}

function htmlspecialchars(string,bl){
	var data = [];
	for(var i = 0 ;i <string.length;i++) {
		data.push( "&#"+string.charCodeAt(i)+";");
	} 
	if(bl != undefined){
		if(data.length <= bl){
			return data.join("");
		}else{
			return data.slice(0,bl).join("")+"..";
		}
	}else return data.join("");
}



	var paperContent = "";
	var paperCookieKey = "paper";
	
	var DisplayShowContent = function(){
		paperContent = Public.Cookie.Get(paperCookieKey);
		if(paperContent != ""){
			$("#addpaper").hide();
			$("#papercon").hide();
			var showContent = htmlspecialchars(paperContent).replace(/&#32;/g,"&nbsp;").replace(/&#10;/g,"<br/>");
			$("#js_paper_result_box").html(showContent).show();
		}
		else{
			$("#addpaper").show();
			$("#papercon").hide();
			$("#js_paper_result_box").hide();
		}
	}
	
	var DisplayEditContent = function(){
		paperContent = Public.Cookie.Get(paperCookieKey);
		$("#addpaper").hide();
		$("#js_paper_result_box").hide();
		$("#papercon").val(paperContent).show();
		document.getElementById("papercon").focus()
	}
	
	var SetPperContent = function(){
		paperContent = $("#papercon").val();
		Public.Cookie.Set(paperCookieKey,paperContent);
		DisplayShowContent();
	}
	
	$(document).ready(function(){
		DisplayShowContent();
		$("#addpaper,#js_paper_result_box").bind("click",function(){
			DisplayEditContent();
		});
		$("#papercon").bind("blur",function(){
			SetPperContent();
		});
	});


	var noteDateSource; /*数据源*/
	/*数据操作*/
	var GetNoteDate = function(){
		noteDateSource = null;
		var str = Public.Cookie.Get("notedata");
		if(str != ""){
			noteDateSource = str.split(',');
		}
		DisplayNoteList();
	}
	var SaveNoteDate = function(){
		Public.Cookie.Set("notedata",noteDateSource.join(","),30*24);
		GetNoteDate();
	}
	
	var tranNoteModel = function(obj){
		return obj.content + "[color:" + obj.color + "]" + "[del:" + obj.del + "]";
	}
	var getNoteModel = function(str){
		var reg = /(.*)\[color:(.*)\]\[del:(.*)\]/;
		var result = reg.exec(str);
		var obj;
		try{
			obj = {content: result[1],color: result[2],del:result[3]};
		}
		catch(e){
			obj = {};
		}
		return {content: result[1],color: result[2],del:result[3]};
	}

	/*显示数据*/
	var DisplayNoteList = function(){
		$("#js_note_edit_box").appendTo("#js_cache_note_edit_box");
		$("#js_note_add_box").appendTo("#js_cache_note_edit_box");
		var html = "";
		if(noteDateSource){
			for(var i = 0,len = noteDateSource.length; i < len; i++){
					var item = getNoteModel(noteDateSource[i]);
					var delstr = "";
					var checked = "";
					if(item.del == "1"){
						delstr = " del";
						checked = "checked";
					}
					var str = item.content;
					html += '<li rel="'+i+'" style="background-color:'+item.color+'">';
					html += '<div class="js_note_show_box '+delstr+'">';
					html += '<div class="ctrl"><a class="e">颜色</a> <a class="c">颜色</a> <a class="d">颜色</a></div>';
					html += '<input type="checkbox" '+checked+' />';
					html += '<label>'+htmlspecialchars(str,30)+'</label>';
					html += '</div>';
					html += '<div class="js_edit_box"></div>';
					html += '</li>';
			}
		}
		else{
			html = '<li class="js_note_none js_none_data"><em class="gray9">您还没有添加任何事项</em></li>';
		}
		html += '<li id="js_note_add_show_box" class="js_note_none hide"></li>';
		$("#js_note_data_source").html(html);
		NoteBindEvent();
	}
	
	var activeLi;
	var NoteBindEvent = function(){
		$("#js_note_data_source").find("li").not(".js_note_none").each(function(i){
			var li = $(this);
			li.find("input[type='checkbox']").each(function(i){
				$(this).bind("click",function(){
					var id = li.attr("rel");
					var model = getNoteModel(noteDateSource[Number(id)]);
					model.del = this.checked ? 1 : 0;
					noteDateSource[Number(id)] = tranNoteModel(model);
					SaveNoteDate();
					if(this.checked){
						$(this).parent().addClass("del");
					}
					else{
						$(this).parent().removeClass("del");
					}
				});
			});
			li.find("a.e").bind("click",function(){
				if(activeLi){
					activeLi.find(".js_note_show_box").show();
				}
				activeLi = li;
				li.find(".js_note_show_box").hide();
				li.find(".js_edit_box").show().append($("#js_note_edit_box"));
				var id = activeLi.attr("rel");
				var model = getNoteModel(noteDateSource[Number(id)]);
				$("#js_note_edit_textbox").val(model.content);
			});
			li.find("a.d").bind("click",function(){
				if(window.confirm("确认要删除待办事项吗？")){
					noteDateSource.splice(Number(li.attr("rel")),1);
					SaveNoteDate();
				}
			});
			li.find("a.c").bind("click",function(){
				var colorBox = $("#js_color_select_box");
				colorBox.show();
				colorBox.attr("rel",li.attr("rel"));
				document.getElementById("js_color_select_box").style.top =  $(this).offset().top -$("#note").offset().top + "px";
			}).bind("mouseout",function(){
				HideColorBox();
			});
		});
	}
	
	var HideColorBox = function(){
		$("#js_color_select_box").hide();
	}

	var ColorBoxHideState = true;
	var NoteLoadBind = function(){
		$("#js_note_add").bind("click",function(){
			var li = $("#js_note_add_show_box");
			li.removeClass("hide");
			$("#js_note_data_source").find(".js_none_data").hide();
			li.append($("#js_note_add_box"));
			document.getElementById("js_note_add_textbox").focus();
			$("#js_note_add_textbox").val("");
		});
		$("#js_note_add_box").find("a").bind("click",function(){
			if(!noteDateSource){
				$("#js_note_data_source").find(".js_none_data").show();
			}
			var li = $("#js_note_add_show_box");
			li.addClass("hide");
		});
		$("#js_note_add_btn").bind("click",function(){/*(增加)保存Note*/
			if(!noteDateSource){
				noteDateSource = [];
			}
			var v = $("#js_note_add_textbox").val();
			if(v == ""){
				alert("请输入内容！");
				document.getElementById("js_note_add_textbox").focus();
				return;
			}
			
				
			var str = tranNoteModel({content:v,color:"#FFFFFF",del:"0"});
			noteDateSource.push(str);
			SaveNoteDate();
			if(!noteDateSource){
				$("#js_note_data_source").find(".js_none_data").show();
			}
			$("#js_note_add_show_box").addClass("hide");
		});
		$("#js_color_select_box").find("a").each(function(i){	/*改变背景颜色*/
			$(this).bind("click",function(){
				var id = $("#js_color_select_box").attr("rel");
				var model = getNoteModel(noteDateSource[Number(id)]);
				model.color = $(this).html();
				noteDateSource[Number(id)] = tranNoteModel(model);
				$("#js_note_data_source").find("li[rel='"+id+"']").css({backgroundColor:$(this).html()});
				SaveNoteDate();
			});
		});
		$("#js_color_select_box").bind("mouseover",function(){
			$(this).show();
		});
		$("#js_color_select_box").bind("mouseout",function(){
			HideColorBox();
		});
		$("#js_note_edit_box").find("a").bind("click",function(){									   
			var ele = $(this).parent().parent();
			var li = ele.parent();
			li.find(".js_note_show_box").show();
			ele.addClass("hide");
		});
		$("#js_note_edit_btn").bind("click",function(){/*(修改)保存Note*/
			var id = activeLi.attr("rel");
			try{
				var v = $("#js_note_edit_textbox").val();
				if(v == ""){
					alert("请输入内容！");
					document.getElementById("js_note_edit_textbox").focus();
					return;
				}
				var md = getNoteModel(noteDateSource[id]);
				md.content = v;
				var str = tranNoteModel(md);
				noteDateSource[id] = str;
				SaveNoteDate();
			}
			catch(e){
				
			}
		});
	}
	
	NoteLoadBind();
	GetNoteDate();