function FixMinHeight(el){
	items = el.getElementsByTagName('dt');
	return items[0].offsetHeight;
}

fx.Height.prototype.toggle = function(){
	min_h = FixMinHeight(this.el);
	if(this.el.offsetHeight > min_h+5){
		this.custom(this.el.offsetHeight, min_h);
	}
	else this.custom(min_h, this.el.scrollHeight);
}

fx.Height.prototype.hide = function(){
	this.now = FixMinHeight(this.el);
	this.increase();
}

fx.Opacity.prototype.toggle = function() {
	if (this.now > FixMinHeight(this.el)-5) this.custom(1, 0);
	else this.custom(0, 1);
}

fx.Opacity.prototype.hide = function(){};

fx.Accordion.prototype.showThisHideOpen = function(toShow){
	this.elements.each(function(el, j){
		min_h = FixMinHeight(el)+5;
		if (el.offsetHeight > min_h && el != toShow) this.clearAndToggle(el, j);
		if (el == toShow && toShow.offsetHeight <= min_h) setTimeout(function(){this.clearAndToggle(toShow, j);}.bind(this), this.options.delay);
	}.bind(this));
}

if($('pd_more')){
	var contents = $c($('pd_more').getElementsByTagName('dl'));
	var toggles = $c($('pd_more').getElementsByTagName('dt'));
	if(contents && toggles){
		contents.each(function(item, i){
			if(item.document.getElementsByTagName('dd')){
				toggles[i].style.cursor='pointer';
			}
		});
		toggles.each(function(item, i){
			item.style.fontFamily = 'Tahoma, Arial, Helvetica, sans-serif';
		});
		var myAccordion = new fx.Accordion(
			toggles, contents, {opacity: true, duration: 300}
		);
		myAccordion.fxa.each(function(item, i){
			item.h.options.onComplete = '';
			item.o.options.onComplete = '';
		});
	}
}