Function.prototype.method = function(name, func) {
	if(!this.prototype[name]){
		this.prototype[name] = func;
	}
	return this;
}

$.addClass = function(elem, newClass){
	if(!elem) 
		return false;
	else if(!elem.className) {
		elem.className = newClass;
		return false; 
	}
	else {
		var ownClass = elem.className.split(" "), had = false;
		for(var i = 0; i < ownClass.length; i++){
			if(ownClass[i] === newClass){
				had = true;
				break;
			}
		}
		if(!had){
			elem.className += " " + newClass;
		}
		return had;
	}
};

$.removeClass = function(elem, oneClass){
	if(!elem || !elem.className) return false;
	var ownClass = elem.className.split(" "),
		had = false;
	for(var i = 0; i < ownClass.length; i++){
		if(ownClass[i] === oneClass){
			ownClass.splice(i, 1);
			had = true;
			break;
		}
	}
	if(had){
		elem.className = "";
		if(ownClass.length < 1){
			return had;
		}else if(ownClass.length == 1){
			elem.className = ownClass[0];
		}else if(ownClass.length >1){
			for(var i = 0; i < ownClass.length; i++){
				if(i == ownClass.length - 1){
					elem.className += ownClass[i];
				}else{
					elem.className += ownClass[i] + " ";
				}
			}
		}
	}	
	return had;	
};

$.addEvent = function(elem, eventName, handler){
	if(elem){
		if(elem.addEventListener){
			return elem.addEventListener(eventName, handler, false);
		}else if(elem.attachEvent){
			return elem.attachEvent("on" + eventName, handler);
		}else {
			elem["on" + eventName] = handler;
		}
	}
};

$.removeEvent = function(elem, eventName, handler){
	if(elem){
		if(elem.removeEventListener){
			return elem.removeEventListener(eventName, handler, false);
		}else if(elem.detachEvent){
			return elem.detachEvent("on" + eventName, handler);
		}else {
			elem["on" + eventName] = null;
		}
	}	
};

$.getEvent = function(event){
	return event ? event : window.event;
};

$.getTarget = function(event){
	return event.target || event.srcElement;
};

$.getRelatedTarget = function(event){
	return event.relatedTarget || event.toElement || event.fromElement || null;
};

$.contains = function(parent, cur){
	while(cur.parentNode){
		if(cur.parentNode === parent){
			return true;
		}
		cur = cur.parentNode;
	}
	return false;
};

$.preventDefault = function(event){
	if(event.preventDefault){
		event.preventDefault();
	}else{
		event.returnValue = false;
	}
};

$.stopPropagation = function(event){
	if(event.stopPropagation){
		event.stopPropagation();
	}else{
		event.cancleBubble = true;
	}
};

$.get_pos = function(elem){
	if(!elem) return false;
	var left = elem.offsetLeft,
		top = elem.offsetTop,
		current = elem.offsetParent;
	while(current !== null){
		left += current.offsetLeft;
		top += current.offsetTop;
		current = current.offsetParent;
	}
	return {"left": left, "top": top};
};

$.get_dir = function(elem, mouse_pos){
	if(!elem) return false;
	var pos = $.get_pos(elem),
		size = {"width": elem.offsetWidth, "height": elem.offsetHeight},
		dx = mouse_pos.x - pos.left - size.width/2,
		dy = (mouse_pos.y - pos.top - size.height/2)*-1,
		eve_tan = dy/dx,
		tan = size.height/size.width;
	if(dx != 0){
		if(eve_tan > tan*-1 && eve_tan < tan && dx < 0){
			return "left";
		}else if(eve_tan > tan*-1 && eve_tan < tan && dx > 0){
			return "right";
		}else if((eve_tan > tan || eve_tan < tan*-1) && dy > 0){
			return "top";
		}else if((eve_tan > tan || eve_tan < tan*-1) && dy <= 0){
			return "bottom";
		}
	}else if(dy > 0){
		return "top";
	}else {
		return "bottom";
	}
};

function params(o){ //Ҫ̨ĲתΪַԼ뵽url
	var arr = [];
	for(var i in o){
		arr.push(i + "=" + encodeURIComponent(o[i]));
	}
	return arr.join("&");
}

$.ajaxp = function(args){ //scriptڵ㣬̨jssrcڵЯҵĲϢ
	var script = document.createElement("script");
	script.type="text/javascript";
	script.src = args.url + "?" + params(args.params);
	document.body.appendChild(script);
	var time = setTimeout(args.params.callback + "()", 6000); //óʱʱ䣬ò׿Ը
	script.onload = function(){
		clearTimeout(time);
	};
};

$.show_tips = function(words, timeout) {
	var tips = $('.tips')[0] || (function() {
		var tips = document.createElement('div');
		tips.className = 'tips animated';
		return document.body.insertBefore(tips, document.body.firstChild);
	})();
	tips.innerHTML = words;
	$.removeClass(tips, 'hide');
	$.addClass(tips, 'show');
	setTimeout($.hide_tips, timeout + 1000);
};

$.hide_tips = function() {
	var tips = $('.tips')[0];
	$.removeClass(tips, 'show');
	$.addClass(tips, 'hide');
	setTimeout('$.removeClass($(".tips")[0], "hide")', 1000);
};
