<!--#include file="../Inc/Cls_Main.Asp"-->
<!--#include file="inc/Cls_Admin.Asp"-->
<!--#include file="inc/Cls_MapPath.Asp"-->
<!--#include file="Admin_Check.Asp"-->
<%
Dim Action
Action = Easp.Get("action:s")
Select Case Action
    Case "json"
        Call JsonList()
    Case Else
        Call JsonList()
End Select

Sub JsonList()
    Dim TempUpPath, ChannelId
    ChannelId = Easp.Get("ChannelId:n:0")
    TempUpPath = CmsUpLoadFile & ChannelId & "/"
    Dim rootPath, rootUrl, fileTypes
    Dim currentPath, currentUrl, currentDirPath, moveupDirPath
    Dim Path, order, dirName, fso, Folder, Dir, File, Result
    Dim fileExt, dirCount, fileCount, orderIndex, i, j
    Dim dirList(), fileList(), isDir, hasFile, filesize, isPhoto, filetype, filename, datetime
    rootPath = TempUpPath
    rootUrl = TempUpPath
    fileTypes = "gif,jpg,jpeg,png,bmp"
    currentPath = ""
    currentUrl = ""
    currentDirPath = ""
    moveupDirPath = ""
    '目录名
    dirName = Easp.Get("dir:s")
    If Not Easp.IsN(dirName) Then
        rootPath = rootPath & dirName & "/"
        rootUrl = rootUrl & dirName & "/"
        If Not Easp.Fso.IsFolder(rootPath) Then
            Easp.Fso.CreateFolder rootPath
        End If
    End If
    Set fso = Server.CreateObject(Easp.FsoName)
    '根据path参数，设置各路径和URL
    Path = Trim(Easp.Get("path"))
    If Easp.IsN(Path) Then
        currentPath = Easp.Fso.MapPath(rootPath) & "\"
        currentUrl = rootUrl
        currentDirPath = ""
        moveupDirPath = ""
    Else
        currentPath = Easp.Fso.MapPath(rootPath & Path) & "\"
        currentUrl = rootUrl & Path
        currentDirPath = Path
        moveupDirPath = RegexReplace(currentDirPath, "(.*?)[^\/]+\/$", "$1")
    End If

    Set Folder = fso.GetFolder(currentPath)

    '排序形式，name or size or type
    order = Trim(LCase(Easp.Get("order")))
    Select Case order
        Case "type" orderIndex = 4
        Case "size" orderIndex = 2
        Case Else orderIndex = 5
    End Select

    '不允许使用..移动到上一级目录
    If RegexIsMatch(Path, "\.\.") Then
        Easp.WE "访问是不允许的。"
    End If
    '最后一个字符不是/
    If Path <> "" And Not RegexIsMatch(Path, "\/$") Then
        Easp.WE "参数是不允许的。"
    End If
    '目录不存在或不是目录
    If Not Easp.Fso.IsFolder(currentPath) Then
        Easp.WE "目录不存在。"
    End If
    Easp.Use "json"
    Set Result = Easp.Json.New(0)
    '相对于根目录的上一级目录
    Result("moveup_dir_path") = moveupDirPath
    '相对于根目录的当前目录
    Result("current_dir_path") = currentDirPath
    '当前目录的URL
    Result("current_url") = currentUrl
    '文件数
    dirCount = Folder.SubFolders.Count
    fileCount = Folder.Files.Count
    Result("total_count") = dirCount + fileCount
    ReDim dirList(dirCount)
    i = 0
    For Each Dir in Folder.SubFolders
        isDir = True
        hasFile = (Dir.Files.Count > 0)
        filesize = 0
        isPhoto = False
        filetype = ""
        filename = Dir.Name
        datetime = Easp.DateTime(Dir.DateLastModified, "yy-mm-dd hh:ii:ss")
        dirList(i) = Array(isDir, hasFile, filesize, isPhoto, filetype, filename, datetime)
        i = i + 1
    Next
    ReDim fileList(fileCount)
    i = 0
    For Each File in Folder.Files
        fileExt = LCase(Mid(File.Name, InStrRev(File.Name, ".") + 1))
        isDir = False
        hasFile = False
        filesize = File.Size
        isPhoto = (InStr(LCase(fileTypes), fileExt) > 0)
        filetype = fileExt
        filename = File.Name
        datetime = Easp.DateTime(File.DateLastModified, "yy-mm-dd hh:ii:ss")
        fileList(i) = Array(isDir, hasFile, filesize, isPhoto, filetype, filename, datetime)
        i = i + 1
    Next

    '排序
    Dim minidx, temp
    For i = 0 To dirCount - 2
        minidx = i
        For j = i + 1 To dirCount - 1
            If (dirList(minidx)(5) > dirList(j)(5)) Then
                minidx = j
            End If
        Next
        If minidx <> i Then
            temp = dirList(minidx)
            dirList(minidx) = dirList(i)
            dirList(i) = temp
        End If
    Next
    For i = 0 To fileCount - 2
        minidx = i
        For j = i + 1 To fileCount - 1
            If (fileList(minidx)(orderIndex) > fileList(j)(orderIndex)) Then
                minidx = j
            End If
        Next
        If minidx <> i Then
            temp = fileList(minidx)
            fileList(minidx) = fileList(i)
            fileList(i) = temp
        End If
    Next

    Result("file_list") = Easp.Json.New(1)
    For i = 0 To dirCount - 1
        Result("file_list")(Null) = Easp.Json.New(0)
        Result("file_list")(Null)("is_dir") = dirList(i)(0)
        Result("file_list")(Null)("has_file") = dirList(i)(1)
        Result("file_list")(Null)("filesize") = dirList(i)(2)
        Result("file_list")(Null)("is_photo") = dirList(i)(3)
        Result("file_list")(Null)("filetype") = dirList(i)(4)
        Result("file_list")(Null)("filename") = dirList(i)(5)
        Result("file_list")(Null)("datetime") = dirList(i)(6)
    Next
    For i = 0 To fileCount - 1
        Result("file_list")(Null) = Easp.Json.New(0)
        Result("file_list")(Null)("is_dir") = fileList(i)(0)
        Result("file_list")(Null)("has_file") = fileList(i)(1)
        Result("file_list")(Null)("filesize") = fileList(i)(2)
        Result("file_list")(Null)("is_photo") = fileList(i)(3)
        Result("file_list")(Null)("filetype") = fileList(i)(4)
        Result("file_list")(Null)("filename") = fileList(i)(5)
        Result("file_list")(Null)("datetime") = fileList(i)(6)
    Next
    Easp.WE Result.jsString()
    Set Result = Nothing
End Sub

'自定义函数

Function RegexIsMatch(subject, Pattern)
    Dim reg
    Set reg = New RegExp
    reg.Global = True
    reg.MultiLine = True
    reg.Pattern = Pattern
    RegexIsMatch = reg.Test(subject)
End Function

Function RegexReplace(subject, Pattern, replacement)
    Dim reg
    Set reg = New RegExp
    reg.Global = True
    reg.MultiLine = True
    reg.Pattern = Pattern
    RegexReplace = reg.Replace(subject, replacement)
End Function
%>