<!--#include file="../../Inc/Cls_Main.Asp"-->
<!--#include file="../../Inc/Cms/Cms.Asp"-->
<!--#include file="../inc/Cls_Admin.Asp"-->
<!--#include file="../inc/Cls_MapPath.Asp"-->
<!--#include file="../Admin_Check.Asp"-->
<%
Server.ScriptTimeOut = 2147483647
'=============================================================================
Dim CmsAdmin
'=============================================================================
Set CmsAdmin = New Cls_Admin
CmsAdmin.SetAdminTitle = CmsSiteName & " > 生成Html管理"
CmsAdmin.SetBodyCssName = "mainbody"
CmsAdmin.SetAdminPath = CmsAdminMapPath
CmsAdmin.LoadHead()
'=============================================================================
Dim TemplateListName, TemplateViewName, SiteHtmlPath, CnTemplateIndexName
TemplateListName = "CnTemplateList"
TemplateViewName = "CnTemplateView"
SiteHtmlPath = ""
CnTemplateIndexName = "CnTemplateIndex"
'=============================================================================
Dim Action
'=============================================================================
Action = Easp.Get("action:s")
Select Case Action
    Case "index"
        Call CreateIndex()
    Case "map"
        Call CreateMap()
    Case "all"
        Call CreateAllHtml()
        '=====================================================================
    Case "infoindex"
        Call InfoIndex()
    Case "infolist"
        Call infolist()
    Case "info"
        Call InfoHtml()
    Case "infoall"
        Call InfoAllHtml()
        '=====================================================================
    Case "freetpl"
        Call CreateFreeTpl()
    Case "topic"
        Call CreateTopic()
End Select
CmsAdmin.LoadFooter()
Set Cms = Nothing
Set CmsAdmin = Nothing

Sub CreateAllHtml()
    CreateIndex()
    CreateMap()
    CreateFreeTpl()
    CreateTopic()
    InfoAllHtml()
    '=========================================================================
    ShowJsComplete "一键生成全站完毕!"
End Sub

'=========================================================================

Sub InfoAllHtml()
    InfoIndex()
    infolist()
    InfoHtml()
    ShowJsComplete "一键生成频道完毕!"
End Sub

'============================================================================= 生成首页
' 通用生成不带分页的函数
'<param name="PageId">页面ID</param>
'<param name="ChannelId">频道ID</param>
'<param name="TemplateFile">模板文件</param>
'<param name="ShowTitle">生成提示</param>
'<param name="CreateFile">生成文件</param>

Sub CreateHtml(ByVal PageId, ByVal ChannelId, ByVal TemplateFile, ByVal ShowTitle, ByVal CreateFile)
    Dim TempFilePath
    TempFilePath = CmsTemplates & CmsTempSkin & TemplateFile
    Easp.Use "fso"
    If Easp.Fso.IsFile(TempFilePath) Then
        Cms.Tpl.Path = CmsTemplates & CmsTempSkin
        Cms.Tpl.File = TemplateFile
        If Not Easp.IsN(PageId) Then
            Cms.Tpl.d("PageId") = PageId
        End If
        If ChannelId > 0 Then
            Cms.Tpl.d("ChannelId") = ChannelId
        End If
        Cms.Fun.Init()
        Cms.Tpl.SaveAs = CreateFile
        '==========================================================================
        ShowErrHtml ShowTitle &"：<a href="""& CreateFile &""" target=""_blank"">"& CreateFile &"</a>,生成成功"
    Else
        ShowErrHtml "生成"& ShowTitle &"失败,模版文件："& CmsFun.ShowColor(TempFilePath, "red") &",未找到"
    End If
End Sub

Sub CreateIndex()
    CreateHtml "PcIndex", 1, PcIndexTemplate, "电脑端网站首页", SiteWebFilePath & "index.html"
    If CmsIsCreateWap = 1 Then
        CreateHtml "MtIndex", 0, MtIndexTemplate, "手机端网站首页", WapSitePath & "index.html"
    End If
End Sub

'============================================================================= 生成地图

Sub CreateMap()
    CreateHtml "robots", 0, RobotsTemplate, "Robots.txt文件", SiteWebFilePath & "robots.txt"
    CreateHtml "PcSitemap", 0, PcSiteMapTemplate, "电脑端网站地图", SiteWebFilePath & "sitemap.html"
    If CmsIsCreateWap = 1 Then
        CreateHtml "MtSitemap", 0, MtSiteMapTemplate, "手机端网站地图", WapSitePath & "sitemap.html"
    End If
    CreateHtml "baidumap", 0, BaiduMapTemplate, "百度地图", SiteWebFilePath & "baidu.xml"
    CreateHtml "googlemap", 0, GoogleMapTemplate, "谷歌地图", SiteWebFilePath & "google.xml"
End Sub

'============================================================================= 生成自定义模版

Sub CreateFreeTpl()
    Dim TempFile, TempFilePath, CreateHtmlFile
    '==========================================================================
    Dim oRs, TempWhere, Id
    TempWhere = " 1 = 1 "
    Id = Easp.Get("id:n:0")
    If Id > 0 Then
        TempWhere = TempWhere & " And Id = "& Id &" "
    End If
    Set oRs = Easp.db.GR(TablePrefix & "FreeTpl", TempWhere, " id Desc ")
    If Easp.IsN(oRs) Then
        ShowErrHtml "生成自定义模版失败,未找到数据"
    Else
        Do While Not oRs.EOF
            TempFile = CmsTemplates & CmsTempSkin & oRs("TemplateView")
            Easp.Use "fso"
            If Easp.Fso.IsFile(TempFile) Then
                CreateHtmlFile = SiteHtmlPath & CmsFun.HtmlFileUrl(SiteWebFilePath, oRs("HtmlFile"), oRs("Id"))
                Cms.Tpl.Path = CmsTemplates & CmsTempSkin
                Cms.Tpl.File = oRs("TemplateView")
                Cms.Tpl.dFields oRs
                Cms.Tpl.d("PageId") = oRs("Id")
                Cms.Tpl.d("PageTitle") = oRs("Title")
                Cms.Tpl.d("PageFile") = CreateHtmlFile
                Cms.Tpl.d("ChannelId") = 1
                Cms.Fun.Init()
                Cms.Tpl.SaveAs = CreateHtmlFile
                '==========================================================================
                ShowErrHtml "生成自定义页：<a href="""& CreateHtmlFile &""" target=""_blank"">"& oRs("Title") &"</a>,生成成功"
            Else
                ShowErrHtml "生成自定义页："& oRs("Title") &"，失败,模版文件："& CmsFun.ShowColor(TempFile, "red") &",未找到"
            End If
            oRs.MoveNext
        Loop
        ShowErrHtml "所有自定义模版生成完毕"
        '==========================================================================
    End If
    Easp.C oRs
End Sub

'============================================================================= 专题内容

Sub CreateTopic()
    Dim TempFile, TempFilePath, CreateHtmlFile
    '==========================================================================
    Dim oRs, TempWhere, Id
    TempWhere = " 1 = 1 "
    Id = Easp.Get("id:n:0")
    If Id > 0 Then
        TempWhere = TempWhere & " And Id = "& Id &" "
    End If
    Set oRs = Easp.db.GR(TablePrefix & "Topic", TempWhere, " Id Desc ")
    If Easp.IsN(oRs) Then
        ShowErrHtml "生成专题失败,未找到数据"
    Else
        Do While Not oRs.EOF
            TempFile = CmsTemplates & CmsTempSkin & oRs("TemplateView")
            Easp.Use "fso"
            If Easp.Fso.IsFile(TempFile) Then
                CreateHtmlFile = SiteHtmlPath & CmsFun.HtmlFileUrl(TopicPath, oRs("HtmlFile"), oRs("Id"))
                Cms.Tpl.Path = CmsTemplates & CmsTempSkin
                Cms.Tpl.File = oRs("TemplateView")
                Cms.Tpl.dFields oRs
                Cms.Tpl.d("PageId") = oRs("Id")
                Cms.Tpl.d("PageTitle") = oRs("Title")
                Cms.Tpl.d("PageFile") = CreateHtmlFile
                Cms.Tpl.d("ChannelId") = 1
                Cms.Fun.Init()
                Cms.Tpl.SaveAs = CreateHtmlFile
                '==========================================================================
                ShowErrHtml "生成专题：<a href="""& CreateHtmlFile &""" target=""_blank"">"& oRs("Title") &"</a>,生成成功"
            Else
                ShowErrHtml "生成专题："& oRs("Title") &"，失败,模版文件："& CmsFun.ShowColor(TempFile, "red") &",未找到"
            End If
            oRs.MoveNext
        Loop
        ShowErrHtml "所有专题生成完毕"
        '==========================================================================
    End If
    Easp.C oRs
End Sub

'============================================================================= 单独生成内容

Sub InfoHtml()
    Dim ChannelId
    ChannelId = Easp.Get("ChannelId:n:0")
    CreateChannelInfoHtml ChannelId
End Sub

'============================================================================= 生成所有内容

Sub CreateChannelInfoHtml(ByVal ChannelId)
    Dim iRs, ArrayList, i, TempWhere
    TempWhere = " 1 = 1 "
    If ChannelId > 0 Then
        TempWhere = TempWhere & " And Id = "& ChannelId &" "
    End If
    Set iRs = Easp.db.GR(TablePrefix & "Channel:Id,IsShow", TempWhere, " Px Asc,Id Desc")
    If Easp.IsN(iRs) Then
        ArrayList = Null
    Else
        ArrayList = iRs.GetRows()
    End If
    Easp.C iRs
    If IsArray(ArrayList) Then
        For i = 0 To UBound(ArrayList, 2)
            If ArrayList(1, i) = 1 Then
                CreateInfoHtml ArrayList(0, i)
            End If
        Next
    End If
End Sub

Sub CreateInfoHtml(ByVal ChannelId)
    Dim ArrayChannel
    Dim ChannelName, BriefName, TabName, ChannelPath, ShowPic
    If ChannelId = 0 Then
        ShowErrHtml "频道参数错误"
    Else
        ArrayChannel = GetCaCheChannelInfo("Channel", ChannelId, ChannelField)
        If Easp.IsN(ArrayChannel) Then
            ShowErrHtml "不存在的频道"
        Else
            ChannelName = ArrayChannel(0)
            BriefName = ArrayChannel(1)
            TabName = ArrayChannel(2)
            ChannelPath = ArrayChannel(4)
            ShowPic = ArrayChannel(9)
            '==========================================================================
            Dim ClassId, NewNum, StartTime, EndTime, Id
            Dim InfoTemplateView, TempFile, HtmlPath, HtmlFile
            TempFile = ""
            InfoTemplateView = ""
            HtmlPath = ""
            HtmlFile = ""
            '==========================================================================
            ClassId = Easp.Get("ClassId:n:0")
            NewNum = Easp.Get("NewNum:n:0")
            StartTime = Easp.Get("StartTime:s")
            EndTime = Easp.Get("EndTime:s")
            Id = Easp.Get("id:s")
            '==========================================================================
            Dim oRs, oSQL, FieldStr, TopStr, WhereStr
            WhereStr = ""
            FieldStr = "a.*,b.ChannelId,b.Cid,b.Pid,b.ChildId,b.ChildIdAll,b.ChildNum,"
            FieldStr = FieldStr & "b.DeepPath,b.CnName,b."& TemplateListName &",b."& TemplateViewName &",b.HtmlFilePath,b.ViewHtmlPath,"
            FieldStr = FieldStr & "b.ViewHtmlPrefix,b.TypeImg,b.MarkVal,b.DataNum"
            If NewNum > 0 Then
                TopStr = " Top "& NewNum &" "
            End If
            oSQL = "Select "& TopStr & FieldStr &" From "
            WhereStr = WhereStr & " ["& TabName &"] a Left Join ["& TablePrefix & "Type] b On a.ClassId = b.Id "
            WhereStr = WhereStr & " Where b.ChannelId = "& ChannelId &" And b."& TemplateViewName &" <> '' "
            '========================================================================== 条件
            If ClassId > 0 Then
                WhereStr = WhereStr & " And a.ClassId = "& ClassId &" "
            End If
            If Id <> "" Then
                WhereStr = WhereStr & " And a.Id In("& Id &") "
            End If
            If StartTime <> "" And EndTime <> "" Then
                If DateDiff("d", StartTime, EndTime)>= 0 Then
                    WhereStr = WhereStr & " And DateDiff("& GetSqlDay &",'"& StartTime &"',a.UpTime)>=0 And DateDiff("& GetSqlDay &",'"& EndTime &"',a.UpTime)<=0 "
                Else
                    WhereStr = WhereStr & " And DateDiff("& GetSqlDay &",'"& EndTime &"',a.UpTime)>=0 And DateDiff("& GetSqlDay &",'"& StartTime &"',a.UpTime)<=0 "
                End If
            End If
            oSQL = oSQL & WhereStr & " Order By a.Px Asc,a.UpTime Desc,a.id Desc "
            '==========================================================================
            Set oRs = Easp.db.Exec(oSQL)
            If Easp.IsN(oRs) Then
                ShowErrHtml "没有信息"
            Else
                Do While Not oRs.EOF
                    InfoTemplateView = oRs(TemplateViewName)
                    TempFile = CmsTemplates & CmsTempSkin & InfoTemplateView
                    '==========================================================================
                    Easp.Use "fso"
                    If Easp.Fso.IsFile(TempFile) Then
                        '==========================================================================
                        Cms.Tpl.Path = CmsTemplates & CmsTempSkin
                        Cms.Tpl.File = InfoTemplateView
                        '==========================================================================
                        Cms.Tpl.d("Tag") = Cms.Fun.GetSearchTagList(ChannelId, oRs("Tag"))
                        Cms.Tpl.dFields oRs
                        Cms.Tpl.d("PageId") = oRs("Id")
                        Cms.Tpl.d("PageTitle") = oRs("Title")
                        Cms.Tpl.d("ShowHeadInfo") = ShowHead(TabName, oRs("Id"), ChannelId, oRs("ClassId")) & ""
                        Cms.Tpl.d("ShowNextInfo") = ShowNext(TabName, oRs("Id"), ChannelId, oRs("ClassId")) & ""
                        '==========================================================================
                        If Not Easp.IsN(oRs("ImageUrl")) Then
                            If InStr(LCase(oRs("ImageUrl")), "http") > 0 Then
                                Cms.Tpl.d("img") = oRs("ImageUrl")
                                Cms.Tpl.d("imgs") = oRs("ImageUrl")
                            Else
                                Easp.Use "fso"
                                If Easp.Fso.IsFile(oRs("ImageUrl")) Then
                                    Cms.Tpl.d("img") = oRs("ImageUrl")
                                    If Easp.Fso.IsFile(Replace(oRs("ImageUrl"), ".", "s.")) Then
                                        Cms.Tpl.d("imgs") = Replace(oRs("ImageUrl"), ".", "s.")
                                    Else
                                        Cms.Tpl.d("imgs") = oRs("ImageUrl")
                                    End If
                                Else
                                    Cms.Tpl.d("img") = ShowPic
                                    Cms.Tpl.d("imgs") = ShowPic
                                End If
                            End If
                        Else
                            Cms.Tpl.d("img") = ShowPic
                            Cms.Tpl.d("imgs") = ShowPic
                        End If
                        '========================================================================== 开始生成Html
                        HtmlFile = SiteHtmlPath & CmsFun.HtmlFileUrl(oRs("ViewHtmlPath") & oRs("ViewHtmlPrefix"), oRs("HtmlFile"), oRs("Id"))
                        Cms.Tpl.d("PageFile") = CmsSiteUrl & HtmlFile
                        Cms.Fun.Init()
                        Cms.Tpl.SaveAs = HtmlFile
                        '==========================================================================
                        ShowErrHtml "内容页：["& oRs("CnName") &"]<a href="""& HtmlFile &""" target=""_blank"">"& oRs("Title") &"</a>,生成成功"
                    Else
                        ShowErrHtml "内容页："& oRs("Title") &"生成失败,模版文件："& CmsFun.ShowColor(TempFile, "red") &",未找到"
                    End If
                    '==========================================================================
                    oRs.MoveNext
                Loop
                ShowErrHtml ChannelName &"内容页生成完毕"
                '==========================================================================
            End If
            Easp.C oRs
        End If
    End If
End Sub

'============================================================================= 单独首页生成内容

Sub InfoIndex()
    Dim ChannelId
    ChannelId = Easp.Get("ChannelId:n:0")
    CreateChannelInfoIndexHtml ChannelId
End Sub

'============================================================================= 生成首页所有内容

Sub CreateChannelInfoIndexHtml(ByVal ChannelId)
    Dim iRs, ArrayList, i, TempWhere
    TempWhere = " 1 = 1 "
    If ChannelId > 0 Then
        TempWhere = TempWhere & " And Id = "& ChannelId &" "
    End If
    Set iRs = Easp.db.GR(TablePrefix & "Channel:Id,IsShow", TempWhere, " Px Asc,Id Desc")
    If Easp.IsN(iRs) Then
        ArrayList = Null
    Else
        ArrayList = iRs.GetRows()
    End If
    Easp.C iRs
    If IsArray(ArrayList) Then
        For i = 0 To UBound(ArrayList, 2)
            If ArrayList(1, i) = 1 Then
                CreateInfoIndex ArrayList(0, i)
            End If
        Next
    End If
End Sub

Sub CreateInfoIndex(ByVal ChannelId)
    Dim oRs, TempFilePath, TempFile, TempContent, TagName
    TagName = "ChannelList"
    Set oRs = Easp.db.GR(TablePrefix & "Channel:1", " Id = "& ChannelId &" ", " Px Asc,Id Desc")
    If Not Easp.IsN(oRs) Then
        TempFile = oRs(CnTemplateIndexName)
        TempFilePath = CmsTemplates & CmsTempSkin & TempFile
        Easp.Use "fso"
        If Easp.Fso.IsFile(TempFilePath) Then
            TempContent = LCase(Easp.Fso.Read(TempFilePath))
            Cms.Tpl.Path = CmsTemplates & CmsTempSkin
            Cms.Tpl.File = TempFile
            '==========================================================================
            If InStr(TempContent, "[showpage]") > 0 Then
                Dim Blocks, block
                Set Blocks = Cms.Tpl.getBlocks(TagName)
                For Each block In Blocks
                    Cms.Tpl.d("ChannelId") = oRs("Id")
                    Cms.Tpl.dFields oRs
                    CreateInfoIndexHtml oRs("TabName"), block.SubMatches(0), TagName, oRs
                Next
                ShowErrHtml "生成："& oRs("ChannelName") &",首页列表完成"
            Else
                Cms.Tpl.dFields oRs
                Cms.Fun.Init()
                Cms.Tpl.SaveAs = SiteHtmlPath & oRs("ChannelPath") & "index.html"
                ShowErrHtml "生成："& oRs("ChannelName") &",首页列表：<a href="""& SiteHtmlPath & oRs("ChannelPath") & "index.html"" target=""_blank"">"& SiteHtmlPath & oRs("ChannelPath") &"index.html</a>,成功"
            End If
        Else
            ShowErrHtml oRs("ChannelName") & "生成首页失败,模版文件："& CmsFun.ShowColor(TempFilePath, "red") &",未找到!"
        End If
    End If
    Easp.C oRs
End Sub

Sub CreateInfoIndexHtml(ByVal TabName, ByVal SubMatchesVal, ByVal TagName, ByVal oRs)
    Dim ClassId, iPageSize, iPageCount, iPage
    Dim CountRs, TempCount, i, TempWhere
    '======================================================
    iPageSize = CmsFun.ChkNumEric(Cms.Tpl.Attr(SubMatchesVal, "num"))
    ClassId = Trim(Cms.Tpl.Attr(SubMatchesVal, "ClassId"))
    TempWhere = ""
    If Not Easp.IsN(ClassId) Then
        TempWhere = TempWhere & " And ClassId in("& ClassId &") "
    End If
    Set CountRs = Easp.db.GR(TabName & ":Count(0)", " 1 = 1 " & TempWhere, "")
    If Easp.IsN(CountRs) Then
        TempCount = 0
    Else
        TempCount = CmsFun.ChkNumEric(CountRs(0))
    End If
    Easp.C CountRs
    '======================================================
    iPageCount = GetTablePageCount(TabName, TempWhere, iPageSize)
    If iPageCount > 0 Then
        Cms.Fun.Init()
        Dim getHtml
        getHtml = Cms.Tpl.GetHtmlCoode()
        For i = 1 To iPageCount
            Cms.Tpl.SetHtml = getHtml
            ShowErrHtml "开始生成第" & CmsFun.ShowColor(i, "red") & "页"
            iPage = i
            CreateInfoIndexHtmlList TabName, oRs, TagName, iPageSize, iPageCount, iPage, TempCount
            ShowErrHtml "第" & CmsFun.ShowColor(i, "red") & "页生成成功"
        Next
    Else
        Cms.Fun.Init()
        CreateInfoIndexHtmlList TabName, oRs, TagName, iPageSize, 1, 1, TempCount
    End If
End Sub

Sub CreateInfoIndexHtmlList(ByVal TabName, ByVal oRs, ByVal TagName, ByVal ToPaegNum, ByVal TotalPage, ByVal Page, ByVal TotalCount)
    Dim iRs, HtmlPageList, HtmlFile, Matchs, Blocks, block, strHtml, html, i, ii
    strHtml = ""
    html = ""
    HtmlFile = SiteHtmlPath & oRs("ChannelPath") & "index{0}.html"
    Set Blocks = Cms.Tpl.getBlocks(TagName)
    For Each block In Blocks
        Dim PageMode, PageTipName, objDic
        Set objDic = Server.CreateObject("Scripting.Dictionary")
        PageMode = Trim(Cms.Tpl.Attr(block.SubMatches(0), "pagemode"))
        PageTipName = Trim(Cms.Tpl.Attr(block.SubMatches(0), "pagetip"))

        If Easp.IsN(PageMode) Then
            objDic.Add "PageMode", "<span class=""disableds"">总数：{recordcount}</span><span class=""disableds"">总页数：{pagecount}</span>{first}{prev}{list}{next}{last}{jump}"
        Else
            objDic.Add "PageMode", Replace(Replace(Replace(PageMode & "", "|", """"), "[", "{"), "]", "}")
        End If
        If Not Easp.IsN(PageTipName) Then
            PageTipName = Split(PageTipName, "|")
            objDic.Add "First", PageTipName(0)
            objDic.Add "Last", PageTipName(1)
            objDic.Add "Prev", PageTipName(2)
            objDic.Add "Next", PageTipName(3)
        Else
            objDic.Add "First", "首　页"
            objDic.Add "Last", "尾　页"
            objDic.Add "Prev", "上一页"
            objDic.Add "Next", "下一页"
        End If
        '=================================================================================
        Dim ClassId, TempWhere, OrderBy
        ClassId = Trim(Cms.Tpl.Attr(block.SubMatches(0), "ClassId"))
        OrderBy = CmsFun.ChkNumEric(Cms.Tpl.attr(block.SubMatches(0), "order"))
        TempWhere = ""
        If Not Easp.IsN(ClassId) Then
            TempWhere = TempWhere & " And a.ClassId in("& ClassId &") "
        End If
        Set iRs = Easp.db.GRS(getPageSql(Page, ToPaegNum, oRs("Id"), TabName, TempWhere, OrderBy))
        html = block.SubMatches(1)
        Set Matchs = Easp.RegMatch(html, "\{((?:empty|null|eof|nodata)\:"&TagName&")\s*?(?:[\s\S.]*?)\/?\}(?:([\s\S.]*?)\{/\1\})")
        If Easp.IsN(iRs) Then
            If Matchs.Count > 0 Then
                strHtml = Matchs(0).SubMatches(1)
            End If
        Else
            If Matchs.Count > 0 Then
                html = Easp.RegReplace(html, Matchs(0).Value, "")
            End If
        End If
        i = 1
        ii = 1
        If Not iRs.EOF Then
            Do While Not iRs.EOF
                strHtml = strHtml & html
                strHtml = Cms.Fun.DataListReturnRs(oRs("Id"), strHtml, TagName, iRs)
                strHtml = Cms.Tpl.Assign(strHtml, TagName, iRs)
                Cms.Tpl.blockTagd strHtml, TagName & ".i", i
                Cms.Tpl.blockTagd strHtml, TagName & ".ii", CmsFun.ZeroFill(ii, 2)
                i = i + 1
                ii = ii + 1
                iRs.MoveNext
            Loop
        End If
        objDic.Add "Page", Page
        objDic.Add "TotalPage", TotalPage
        objDic.Add "TotalCount", TotalCount
        objDic.Add "PaegNum", ToPaegNum
        HtmlPageList = ShowPageHtml(objDic)
        Cms.Tpl.d("PageTitle") = oRs("ChannelName")
        Cms.Tpl.d("ShowPage") = HtmlPageList & ""
        Cms.Tpl.d("PageId") = oRs("Id")
        Cms.Tpl.d("ChannelId") = oRs("Id")
        Cms.Tpl.d("PageFile") = Easp.Format(HtmlFile, "")
        Cms.Tpl.blockTag(block) = strHtml
    Next
    If (CmsFun.ChkNumEric(Page) = 0 Or CmsFun.ChkNumEric(Page) = 1) Then
        Cms.Tpl.SaveAs = Easp.Format(HtmlFile, "")
        ShowErrHtml "生成："& oRs("ChannelName") &",首页列表：<a href="""& Easp.Format(HtmlFile, "") &""" target=""_blank"">"& Easp.Format(HtmlFile, "") &"</a>,成功"
    Else
        Cms.Tpl.SaveAs = Easp.Format(HtmlFile, Page)
        ShowErrHtml "生成："& oRs("ChannelName") &",首页列表：<a href="""& Easp.Format(HtmlFile, Page) &""" target=""_blank"">"& Easp.Format(HtmlFile, Page) &"</a>,成功"
    End If
    '===============================================================
    Set Blocks = Nothing
    '==========================================================================
    Easp.C iRs
End Sub

'============================================================================= 单独列表生成内容

Sub InfoList()
    Dim ChannelId, ClassId
    ChannelId = Easp.Get("ChannelId:n:0")
    ClassId = Easp.Get("ClassId:n:0")
    CreateChannelListHtml ChannelId
End Sub

'============================================================================= 生成列表所有内容

Sub CreateChannelListHtml(ByVal ChannelId)
    Dim iRs, ArrayList, i, TempWhere
    TempWhere = " 1 = 1 "
    If ChannelId > 0 Then
        TempWhere = TempWhere & " And Id = "& ChannelId &" "
    End If
    Set iRs = Easp.db.GR(TablePrefix & "Channel:Id,IsShow", TempWhere, " Px Asc,Id Desc")
    If Easp.IsN(iRs) Then
        ArrayList = Null
    Else
        ArrayList = iRs.GetRows()
    End If
    Easp.C iRs
    If IsArray(ArrayList) Then
        For i = 0 To UBound(ArrayList, 2)
            If ArrayList(1, i) = 1 Then
                CreateInfoList ArrayList(0, i)
            End If
        Next
    End If
End Sub

Sub CreateInfoList(ByVal ChannelId)
    Dim TagName, ArrayChannel, ChannelName, TabName
    TagName = "ChannelList"
    ArrayChannel = GetCaCheChannelInfo("Channel", ChannelId, ChannelField)
    If Easp.IsN(ArrayChannel) Then
        ShowErrHtml "不存在的频道"
    Else
        ChannelName = ArrayChannel(0)
        TabName = ArrayChannel(2)
        '======================================================================
        Dim TempContent, oRs, TempWhere, ClassId, TempField, TemplateList
        TempWhere = ""
        ClassId = Easp.Get("ClassId:n:0")
        If CmsFun.ChkNumEric(ClassId) > 0 Then
            TempWhere = TempWhere & " And Id = "& ClassId &" "
        End If
        TempField = "Id,ChannelId,Cid,Pid,ChildId,ChildIdAll,ChildNum,"
        TempField = TempField & "DeepPath,CnName,Px,"& TemplateListName &","& TemplateViewName &",HtmlFilePath,ViewHtmlPath,"
        TempField = TempField & "ViewHtmlPrefix,TypeImg,MetaKey,MetaDesc,IsShow,MarkVal,DataNum"
        Set oRs = Easp.db.GR(TablePrefix & "Type:"& TempField &"", " ChannelId = "& ChannelId &" And "& TemplateListName &" <> '' " & TempWhere, " Px Asc,id Desc ")
        If Easp.IsN(oRs) Then
            ShowErrHtml "生成："& ChannelName &"分类失败,当前还没有添加分类"
            Exit Sub
        Else
            Do While Not oRs.EOF
                TempContent = ""
                '======================================================================
                Easp.Use "fso"
                TemplateList = CmsTemplates & CmsTempSkin & oRs(TemplateListName)
                If Easp.Fso.IsFile(TemplateList) Then
                    TempContent = LCase(Easp.Fso.Read(TemplateList))
                    Cms.Tpl.Path = CmsTemplates & CmsTempSkin
                    Cms.Tpl.File = oRs(TemplateListName)
                    '======================================================================
                    If InStr(TempContent, "[showpage]") > 0 Then
                        Dim Blocks, block
                        Set Blocks = Cms.Tpl.getBlocks(TagName)
                        For Each block In Blocks
                            Cms.Tpl.d("ChannelId") = oRs("ChannelId")
                            Cms.Tpl.dFields oRs
                            CreateListHtml TabName, TagName, oRs, block.SubMatches(0)
                        Next
                    Else
                        Cms.Tpl.dFields oRs
                        Cms.Fun.Init()
                        Cms.Tpl.SaveAs = SiteHtmlPath & oRs("HtmlFilePath") & "index.html"
                        ShowErrHtml "生成分类：["& oRs("CnName") &"]列表：<a href="""& SiteHtmlPath & oRs("HtmlFilePath") & "index.html"" target=""_blank"">"& SiteHtmlPath & oRs("HtmlFilePath") & "index.html</a>,成功"
                    End If
                    '==========================================================================
                Else
                    ShowErrHtml "生成："& ChannelName &"分类"& oRs("CnName") &"失败,模版文件："& TemplateList &",未找到"
                End If
                oRs.MoveNext
            Loop
        End If
        Easp.C oRs
    End If
End Sub

Sub CreateListHtml(ByVal TabName, ByVal TagName, ByVal oRs, ByVal SubMatchesVal)
    Dim iPageSize, iPageCount, iSQL, iRs, iPage, DataClassId, TempCount, n
    iSQL = ""
    DataClassId = ""
    If CmsFun.ChkNumEric(oRs("id")) > 0 Then
        DataClassId = CmsFun.GetClassVal(oRs("ChannelId"), oRs("id"))
        If Not Easp.IsN(DataClassId) Then
            iSQL = " And ClassId In(" & DataClassId & ") "
        Else
            iSQL = " And ClassId = "& oRs("id") &" "
        End If
    Else
        Exit Sub
    End If
    iPageSize = CmsFun.ChkNumEric(Cms.Tpl.Attr(SubMatchesVal, "num"))
    iPageSize = Easp.IIf(iPageSize = 0, 10, iPageSize)
    '======================================================
    iPageCount = GetTablePageCount(TabName, iSQL, iPageSize)
    If iPageCount > 0 Then
        ShowErrHtml "开始生成分类：" & oRs("CnName") & "，共："& iPageCount &"页"
        Cms.Fun.Init()
        Dim getHtml
        getHtml = Cms.Tpl.GetHtmlCoode()
        For n = 1 To iPageCount
            Cms.Tpl.SetHtml = getHtml
            iPage = n
            CreatePageList TabName, oRs, TagName, iPageSize, iPageCount, iPage
        Next
    Else
        Cms.Fun.Init()
        CreatePageList TabName, oRs, TagName, iPageSize, 1, 1
    End If
End Sub

Sub CreatePageList(ByVal TabName, ByVal oRs, ByVal TagName, ByVal ToPaegNum, ByVal TotalPage, ByVal Page)
    Dim iRs, HtmlPageList, StrWhere, DataClassId, HtmlFile
    StrWhere = ""
    HtmlFile = SiteHtmlPath & oRs("HtmlFilePath") & "index{0}.html"
    If CmsFun.ChkNumEric(oRs("id")) > 0 Then
        DataClassId = CmsFun.GetClassVal(oRs("ChannelId"), oRs("id"))
        If Not Easp.IsN(DataClassId) Then
            StrWhere = StrWhere & " And a.ClassId In(" & DataClassId & ") "
        Else
            StrWhere = StrWhere & " And a.ClassId = "& oRs("id") &" "
        End If
    End If
    '======================================================== 取总记录数
    Dim TotalCount, oSQL, CountRs
    oSQL = "Select Count(*) From ["& TabName &"] a Left Join ["& TablePrefix & "Type] b On a.ClassId = b.id "
    oSQL = oSQL & " Where b.ChannelId = "& oRs("ChannelId") &" And b."& TemplateViewName &" <> '' " & StrWhere
    Set CountRs = Easp.db.Exec(oSQL)
    If Not Easp.IsN(CountRs) Then
        TotalCount = CountRs(0)
    End If
    Easp.C CountRs
    Dim Matchs, Blocks, block, strHtml, html, n, ii
    strHtml = ""
    html = ""
    Set Blocks = Cms.Tpl.getBlocks(TagName)
    For Each block In Blocks
        Dim PageMode, PageTipName, objDic
        Set objDic = Server.CreateObject("Scripting.Dictionary")
        PageMode = Trim(Cms.Tpl.Attr(block.SubMatches(0), "pagemode"))
        PageTipName = Trim(Cms.Tpl.Attr(block.SubMatches(0), "pagetip"))
        If Easp.IsN(PageMode) Then
            objDic.Add "PageMode", "<span class=""disableds"">总数：{recordcount}</span><span class=""disableds"">总页数：{pagecount}</span>{first}{prev}{list}{next}{last}{jump}"
        Else
            objDic.Add "PageMode", Replace(Replace(Replace(PageMode & "", "|", """"), "[", "{"), "]", "}")
        End If
        If Not Easp.IsN(PageTipName) Then
            PageTipName = Split(PageTipName, "|")
            objDic.Add "First", PageTipName(0)
            objDic.Add "Last", PageTipName(1)
            objDic.Add "Prev", PageTipName(2)
            objDic.Add "Next", PageTipName(3)
        Else
            objDic.Add "First", "首　页"
            objDic.Add "Last", "尾　页"
            objDic.Add "Prev", "上一页"
            objDic.Add "Next", "下一页"
        End If
        '=================================================================================
        Dim OrderBy
        OrderBy = CmsFun.ChkNumEric(Cms.Tpl.attr(block.SubMatches(0), "order"))
        Set iRs = Easp.db.GRS(getPageSql(Page, ToPaegNum, oRs("ChannelId"), TabName, StrWhere, OrderBy))
        html = block.SubMatches(1)
        Set Matchs = Easp.RegMatch(html, "\{((?:empty|null|eof|nodata)\:"&TagName&")\s*?(?:[\s\S.]*?)\/?\}(?:([\s\S.]*?)\{/\1\})")
        If Easp.IsN(iRs) Then
            If Matchs.Count > 0 Then
                strHtml = Matchs(0).SubMatches(1)
            End If
        Else
            If Matchs.Count > 0 Then
                html = Easp.RegReplace(html, Matchs(0).Value, "")
            End If
        End If
        n = 1
        ii = 1
        If Not Easp.IsN(iRs) Then
            Do While Not iRs.EOF
                strHtml = strHtml & html
                strHtml = Cms.Fun.DataListReturnRs(oRs("ChannelId"), strHtml, TagName, iRs)
                strHtml = Cms.Tpl.Assign(strHtml, TagName, iRs)
                Cms.Tpl.blockTagd strHtml, TagName & ".i", n
                Cms.Tpl.blockTagd strHtml, TagName & ".ii", CmsFun.ZeroFill(ii, 2)
                n = n + 1
                ii = ii + 1
                iRs.MoveNext
            Loop
        End If
        objDic.Add "Page", Page
        objDic.Add "TotalPage", TotalPage
        objDic.Add "TotalCount", TotalCount
        objDic.Add "PaegNum", ToPaegNum
        HtmlPageList = ShowPageHtml(objDic)
        Cms.Tpl.d("PageFile") = Easp.Format(HtmlFile, "")
        Cms.Tpl.d("ShowPage") = HtmlPageList & ""
        Easp.C iRs
        Cms.Tpl.blockTag(block) = strHtml
    Next
    If (CmsFun.ChkNumEric(Page) = 0 Or CmsFun.ChkNumEric(Page) = 1) Then
        Cms.Tpl.SaveAs = Easp.Format(HtmlFile, "")
        ShowErrHtml "生成分类：["& oRs("CnName") &"]列表：<a href="""& Easp.Format(HtmlFile, "") &""" target=""_blank"">"& Easp.Format(HtmlFile, "") &"</a>,成功"
    Else
        Cms.Tpl.SaveAs = Easp.Format(HtmlFile, Page)
        ShowErrHtml "生成分类：["& oRs("CnName") &"]列表：<a href="""& Easp.Format(HtmlFile, Page) &""" target=""_blank"">"& Easp.Format(HtmlFile, Page) &"</a>,成功"
    End If
    '===============================================================
    Set Blocks = Nothing
    '==========================================================================
    Easp.C iRs
End Sub

Function getPageSql(ByVal Page, ByVal TopNum, ByVal ChannelId, ByVal TabName, ByVal strWhere, ByVal strOrderBy)
    Dim iSQL
    iSQL = ""
    If Page > 1 Then
        iSQL = iSQL & "Select Top "& TopNum &" a.*,b.ChannelId,b.Cid,b.Pid,b.ChildId,b.ChildIdAll,b.ChildNum,"
        iSQL = iSQL & "b.DeepPath,b.CnName,b."& TemplateListName &",b."& TemplateViewName &",b.HtmlFilePath,b.ViewHtmlPath,"
        iSQL = iSQL & "b.ViewHtmlPrefix,b.TypeImg,b.MarkVal,b.DataNum"
        iSQL = iSQL & " From ["& TabName &"] a "
        iSQL = iSQL & " Left Join ["& TablePrefix & "Type] b On a.ClassId = b.Id Where b.ChannelId = "& ChannelId &" " & strWhere
        iSQL = iSQL & " And a.id < (Select min(id) From (Select Top "& (Page - 1) * TopNum &" a.id From ["& TabName &"] a "
        iSQL = iSQL & " Left Join ["& TablePrefix & "Type] b On a.ClassId = b.Id Where b.ChannelId = "& ChannelId &" " & strWhere
        iSQL = iSQL & " Order By a.id desc) as c1)"
    Else
        iSQL = iSQL & "Select Top "& TopNum &" a.*,b.ChannelId,b.Cid,b.Pid,b.ChildId,b.ChildIdAll,b.ChildNum,"
        iSQL = iSQL & "b.DeepPath,b.CnName,b."& TemplateListName &",b."& TemplateViewName &",b.HtmlFilePath,b.ViewHtmlPath,"
        iSQL = iSQL & "b.ViewHtmlPrefix,b.TypeImg,b.MarkVal,b.DataNum"
        iSQL = iSQL & " From ["& TabName &"] a "
        iSQL = iSQL & " Left Join ["& TablePrefix & "Type] b On a.ClassId = b.Id Where b.ChannelId = "& ChannelId &" " & strWhere
    End If
    Select Case strOrderBy
        Case 1
            iSQL = iSQL & " Order By a.UpTime Desc,a.Id Desc "
        Case 2
            iSQL = iSQL & " Order By a.Px Asc,a.Id Desc "
        Case 3
            iSQL = iSQL & " Order By a.Hits Desc,a.Id Desc "
        Case Else
            iSQL = iSQL & " Order By a.AddTime Desc,a.Id Desc "
    End Select
    getPageSql = iSQL
End Function

Function GetTablePageCount(ByVal TableName, ByVal TableWhere, ByVal PageNum)
    Dim iCount, iPageCount, iRs, TempWhere
    TempWhere = ""
    If Not Easp.IsN(TableWhere) Then
        TempWhere = TempWhere & TableWhere
    End If
    Set iRs = Easp.db.GR(TableName & ":Count(0)", " 1 = 1 " & TempWhere, "")
    If Easp.IsN(iRs) Then
        iCount
    Else
        iCount = CmsFun.ChkNumEric(iRs(0))
        If iCount Mod PageNum = 0 Then
            iPageCount = CmsFun.ChkNumEric(iCount \ PageNum)
        Else
            iPageCount = CmsFun.ChkNumEric(iCount \ PageNum + 1)
        End If
    End If
    Easp.db.C iRs
    GetTablePageCount = iPageCount
End Function

'=============================================================================
'函数名：ShowPageHtml
'作　用：通用分页导航
'=============================================================================

Function ShowPageHtml(ByVal objDic)
    Dim Page, TotalPage, TotalCount, PaegNum, PageTempHtml
    Dim PageFirst, PageLast, PagePrev, PageNext, PageJump

    Dim i, PageList, PageStart, PageEnd, ListLong
    Page = CmsFun.ChkNumEric(objDic.Item("Page"))
    ListLong = 9
    PageTempHtml = objDic.Item("PageMode")
    '=========================================================================
    If objDic.Item("TotalPage") > 1 Then
        PageStart = Page - ((ListLong \ 2) + (ListLong Mod 2)) + 1

        PageEnd = Page + (ListLong \ 2)
        If PageStart < 1 Then
            PageStart = 1
            PageEnd = ListLong
        End If
        If PageEnd > objDic.Item("TotalPage") Then
            PageStart = objDic.Item("TotalPage") - ListLong + 1

            PageEnd = objDic.Item("TotalPage")
        End If
        If PageStart < 1 Then PageStart = 1
        For i = PageStart To PageEnd
            If i = Page Then
                PageList = PageList & "<span class=""disabled"">" & i & "</span>"
            Else
                If i = 1 And i <> Page Then
                    PageList = PageList & "<a href=""index.html"">" & i & "</a>"
                Else
                    PageList = PageList & "<a href=""index"& i &".html"">" & i & "</a>"
                End If
            End If
        Next
        If Page > 1 Then
            PageFirst = "<a href=""index.html"">" & objDic.Item("First") & "</a>"
            If CmsFun.ChkNumEric(Page) = 2 Then
                PagePrev = "<a href=""index.html"">"& objDic.Item("Prev") &"</a>"
            Else
                PagePrev = "<a href=""index"& (Page -1) & ".html"">" & objDic.Item("Prev") & "</a>"
            End If
        Else
            PageFirst = "<span class=""disabled"">" & objDic.Item("First") & "</span>"
            PagePrev = "<span class=""disabled"">" & objDic.Item("Prev") & "</span>"
        End If
        If Page < objDic.Item("TotalPage") Then
            PageLast = "<a href=""index"& objDic.Item("TotalPage") & ".html"">" & objDic.Item("Last") & "</a>"
            PageNext = "<a href=""index"& (Page + 1) & ".html"">" & objDic.Item("Next") & "</a>"
        Else
            PageLast = "<span class=""disabled"">" & objDic.Item("Last") & "</span>"
            PageNext = "<span class=""disabled"">" & objDic.Item("Next") & "</span>"
        End If
        PageJump = "<select onchange=""window.location='index'+this.options[this.selectedIndex].value+'.html'"" title=""请选择要跳转到的页数"">"
        For i = 1 To objDic.Item("TotalPage")
            PageJump = PageJump & "<option value=""" & Easp.IIf(i = 1, "", i) & """"
            If CmsFun.ChkNumEric(i) = Page Then
                PageJump = PageJump & " selected"
            End If
            PageJump = PageJump & ">"& i &"</option>"
        Next
        PageJump = PageJump & "</select>"
        '=========================================================================
        PageTempHtml = Replace(PageTempHtml, "{recordcount}", objDic.Item("TotalCount"))
        PageTempHtml = Replace(PageTempHtml, "{pagecount}", objDic.Item("TotalPage"))
        PageTempHtml = Replace(PageTempHtml, "{pageindex}", objDic.Item("Page"))
        PageTempHtml = Replace(PageTempHtml, "{pagesize}", objDic.Item("PaegNum"))
        PageTempHtml = Replace(PageTempHtml, "{list}", PageList)
        PageTempHtml = Replace(PageTempHtml, "{first}", PageFirst)
        PageTempHtml = Replace(PageTempHtml, "{prev}", PagePrev)
        PageTempHtml = Replace(PageTempHtml, "{next}", PageNext)
        PageTempHtml = Replace(PageTempHtml, "{last}", PageLast)
        PageTempHtml = Replace(PageTempHtml, "{jump}", PageJump)
        ShowPageHtml = PageTempHtml
    Else
        ShowPageHtml = ""
    End If
    Set objDic = Nothing
End Function

'=============================================================================
'函 数 名：ShowHead
'函数作用：通用返回上一篇的链接
'参    数：
'			TableName			##### 表名
'			TableId				##### 当前ID
'			ChannelId			##### 频道ID
'			ClassId				##### 分类ID
'=============================================================================

Function ShowHead(ByVal TableName, ByVal TableId, ByVal ChannelId, ByVal ClassId)
    Dim TempStr, oRs, oSQL
    If CmsFun.ChkNumEric(TableId) = 0 Then
        Exit Function
    Else
        oSQL = "Select Top 1 a.Id,a.Title,a.HtmlFile,b.ViewHtmlPath,b.ViewHtmlPrefix,a.ClassId From "& TableName &" a Left Join ["& TablePrefix & "Type] b On a.ClassId = b.id  "
        oSQL = oSQL & " Where b.ChannelId = "& ChannelId &" And b."& TemplateViewName &" <> '' "
        If CmsFun.ChkNumEric(ClassId) > 0 Then
            oSQL = oSQL & " And a.ClassId = "& ClassId &" "
        End If
        oSQL = oSQL & " And a.id > "& TableId &" Order By a.Px Asc,a.UpTime Desc,a.id Desc "
        Set oRs = Easp.db.Exec(oSQL)
        If Easp.IsN(oRs) Then
            TempStr = "没有了!"
        Else
            TempStr = "<a href="""& CmsFun.HtmlFileUrl(oRs("ViewHtmlPath") & oRs("ViewHtmlPrefix"), oRs("HtmlFile"), oRs("id")) &""">"& oRs("Title") &"</a>"
        End If

        Easp.C oRs
        ShowHead = TempStr
    End If
End Function

'=============================================================================
'函 数 名：ShowNext
'函数作用：通用返回下一篇的链接
'参    数：

'			TableName			##### 表名
'			TableId				##### 当前ID
'			ChannelId			##### 频道ID
'			ClassId				##### 分类ID
'=============================================================================

Function ShowNext(ByVal TableName, ByVal TableId, ByVal ChannelId, ByVal ClassId)
    Dim TempStr, oRs, oSQL
    TempStr = ""
    If CmsFun.ChkNumEric(TableId) = 0 Then
        Exit Function
    Else
        oSQL = "Select Top 1 a.Id,a.Title,a.HtmlFile,b.ViewHtmlPath,b.ViewHtmlPrefix,a.ClassId From "& TableName &" a Left Join ["& TablePrefix & "Type] b On a.ClassId = b.Id  "
        oSQL = oSQL & " Where b.ChannelId = "& ChannelId &" And b."& TemplateViewName &" <> '' "
        If CmsFun.ChkNumEric(ClassId) > 0 Then
            oSQL = oSQL & " And a.ClassId = "& ClassId &" "
        End If
        oSQL = oSQL & " And a.id < "& TableId &" Order By a.Px Asc,a.UpTime Desc,a.id Desc "
        Set oRs = Easp.db.Exec(oSQL)
        If Easp.IsN(oRs) Then
            TempStr = "没有了!"
        Else
            TempStr = "<a href="""& CmsFun.HtmlFileUrl(oRs("ViewHtmlPath") & oRs("ViewHtmlPrefix"), oRs("HtmlFile"), oRs("id")) &""">"& oRs("Title") &"</a>"
        End If
        Easp.C oRs
        ShowNext = TempStr
    End If
End Function

'=============================================================================

Sub ShowErrHtml(ByVal Tip)
    Easp.WF Tip & "。"& Easp.ScriptTime &","& Now() &"。<br />" & vbCrLf
End Sub

Sub ShowJsComplete(ByVal Tip)
    Dim JsCode
    JsCode = "script"
    Easp.WF Tip & "," & Easp.ScriptTime & vbCrLf
    Easp.WF Tip & "<"& JsCode &">parent.$('#createiframe').attr('src','complete.html');</"& JsCode &">" & vbCrLf
End Sub
%>