<%
Dim objChannel
Set objChannel = New Cls_Channel

Class Cls_Channel

    Public Function CreateTableName(ByVal ChannelId, ByVal ModelId, ByVal TableName)
        Dim Result, TabSQL, TxtSQL
        Result = False
        TabSQL = Easp.IIf(DataBaseType = 1, "access", "sql") & "/" & ModelId & ".txt"
        If (Easp.IsN(TabSQL) Or Not Easp.Fso.IsFile(TabSQL)) Then
            Result = False
        Else
            TxtSQL = Easp.Fso.Read(TabSQL)
            TxtSQL = Replace(TxtSQL, "{tablename}", TableName, 1, -1, 1)
            TxtSQL = Replace(TxtSQL, "{Now}", GetSqlTime, 1, -1, 1)
            Easp.db.Exec TxtSQL
            CreateModel ChannelId, ModelId
            CreateChannelView ChannelId, TableName
            Result = True
        End If
        CreateTableName = Result
    End Function

    Private Sub CreateModel(ByVal ChannelId, ByVal ModelId)
        Dim TypeId
        TypeId = CmsFun.ChkNumEric(ModelId)
        Select Case TypeId
            Case 1
                AddChannelField ChannelId, "信息来源", "MY_Ly", 1, 0
                AddChannelField ChannelId, "信息作者", "MY_Zz", 1, 0
            Case 2
                AddChannelField ChannelId, "产品编号", "MY_Bh", 1, 0
                AddChannelField ChannelId, "产品型号", "MY_Xh", 1, 0
                AddChannelField ChannelId, "产品品牌", "MY_Pp", 1, 0
                AddChannelField ChannelId, "生产基地", "MY_Jd", 1, 0
                AddChannelField ChannelId, "产品价格", "MY_Jg", 1, 0
            Case 3
                AddChannelField ChannelId, "下载地址1", "MY_Url1", 5, 0
                AddChannelField ChannelId, "下载地址2", "MY_Url2", 5, 0
                AddChannelField ChannelId, "下载地址3", "MY_Url3", 5, 0
            Case 4
                AddChannelField ChannelId, "工作地点", "MY_Gzdd", 1, 0
                AddChannelField ChannelId, "招聘人数", "MY_Zprs", 1, 0
                AddChannelField ChannelId, "学历要求", "MY_Xlyq", 10, 0
                AddChannelField ChannelId, "工作经验", "MY_Gzjy", 10, 0
                AddChannelField ChannelId, "截止日期", "MY_Jzsj", 7, 0
                AddChannelField ChannelId, "职位性质", "MY_Zwxz", 8, 0
                AddChannelField ChannelId, "职位简介", "MY_Zwjj", 12, 0
                AddChannelField ChannelId, "职位要求", "MY_Zwyq", 12, 0
        End Select
    End Sub

    Public Sub CreateChannelView(ByVal ChannelId, ByVal TabName)
        Dim ViewName
        ViewName = "View_" & TabName
        If Not CmsMain.CheckView(ViewName) Then
            Dim oSQL
            oSQL = "Create View "& ViewName &" As SELECT "
            oSQL = oSQL & "a.*,b.ChannelId As ChannelId,b.ChildId As ChildId,b.ChildIdAll As ChildIdAll,"
            oSQL = oSQL & "b.CnName As CnName,b.HtmlFilePath As HtmlFilePath,b.ViewHtmlPath As ViewHtmlPath,"
            oSQL = oSQL & "b.ViewHtmlPrefix As ViewHtmlPrefix,b.MarkVal As MarkVal"
            oSQL = oSQL & " From ["& TabName &"] AS a Left Join ["& TablePrefix & "Type] AS b ON a.ClassId=b.id "
            oSQL = oSQL & " Where b.ChannelId="& ChannelId &" "
            Easp.db.Exec oSQL
        End If
    End Sub

    Private Sub AddChannelField(ByVal ChannelId, ByVal Alias, ByVal FieldName, ByVal FieldType, ByVal AttrId)
        Dim List, ResultVal
        Easp.Use "list"
        Set List = Easp.List.New
        List("ChannelId") = ChannelId
        List("Alias") = Alias
        List("FieldName") = FieldName
        List("IsNotNull") = 0
        List("FieldType") = FieldType
        List("Px") = 10000
        List("AttrId") = AttrId
        List("IsSys") = 1
        List("AddTime") = Now()
        ResultVal = Easp.db.AR(TablePrefix & "ChannelField:id", List.Hash)
        Easp.C List
        If ResultVal <> 0 Then
            '=======================
        End If
    End Sub

    Public Function LoadThumbMode(ByVal Val)
        Dim strTemp, ArrayList, ii
        ArrayList = Array("限定宽高(一般会变形)", "只限定宽度,高度按比例(推荐)", "只限定高度,宽度按比例(推荐)", "按限定的宽高比裁切(底部、右边会被忽略)")
        strTemp = "<select name=""ThumbMode"" id=""ThumbMode"" class=""select2"">" & vbCrLf
        For ii = 0 To UBound(ArrayList)
            strTemp = strTemp & "<option value="""& ii &""""& Easp.IIf(Trim(Val) = Trim(ii), " selected=""selected""", "") &">"& ArrayList(ii) &"</option>" & vbCrLf
        Next
        strTemp = strTemp & "</select>"
        LoadThumbMode = strTemp
    End Function


    Public Function LoadLogoMode(ByVal Val)
        Dim strTemp, ArrayList, ii
        ArrayList = Array("选择Logo图片显示位置", "左上", "右上", "左下", "右下(推荐)", "居中")
        strTemp = "<select name=""WaterLogoPos"" id=""WaterLogoPos"" class=""select2"">" & vbCrLf
        For ii = 0 To UBound(ArrayList)
            strTemp = strTemp & "<option value="""& ii &""""& Easp.IIf(Trim(Val) = Trim(ii), " selected=""selected""", "") &">"& ArrayList(ii) &"</option>" & vbCrLf
        Next
        strTemp = strTemp & "</select>"
        LoadLogoMode = strTemp
    End Function

    Public Function GetModelList(ByVal Val, ByVal IsDisabled)
        Dim strTemp, oRs, arrList, i, IfSelect
        strTemp = "<select name=""ModelId"" id=""ModelId"" class=""select2"""& Easp.IIf(IsDisabled, " disabled=""disabled""", "") &">" & vbCrLf
        strTemp = strTemp & "<option value=""0"">选择模型</option>" & vbCrLf
        Set oRs = Easp.db.GR(TablePrefix & "Model:Id,ModelName", "", " Px Asc,Id Desc ")
        If Not Easp.IsN(oRs) Then
            arrList = oRs.GetRows()
        End If
        Easp.C oRs
        If IsArray(arrList) Then
            For i = 0 To UBound(arrList, 2)
                IfSelect = ""
                IfSelect = Easp.IIf(Trim(arrList(0, i)) = Trim(Val), " selected=""selected""", "")
                strTemp = strTemp & "<option value="""& arrList(0, i) &""""& IfSelect &">"& arrList(1, i) &"</option>" & vbCrLf
            Next
        End If
        strTemp = strTemp & "</select>" & vbCrLf
        GetModelList = strTemp
    End Function

End Class
%>