// Dialog set
var getWinHeight = parseInt($(window).height());
var getWinWidth = parseInt($(window).width());
var SetDialog = {
    PublicWidth: getWinWidth >= 1250 ? 950 : 850,
    PublicHeight: getWinHeight >= 620 ? 550 : 400,
    SpecialWidth: getWinWidth >= 1250 ? 850 : 750,
    SpecialHeight: getWinHeight >= 620 ? 550 : 400
};
//表格隔行变色
$(function () {
    $(".msgtable tr:nth-child(odd)").addClass("tr_odd_bg");
    $(".msgtable tr").hover(function () {
        $(this).addClass("tr_hover_col");
    },
    function () {
        $(this).removeClass("tr_hover_col");
    });
});
// 获取上传图片的信息
function GetUpImagesListVal() {
    var bImg = $("input[name='BatchImg']");
    var bImgs = $("input[name='BatchImgs']");
    var bInfo = $("input[name='BatchInfo']");
    var bPx = $("input[name='BatchPx']");
    // 
    var data = [];
    if (bImg.length > 0) {
        $(bImg).each(function(i) {
            data.push(bImg[i].value + '#$@' + bImgs[i].value + '#$@' + bInfo[i].value + '#$@' + bPx[i].value);
        });
        data = data.join('㊣');
        $('#UpImagesListVal').val(data);
    }
}
/// <summary>ShowWin</summary>
/// 汉字转拼音
/// </summary>
/// <param name="UrlPath"></param>
/// <param name="objId">要转换文本框中的文字ID</param>
/// <param name="objVal">返回到文本框的ID</param>
/// <param name="objIdType">拼音类型：1=转拼音首字母,2=转拼音全拼音</param>
/// <param name="startStr">追加开始字符串</param>
/// <param name="endStr">追加结束字符串</param>
function GetPy(UrlPath, objId, objVal, objIdType, startStr, endStr) {
    if ($('#' + objId).val() != '') {
        var TipType = parseInt(objIdType);
        var TipVal = $('#' + objVal + '_' + TipType).val();
        $('#' + objVal + '_' + TipType).val('转换中……');
        if (TipType == 6) {
            GetPySzm(objId, objVal, startStr, endStr);
        } else {
            GetPyQpy(objId, objVal, startStr, endStr);
        }
        $('#' + objVal + '_' + TipType).val(TipVal);
    }
}

// 汉字转拼音首字母
function GetPySzm(objId, objVal, startStr, endStr) {
    if ($('#' + objId).val() != '') {
        $('#' + objVal).val(startStr + Pinyin.GetJP($('#' + objId).val()) + endStr);
    }
}
// 汉字转拼音全拼音
function GetPyQpy(objId, objVal, startStr, endStr) {
    if ($('#' + objId).val() != '') {
        $('#' + objVal).val(startStr + Pinyin.GetQP($('#' + objId).val()) + endStr);
    }
}
// 英文、整数输入
function ChkEnNumInput(obj) {
    obj.style.imeMode = 'disabled';
    obj.onkeypress = function(e) {
        e = e || event;
        var c = e.keyCode || e.which;
        return (c >= 65 && c <= 90 || c >= 97 && c <= 122 || e.charCode == 0) || '' != this.value && (c >= 48 && c <= 57 || c == 95);
    };
    obj.onpaste = function() {
        return ! clipboardData.getData('text').match(/[^a-z0-9_]/i);
    };
    obj.ondragenter = function() {
        return /[^a-z0-9_]/i.test(event.dataTransfer.getData('text'));
    };
}
function ChkIntInput(obj) {
    obj.style.imeMode = 'disabled';
    obj.onkeypress = function(e) {
        e = e || event;
        var c = e.keyCode || e.which;
        if (45 == c) {
            this.value = ('-' == this.value.charAt(0)) ? this.value.substr(1) : '-' + this.value;
            return false;
        }
        return c >= 48 && c <= 57 || e.charCode == 0;
    }
    obj.onpaste = function() {
        return ! clipboardData.getData('text').match(/\D/);
    }
    obj.ondragenter = function(e) {
        return ! /\D/.test(event.dataTransfer.getData('text'));
    }
    if (!obj.oldBlur) obj.oldBlur = obj.onblur;
    obj.onblur = function() {
        if ('' == this.value) {
            if (!this.getAttribute('allow_empty')) this.value = '10000';
            return;
        }
        this.value = parseInt(this.value, 10);
        var max = this.getAttribute('max');
        var min = this.getAttribute('min');
        if (max != undefined && parseInt(this.value, 10) > parseInt(max, 10)) this.value = parseInt(max, 10);
        if (min != undefined && parseInt(this.value, 10) < parseInt(min, 10)) this.value = parseInt(min, 10);
        if (this.oldBlur) this.oldBlur();
    }
}
// 整数输入
// 示例： onFocus="ChkNumEric(this);"
function ChkNumEric(obj) {
    if (obj.inited) return;
    obj.inited = true;
    ChkIntInput(obj);
}
// 英文、整数输入
function ChkEnNum(obj) {
    if (obj.inited) return;
    obj.inited = true;
    ChkEnNumInput(obj);
}

// 获取checkbox选中的值
function GetChkBoxVal(n) {
    var data = [];
    $("[name='" + n + "']:checked").each(function() {
        data.push($(this).val());
    });
    data = data.join(',');
    return data;
}

function InnerVal(id, Value) {
    $('#' + id).val(Value);
}

function GetSubmit(id, url) {
    $('#' + id).attr('action', url);
    $('#' + id).submit();
}

function OkSubmit(id) {
    $('#' + id).submit();
}

// 随即函数
function getRandNumber(startNum, endNum) {
    var randomNumber;
    randomNumber = Math.round(Math.random() * (endNum - startNum)) + startNum;
    return randomNumber;
}

//Tab控制函数
function tabs(tabObj) {
    var tabNum = $(tabObj).parent().index("li");
    var parentLiNums = $(tabObj).parent().parent().children("li").length;
    //设置点击后的切换样式
    $(tabObj).parent().parent().find("li a").removeClass("selected");
    $(tabObj).addClass("selected");
    //根据参数决定显示内容
    $(".tab_con").hide();
    $(".tab_con").eq(tabNum).show();
    //执行VF表单验证
    for (var n = 0; n < parentLiNums; n++) {
        $(".tab_con").eq(n).find(":input").each(function(index, element) {
            if ($(element).attr("datatype") != undefined) {
                $(element).trigger("blur");
            }
        });
    }
}


//可以自动关闭的提示
function jsprint(msgtitle, url, msgcss, callback) {
    $("#msgprint").remove();
    var cssname = "";
    switch (msgcss) {
        case "Success":
            cssname = "pcent success";
            break;
        case "Error":
            cssname = "pcent error";
            break;
        default:
            cssname = "pcent warning";
            break;
    }
    var str = '<div id="msgprint" class="' + cssname + '">' + msgtitle + '</div>';
    $("body").append(str);
    $("#msgprint").show();
    var itemiframe = "#framecenter .l-tab-content .l-tab-content-item";
    var curriframe = "";
    $(itemiframe).each(function () {
        if ($(this).css("display") != "none") {
            curriframe = $(itemiframe).index($(this));
            return false;
        }
    });
    if (url == "back" && curriframe != "") {
        frames[curriframe].history.back(-1);
    } else if (url != "" && curriframe != "") {
        frames[curriframe].location.href = url;
    }
    //3秒后清除提示
    setTimeout(function () {
        $("#msgprint").fadeOut(500);
        //如果动画结束则删除节点
        if (!$("#msgprint").is(":animated")) {
            $("#msgprint").remove();
        }
    },
    3000);
    //执行回调函数
    if (typeof (callback) == "function") {
        callback();
    }
}

//全选取消按钮函数，调用样式如：
function checkAll(chkobj) {
    if ($(chkobj).find("span b").text() == "全选") {
        $(chkobj).find("span b").text("取消");
        $(".msgtable input").attr("checked", true);
    } else {
        $(chkobj).find("span b").text("全选");
        $(".msgtable input").attr("checked", false);
    }
}

//执行回传函数
function ExePostBack(objmsg, id, url) {
    if ($(".msgtable input:checked").size() < 1) {
        $.ligerDialog.warn("对不起，请选中您要操作的记录！");
        return false;
    }
    var msg = "删除记录后不可恢复，您确定吗？";
    if (objmsg != '') {
        msg = objmsg;
    }
    $.ligerDialog.confirm(msg, "提示信息", function(result) {
        if (result) {
            GetSubmit(id, url);
        }
    });
    return false;
}

//执行回传函数
function ExeConfirm(objMsg, objType, objUrl) {
    $.ligerDialog.confirm(objMsg, "提示信息", function(result) {
        if (result) {
            if (objType == 1) {
                top.location.href = objUrl;
            } else {
                location.href = objUrl;
            }
        }
    });
    return false;
}
//执行回传函数
function ExeConfirmSub(objFormId, objUrl, objMsg) {
    $.ligerDialog.confirm(objMsg, "提示信息", function(result) {
        if (result) {
            GetSubmit(objFormId, objUrl);
        }
    });
    return false;
}

//执行回传函数
function ExePostTip(objId, objmsg, id, url) {
    if ($(".checkall input:checked").size() < 1) {
        $.ligerDialog.warn("对不起，请选中您要操作的记录！");
        return false;
    }
    var msg = "删除记录后不可恢复，您确定吗？";
    if (arguments.length == 2) {
        msg = objmsg;
    }
    $.ligerDialog.confirm(msg, "提示信息", function (result) {
        if (result) {
			GetSubmit(id, url);
        }
    });
    return false;
}

//关闭提示窗口
function CloseTip(objId) {
    $("#" + objId).hide();
}

/// <summary>ShowWin</summary>
/// 弹出窗口
/// </summary>
/// <param name="DialogId">id,防止多个弹出</param>
/// <param name="DialogTitle">窗口标题</param>
/// <param name="DialogUrl">URL</param>
/// <param name="DialogWidth">窗口宽度</param>
/// <param name="DialogHeight">窗口高度</param>
/// <param name="DialogCache">是否缓存</param>
function ShowWin(DialogId, DialogTitle, DialogUrl, DialogWidth, DialogHeight, DialogCache) {
    $.dialog.open(DialogUrl, {
        id: DialogId,
        title: DialogTitle,
        width: DialogWidth,
        height: DialogHeight,
        lock: true,
        background: '#000',
        opacity: 0.4,
        resize: false,
        fixed: true
    },
    DialogCache);
}
/// <summary>
/// 关闭弹出窗口
/// </summary>
/// <param name="Tip">提示信息，可以为空</param>
/// <param name="IsReload">关闭窗口后是否刷新父页面</param>
/// <returns></returns>
function DialogTip(Tip, IsReload) {
    var W = artDialog.open.origin;
    if (Tip != '') {
        alert(Tip);
    }
    if (IsReload == 1) {
        W.location.reload();
    }
    $.dialog.close();
}
function ReturnDialogVal(HtmlId, Val) {
    var W = artDialog.open.origin;
    W.$('#' + HtmlId).val(Val);
    $.dialog.close();
}
//===========================系统管理JS函数结束================================

//================上传文件JS函数开始，需和jquery.form.js一起使用===============
/// <summary>
/// 文件上传
/// </summary>
/// <param name="pathUrl">上传URL相对路径</param>
/// <param name="action"></param>
/// <param name="ChannelId">频道ID(只能是数字)</param>
/// <param name="UpType">上传类型(只能是数字)</param>
/// <param name="ReturnInputName">上传完后返回到指定文本框中的ID</param>
/// <returns></returns>
function Upload(pathUrl, action, ChannelId, UpType, ReturnInputName) {
    var sendUrl = pathUrl + 'handler/UpLoad.Asp?action=' + action + '&ChannelId=' + ChannelId + '&UpType=' + UpType + '&n=' + Math.random();
    //开始提交
    $('#myform').ajaxSubmit({
        url: sendUrl,
        type: "post",
        dataType: "html",
        beforeSubmit: function() {
            //隐藏上传按钮
            $("#" + ReturnInputName).nextAll(".files").eq(0).hide();
            //显示LOADING图片
            $("#" + ReturnInputName).nextAll(".uploading").eq(0).show();
        },
        success: function(d) {
            $('#myform').removeAttr('encType');
            $('#myform').removeAttr('encoding');
            var data = eval("(" + d + ")");
            if (data.error == 0) {
                $("#" + ReturnInputName).val(data.url);
            } else {
                alert(data.message);
            }
            $("#" + ReturnInputName).nextAll(".files").eq(0).show();
            $("#" + ReturnInputName).nextAll(".uploading").eq(0).hide();
        },
        error: function(data, status, e) {
            $('#myform').removeAttr('encType');
            $('#myform').removeAttr('encoding');
            $("#" + ReturnInputName).nextAll(".files").eq(0).show();
            $("#" + ReturnInputName).nextAll(".uploading").eq(0).hide();
        }
    });
    return false;
};
//===========================上传文件JS函数结束================================

// 插入到编辑器
function InEditorVal(ObjEditor, Value, TypeId) {
    if (Value != '' && Value != null) {
        if (TypeId == 0) {
            ObjEditor.insertHtml(Value);
        } else {
            ObjEditor.insertHtml('<img src="' + Value + '" border="0" />');
        }
    }
}

function LoadEditorColor() {
    return [['#000000', '#CCFFFF', '#CCFFCC', '#CCFF99', '#CCFF66', '#CCFF33', '#CCFF00', '#66FF00', '#66FF33', '#66FF66', '#66FF99', '#66FFCC', '#66FFFF', '#00FFFF', '#00FFCC', '#00FF99', '#00FF66', '#00FF33', '#00FF00'], ['#333333', '#CCCCFF', '#CCCCCC', '#CCCC99', '#CCCC66', '#CCCC33', '#CCCC00', '#66CC00', '#66CC33', '#66CC66', '#66CC99', '#66CCCC', '#66CCFF', '#00CCFF', '#00CCCC', '#00CC99', '#00CC66', '#00CC33', '#00CC00'], ['#666666', '#CC99FF', '#CC99CC', '#CC9999', '#CC9966', '#CC9933', '#CC9900', '#669900', '#669933', '#669966', '#669999', '#6699CC', '#6699FF', '#0099FF', '#0099CC', '#009999', '#009966', '#009933', '#009900'], ['#999999', '#CC66FF', '#CC66CC', '#CC6699', '#CC6666', '#CC6633', '#CC6600', '#666600', '#666633', '#666666', '#666699', '#6666CC', '#6666FF', '#0066FF', '#0066CC', '#006699', '#006666', '#006633', '#006600'], ['#CCCCCC', '#CC33FF', '#CC33CC', '#CC3399', '#CC3366', '#CC3333', '#CC3300', '#663300', '#663333', '#663366', '#663399', '#6633CC', '#6633FF', '#0033FF', '#0033CC', '#003399', '#003366', '#003333', '#003300'], ['#FFFFFF', '#CC00FF', '#CC00CC', '#CC0099', '#CC0066', '#CC0033', '#CC0000', '#660000', '#660033', '#660066', '#660099', '#6600CC', '#6600FF', '#0000FF', '#0000CC', '#000099', '#000066', '#000033', '#000000'], ['#FF0000', '#FF00FF', '#FF00CC', '#FF0099', '#FF0066', '#FF0033', '#FF0000', '#990000', '#990033', '#990066', '#990099', '#9900CC', '#9900FF', '#3300FF', '#3300CC', '#330099', '#330066', '#330033', '#330000'], ['#00FF00', '#FF33FF', '#FF33CC', '#FF3399', '#FF3366', '#FF3333', '#FF3300', '#993300', '#993333', '#993366', '#993399', '#9933CC', '#9933FF', '#3333FF', '#3333CC', '#333399', '#333366', '#333333', '#333300'], ['#0000FF', '#FF66FF', '#FF66CC', '#FF6699', '#FF6666', '#FF6633', '#FF6600', '#996600', '#996633', '#996666', '#996699', '#9966CC', '#9966FF', '#3366FF', '#3366CC', '#336699', '#336666', '#336633', '#336600'], ['#FFFF00', '#FF99FF', '#FF99CC', '#FF9999', '#FF9966', '#FF9933', '#FF9900', '#999900', '#999933', '#999966', '#999999', '#9999CC', '#9999FF', '#3399FF', '#3399CC', '#339999', '#339966', '#339933', '#339900'], ['#00FFFF', '#FFCCFF', '#FFCCCC', '#FFCC99', '#FFCC66', '#FFCC33', '#FFCC00', '#99CC00', '#99CC33', '#99CC66', '#99CC99', '#99CCCC', '#99CCFF', '#33CCFF', '#33CCCC', '#33CC99', '#33CC66', '#33CC33', '#33CC00'], ['#000000', '#FF00FF', '#FF00CC', '#FF0099', '#FF0066', '#FF0333', '#FF0000', '#99FF00', '#99FF33', '#99FF66', '#99FF99', '#99FFCC', '#99FFFF', '#33FFFF', '#33FFCC', '#33FF99', '#33FF66', '#33FF33', '#33FF00']]
}

// 加载编辑器
function LoadCmsEditor(PathUrl, TextName, ChannelId) {
    var editor, UpLoadUrlPath, FileManagerUrlPath;
    UpLoadUrlPath = PathUrl + 'handler/UpLoad.Asp?action=upfile&ChannelId=' + ChannelId + '&n=' + Math.random();
    FileManagerUrlPath = PathUrl + 'Admin_FileUrl.Asp?ChannelId=' + ChannelId + '&n=' + Math.random();
    editor = KindEditor.create('textarea[name="' + TextName + '"]', {
        langType: 'zh_CN',
        imageTabIndex: 1,
        filterMode: false,
        wellFormatMode: false,
        pagebreakHtml: '[page_break]<br />',
        filePostName: 'FileData',
        minWidth: '650px',
        colorTable: LoadEditorColor(),
        items: ["source", "|", "undo", "redo", "|", "preview", "print", "template", "cut", "copy", "paste", "plainpaste", "wordpaste", "|", "justifyleft", "justifycenter", "justifyright", "justifyfull", "insertorderedlist", "insertunorderedlist", "indent", "outdent", "subscript", "superscript", "clearhtml", "quickformat", "selectall", "|", "fullscreen", "/", "formatblock", "fontname", "fontsize", "|", "forecolor", "hilitecolor", "bold", "italic", "underline", "strikethrough", "lineheight", "removeformat", "|", "image", "multiimage", "flash", "media", "flv", "insertfile", "table", "hr", "baidumap", "anchor", "link", "unlink", "|", "about"],
        afterChange: function() {
            this.sync();
        },
        afterBlur: function() {
            this.sync();
        },
        uploadJson: UpLoadUrlPath,
        allowFileManager: true,
        fileManagerJson: FileManagerUrlPath
    });
    return editor;
}

// KindEditor颜色组件
function SearchColor(Id, ValId, BgId) {
    var colorpicker;
    KindEditor('#' + Id).bind('click',function(e) {
        e.stopPropagation();
        if (colorpicker) {
            colorpicker.remove();
            colorpicker = null;
            return;
        }
        var colorpickerPos = KindEditor('#' + Id).pos();
        colorpicker = KindEditor.colorpicker({
            x: colorpickerPos.x,
            y: colorpickerPos.y + KindEditor('#' + Id).height(),
            z: 19811214,
            selectedColor: 'default',
            noColor: '无颜色',
            click: function(color) {
                $('#' + ValId).val(color);
                if (BgId != '') {
                    $("#" + BgId).css('background', color);
                }
                colorpicker.remove();
                colorpicker = null;
            }
        });
    });
    KindEditor(document).click(function() {
        if (colorpicker) {
            colorpicker.remove();
            colorpicker = null;
        }
    });
}

function delFile(PathUrl, fileName) {
    $.get(PathUrl + 'handler/ajax.Asp', {
        action: 'delfile',
        f: escape(fileName),
        n: Math.random()
    },
    function (data) {
        var d = eval("(" + data + ")");
        if (d.result == 1) {
            parent.jsprint("删除成功", "", "Warning");
            window.location.reload();
        }
    })
}