//==========基于Validform插件==========
//初始化验证表单
$.fn.initValidform = function() {
    var checkValidform = function(formObj) {
            $(formObj).Validform({
                tiptype: function(msg, o, cssctl) {
                    //msg：提示信息;
                    //o: {obj:*,type:*,curform:*}，
                    //    obj指向的是当前验证的表单元素（或表单对象，验证全部验证通过，提交表单时o.obj为该表单对象），
                    //    type指示提示的状态，值为1、2、3、4， 1：正在检测/提交数据，2：通过验证，3：验证失败，4：提示ignore状态， 
                    //    curform为当前form对象;
                    //cssctl: 内置的提示信息样式控制函数，该函数需传入两个参数：显示提示信息的对象 和 当前提示的状态（既形参o中的type）
                    if (!o.obj.is("form")) {
                        //定位到相应的Tab页面
                        if (o.obj.is(o.curform.find(".Validform_error:first"))) {
                            var tabobj = o.obj.parents(".tab_con"); //显示当前的选项
                            var tabindex = $(".tab_con").index(tabobj); //显示当前选项索引
                            if (!$(".content-tab ul li").eq(tabindex).children("a").hasClass("selected")) {
                                $(".content-tab ul li a").removeClass("selected");
                                $(".content-tab ul li").eq(tabindex).children("a").addClass("selected");
                                $(".tab_con").hide();
                                tabobj.show();
                            }
                        }
                        //页面上不存在提示信息的标签时，自动创建;
                        if (o.obj.parents("td[class=td2]").find(".Validform_checktip").length == 0) {
                            o.obj.parents("td[class=td2]").append('<span class="Validform_checktip" />');
                            o.obj.parents("td[class=td2]").next().find(".Validform_checktip").remove();
                        }
                        var objtip = o.obj.parents("td[class=td2]").find(".Validform_checktip");
                        cssctl(objtip, o.type);
                        objtip.text(msg);
                    }
                },
                datatype: {
                    "select": function(gets, obj, curform, regxp) {
                        if (gets == 0) {
                            return false;
                        }
                        return true;
                    },
                    "select1": /^[0-9]\d{0,2}$/,
                    "en1": /\w{3,10}$/,
                    "n3": /^[1-9]\d{0,2}$/,
                    "n4": /^[1-9]\d{0,3}$/,
                    "px": /^[1-9]\d{0,4}$/,
                    "js": /^\w{4,35}\.js$/,
                    "html1": /^.{4,35}\.html$/,
                    "zd": /^MY_\w{2,20}$/,
                    "date1": /^\d{4}-\d{1,2}-\d{1,2}$/,
                    "email": /^(?=\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$).{6,30}$/ ,
                    "url1": /^(\w+:\/\/)?\w+(\.\w+)+.[a-zA-Z0-9]{2,3}$/,
                    "path1": /^\/\w{4,50}\/$/,
                    "path2": /^\w{4,20}\/$/,
                    "size": /\d{1,4}(KB|MB)$/,
                    "bakmdb": /^bak_\w{10,30}.(mdb)$/
                },
                callback: function(d) {
                    $(formObj).removeAttr('encType');
                    $(formObj).removeAttr('encoding');
                },
                showAllError: true
            });
        };
    return $(this).each(function() {
        checkValidform($(this));
    });
}