<%
Easp.Use "Cache"
Dim CmsMain, CmsSiteInfo, CmsFun, SysVersion, SysDateTime
'=================== 系统版本
SysVersion = "2.0.0(beta)"
SysDateTime = "20140522"
'==============================================================
Set CmsMain = New Cls_Main
CmsMain.SetCaCheName = "Sys_Config"
CmsMain.Init()
CmsSiteInfo = CmsMain.GetCaCheData()
'==============================================================
Set CmsFun = New Cls_Fun
'============================================================== 开始取得网站的配置参数
Dim CmsSiteName, CmsSiteTitle, CmsSiteUrl, CmsSiteLogo, CmsSiteKey, CmsSiteDesc, CmsSiteCopy
Dim CmsCompName, CmsCompFax, CmsCompPhone, CmsCompAddress, CmsCompEmail, CmsCompZcode, CmsCompQQ, CmsCompTel
Dim CmsTemplates, CmsTempSkin, CmsUpLoadFile
Dim CmsUpImagesType, CmsUpImagesSize, CmsUpFlashType, CmsUpFlashSize
Dim CmsUpMediaType, CmsUpMediaSize, CmsUpFileType, CmsUpFileSize, CmsUpAdType, CmsUpAdSize
Dim CmsIsCreateWap, CmsDialogSkin
'==============================================================
CmsSiteName = CmsSiteInfo(1, 0)
CmsSiteTitle = CmsSiteInfo(2, 0)
CmsSiteUrl = CmsSiteInfo(3, 0)
CmsSiteLogo = CmsSiteInfo(4, 0)
CmsSiteKey = CmsSiteInfo(5, 0)
CmsSiteDesc = CmsSiteInfo(6, 0)
CmsSiteCopy = CmsSiteInfo(7, 0)
'==============================================================
CmsCompName = CmsSiteInfo(8, 0)
CmsCompFax = CmsSiteInfo(9, 0)
CmsCompPhone = CmsSiteInfo(10, 0)
CmsCompAddress = CmsSiteInfo(11, 0)
CmsCompEmail = CmsSiteInfo(12, 0)
CmsCompZcode = CmsSiteInfo(13, 0)
CmsCompQQ = CmsSiteInfo(14, 0)
CmsCompTel = CmsSiteInfo(15, 0)
'==============================================================
CmsTemplates = CmsSiteInfo(16, 0)
CmsTempSkin = CmsSiteInfo(17, 0)
CmsUpLoadFile = CmsSiteInfo(18, 0)
'==============================================================
CmsUpImagesType = CmsSiteInfo(19, 0)
CmsUpImagesSize = CmsSiteInfo(20, 0)
CmsUpFlashType = CmsSiteInfo(21, 0)
CmsUpFlashSize = CmsSiteInfo(22, 0)
CmsUpMediaType = CmsSiteInfo(23, 0)
CmsUpMediaSize = CmsSiteInfo(24, 0)
CmsUpFileType = CmsSiteInfo(25, 0)
CmsUpFileSize = CmsSiteInfo(26, 0)
CmsUpAdType = CmsSiteInfo(27, 0)
CmsUpAdSize = CmsSiteInfo(28, 0)
CmsIsCreateWap = CmsSiteInfo(29, 0)
CmsDialogSkin = CmsSiteInfo(30, 0)
'==============================================================
CmsMain.SetDialogSkin = CmsDialogSkin
'==============================================================

Class Cls_Main
    Private CmsCaCheData, CaCheConfigName, DialogSkin

    Public Property Let SetCaCheName(ByVal Val)
        CaCheConfigName = Val
    End Property

    Public Property Let SetDialogSkin(ByVal Val)
        DialogSkin = Trim(Val)
    End Property

    Public Property Get GetCaCheData()
        GetCaCheData = CmsCaCheData
    End Property

    '======================================================================
    ' 加载Js文件
    '======================================================================

    Public Function LoadJsFile(ByVal FilePath)
        If Easp.IsN(FilePath) Then
            Exit Function
        Else
            Dim ResultTempFile
            ResultTempFile = Easp.IIf(InStr(FilePath, "?") > 0, FilePath & "&", FilePath & "?") & "BuildTime="& SysDateTime
            LoadJsFile = "<script src="""& ResultTempFile &"""></script>" & vbCrLf
        End If
    End Function

    Public Function LoadJsFileNoTime(ByVal FilePath)
        If Easp.IsN(FilePath) Then
            Exit Function
        Else
            LoadJsFileNoTime = "<script src="""& FilePath &"""></script>" & vbCrLf
        End If
    End Function

    '======================================================================
    ' 加载CSS文件
    '======================================================================

    Public Function LoadCssFile(ByVal FilePath)
        If Easp.IsN(FilePath) Then
            Exit Function
        Else
            Dim ResultTempFile
            ResultTempFile = Easp.IIf(InStr(FilePath, "?") > 0, FilePath & "&", FilePath & "?") & "BuildTime="& SysDateTime
            LoadCssFile = "<link href="""& ResultTempFile &""" rel=""stylesheet"" />" & vbCrLf
        End If
    End Function

    '======================================================================
    ' 加载弹出层插件
    '======================================================================

    Public Function LoadDialogScript(ByVal Path)
        Dim strTemp
        strTemp = ""
        strTemp = strTemp & LoadJsFileNoTime(Path & "Scripts/jquery/plugins/artdialog/artdialog.js?skin="& DialogSkin &"")
        strTemp = strTemp & LoadJsFile(Path & "Scripts/jquery/plugins/artdialog/plugins/iframeTools.js")
        LoadDialogScript = strTemp
    End Function

    '======================================================================
    ' 加载日期插件
    '======================================================================

    Public Function LoadDateScript(ByVal Path)
        Dim strTemp
        strTemp = ""
        strTemp = strTemp & LoadJsFile(Path & "Scripts/DatePicker/WdatePicker.js")
        LoadDateScript = strTemp
    End Function

    '======================================================================
    ' 加载编辑器
    '======================================================================

    Public Function LoadEditorScript(ByVal Path)
        Dim strTemp
        strTemp = ""
        strTemp = strTemp & LoadCssFile(Path & "Scripts/Editor/themes/default/default.css")
        strTemp = strTemp & LoadJsFile(Path & "Scripts/Editor/kindeditor.js")
        strTemp = strTemp & LoadJsFile(Path & "Scripts/Editor/lang/zh_CN.js")
        LoadEditorScript = strTemp
    End Function

    Private Sub LoadSiteInfo()
        Dim oRs, ArrayFieldList
        ArrayFieldList = "Id,SiteName,SiteTitle,SiteUrl,SiteLogo,SiteKey,SiteDesc,SiteCopy,"
        ArrayFieldList = ArrayFieldList & "CompName,CompFax,CompPhone,CompAddress,CompEmail,CompZcode,CompQQ,CompTel,"
        ArrayFieldList = ArrayFieldList & "Templates,TempSkin,UpLoadFile,"
        ArrayFieldList = ArrayFieldList & "UpImagesType,UpImagesSize,UpFlashType,UpFlashSize,"
        ArrayFieldList = ArrayFieldList & "UpMediaType,UpMediaSize,UpFileType,UpFileSize,UpAdType,UpAdSize,"
        ArrayFieldList = ArrayFieldList & "IsCreateWap,DialogSkin"
        Set oRs = Easp.db.GR(TablePrefix & "Config:"& ArrayFieldList &":1", " Id = 1", "")
        If Not oRs.EOF Then
            CmsCaCheData = oRs.GetRows()
        End If
        Easp.db.C(oRs)
    End Sub

    Public Sub Init()
        Easp.Cache(CaCheConfigName).Expires = 120
        If Easp.Cache(CaCheConfigName).Ready() Then
            CmsCaCheData = Easp.Cache(CaCheConfigName)
        Else
            LoadSiteInfo()
            If IsArray(CmsCaCheData) Then
                Easp.Cache(CaCheConfigName) = CmsCaCheData
                Easp.Cache(CaCheConfigName).SaveApp
            End If
        End If
    End Sub

    '===========================================================
    '函数名：GetFilePathList
    '作　用：获取某个文件夹的Html文件
    '参　数：	1、ShowType				##### 0、同时列出文件夹和文件,1、只列出文件,2、只列出文件夹
    '			2、TempPath				##### 系统设置模版存放的路径
    '			3、Path					##### 显示文件夹路径
    '			4、ListName				##### 下拉框的名称
    '			5、ListVal				##### 下拉框选中的值返回到某的ID元素
    '			6、ListExps				##### 下拉框第一项选择说明
    '			7、FilePathExps			##### 是否在下拉框后面显示路径说明信息
    '返回值：以下拉框形式显示相关信息
    '===========================================================

    Public Function GetFilePathList(ByVal ShowType, ByVal TempPath, ByVal Path, ByVal ListName, ByVal ListVal, ByVal ListExps, ByVal FilePathExps)
        Dim strTemp, BakPath
        BakPath = TempPath & Path
        strTemp = ""
        strTemp = strTemp & "<select name="""& ListName &""" id="""& ListName &""" class=""select2"" onchange=""InnerVal('"& ListVal &"',this.value);"">" & vbCrLf
        strTemp = strTemp & "<option value="""">"& ListExps &"</option>" & vbCrLf
        Easp.Use "fso"
        If Easp.Fso.IsFolder(TempPath & Path) Then
            Dim Flist, i
            Flist = Easp.Fso.List(BakPath, ShowType)
            For i = 0 To UBound(Flist, 2)
                strTemp = strTemp & "<option value="""& Path & Flist(0, i) &""">"& Flist(0, i) &"</option>" & vbCrLf
            Next
        End If
        strTemp = strTemp & "</select>"
        If Not Easp.IsN(FilePathExps) Then
            strTemp = strTemp & "　" & FilePathExps & "：" & BakPath
        End If
        GetFilePathList = strTemp
    End Function

    '===========================================================
    'GetDataTypeIsNotNull
    '===========================================================

    Public Function GetDataTypeIsNotNull(ByVal FieldName)
        Dim strTemp
        If DataBaseType = 1 Then
            strTemp = FieldName & " <>'' "
        Else
            strTemp = "IsNull("& FieldName &",'''')<>'''' "
        End If
        GetDataTypeIsNotNull = strTemp
    End Function

    '===========================================================
    '检查数据表是否存在
    '===========================================================

    Public Function CheckTable(ByVal TabName)
        CheckTable = False
        Dim iRs
        Set iRs = Easp.db.Conn().openSchema(20)
        Do While Not iRs.EOF
            If LCase(iRs(3)) = "table" Then
                If LCase(iRs(2)) = LCase(TabName) Then
                    CheckTable = True
                End If
            End If
            iRs.MoveNext
        Loop
        Easp.C iRs
    End Function

    '===========================================================
    '检查查询是否存在
    '===========================================================

    Public Function CheckView(ByVal ViewName)
        CheckView = False
        Dim iRs
        Set iRs = Easp.db.Conn().openSchema(20)
        Do While Not iRs.EOF
            If LCase(iRs(3)) = "view" Then
                If LCase(iRs(2)) = LCase(ViewName) Then
                    CheckView = True
                End If
            End If
            iRs.MoveNext
        Loop
        Easp.C iRs
    End Function

    '===========================================================
    '创建表
    '===========================================================

    Public Function CreateTable(ByVal TableName)
        On Error Resume Next
        If Not CheckTable(TableName) Then
            Dim SQL
            If DataBaseType = 0 Then
                SQL = "CREATE Table ["& TableName &"] (Id INT Identity (1, 1) Primary Key)"
            Else
                SQL = "CREATE Table ["& TableName &"] (Id INT IDENTITY (1, 1) NOT NULL PRIMARY KEY)"
            End If
            Easp.db.Exec SQL
            If Err.Number <> 0 Then
                Err.Clear()
                CreateTable = False
            Else
                CreateTable = True
            End If
        Else
            CreateTable = False
        End If
    End Function

    '===========================================================
    '删除字段通用函数
    '===========================================================

    Public Function DelColumn(ByVal TableName, ByVal ColumnName)
        Dim Result, ErrMsg
        Result = Easp.db.Exec("Alter Table "& TableName &" Drop "& LCase(ColumnName) &" ")
        If Result = 0 Then
            ErrMsg = "删除 "& TableName &" 表中字段<span style=""color:#00F"">错误</span>，请手动将数据库中 <b>"& ColumnName &"</b> 字段删除"
        Else
            ErrMsg = "删除 "& TableName &" 表中字段 "& ColumnName &" 成功"
        End If
        DelColumn = ErrMsg
    End Function

    '===========================================================
    '添加字段通用函数
    '===========================================================

    Public Function AddColumn(ByVal TableName, ByVal ColumnName, ByVal ColumnType)
        Dim Result, ErrMsg
        Result = Easp.db.Exec("Alter Table "& TableName &" Add "& ColumnName &" "& ColumnType &" ")
        If Result = 0 Then
            ErrMsg = "新建 "& TableName &" 表中字段<span style=""color:#00F"">错误</span>，请手动将数据库中 <b>"& ColumnName &"</b> 字段建立，属性为 <b>"& ColumnType &"</b>"
        Else
            ErrMsg = "新建 "& TableName &" 表中字段 "& ColumnName &" 成功"
        End If
        AddColumn = ErrMsg
    End Function

    '===========================================================
    '更改字段通用函数
    '===========================================================

    Public Function ModColumn(ByVal TableName, ByVal ColumnName, ByVal ColumnType)
        Dim Result, ErrMsg
        Result = Easp.db.Exec("Alter Table "& TableName &" Alter Column "& ColumnName &" "& ColumnType &"")
        If Result = 0 Then
            ErrMsg = "更改 "& TableName &" 表中字段属性<span style=""color:#00F"">错误</span>，请手动将数据库中 <b>"& ColumnName &"</b> 字段更改为 <b>"& ColumnType &"</b>"
        Else
            ErrMsg = "更改 "& TableName &" 表中字段属性 "& ColumnName &" 成功"
        End If
        ModColumn = ErrMsg
    End Function

    '===========================================================
    '判断字段是否存在通用函数
    '===========================================================

    Public Function IsFieldsText(ByVal TableName, ByVal ColumnName)
        Dim FieldsRs, imNum, iFoundErr
        iFoundErr = False
        Set FieldsRs = Easp.db.Exec("Select Top 1 * From " & TableName & "")
        For imNum = 0 To FieldsRs.Fields.Count - 1
            If FieldsRs.Fields(imNum).Name = ColumnName Then
                iFoundErr = True
                Exit For
            End If
        Next
        IsFieldsText = iFoundErr
    End Function

End Class
%>