<%
Class Cms_Fun
    Private TempScript

    '构造函数开始

    Private Sub Class_Initialize()
        TempScript = "script"
    End Sub

    Public Sub Init()
        SiteConfig()
        GetFreeTag()
        GetChannelName()
        GetTypeName()
        GetAdFile()
        ClassList 0
        ClassList 1
        ClassList 2
        ClassList 3
        ClassList 4
        ClassList 5
        GetDataList()
        TagList()
        HdpList()
        LinkList()
        BookTypeList()
        BookList()
        TopicList()
        PicList()
        GetClassPath()
        GetExecuteSql()
    End Sub

    '================================================================
    ' 装载网站配置
    '================================================================

    Public Sub SiteConfig()
        Dim oRs, i
        Set oRs = Cms.Lib.GetSiteConfig()
        If Not Easp.IsN(oRs) Then
            Cms.Tpl.AssignTag "{"& SysLable &"Sys:", "}", oRs
        End If
        Easp.C oRs
        Cms.Tpl.blockTag("{"& SysLable &"Sys:SiteDir}") = SiteWebFilePath
        Cms.Tpl.blockTag("{"& SysLable &"Sys:ThemePath}") = CmsTemplates & CmsTempSkin
        Cms.Tpl.blockTag("{"& SysLable &"Sys:ThemeMobilePath}") = CmsTemplates & CmsTempSkin & WapSiteFilePath
        Cms.Tpl.blockTag("{"& SysLable &"Sys:Now}") = Easp.DateTime(Now(), "yyyy-mm-dd hh:ii:ss")
        Cms.Tpl.blockTag("{"& SysLable &"Sys:Date}") = Easp.DateTime(Now(), "yyyy-mm-dd")
        Cms.Tpl.blockTag("{"& SysLable &"Sys:NowNum}") = Easp.DateTime(Now(), "yyyymmddhhiiss")
    End Sub

    '================================================================
    ' 装载自定义标签
    '================================================================

    Public Sub GetFreeTag()
        Dim oRs
        Set oRs = Cms.Lib.GetFreeTag()
        If Not Easp.IsN(oRs) Then
            Do While Not oRs.EOF
                Cms.Tpl.blockTag("{"& SysLable &"Tag:" & oRs(0) & "}") = oRs(1)
                oRs.MoveNext
            Loop
        End If
        Easp.C oRs
    End Sub

    '================================================================
    ' 装载分类列表
    '================================================================

    Public Sub ClassList(ByVal Num)
        Dim strHtml, oRs, Blocks, block, html, i, n, TagName, Matchs
        TagName = "type" & Easp.IIf(Num = 0, "", Num)
        Set Blocks = Cms.Tpl.getBlocks(TagName)
        If CmsFun.ChkNumEric(Blocks.Count) = 0 Then
            Set Blocks = Nothing
            Exit Sub
        End If
        For Each block In Blocks
            html = block.SubMatches(1)
            strHtml = ""
            Set oRs = Cms.Lib.GetClassList(block.SubMatches(0))
            Set Matchs = Easp.RegMatch(html, "\{((?:empty|null|eof|nodata)\:" & TagName & ")\s*?(?:[\s\S.]*?)\/?\}(?:([\s\S.]*?)\{/\1\})")
            If Easp.IsN(oRs) Then
                If Matchs.Count > 0 Then
                    strHtml = Matchs(0).SubMatches(1)
                End If
            Else
                If Matchs.Count > 0 Then
                    html = Easp.RegReplace(html, Matchs(0).Value, "")
                End If
            End If
            If Not oRs.EOF Then
                n = 0
                i = 1
                Do While Not oRs.EOF
                    strHtml = strHtml & html
                    strHtml = ReturnTypeRs(strHtml, TagName, oRs)
                    strHtml = Cms.Tpl.Assign(strHtml, TagName, oRs)
                    Cms.Tpl.blockTagd strHtml, TagName & ".i", i
                    Cms.Tpl.blockTagd strHtml, TagName & ".ii", CmsFun.ZeroFill(i, 2)
                    Cms.Tpl.blockTagd strHtml, TagName & ".n", n
                    Cms.Tpl.blockTagd strHtml, TagName & ".nn", CmsFun.ZeroFill(n, 2)
                    i = i + 1
                    n = n + 1
                    oRs.MoveNext
                Loop
                Cms.Tpl.blockTagd strHtml, TagName & ".countnum", CmsFun.ChkNumEric(oRs.RecordCount)
            End If
            Easp.C oRs
            Cms.Tpl.blockTag(block) = strHtml
        Next
        Set Blocks = Nothing
    End Sub

    Public Sub GetTypeName()
        Dim Blocks, block, Id, TagName, ResultHtml
        Dim ResultVal, UrlLink, CssStyle, ShowTip, IsWap
        TagName = "TypeCnName"
        ResultHtml = ""
        CssStyle = ""
        ShowTip = ""
        IsWap = 0
        Set Blocks = Cms.Tpl.getFuncs(TagName)
        For Each block In Blocks
            ResultVal = Cms.Lib.GetTypeName(block)
            '============================================== 获取一些属性值
            CssStyle = Trim(Cms.Tpl.attr(block, "css"))
            ShowTip = Trim(Cms.Tpl.attr(block, "tip"))
            IsWap = CmsFun.ChkNumEric(Trim(Cms.Tpl.attr(block, "m")))
            If Not Easp.IsN(ResultVal) Then
                If Not Easp.IsN(ShowTip) Then
                    ShowTip = Replace(ShowTip, "|", """")
                Else
                    ShowTip = ResultVal(0)
                End If
                If Not Easp.IsN(ResultVal(2)) Then
                    UrlLink = ResultVal(2)
                Else
                    UrlLink = ResultVal(1)
                End If
                If IsWap > 0 Then
                    ResultHtml = "<a href=""" & WapPath & UrlLink & """"& Easp.IIf(Not Easp.IsN(CssStyle), " class="""& CssStyle &"""", "") &">" & ShowTip & "</a>"
                Else
                    ResultHtml = "<a href=""" & UrlLink & """"& Easp.IIf(Not Easp.IsN(CssStyle), " class="""& CssStyle &"""", "") &">" & ShowTip & "</a>"
                End If
            End If
            Cms.Tpl.funcTag(block) = ResultHtml
        Next
        Set Blocks = Nothing
    End Sub

    Public Sub GetChannelName()
        Dim Blocks, block, Id, TagName, ResultHtml
        Dim ResultVal, CssStyle, ShowTip, IsWap
        TagName = "ChannelName"
        ResultHtml = ""
        CssStyle = ""
        ShowTip = ""
        IsWap = 0
        Set Blocks = Cms.Tpl.getFuncs(TagName)
        For Each block In Blocks
            ResultVal = Cms.Lib.GetChannelName(block)
            '============================================== 获取一些属性值
            CssStyle = Trim(Cms.Tpl.attr(block, "css"))
            ShowTip = Trim(Cms.Tpl.attr(block, "tip"))
            IsWap = CmsFun.ChkNumEric(Trim(Cms.Tpl.attr(block, "m")))
            If Not Easp.IsN(ResultVal) Then
                If Not Easp.IsN(ShowTip) Then
                    ShowTip = Replace(ShowTip, "|", """")
                Else
                    ShowTip = ResultVal(0)
                End If
                If IsWap > 0 Then
                    ResultHtml = "<a href=""" & WapPath & ResultVal(1) & """"& Easp.IIf(Not Easp.IsN(CssStyle), " class="""& CssStyle &"""", "") &">" & ShowTip & "</a>"
                Else
                    ResultHtml = "<a href=""" & ResultVal(1) & """"& Easp.IIf(Not Easp.IsN(CssStyle), " class="""& CssStyle &"""", "") &">" & ShowTip & "</a>"
                End If
            End If
            Cms.Tpl.funcTag(block) = ResultHtml
        Next
        Set Blocks = Nothing
    End Sub

    Public Sub GetClassPath()
        Dim Blocks, block, Id, TagName, ResultHtml
        TagName = "GetClassPath"
        ResultHtml = ""
        Set Blocks = Cms.Tpl.getFuncs(TagName)
        For Each block In Blocks
            ResultHtml = Cms.Lib.GetClassPath(block)
            Cms.Tpl.funcTag(block) = ResultHtml
        Next
        Set Blocks = Nothing
    End Sub

    Public Sub GetAdFile()
        Dim Blocks, block, Id, TagName, ResultHtml
        TagName = "GetAd"
        ResultHtml = ""
        Set Blocks = Cms.Tpl.getFuncs(TagName)
        For Each block In Blocks
            ResultHtml = Cms.Lib.GetAdFile(block)
            Cms.Tpl.funcTag(block) = "<"& TempScript &" src=""" & SiteWebFilePath & "Plug/super/?action=super&id=" & ResultHtml & """></"& TempScript &">"
        Next
        Set Blocks = Nothing
    End Sub

    '================================================================
    ' 装载Tag列表
    '================================================================

    Public Sub TagList()

        Dim strHtml, oRs, Blocks, block, html, i, l, TagName, Matchs
        TagName = "tag"
        Set Blocks = Cms.Tpl.getBlocks(TagName)
        If CmsFun.ChkNumEric(Blocks.Count) = 0 Then
            Set Blocks = Nothing
            Exit Sub
        End If
        For Each block In Blocks
            html = block.SubMatches(1)
            strHtml = ""
            Set oRs = Cms.Lib.GetTagList(block.SubMatches(0))
            Set Matchs = Easp.RegMatch(html, "\{((?:empty|null|eof|nodata)\:" & TagName & ")\s*?(?:[\s\S.]*?)\/?\}(?:([\s\S.]*?)\{/\1\})")
            If Easp.IsN(oRs) Then
                If Matchs.Count > 0 Then
                    strHtml = Matchs(0).SubMatches(1)
                End If
            Else
                If Matchs.Count > 0 Then
                    html = Easp.RegReplace(html, Matchs(0).Value, "")
                End If
            End If
            If Not oRs.EOF Then
                i = 1
                l = 0
                Do While Not oRs.EOF
                    strHtml = strHtml & html
                    strHtml = Cms.Tpl.Assign(strHtml, TagName, oRs)
                    i = i + 1
                    l = l + 1
                    oRs.MoveNext
                Loop
            End If
            Easp.C oRs
            Cms.Tpl.blockTag(block) = strHtml
        Next
        Set Blocks = Nothing
    End Sub

    '================================================================
    ' 装载幻灯片列表
    '================================================================

    Public Sub HdpList()
        Dim strHtml, oRs, Blocks, block, html, i, l, TagName, Matchs
        TagName = "hdp"
        Set Blocks = Cms.Tpl.getBlocks(TagName)
        If CmsFun.ChkNumEric(Blocks.Count) = 0 Then
            Set Blocks = Nothing
            Exit Sub
        End If
        For Each block In Blocks
            html = block.SubMatches(1)
            strHtml = ""
            Set oRs = Cms.Lib.GetHdpList(block.SubMatches(0))
            Set Matchs = Easp.RegMatch(html, "\{((?:empty|null|eof|nodata)\:" & TagName & ")\s*?(?:[\s\S.]*?)\/?\}(?:([\s\S.]*?)\{/\1\})")
            If Easp.IsN(oRs) Then
                If Matchs.Count > 0 Then
                    strHtml = Matchs(0).SubMatches(1)
                End If
            Else
                If Matchs.Count > 0 Then
                    html = Easp.RegReplace(html, Matchs(0).Value, "")
                End If
            End If
            If Not oRs.EOF Then
                i = 1
                l = 0
                Do While Not oRs.EOF
                    strHtml = strHtml & html
                    strHtml = Cms.Tpl.Assign(strHtml, TagName, oRs)
                    Cms.Tpl.blockTagd strHtml, TagName & ".url", oRs("Url")
                    Cms.Tpl.blockTagd strHtml, TagName & ".i", i
                    Cms.Tpl.blockTagd strHtml, TagName & ".ii", CmsFun.ZeroFill(i, 2)
                    Cms.Tpl.blockTagd strHtml, TagName & ".l", l
                    Cms.Tpl.blockTagd strHtml, TagName & ".ll", CmsFun.ZeroFill(l, 2)
                    i = i + 1
                    l = l + 1
                    oRs.MoveNext
                Loop
                Cms.Tpl.blockTagd strHtml, TagName & ".countnum", CmsFun.ChkNumEric(oRs.RecordCount)
            End If
            Easp.C oRs
            Cms.Tpl.blockTag(block) = strHtml
        Next
        Set Blocks = Nothing
    End Sub

    '================================================================
    ' 装载友情链接列表
    '================================================================

    Public Sub LinkList()
        Dim strHtml, oRs, Blocks, block, html, i, l, TagName, Matchs
        TagName = "link"
        Set Blocks = Cms.Tpl.getBlocks(TagName)
        If CmsFun.ChkNumEric(Blocks.Count) = 0 Then
            Set Blocks = Nothing
            Exit Sub
        End If
        For Each block In Blocks
            html = block.SubMatches(1)
            strHtml = ""
            Set oRs = Cms.Lib.GetLinkList(block.SubMatches(0))
            Set Matchs = Easp.RegMatch(html, "\{((?:empty|null|eof|nodata)\:" & TagName & ")\s*?(?:[\s\S.]*?)\/?\}(?:([\s\S.]*?)\{/\1\})")
            If Easp.IsN(oRs) Then
                If Matchs.Count > 0 Then
                    strHtml = Matchs(0).SubMatches(1)
                End If
            Else
                If Matchs.Count > 0 Then
                    html = Easp.RegReplace(html, Matchs(0).Value, "")
                End If
            End If
            If Not oRs.EOF Then
                i = 1
                l = 0
                Do While Not oRs.EOF
                    strHtml = strHtml & html
                    strHtml = Cms.Tpl.Assign(strHtml, TagName, oRs)
                    Cms.Tpl.blockTagd strHtml, TagName & ".i", i
                    Cms.Tpl.blockTagd strHtml, TagName & ".ii", CmsFun.ZeroFill(i, 2)
                    Cms.Tpl.blockTagd strHtml, TagName & ".l", l
                    Cms.Tpl.blockTagd strHtml, TagName & ".ll", CmsFun.ZeroFill(l, 2)
                    i = i + 1
                    l = l + 1
                    oRs.MoveNext
                Loop
                Cms.Tpl.blockTagd strHtml, TagName & ".countnum", CmsFun.ChkNumEric(oRs.RecordCount)
            End If
            Easp.C oRs
            Cms.Tpl.blockTag(block) = strHtml
        Next
        Set Blocks = Nothing
    End Sub

    '================================================================
    ' 装载专题列表
    '================================================================

    Public Sub TopicList()
        Dim strHtml, oRs, Blocks, block, html, i, l, TagName, Matchs
        TagName = "topiclist"
        Set Blocks = Cms.Tpl.getBlocks(TagName)
        If CmsFun.ChkNumEric(Blocks.Count) = 0 Then
            Set Blocks = Nothing
            Exit Sub
        End If
        For Each block In Blocks
            html = block.SubMatches(1)
            strHtml = ""
            Set oRs = Cms.Lib.GetTopicList(block.SubMatches(0))
            Set Matchs = Easp.RegMatch(html, "\{((?:empty|null|eof|nodata)\:" & TagName & ")\s*?(?:[\s\S.]*?)\/?\}(?:([\s\S.]*?)\{/\1\})")
            If Easp.IsN(oRs) Then
                If Matchs.Count > 0 Then
                    strHtml = Matchs(0).SubMatches(1)
                End If
            Else
                If Matchs.Count > 0 Then
                    html = Easp.RegReplace(html, Matchs(0).Value, "")
                End If
            End If
            If Not oRs.EOF Then
                i = 1
                l = 0
                Do While Not oRs.EOF
                    strHtml = strHtml & html
                    strHtml = ReturnTopicRs(strHtml, TagName, oRs)
                    strHtml = Cms.Tpl.Assign(strHtml, TagName, oRs)
                    Cms.Tpl.blockTagd strHtml, TagName & ".i", i
                    Cms.Tpl.blockTagd strHtml, TagName & ".ii", CmsFun.ZeroFill(i, 2)
                    Cms.Tpl.blockTagd strHtml, TagName & ".l", l
                    Cms.Tpl.blockTagd strHtml, TagName & ".ll", CmsFun.ZeroFill(l, 2)
                    i = i + 1
                    l = l + 1
                    oRs.MoveNext
                Loop
                Cms.Tpl.blockTagd strHtml, TagName & ".countnum", CmsFun.ChkNumEric(oRs.RecordCount)
            End If
            Easp.C oRs
            Cms.Tpl.blockTag(block) = strHtml
        Next
        Set Blocks = Nothing
    End Sub

    '================================================================
    ' 装载图片列表
    '================================================================

    Public Sub PicList()
        Dim strHtml, oRs, Blocks, block, html, i, l, TagName, Matchs
        TagName = "pic"
        Set Blocks = Cms.Tpl.getBlocks(TagName)
        If CmsFun.ChkNumEric(Blocks.Count) = 0 Then
            Set Blocks = Nothing
            Exit Sub
        End If
        For Each block In Blocks
            html = block.SubMatches(1)
            strHtml = ""
            Set oRs = Cms.Lib.GetPicList(block.SubMatches(0))
            Set Matchs = Easp.RegMatch(html, "\{((?:empty|null|eof|nodata)\:" & TagName & ")\s*?(?:[\s\S.]*?)\/?\}(?:([\s\S.]*?)\{/\1\})")
            If Easp.IsN(oRs) Then
                If Matchs.Count > 0 Then
                    strHtml = Matchs(0).SubMatches(1)
                End If
            Else
                If Matchs.Count > 0 Then
                    html = Easp.RegReplace(html, Matchs(0).Value, "")
                End If
            End If
            If Not oRs.EOF Then
                i = 1
                l = 0
                Do While Not oRs.EOF
                    strHtml = strHtml & html
                    strHtml = ReturnPicRs(strHtml, TagName, oRs)
                    strHtml = Cms.Tpl.Assign(strHtml, TagName, oRs)
                    Cms.Tpl.blockTagd strHtml, TagName & ".i", i
                    Cms.Tpl.blockTagd strHtml, TagName & ".ii", CmsFun.ZeroFill(i, 2)
                    Cms.Tpl.blockTagd strHtml, TagName & ".l", l
                    Cms.Tpl.blockTagd strHtml, TagName & ".ll", CmsFun.ZeroFill(l, 2)
                    i = i + 1
                    l = l + 1
                    oRs.MoveNext
                Loop
                Cms.Tpl.blockTagd strHtml, TagName & ".countnum", CmsFun.ChkNumEric(oRs.RecordCount)
            End If
            Easp.C oRs
            Cms.Tpl.blockTag(block) = strHtml
        Next
        Set Blocks = Nothing
    End Sub

    '================================================================
    ' 装载留言分类标签
    '================================================================

    Public Sub BookTypeList()
        Dim strHtml, oRs, Blocks, block, matchs, html, i, ii, l, TagName
        TagName = "booktype"
        Set Blocks = cms.tpl.getBlocks(TagName)
        If CmsFun.ChkNumEric(Blocks.Count) = 0 Then
            Set Blocks = Nothing
            Exit Sub
        End If
        For Each block In Blocks
            html = block.SubMatches(1)
            strHtml = ""
            Set oRs = Cms.Lib.GetBookTypeList(block.SubMatches(0))
            Set Matchs = Easp.RegMatch(html, "\{((?:empty|null|eof|nodata)\:" & TagName & ")\s*?(?:[\s\S.]*?)\/?\}(?:([\s\S.]*?)\{/\1\})")
            If Easp.IsN(oRs) Then
                If Matchs.Count > 0 Then
                    strHtml = Matchs(0).SubMatches(1)
                End If
            Else
                If Matchs.Count > 0 Then
                    html = Easp.RegReplace(html, Matchs(0).Value, "")
                End If
            End If
            If Not oRs.EOF Then
                i = 1
                ii = 1
                l = 0
                Do While Not oRs.EOF
                    strHtml = strHtml & html
                    strHtml = ReturnBookTypeRs(strHtml, TagName, oRs)
                    strHtml = Cms.Tpl.Assign(strHtml, TagName, oRs)
                    Cms.Tpl.blockTagd strHtml, TagName & ".i", i
                    Cms.Tpl.blockTagd strHtml, TagName & ".ii", CmsFun.ZeroFill(ii, 2)
                    Cms.Tpl.blockTagd strHtml, TagName & ".l", l
                    Cms.Tpl.blockTagd strHtml, TagName & ".ll", CmsFun.ZeroFill(l, 2)
                    i = i + 1
                    ii = ii + 1
                    l = l + 1
                    oRs.MoveNext
                Loop
                Cms.Tpl.blockTagd strHtml, TagName & ".countnum", CmsFun.ChkNumEric(oRs.RecordCount)
            End If
            Easp.C oRs
            Cms.Tpl.blockTag(block) = strHtml
        Next
        Set Blocks = Nothing
    End Sub

    '================================================================
    ' 装载留言列表
    '================================================================

    Public Sub BookList()
        Dim strHtml, oRs, Blocks, block, html, i, l, TagName, Matchs
        TagName = "book"
        Set Blocks = Cms.Tpl.getBlocks(TagName)
        If CmsFun.ChkNumEric(Blocks.Count) = 0 Then
            Set Blocks = Nothing
            Exit Sub
        End If
        For Each block In Blocks
            html = block.SubMatches(1)
            strHtml = ""
            Set oRs = Cms.Lib.GetBookList(block.SubMatches(0))
            Set Matchs = Easp.RegMatch(html, "\{((?:empty|null|eof|nodata)\:" & TagName & ")\s*?(?:[\s\S.]*?)\/?\}(?:([\s\S.]*?)\{/\1\})")
            If Easp.IsN(oRs) Then
                If Matchs.Count > 0 Then
                    strHtml = Matchs(0).SubMatches(1)
                End If
            Else
                If Matchs.Count > 0 Then
                    html = Easp.RegReplace(html, Matchs(0).Value, "")
                End If
            End If
            If Not oRs.EOF Then
                i = 1
                l = 0
                Do While Not oRs.EOF
                    strHtml = strHtml & html
                    strHtml = ReturnBookRs(strHtml, TagName, oRs)
                    strHtml = Cms.Tpl.Assign(strHtml, TagName, oRs)
                    Cms.Tpl.blockTagd strHtml, TagName & ".i", i
                    Cms.Tpl.blockTagd strHtml, TagName & ".ii", CmsFun.ZeroFill(i, 2)
                    Cms.Tpl.blockTagd strHtml, TagName & ".l", l
                    Cms.Tpl.blockTagd strHtml, TagName & ".ll", CmsFun.ZeroFill(l, 2)
                    i = i + 1
                    l = l + 1
                    oRs.MoveNext
                Loop
                Cms.Tpl.blockTagd strHtml, TagName & ".countnum", CmsFun.ChkNumEric(oRs.RecordCount)
            End If
            Easp.C oRs
            Cms.Tpl.blockTag(block) = strHtml
        Next
        Set Blocks = Nothing
    End Sub

    '================================================================
    ' 装载自定义SQL列表
    '================================================================

    Private Sub GetExecuteSql()
        Dim TagName
        TagName = "datasql"
        Dim strHtml, oRs, Blocks, block, html, i, n, Matchs
        Set Blocks = Cms.Tpl.getBlocks(TagName)
        If CmsFun.ChkNumEric(Blocks.Count) = 0 Then
            Set Blocks = Nothing
            Exit Sub
        End If
        For Each block In Blocks
            html = block.SubMatches(1)
            strHtml = ""
            Set Matchs = Easp.RegMatch(html, "\{((?:empty|null|eof|nodata)\:" & TagName & ")\s*?(?:[\s\S.]*?)\/?\}(?:([\s\S.]*?)\{/\1\})")
            If Easp.IsN(Cms.Lib.GetExecuteSql(block.SubMatches(0))) Then
                If Matchs.Count > 0 Then
                    strHtml = Matchs(0).SubMatches(1)
                End If
            Else
                Set oRs = Easp.db.GRS(Cms.Lib.GetExecuteSql(block.SubMatches(0)))
                If Easp.IsN(oRs) Then
                    If Matchs.Count > 0 Then
                        strHtml = Matchs(0).SubMatches(1)
                    End If
                Else
                    If Matchs.Count > 0 Then
                        html = Easp.RegReplace(html, Matchs(0).Value, "")
                    End If
                End If
                If Not oRs.EOF Then
                    i = 0
                    n = 1
                    Do While Not oRs.EOF
                        strHtml = strHtml & html
                        strHtml = Cms.Tpl.Assign(strHtml, TagName, oRs)
                        Cms.Tpl.blockTagd strHtml, TagName & ".i", i
                        Cms.Tpl.blockTagd strHtml, TagName & ".ii", CmsFun.ZeroFill(i, 2)
                        Cms.Tpl.blockTagd strHtml, TagName & ".n", n
                        Cms.Tpl.blockTagd strHtml, TagName & ".nn", CmsFun.ZeroFill(n, 2)
                        i = i + 1
                        n = n + 1
                        oRs.MoveNext
                    Loop
                    Cms.Tpl.blockTagd strHtml, TagName & ".countnum", CmsFun.ChkNumEric(oRs.RecordCount)
                End If
                Easp.C oRs
            End If
            Cms.Tpl.blockTag(block) = strHtml
        Next
        Set Blocks = Nothing
    End Sub

    '================================================================
    ' 装载通用列表
    '================================================================

    Private Sub GetDataList()
        Dim TagName, ChannelId
        TagName = "datalist"
        Dim strHtml, oRs, Blocks, block, html, i, l, n, Matchs, StartNum
        Set Blocks = Cms.Tpl.getBlocks(TagName)
        If CmsFun.ChkNumEric(Blocks.Count) = 0 Then
            Set Blocks = Nothing
            Exit Sub
        End If
        For Each block In Blocks
            html = block.SubMatches(1)
            strHtml = ""
            Set Matchs = Easp.RegMatch(html, "\{((?:empty|null|eof|nodata)\:" & TagName & ")\s*?(?:[\s\S.]*?)\/?\}(?:([\s\S.]*?)\{/\1\})")
            If Easp.IsN(Cms.Lib.GetDataList(block.SubMatches(0))) Then
                If Matchs.Count > 0 Then
                    strHtml = Matchs(0).SubMatches(1)
                End If
            Else
                Set oRs = Easp.db.GRS(Cms.Lib.GetDataList(block.SubMatches(0)))
                StartNum = CmsFun.ChkNumEric(Cms.Tpl.attr(block.SubMatches(0), "start"))
                ChannelId = CmsFun.ChkNumEric(Cms.Tpl.attr(block.SubMatches(0), "ChannelId"))
                If Easp.IsN(oRs) Then
                    If Matchs.Count > 0 Then
                        strHtml = Matchs(0).SubMatches(1)
                    End If
                Else
                    If Matchs.Count > 0 Then
                        html = Easp.RegReplace(html, Matchs(0).Value, "")
                    End If
                End If
                If Not oRs.EOF Then
                    i = Easp.IIf(StartNum > 0, (1 + StartNum), 1)
                    n = 1
                    l = 0
                    oRs.Move StartNum
                    Do While Not oRs.EOF
                        strHtml = strHtml & html
                        strHtml = DataListReturnRs(ChannelId, strHtml, TagName, oRs)
                        strHtml = Cms.Tpl.Assign(strHtml, TagName, oRs)
                        Cms.Tpl.blockTagd strHtml, TagName & ".i", i
                        Cms.Tpl.blockTagd strHtml, TagName & ".ii", CmsFun.ZeroFill(i, 2)
                        Cms.Tpl.blockTagd strHtml, TagName & ".n", n
                        Cms.Tpl.blockTagd strHtml, TagName & ".nn", CmsFun.ZeroFill(n, 2)
                        Cms.Tpl.blockTagd strHtml, TagName & ".l", l
                        Cms.Tpl.blockTagd strHtml, TagName & ".ll", CmsFun.ZeroFill(l, 2)
                        i = i + 1
                        n = n + 1
                        l = l + 1
                        oRs.MoveNext
                    Loop
                    Cms.Tpl.blockTagd strHtml, TagName & ".countnum", CmsFun.ChkNumEric(oRs.RecordCount)
                End If
                Easp.C oRs
            End If
            Cms.Tpl.blockTag(block) = strHtml
        Next
        Set Blocks = Nothing
    End Sub

    '================================================================
    ' 重写分类列表字段
    '================================================================

    Public Function ReturnTypeRs(ByVal sHtml, ByVal TagName, ByVal Rs)
        If LCase(TypeName(Rs)) = "recordset" Then
            Dim UrlLink
            '=========================================================================================
            UrlLink = Rs("HtmlFilePath")
            Cms.Tpl.blockTagd sHtml, TagName & ".url", Easp.IIf(Rs("UrlLink") <> "", Rs("UrlLink"), UrlLink)
            Cms.Tpl.blockTagd sHtml, TagName & ".urlm", Easp.IIf(Rs("UrlLink") <> "", Rs("UrlLink"), WapPath & UrlLink)
            ReturnTypeRs = sHtml
        Else
            Exit Function
        End If
    End Function

    '================================================================
    ' 重写列表字段
    '================================================================

    Public Function DataListReturnRs(ByVal ChannelId, ByVal sHtml, ByVal TagName, ByVal Rs)
        If LCase(TypeName(Rs)) = "recordset" Then
            Dim iRs, UrlLink, ShowPic, ArrayChannel
            Dim FieldName, FieldVal, FieldNull, FieldNotNull
            ArrayChannel = GetCaCheChannelInfo("Channel", ChannelId, ChannelField)
            If Easp.IsN(ArrayChannel) Then
                ShowPic = "/Images/no_"& ChannelId &"_pic.jpg"
            Else
                ShowPic = ArrayChannel(11)
            End If
            '=========================================================================================
            UrlLink = CmsFun.HtmlFileUrl(Rs("ViewHtmlPath") & Rs("ViewHtmlPrefix"), Rs("HtmlFile") & "", Rs("Id"))
            Cms.Tpl.blockTagd sHtml, TagName & ".css", CmsFun.ReadCssFontMode(Rs("ColorMode"), Rs("FontMode"))
            Cms.Tpl.blockTagd sHtml, TagName & ".url", Easp.IIf(Rs("UrlLink") <> "", Rs("UrlLink"), UrlLink)
            Cms.Tpl.blockTagd sHtml, TagName & ".urlm", Easp.IIf(Rs("UrlLink") <> "", Rs("UrlLink"), WapPath & UrlLink)
            Cms.Tpl.blockTagd sHtml, TagName & ".urls", Rs("HtmlFilePath")
            Cms.Tpl.blockTagd sHtml, TagName & ".urlsm", WapPath & Rs("HtmlFilePath")
            Cms.Tpl.blockTagd sHtml, TagName & ".tag", GetSearchTagList(ChannelId, Rs("Tag"))
            '=========================================================================================
            If Not Easp.IsN(Rs("ImageUrl")) Then
                If InStr(LCase(Rs("ImageUrl")), "http") > 0 Then
                    Cms.Tpl.blockTagd sHtml, TagName & ".img", Rs("ImageUrl")
                    Cms.Tpl.blockTagd sHtml, TagName & ".imgs", Rs("ImageUrl")
                Else
                    Easp.Use "fso"
                    If Easp.Fso.IsFile(Rs("ImageUrl")) Then
                        Cms.Tpl.blockTagd sHtml, TagName & ".img", Rs("ImageUrl")
                        If Easp.Fso.IsFile(Replace(Rs("ImageUrl"), ".", "s.")) Then
                            Cms.Tpl.blockTagd sHtml, TagName & ".imgs", Replace(Rs("ImageUrl"), ".", "s.")
                        Else
                            Cms.Tpl.blockTagd sHtml, TagName & ".imgs", Rs("ImageUrl")
                        End If
                    Else
                        Cms.Tpl.blockTagd sHtml, TagName & ".img", ShowPic
                        Cms.Tpl.blockTagd sHtml, TagName & ".imgs", ShowPic
                    End If
                End If
            Else
                Cms.Tpl.blockTagd sHtml, TagName & ".img", ShowPic
                Cms.Tpl.blockTagd sHtml, TagName & ".imgs", ShowPic
            End If
            '========================================================================================= 自定义字段
            Set iRs = Easp.db.GR(TablePrefix & "ChannelField:FieldName,FieldType,FieldNull,FieldNotNull", " ChannelId = "& ChannelId &" ", "")
            If Not Easp.IsN(iRs) Then
                Do While Not iRs.EOF
                    FieldName = LCase(Trim(iRs("FieldName")))
                    FieldNull = Trim(iRs("FieldNull"))
                    FieldNotNull = Trim(iRs("FieldNotNull"))
                    If iRs("FieldType") = 4 Then
                        FieldVal = CmsFun.ChkNumEric(Rs(FieldName))
                        Cms.Tpl.blockTagd sHtml, TagName & "." & FieldName, Easp.IIf(FieldVal > 0, Rs(FieldName), FieldNull)
                    ElseIf iRs("FieldType") = 5 Then
                        FieldVal = CmsFun.ChkNumEric(Rs(FieldName))
                        Cms.Tpl.blockTagd sHtml, TagName & "." & FieldName, Easp.IIf(FieldVal > 0, FieldNotNull, FieldNull)
                    Else
                        Cms.Tpl.blockTagd sHtml, TagName & "." & FieldName, Easp.IIf(Not Easp.IsN(Rs(FieldName)), Rs(FieldName), FieldNull)
                    End If
                    iRs.MoveNext
                Loop
            End If
            Easp.db.C iRs
            '=========================================================================================
            DataListReturnRs = sHtml
        Else
            Exit Function
        End If
    End Function

    '================================================================
    ' 重写图片列表字段
    '================================================================

    Public Function ReturnPicRs(ByVal sHtml, ByVal TagName, ByVal Rs)
        If LCase(TypeName(Rs)) = "recordset" Then
            Dim ShowPic
            ShowPic = "/Images/no_pic.jpg"
            If Not Easp.IsN(Rs("Img")) Then
                Easp.Use "fso"
                If Easp.Fso.IsFile(Rs("Img")) Then
                    Cms.Tpl.blockTagd sHtml, TagName & ".img", Rs("Img")
                    If Easp.Fso.IsFile(Rs("Imgs")) Then
                        Cms.Tpl.blockTagd sHtml, TagName & ".imgs", Rs("Imgs")
                    Else
                        Cms.Tpl.blockTagd sHtml, TagName & ".imgs", Rs("Img")
                    End If
                Else
                    Cms.Tpl.blockTagd sHtml, TagName & ".img", ShowPic
                    Cms.Tpl.blockTagd sHtml, TagName & ".imgs", ShowPic
                End If
            Else
                Cms.Tpl.blockTagd sHtml, TagName & ".img", ShowPic
                Cms.Tpl.blockTagd sHtml, TagName & ".imgs", ShowPic
            End If
            ReturnPicRs = sHtml
        Else
            Exit Function
        End If
    End Function

    '================================================================
    ' 重写专题列表字段
    '================================================================

    Public Function ReturnTopicRs(ByVal sHtml, ByVal TagName, ByVal Rs)
        If LCase(TypeName(Rs)) = "recordset" Then
            Dim UrlLink, HtmlFileLink
            HtmlFileLink = ChannelTopicHtml
            '=========================================================================================
            UrlLink = CmsFun.HtmlFileUrl(HtmlFileLink, Rs("HtmlFile") & "", Rs("Id"))
            Cms.Tpl.blockTagd sHtml, TagName & ".style", CmsFun.ReadCssFontMode(Rs("ColorMode"), Rs("FontMode"))
            Cms.Tpl.blockTagd sHtml, TagName & ".url", Easp.IIf(Rs("UrlLink") <> "", Rs("UrlLink"), UrlLink)
            Cms.Tpl.blockTagd sHtml, TagName & ".urlm", Easp.IIf(Rs("UrlLink") <> "", Rs("UrlLink"), WapPath & UrlLink)
            ReturnTopicRs = sHtml
        Else
            Exit Function
        End If
    End Function

    '================================================================
    ' 重写留言分类列表字段
    '================================================================

    Public Function ReturnBookTypeRs(ByVal sHtml, ByVal TagName, ByVal Rs)
        If LCase(TypeName(Rs)) = "recordset" Then
            Cms.Tpl.blockTagd sHtml, TagName & ".url", BookPath & "?ClassId=" & Rs("id")
            Cms.Tpl.blockTagd sHtml, TagName & ".urlm", BookPath & "?ClassId=" & Rs("id")
            ReturnBookTypeRs = sHtml
        Else
            Exit Function
        End If
    End Function

    '================================================================
    ' 重写留言列表字段
    '================================================================

    Public Function ReturnBookRs(ByVal sHtml, ByVal TagName, ByVal Rs)
        If LCase(TypeName(Rs)) = "recordset" Then
            Cms.Tpl.blockTagd sHtml, TagName & ".info", CmsFun.HtmlRCdoe(Rs("Info"))
            Cms.Tpl.blockTagd sHtml, TagName & ".addtime", CmsFun.DateToString(Rs("AddTime"))
            Cms.Tpl.blockTagd sHtml, TagName & ".ishf", Easp.IIf(Easp.IsN(Rs("ReplyInfo")), 0, 1)
            Cms.Tpl.blockTagd sHtml, TagName & ".setinfo", Rs("ReplyInfo") & ""
            ReturnBookRs = sHtml
        Else
            Exit Function
        End If
    End Function

    Public Function GetSearchTagList(ByVal ChannelId, ByVal Tag)
        If Easp.IsN(Tag) Then
            GetSearchTagList = ""
            Exit Function
        Else
            Dim strTemp, i, ArrayList
            strTemp = ""
            ArrayList = Split(Tag, ",")
            For i = 0 To UBound(ArrayList)
                strTemp = strTemp & "<a href=""/search/?ChannelId="& ChannelId &"&tag="& CmsFun.GetTag(ArrayList(i)) &""" target=""_blank"">"& ArrayList(i) &"</a>,"
            Next
            If Trim(Right(strTemp, 1)) = "," Then
                strTemp = Left(strTemp, Len(strTemp) -1)
            End If
            GetSearchTagList = strTemp
        End If
    End Function

End Class
%>