<%
Class Cms_Lib

    '构造函数开始

    Private Sub Class_Initialize()

    End Sub

    Public Function GetCreateSQL(ByVal ChannelId, ByVal TabName, ByVal TopNum)
        Dim Sql
        Sql = "Select Top "& TopNum &" * From [View_"& TabName &"] Where ChannelId="& ChannelId &" "
        GetCreateSQL = Sql
    End Function


    '=================================================================
    '函 数 名：GetReturnSQL
    '函数作用：返回SQL语句
    '返 回 值：SQL
    '=================================================================

    Public Function GetDataList(ByVal attr)
        Dim ChannelId, ClassId, TopicId, TempClassVal
        Dim DataIsMsg, DataIsSlide, DataIsTop, DataIsBest, DataIsHot
        Dim TempTopNum, ShowNum
        Dim IsPic, Id, OrderBy, StartNum, CondiTion
        '==============================================================
        Dim ArrayChannel, oSQL, TabName
        ChannelId = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "ChannelId"))
        ClassId = Trim(Cms.Tpl.attr(attr, "ClassId"))
        TopicId = Trim(Cms.Tpl.attr(attr, "TopicId"))
        DataIsMsg = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "ismsg"))
        DataIsSlide = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "isslide"))
        DataIsTop = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "istop"))
        DataIsBest = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "isbest"))
        DataIsHot = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "ishot"))
        IsPic = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "ispic"))
        TempTopNum = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "num"))
        TempTopNum = Easp.IIf(TempTopNum = 0, 10, TempTopNum)
        StartNum = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "start"))
        OrderBy = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "order"))
        Id = Cms.Tpl.attr(attr, "id")
        CondiTion = Cms.Tpl.attr(attr, "condition")
        '==============================================================
        ArrayChannel = GetCaCheChannelInfo("Channel", ChannelId, ChannelField)
        If Easp.IsN(ArrayChannel) Then
            GetDataList = ""
            Exit Function
        Else
            TabName = ArrayChannel(2)
        End If
        '==============================================================
        If StartNum > 0 Then
            ShowNum = TempTopNum + StartNum
        Else
            ShowNum = TempTopNum
        End If
        '==============================================================
        oSQL = GetCreateSQL(ChannelId, TabName, ShowNum)
        '==============================================================
        If Not Easp.IsN(ClassId) Then
            If InStr(ClassId, ",") > 0 Then
                oSQL = oSQL & " And ClassId In(" & ClassId & ") "
            Else
                TempClassVal = CmsFun.GetClassVal(ChannelId, ClassId)
                If Not Easp.IsN(TempClassVal) Then
                    oSQL = oSQL & " And ClassId In(" & TempClassVal & ") "
                Else
                    oSQL = oSQL & " And ClassId = " & ClassId & " "
                End If
            End If
        End If
        '==============================================================
        If Not Easp.IsN(TopicId) Then
            If InStr(TopicId, ",") > 0 Then
                oSQL = oSQL & " And TopicId In(" & TopicId & ") "
            Else
                oSQL = oSQL & " And TopicId = " & TopicId & " "
            End If
        End If
        '==============================================================
        If DataIsMsg > 0 Then
            oSQL = oSQL & " And DataIsMsg >0 "
        End If
        If DataIsSlide > 0 Then
            oSQL = oSQL & " And DataIsSlide >0 "
        End If
        If DataIsTop > 0 Then
            oSQL = oSQL & " And DataIsTop >0 "
        End If
        If DataIsBest > 0 Then
            oSQL = oSQL & " And DataIsBest >0 "
        End If
        If DataIsHot > 0 Then
            oSQL = oSQL & " And DataIsHot >0 "
        End If
        If IsPic > 0 Then
            oSQL = oSQL & " And " & CmsMain.GetDataTypeIsNotNull("ImageUrl")
        End If
        If Not Easp.IsN(Id) Then
            oSQL = oSQL & " And Id in("& Id &") "
        End If
        If Not Easp.IsN(CondiTion) Then
            oSQL = oSQL & " And " & CondiTion
        End If
        Select Case OrderBy
            Case 1
                oSQL = oSQL & " Order By UpTime Desc,Id Desc "
            Case 2
                oSQL = oSQL & " Order By Px Asc,Id Desc "
            Case 3
                oSQL = oSQL & " Order By Hits Desc,Id Desc "
            Case Else
                oSQL = oSQL & " Order By AddTime Desc,Id Desc "
        End Select
        '==============================================================
        GetDataList = oSQL
    End Function

    '=================================================================
    '函 数 名：GetClassList
    '函数作用：装载分类列表
    '参　　数：
    '			ChannelId			###	频道ID
    '			num					  ###	显示条数
    '			d					    ###	条件:只调用大类
    '			pid					  ###	条件:指定父类ID
    '			id            ###	条件:指定分类ID
    '返 回 值：分类列表SQL
    '=================================================================

    Public Function GetClassList(attr)
        Dim oSQL, TempTopNum, ChannelId, Pid, IdVal, DeepPath
        ChannelId = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "ChannelId"))
        TempTopNum = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "num"))
        Pid = Cms.Tpl.attr(attr, "pid")
        IdVal = Cms.Tpl.attr(attr, "id")
        DeepPath = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "d"))
        '=============================================================
        oSQL = "Select "& Easp.IIf(TempTopNum = 0, "", "Top " & TempTopNum) &" * From "& TablePrefix & "Type Where IsShow = 1 "
        If ChannelId > 0 Then
            oSQL = oSQL & " And ChannelId = "& ChannelId &" "
        Else
            Exit Function
        End If
        If Not Easp.IsN(Pid) Then
            oSQL = oSQL & " And Pid In("& Pid &") "
        End If
        If DeepPath = 1 Then
            oSQL = oSQL & " And DeepPath = 0 "
        End If
        If Not Easp.IsN(IdVal) Then
            oSQL = oSQL & " And Id in("& IdVal &") "
        End If
        oSQL = oSQL & " Order By Px Asc,Id Desc "
        Set GetClassList = Easp.db.GRS(oSQL)
    End Function

    '=================================================================
    '函 数 名：GetTypeName
    '函数作用：获取指定分类的名称与URL
    '参　　数：
    '			id            ###	条件:指定分类ID
    '返 回 值：分类的名称与URL
    '=================================================================

    Public Function GetTypeName(attr)
        Dim ResultVal, IdVal
        IdVal = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "id"))
        If IdVal = 0 Then
            GetTypeName = ""
        Else
            GetTypeName = Easp.db.RT(TablePrefix & "Type", " Id = "& IdVal &" ", "CnName,HtmlFilePath,UrlLink")
        End If
    End Function

    '=================================================================
    '函 数 名：GetChannelName
    '函数作用：获取指定频道的名称与URL
    '参　　数：
    '			id            ###	条件:指定频道ID
    '返 回 值：频道的名称与URL
    '=================================================================

    Public Function GetChannelName(attr)
        Dim ResultVal, IdVal
        IdVal = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "id"))
        If IdVal = 0 Then
            GetChannelName = ""
        Else
            GetChannelName = Easp.db.RT(TablePrefix & "Channel", " Id = "& IdVal &" ", "ChannelName,ChannelPath")
        End If
    End Function

    '=================================================================
    '函 数 名：GetAdFile
    '函数作用：获取广告js显示
    '参　　数：
    '			id            ###	条件:指定编号ID
    '返 回 值：js广告代码
    '=================================================================

    Public Function GetAdFile(attr)
        Dim ResultVal, IdVal
        IdVal = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "id"))
        If IdVal = 0 Then
            GetAdFile = ""
        Else
            GetAdFile = Easp.db.RT(TablePrefix & "AdType", " Id = "& IdVal &" ", "Id")
        End If
    End Function

    '=================================================================
    '函 数 名：GetLinkList
    '函数作用：装载友情连接
    '参　　数：
    '			num					  ###	显示条数
    '			ClassId				###	所属类别
    '			IsLogo				### 是否只调用有LOGO
    '返 回 值：友情连接SQL
    '=================================================================

    Public Function GetLinkList(attr)
        Dim oSQL, TempTopNum, ClassId, IsLogo
        TempTopNum = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "num"))
        ClassId = Cms.Tpl.attr(attr, "ClassId")
        '=============================================================
        oSQL = "Select "& Easp.IIf(TempTopNum = 0, "", "Top " & TempTopNum) &" * From ["& TablePrefix & "Link] Where 1 = 1 "
        If Not Easp.IsN(ClassId) Then
            oSQL = oSQL & " And ClassId in("& ClassId &") "
        End If
        If IsLogo > 0 Then
            oSQL = oSQL & " And Logo <> '' "
        End If
        oSQL = oSQL & " Order By Px Asc,id Desc "
        Set GetLinkList = Easp.db.GRS(oSQL)
    End Function

    '=================================================================
    '函 数 名：GetHdpList
    '函数作用：装载幻灯片列表
    '参　　数：
    '			num					###	显示条数
    '			ClassId			###	所属类别
    '返 回 值：幻灯片SQL
    '=================================================================

    Public Function GetHdpList(attr)
        Dim oSQL, TempTopNum, ClassId
        TempTopNum = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "num"))
        ClassId = Cms.Tpl.attr(attr, "ClassId")
        '=============================================================
        oSQL = "Select "& Easp.IIf(TempTopNum = 0, "", "Top " & TempTopNum) &" * From ["& TablePrefix & "Hdp] Where 1 = 1 "
        If Not Easp.IsN(ClassId) Then
            oSQL = oSQL & " And ClassId in("& ClassId &") "
        End If
        oSQL = oSQL & " Order By Px Asc,Id Desc  "
        Set GetHdpList = Easp.db.GRS(oSQL)
    End Function

    '=================================================================
    '函 数 名：GetBookTypeList
    '函数作用：装载留言分类列表
    '参　　数：
    '			num					###	显示条数
    '			id					###	调用指定ID分类
    '返 回 值：留言分类SQL
    '=================================================================

    Public Function GetBookTypeList(attr)
        Dim oSQL, TempTopNum, MaxTopNum, Id
        TempTopNum = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "num"))
        Id = Cms.Tpl.attr(attr, "id")
        '=============================================================
        oSQL = "Select "& Easp.IIf(TempTopNum = 0, "", "Top " & TempTopNum) &" * From ["& TablePrefix & "BookType] Where 1 = 1 "
        If Not Easp.IsN(Id) Then
            oSQL = oSQL & " And Id in("& Id &") "
        End If
        oSQL = oSQL & " Order By Px Asc,Id Desc "
        Set GetBookTypeList = Easp.db.GRS(oSQL)
    End Function

    '=================================================================
    '函 数 名：GetBookList
    '函数作用：装载留言列表
    '参　　数：
    '			num					###	显示条数
    '			ClassId			###	调用指定分类ID，多个以逗号隔行，如：1,2,3
    '			IsReply			###	调用有回复的
    '			id					###	调用指定ID数据
    '返 回 值：留言列表SQL
    '=================================================================

    Public Function GetBookList(attr)
        Dim oSQL, TempTopNum, ClassId, IsReply, Id
        TempTopNum = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "num"))
        ClassId = Cms.Tpl.attr(attr, "ClassId")
        IsReply = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "isreply"))
        Id = Cms.Tpl.attr(attr, "id")
        '=============================================================
        oSQL = "Select "& Easp.IIf(TempTopNum = 0, "", "Top " & TempTopNum) &" * From ["& TablePrefix & "Book] Where IsChk = 1 "
        If Not Easp.IsN(ClassId) Then
            oSQL = oSQL & " And ClassId in("& ClassId &") "
        End If
        If IsReply > 0 Then
            oSQL = oSQL & " And IsReply > 0 "
        End If
        If Not Easp.IsN(Id) Then
            oSQL = oSQL & " And Id in("& Id &") "
        End If
        oSQL = oSQL & " Order By id Desc "
        Set GetBookList = Easp.db.GRS(oSQL)
    End Function

    '=================================================================
    '函 数 名：GetPicList
    '函数作用：装载图片列表
    '参　　数：
    '			num					###	显示条数
    '			ChannelId					###	调用指定频道ID
    '			DataId					###	调用指定内容ID数据
    '返 回 值：图片列表SQL
    '=================================================================

    Public Function GetPicList(attr)
        Dim oSQL, TempTopNum, ChannelId, DataId, OrderBy
        TempTopNum = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "num"))
        ChannelId = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "ChannelId"))
        DataId = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "DataId"))
        OrderBy = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "order"))
        '=============================================================
        oSQL = "Select "& Easp.IIf(TempTopNum = 0, "", "Top " & TempTopNum) &" * From ["& TablePrefix & "UpLoad] Where 1 = 1 "
        If ChannelId > 0 Then
            oSQL = oSQL & " And ChannelId = "& ChannelId &" "
        Else
            Exit Function
        End If
        If DataId > 0 Then
            oSQL = oSQL & " And DataId = "& DataId &" "
        Else
            Exit Function
        End If
        If OrderBy > 0 Then
            oSQL = oSQL & " Order By Px Asc,Id Desc "
        Else
            oSQL = oSQL & " Order By Px Asc,Id Asc "
        End If
        Set GetPicList = Easp.db.GRS(oSQL)
    End Function

    '=================================================================
    '函 数 名：GetTopicList
    '函数作用：装载专题列表
    '参　　数：
    '			num					  ###	显示条数
    '			ChannelId			###	调用指定频道ID
    '返 回 值：专题列表SQL
    '=================================================================

    Public Function GetTopicList(attr)
        Dim oSQL, TempTopNum, ChannelId
        TempTopNum = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "num"))
        ChannelId = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "ChannelId"))
        '=============================================================
        oSQL = "Select "& Easp.IIf(TempTopNum = 0, "", "Top " & TempTopNum) &" * From ["& TablePrefix & "Topic] Where 1 = 1 "
        If ChannelId > 0 Then
            oSQL = oSQL & " And ChannelId = "& ChannelId &" "
        End If
        oSQL = oSQL & " Order By Px Asc,id Desc "
        Set GetTopicList = Easp.db.GRS(oSQL)
    End Function

    '=================================================================
    '函 数 名：GetTagList
    '函数作用：装载Tag列表
    '参　　数：
    '			num					  ###	显示条数
    '			ChannelId			###	调用指定频道ID
    '返 回 值：专题列表SQL
    '=================================================================

    Public Function GetTagList(attr)
        Dim oSQL, TempTopNum, ChannelId, OrderBy
        TempTopNum = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "num"))
        ChannelId = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "ChannelId"))
        OrderBy = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "order"))
        '=============================================================
        oSQL = "Select "& Easp.IIf(TempTopNum = 0, "", "Top " & TempTopNum) &" * From ["& TablePrefix & "Tags] Where 1 = 1 "
        If ChannelId > 0 Then
            oSQL = oSQL & " And ChannelId = "& ChannelId &" "
        End If
        If OrderBy > 0 Then
            oSQL = oSQL & " Order By Counts Asc,Id Desc "
        Else
            oSQL = oSQL & " Order By Id Desc "
        End If
        Set GetTagList = Easp.db.GRS(oSQL)
    End Function

    '=================================================================
    '函 数 名：GetExecuteSql
    '函数作用：根据SQL语句返回
    '返 回 值：SQL语句返回
    '=================================================================

    Public Function GetExecuteSql(attr)
        Dim oSQL
        oSQL = Trim(Cms.Tpl.attr(attr, "sql")) & ""
        '=============================================================
        If Easp.IsN(oSQL) Then
            GetExecuteSql = ""
        Else
            GetExecuteSql = oSQL
        End If
    End Function

    '=================================================================
    '生成频道你的位置
    '=================================================================

    Public Function GetClassPath(attr)
        Dim UrlLink, ClassId, SplitVal, ChannelPath, IsWap, ClassVal
        ClassId = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "ClassId"))
        ClassVal = Trim(Cms.Tpl.attr(attr, "class"))
        SplitVal = Cms.Tpl.attr(attr, "SplitVal")
        IsWap = CmsFun.ChkNumEric(Trim(Cms.Tpl.attr(attr, "m")))
        If ClassId > 0 Then
            Do While Int(ClassId) > 0
                UrlLink = ""
                UrlLink = Easp.db.RT(TablePrefix & "Type", " Id = "& ClassId &" ", "HtmlFilePath,UrlLink")
                If Easp.Has(UrlLink) Then
                    If Not Easp.IsN(UrlLink(1)) Then
                        ChannelPath = UrlLink(1)
                    Else
                        ChannelPath = UrlLink(0)
                    End If
                Else
                    GetClassPath = ""
                    Exit Function
                End If
                GetClassPath = SplitVal & "<a href=""" & Easp.IIf(IsWap > 0, WapPath, "") & ChannelPath & """"& Easp.IIf(Not Easp.IsN(ClassVal), " class=""" & ClassVal & """", "") &">" & Easp.db.RT(TablePrefix & "Type", " Id = "& ClassId &" ", "CnName") & "</a>" & GetClassPath
                ClassId = CmsFun.ChkNumEric(Easp.db.RT(TablePrefix & "Type", " Id = "& ClassId &" ", "Pid"))
            Loop
            GetClassPath = GetClassPath
        Else
            GetClassPath = ""
        End If
    End Function

    '=================================================================
    '读取网站配置参数
    '=================================================================

    Public Function GetSiteConfig()
        Set GetSiteConfig = Easp.db.GR(TablePrefix & "Config", " Id = 1 ", "")
    End Function

    '=================================================================
    ' 装载用户自定义标签
    '=================================================================

    Public Function GetFreeTag()
        Set GetFreeTag = Easp.db.GR(TablePrefix & "FreeTag:title,Content", "", "")
    End Function

End Class
%>