/// 设置cookie的值，比如我们要设置变量名为userid对应值为123的cookie，代码如下
/// $.cookie('userid', '123');
/// 新建一个cookie，并设置cookie的有效期 路径 域名等，代码如下：
/// $.cookie('userid, '123', {expires: 7, path: '/', domain: 'jquery.com', secure: true}); 
/// 注意：如果去掉后面{}的参数，新建后将以默认设置生效。 

/// 删除cookie，即把对应cookie值置为null，代码如下：
/// $.cookie('userid', null); 

/// 读取cookie，如读取变量名为userid的cookie值，代码如下：
/// var uId = $.cookie('userid');

jQuery.cookie = function(name, value, options) {
    if (typeof value != 'undefined') {
        options = options || {};
        if (value === null) {
            value = '';
            options = $.extend({},
            options);
            options.expires = -1;
        }
        var expires = '';
        if (options.expires && (typeof options.expires == 'number' || options.expires.toUTCString)) {
            var date;
            if (typeof options.expires == 'number') {
                date = new Date();
                date.setTime(date.getTime() + (options.expires * 24 * 60 * 60 * 1000));
            } else {
                date = options.expires;
            }
            expires = '; expires=' + date.toUTCString();
        }
        var path = options.path ? '; path=' + (options.path) : '';
        var domain = options.domain ? '; domain=' + (options.domain) : '';
        var secure = options.secure ? '; secure': '';
        document.cookie = [name, '=', encodeURIComponent(value), expires, path, domain, secure].join('');
    } else {
        var cookieValue = null;
        if (document.cookie && document.cookie != '') {
            var cookies = document.cookie.split(';');
            for (var i = 0; i < cookies.length; i++) {
                var cookie = jQuery.trim(cookies[i]);
                if (cookie.substring(0, name.length + 1) == (name + '=')) {
                    cookieValue = decodeURIComponent(cookie.substring(name.length + 1));
                    break;
                }
            }
        }
        return cookieValue;
    }
};