﻿<%
Class Cls_Pager
    Private oConn
    Private sTableName, sPKey, sFields, sOrderBy
    Private sSql, sSqlString, aCondition(), sTempWhere
    Private iPage, iPageSize, iPageCount, iRecordCount, sPage, sPageCount, sRecordCount
    Private sVersion, bShowError, bDistinct
    Private sPageInfo, sPageParam, iPagerSize, iCurrentPageSize, sReWrite, iTableKind
    Private sFirstPage, sPreviewPage, sCurrentPage, sListPage, sNextPage, sLastPage
    Private iPagerTop, iPagerGroup
    Private sUrl, sQueryString, x, y, sSpaceMark

    Private Sub Class_Initialize()
        ReDim aCondition( -1)
        sVersion = "Ver: 1.09 Build: 090322"
        sPKey = "ID"
        sFields = "*"
        sTempWhere = ""
        sOrderBy = ""
        sSqlString = ""
        iPageSize = 20
        iPage = 1
        iRecordCount = Null
        iPageCount = Null
        bShowError = True
        bDistinct = False
        iPagerTop = 0
        sPage = "{$Kin_Page}"
        sPageCount = "{$Kin_PageCount}"
        sRecordCount = "{$Kin_RecordCount}"
        sPageInfo = "<span class=""disabled"">共有 {$Kin_RecordCount} 条记录</span><span class=""disabled"">页次:{$Kin_Page}/{$Kin_PageCount}</span>"
        sPageParam = "page"
        setPageParam(sPageParam)
        iTableKind = 0
        iPagerSize = 7
        sFirstPage = "首　页"
        sPreviewPage = "上一页"
        sCurrentPage = "{$CurrentPage}"
        sListPage = "{$ListPage}"
        sNextPage = "下一页"
        sLastPage = "尾　页"
        sSpaceMark = ""
    End Sub

    Private Sub Class_Terminate()
        Set oConn = Nothing
    End Sub

    Private Function Bint(sValue)
        On Error Resume Next
        Bint = 0
        Bint = Fix(CDbl(sValue))
    End Function

    Private Function IsBlank(byref TempVar)
        IsBlank = False
        Select Case VarType(TempVar)
            Case 0, 1
                IsBlank = True
            Case 8
                If Len(TempVar) = 0 Then
                    IsBlank = True
                End If
            Case 9
                tmpType = TypeName(TempVar)
                If (tmpType = "Nothing") Or (tmpType = "Empty") Then
                    IsBlank = True
                End If
            Case 8192, 8204, 8209
                If UBound(TempVar) = -1 Then
                    IsBlank = True
                End If
        End Select
    End Function

    Public Sub doError(s)
        On Error Resume Next
        If Not bShowError Then Exit Sub
        Dim nRnd
        Randomize()
        nRnd = CLng(Rnd() * 29252888)
        With Response
            .Clear
            .Expires = 0
            .Write "<br />"
            .Write "<div style=""width:100%; font-size:12px; cursor:pointer;line-height:150%"">"
            .Write "<label onClick=""ERRORDIV" & nRnd & ".style.display=(ERRORDIV" & nRnd & ".style.display=='none'?'':'none')"">"
            .Write "<span style=""background-color:820222;color:#FFFFFF;height:23px;font-size:14px;"">〖 ERROR 〗</span><br />"
            .Write "</label>"
            .Write "<div id=""ERRORDIV" & nRnd & """ style=""width:100%;border:1px solid #820222;padding:5px;overflow:hidden;"">"
            .Write "<span style=""color:#FF0000;"">Description</span> " & Server.HTMLEncode(s) & "<br />"
            .Write "<span style=""color:#FF0000;"">Version</span> " & sVersion & "<br />"
            .Write "<span style=""color:#FF0000;"">Information</span>"
            .Write "</div>"
            .Write "</div>"
            .Write "<br />"
            .End()
        End With
    End Sub

    Public Function GetSql()
        If Not IsBlank(sSqlString) Then
            getSql = sSqlString
            Exit Function
        End If
        Dim iStart, iEnd
        Call makeWhere()
        iStart = ( iPage - 1 ) * iPageSize
        iEnd = iStart + iPageSize
        GetSql = "Select " & Easp.IIf(bDistinct, "Distinct ", " ") & " Top " & iPage * iPageSize & " " & sFields & " From " & TableFormat(sTableName) & " " & sTempWhere & " " & sOrderBy
    End Function

    Private Sub makeWhere()
        If Not IsBlank(sTempWhere) Then Exit Sub
        If UBound(aCondition)>= 0 Then
            sTempWhere = " Where " & Join(aCondition, " And ")
        End If
    End Sub

    Private Sub CaculateRecordCount()
        On Error Resume Next
        Dim oRs
        If Not IsBlank(sSqlString) Then
            sSql = "Select COUNT(0) From (" & sSqlString & ")"
        Else
            Call makeWhere()
            sSql = "Select COUNT(0) From " & TableFormat(sTableName) & " " & Easp.IIf(IsBlank(sTempWhere), "", sTempWhere)
        End If
        Set oRs = oConn.Execute(sSql)
        If Err Then
            doError Err.Description
        End If
        iRecordCount = oRs.Fields.Item(0).Value
        Set oRs = Nothing
    End Sub

    Private Sub CaculatePageCount()
        If IsNull(iRecordCount) Then CaculateRecordCount()
        If iRecordCount = 0 Then
            iPageCount = 0
            Exit Sub
        End If
        iPageCount = Abs(Int(0 - (iRecordCount / iPageSize)))
    End Sub

    Private Function setPage(n)
        iPage = Bint(n)
        If iPage < 1 Then iPage = 1
    End Function

    Public Sub AddCondition(s)
        If IsBlank(s) Then Exit Sub
        ReDim Preserve aCondition(UBound(aCondition) + 1)
        aCondition(UBound(aCondition)) = s
    End Sub

    Private Function ReWrite(n)
        n = Bint(n)
        If Not IsBlank(sRewrite) Then
            ReWrite = Replace(sReWrite, "*", n)
        Else
            ReWrite = sUrl & Easp.IIf(n>0, n, "")
        End If
    End Function

    Private Function TableFormat(s)
        Select Case iTableKind
            Case 0
                TableFormat = "" & s & ""
            Case 1
                TableFormat = " " & s & " "
        End Select
    End Function

    Public Function OrderIn(s, sOrderIn)
        OrderIn = " "
        If Not IsBlank(s) And Not IsBlank(sOrderIn) Then
            sOrderIn = Replace(sOrderIn, " ", "")
            sOrderIn = Replace(sOrderIn, "'", "")
            sOrderIn = "'" & sOrderIn & "'"
            OrderIn = "Instr(','+CStr(" & sOrderIn & ")+',',','+CStr(" & s & ")+',')"
        End If
        OrderIn = OrderIn & " "
    End Function

    Private Function setPageParam(s)
        sQueryString = ""
        For Each x In Request.QueryString
            If x <> sPageParam Then
                For Each y In Request.QueryString(x)
                    sQueryString = "&" & x & "=" & Server.URLEncode(y) & sQueryString
                Next
            End If
        Next
        sUrl = Request.ServerVariables("URL") & "?" & Easp.IIf(IsBlank(sQueryString), "", Mid(sQueryString, 2) & "&") & sPageParam & "="
    End Function

    Public Property Set ActiveConnection(o)
        Set oConn = o
    End Property

    Public Property Let ConnectionString(s)
        Set oConn = Server.CreateObject("ADODB.Connection")
        oConn.ConnectionString = s
        oConn.Open()
    End Property

    Public Property Let FirstPage(s)
        sFirstPage = s
    End Property

    Public Property Let PreviewPage(s)
        sPreviewPage = s
    End Property

    Public Property Let CurrentPage(s)
        sCurrentPage = s
    End Property

    Public Property Let ListPage(s)
        sListPage = s
    End Property

    Public Property Let NextPage(s)
        sNextPage = s
    End Property

    Public Property Let LastPage(s)
        sLastPage = s
    End Property

    Public Property Let SpaceMark(s)
        sSpaceMark = s
    End Property

    Public Property Let PagerTop(n)
        iPagerTop = Bint(n)
    End Property

    Public Property Let TableName(s)
        sTableName = s
        If InStr(s, "(")>0 Then iTableKind = 1
        If InStr(s, "[")>0 Then iTableKind = 1
        If InStr(s, ".")>0 Then iTableKind = 1
    End Property

    Public Property Let Fields(s)
        sFields = s
    End Property

    Public Property Let PKey(s)
        If Not IsBlank(s) Then sPKey = s
    End Property

    Public Property Let OrderBy(s)
        If Not IsBlank(s) Then sOrderBy = " Order By " & s & " "
    End Property

    Public Property Let PageSize(s)
        iPageSize = Bint(s)
        iPageSize = Easp.IIf(iPageSize<1, 1, iPageSize)
    End Property

    Public Property Let Page(n)
        setPage Bint(n)
    End Property

    Public Property Let AbsolutePage(n)
        setPage Bint(n)
    End Property

    Public Property Let Sql(s)
        sSqlString = s
    End Property

    Public Property Let Distinct(b)
        bDistinct = b
    End Property

    Public Property Let PageParam(s)
        sPageParam = LCase(s)
        If IsBlank(sPageParam) Then sPageParam = "page"
        setPageParam(sPageParam)
    End Property

    Public Property Let PagerSize(n)
        iPagerSize = Bint(n)
    End Property

    Public Property Let ReWritePath(s)
        sReWrite = s
    End Property

    Public Property Let TableKind(n)
        iTableKind = n
    End Property

    Public Property Let PageInfo(s)
        sPageInfo = s
    End Property

    Public Property Get ConnectionString()
        ConnectionString = oConn.ConnectionString
    End Property

    Public Property Get Conn()
        Set Conn = oConn
    End Property

    Public Property Get TableName()
        TableName = sTableName
    End Property

    Public Property Get Fields()
        Fields = sFields
    End Property

    Public Property Get PKey()
        PKey = sPKey
    End Property

    Public Property Get OrderBy()
        OrderBy = sOrderBy
    End Property

    Public Property Get RecordCount()
        If IsNull(iRecordCount) Then CaculateRecordCount()
        RecordCount = iRecordCount
    End Property

    Public Property Get PageSize()
        PageSize = iPageSize
    End Property

    Public Property Get GetWhere()
        If IsBlank(sTempWhere) Then makeWhere()
        GetWhere = sTempWhere
    End Property

    Public Property Get Page()
        Page = iPage
    End Property

    Public Property Get AbsolutePage()
        AbsolutePage = iPage
    End Property

    Public Property Get PageCount()
        If IsNull(iPageCount) Then CaculatePageCount()
        PageCount = iPageCount
    End Property

    Public Property Get CurrentPageSize()
        If IsNull(iRecordCount) Then CaculateRecordCount()
        If IsNull(iPageCount) Then CaculatePageCount()
        CurrentPageSize = Easp.IIf(iRecordCount>0, Easp.IIf(iPage = iPageCount, iRecordCount - (iPage -1) * iPageSize, iPageSize), 0)
    End Property

    Public Property Get RecordSet()
        On Error Resume Next
        sSql = getSql()
        Set RecordSet = Server.CreateObject ("ADODB.RecordSet")
        RecordSet.Open sSql, oConn, 1, 1, &H0001
        RecordSet.PageSize = iPageSize
        If RecordSet.AbsolutePage <> -1 Then
            iPage = Easp.IIf(iPage > RecordSet.PageCount, RecordSet.PageCount, iPage)
            RecordSet.AbsolutePage = iPage
        End If
        If Err Then
            doError Err.Description
            If Not IsBlank(sSql) Then
                Set RecordSet = oConn.Execute(sSql)
                If Err Then doError Err.Description
            Else
                doError Err.Description
            End If
        End If
        Err.Clear()
    End Property

    Public Property Get Version()
        Version = sVersion
    End Property

    Public Property Get PageInfo()
        CaculatePageCount()
        PageInfo = Replace(sPageInfo, sRecordCount, iRecordCount)
        PageInfo = Replace(PageInfo, sPageCount, iPageCount)
        PageInfo = Replace(PageInfo, sPage, iPage)
    End Property

    Public Property Get PageParam()
        PageParam = sPageParam
    End Property

    Public Property Get Pager()
        Dim i, ii, iStart, iEnd
        Pager = ""
        ii = (iPagerSize \ 2)
        iEnd = iPage + ii
        iStart = iPage - (ii + (iPagerSize Mod 2)) + 1
        If iEnd > iPageCount Then
            iEnd = iPageCount
            iStart = iPageCount - iPagerSize + 1
        End If
        If iStart < 1 Then
            iStart = 1
            iEnd = iStart + iPagerSize -1
        End If
        If iEnd > iPageCount Then
            iEnd = iPageCount
        End If

        If iPageCount>0 Then
            If iPage>1 Then
                Pager = Pager & Easp.IIf(IsBlank(sFirstPage), "", "<a href=""" & ReWrite(1) & """>" & sFirstPage & "</a>" & sSpaceMark)
                Pager = Pager & Easp.IIf(IsBlank(sPreviewPage), "", "<a href=""" & ReWrite((iPage -1)) & """>" & sPreviewPage & "</a>" & sSpaceMark)
            Else
                Pager = Pager & Easp.IIf(IsBlank(sFirstPage), "", "<span class=""disabled"">" & sFirstPage & "</span>" & sSpaceMark)
                Pager = Pager & Easp.IIf(IsBlank(sPreviewPage), "", "<span class=""disabled"">" & sPreviewPage & "</span>" & sSpaceMark)
            End If
            If iPagerTop > 0 Then
                If iPagerTop < iStart Then
                    ii = iPagerTop
                Else
                    ii = iStart - 1
                End If
                For i = 1 To ii
                    Pager = Pager & "<a href=""" & ReWrite(i) & """>" & Replace(sListPage, "{$Listpage}", i, 1, -1, 1) & "</a>" & sSpaceMark
                Next
                If iPagerTop < iStart -1 Then Pager = Pager & "..." & sSpaceMark
            End If
            If iPagerSize >0 Then
                For i = iStart To iEnd
                    If i = iPage Then
                        Pager = Pager & "<span class=""disabled"">" & Replace(sCurrentPage, "{$Currentpage}", i, 1, -1, 1) & "</span>" & sSpaceMark
                    Else
                        Pager = Pager & "<a href=""" & ReWrite(i) & """>" & Replace(sListPage, "{$Listpage}", i, 1, -1, 1) & "</a>" & sSpaceMark
                    End If
                Next
            End If
            If iPagerTop > 0 Then
                If iPageCount - iPagerTop > iEnd Then Pager = Pager & "..." & sSpaceMark
                If iPageCount - iPagerTop > iEnd Then
                    ii = iPageCount - iPagerTop + 1
                Else
                    ii = iEnd + 1
                End If
                For i = ii To iPageCount
                    Pager = Pager & "<a href=""" & ReWrite(i) & """>" & Replace(sListPage, "{$Listpage}", i, 1, -1, 1) & "</a>" & sSpaceMark
                Next
            End If
            If iPageCount>iPage Then
                Pager = Pager & Easp.IIf(IsBlank(sNextPage), "", "<a href=""" & ReWrite(iPage + 1) & """>" & sNextPage & "</a>" & sSpaceMark)
                Pager = Pager & Easp.IIf(IsBlank(sLastPage), "", "<a href=""" & ReWrite(iPageCount) & """>" & sLastPage & "</a>" & sSpaceMark)
            Else
                Pager = Pager & Easp.IIf(IsBlank(sNextPage), "", "<span class=""disabled"">" & sNextPage & "</span>" & sSpaceMark)
                Pager = Pager & Easp.IIf(IsBlank(sLastPage), "", "<span class=""disabled"">" & sLastPage & "</span>")
            End If
        End If
    End Property

End Class
%>