﻿<%
Class Cms_Fun

    Public Sub Init()
        SiteConfig()
        GetUserLabel()
        NavList 0
        NavList 1
        NavList 2
        NavList 3
        ClassList 0
        ClassList 1
        ClassList 2
        ClassList 3
        HdpList()
        LinkList()
        About()
        BookList()
        NewsList()
        ProList()
        DownList()
        JobList()
    End Sub

    '================================================================
    ' 装载网站配置
    '================================================================

    Public Sub SiteConfig()
        Dim oRs, i
        Set oRs = Cms.Lib.GetSiteConfig()
        If Not Easp.IsN(oRs) Then
            For i = 0 To oRs.Fields.Count - 1
                Cms.Tpl.AssignTag "{z"&"j"&"j"&"c"&"m"&"s"&":", "}", oRs
            Next
        End If
        Easp.C oRs
        Cms.Tpl.blockTag("{z"&"j"&"j"&"c"&"m"&"s"&":"&"T"&"h"&"e"&"m"&"e"&"P"&"a"&"t"&"h"&"}") = CmsTemplates & CmsTempSkin
        Cms.Tpl.blockTag("{z"&"j"&"j"&"c"&"m"&"s"&":"&"U"&"p"&"N"&"o"&"w"&"S"&"i"&"t"&"e"&"}") = Now()
    End Sub

    '================================================================
    ' 装载自定义标签
    '================================================================

    Public Sub GetUserLabel()
        Dim oRs
        Set oRs = Cms.Lib.GetUserLabel()
        If Not Easp.IsN(oRs) Then
            Do While Not oRs.EOF
                Cms.Tpl.blockTag("{z"&"j"&"j"&"c"&"m"&"s"&"_"&"z"&"d"&"y"&":" & oRs(0) & "}") = oRs(1)
                oRs.MoveNext
            Loop
        End If
        Easp.C oRs
    End Sub

    '================================================================
    ' 装载导航标签
    '================================================================

    Public Sub NavList(ByVal Num)
        Dim strHtml, oRs, Blocks, block, matchs, html, i, ii, tagname
        tagname = "navlist" & Easp.IIf(Num = 0, "", Num)
        Set Blocks = cms.tpl.getBlocks(tagname)
        If CmsFun.ChkNumEric(Blocks.Count) = 0 Then
            Set Blocks = Nothing
            Exit Sub
        End If
        For Each block In Blocks
            Set oRs = Cms.Lib.GetNavList(block.SubMatches(0))
            html = block.SubMatches(1)
            strHtml = ""
            Set Matchs = Easp.RegMatch(html, "\{((?:empty|null|eof|nodata)\:"&tagname&")\s*?(?:[\s\S.]*?)\/?\}(?:([\s\S.]*?)\{/\1\})")
            If Easp.IsN(oRs) Then
                If Matchs.Count > 0 Then
                    strHtml = Matchs(0).SubMatches(1)
                End If
            Else
                If Matchs.Count > 0 Then
                    html = Easp.RegReplace(html, Matchs(0).Value, "")
                End If
            End If
            If Not oRs.EOF Then
                i = 1
                ii = 1
                Do While Not oRs.EOF
                    strHtml = strHtml & html
                    strHtml = Cms.Tpl.Assign(strHtml, tagname, oRs)
                    Cms.Tpl.blockTagd strHtml, tagname & ".url", oRs("UrlLink")
                    Cms.Tpl.blockTagd strHtml, tagname & ".style", CmsFun.ReadCssFontMode(oRs("ColorMode"), oRs("FontMode"))
                    Cms.Tpl.blockTagd strHtml, tagname & ".open", Easp.IIf(oRs("IsNewOpen") = 1, " target=""_blank""", "")
                    Cms.Tpl.blockTagd strHtml, tagname & ".i", i
                    Cms.Tpl.blockTagd strHtml, tagname & ".ii", CmsFun.ZeroFill(ii, 2)
                    i = i + 1
                    ii = ii + 1
                    oRs.MoveNext
                Loop
            End If
            Easp.C oRs
            Cms.Tpl.blockTag(block) = strHtml
        Next
        Set Blocks = Nothing
    End Sub

    '================================================================
    ' 装载分类标签
    '================================================================

    Public Sub ClassList(ByVal Num)
        Dim strHtml, oRs, Blocks, block, matchs, html, i, ii, tagname
        tagname = "classlist" & Easp.IIf(Num = 0, "", Num)
        Set Blocks = cms.tpl.getBlocks(tagname)
        If CmsFun.ChkNumEric(Blocks.Count) = 0 Then
            Set Blocks = Nothing
            Exit Sub
        End If
        For Each block In Blocks
            Set oRs = Cms.Lib.GetClassList(block.SubMatches(0))
            html = block.SubMatches(1)
            strHtml = ""
            Set Matchs = Easp.RegMatch(html, "\{((?:empty|null|eof|nodata)\:"&tagname&")\s*?(?:[\s\S.]*?)\/?\}(?:([\s\S.]*?)\{/\1\})")
            If Easp.IsN(oRs) Then
                If Matchs.Count > 0 Then
                    strHtml = Matchs(0).SubMatches(1)
                End If
            Else
                If Matchs.Count > 0 Then
                    html = Easp.RegReplace(html, Matchs(0).Value, "")
                End If
            End If
            If Not oRs.EOF Then
                i = 1
                ii = 1
                Do While Not oRs.EOF
                    strHtml = strHtml & html
                    strHtml = Cms.Tpl.Assign(strHtml, tagname, oRs)
                    Cms.Tpl.blockTagd strHtml, tagname & ".url", oRs("HtmlFilePath")
                    Cms.Tpl.blockTagd strHtml, tagname & ".i", i
                    Cms.Tpl.blockTagd strHtml, tagname & ".ii", CmsFun.ZeroFill(ii, 2)
                    i = i + 1
                    ii = ii + 1
                    oRs.MoveNext
                Loop
            End If
            Easp.C oRs
            Cms.Tpl.blockTag(block) = strHtml
        Next
        Set Blocks = Nothing
    End Sub

    '================================================================
    ' 装载幻灯片标签
    '================================================================

    Public Sub HdpList()
        Dim strHtml, oRs, Blocks, block, matchs, html, i, ii, tagname
        tagname = "hdp"
        Set Blocks = cms.tpl.getBlocks(tagname)
        If CmsFun.ChkNumEric(Blocks.Count) = 0 Then
            Set Blocks = Nothing
            Exit Sub
        End If
        For Each block In Blocks
            Set oRs = Cms.Lib.GetHdpList(block.SubMatches(0))
            html = block.SubMatches(1)
            strHtml = ""
            Set Matchs = Easp.RegMatch(html, "\{((?:empty|null|eof|nodata)\:"&tagname&")\s*?(?:[\s\S.]*?)\/?\}(?:([\s\S.]*?)\{/\1\})")
            If Easp.IsN(oRs) Then
                If Matchs.Count > 0 Then
                    strHtml = Matchs(0).SubMatches(1)
                End If
            Else
                If Matchs.Count > 0 Then
                    html = Easp.RegReplace(html, Matchs(0).Value, "")
                End If
            End If
            If Not oRs.EOF Then
                i = 1
                ii = 1
                Do While Not oRs.EOF
                    strHtml = strHtml & html
                    strHtml = Cms.Tpl.Assign(strHtml, tagname, oRs)
                    Cms.Tpl.blockTagd strHtml, tagname & ".url", oRs("urllink")
                    Cms.Tpl.blockTagd strHtml, tagname & ".i", i
                    Cms.Tpl.blockTagd strHtml, tagname & ".ii", CmsFun.ZeroFill(ii, 2)
                    i = i + 1
                    ii = ii + 1
                    oRs.MoveNext
                Loop
            End If
            Easp.C oRs
            Cms.Tpl.blockTag(block) = strHtml
        Next
        Set Blocks = Nothing
    End Sub

    '================================================================
    ' 装载友情链接标签
    '================================================================

    Public Sub LinkList()
        Dim strHtml, oRs, Blocks, block, matchs, html, i, ii, tagname
        tagname = "link"
        Set Blocks = cms.tpl.getBlocks(tagname)
        If CmsFun.ChkNumEric(Blocks.Count) = 0 Then
            Set Blocks = Nothing
            Exit Sub
        End If
        For Each block In Blocks
            Set oRs = Cms.Lib.GetLinkList(block.SubMatches(0))
            html = block.SubMatches(1)
            strHtml = ""
            Set Matchs = Easp.RegMatch(html, "\{((?:empty|null|eof|nodata)\:"&tagname&")\s*?(?:[\s\S.]*?)\/?\}(?:([\s\S.]*?)\{/\1\})")
            If Easp.IsN(oRs) Then
                If Matchs.Count > 0 Then
                    strHtml = Matchs(0).SubMatches(1)
                End If
            Else
                If Matchs.Count > 0 Then
                    html = Easp.RegReplace(html, Matchs(0).Value, "")
                End If
            End If
            If Not oRs.EOF Then
                i = 1
                ii = 1
                Do While Not oRs.EOF
                    strHtml = strHtml & html
                    strHtml = Cms.Tpl.Assign(strHtml, tagname, oRs)
                    Cms.Tpl.blockTagd strHtml, tagname & ".i", i
                    Cms.Tpl.blockTagd strHtml, tagname & ".ii", CmsFun.ZeroFill(ii, 2)
                    i = i + 1
                    ii = ii + 1
                    oRs.MoveNext
                Loop
            End If
            Easp.C oRs
            Cms.Tpl.blockTag(block) = strHtml
        Next
        Set Blocks = Nothing
    End Sub

    '================================================================
    ' 装载单页标签
    '================================================================

    Public Sub About()
        Dim strHtml, oRs, Blocks, block, matchs, html, i, ii, tagname
        tagname = "aboutlist"
        Set Blocks = cms.tpl.getBlocks(tagname)
        If CmsFun.ChkNumEric(Blocks.Count) = 0 Then
            Set Blocks = Nothing
            Exit Sub
        End If
        For Each block In Blocks
            Set oRs = Cms.Lib.GetAbout(block.SubMatches(0))
            html = block.SubMatches(1)
            strHtml = ""
            Set Matchs = Easp.RegMatch(html, "\{((?:empty|null|eof|nodata)\:"&tagname&")\s*?(?:[\s\S.]*?)\/?\}(?:([\s\S.]*?)\{/\1\})")
            If Easp.IsN(oRs) Then
                If Matchs.Count > 0 Then
                    strHtml = Matchs(0).SubMatches(1)
                End If
            Else
                If Matchs.Count > 0 Then
                    html = Easp.RegReplace(html, Matchs(0).Value, "")
                End If
            End If
            If Not oRs.EOF Then
                i = 1
                ii = 1
                Do While Not oRs.EOF
                    strHtml = strHtml & html
                    strHtml = Cms.Tpl.Assign(strHtml, tagname, oRs)
                    Cms.Tpl.blockTagd strHtml, tagname & ".url", "/about/" & oRs("htmlfile")
                    Cms.Tpl.blockTagd strHtml, tagname & ".i", i
                    Cms.Tpl.blockTagd strHtml, tagname & ".ii", CmsFun.ZeroFill(ii, 2)
                    i = i + 1
                    ii = ii + 1
                    oRs.MoveNext
                Loop
            End If
            Easp.C oRs
            Cms.Tpl.blockTag(block) = strHtml
        Next
        Set Blocks = Nothing
    End Sub

    '================================================================
    ' 装载留言标签
    '================================================================

    Public Sub BookList()
        Dim strHtml, oRs, Blocks, block, matchs, html, i, ii, tagname
        tagname = "book"
        Set Blocks = cms.tpl.getBlocks(tagname)
        If CmsFun.ChkNumEric(Blocks.Count) = 0 Then
            Set Blocks = Nothing
            Exit Sub
        End If
        For Each block In Blocks
            Set oRs = Cms.Lib.GetBookList(block.SubMatches(0))
            html = block.SubMatches(1)
            strHtml = ""
            Set Matchs = Easp.RegMatch(html, "\{((?:empty|null|eof|nodata)\:"&tagname&")\s*?(?:[\s\S.]*?)\/?\}(?:([\s\S.]*?)\{/\1\})")
            If Easp.IsN(oRs) Then
                If Matchs.Count > 0 Then
                    strHtml = Matchs(0).SubMatches(1)
                End If
            Else
                If Matchs.Count > 0 Then
                    html = Easp.RegReplace(html, Matchs(0).Value, "")
                End If
            End If
            If Not oRs.EOF Then
                i = 1
                ii = 1
                Do While Not oRs.EOF
                    strHtml = strHtml & html
                    strHtml = Cms.Tpl.Assign(strHtml, tagname, oRs)
                    Cms.Tpl.blockTagd strHtml, tagname & ".i", i
                    Cms.Tpl.blockTagd strHtml, tagname & ".ii", CmsFun.ZeroFill(ii, 2)
                    i = i + 1
                    ii = ii + 1
                    oRs.MoveNext
                Loop
            End If
            Easp.C oRs
            Cms.Tpl.blockTag(block) = strHtml
        Next
        Set Blocks = Nothing
    End Sub

    '================================================================
    ' 装载文章列表
    '================================================================

    Public Sub NewsList()
        Dim strHtml, oRs, Blocks, block, matchs, html, i, ii, tagname, StartNum
        tagname = "news"
        Set Blocks = cms.tpl.getBlocks(tagname)
        If CmsFun.ChkNumEric(Blocks.Count) = 0 Then
            Set Blocks = Nothing
            Exit Sub
        End If
        For Each block In Blocks
            Set oRs = Cms.Lib.GetNewsList(block.SubMatches(0))
            StartNum = CmsFun.ChkNumEric(Cms.Tpl.attr(block.SubMatches(0), "start"))
            html = block.SubMatches(1)
            strHtml = ""
            Set Matchs = Easp.RegMatch(html, "\{((?:empty|null|eof|nodata)\:"&tagname&")\s*?(?:[\s\S.]*?)\/?\}(?:([\s\S.]*?)\{/\1\})")
            If Easp.IsN(oRs) Then
                If Matchs.Count > 0 Then
                    strHtml = Matchs(0).SubMatches(1)
                End If
            Else
                If Matchs.Count > 0 Then
                    html = Easp.RegReplace(html, Matchs(0).Value, "")
                End If
            End If
            If Not oRs.EOF Then
                i = Easp.IIf(StartNum > 0, i + StartNum, 1)
                ii = Easp.IIf(StartNum > 0, i + StartNum, 1)
                If StartNum > 0 Then
                    oRs.Move StartNum
                End If
                Do While Not oRs.EOF
                    strHtml = strHtml & html
                    strHtml = ReturnNewsRs(strHtml, tagname, oRs)
                    strHtml = Cms.Tpl.Assign(strHtml, tagname, oRs)
                    Cms.Tpl.blockTagd strHtml, tagname & ".CnName", oRs("CnName")
                    Cms.Tpl.blockTagd strHtml, tagname & ".HtmlFilePath", oRs("HtmlFilePath")
                    Cms.Tpl.blockTagd strHtml, tagname & ".i", i
                    Cms.Tpl.blockTagd strHtml, tagname & ".ii", CmsFun.ZeroFill(ii, 2)
                    i = i + 1
                    ii = ii + 1
                    oRs.MoveNext
                Loop
            End If
            Easp.C oRs
            Cms.Tpl.blockTag(block) = strHtml
        Next
        Set Blocks = Nothing
    End Sub

    '================================================================
    ' 装载产品列表
    '================================================================

    Public Sub ProList()
        Dim strHtml, oRs, Blocks, block, matchs, html, i, ii, tagname, StartNum
        tagname = "pro"
        Set Blocks = cms.tpl.getBlocks(tagname)
        If CmsFun.ChkNumEric(Blocks.Count) = 0 Then
            Set Blocks = Nothing
            Exit Sub
        End If
        For Each block In Blocks
            Set oRs = Cms.Lib.GetProList(block.SubMatches(0))
            StartNum = CmsFun.ChkNumEric(Cms.Tpl.attr(block.SubMatches(0), "start"))
            html = block.SubMatches(1)
            strHtml = ""
            Set Matchs = Easp.RegMatch(html, "\{((?:empty|null|eof|nodata)\:"&tagname&")\s*?(?:[\s\S.]*?)\/?\}(?:([\s\S.]*?)\{/\1\})")
            If Easp.IsN(oRs) Then
                If Matchs.Count > 0 Then
                    strHtml = Matchs(0).SubMatches(1)
                End If
            Else
                If Matchs.Count > 0 Then
                    html = Easp.RegReplace(html, Matchs(0).Value, "")
                End If
            End If
            If Not oRs.EOF Then
                i = Easp.IIf(StartNum > 0, i + StartNum, 1)
                ii = Easp.IIf(StartNum > 0, i + StartNum, 1)
                If StartNum > 0 Then
                    oRs.Move StartNum
                End If
                Do While Not oRs.EOF
                    strHtml = strHtml & html
                    strHtml = ReturnProRs(strHtml, tagname, oRs)
                    strHtml = Cms.Tpl.Assign(strHtml, tagname, oRs)
                    Cms.Tpl.blockTagd strHtml, tagname & ".CnName", oRs("CnName")
                    Cms.Tpl.blockTagd strHtml, tagname & ".HtmlFilePath", oRs("HtmlFilePath")
                    Cms.Tpl.blockTagd strHtml, tagname & ".i", i
                    Cms.Tpl.blockTagd strHtml, tagname & ".ii", CmsFun.ZeroFill(ii, 2)
                    i = i + 1
                    ii = ii + 1
                    oRs.MoveNext
                Loop
            End If
            Easp.C oRs
            Cms.Tpl.blockTag(block) = strHtml
        Next
        Set Blocks = Nothing
    End Sub

    '================================================================
    ' 装载下载列表
    '================================================================

    Public Sub DownList()
        Dim strHtml, oRs, Blocks, block, matchs, html, i, ii, tagname, StartNum
        tagname = "down"
        Set Blocks = cms.tpl.getBlocks(tagname)
        If CmsFun.ChkNumEric(Blocks.Count) = 0 Then
            Set Blocks = Nothing
            Exit Sub
        End If
        For Each block In Blocks
            Set oRs = Cms.Lib.GetDownList(block.SubMatches(0))
            StartNum = CmsFun.ChkNumEric(Cms.Tpl.attr(block.SubMatches(0), "start"))
            html = block.SubMatches(1)
            strHtml = ""
            Set Matchs = Easp.RegMatch(html, "\{((?:empty|null|eof|nodata)\:"&tagname&")\s*?(?:[\s\S.]*?)\/?\}(?:([\s\S.]*?)\{/\1\})")
            If Easp.IsN(oRs) Then
                If Matchs.Count > 0 Then
                    strHtml = Matchs(0).SubMatches(1)
                End If
            Else
                If Matchs.Count > 0 Then
                    html = Easp.RegReplace(html, Matchs(0).Value, "")
                End If
            End If
            If Not oRs.EOF Then
                i = Easp.IIf(StartNum > 0, i + StartNum, 1)
                ii = Easp.IIf(StartNum > 0, i + StartNum, 1)
                If StartNum > 0 Then
                    oRs.Move StartNum
                End If
                Do While Not oRs.EOF
                    strHtml = strHtml & html
                    strHtml = ReturnDownRs(strHtml, tagname, oRs)
                    strHtml = Cms.Tpl.Assign(strHtml, tagname, oRs)
                    Cms.Tpl.blockTagd strHtml, tagname & ".CnName", oRs("CnName")
                    Cms.Tpl.blockTagd strHtml, tagname & ".HtmlFilePath", oRs("HtmlFilePath")
                    Cms.Tpl.blockTagd strHtml, tagname & ".i", i
                    Cms.Tpl.blockTagd strHtml, tagname & ".ii", CmsFun.ZeroFill(ii, 2)
                    i = i + 1
                    ii = ii + 1
                    oRs.MoveNext
                Loop
            End If
            Easp.C oRs
            Cms.Tpl.blockTag(block) = strHtml
        Next
        Set Blocks = Nothing
    End Sub

    '================================================================
    ' 装载招聘列表
    '================================================================

    Public Sub JobList()
        Dim strHtml, oRs, Blocks, block, matchs, html, i, ii, tagname, StartNum
        tagname = "job"
        Set Blocks = cms.tpl.getBlocks(tagname)
        If CmsFun.ChkNumEric(Blocks.Count) = 0 Then
            Set Blocks = Nothing
            Exit Sub
        End If
        For Each block In Blocks
            Set oRs = Cms.Lib.GetJobList(block.SubMatches(0))
            StartNum = CmsFun.ChkNumEric(Cms.Tpl.attr(block.SubMatches(0), "start"))
            html = block.SubMatches(1)
            strHtml = ""
            Set Matchs = Easp.RegMatch(html, "\{((?:empty|null|eof|nodata)\:"&tagname&")\s*?(?:[\s\S.]*?)\/?\}(?:([\s\S.]*?)\{/\1\})")
            If Easp.IsN(oRs) Then
                If Matchs.Count > 0 Then
                    strHtml = Matchs(0).SubMatches(1)
                End If
            Else
                If Matchs.Count > 0 Then
                    html = Easp.RegReplace(html, Matchs(0).Value, "")
                End If
            End If
            If Not oRs.EOF Then
                i = Easp.IIf(StartNum > 0, i + StartNum, 1)
                ii = Easp.IIf(StartNum > 0, i + StartNum, 1)
                If StartNum > 0 Then
                    oRs.Move StartNum
                End If
                Do While Not oRs.EOF
                    strHtml = strHtml & html
                    strHtml = ReturnJobRs(strHtml, tagname, oRs)
                    strHtml = Cms.Tpl.Assign(strHtml, tagname, oRs)
                    Cms.Tpl.blockTagd strHtml, tagname & ".i", i
                    Cms.Tpl.blockTagd strHtml, tagname & ".ii", CmsFun.ZeroFill(ii, 2)
                    i = i + 1
                    ii = ii + 1
                    oRs.MoveNext
                Loop
            End If
            Easp.C oRs
            Cms.Tpl.blockTag(block) = strHtml
        Next
        Set Blocks = Nothing
    End Sub

    '================================================================
    ' 重写文章列表字段
    '================================================================

    Public Function ReturnNewsRs(ByVal sHtml, ByVal TagName, ByVal Rs)
        If LCase(TypeName(Rs)) = "recordset" Then
            Dim ChannelId, PathUrl, iRs
            Dim UrlLink, IsZhiDing, IsTuiJian, IsReMen, Img
            Dim FieldName, FieldVal, FieldNull, FieldNotNull
            ChannelId = 1
            PathUrl = "news"
            '=========================================================================================
            Set iRs = Easp.db.GR(TablePrefix & "Channel:ZhiDing,TuiJian,ReMen,ShowPic:1", " IsField = 1 And id = "& ChannelId &" ", "")
            If Easp.IsN(iRs) Then
                IsZhiDing = "[置顶]"
                IsTuiJian = "[推荐]"
                IsReMen = "[热门]"
                Img = "/images/no_"& PathUrl &"_pic.jpg"
            Else
                IsZhiDing = iRs("ZhiDing")
                IsTuiJian = iRs("TuiJian")
                IsReMen = iRs("ReMen")
                Img = iRs("ShowPic")
            End If
            Easp.db.C iRs
            '=========================================================================================
            UrlLink = CmsFun.HtmlFileUrl(Rs("ViewHtmlPath") & Rs("ViewHtmlPrefix"), Rs("HtmlFile") & "", Rs("Id"))
            Cms.Tpl.blockTagd sHtml, TagName & ".style", CmsFun.ReadCssFontMode(Rs("colormode"), Rs("fontmode"))
            Cms.Tpl.blockTagd sHtml, TagName & ".url", Easp.IIf(Rs("urllink") <> "", Rs("urllink"), UrlLink)
            Cms.Tpl.blockTagd sHtml, TagName & ".urls", Rs("htmlfilepath")
            '=========================================================================================
            If Not Easp.IsN(Rs("imageurl")) Then
                Easp.Use "fso"
                If Easp.Fso.IsFile(rs("imageurl")) Then
                    Cms.Tpl.blockTagd sHtml, TagName & ".img", Rs("imageurl")
                    If Easp.Fso.IsFile(Replace(Rs("imageurl"), ".", "s.")) Then
                        Cms.Tpl.blockTagd sHtml, TagName & ".imgs", Replace(Rs("imageurl"), ".", "s.")
                    Else
                        Cms.Tpl.blockTagd sHtml, TagName & ".imgs", Rs("imageurl")
                    End If
                Else
                    Cms.Tpl.blockTagd sHtml, TagName & ".img", Img
                    Cms.Tpl.blockTagd sHtml, TagName & ".imgs", Img
                End If
            Else
                Cms.Tpl.blockTagd sHtml, TagName & ".img", Img
                Cms.Tpl.blockTagd sHtml, TagName & ".imgs", Img
            End If
            '=========================================================================================
            Cms.Tpl.blockTagd sHtml, TagName & ".zhiding", Easp.IIf(CmsFun.ChkNumEric(Rs("dataistop"))> 0, IsZhiDing, "")
            Cms.Tpl.blockTagd sHtml, TagName & ".tuijian", Easp.IIf(CmsFun.ChkNumEric(Rs("dataisbest"))> 0, IsTuiJian, "")
            Cms.Tpl.blockTagd sHtml, TagName & ".remen", Easp.IIf(CmsFun.ChkNumEric(Rs("dataishot"))> 0, IsReMen, "")
            '========================================================================================= 自定义字段
            Set iRs = Easp.db.GR(TablePrefix & "Field:FieldName,FieldType,FieldNull,FieldNotNull", " Channel = "& ChannelId &" ", "")
            If Not Easp.IsN(iRs) Then
                Do While Not iRs.EOF
                    FieldName = LCase(Trim(iRs("FieldName")))
                    FieldNull = Trim(iRs("FieldNull"))
                    FieldNotNull = Trim(iRs("FieldNotNull"))
                    If iRs("FieldType") = 4 Then
                        FieldVal = CmsFun.ChkNumEric(Rs(FieldName))
                        Cms.Tpl.blockTagd sHtml, TagName & "." & FieldName, Easp.IIf(FieldVal > 0, Rs(FieldName), FieldNull)
                    ElseIf iRs("FieldType") = 7 Then
                        FieldVal = CmsFun.ChkNumEric(Rs(FieldName))
                        Cms.Tpl.blockTagd sHtml, TagName & "." & FieldName, Easp.IIf(FieldVal > 0, FieldNotNull, FieldNull)
                    Else
                        Cms.Tpl.blockTagd sHtml, TagName & "." & FieldName, Easp.IIf(Not Easp.IsN(Rs(FieldName)), Rs(FieldName), FieldNull)
                    End If
                    iRs.MoveNext
                Loop
            End If
            Easp.db.C iRs
            '=========================================================================================
        End If
        ReturnNewsRs = sHtml
    End Function

    '================================================================
    ' 重写产品列表字段
    '================================================================

    Public Function ReturnProRs(ByVal sHtml, ByVal TagName, ByVal Rs)
        If LCase(TypeName(rs)) = "recordset" Then
            Dim ChannelId, PathUrl, iRs
            Dim UrlLink, IsZhiDing, IsTuiJian, IsReMen, Img
            Dim FieldName, FieldNull, FieldNotNull
            ChannelId = 2
            PathUrl = "pro"
            '=========================================================================================
            Set iRs = Easp.db.GR(TablePrefix & "Channel:ZhiDing,TuiJian,ReMen,ShowPic:1", " IsField = 1 And id = "& ChannelId &" ", "")
            If Easp.IsN(iRs) Then
                IsZhiDing = "[置顶]"
                IsTuiJian = "[推荐]"
                IsReMen = "[热门]"
                Img = "/images/no_"& PathUrl &"_pic.jpg"
            Else
                IsZhiDing = iRs("ZhiDing")
                IsTuiJian = iRs("TuiJian")
                IsReMen = iRs("ReMen")
                Img = iRs("ShowPic")
            End If
            Easp.db.C iRs
            '=========================================================================================
            UrlLink = CmsFun.HtmlFileUrl(Rs("ViewHtmlPath") & Rs("ViewHtmlPrefix"), Rs("HtmlFile") & "", Rs("Id"))
            Cms.Tpl.blockTagd sHtml, TagName & ".style", CmsFun.ReadCssFontMode(Rs("colormode"), Rs("fontmode"))
            Cms.Tpl.blockTagd sHtml, TagName & ".url", Easp.IIf(Rs("urllink") <> "", Rs("urllink"), UrlLink)
            Cms.Tpl.blockTagd sHtml, TagName & ".urls", Rs("htmlfilepath")
            '=========================================================================================
            If Not Easp.IsN(Rs("imageurl")) Then
                Easp.Use "fso"
                If Easp.Fso.IsFile(rs("imageurl")) Then
                    Cms.Tpl.blockTagd sHtml, TagName & ".img", Rs("imageurl")
                    If Easp.Fso.IsFile(Replace(Rs("imageurl"), ".", "s.")) Then
                        Cms.Tpl.blockTagd sHtml, TagName & ".imgs", Replace(Rs("imageurl"), ".", "s.")
                    Else
                        Cms.Tpl.blockTagd sHtml, TagName & ".imgs", Rs("imageurl")
                    End If
                Else
                    Cms.Tpl.blockTagd sHtml, TagName & ".img", Img
                    Cms.Tpl.blockTagd sHtml, TagName & ".imgs", Img
                End If
            Else
                Cms.Tpl.blockTagd sHtml, TagName & ".img", Img
                Cms.Tpl.blockTagd sHtml, TagName & ".imgs", Img
            End If
            '=========================================================================================
            Cms.Tpl.blockTagd sHtml, TagName & ".zhiding", Easp.IIf(CmsFun.ChkNumEric(Rs("dataistop"))> 0, IsZhiDing, "")
            Cms.Tpl.blockTagd sHtml, TagName & ".tuijian", Easp.IIf(CmsFun.ChkNumEric(Rs("dataisbest"))> 0, IsTuiJian, "")
            Cms.Tpl.blockTagd sHtml, TagName & ".remen", Easp.IIf(CmsFun.ChkNumEric(Rs("dataishot"))> 0, IsReMen, "")
            '========================================================================================= 自定义字段
            Set iRs = Easp.db.GR(TablePrefix & "Field:FieldName,FieldType,FieldNull,FieldNotNull", " Channel = "& ChannelId &" ", "")
            If Not Easp.IsN(iRs) Then
                Do While Not iRs.EOF
                    FieldName = LCase(Trim(iRs("FieldName")))
                    FieldNull = Trim(iRs("FieldNull"))
                    FieldNotNull = Trim(iRs("FieldNotNull"))
                    If iRs("FieldType") = 4 Then
                        FieldVal = CmsFun.ChkNumEric(Rs(FieldName))
                        Cms.Tpl.blockTagd sHtml, TagName & "." & FieldName, Easp.IIf(FieldVal > 0, Rs(FieldName), FieldNull)
                    ElseIf iRs("FieldType") = 7 Then
                        FieldVal = CmsFun.ChkNumEric(Rs(FieldName))
                        Cms.Tpl.blockTagd sHtml, TagName & "." & FieldName, Easp.IIf(FieldVal > 0, FieldNotNull, FieldNull)
                    Else
                        Cms.Tpl.blockTagd sHtml, TagName & "." & FieldName, Easp.IIf(Not Easp.IsN(Rs(FieldName)), Rs(FieldName), FieldNull)
                    End If
                    iRs.MoveNext
                Loop
            End If
            Easp.db.C iRs
            '=========================================================================================
        End If
        ReturnProRs = sHtml
    End Function

    '================================================================
    ' 重写下载列表字段
    '================================================================

    Public Function ReturnDownRs(ByVal sHtml, ByVal TagName, ByVal Rs)
        If LCase(TypeName(rs)) = "recordset" Then
            Dim ChannelId, PathUrl, iRs
            Dim UrlLink, IsZhiDing, IsTuiJian, IsReMen, Img
            Dim FieldName, FieldNull, FieldNotNull
            ChannelId = 3
            PathUrl = "down"
            '=========================================================================================
            Set iRs = Easp.db.GR(TablePrefix & "Channel:ZhiDing,TuiJian,ReMen,ShowPic:1", " IsField = 1 And id = "& ChannelId &" ", "")
            If Easp.IsN(iRs) Then
                IsZhiDing = "[置顶]"
                IsTuiJian = "[推荐]"
                IsReMen = "[热门]"
                Img = "/images/no_"& PathUrl &"_pic.jpg"
            Else
                IsZhiDing = iRs("ZhiDing")
                IsTuiJian = iRs("TuiJian")
                IsReMen = iRs("ReMen")
                Img = iRs("ShowPic")
            End If
            Easp.db.C iRs
            '=========================================================================================
            UrlLink = CmsFun.HtmlFileUrl(Rs("ViewHtmlPath") & Rs("ViewHtmlPrefix"), Rs("HtmlFile") & "", Rs("Id"))
            Cms.Tpl.blockTagd sHtml, TagName & ".style", CmsFun.ReadCssFontMode(Rs("colormode"), Rs("fontmode"))
            Cms.Tpl.blockTagd sHtml, TagName & ".url", Easp.IIf(Rs("urllink") <> "", Rs("urllink"), UrlLink)
            Cms.Tpl.blockTagd sHtml, TagName & ".urls", Rs("htmlfilepath")
            '=========================================================================================
            If Not Easp.IsN(Rs("imageurl")) Then
                Easp.Use "fso"
                If Easp.Fso.IsFile(rs("imageurl")) Then
                    Cms.Tpl.blockTagd sHtml, TagName & ".img", Rs("imageurl")
                    If Easp.Fso.IsFile(Replace(Rs("imageurl"), ".", "s.")) Then
                        Cms.Tpl.blockTagd sHtml, TagName & ".imgs", Replace(Rs("imageurl"), ".", "s.")
                    Else
                        Cms.Tpl.blockTagd sHtml, TagName & ".imgs", Rs("imageurl")
                    End If
                Else
                    Cms.Tpl.blockTagd sHtml, TagName & ".img", Img
                    Cms.Tpl.blockTagd sHtml, TagName & ".imgs", Img
                End If
            Else
                Cms.Tpl.blockTagd sHtml, TagName & ".img", Img
                Cms.Tpl.blockTagd sHtml, TagName & ".imgs", Img
            End If
            '=========================================================================================
            Cms.Tpl.blockTagd sHtml, TagName & ".zhiding", Easp.IIf(CmsFun.ChkNumEric(Rs("dataistop"))> 0, IsZhiDing, "")
            Cms.Tpl.blockTagd sHtml, TagName & ".tuijian", Easp.IIf(CmsFun.ChkNumEric(Rs("dataisbest"))> 0, IsTuiJian, "")
            Cms.Tpl.blockTagd sHtml, TagName & ".remen", Easp.IIf(CmsFun.ChkNumEric(Rs("dataishot"))> 0, IsReMen, "")
            '========================================================================================= 自定义字段
            Set iRs = Easp.db.GR(TablePrefix & "Field:FieldName,FieldType,FieldNull,FieldNotNull", " Channel = "& ChannelId &" ", "")
            If Not Easp.IsN(iRs) Then
                Do While Not iRs.EOF
                    FieldName = LCase(Trim(iRs("FieldName")))
                    FieldNull = Trim(iRs("FieldNull"))
                    FieldNotNull = Trim(iRs("FieldNotNull"))
                    If iRs("FieldType") = 4 Then
                        FieldVal = CmsFun.ChkNumEric(Rs(FieldName))
                        Cms.Tpl.blockTagd sHtml, TagName & "." & FieldName, Easp.IIf(FieldVal > 0, Rs(FieldName), FieldNull)
                    ElseIf iRs("FieldType") = 7 Then
                        FieldVal = CmsFun.ChkNumEric(Rs(FieldName))
                        Cms.Tpl.blockTagd sHtml, TagName & "." & FieldName, Easp.IIf(FieldVal > 0, FieldNotNull, FieldNull)
                    Else
                        Cms.Tpl.blockTagd sHtml, TagName & "." & FieldName, Easp.IIf(Not Easp.IsN(Rs(FieldName)), Rs(FieldName), FieldNull)
                    End If
                    iRs.MoveNext
                Loop
            End If
            Easp.db.C iRs
            '=========================================================================================
        End If
        ReturnDownRs = sHtml
    End Function

    '================================================================
    ' 重写人才招聘列表字段
    '================================================================

    Public Function ReturnJobRs(ByVal sHtml, ByVal TagName, ByVal Rs)
        If TypeName(rs) = "Recordset" Then
            Dim ChannelId, PathUrl, iRs
            Dim IsZhiDing, IsTuiJian, IsReMen, Img
            Dim FieldName, FieldNull, FieldNotNull
            ChannelId = 4
            PathUrl = "job"
            '=========================================================================================
            Set iRs = Easp.db.GR(TablePrefix & "Channel:ZhiDing,TuiJian,ReMen,ShowPic:1", " IsField = 1 And id = "& ChannelId &" ", "")
            If Easp.IsN(iRs) Then
                IsZhiDing = "[置顶]"
                IsTuiJian = "[推荐]"
                IsReMen = "[热门]"
                Img = "/images/no_"& PathUrl &"_pic.jpg"
            Else
                IsZhiDing = iRs("ZhiDing")
                IsTuiJian = iRs("TuiJian")
                IsReMen = iRs("ReMen")
                Img = iRs("ShowPic")
            End If
            Easp.db.C iRs
            '=========================================================================================
            Cms.Tpl.blockTagd sHtml, TagName & ".style", CmsFun.ReadCssFontMode(Rs("colormode"), Rs("fontmode"))
            '=========================================================================================
            Cms.Tpl.blockTagd sHtml, TagName & ".zhiding", Easp.IIf(CmsFun.ChkNumEric(Rs("dataistop"))> 0, IsZhiDing, "")
            Cms.Tpl.blockTagd sHtml, TagName & ".tuijian", Easp.IIf(CmsFun.ChkNumEric(Rs("dataisbest"))> 0, IsTuiJian, "")
            Cms.Tpl.blockTagd sHtml, TagName & ".remen", Easp.IIf(CmsFun.ChkNumEric(Rs("dataishot"))> 0, IsReMen, "")
            '========================================================================================= 自定义字段
            Set iRs = Easp.db.GR(TablePrefix & "Field:FieldName,FieldType,FieldNull,FieldNotNull", " Channel = "& ChannelId &" ", "")
            If Not Easp.IsN(iRs) Then
                Do While Not iRs.EOF
                    FieldName = LCase(Trim(iRs("FieldName")))
                    FieldNull = Trim(iRs("FieldNull"))
                    FieldNotNull = Trim(iRs("FieldNotNull"))
                    If iRs("FieldType") = 4 Then
                        FieldVal = CmsFun.ChkNumEric(Rs(FieldName))
                        Cms.Tpl.blockTagd sHtml, TagName & "." & FieldName, Easp.IIf(FieldVal > 0, Rs(FieldName), FieldNull)
                    ElseIf iRs("FieldType") = 7 Then
                        FieldVal = CmsFun.ChkNumEric(Rs(FieldName))
                        Cms.Tpl.blockTagd sHtml, TagName & "." & FieldName, Easp.IIf(FieldVal > 0, FieldNotNull, FieldNull)
                    Else
                        Cms.Tpl.blockTagd sHtml, TagName & "." & FieldName, Easp.IIf(Not Easp.IsN(Rs(FieldName)), Rs(FieldName), FieldNull)
                    End If
                    iRs.MoveNext
                Loop
            End If
            Easp.db.C iRs
            '=========================================================================================
        End If
        ReturnJobRs = sHtml
    End Function

End Class
%>