﻿<!--#include file="../../Inc/Cls_Main.Asp"-->
<!--#include file="../../Inc/Cms/Cms.Asp"-->
<!--#include file="../inc/Cls_Admin.Asp"-->
<!--#include file="../inc/Cls_MapPath.Asp"-->
<!--#include file="../Admin_Check.Asp"-->
<%
Server.ScriptTimeOut = 2147483647
'=============================================================================
Dim CmsAdmin
'=============================================================================
Set CmsAdmin = New Cls_Admin
CmsAdmin.SetAdminTitle = CmsSiteName & " > 生成Html管理"
CmsAdmin.SetIncHtmlFile = ""
CmsAdmin.SetBodyCssName = "htmlbody"
CmsAdmin.SetAdminPath = "../"
CmsAdmin.LoadHead()
'=============================================================================
Dim Action
'=============================================================================
Action = Easp.Get("action:s")
Select Case Action
    Case "index"
        Call IndexHtml()
    Case "all"
        Call AllHtml()
        '=====================================================================
    Case "about"
        Call HtmlAbout()
    Case "map"
        Call MapXml()
        '=====================================================================
    Case "user"
        Call HtmlUserTpl()
        '=====================================================================
    Case "news"
        Call News()
    Case "newscontent"
        Call NewsContent()
    Case "newsindex"
        Call NewsIndex()
    Case "newslist"
        Call NewsList()
        '=====================================================================
    Case "pro"
        Call Pro()
    Case "procontent"
        Call ProContent()
    Case "proindex"
        Call ProIndex()
    Case "prolist"
        Call ProList()
        '=====================================================================
    Case "down"
        Call Down()
    Case "downcontent"
        Call DownContent()
    Case "downindex"
        Call DownIndex()
    Case "downlist"
        Call DownList()
        '=====================================================================
    Case "jobindex"
        Call JobIndex()
        '======================================================================
End Select
Set Cms = Nothing
Set CmsAdmin = Nothing

Sub AllHtml()
    MapXml()
    IndexHtml()
    HtmlAbout()
    HtmlUserTpl()
    '=========================================================================
    News()
    Pro()
    Down()
    Job()
    '=========================================================================
    ShowHtml "一键生成全站完毕,完成时间："& Now() &"!"
End Sub

Sub News()
    If ChannelNewsIsHtml = 1 Then
        NewsIndex()
        NewsList()
        NewsContent()
        ShowHtml "文章频道生成完毕,完成时间："& Now() &"!"
    Else
        ShowHtml "文章频道关闭中，无法生成!"
    End If
End Sub

Sub Pro()
    If ChannelProIsHtml = 1 Then
        ProIndex()
        ProList()
        ProContent()
        ShowHtml "产品频道生成完毕,完成时间："& Now() &"!"
    Else
        ShowHtml "产品频道关闭中，无法生成!"
    End If
End Sub

Sub Down()
    If ChannelDownIsHtml = 1 Then
        DownIndex()
        DownList()
        DownContent()
        ShowHtml "下载频道生成完毕,完成时间："& Now() &"!"
    Else
        ShowHtml "下载频道关闭中，无法生成!"
    End If
End Sub

Sub Job()
    If ChannelJobIsHtml = 1 Then
        JobIndex()
        ShowHtml "招聘频道生成完毕,完成时间："& Now() &"!"
    Else
        ShowHtml "招聘频道关闭中，无法生成!"
    End If
End Sub

'============================================================================= 生成首页
' 通用生成不带分页的函数

Function PublicCreateHtml(ByVal PageId, ByVal ChannelId, ByVal TempFile, ByVal CreateTitle, ByVal CreateFile)
    Dim TempFilePath, i
    TempFilePath = CmsTemplates & CmsTempSkin & TempFile
    Easp.Use "fso"
    If Easp.Fso.IsFile(TempFilePath) Then
        Cms.Tpl.Path = CmsTemplates & CmsTempSkin
        Cms.Tpl.File = TempFile
        If Not Easp.IsN(PageId) Then
            Cms.Tpl.d("PageId") = PageId
        End If
        If Not Easp.IsN(PageId) Then
            Cms.Tpl.d("ChannelId") = ChannelId
        End If
        Cms.Fun.Init()
        Cms.Tpl.SaveAs = CreateFile
        '==========================================================================
        i = 1
        ErrHtml 1, 1, ","& CreateTitle &"：<a href="""& CreateFile &""" target=""_blank"">"& CreateFile &"</a>,生成成功,"& Now() &"!"
    Else
        i = 0
        ErrHtml 1, 0, ",生成"& CreateTitle &"失败,模版文件："& TempFilePath &",未找到!"
    End If
    PublicCreateHtml = i
End Function

'============================================================================= 生成robots.txt文件

Sub RobotsTxt()
    Dim TempFile, TempFilePath, RobotsFile
    TempFile = "robots.txt"
    TempFilePath = CmsTemplates & TempFile
    Easp.Use "fso"
    If Easp.Fso.IsFile(TempFilePath) Then
        RobotsFile = Easp.Fso.Read(TempFilePath)
        RobotsFile = Replace(RobotsFile & "", "{$SiteUrl}", CmsSiteUrl)
        Easp.Fso.CreateFile CmsSiteDir & TempFile, RobotsFile
        '==========================================================================
        ErrHtml 1, 1, ",robots.txt文件生成成功,完成时间："& Now() &"!"
    Else
        ErrHtml 1, 0, ",生成robots.txt失败,模版文件："& TempFilePath &",未找到!"
    End If
End Sub

'============================================================================= 生成首页

Sub IndexHtml()
    PublicCreateHtml "index", "", TplIndexFile, "网站首页", "/index.html"
End Sub

'============================================================================= 生成地图

Sub MapXml()
    RobotsTxt()
    CreateBaiduMap()
    CreateGoogleMap()
    CreateSiteMap()
End Sub

Sub CreateSiteMap()
    PublicCreateHtml "sitemap", "", TplMapHtmlFile, "网站地图", "/sitemap/index.html"
End Sub

Sub CreateBaiduMap()
    PublicCreateHtml "baidumap", "", TplBaiduMapFile, "百度地图", "/baidu.xml"
End Sub

Sub CreateGoogleMap()
    PublicCreateHtml "googlemap", "", TplGoogleMapFile, "谷歌地图", "/google.xml"
End Sub

'============================================================================= 生成单页

Sub HtmlAbout()
    Dim HtmlFile, TempFile, TotalNumber, TakeCount, i
    HtmlFile = ChannelAboutHtml
    Dim oRs, TempWhere, id
    TempWhere = " 1 = 1 "
    id = Easp.Get("id:n:0")
    If id > 0 Then
        TempWhere = TempWhere & " And id = "& id &" "
    End If
    Set oRs = Easp.db.GR(TablePrefix & "About", TempWhere, " id desc ")
    If Easp.IsN(oRs) Then
        ErrHtml 0, 0, ",生成单页失败,未找到数据!"
    Else
        TotalNumber = Easp.db.RT(TablePrefix & "About", TempWhere, "Count(0)")
        Easp.Fso.CreateFolder HtmlFile
        Do While Not oRs.EOF
            TakeCount = TakeCount + 1
            If Not Easp.IsN(oRs("TemplateView")) Then
                If Easp.Fso.IsFile(CmsTemplates & CmsTempSkin & oRs("TemplateView")) Then
                    '==========================================================================
                    TempFile = ""
                    TempFile = oRs("TemplateView")
                    '==========================================================================
                    Cms.Tpl.Path = CmsTemplates & CmsTempSkin
                    Cms.Tpl.File = TempFile
                    Cms.Tpl.dFields oRs
                    Cms.Tpl.d("PageId") = oRs("Id")
                    Cms.Tpl.d("PageTitle") = oRs("Title")
                    Cms.Tpl.d("PageContent") = oRs("Content")
                    Cms.Fun.Init()
                    Cms.Tpl.SaveAs = HtmlFile & oRs("HtmlFile")
                End If
            End If
            '==========================================================================
            MsgHtml TotalNumber, TakeCount, "生成单页"& oRs("Title") &"成功"
            oRs.MoveNext
        Loop
        If TakeCount = TotalNumber Then
            ErrHtml TotalNumber, TakeCount, "，所有单页生成完毕,"& Now() &"!"
        End If
        '==========================================================================
    End If
    Easp.db.C oRs
End Sub

'============================================================================= 生成自定义模版

Sub HtmlUserTpl()
    Dim HtmlFile, TempFile, TempFilePath, TotalNumber, TakeCount, i
    '==========================================================================
    Dim oRs, TempWhere, id
    TempWhere = " 1 = 1 "
    id = Easp.Get("id:n:0")
    If id > 0 Then
        TempWhere = TempWhere & " And id = "& id &" "
    End If
    Set oRs = Easp.db.GR(TablePrefix & "Template", TempWhere, " id desc ")
    If Easp.IsN(oRs) Then
        ErrHtml 0, 0, ",生成自定义模版失败,未找到数据!"
    Else
        TotalNumber = Easp.db.RT(TablePrefix & "Template", TempWhere, "Count(0)")
        Easp.Fso.CreateFolder HtmlFile
        Do While Not oRs.EOF
            TakeCount = TakeCount + 1
            TempFile = CmsTemplates & CmsTempSkin & oRs("TempPath")
            If Easp.IsN(oRs("DirPath")) Then
                HtmlFile = CmsSiteDir & oRs("HtmlFile")
            Else
                HtmlFile = oRs("DirPath") & oRs("HtmlFile")
            End If
            Easp.Use "fso"
            If Easp.Fso.IsFile(TempFile) Then
                Easp.Fso.CreateFolder oRs("DirPath")
                '==========================================================================
                Cms.Tpl.Path = CmsTemplates & CmsTempSkin
                Cms.Tpl.File = oRs("TempPath")
                Cms.Tpl.dFields oRs
                Cms.Tpl.d("PageId") = oRs("Id")
                Cms.Tpl.d("PageTitle") = oRs("Title")
                Cms.Fun.Init()
                Cms.Tpl.SaveAs = HtmlFile
                MsgHtml TotalNumber, TakeCount, "生成自定义页"& oRs("Title") &"成功"
            Else
                '==========================================================================
                MsgHtml TotalNumber, TakeCount, "生成自定义页"& oRs("Title") &"失败,模版文件："& TempFile &",未找到"
            End If
            oRs.MoveNext
        Loop
        If TakeCount = TotalNumber Then
            ErrHtml TotalNumber, TakeCount, "，所有自定义模版生成完毕,"& Now() &"!"
        End If
        '==========================================================================
    End If
    Easp.db.C oRs
End Sub

Sub PublicCreateContent(ByVal IsChannelHtml, ByVal ChannelId, ByVal ChannelTitle, ByVal ChannelTagName, ByVal ChannelTabName)
    If IsChannelHtml = 1 Then
        Dim ClassId, NewNum, StartTime, EndTime, Id, TotalNumber, TakeCount
        Dim TempFile, i, HtmlPath, HtmlFile
        TempFile = ""
        '==========================================================================
        IsHtmlError ChannelTitle & "频道", ChannelId
        '==========================================================================
        Easp.WF "<script type=""text/javascript"">" & vbCrLf
        Easp.WF "parent.$('#planmain').show();" & vbCrLf
        Easp.WF "parent.$('#plantext').show();" & vbCrLf
        Easp.WF "</script>" & vbCrLf
        '==========================================================================
        ClassId = Easp.Get("ClassId:n:0")
        NewNum = Easp.Get("NewNum:n:0")
        StartTime = Easp.Get("StartTime:s")
        EndTime = Easp.Get("EndTime:s")
        Id = Easp.Get("Id:s")
        TotalNumber = Easp.Get("totalnumber:n:0")
        TakeCount = Easp.Get("takecount:n:0")
        '==========================================================================
        Dim oRs, iRs, oSQL, FieldStr, TopStr, WhereStr
        WhereStr = ""
        FieldStr = "a.*,b.ChannelId,b.Picture,b.CnName,b.HtmlFilePath,"
        FieldStr = FieldStr & "b.ViewHtmlPath,b.TemplateView,b.ViewHtmlPrefix,b.MarkVal,b.Pid,b.ChildId,b.ChildIdAll"
        If NewNum > 0 Then
            TopStr = " Top "& NewNum &" "
        End If
        oSQL = "Select "& TopStr & FieldStr &" From "
        WhereStr = WhereStr & " ["& TablePrefix & ChannelTabName & "] a Left Join ["& TablePrefix &"Type] b On a.ClassId = b.Id "
        WhereStr = WhereStr & " Where b.ChannelId = "& ChannelId &" And  b.TemplateView <> '' "
        '========================================================================== 条件
        If ClassId > 0 Then
            WhereStr = WhereStr & " And a.ClassId = "& ClassId &" "
        End If
        If Id <> "" Then
            WhereStr = WhereStr & " And a.Id In("& Id &") "
        End If
        If StartTime <> "" And EndTime <> "" Then
            If DateDiff("d", StartTime, EndTime)>= 0 Then
                WhereStr = WhereStr & " And DateDiff('d','"& StartTime &"',a.UpTime)>=0 And DateDiff('d','"& EndTime &"',a.UpTime)<=0 "
            Else
                WhereStr = WhereStr & " And DateDiff('d','"& EndTime &"',a.UpTime)>=0 And DateDiff('d','"& StartTime &"',a.UpTime)<=0 "
            End If
        End If
        oSQL = oSQL & WhereStr & " Order By a.UpTime Desc,a.id Desc "
        '==========================================================================
        If NewNum > 0 Then
            TotalNumber = NewNum
        Else
            Set iRs = Easp.db.Exec("Select Count(0) From "& WhereStr &"")
            If Easp.IsN(iRs) Then
                TotalNumber = 0
            Else
                TotalNumber = iRs(0)
            End If
            Easp.db.C iRs
        End If
        '==========================================================================
        Set oRs = Easp.db.Exec(oSQL)
        If Easp.IsN(oRs) Then
            ErrHtml TotalNumber, TakeCount, ""
        Else
            Dim Imgs
            Imgs = Easp.db.RT(TablePrefix & "Channel", " IsField = 1 And id = "& ChannelId &" ", "ShowPic")
            Do While Not oRs.EOF
                TakeCount = TakeCount + 1
                TempFile = CmsTemplates & CmsTempSkin & oRs("TemplateView")
                '==========================================================================
                Easp.Use "fso"
                If Easp.Fso.IsFile(TempFile) Then
                    '==========================================================================
                    Cms.Tpl.Path = CmsTemplates & CmsTempSkin
                    Cms.Tpl.File = oRs("TemplateView")
                    Cms.Tpl.dFields oRs
                    Cms.Tpl.d("PageId") = oRs("Id")
                    Cms.Tpl.d("PageTitle") = oRs("Title")
                    Cms.Tpl.d("PageContent") = oRs("Content")
                    Cms.Tpl.d("PageCurrent") = ChannelTagName
                    Cms.Tpl.d("HtmlFilePath") = oRs("HtmlFilePath")
                    Cms.Tpl.d("ChildId") = oRs("ChildId")
                    Cms.Tpl.d("ChildIdAll") = oRs("ChildIdAll")
                    Cms.Tpl.d("ShowHeadInfo") = ShowHead(TablePrefix & ChannelTabName, oRs("Id"), ChannelId, oRs("ClassId")) & ""
                    Cms.Tpl.d("ShowNextInfo") = ShowNext(TablePrefix & ChannelTabName, oRs("Id"), ChannelId, oRs("ClassId")) & ""
                    Cms.Tpl.d("CurrentDir") = GetSitePath(oRs("ClassId"), " -> ")
                    '==========================================================================
                    If Not Easp.IsN(oRs("imageurl")) Then
                        Easp.Use "fso"
                        If Easp.Fso.IsFile(oRs("imageurl")) Then
                            Cms.Tpl.d("img") = oRs("imageurl")
                            If Easp.Fso.IsFile(Replace(oRs("imageurl"), ".", "s.")) Then
                                Cms.Tpl.d("imgs") = Replace(oRs("imageurl"), ".", "s.")
                            Else
                                Cms.Tpl.d("imgs") = oRs("imageurl")
                            End If
                        Else
                            Cms.Tpl.d("img") = Imgs
                            Cms.Tpl.d("imgs") = Imgs
                        End If
                    Else
                        Cms.Tpl.d("img") = Imgs
                        Cms.Tpl.d("imgs") = Imgs
                    End If
                    If ChannelId = 2 Then
                        '============================ 图片显示形式1
                        Cms.Tpl.d("BigPic") = GetPicAttr(oRs("UpImages"), 1, "", "", 0, 0) & ""
                        Cms.Tpl.d("SmallPic") = GetPicAttr(oRs("UpImages"), 11, "", "", 0, 0) & ""
                        Cms.Tpl.d("PicText") = GetPicAttr(oRs("UpImages"), 111, "", "", 0, 0) & ""
                        '============================ 图片显示形式2
                        Cms.Tpl.d("BigPic2") = GetPicAttr(oRs("UpImages"), 2, "", "", 0, 0) & ""
                        Cms.Tpl.d("SmallPic2") = GetPicAttr(oRs("UpImages"), 22, "", "", 0, 0) & ""
                        Cms.Tpl.d("PicText2") = GetPicAttr(oRs("UpImages"), 222, "", "", 0, 0) & ""
                        '============================ 图片显示形式
                        Cms.Tpl.d("PicListOrd") = GetPicAttr(oRs("UpImages"), 3, "", "", 0, 0) & ""
                        Cms.Tpl.d("PicListLi") = GetPicAttr(oRs("UpImages"), 4, "", "", 0, 0) & ""
                        Cms.Tpl.d("PicListLiP") = GetPicAttr(oRs("UpImages"), 5, "", "", 0, 0) & ""
                        Cms.Tpl.d("PicListP") = GetPicAttr(oRs("UpImages"), 6, "", "", 0, 0) & ""
                        '==========================================================================
                        Dim UpImgLable, arrUpImg
                        UpImgLable = Cms.Tpl.GetAttr("PicList", "sp")
                        If Not Easp.IsN(UpImgLable) Then
                            If InStr(UpImgLable, ",") > 0 Then
                                arrUpImg = Split(UpImgLable, ",")
                                Cms.Tpl.d("PicList") = GetPicAttr(oRs("UpImages"), 7, arrUpImg(0), arrUpImg(1), CmsFun.ChkNumEric(arrUpImg(2)), CmsFun.ChkNumEric(arrUpImg(3))) & ""
                            Else
                                Cms.Tpl.d("PicList") = GetPicAttr(oRs("UpImages"), 7, "", "", 0, 0) & ""
                            End If
                        Else
                            Cms.Tpl.d("PicList") = GetPicAttr(oRs("UpImages"), 7, "", "", 0, 0) & ""
                        End If
                        Cms.Tpl.d("PicListJson") = GetPicAttr(oRs("UpImages"), 8, "", "", 0, 0) & ""
                    End If
                    Cms.Tpl.d("ChannelId") = ChannelId
                    '========================================================================== 开始生成Html
                    HtmlFile = CmsFun.HtmlFileUrl(oRs("ViewHtmlPath") & oRs("ViewHtmlPrefix"), oRs("HtmlFile"), oRs("Id"))
                    Cms.Fun.Init()
                    Cms.Tpl.SaveAs = HtmlFile
                    MsgHtml TotalNumber, TakeCount, "生成"& ChannelTitle & ":" & oRs("Title") &"成功"
                Else
                    '==========================================================================
                    MsgHtml TotalNumber, TakeCount, "生成"& ChannelTitle & ":" & oRs("Title") &"失败,模版文件："& TempFile &",未找到"
                End If
                '==========================================================================
                oRs.MoveNext
            Loop
            '==========================================================================
            If TakeCount = TotalNumber Then
                ErrHtml TotalNumber, TakeCount, "，所有"& ChannelTitle &"内容页生成完毕,"& Now() &"!"
            End If
            '==========================================================================
        End If
        Easp.db.C oRs
    End If
End Sub

'============================================================================= 生成文章内容

Sub NewsContent()
    PublicCreateContent ChannelNewsIsHtml, 1, "文章", "news", "News"
End Sub

'============================================================================= 生成产品内容

Sub ProContent()
    PublicCreateContent ChannelProIsHtml, 2, "产品", "pro", "Pro"
End Sub

'============================================================================= 生成下载内容

Sub DownContent()
    PublicCreateContent ChannelDownIsHtml, 3, "下载", "down", "Down"
End Sub


Sub PublicCreateIndex(ByVal TempFile, ByVal TagName, ByVal ChannelId, ByVal cTitle, ByVal cTab, ByVal cSavePath, ByVal cPageId)
    Dim Tpl, iPageSize, PageStyle, PageLanguage, TempFilePath, CmsLib
    TempFilePath = CmsTemplates & CmsTempSkin & TempFile
    Easp.Use "fso"
    If Easp.Fso.IsFile(TempFilePath) Then
        Cms.Tpl.Path = CmsTemplates & CmsTempSkin
        Cms.Tpl.File = TempFile
        '==========================================================================
        Dim Blocks, block, DataId, Cid, OrderBy
        Set Blocks = Cms.Tpl.getBlocks(TagName)
        For Each block In Blocks
            iPageSize = CmsFun.ChkNumEric(Cms.Tpl.Attr(block.SubMatches(0), "num"))
            PageStyle = CmsFun.ChkNumEric(Cms.Tpl.Attr(block.SubMatches(0), "style"))
            PageLanguage = CmsFun.ChkNumEric(Cms.Tpl.Attr(block.SubMatches(0), "language"))
            DataId = Trim(Cms.Tpl.Attr(block.SubMatches(0), "id"))
            Cid = Trim(Cms.Tpl.Attr(block.SubMatches(0), "cid"))
            OrderBy = CmsFun.ChkNumEric(Cms.Tpl.attr(block.SubMatches(0), "order"))
        Next
        iPageSize = Easp.IIf(iPageSize = 0, 20, iPageSize)
        '==========================================================================
        PublicCreateIndexCountPage iPageSize, PageStyle, PageLanguage, Cms, DataId, Cid, OrderBy, TagName, ChannelId, cTitle, cTab, cSavePath, cPageId
    Else
        ErrHtml 1, 0, ",生成"& cTitle &"首页失败,模版文件："& TempFilePath &",未找到!"
    End If
End Sub

Sub PublicCreateIndexCountPage(iPageSize, PageStyle, PageLanguage, Cms, DataId, Cid, OrderBy, TagName, ChannelId, cTitle, cTab, cSavePath, cPageId)
    Dim iPageCount, oRs, TempCount, iPage, i, TempWhere
    '======================================================
    TempWhere = ""
    If Not Easp.IsN(DataId) Then
        TempWhere = TempWhere & " And id in("& DataId &") "
    End If
    If Not Easp.IsN(Cid) Then
        TempWhere = TempWhere & " And ClassId in("& Cid &") "
    End If
    Set oRs = Easp.db.GR(TablePrefix & cTab & ":Count(0)", " 1 = 1 " & TempWhere, "")
    If Easp.IsN(oRs) Then
        TempCount = 0
    Else
        TempCount = CmsFun.ChkNumEric(oRs(0))
    End If
    Easp.C oRs
    '======================================================
    iPageCount = GetTablePageCount(TablePrefix & cTab, TempWhere, iPageSize)
    If iPageCount > 0 Then
        Cms.Fun.Init()
        Dim getHtml
        getHtml = Cms.Tpl.gethtml()
        For i = 1 To iPageCount
            Cms.Tpl.sethtml = getHtml
            Easp.WF ""
            iPage = i
            PublicCreateIndexPage iPageSize, PageStyle, PageLanguage, iPageCount, i, TempCount, Cms, DataId, Cid, OrderBy, TagName, ChannelId, cTitle, cTab, cSavePath, cPageId
            Easp.WF ""
        Next
    Else
        Cms.Fun.Init()
        PublicCreateIndexPage iPageSize, PageStyle, PageLanguage, 1, 1, TempCount, Cms, DataId, Cid, OrderBy, TagName, ChannelId, cTitle, cTab, cSavePath, cPageId
    End If
End Sub

Sub PublicCreateIndexPage(ToPaegNum, PageStyle, PageLanguage, TotalPage, Page, TotalCount, Cms, DataId, Cid, OrderBy, TagName, ChannelId, cTitle, cTab, cSavePath, cPageId)
    Dim iSQL, iRs, HtmlPageList, HtmlFilePath, HtmlFile, TakeCount, TempWhere
    iSQL = ""
    HtmlFilePath = cSavePath
    TempWhere = ""
    If Not Easp.IsN(DataId) Then
        TempWhere = TempWhere & " And a.id in("& DataId &") "
    End If
    If Not Easp.IsN(Cid) Then
        TempWhere = TempWhere & " And a.ClassId in("& Cid &") "
    End If
    If Page > 1 Then
        iSQL = iSQL & "Select Top "& ToPaegNum &" a.*,b.ChannelId,b.Picture,b.CnName,b.HtmlFilePath,"
        iSQL = iSQL & "b.ViewHtmlPath,b.ViewHtmlPrefix,b.TemplateView,b.MarkVal,b.Pid,b.ChildIdAll From ["& TablePrefix & cTab &"] a "
        iSQL = iSQL & " Left Join ["& TablePrefix &"Type] b On a.ClassId = b.Id Where b.ChannelId = "& ChannelId &" " & TempWhere
        iSQL = iSQL & " And a.id < (Select min(id) From (Select Top "& (Page -1) * ToPaegNum &" a.id From ["& TablePrefix & cTab &"] a "
        iSQL = iSQL & " Left Join ["& TablePrefix &"Type] b On a.ClassId = b.Id Where b.ChannelId = "& ChannelId &" " & TempWhere
        iSQL = iSQL & " Order By a.id desc) as c1)"
    Else
        iSQL = iSQL & "Select Top "& ToPaegNum &" a.*,b.ChannelId,b.Picture,b.CnName,b.HtmlFilePath,"
        iSQL = iSQL & "b.ViewHtmlPath,b.ViewHtmlPrefix,b.TemplateView,b.MarkVal,b.Pid,b.ChildIdAll From ["& TablePrefix & cTab &"] a "
        iSQL = iSQL & " Left Join ["& TablePrefix &"Type] b On a.ClassId = b.Id Where b.ChannelId = "& ChannelId &" " & TempWhere
    End If
    '========================================================
    Select Case OrderBy
        Case 1
            iSQL = iSQL & " Order By a.Hits Desc,a.UpTime Desc,a.Id Desc "
        Case 2
            iSQL = iSQL & " Order By a.DataIsTop Desc,a.UpTime Desc,a.Id Desc "
        Case 3
            iSQL = iSQL & " Order By a.DataIsBest Desc,a.UpTime Desc,a.Id Desc "
        Case 4
            iSQL = iSQL & " Order By a.DataIsHot Desc,a.UpTime Desc,a.Id Desc "
        Case 5
            iSQL = iSQL & " Order By a.DataIsTop Desc,a.Hits Desc,a.UpTime Desc,a.Id Desc "
        Case 6
            iSQL = iSQL & " Order By a.DataIsBest Desc,a.Hits Desc,a.UpTime Desc,a.Id Desc "
        Case 7
            iSQL = iSQL & " Order By a.DataIsHot Desc,a.Hits Desc,a.UpTime Desc,a.Id Desc "
        Case Else
            iSQL = iSQL & " Order By a.UpTime Desc,a.Id Desc "
    End Select
    '========================================================
    Set iRs = Easp.db.GRS(iSQL)
    Easp.WF ""
    Dim Matchs, Blocks, block, strHtml, html, i, ii
    strHtml = ""
    html = ""
    Set Blocks = Cms.Tpl.getBlocks(TagName)
    For Each block In Blocks
        html = block.SubMatches(1)
        Set Matchs = Easp.RegMatch(html, "\{((?:empty|null|eof|nodata)\:"&TagName&")\s*?(?:[\s\S.]*?)\/?\}(?:([\s\S.]*?)\{/\1\})")
        If Easp.IsN(iRs) Then
            If Matchs.Count > 0 Then
                strHtml = Matchs(0).SubMatches(1)
            End If
        Else
            If Matchs.Count > 0 Then
                html = Easp.RegReplace(html, Matchs(0).Value, "")
            End If
        End If
        i = 1
        ii = 1
        Do While Not iRs.EOF
            strHtml = strHtml & html
            Select Case ChannelId
                Case 1
                    strHtml = Cms.Fun.ReturnNewsRs(strHtml, TagName, iRs)
                Case 2
                    strHtml = Cms.Fun.ReturnProRs(strHtml, TagName, iRs)
                Case 3
                    strHtml = Cms.Fun.ReturnDownRs(strHtml, TagName, iRs)
            End Select
            strHtml = Cms.Tpl.Assign(strHtml, TagName, iRs)
            Cms.Tpl.blockTagd strHtml, TagName & ".CnName", iRs("CnName")
            Cms.Tpl.blockTagd strHtml, TagName & ".HtmlFilePath", iRs("HtmlFilePath")
            Cms.Tpl.blockTagd strHtml, TagName & ".i", i
            Cms.Tpl.blockTagd strHtml, TagName & ".ii", CmsFun.ZeroFill(ii, 2)
            i = i + 1
            ii = ii + 1
            iRs.MoveNext
        Loop
        HtmlPageList = ShowPageHtml(Page, TotalPage, TotalCount, ToPaegNum, PageStyle, PageLanguage)
        Easp.Fso.CreateFolder HtmlFilePath
        Cms.Tpl.d("PageTitle") = cTitle
        Cms.Tpl.d("ShowPage") = HtmlPageList & ""
        Cms.Tpl.d("PageId") = cPageId
        Cms.Tpl.d("ChannelId") = ChannelId
        Cms.Tpl.blockTag(block) = strHtml
    Next
    If (CmsFun.ChkNumEric(Page) = 0 Or CmsFun.ChkNumEric(Page) = 1) Then
        HtmlFile = HtmlFilePath & "index.html"
        Cms.Tpl.SaveAs = HtmlFile
    Else
        HtmlFile = HtmlFilePath & "index"& Page &".html"
        Cms.Tpl.SaveAs = HtmlFile
    End If
    '===============================================================
    Set Blocks = Nothing
    '==========================================================================
    TakeCount = Easp.IIf(Page = 0, 1, Page)
    MsgHtml TotalPage, TakeCount, "生成"& cTitle & "首页列表成功"
    If TakeCount = TotalPage Then
        ErrHtml TotalPage, TakeCount, ",生成文章首页列表完毕,"& Now() &"!"
    End If
    '==========================================================================
    Easp.C iRs
End Sub

'============================================================================= 生成文章首页

Sub NewsIndex()
    Dim IndexFile, IndexTemp
    IndexTemp = CmsTemplates & CmsTempSkin & TplNewsInexFile
    Easp.Use "fso"
    If Easp.Fso.IsFile(IndexTemp) Then
        IndexFile = Easp.Fso.Read(IndexTemp)
        If InStr(IndexFile, "[ShowPage") > 0 Then
            PublicCreateIndex TplNewsInexFile, "newslist", 1, "文章", "News", ChannelNewsHtml, "news"
        Else
            CreateIndexNewsPage()
        End If
    Else
        ErrHtml 1, 0, ",生成文章首页失败,模版文件："& IndexTemp &"未找到！"
    End If
End Sub

'============================================================================= 生成文章首页（不带分页）

Sub CreateIndexNewsPage()
    PublicCreateHtml "newsindex", 1, TplNewsInexFile, "文章首页", ChannelNewsHtml & "index.html"
End Sub

'============================================================================= 生成产品首页

Sub ProIndex()
    Dim IndexFile, IndexTemp
    IndexTemp = CmsTemplates & CmsTempSkin & TplProInexFile

    Easp.Use "fso"
    If Easp.Fso.IsFile(IndexTemp) Then
        IndexFile = Easp.Fso.Read(IndexTemp)
        If InStr(IndexFile, "[ShowPage") > 0 Then
            PublicCreateIndex TplProInexFile, "prolist", 2, "产品", "Pro", ChannelProHtml, "pro"
        Else
            CreateIndexProPage()
        End If
    Else
        ErrHtml 1, 0, ",生成产品首页失败,模版文件："& IndexTemp &"未找到！"
    End If
End Sub

'============================================================================= 生成产品首页（不带分页）

Sub CreateIndexProPage()
    PublicCreateHtml "proindex", 2, TplProInexFile, "产品首页", ChannelProHtml & "index.html"
End Sub

'============================================================================= 生成下载首页

Sub DownIndex()
    Dim IndexFile, IndexTemp
    IndexTemp = CmsTemplates & CmsTempSkin & TplDownInexFile
    Easp.Use "fso"
    If Easp.Fso.IsFile(IndexTemp) Then
        IndexFile = Easp.Fso.Read(IndexTemp)
        If InStr(IndexFile, "[ShowPage") > 0 Then
            PublicCreateIndex TplDownInexFile, "downlist", 3, "下载", "Down", ChannelDownHtml, "down"
        Else
            CreateIndexDownPage()
        End If
    Else
        ErrHtml 1, 0, ",生成下载首页失败,模版文件："& IndexTemp &"未找到！"
    End If
End Sub

'============================================================================= 生成下载首页（不带分页）

Sub CreateIndexDownPage()
    PublicCreateHtml "downindex", 3, TplDownInexFile, "下载首页", ChannelDownHtml & "index.html"
End Sub

'============================================================================= 生成招聘首页（不带分页）

Sub JobIndex()
    If ChannelJobIsHtml = 1 Then
        PublicCreateHtml "jobindex", 4, TplJobInexFile, "招聘首页", ChannelJobHtml & "index.html"
    End If
End Sub

Sub PublicCreateList(ByVal TagName, ByVal ChannelId, ByVal InfoTitle, ByVal TabName)
    Dim oRs, iPageSize, PageStyle, PageLanguage, arrList, i, TempWhere, ClassId, TempField
    TempWhere = ""
    ClassId = Easp.Get("ClassId:n:0")
    If CmsFun.ChkNumEric(ClassId) > 0 Then
        TempWhere = TempWhere & " And id = "& ClassId &" "
    End If
    TempField = "id,CnName,TemplateList,HtmlFilePath,Pid,ChildIdAll,MetaKey,MetaDesc,MarkVal,ChannelId,Picture,ChildId"
    Set oRs = Easp.db.GR(TablePrefix & "Type:"& TempField &"", " ChannelId = "& ChannelId &" And TemplateList <> '' " & TempWhere, " Px Asc,id Desc ")
    If Easp.IsN(oRs) Then
        ErrHtml 1, 0, ",生成"& InfoTitle &"分类失败,当前还没有添加分类!"
        Exit Sub
    Else
        arrList = oRs.GetRows()
    End If
    Easp.db.C oRs
    '==========================================================================
    For i = 0 To UBound(arrList, 2)
        '======================================================================
        Easp.Use "fso"
        If Easp.Fso.IsFile(CmsTemplates & CmsTempSkin & arrList(2, i)) Then
            '======================================================================
            Cms.Tpl.Path = CmsTemplates & CmsTempSkin
            Cms.Tpl.File = arrList(2, i)
            Dim Blocks, block, OrderBy
            Set Blocks = Cms.Tpl.getBlocks(TagName)
            For Each block In Blocks
                iPageSize = CmsFun.ChkNumEric(Cms.Tpl.Attr(block.SubMatches(0), "num"))
                PageStyle = CmsFun.ChkNumEric(Cms.Tpl.Attr(block.SubMatches(0), "style"))
                PageLanguage = CmsFun.ChkNumEric(Cms.Tpl.Attr(block.SubMatches(0), "language"))
                OrderBy = CmsFun.ChkNumEric(Cms.Tpl.attr(block.SubMatches(0), "order"))
            Next
            iPageSize = Easp.IIf(iPageSize = 0, 10, iPageSize)
            Cms.Tpl.d("CurrentDir") = GetSitePath(arrList(0, i), " -> ")
            Cms.Tpl.d("PageId") = arrList(0, i)
            Cms.Tpl.d("PageTitle") = arrList(1, i)
            Cms.Tpl.d("HtmlFilePath") = arrList(3, i)
            Cms.Tpl.d("ChildIdAll") = arrList(5, i)
            Cms.Tpl.d("MetaKey") = arrList(6, i)
            Cms.Tpl.d("MetaDesc") = arrList(7, i)
            Cms.Tpl.d("MarkVal") = arrList(8, i)
            Cms.Tpl.d("ChannelId") = arrList(9, i)
            Cms.Tpl.d("Picture") = arrList(10, i)
            Cms.Tpl.d("ChildId") = arrList(11, i)
            PublicCreateListHtml arrList(0, i), iPageSize, PageStyle, PageLanguage, OrderBy, Cms, arrList(3, i), arrList(1, i), TagName, ChannelId, InfoTitle, TabName
            '==========================================================================
        Else
            ErrHtml 1, 0, ",生成"& InfoTitle &"分类"& arrList(1, i) &"失败,模版文件："& CmsTemplates & CmsTempSkin & arrList(2, i) &",未找到!"
        End If
    Next
End Sub


Sub PublicCreateListHtml(ClassId, iPageSize, PageStyle, PageLanguage, OrderBy, Cms, SavePath, PageTitle, TagName, ChannelId, InfoTitle, TabName)
    Dim iPageCount, iSQL, iRs, iPage, DataClassId, TempCount, n
    iSQL = ""
    DataClassId = ""
    If CmsFun.ChkNumEric(ClassId) > 0 Then
        DataClassId = CmsFun.GetClassVal(ChannelId, ClassId)
        iSQL = " And ClassId In(" & DataClassId & ") "
    Else
        Exit Sub
    End If
    '======================================================
    iPageCount = GetTablePageCount(TablePrefix & TabName, iSQL, iPageSize)
    If iPageCount > 0 Then
        Cms.Fun.Init()
        Dim getHtml
        getHtml = Cms.Tpl.gethtml()
        For n = 1 To iPageCount
            Cms.Tpl.sethtml = getHtml
            Easp.WF ""
            iPage = n
            PublicCreatePageList iPageSize, PageStyle, PageLanguage, OrderBy, iPageCount, iPage, ClassId, Cms, SavePath, PageTitle, TagName, ChannelId, InfoTitle, TabName
            Easp.WF ""
        Next
    Else
        Cms.Fun.Init()
        PublicCreatePageList iPageSize, PageStyle, PageLanguage, OrderBy, 1, 1, ClassId, Cms, SavePath, PageTitle, TagName, ChannelId, InfoTitle, TabName
    End If
End Sub

Sub PublicCreatePageList(ToPaegNum, PageStyle, PageLanguage, OrderBy, TotalPage, Page, ClassId, Cms, SavePath, PageTitle, TagName, ChannelId, InfoTitle, TabName)
    Dim iSQL, iRs, HtmlPageList, StrWhere, DataClassId, HtmlFilePath, HtmlFile, TakeCount
    StrWhere = ""
    iSQL = ""
    HtmlFilePath = SavePath
    If CmsFun.ChkNumEric(ClassId) > 0 Then
        DataClassId = CmsFun.GetClassVal(ChannelId, ClassId)
        StrWhere = StrWhere & " And a.ClassId In(" & DataClassId & ") "
    End If
    If Page > 1 Then
        iSQL = iSQL & "Select Top "& ToPaegNum &" a.*,b.CnName,b.HtmlFilePath,b.MarkVal,b.ViewHtmlPath,b.ViewHtmlPrefix From ["& TablePrefix & TabName &"] a "
        iSQL = iSQL & " Left Join ["& TablePrefix &"Type] b On a.ClassId = b.id Where b.ChannelId = "& ChannelId &" And  b.TemplateView <> '' "
        iSQL = iSQL & " And a.id < (Select min(id) From (Select Top "& (Page -1) * ToPaegNum &" a.id From ["& TablePrefix & TabName &"] a "
        iSQL = iSQL & " Left Join ["& TablePrefix &"Type] b On a.ClassId = b.id Where b.ChannelId = "& ChannelId &" " & StrWhere
        iSQL = iSQL & " And  b.TemplateView <> '' "& StrWhere &" Order By a.id desc) as c1)"
    Else
        iSQL = iSQL & "Select Top "& ToPaegNum &" a.*,b.CnName,b.HtmlFilePath,b.MarkVal,b.ViewHtmlPath,b.ViewHtmlPrefix From ["& TablePrefix & TabName &"] a "
        iSQL = iSQL & " Left Join ["& TablePrefix &"Type] b On a.ClassId = b.id Where b.ChannelId = "& ChannelId &" And  b.TemplateView <> '' "
    End If
    '======================================================== 取总记录数
    Dim TotalCount, oSQL, oRs
    oSQL = "Select Count(*) From ["& TablePrefix & TabName &"] a Left Join ["& TablePrefix &"Type] b On a.ClassId = b.id "
    oSQL = oSQL & " Where b.ChannelId = "& ChannelId &" And  b.TemplateView <> '' " & StrWhere
    Set oRs = Easp.db.Exec(oSQL)
    If Not Easp.IsN(oRs) Then
        TotalCount = oRs(0)
    End If
    Easp.db.C oRs
    '========================================================
    iSQL = iSQL & StrWhere
    '========================================================
    Select Case OrderBy
        Case 1
            iSQL = iSQL & " Order By a.Hits Desc,a.UpTime Desc,a.Id Desc "
        Case 2
            iSQL = iSQL & " Order By a.DataIsTop Desc,a.UpTime Desc,a.Id Desc "
        Case 3
            iSQL = iSQL & " Order By a.DataIsBest Desc,a.UpTime Desc,a.Id Desc "
        Case 4
            iSQL = iSQL & " Order By a.DataIsHot Desc,a.UpTime Desc,a.Id Desc "
        Case 5
            iSQL = iSQL & " Order By a.DataIsTop Desc,a.Hits Desc,a.UpTime Desc,a.Id Desc "
        Case 6
            iSQL = iSQL & " Order By a.DataIsBest Desc,a.Hits Desc,a.UpTime Desc,a.Id Desc "
        Case 7
            iSQL = iSQL & " Order By a.DataIsHot Desc,a.Hits Desc,a.UpTime Desc,a.Id Desc "
        Case Else
            iSQL = iSQL & " Order By a.UpTime Desc,a.Id Desc "
    End Select
    Set iRs = Easp.db.Exec(iSQL)
    Easp.WF ""
    Dim Matchs, Blocks, block, strHtml, html, n, ii
    strHtml = ""
    html = ""
    Set Blocks = Cms.Tpl.getBlocks(TagName)
    For Each block In Blocks
        html = block.SubMatches(1)
        Set Matchs = Easp.RegMatch(html, "\{((?:empty|null|eof|nodata)\:"&TagName&")\s*?(?:[\s\S.]*?)\/?\}(?:([\s\S.]*?)\{/\1\})")

        If Easp.IsN(iRs) Then
            If Matchs.Count > 0 Then
                strHtml = Matchs(0).SubMatches(1)
            End If
        Else
            If Matchs.Count > 0 Then
                html = Easp.RegReplace(html, Matchs(0).Value, "")
            End If
        End If
        n = 1
        ii = 1
        Do While Not iRs.EOF
            strHtml = strHtml & html
            Select Case ChannelId
                Case 1
                    strHtml = Cms.Fun.ReturnNewsRs(strHtml, TagName, iRs)
                Case 2
                    strHtml = Cms.Fun.ReturnProRs(strHtml, TagName, iRs)
                Case 3
                    strHtml = Cms.Fun.ReturnDownRs(strHtml, TagName, iRs)
            End Select
            strHtml = Cms.Tpl.Assign(strHtml, TagName, iRs)
            Cms.Tpl.blockTagd strHtml, TagName & ".CnName", iRs("CnName")
            Cms.Tpl.blockTagd strHtml, TagName & ".HtmlFilePath", iRs("HtmlFilePath")
            Cms.Tpl.blockTagd strHtml, TagName & ".i", n
            Cms.Tpl.blockTagd strHtml, TagName & ".ii", CmsFun.ZeroFill(ii, 2)
            n = n + 1
            ii = ii + 1
            iRs.MoveNext
        Loop
        HtmlPageList = ShowPageHtml(Page, TotalPage, TotalCount, ToPaegNum, PageStyle, PageLanguage)
        Easp.Fso.CreateFolder HtmlFilePath
        Cms.Tpl.d("ShowPage") = HtmlPageList & ""
        Easp.C iRs
        Cms.Tpl.blockTag(block) = strHtml
    Next
    If (CmsFun.ChkNumEric(Page) = 0 Or CmsFun.ChkNumEric(Page) = 1) Then
        HtmlFile = HtmlFilePath & "index.html"
        Cms.Tpl.SaveAs = HtmlFile
    Else
        HtmlFile = HtmlFilePath & "index"& Page &".html"
        Cms.Tpl.SaveAs = HtmlFile
    End If
    '===============================================================
    Set Blocks = Nothing
    '==========================================================================
    TakeCount = Easp.IIf(Page = 0, 1, Page)
    MsgHtml TotalPage, TakeCount, "生成"& InfoTitle &"分类：" & PageTitle & "列表成功"
    If TakeCount = TotalPage Then
        ErrHtml TotalPage, TakeCount, ",生成"& InfoTitle &"分类"& PageTitle &"列表完毕,"& Now() &"!"
    End If
    '==========================================================================
    Easp.db.C iRs
End Sub

'============================================================================= 文章列表生成开始
' 文章列表生成开始,查询分类并载入模版
'=============================================================================

Sub NewsList()
    PublicCreateList "newslist", 1, "文章", "News"
End Sub

'============================================================================= 产品列表生成开始
' 产品列表生成开始,查询分类并载入模版
'=============================================================================

Sub ProList()
    PublicCreateList "prolist", 2, "产品", "Pro"
End Sub

'============================================================================= 下载列表生成开始
' 下载列表生成开始,查询分类并载入模版
'=============================================================================

Sub DownList()
    PublicCreateList "downlist", 3, "下载", "Down"
End Sub

'=============================================================================

Function GetTablePageCount(ByVal TableName, ByVal TableWhere, ByVal PageNum)
    Dim iCount, iPageCount, iRs, TempWhere
    TempWhere = ""
    If Not Easp.IsN(TableWhere) Then
        TempWhere = TempWhere & TableWhere
    End If
    Set iRs = Easp.db.GR(TableName & ":Count(0)", " 1 = 1 " & TempWhere, "")
    If Easp.IsN(iRs) Then
        iCount
    Else
        iCount = CmsFun.ChkNumEric(iRs(0))
        If iCount Mod PageNum = 0 Then
            iPageCount = CmsFun.ChkNumEric(iCount \ PageNum)
        Else
            iPageCount = CmsFun.ChkNumEric(iCount \ PageNum + 1)
        End If
    End If
    Easp.db.C iRs
    GetTablePageCount = iPageCount
End Function

'=============================================================================
'函数名：ShowPageHtml
'作　用：通用分页导航
'参　数：
'		Page				### 当前页
'		TotalPage			### 总页数
'		TotalNum			###	总信息数量
'		PageNum				###	每页多少个
'		PageStyle			###	分页样式
'		PageLanguage		###	显示语言0、中文,1、英文
'=============================================================================

Function ShowPageHtml(ByVal Page, ByVal TotalPage, ByVal TotalNum, ByVal PageNum, ByVal PageStyle, ByVal PageLanguage)
    Dim iPageStyle, TempPageHtml
    iPageStyle = CmsFun.ChkNumEric(PageStyle)
    Select Case iPageStyle
        Case 1
            TempPageHtml = ShowPageSimple(Page, TotalPage, TotalNum, PageNum, PageLanguage)
        Case 2
            TempPageHtml = ShowPageNum(Page, TotalPage, PageLanguage)
        Case Else
            TempPageHtml = ShowPageDefault(Page, TotalPage, TotalNum, PageNum, PageLanguage)
    End Select
    ShowPageHtml = TempPageHtml
End Function

Function ShowPageDefault(ByVal Page, ByVal TotalPage, ByVal TotalNum, ByVal PageNum, ByVal PageLanguage)
    Dim PageHtml
    Dim PageFirst, PagePrev, PageNext, PageLast, PageTotalNum, PageTotalRecords, PageInfo, PageTip
    If PageLanguage > 0 Then
        PageFirst = "First"
        PagePrev = "Prev"
        PageNext = "Next"
        PageLast = "Last"
        PageTotalNum = "Total Pages"
        PageTotalRecords = "Total Records"
        PageInfo = "/Page"
        PageTip = "Page"
    Else
        PageFirst = "首　页"
        PagePrev = "上一页"
        PageNext = "下一页"
        PageLast = "尾　页"
        PageTotalNum = "总页数"
        PageTotalRecords = "总数"
        PageInfo = "个/页"
        PageTip = "页次"
    End If
    If TotalPage > 1 Then
        PageHtml = "<span class=""disabled"">"& PageTotalRecords &"："& TotalNum &"</span>"
        If CmsFun.ChkNumEric(Page) = 1 Then
            PageHtml = PageHtml & "<span class=""disabled"">"& PageFirst &"</span>"
        Else
            PageHtml = PageHtml & "<a href=""index.html"">"& PageFirst &"</a>"
        End If
        If CmsFun.ChkNumEric(Page) = 1 Then
            PageHtml = PageHtml & "<span class=""disabled"">"& PagePrev &"</span>"
        Else
            If CmsFun.ChkNumEric(Page) = 2 Then
                PageHtml = PageHtml & "<a href=""index.html"">"& PagePrev &"</a>"
            Else
                PageHtml = PageHtml & "<a href=""index"& (Page - 1) &".html"">"& PagePrev &"</a>"
            End If
        End If
        If CmsFun.ChkNumEric(Page) = TotalPage Then
            PageHtml = PageHtml & "<span class=""disabled"">"& PageNext &"</span>"
        Else
            PageHtml = PageHtml & "<a href=""index"& (Page + 1) &".html"">"& PageNext &"</a>"
        End If
        If CmsFun.ChkNumEric(Page) = TotalPage Then
            PageHtml = PageHtml & "<span class=""disabled"">"& PageLast &"</span>"
        Else
            PageHtml = PageHtml & "<a href=""index"& TotalPage &".html"">"& PageLast &"</a>"
        End If
        PageHtml = PageHtml & "<span class=""disabled"">" & PageNum & PageInfo & "</span>"
        PageHtml = PageHtml & "<span class=""disabled"">"& PageTip &"：<font color=""red"">"& Page &"</font>/"& TotalPage &"</span>"
    Else
        PageHtml = ""
    End If
    ShowPageDefault = PageHtml
End Function

Function ShowPageSimple(ByVal Page, ByVal TotalPage, ByVal TotalNum, ByVal PageNum, ByVal PageLanguage)
    Dim strHtml
    Dim PageFirst, PagePrev, PageNext, PageLast, PageTotalNum, PageTotalRecords, PageInfo, PageTip
    If PageLanguage > 0 Then
        PageFirst = "First"
        PagePrev = "Prev"
        PageNext = "Next"
        PageLast = "Last"
        PageTotalNum = "Total Pages"
        PageTotalRecords = "Total Records"
        PageInfo = "/Page"
        PageTip = "Page"
    Else
        PageFirst = "首　页"
        PagePrev = "上一页"
        PageNext = "下一页"
        PageLast = "尾　页"
        PageTotalNum = "总页数"
        PageTotalRecords = "总数"
        PageInfo = "个/页"
        PageTip = "页次"
    End If
    If TotalPage > 1 Then
        strHtml = PageTotalRecords & "：" & TotalNum & " "
        If Page <= 1 Then
            strHtml = strHtml & PageFirst & " "
            strHtml = strHtml & PagePrev & " "
        Else
            strHtml = strHtml & "<a href=""index.html"">"& PageFirst &"</a>"
            If Page = 2 Then
                strHtml = strHtml & "<a href=""index.html"">"& PagePrev &"</a>"
            Else
                strHtml = strHtml & "<a href=""index"& (Page -1) & ".html"">"& PagePrev &"</a>"
            End If
        End If
        If Page >= TotalPage Then
            strHtml = strHtml & PageNext & " "
            strHtml = strHtml & PageLast & " "
        Else
            strHtml = strHtml & "<a href=""index"& (Page + 1) &".html"">"& PageNext &"</a>"
            strHtml = strHtml & "<a href=""index"& TotalPage &".html"">"& PageLast &"</a>"
        End If
        strHtml = strHtml & " "& PageTip &"："& Page &"/"& TotalPage &" " & PageNum & PageInfo
    Else
        strHtml = ""
    End If
    ShowPageSimple = strHtml
End Function

Function ShowPageNum(ByVal Page, ByVal TotalPage, ByVal PageLanguage)
    Dim strHtml, i, j, ibegin
    Dim PageFirst, PagePrev, PageNext, PageLast, PageTotalNum, PageTotalRecords, PageInfo, PageTip
    If PageLanguage > 0 Then
        PageFirst = "First"
        PagePrev = "Prev"
        PageNext = "Next"
        PageLast = "Last"
        PageTotalNum = "Total Pages"
        PageTotalRecords = "Total Records"
        PageInfo = "/Page"
        PageTip = "Page"
    Else
        PageFirst = "首　页"
        PagePrev = "上一页"
        PageNext = "下一页"
        PageLast = "尾　页"
        PageTotalNum = "总页数"
        PageTotalRecords = "总数"
        PageInfo = "个/页"
        PageTip = "页次"
    End If
    If TotalPage > 1 Then
        strHtml = ""
        j = 0
        If TotalPage = 1 Then
            Exit Function
        End If
        If Page <= 1 Then
            strHtml = strHtml & "<span>1</span>"
            For i = 2 To 9
                If i <= TotalPage Then
                    If i = 1 Then
                        strHtml = strHtml & "<a href=""index.html"">"& i &"</a>"
                    Else
                        strHtml = strHtml & "<a href=""index"& i & ".html"">"& i &"</a>"
                    End If
                    j = j + 1
                End If
            Next
            strHtml = strHtml & "<a href=""index"& (Page + 1) & ".html"">"& PageNext &"</a>"
            strHtml = strHtml & "<a href=""index"& TotalPage & ".html"">"& PageLast &"</a>"
        ElseIf Page >= TotalPage Then
            If TotalPage >= 9 Then
                ibegin = TotalPage - 9
                strHtml = strHtml & "<a href=""index.html"">"& PageFirst &"</a>"
                If Page = 2 Then
                    strHtml = strHtml & "<a href=""index.html"">"& PagePrev &"</a>"
                Else
                    strHtml = strHtml & "<a href=""index"& (Page -1) & ".html"">"& PagePrev &"</a>"
                End If
            Else
                strHtml = strHtml & "<a href=""index.html"">"& PageFirst &"</a>"
                If Page = 2 Then
                    strHtml = strHtml & "<a href=""index.html"">"& PagePrev &"</a>"
                Else
                    strHtml = strHtml & "<a href=""index"& (Page -1) & ".html"">"& PagePrev &"</a>"
                End If
                ibegin = 1
            End If
            For i = ibegin To TotalPage -1
                If i > 0 Then
                    If i = 1 Then
                        strHtml = strHtml & "<a href=""index.html"">"& i &"</a>"
                    Else
                        strHtml = strHtml & "<a href=""index"& i & ".html"">"& i &"</a>"
                    End If
                End If
            Next
            strHtml = strHtml & "<span>" & TotalPage & "</span>"
        Else
            strHtml = strHtml & "<a href=""index.html"">"& PageFirst &"</a>"
            If Page = 2 Then
                strHtml = strHtml & "<a href=""index.html"">"& PagePrev &"</a>"
            Else
                strHtml = strHtml & "<a href=""index"& (Page -1) & ".html"">"& PagePrev &"</a>"
            End If
            If Page > 4 Then
                ibegin = Page -4
            Else
                ibegin = 1
            End If
            j = j + 1
            For i = ibegin To Page -1
                If i = 1 Then
                    strHtml = strHtml & "<a href=""index.html"">"& i &"</a>"
                Else
                    strHtml = strHtml & "<a href=""index"& i & ".html"">"& i &"</a>"
                End If
                j = j + 1
            Next
            strHtml = strHtml & "<span>" & Page & "</span>"
            For i = 1 To 9 - j
                If Page + i<= TotalPage Then
                    strHtml = strHtml & "<a href=""index"& (Page + i) & ".html"">"& Page + i &"</a>"
                Else
                    Exit For
                End If
            Next
            strHtml = strHtml & "<a href=""index"& (Page + 1) & ".html"">"& PageNext &"</a>"
            strHtml = strHtml & "<a href=""index"& TotalPage & ".html"">"& PageLast &"</a>"
        End If
    Else
        strHtml = ""
    End If
    ShowPageNum = strHtml
End Function

'=============================================================================
'函 数 名：ShowHead
'函数作用：通用返回上一篇的链接
'参    数：
'			TableName			##### 表名
'			TableId				##### 当前ID
'			ChannelId			##### 频道ID
'			ClassId				##### 分类ID
'=============================================================================

Function ShowHead(ByVal TableName, ByVal TableId, ByVal ChannelId, ByVal ClassId)
    Dim TempStr, oRs, oSQL
    If CmsFun.ChkNumEric(TableId) = 0 Then
        Exit Function
    Else
        oSQL = "Select Top 1 a.id,a.Title,a.HtmlFile,b.ViewHtmlPath,b.ViewHtmlPrefix,a.ClassId From "& TableName &" a Left Join ["& TablePrefix &"Type] b On a.ClassId = b.id  "
        oSQL = oSQL & " Where b.ChannelId = "& ChannelId &" And  b.TemplateView <> '' "
        If CmsFun.ChkNumEric(ClassId) > 0 Then
            oSQL = oSQL & " And a.ClassId = "& ClassId &" "
        End If
        oSQL = oSQL & " And a.id > "& TableId &" Order By a.Id Desc "
        Set oRs = Easp.db.Exec(oSQL)
        If Easp.IsN(oRs) Then
            TempStr = "没有了!"
        Else
            TempStr = "<a href="""& CmsFun.HtmlFileUrl(oRs("ViewHtmlPath") & oRs("ViewHtmlPrefix"), oRs("HtmlFile"), oRs("id")) &""">"& oRs("Title") &"</a>"
        End If
        Easp.db.C oRs
        ShowHead = TempStr
    End If
End Function

'=============================================================================
'函 数 名：ShowNext
'函数作用：通用返回下一篇的链接
'参    数：
'			TableName			##### 表名
'			TableId				##### 当前ID
'			ChannelId			##### 频道ID
'			ClassId				##### 分类ID
'=============================================================================

Function ShowNext(ByVal TableName, ByVal TableId, ByVal ChannelId, ByVal ClassId)
    Dim TempStr, oRs, oSQL
    TempStr = ""
    If CmsFun.ChkNumEric(TableId) = 0 Then
        Exit Function
    Else
        oSQL = "Select Top 1 a.id,a.Title,a.HtmlFile,b.ViewHtmlPath,b.ViewHtmlPrefix,a.ClassId From "& TableName &" a Left Join ["& TablePrefix &"Type] b On a.ClassId = b.Id  "
        oSQL = oSQL & " Where b.ChannelId = "& ChannelId &" And  b.TemplateView <> '' "
        If CmsFun.ChkNumEric(ClassId) > 0 Then
            oSQL = oSQL & " And a.ClassId = "& ClassId &" "
        End If
        oSQL = oSQL & " And a.id < "& TableId &" Order By a.Id Desc "
        Set oRs = Easp.db.Exec(oSQL)
        If Easp.IsN(oRs) Then
            TempStr = "没有了!"
        Else
            TempStr = "<a href="""& CmsFun.HtmlFileUrl(oRs("ViewHtmlPath") & oRs("ViewHtmlPrefix"), oRs("HtmlFile"), oRs("id")) &""">"& oRs("Title") &"</a>"
        End If
        Easp.db.C oRs
        ShowNext = TempStr
    End If
End Function

Function GetSitePath(ByVal cid, ByVal SitePathSplit)
    Dim Path, fid
    fid = cid
    Do While Int(fid) > 0
        Path = Easp.db.RT(TablePrefix & "Type", " id = "& fid &" ", "HtmlFilePath")
        GetSitePath = SitePathSplit & " <a href=""" & Path & """>" & Easp.db.RT(TablePrefix & "Type", " id = "& fid &" ", "CnName") & "</a>" & GetSitePath
        fid = Easp.db.RT(TablePrefix & "Type", " id = "& fid &" ", "Pid")
    Loop
    GetSitePath = GetSitePath
End Function

'=============================================================================

Function GetPicAttr(ByVal Str, ByVal TypeStr, ByVal PicLable, ByVal TextLable, ByVal IsShowText, ByVal IsAutoLink)
    If Easp.IsN(Str) Then
        Exit Function
    Else
        Dim strTemp, arrTemp, TempStr, arrLength, iii
        strTemp = ""
        TempStr = ""
        arrTemp = Split(Str, "⊙$|||$⊙")
        arrLength = UBound(arrTemp) - 1
        For iii = 0 To arrLength
            TempStr = Split(arrTemp(iii), "#$#")
            Select Case CmsFun.ChkNumEric(TypeStr)
                Case 1
                    strTemp = strTemp & TempStr(0) & "|"
                Case 11
                    strTemp = strTemp & Easp.IIf(TempStr(0) <> "", TempStr(0), CmsSiteDir & "images/no_pic.gif") & "|"
                Case 111
                    strTemp = strTemp & TempStr(1) & "|"
                Case 2
                    strTemp = strTemp & TempStr(0) & ","
                Case 22
                    strTemp = strTemp & Easp.IIf(TempStr(0) <> "", TempStr(0), CmsSiteDir & "images/no_pic.gif") & ","
                Case 222
                    strTemp = strTemp & TempStr(1) & ","
                Case 3
                    strTemp = strTemp & "<img src="""& TempStr(0) &""" alt="""& TempStr(1) &""" title="""& TempStr(1) &""" border=""0"" />"
                Case 4
                    strTemp = strTemp & "<li><img src="""& TempStr(0) &""" alt="""& TempStr(1) &""" title="""& TempStr(1) &""" border=""0"" /></li>"
                Case 5
                    strTemp = strTemp & "<li><img src="""& TempStr(0) &""" alt="""& TempStr(1) &""" title="""& TempStr(1) &""" border=""0"" /><p>"& TempStr(1) &"</p></li>"
                Case 6
                    strTemp = strTemp & "<p><img src="""& TempStr(0) &""" alt="""& TempStr(1) &""" title="""& TempStr(1) &""" border=""0"" /></p>"
                Case 7
                    If PicLable <> "" Then
                        strTemp = strTemp & "<"& PicLable &">"
                    End If
                    If IsAutoLink = 1 Then
                        strTemp = strTemp & "<a href="""& TempStr(0) &""" target=""_blank""><img src="""& TempStr(0) &""" alt="""& TempStr(1) &""" title="""& TempStr(1) &""" border=""0"" /></a>"
                    Else
                        strTemp = strTemp & "<img src="""& TempStr(0) &""" alt="""& TempStr(1) &""" title="""& TempStr(1) &""" border=""0"" />"
                    End If
                    If IsShowText = 1 Then
                        If TextLable <> "" Then
                            strTemp = strTemp & "<"& TextLable &">" & TempStr(1) & "</"& TextLable &">"
                        Else
                            strTemp = strTemp & TempStr(1)
                        End If
                    End If
                    If PicLable <> "" Then
                        strTemp = strTemp & "</"& PicLable &">"
                    End If
                Case 8
                    strTemp = strTemp & "{""img"":"""& TempStr(0) &""",""imgs"":"""& Easp.IIf(TempStr(0) <> "", TempStr(0), CmsSiteDir & "images/no_pic.gif") &""",""title"":"""& TempStr(1) &"""},"
                Case Else
                    strTemp = strTemp & TempStr(0) & "|"
            End Select
        Next
        If strTemp <> "" And (Right(strTemp, 1) = "|" Or Right(strTemp, 1) = ",") Then
            strTemp = Left(strTemp, Len(strTemp) -1)
        End If
        GetPicAttr = strTemp
    End If
End Function

'=============================================================================

Sub IsHtmlError(ByVal Title, ByVal ChannelId)
    Dim IsHtml
    IsHtml = CmsFun.GetChannelField(ChannelId, "IsHtml")
    If IsHtml = 0 Then
        ErrHtml 1, 0, ",生成"& Title &"失败,"& Title &"没有打开HTML生成功能，不能生成HTML！"
    End If
End Sub

'=============================================================================

Sub MsgHtml(ByVal TotalNumber, ByVal TakeCount, ByVal MsgInfo)
    Easp.WF "<script type=""text/javascript"">" & vbCrLf
    Easp.WF "parent.plantext("& TotalNumber &","& TakeCount &",'" & Easp.ScriptTime & "',',"& MsgInfo &","& Now() &"!');" & vbCrLf
    Easp.WF "parent.planpercent('" & FormatPercent(TakeCount / TotalNumber, 2, -1) & "');" & vbCrLf
    Easp.WF "parent.planwidth("& Fix((TakeCount / TotalNumber) * 500) &");" & vbCrLf
    Easp.WF "</script>" & vbCrLf
End Sub

Sub ErrHtml(ByVal TempTotal, ByVal TempNum, ByVal TempTitle)
    Easp.WF "<script type=""text/javascript"">" & vbCrLf
    Easp.WF "parent.plantext("& TempTotal &","& TempNum &",'" & Easp.ScriptTime & "','"& TempTitle &"');" & vbCrLf
    Easp.WF "parent.planpercent('100%');" & vbCrLf
    Easp.WF "parent.planwidth(500);" & vbCrLf
    Easp.WF "</script>" & vbCrLf
End Sub

'=============================================================================

Sub ShowHtml(ByVal TempTitle)
    Easp.WF "<script type=""text/javascript"">" & vbCrLf
    Easp.WF "parent.planhtml('"& TempTitle &"','" & Easp.ScriptTime & "');" & vbCrLf
    Easp.WF "parent.planpercent('100%');" & vbCrLf
    Easp.WF "parent.planwidth(500);" & vbCrLf
    Easp.WF "</script>" & vbCrLf
End Sub
%>