﻿<!--#include file="../../Inc/Cls_Main.Asp"-->
<!--#include file="../inc/Cls_Admin.Asp"-->
<!--#include file="../inc/Cls_MapPath.Asp"-->
<!--#include file="../Admin_Check.Asp"-->
<%
Dim CmsAdmin, Action, PageTitle
'=============================================================================
PageTitle = "自定义字段"
'=============================================================================
Set CmsAdmin = New Cls_Admin
CmsAdmin.SetAdminTitle = CmsSiteName
CmsAdmin.SetIncHtmlFile = ""
CmsAdmin.SetBodyCssName = "htmlbody"
CmsAdmin.SetAdminPath = "../"
CmsAdmin.LoadHead()
'=============================================================================
Action = Easp.Get("action:s")
Select Case Action
    Case "add"
        Call SaveAdd()
    Case "edit"
        Call SaveEdit()
    Case "del"
        Call DelData()
End Select
CmsAdmin.LoadFooter()
Set CmsAdmin = Nothing

Sub SaveAdd()
    Dim Channel, Title, FieldName, FieldType, FieldNull, FieldNotNull, ShowPx
    '=====================================================================
    Channel = Easp.Post("Channel:n:0")
    Title = Easp.Post("Title:s")
    FieldName = Easp.Post("FieldName:s")
    FieldType = Easp.Post("FieldType:n:0")
    FieldNull = Easp.Post("FieldNull:s")
    FieldNotNull = Easp.Post("FieldNotNull:s")
    ShowPx = Easp.Post("ShowPx:n:0")
    '=====================================================================
    If Channel = 0 Then
        CmsAdmin.Error_Msg("<li>所属频道必须选择!</li>")
    End If
    If Len(Title) = 0 Then
        CmsAdmin.Error_Msg("<li>字段标题必须填写!</li>")
    End If
    If Len(FieldName) = 0 Then
        CmsAdmin.Error_Msg("<li>字段名称必须填写!</li>")
    End If
    If FieldType = 0 Then
        CmsAdmin.Error_Msg("<li>字段类型必须选择!</li>")
    End If
    FieldName = "zdy_" & FieldName
    If CmsMain.IsFieldsText(CmsFun.GetChannelField(Channel, "TabName"), FieldName) Then
        CmsAdmin.Error_Msg("<li>指定的字段名称已经存在!</li>")
    End If
    '=====================================================================
    Dim List, ResultVal
    Easp.Use "list"
    Set List = Easp.List.New
    List("Channel") = Channel
    List("Title") = Title
    List("FieldName") = FieldName
    List("FieldType") = FieldType
    List("FieldNull") = FieldNull
    List("FieldNotNull") = FieldNotNull
    List("ShowPx") = ShowPx
    List("AddTime") = Now()
    '=====================================================================
    ResultVal = Easp.db.AR(TablePrefix & "Field", List.Hash)
    '=====================================================================
    Easp.C List
    If ResultVal <> 0 Then
        CreateField Channel, FieldName, FieldType
        CmsAdmin.Succeed "<li>添加"& PageTitle &"数据成功!</li>", "Admin_Index.Asp"
    End If
    '=====================================================================
End Sub

Sub SaveEdit()
    Dim Id, Channel, Title, FieldNull, FieldNotNull, ShowPx, ToUrl
    Id = Easp.Post("Id:n:0")
    If Id = 0 Then
        CmsAdmin.Error_Msg("<li>缺少"& PageTitle &"编辑对象!</li>")
    End If
    '=====================================================================
    Title = Easp.Post("Title:s")
    FieldNull = Easp.Post("FieldNull:s")
    FieldNotNull = Easp.Post("FieldNotNull:s")
    ShowPx = Easp.Post("ShowPx:n:0")
    ToUrl = Easp.Post("ToUrl:s")
    '=====================================================================
    Dim List, ResultVal
    Easp.Use "list"
    Set List = Easp.List.New
    List("Title") = Title
    List("FieldNull") = FieldNull
    List("FieldNotNull") = FieldNotNull
    List("ShowPx") = ShowPx
    '=====================================================================
    ResultVal = Easp.db.UR(TablePrefix & "Field", " id = "& Id &" ", List.Hash)
    '=====================================================================
    Easp.C List
    If ResultVal <> 0 Then
        CmsAdmin.Succeed "<li>编辑"& PageTitle &"数据成功!</li>", ToUrl
    End If
    '=====================================================================
End Sub

Sub DelData()
    Dim id, ResultVal, oRs, DelTableName, DelTableField
    id = Easp.Get("id:n:0")
    If (id = 0 Or Easp.IsN(id)) Then
        CmsAdmin.Error_Msg("<li>未选择"& PageTitle &"操作选项</li>")
    End If
    Set oRs = Easp.db.GR(TablePrefix & "Field:Channel,FieldName:1", " id = "& id &" ", "")
    If Not oRs.EOF Then
        DelTableName = oRs(0)
        DelTableField = oRs(1)
        If CmsMain.IsFieldsText(CmsFun.GetChannelField(DelTableName, "TabName"), DelTableField) Then
            CmsMain.DelColumn CmsFun.GetChannelField(DelTableName, "TabName"), DelTableField
        End If
    End If
    Easp.db.C oRs
    ResultVal = Easp.db.DR(TablePrefix & "Field", "id:" & id)
    If ResultVal <> 0 Then
        CmsAdmin.Succeed_Load("<li>删除"& PageTitle &"成功!</li>")
    End If
End Sub

Function CreateField(ByVal ChannelId, ByVal FieldName, ByVal FieldType)
    If (CmsFun.ChkNumEric(ChannelId) = 0 Or Easp.IsN(FieldName) Or CmsFun.ChkNumEric(FieldType) = 0) Then
        Exit Function
    Else
        Dim StrFieldType
        StrFieldType = CmsFun.ChkNumEric(FieldType)
        Select Case StrFieldType
            Case 1, 2, 3
                CmsMain.AddColumn CmsFun.GetChannelField(ChannelId, "TabName"), FieldName, " nvarchar(255) Null"
            Case 4, 7
                CmsMain.AddColumn CmsFun.GetChannelField(ChannelId, "TabName"), FieldName, " int default 0"
            Case 5, 6
                CmsMain.AddColumn CmsFun.GetChannelField(ChannelId, "TabName"), FieldName, " text Null"
        End Select
    End If
End Function
%>