<?xml version="1.0" encoding="GB2312"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" omit-xml-declaration = "yes" indent="yes" version="4.0"/>
	<!--
	Copyright (C) 2007,2008 NewAsp.Net. All rights reserved.
	Written by newasp.cn Sunwin
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="/xml/@name='share'">
			<xsl:choose>
				<xsl:when test="/xml/@action='1'">
					<xsl:call-template name="sharelist"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="topsharelist"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:when test="/xml/@name='users'">
			<xsl:call-template name="userinfolist"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:choose>
				<xsl:when test="/xml/@action='1'">
					<xsl:call-template name="hotquestion"/>
				</xsl:when>
				<xsl:when test="/xml/@action='2'">
					<xsl:call-template name="rewardquestion"/>
				</xsl:when>
				<xsl:when test="/xml/@action='3'">
					<xsl:call-template name="hotquestion"/>
				</xsl:when>
				<xsl:when test="/xml/@action='5'">
					<xsl:call-template name="questionlist"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="newquestion"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="newquestion">
	<ul>
		<xsl:for-each select="xml/topic/row">
			<li><span class="listletBox">[<a rel="external" href="{$installdir}showlist.asp?classid={@classid}"><xsl:value-of select="@classname" disable-output-escaping="yes"/></a>]</span>
			<span class="listrgtBox"><xsl:value-of select="@dateandtime" disable-output-escaping="yes"/></span>
			<span class="title">
			<a rel="external" href="{$installdir}question.asp?topicid={@topicid}">
			<xsl:choose>
				<xsl:when test="string-length(@title) &gt; 26 "><xsl:value-of select="concat(substring(@title,0,26),'..','..')" disable-output-escaping="yes"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="@title" disable-output-escaping="yes"/></xsl:otherwise>
			</xsl:choose>
			</a></span></li>
		</xsl:for-each>
	</ul>
</xsl:template>
<xsl:template name="hotquestion">
	<ul>
		<xsl:for-each select="xml/topic/row">
			<li><span class="listletBox">[<a rel="external" href="{$installdir}showlist.asp?classid={@classid}"><xsl:value-of select="@classname" disable-output-escaping="yes"/></a>]</span>
			<span class="listrgtBox"><xsl:value-of select="@hits" disable-output-escaping="yes"/></span>
			<span class="title">
			<a rel="external" href="{$installdir}question.asp?topicid={@topicid}">
			<xsl:choose>
				<xsl:when test="string-length(@title) &gt; 26 "><xsl:value-of select="concat(substring(@title,0,26),'..','..')" disable-output-escaping="yes"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="@title" disable-output-escaping="yes"/></xsl:otherwise>
			</xsl:choose>
			</a></span></li>
		</xsl:for-each>
	</ul>
</xsl:template>
<xsl:template name="rewardquestion">
	<ul>
		<xsl:for-each select="xml/topic/row">
			<li><span class="listletBox">[<a rel="external" href="{$installdir}showlist.asp?classid={@classid}"><xsl:value-of select="@classname" disable-output-escaping="yes"/></a>]</span>
			<span class="listrgtBox"><xsl:value-of select="@reward" disable-output-escaping="yes"/></span>
			<span class="title">
			<a rel="external" href="{$installdir}question.asp?topicid={@topicid}">
			<xsl:choose>
				<xsl:when test="string-length(@title) &gt; 26 "><xsl:value-of select="concat(substring(@title,0,26),'..','..')" disable-output-escaping="yes"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="@title" disable-output-escaping="yes"/></xsl:otherwise>
			</xsl:choose>
			</a></span></li>
		</xsl:for-each>
	</ul>
</xsl:template>
<xsl:template name="questionlist">
	<ul>
		<xsl:for-each select="xml/topic/row">
			<li><a rel="external" href="{$installdir}question.asp?topicid={@topicid}">
			<xsl:value-of select="@title" disable-output-escaping="yes"/>
			</a></li>
		</xsl:for-each>
	</ul>
</xsl:template>
<xsl:template name="userinfolist">
	<ul class="userliststrap">
		<xsl:for-each select="xml/users/row">
			<li><span style="float:right;margin:0 5px;"><xsl:value-of select="@points" disable-output-escaping="yes"/></span><a rel="external" href="{$installdir}usertopic.asp?userid={@userid}"><xsl:value-of select="@username" disable-output-escaping="yes"/></a></li>
		</xsl:for-each>
	</ul>
</xsl:template>
<xsl:template name="topsharelist">
	<ul>
		<xsl:for-each select="xml/topic/row">
			<li><a rel="external" href="{$installdir}share.asp?topicid={@topicid}">
			<xsl:choose>
				<xsl:when test="string-length(@title) &gt; 30 "><xsl:value-of select="concat(substring(@title,0,30),'..','..')" disable-output-escaping="yes"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="@title" disable-output-escaping="yes"/></xsl:otherwise>
			</xsl:choose>
			</a></li>
		</xsl:for-each>
	</ul>
</xsl:template>
<xsl:template name="sharelist">
	<ul>
		<xsl:for-each select="xml/topic/row">
			<li><a rel="external" href="{$installdir}share.asp?topicid={@topicid}">
			<xsl:value-of select="@title" disable-output-escaping="yes"/>
			</a></li>
		</xsl:for-each>
	</ul>
</xsl:template>
</xsl:stylesheet>