<?xml version="1.0" encoding="GB2312"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" omit-xml-declaration = "yes" indent="yes" version="4.0"/>
	<!--
	Copyright (C) 2007,2008 NewAsp.Net. All rights reserved.
	Written by newasp.cn Sunwin
	-->
<xsl:variable name="nowuserid">
	<xsl:value-of select="xml/@userid" disable-output-escaping="yes"/>
</xsl:variable>
<xsl:variable name="askedtitle">
	<xsl:value-of select="xml/topic/@title" disable-output-escaping="yes"/>
</xsl:variable>
<xsl:template match="/">
	<iframe name="_hideframe" style="display:none;"></iframe>
	<xsl:if test="/xml/postlist/row/@postsmode='0'">
		<xsl:call-template name="post_question"/>
	</xsl:if>
	<xsl:if test="/xml/@satisanswer &gt; 0">
		<xsl:call-template name="satis_answer"/>
	</xsl:if>
	<xsl:if test="/xml/@otheranswer &gt; 0">
		<xsl:call-template name="post_answer"/>
	</xsl:if>
	<xsl:if test="/xml/@nowcommentnum &gt; 0">
		<xsl:call-template name="answer_comment"/>
	</xsl:if>
	<xsl:if test="/xml/@closetopic='0' and /xml/topic/@topicmode='0'">
		<xsl:if test="/xml/@isnowuser='0' and /xml/@allowanswers='1'">
			<xsl:call-template name="post_answerform"/>
		</xsl:if>
	</xsl:if>
	<xsl:if test="/xml/@closetopic='0' and /xml/topic/@topicmode='1'">
		<xsl:if test="/xml/@allowcomment='1'">
			<xsl:call-template name="post_commentform"/>
		</xsl:if>
	</xsl:if>
</xsl:template>
<xsl:template name="post_question">
	<xsl:for-each select="xml/postlist/row[@postsmode=0]">
	<xsl:variable name="thisuserid" select="@userid"/>
	<div id="mainTopicZone">
		<h2><span class="headline"><img src="{$installdir}images/icons/icon_0{/xml/@icons}.gif" border="0"/> 
		<xsl:choose>
			<xsl:when test="/xml/@icons='1'"> ѽ</xsl:when>
			<xsl:when test="/xml/@icons='2'"> ͶƱ</xsl:when>
			<xsl:when test="/xml/@icons='3'"> û</xsl:when>
			<xsl:when test="/xml/@icons='4'"> ѹ</xsl:when>
			<xsl:when test="/xml/@icons='5'"> ѹر</xsl:when>
			<xsl:otherwise> δ</xsl:otherwise>
		</xsl:choose>
		</span>
		<xsl:if test="/xml/@isnowuser=0">
			<span class="headside"><img src="{$installdir}images/icons/icon_13.gif" border="0"/> <a target="_hideframe" href="{$installdir}userfavorite.asp?action=add&amp;topicid={@topicid}" title="ղصĸģԱ´β鿴">ղ</a></span>
		</xsl:if>
		</h2>
		<h1 class="title"><xsl:value-of select="/xml/topic/@title" disable-output-escaping="yes"/>
		</h1>
		<div id="questioninfo">
			<div style="color:#7c7c7c;"><xsl:if test="/xml/@icons='0'">
			<xsl:if test="/xml/topic/@reward &gt; 0"><span class="reward"><img src="{$installdir}images/icons/icon_10.gif" border="0"/></span><span><font color="red"><xsl:value-of select="/xml/topic/@reward" disable-output-escaping="yes"/></font></span> </xsl:if>
			<xsl:if test="/xml/@remaindays &gt; 0"><span class="remain"> -  <xsl:value-of select="/xml/@remaindays" disable-output-escaping="yes"/>  <xsl:value-of select="/xml/@remainhour" disable-output-escaping="yes"/> Сʱ</span></xsl:if>
		</xsl:if>
		&amp;nbsp;&amp;nbsp;
		 <xsl:value-of select="/xml/topic/@hits" disable-output-escaping="yes"/>&amp;nbsp;&amp;nbsp;
		<xsl:choose>
			<xsl:when test="/xml/topic/@topicmode='1'">ʱ <xsl:value-of select="/xml/topic/@lastposttime" disable-output-escaping="yes"/></xsl:when>
			 <xsl:otherwise>ʱ <xsl:value-of select="/xml/topic/@dateandtime" disable-output-escaping="yes"/></xsl:otherwise>
		</xsl:choose>
			</div>
			<div class="content"><xsl:value-of select="@content" disable-output-escaping="yes"/></div>
			<xsl:if test="/xml/topic/@supplement &gt; 0">
				<div id="supplement"><span id="suptitle">ⲹ䣺</span><br/><xsl:value-of select="@addtext" disable-output-escaping="yes"/></div>
			</xsl:if>
			<div class="askPostInfo"><span class="post1">
			<xsl:if test="/xml/@closetopic='0'">
			<xsl:choose>
				<xsl:when test="/xml/topic/@userid = $nowuserid">
					<xsl:if test="/xml/topic/@topicmode='0'">
						<a class="btn1" href="#adopt"></a>
						<a class="btn1" href="#" onClick="openWindow('{$installdir}handle.asp?action=1&amp;topicid={@topicid}',540,240,''); return false;"></a>
						<a class="btn1" href="#" onClick="openWindow('{$installdir}handle.asp?action=2&amp;topicid={@topicid}',540,220,''); return false;"></a>
						<a class="btn1" href="#" onClick="openWindow('{$installdir}handle.asp?action=3&amp;topicid={@topicid}',560,180,''); return false;"></a>
					</xsl:if>
					<xsl:if test="/xml/topic/@topicmode='1'"><a class="btn1" href="#post"></a></xsl:if>
					<xsl:if test="/xml/topic/@topicmode &gt; 1"> &amp;nbsp;</xsl:if>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="/xml/topic/@topicmode='0'"><a class="btn1" href="#post">ش</a></xsl:if>
					<xsl:if test="/xml/topic/@topicmode='1'"><a class="btn1" href="#post"></a></xsl:if>
				</xsl:otherwise>
			</xsl:choose>
			</xsl:if>
			<xsl:if test="/xml/@closetopic='1'">&amp;nbsp;&amp;nbsp;</xsl:if>
			</span>
			<span class="post2">ߣ
			<xsl:choose>
			<xsl:when test="/xml/topic/@anonymous=1"></xsl:when>
			<xsl:otherwise>
				<a href="{$installdir}usertopic.asp?userid={@userid}" target="_blank"><xsl:value-of select="/xml/topic/@postusername" disable-output-escaping="yes"/></a> 
			</xsl:otherwise>
			</xsl:choose>
			 &amp;nbsp;&amp;nbsp;
			ȼ<a href="{$installdir}usertopic.asp?userid={@userid}&amp;topicmode=1" target="_blank"><xsl:value-of select="/xml/userlist/user[@userid=$thisuserid]/@usertitle"/></a>&amp;nbsp;&amp;nbsp;
			</span></div>
		</div>
	</div>
	<div style="clear:both"></div>
	</xsl:for-each>
</xsl:template>
<xsl:template name="post_answer">
<xsl:variable name="adoptanswerform1">
	<![CDATA[<form method="post" name="bestanswerform" id="bestanswerform" action="{$installdir}handle.asp?action=selbest" target="_hideframe" autocomplete="off">]]>
</xsl:variable>
<xsl:variable name="adoptanswerform2">
	<![CDATA[</form>]]>
</xsl:variable>
	<div id="mainAnswerZone">
		<xsl:if test="(/xml/topic/@topicmode='0' or /xml/topic/@topicmode='2') and /xml/@isnowuser=1">
			<xsl:value-of select="$adoptanswerform1" disable-output-escaping="yes"/>
			<input type="hidden" name="TopicID" id="TopicID" value="{/xml/topic/@topicid}"/>
			<input type="hidden" name="direct" id="direct" value="1"/>
		</xsl:if>
		<h2>ش<xsl:value-of select="/xml/topic/@title" disable-output-escaping="yes"/></h2>
		<xsl:for-each select="xml/postlist/row[@postsmode=1 and @satis=0]">
			<xsl:variable name="thisuserid" select="@userid"/>
			<div class="content">
			<xsl:if test="(/xml/topic/@topicmode='0' or /xml/topic/@topicmode='2') and /xml/@isnowuser=1">
				<span style="float:left;font-size:12px;color:#7C7C7C;"><input type="checkbox" name="bestAnswerID" value="{@postsid}" onclick="checkBestStar(this,'star{@postsid}');" title="ѡĴ"/> </span>
				<span id="star{@postsid}" style="display:none">
				<input value="1" type="radio" name="star_{@postsid}"></input><img src="{$installdir}images/star/s1.gif" />
				<input value="2" type="radio" name="star_{@postsid}"></input><img src="{$installdir}images/star/s2.gif" />
				<input value="3" type="radio" checked="true" name="star_{@postsid}"></input><img src="{$installdir}images/star/s3.gif" />
				<input value="4" type="radio" name="star_{@postsid}"></input><img src="{$installdir}images/star/s4.gif" />
				<input value="5" type="radio" name="star_{@postsid}"></input><img src="{$installdir}images/star/s5.gif" /><span style="font-size:12px;color:#7C7C7C;">(ѡ𰸲)</span><br class="x"/>
				</span>
			</xsl:if>
			<xsl:value-of select="@content" disable-output-escaping="yes"/></div>
			<xsl:if test="/xml/topic/@topicmode='2'">
				<div class="voteinfo">
					<xsl:if test="/xml/@isnowuser=0">
						<a class="btn1" href="{$installdir}handle.asp?action=vote&amp;topicid={@topicid}&amp;postsid={@postsid}" target="_hideframe">ͶһƱ</a>&amp;nbsp;&amp;nbsp;
					</xsl:if>
					ѻ<xsl:value-of select="@votenum" disable-output-escaping="yes"/>Ʊ
				</div>
			</xsl:if>
			<div class="AnswerBot">
			<xsl:choose>
				<xsl:when test="(/xml/topic/@topicmode='0' or /xml/topic/@topicmode='2') and /xml/@isnowuser='1' and /xml/@allowdeletes='1'"><span onclick="checkDelAnswer('{$installdir}handle.asp?action=delanswer&amp;topicid={@topicid}&amp;postsid={@postsid}');"><a href="javascript:;">ɾ</a></span></xsl:when>
				<xsl:otherwise><span><img src="{$installdir}images/icons/icon_14.gif" border="0"/> <a href="" target="_blank">ٱ</a></span></xsl:otherwise>
			</xsl:choose>
			شߣ<a href="{$installdir}usertopic.asp?userid={@userid}&amp;topicmode=1" target="_blank"><xsl:value-of select="@username" disable-output-escaping="yes"/></a>&amp;nbsp;&amp;nbsp;
			ȼ<a href="{$installdir}usertopic.asp?userid={@userid}&amp;topicmode=0" target="_blank"><xsl:value-of select="/xml/userlist/user[@userid=$thisuserid]/@usertitle"/></a>&amp;nbsp;&amp;nbsp;
			شʱ <xsl:value-of select="@posttime" disable-output-escaping="yes"/></div>
		</xsl:for-each>
		<xsl:if test="(/xml/topic/@topicmode='0' or /xml/topic/@topicmode='2') and /xml/@isnowuser=1">
			<div class="adoptAnswer"><a name="adopt"></a><input type="submit" name="staisubmit" value="Ϊ" onclick="return checkBestAnswerSubmit(this.form);"/>&amp;nbsp;&amp;nbsp; 
			<xsl:if test="/xml/topic/@topicmode='0' and /xml/topic/@postnum &gt; 0">
				<input type="button" name="closebtn" value="ر" onclick="openWindow('{$installdir}handle.asp?action=3&amp;topicid={/xml/topic/@topicid}',560,180,'ر'); return false;"/>&amp;nbsp;&amp;nbsp; 
			</xsl:if>
			<xsl:if test="/xml/topic/@topicmode='0' and /xml/topic/@postnum &gt; 1">
				<a href="{$installdir}handle.asp?action=selvote&amp;topicid={/xml/topic/@topicid}" target="_hideframe"><u>ͶƱ</u></a>
			</xsl:if></div>
			<xsl:value-of select="$adoptanswerform2" disable-output-escaping="yes"/>
		</xsl:if>
	</div>
	<div style="clear:both"></div>
</xsl:template>

<xsl:template name="answer_comment">
	<div id="commentZone">
	<div id="answerComment">
		<h2>ۣ<xsl:value-of select="/xml/topic/@title" disable-output-escaping="yes"/></h2>
		<xsl:for-each select="xml/commentlist/row">
		<xsl:variable name="thisuserid" select="@userid"/>
		<hr/>
		<div class="content"><xsl:value-of select="@content" disable-output-escaping="yes"/></div>
		<div class="AnswerBot">
		<xsl:choose>
			<xsl:when test="/xml/@closetopic='0' and /xml/@isnowuser='1' and /xml/@allowdeletes='1'"><span onclick="checkDelComment('{$installdir}handle.asp?action=delcomment&amp;topicid={@topicid}&amp;commentid={@commentid}');"><a href="#">ɾ</a></span></xsl:when>
			<xsl:otherwise><span><a href="{$installdir}handle.asp" target="_blank">ٱ</a></span></xsl:otherwise>
		</xsl:choose>
		ˣ<a href="{$installdir}usertopic.asp?userid={@userid}" target="_blank"><xsl:value-of select="@username" disable-output-escaping="yes"/></a>&amp;nbsp;&amp;nbsp;
		ȼ<a href="{$installdir}usertopic.asp?userid={@userid}&amp;topicmode=1" target="_blank"><xsl:value-of select="/xml/userlist/user[@userid=$thisuserid]/@usertitle" disable-output-escaping="yes"/></a>&amp;nbsp;&amp;nbsp;
		شʱ <xsl:value-of select="@posttime" disable-output-escaping="yes"/></div>
		</xsl:for-each>
	</div>
	</div>
	<div style="clear:both"></div>
</xsl:template>
<xsl:template name="satis_answer">
<xsl:for-each select="xml/postlist/row[@postsmode=1 and @satis=1]">
	<xsl:variable name="thisuserid" select="@userid"/>
	<div class="satisAnswerZone">
		<table width="100%" height="49" cellpadding="0" cellspacing="0">
		<tr>
			<td width="60" valign="top" align="right"><img src="{$installdir}images/icons/icon_11n.gif"/></td>
			<td width="60" valign="top"><span style="color:#F0870A;font-weight:bold;padding:0 0 0 5px;"></span><br/><img src="{$installdir}images/star/s{@star}.gif" style="margin:10px 0 0 5px;"/></td>
			<td valign="top"><span style="color:#F0870A;font-weight:bold;padding:2px 0 0 5px;"></span></td>
		</tr>
		</table>
		<div class="content"><xsl:value-of select="@content" disable-output-escaping="yes"/></div>
		<div class="satisinfo"><span><img src="{$installdir}images/icons/icon_14.gif" border="0"/> <a href="#" target="_blank">ٱ</a></span>
		شߣ<a href="{$installdir}usertopic.asp?userid={@userid}&amp;topicmode=1" target="_blank"><xsl:value-of select="@username" disable-output-escaping="yes"/></a>&amp;nbsp;&amp;nbsp;
		ȼ<a href="{$installdir}usertopic.asp?userid={@userid}&amp;topicmode=0" target="_blank"><xsl:value-of select="/xml/userlist/user[@userid=$thisuserid]/@usertitle"/></a>&amp;nbsp;&amp;nbsp;
		شʱ <xsl:value-of select="@posttime" disable-output-escaping="yes"/> </div>
	</div>
	<div style="clear:both"></div>
</xsl:for-each>
</xsl:template>
<xsl:template name="post_answerform">
	<div id="postAnswerZone">
		<form method="post" name="answerform" id="answerform" action="postsave.asp" target="_hideframe">
		<div id="postAnswer">
			<input type="hidden" name="action" value="saveanswer"/>
			<input type="hidden" name="topicid" value="{/xml/topic/@topicid}"/>
			<a name="post"></a>
			<xsl:choose>
				<xsl:when test="$nowuserid=0">
					<textarea name="TextContent" id="TextContent" disabled="disabled" wrap="PHYSICAL" style="width:100%;height:100px;padding:4px;">װûûе¼ȵ¼</textarea><br/><br class="x"/>
					<input type="submit" name="answerSubmit" id="answerSubmit" disabled="disabled" value="ύش" class="btn2" style="margin-right:10px;"/>
					<script language="JavaScript">document.writeln('<a href="'+sitePath+'login.asp?ReturnURL=' +window.location.href + '">¼</a>');</script> 
					<span style="color:#7C7C7C">(һλشɻ<xsl:value-of select="xml/@answerpoint" disable-output-escaping="yes"/>֣𰸱ɻɻͷֺͶ<xsl:value-of select="xml/@acceptpoint" disable-output-escaping="yes"/>ֽ)</span>
				</xsl:when>
				<xsl:otherwise>
					<textarea name="TextContent" id="TextContent" wrap="PHYSICAL" style="width:100%;height:100px;padding:4px;"></textarea><br/><br class="x"/>
					<input type="submit" name="answerSubmit" id="answerSubmit" value="ύش" class="btn2" style="margin-right:10px;"/>
					<span style="color:#7C7C7C">(һλشɻ<xsl:value-of select="xml/@answerpoint" disable-output-escaping="yes"/>֣𰸱ɻɻͷֺͶ<xsl:value-of select="xml/@acceptpoint" disable-output-escaping="yes"/>ֽ)</span>
				</xsl:otherwise>
			</xsl:choose>
		</div>
		</form>
	</div>
	<div style="clear:both"></div>
</xsl:template>
<xsl:template name="post_commentform">
	<div id="postAnswerZone">
		<form method="post" name="answerform" id="answerform" action="postsave.asp" target="_hideframe">
		<div id="postAnswer">
			<input type="hidden" name="action" value="savecomment"/>
			<input type="hidden" name="topicid" value="{/xml/topic/@topicid}"/>
			<a name="post"></a>
			<xsl:choose>
				<xsl:when test="$nowuserid=0">
					<textarea name="TextContent" id="TextContent" disabled="disabled" wrap="PHYSICAL" style="width:100%;height:100px;padding:4px;">װûûе¼ȵ¼</textarea><br/><br class="x"/>
					<input type="submit" name="answerSubmit" id="answerSubmit" disabled="disabled" value="ύ" class="btn2" style="margin-right:10px;"/>
					<script language="JavaScript">document.writeln('<a href="'+sitePath+'login.asp?ReturnURL=' +window.location.href + '">¼</a>');</script> 
				</xsl:when>
				<xsl:otherwise>
					<textarea name="TextContent" id="TextContent" wrap="PHYSICAL" style="width:100%;height:100px;padding:4px;"></textarea><br/><br class="x"/>
					<input type="submit" name="answerSubmit" id="answerSubmit" value="ύ" class="btn2" style="margin-right:10px;"/>
				</xsl:otherwise>
			</xsl:choose>
		</div>
		</form>
	</div>
	<div style="clear:both"></div>
</xsl:template>
<xsl:template name="share_topic">
</xsl:template>
<xsl:template name="share_reply">
</xsl:template>
<xsl:template name="share_form">
</xsl:template>
</xsl:stylesheet>