<%
Response.Buffer = EW_RESPONSE_BUFFER
%>
<!--#include file="ewcfg7.asp"-->
<!--#include file="zlogininfo.asp"-->
<!--#include file="aspfn7.asp"-->
<!--#include file="userfn7.asp"-->
<% Session.Timeout = 900 %>
<%
Response.Expires = 0
Response.ExpiresAbsolute = Now() - 1
Response.AddHeader "pragma", "no-cache"
Response.AddHeader "cache-control", "private, no-cache, no-store, must-revalidate"
%>
<%

' Define page object
Dim default
Set default = New cdefault
Set Page = default

' Page init processing
Call default.Page_Init()

' Page main processing
Call default.Page_Main()
%>
<%

' Drop page object
Set default = Nothing
%>
<%

' -----------------------------------------------------------------
' Page Class
'
Class cdefault

	' Page ID
	Public Property Get PageID()
		PageID = "default"
	End Property

	' Page Object Name
	Public Property Get PageObjName()
		PageObjName = "default"
	End Property

	' Page Name
	Public Property Get PageName()
		PageName = ew_CurrentPage()
	End Property

	' Page Url
	Public Property Get PageUrl()
		PageUrl = ew_CurrentPage() & "?"
	End Property

	' Message
	Public Property Get Message()
		Message = Session(EW_SESSION_MESSAGE)
	End Property

	Public Property Let Message(v)
		If Session(EW_SESSION_MESSAGE) <> "" Then ' Append
			Session(EW_SESSION_MESSAGE) = Session(EW_SESSION_MESSAGE) & "<br>" & v
		Else
			Session(EW_SESSION_MESSAGE) = v
		End If
	End Property

	' Show Message
	Public Sub ShowMessage()
		If Message <> "" Then ' Message in Session, display
			Response.Write "<p><span class=""ewMessage"">" & Message & "</span></p>"
			Session(EW_SESSION_MESSAGE) = "" ' Clear message in Session
		End If
	End Sub

	' -----------------------
	'  Validate Page request
	'
	Public Function IsPageRequest()
		IsPageRequest = True
	End Function

	' -----------------------------------------------------------------
	'  Class initialize
	'  - init objects
	'  - open ADO connection
	'
	Private Sub Class_Initialize()

		' Initialize user table object
		Set zlogin = New czlogin

		' Initialize form object
		Set ObjForm = Nothing

		' Intialize page id (for backward compatibility)
		EW_PAGE_ID = "default"

		' Open connection to the database
		Set Conn = Server.CreateObject("ADODB.Connection")
		Conn.Open EW_DB_CONNECTION_STRING
	End Sub

	' -----------------------------------------------------------------
	'  Subroutine Page_Init
	'  - called before page main
	'  - check Security
	'  - set up response header
	'  - call page load events
	'
	Sub Page_Init()
		Set Security = New cAdvancedSecurity

		' Global page loading event (in userfn7.asp)
		Call Page_Loading()

		' Page load event, used in current page
		Call Page_Load()
	End Sub

	' -----------------------------------------------------------------
	'  Class terminate
	'  - clean up page object
	'
	Private Sub Class_Terminate()
		Call Page_Terminate("")
	End Sub

	' -----------------------------------------------------------------
	'  Subroutine Page_Terminate
	'  - called when exit page
	'  - clean up ADO connection and objects
	'  - if url specified, redirect to url
	'
	Sub Page_Terminate(url)

		' Page unload event, used in current page
		Call Page_Unload()

		' Global page unloaded event (in userfn60.asp)
		Call Page_Unloaded()
		If Not (Conn Is Nothing) Then Conn.Close ' Close Connection
		Set Conn = Nothing
		Set Security = Nothing

		' Go to url if specified
		If url <> "" Then
			Response.Clear
			Response.Redirect url
		End If
	End Sub

	'
	'  Subroutine Page_Terminate (End)
	' ----------------------------------------
	' Page main processing
	Sub Page_Main()
		If Not Security.IsLoggedIn() Then Call Security.AutoLogin()
		Call Security.LoadUserLevel() ' load user level
		If Security.AllowList("bhlm") Then
			Call Page_Terminate("bhlmlist.asp") ' Exit and go to default page
		End If
		If Security.AllowList("xwlm") Then
			Call Page_Terminate("xwlmlist.asp")
		End If
		If Security.AllowList("xwfb") Then
			Call Page_Terminate("xwfblist.asp")
		End If
		If Security.AllowList("login") Then
			Call Page_Terminate("zloginlist.asp")
		End If
		If Security.AllowList("UserLevelPermissions") Then
			Call Page_Terminate("UserLevelPermissionslist.asp")
		End If
		If Security.AllowList("UserLevels") Then
			Call Page_Terminate("UserLevelslist.asp")
		End If
		If Security.AllowList("webset") Then
			Call Page_Terminate("websetlist.asp")
		End If
		If Security.AllowList("webseo") Then
			Call Page_Terminate("webseolist.asp")
		End If
		If Security.AllowList("sjlm") Then
			Call Page_Terminate("sjlmlist.asp")
		End If
		If Security.AllowList("dc") Then
			Call Page_Terminate("dclist.asp")
		End If
		If Security.AllowList("lx") Then
			Call Page_Terminate("lxlist.asp")
		End If
		If Security.AllowList("pp") Then
			Call Page_Terminate("pplist.asp")
		End If
		If Security.AllowList("ys") Then
			Call Page_Terminate("yslist.asp")
		End If
		If Security.AllowList("zw") Then
			Call Page_Terminate("zwlist.asp")
		End If
		If Security.IsLoggedIn() Then
			Response.Write "Ȩ鿴"
			Response.Write "<br><a href=""logout.asp"">ص½ҳ</a>"
		Else
			Call Page_Terminate("login.asp") ' Exit and go to login page
		End If
	End Sub

	' Page Load event
	Sub Page_Load()

		'Response.Write "Page Load"
	End Sub

	' Page Unload event
	Sub Page_Unload()

		'Response.Write "Page Unload"
	End Sub
End Class
%>
