<%
Class Cls_ComFunc

	Private o_tmp

	Private Sub Class_Initialize()
		Set o_tmp = New Cls_ComFunc_Tmp
	End Sub

	Private Sub Class_Terminate()
		Set o_tmp = Nothing
	End Sub

	Public Function CLeft(ByVal s, ByVal m)
		CLeft = LR(s,m,0)
	End Function

	Public Function CRight(ByVal s, ByVal m)
		CRight = LR(s,m,1)
	End Function

	Public Function LR(ByVal s, ByVal m, ByVal t)
		Dim n : n = Instr(s,m)
		If n>0 Then
			If t = 0 Then
				LR = Left(s,n-1)
			ElseIf t = 1 Then
				LR = Mid(s,n+Len(m))
			End If
		Else
			If t = 0 Then
				LR = s
			Else
				LR = ""
			End If
		End If
	End Function

	Public Function NewRs()
		Set NewRs = Server.CreateObject("Adodb.Recordset")
	End Function

	Public Function Dict() '创建新字典
		Dim d : Set d = Server.CreateObject("Scripting.Dictionary") : d.CompareMode = 1
		Set Dict = d
		Set d = Nothing
	End Function

	Function IsInt(Byval s)
		Dim stype: stype = Lcase(TypeName(s))
		IF stype="integer" Or stype="long" Or stype="double" Or stype="single" Then
			IsInt = True
		Else
			IsInt = False
		End IF
	End Function

	Function IsNum(Byval s)
		On Error Resume Next
		'Rem 用IsNumeric可能存在Bug,弃用!
		'IF Not IsNull(s) and Trim(s)<>"" Then:IsNum=IsNumeric(s):Else:IsNum=False:End IF
		IsNum = RegTest(s, "^\d+$")
		On Error Goto 0
	End Function

	Function isStr(Byval s)
		isStr = False
		If Not IsObject(s) And VarType(s) = vbString Then isStr = True
	End Function

	Function isDict(Byval o)
		isDict = False
		If IsObject(o) and TypeName(o) = "Dictionary" Then isDict = True
	End Function

	Function isRs(Byval o)
		isRs = False
		If IsObject(o) and TypeName(o) = "Recordset" Then isRs = True
	End Function

	Public Function isNul(ByVal s)
		On Error Resume Next:IF Err.Number<>0 Then Err.Clear
		isNul = False
		Select Case VarType(s)
			Case vbEmpty, vbNull
				isNul = True : Exit Function
			Case vbString
				If s="" Then isNul = True : Exit Function
			Case vbObject
				Select Case TypeName(s)
					Case "Nothing","Empty"
						isNul = True : Exit Function
					Case "Recordset"
						If s.State = 0 Then isNul = True : Exit Function
						If s.Bof And s.Eof Then isNul = True : Exit Function
					Case "Dictionary"
						If s.Count = 0 Then isNul = True : Exit Function
				End Select
			Case vbArray,8194,8204,8209
				If Ubound(s)=-1 Then isNul = True : Exit Function
		End Select
		On Error Goto 0
	End Function

	Public Function Has(ByVal s)
		On Error Resume Next:Err.Clear
		Has = Not isNul(s)
		On Error Goto 0
	End Function

	Public Function NoneIs(ByVal p, ByVal s)
		Dim t : t = IsNone(s)
		If IsObject(IIF(t,p,s)) Then
			Set NoneIs = IIF(t,p,s)
		Else
			NoneIs = IIF(t,p,s)
		End If
	End Function

	Public Function IsNone(ByVal s)
		On Error Resume Next:IF Err.Number<>0 Then Err.Clear
		IsNone = False
		Select Case VarType(s)
			Case vbEmpty, vbNull
				IsNone = True : Exit Function
			Case vbString
				If Trim(s)="" Then IsNone = True : Exit Function
			Case vbObject
				Select Case TypeName(s)
					Case "Nothing","Empty"
						IsNone = True : Exit Function
					Case "Recordset"
						If s.State = 0 Then IsNone = True : Exit Function
						If s.Bof And s.Eof Then IsNone = True : Exit Function
					Case "Dictionary"
						If s.Count = 0 Then IsNone = True : Exit Function
				End Select
			Case vbArray,8194,8204,8209
				If Ubound(s)=-1 Then IsNone = True : Exit Function
				If Ubound(s)=0 Then
					If IsObject(s(0)) Or IsArray(s(0)) Then
						IsNone = False
					ElseIf VarType(s(0))=vbEmpty Or VarType(s(0))=vbNull Then
						IsNone = True
					ElseIf VarType(s(0))=vbString Then
						If Trim(s(0))="" Then IsNone = True : Exit Function
					End If
				End If
		End Select
		On Error Goto 0
	End Function

	Public Function IIF(ByVal Cn, ByVal T, ByVal F)
		If Cn Then
			If IsObject(T) Then
				Set IIF = T
			Else
				IIF = T
			End If
		Else
			If IsObject(F) Then
				Set IIF = F
			Else
				IIF = F
			End If
		End If
	End Function

	Public Function IfThen(ByVal Cn, ByVal T)
		If IsObject(IIF(Cn,T,"")) Then
			Set IfThen = IIF(Cn,T,"")
		Else
			IfThen = IIF(Cn,T,"")
		End If
	End Function

	Public Function RegTest(ByVal s, ByVal p)
		If isNul(s) Then RegTest = False : Exit Function
		Dim o_regex
		Set o_regex = New Regexp
		o_regex.Global = True
		o_regex.IgnoreCase = True
		o_regex.Pattern = p
		RegTest = o_regex.Test(CStr(s))
		o_regex.Pattern = ""
	End Function

	Public Function RegMatch(ByVal s, ByVal rule)
		Dim o_regex
		Set o_regex = New Regexp
		o_regex.Global = True
		o_regex.IgnoreCase = True
		o_regex.Pattern = rule
		Set RegMatch = o_regex.Execute(s)
		o_regex.Pattern = ""
	End Function

	Public Function RegReplace(ByVal s, ByVal rule, Byval Result)
		RegReplace = ReplaceX(s,rule,Result,0)
	End Function

	Public Function ReplaceX(ByVal s, ByVal rule, Byval Result, ByVal isM)
		Dim tmpStr : tmpStr = s
		Dim o_regex : Set o_regex = New Regexp
		o_regex.Global = True
		o_regex.IgnoreCase = True
		If Has(s) Then
			If isM = 1 Then o_regex.Multiline = True
			o_regex.Pattern = rule
			tmpStr = o_regex.Replace(tmpStr,Result)
			If isM = 1 Then o_regex.Multiline = False
			o_regex.Pattern = ""
		End If
		ReplaceX = tmpStr
	End Function

	Public Function RP(Byval Str, Byval FindStr, Byval RepStr)
		On Error Resume Next
		IF IsNull(Str) Or Str="" Then RP="":Exit Function
		If IsArray(FindStr) Then
			Dim i, x, y, m : i = 0 : m = Ubound(FindStr)
			If Err Then : Err.Clear : RP = Str : Exit Function : End If
			If m > 0 Then
				If IsArray(RepStr) Then
					Dim n : n = Ubound(RepStr)
					If Err Then : Err.Clear : RP = Str : Exit Function : End If
					If m >= n Then
						For i = 0 To n
							Str = Replace(Str, FindStr(i), RepStr(i))
						Next
						For i=n+1 To m
							Str = Replace(Str, FindStr(i), "")
						Next
					Else
						For i = 0 To m
							Str = Replace(Str, FindStr(i), RepStr(i))
						Next
					End If
				Else
					For i = 0 To m
						Str = Replace(Str, FindStr(i), RepStr)
					Next
				End If
				RP = Str
			End If
		Else
			If IsArray(RepStr) Then : RP = Str : Exit Function : End If
			'RP = Replace(Str,FindStr,RepStr,1,-1,1)
			RP = Replace(Str,FindStr,RepStr)
		End If
		If Err Then : Err.Clear : RP = Str : End If
		On Error Goto 0
	End Function

	Public Function [Get](Byval s)
		Dim tmp
		If Instr(s,":")>0 Then
			s = CLeft(s,":")
		End If
		tmp = Request.QueryString(s)
		[Get] = tmp
	End Function

	Function [Join](Byval p, Byval s)
		[Join] = o_tmp.strJoin(p, s)
	End Function

	Public Function Push(ByVal arr, ByVal s)
		Dim i, a : a = Me.Clone(arr)
		If Me.Len(arr)<=0 Then
			Redim Preserve a(0)
			If IsObject(s) Then Set a(0) = s Else a(0) = s
			Push = a
			Exit Function
		End If
		Redim Preserve a(UBound(arr)+1)
		If IsObject(s) Then Set a(UBound(arr)+1) = s Else a(UBound(arr)+1) = s
		Push = a
	End Function

	Public Function Clone(ByVal arr)
		Dim i, a()
		If Me.Len(arr)<=0 Then : Clone = arr: Exit Function: End If
		For i = LBound(arr) To UBound(arr)
			Redim Preserve a(i)
			If IsObject(arr(i)) Then Set a(i) = arr(i) Else a(i) = arr(i)
		Next
		Clone = a
	End Function

	Public Function [Len](Byval arr)
		On Error Resume Next
		If Not IsArray(arr) Then:[Len]=-1:End If
		Dim temp:temp=Ubound(arr)
		If Err Or temp<0 Then:[Len]=0:Err.Clear:Exit Function:End If
		Dim i,iCount:iCount=0
		For i=Lbound(arr) To Ubound(arr)
			iCount = iCount + 1
		Next
		[Len] = iCount
		On Error GoTo 0
	End Function

	Public Function Fetch(ByVal s, ByVal p)
		Dim t, e, a, i : a = Array()
		s = Trim(s)
		If p="" Then p = ","
		If s<>"" Then
			t = Split(s, p)
			For i=0 To UBound(t)
				e = Trim(t(i))
				If e<>"" Then
					If ComFun.IsNum(e) Then e = CLng(e)
					a = Me.Push(a, e)
				End If
			Next
		End If
		Fetch = a
	End Function

	Public Function [Remove](ByVal arr, ByVal p)
		Dim tmp, e, k, a() : k=0
		For Each e in arr
			If IsObject(e) Then
				If Not IsObject(p) Then
					Redim Preserve a(k)
					Set a(k) = e
					k = k+1
				Else
					If Not (e Is p) Then
						Redim Preserve a(k)
						Set a(k) = e
						k = k+1
					End If
				End If
			Else
				If e <> p Then
					Redim Preserve a(k)
					a(k) = e
					k = k+1
				End If
			End If
		Next
		tmp = a
		[Remove] = a
	End Function
	Public Function Del(ByVal arr, ByVal p) : Del = Me.Remove(arr, p) : End Function

	Public Function InArray(Byval s, Byval arr)
		If Not IsArray(arr) Then InArray = False : Exit Function
		Dim x : InArray = False
		For Each x In arr
			If Not IsObject(x) and Not IsObject(s) Then
				If x = s Then
					InArray = True
					Exit For
				End If
			ElseIf IsObject(x) and IsObject(s) Then
				If TypeName(x) = TypeName(s) and VarType(x) = VarType(s) Then
					InArray = True
					Exit For
				End If
			End If
		Next
	End Function

	'e.g. ShowErr "系统出错", Err.Number, Err.Description, Err.Source
	Public Sub ShowErr(ByVal msg, ByVal Number, ByVal Description, ByVal Source)
		Dim s
		s = "<fieldset id=""abxError"">" & vbCrLf
		s = s & "	<legend>Error Occurred</legend>" & vbCrLf
		s = s & "	<p class=""msg"">" & msg & "</p>" & vbCrLf
		If Number<>0 Then
			s = s & "	<ul class=""dev"">" & vbCrLf
			s = s & "		<li class=""info"">以下信息针对开发者：</li>" & vbCrLf
			s = s & "		<li>错误代码：0x" & Hex(Number) & "</li>" & vbCrLf
			s = s & "		<li>错误描述：" & Description & "</li>" & vbCrLf
			s = s & "		<li>错误来源：" & Source & "</li>" & vbCrLf
			s = s & "	</ul>" & vbCrLf
		End If
		Err.Clear
		Response.Write s
		Response.Write "</fieldset>"
		Response.End
	End Sub

End Class

Class Cls_ComFunc_Tmp

	Function strJoin(Byval p, Byval s)
		strJoin = Join(p, s)
	End Function

End Class

Dim ComFun
Set ComFun = New Cls_ComFunc
%>