<%
'######################################################################
'## Dao.Cls.asp
'## -------------------------------------------------------------------
'## Feature     :   App Dao
'## Version     :   v0.1
'## Author      :   Lajox (lajox@19www.com)
'## Update Date :   2014/03/26 14:58
'## HomePage	:   http://www.19www.com
'## -------------------------------------------------------------------
'## Description :   App Dao Core
'######################################################################

Class Cls_Dao

	Private s_fsoName, s_dictName, s_steamName, s_Charset, s_tbPrefix
	Private s_selectSql, s_insertSql, s_updateSql, s_deleteSql, s_querySql, s_execType, s_execSql
	Private o_db, o_ds, o_fs
	Private b_changed
	Private i_find, i_affected
	Public ComFun

	Private Sub Class_Initialize()
		On Error Resume Next
		Set ComFun = New Cls_ComFunc
		s_Charset = "UTF-8"
		s_tbPrefix = ""
		s_dictName = "Scripting.Dictionary"
		s_selectSql = "SELECT%TOP% %FIELD% FROM %TABLE%%ALIAS%%JOIN%%ON%%WHERE%%GROUP%%HAVING%%ORDER%%UNION%"
		s_insertSql = "INSERT INTO %TABLE%%WHERE%"
		s_updateSql = "UPTATE %TABLE%%SET%"
		s_deleteSql = "DELETE FROM %TABLE%%WHERE%"
		s_querySql = ""
		s_execType = 1
		i_affected = 0
		i_find = 999
		b_changed = False
		Set o_ds = Server.CreateObject(s_dictName) : o_ds.CompareMode = 1
		Set o_fs = Server.CreateObject(s_dictName) : o_fs.CompareMode = 1
		o_ds("table") = "TABLE"
		On Error GoTo 0
	End Sub

	Private Sub Class_Terminate()
		Set o_db = Nothing
		Set o_ds = Nothing
		Set o_fs = Nothing
	End Sub

	Public Sub Init(ByVal dbCfg)
		On Error Resume Next
		Dim t_db
		If LCase(dbCfg("db_open"))="true" Or LCase(dbCfg("db_open"))="1" Or LCase(dbCfg("db_open"))="" Then
			'--- 设置数据表前缀
			If dbCfg.Exists("table_prefix") Then s_tbPrefix = dbCfg("table_prefix")
			Set t_db = New Cls_DB
			t_db.Debug = True
			If LCase(dbCfg("db_type"))="sql" Or LCase(dbCfg("db_type"))="mssql" Then '@MS SQL Server
				t_db.Conn = t_db.OpenConn(0, dbCfg("sql_db"), dbCfg("sql_uid") &":"& dbCfg("sql_pwd") &"@"& dbCfg("sql_server") )
			Else '@Access
				t_db.Conn = t_db.OpenConn(1, dbCfg("acc_db"), dbCfg("acc_pwd"))
			End If
			Set o_db = t_db
		Else
			Response.Write "数据库连接已关闭"
			Response.End
		End If
		On Error Goto 0
	End Sub

	Public Function [New]()
		Set [New] = New Cls_Dao
	End Function

	Public Property Let db(ByVal o)
		If IsObject(o) Then Set o_db = o
	End Property
	Public Property Get db()
		Set db = o_db
	End Property

	Public Property Let tbPrefix(ByVal s)
		s_tbPrefix = s
	End Property
	Public Property Get tbPrefix()
		tbPrefix = s_tbPrefix
	End Property

	Public Property Let Table(ByVal s)
		o_ds("table") = Trim(s)
		If Instr(s," ")>0 Then
			o_ds("table") = Trim(ComFun.CLeft(s," "))
			o_ds("alias") = Trim(ComFun.CRight(s," "))
		End If
	End Property
	Public Property Get Table()
		Table = o_ds("table")
	End Property

	Public Function T(ByVal s)
        If Not ComFun.IsNul(Trim(s)) Then o_ds("table") = Trim(s)
		If Instr(o_ds("table")," ")>0 Then
			o_ds("table") = Trim(ComFun.CLeft(o_ds("table")," "))
			o_ds("alias") = Trim(ComFun.CRight(o_ds("table")," "))
		End If
		Set T = Me
    End Function

	Public Function From(ByVal s)
		Set From = Me.T(s)
    End Function

	Public Function [Alias](ByVal s)
        If Not ComFun.IsNul(Trim(s)) Then o_ds("alias") = Trim(s)
		Set [Alias] = Me
    End Function

	Public Function GetAlias()
		Dim s
		If o_ds.Exists("alias") Then
			s = Trim(o_ds("alias"))
		Else
			If Instr(o_ds("table")," ")>0 Then
				o_ds("table") = Trim(ComFun.CLeft(o_ds("table")," "))
				o_ds("alias") = Trim(ComFun.CRight(o_ds("table")," "))
			End If
			s = Trim(o_ds("alias"))
		End If
        GetAlias = s
    End Function

	Public Function [Select](ByVal s)
		Set [Select] = Me.Field(s)
    End Function

	Public Function Field(ByVal s)
        If Not ComFun.IsNul(s) Then
			If IsObject(s) Then Set o_ds("field") = s Else o_ds("field") = s
		Else
			o_ds("field") = "*"
		End If
		Set Field = Me
    End Function

	Public Function Where(ByVal s)
		If ComFun.isStr(s) Then s = Trim(s)
        If Not ComFun.IsNul(s) Then
			If IsObject(s) Then Set o_ds("where") = s Else o_ds("where") = s
		End If
		Set Where = Me
    End Function

	Public Function Order(ByVal s)
        If Not ComFun.IsNul(s) Then o_ds("order") = s
		Set Order = Me
    End Function

	Public Function Group(ByVal s)
        If Not ComFun.IsNul(s) Then o_ds("group") = s
		Set Group = Me
    End Function

	Public Function Having(ByVal s)
        If Not ComFun.IsNul(s) Then o_ds("having") = s
		Set Having = Me
    End Function

	Public Function [Join](ByVal s)
        If Not ComFun.IsNul(s) Then
			If IsObject(s) Then Set o_ds("join") = s Else o_ds("join") = s
		End If
		Set [Join] = Me
    End Function

	Public Function [On](ByVal s)
        If Not ComFun.IsNul(s) Then o_ds("on") = s
		Set [On] = Me
    End Function

	Public Function Union(ByVal s)
        If Not ComFun.IsNul(s) Then o_ds("union") = s
		Set Union = Me
    End Function

	Public Function Top(ByVal s)
        If Trim(s)<>"" Then o_ds("top") = s
		Set Top = Me
    End Function

	'模拟 mysql的 limit(offset,rows) 用法
	'用法：
	'limit(0,0) 取全部数据（第1条(0+1=1)数据开始到结束的数据）
	'limit(0,1) 取从（第1条(0+1=1)数据开始的1条数据，即：第1~1条）（共1条）
	'limit(3,0) 取从（第4条(3+1=4)数据开始到结束的数据，即：第4~最后一条）
	'limit(2,5) 表示 第3条(2+1=3)数据开始的5条数据，即：第3~第7条）（共5条）
	'limit(1,2) 表示 第2条(1+1=2)数据开始的2条数据，即：第2~第3条）（共2条）
	'limit(4,6) 可以这么算：表示 第4+1=5条 到 第4+6=10条）（共6条）
	'@注意：Limit用法只能用于查询，不能用于Rs数据更新！
	Public Function Limit(ByVal offset, ByVal rows)
		On Error Resume Next
		o_ds("offset") = ComFun.IIF(ComFun.IsNum(offset),CLng(offset),0)
		o_ds("rows") = ComFun.IIF(ComFun.IsNum(rows),CLng(rows),0)
		Set Limit = Me
		On Error Goto 0
    End Function

	Public Function getField(ByVal p)
        Dim tRs, t : t = False
		Set tRs = Me.Result()
		If Not (tRs.Bof Or tRs.Eof) Then
			t = tRs(p)
		End If
		tRs.Close()
		Set tRs = Nothing
		getField = t
    End Function

	'取得当前Rs的字段集合（数组）
	Public Function GetFields()
        Dim Rs, i, f, a : a = Array()
		Set Rs = Me.Result()
		For i = 0 To Rs.Fields.Count-1
			f = Rs.Fields(i).Name
			a = ComFun.Push(a, f)
		Next
		Rs.Close()
		Set Rs = Nothing
		GetFields = a
    End Function

	'取得Rs的字段集合（数组）
	Public Function RsFields(ByVal Rs)
        Dim i, f, a : a = Array()
		If ComFun.IsRs(Rs) Then
			For i = 0 To Rs.Fields.Count-1
				f = Rs.Fields(i).Name
				a = ComFun.Push(a, f)
			Next
		End If
		RsFields = a
    End Function

	'按条件检索数据
	'注：此用法自由度比较高，比如要查找 id=1,3,4 这三条数据，
	'可以用：Find(Array(1,3,4))， Find("1,3,5")， Find("id in(1,3,5)") 等用法
	Public Function Find(ByVal id)
		On Error Resume Next
		Dim s_pk, s_alias, s_find, arr, Match, Matches, i, j, o, b_int, f, c, v, t, a
		s_pk = Me.getPk()
		s_alias = Me.GetAlias()
		s_pk = ComFun.IIF(s_alias="", s_pk, s_alias & "." & s_pk)
		If IsArray(id) Then '数组
			b_int = True
			For Each i In id
				If Not (ComFun.IsNum(Trim(i)) Or Trim(i)="")  Then
					b_int = False
					Exit For
				End If
			Next
			If b_int Then
				id = ComFun.Join(id, ",")
				arr = ComFun.Fetch(id,",")
				id = ComFun.Join(arr, ",")
				If Trim(id)<>"" Then s_find = s_pk & " in (" & id & ")"
			Else
				arr = Array()
				For Each i in id
					''更友好的支持格式如: Array("typeid>1", "name:jack", "email:lajox@19www.com", "workyear<=2014")
					''注：此Find方法自由度没有Where方法（自由无限制）的高，若编译生成的SQL有误，需改用 Where 方法。
					i = Trim(i) : f = "" : c = "" : v = ""
					If ComFun.RegTest(i,"^([\w\.]+)\s*(\:|\!=|[\<\>=]{1,2})\s*(['""]?)(.+)\3") Then
						Set Matches = ComFun.RegMatch(i, "^(\w+\.)\s*(\:|\!=|[\<\>=]{1,2})\s*(['""]?)(.+)\3")
						For Each Match In Matches
							f = Trim(Match.SubMatches(0))
							Select Case Match.SubMatches(1)
								Case ":", "=" : c = "="
								Case ">=" : c = ">="
								Case "<=" : c = "<="
								Case "<>", "!=" : c = "<>"
								Case ">" : c = ">"
								Case "<" : c = "<"
								Case Else : c = "="
							End Select
							v = Match.SubMatches(3)
						Next
						Set Matches = Nothing
						If Not ComFun.IsNum(v) Then '支持日期格式 如 #2014-3-20 15:06:18#
							If ComFun.RegTest(v,"^#(.+?)#$") Then
								t = ComFun.RegReplace(v,"^#(.+?)#$", "$1")
								If Not isDate(t) Then
									v = "'" & v & "'"
								End If
							Else
								v = "'" & v & "'"
							End If
						End If
					Else
						f = i : c = "" : v =""
					End If
					If Trim(f)<>"" Then arr = ComFun.Push(arr, f & c & v)
				Next
				''s_find = ComFun.Join(arr, " And ") '弃用这个，为了更好的兼容下面的 And Or 模式
				s_find = "1=1"
				For Each j in arr
					If Left(LCase(Trim(j)),3) = "or " Or Left(LCase(Trim(j)),4) = "and " Then
						s_find = s_find & " " & j
					Else
						s_find = s_find & " And " & j
					End If
				Next
			End If
		ElseIf ComFun.IsDict(id) Then '字典
			'字典数据,格式如： o_dt("name")="jack" : o_dt("typeid<")=5 : o_dt("email<>")="lajox@19www.com" : o_dt("class*")="%test%" : o_dt("class[]")=Array(1,3,5)
			arr = Array()
			For Each i In id
				i = Trim(i) : f = "" : c = "" : v = ""
				If InStr(i,":")>0 Then
					f = ComFun.CLeft(i,":") : c = "="
				ElseIf InStr(i,">=")>0 Then
					f = ComFun.CLeft(i,">=") : c = ">="
				ElseIf InStr(i,"<=")>0 Then
					f = ComFun.CLeft(i,"<=") : c = "<="
				ElseIf InStr(i,"<>")>0 Then
					f = ComFun.CLeft(i,"<>") : c = "<>"
				ElseIf InStr(i,"!=")>0 Then
					f = ComFun.CLeft(i,"!=") : c = "<>"
				ElseIf InStr(i,"=")>0 Then
					f = ComFun.CLeft(i,"=") : c = "="
				ElseIf InStr(i,">")>0 Then
					f = ComFun.CLeft(i,">") : c = ">"
				ElseIf InStr(i,"<")>0 Then
					f = ComFun.CLeft(i,"<") : c = "<"
				ElseIf InStr(i,"*")>0 Then '星号匹配like
					f = ComFun.CLeft(i,"*") : c = " like "
				ElseIf InStr(i,"[]")>0 Then '[]号匹配in
					f = ComFun.CLeft(i,"[]") : c = " IN "
				ElseIf ComFun.RegTest(Trim(i),"^[\w\.]+$") Then
					f = Trim(i) : c = "="
				Else
					f = ComFun.RP(i,Array("=",">","<","!"),Array("","","","")) : c = "="
				End If
				v = id(i)
				f = Trim(f)
				''自由语句,如 o_dt("")="id <> 6" 、o_dt("+1")="name like '%jack%'" 、 o_dt("+2")="email like '%@gmail.com%'"
				If UCase(Trim(c)) = "IN" Or IsArray(v) Then
					If IsArray(v) Then
						a = Array()
						For Each t In v
							If ComFun.IsInt(t) Then a = ComFun.Push(a, t) Else a = ComFun.Push(a, "'"& t & "'")
						Next
						v = ComFun.Join(a, ",")
					End If
					If Trim(f)<>"" Then arr = ComFun.Push(arr, f & " IN(" & v & ")")
				ElseIf (f="" Or Instr(f,"+")>0) And Trim(v)<>"" Then 
					arr = ComFun.Push(arr, v)
				ElseIf f = Me.getPk() And c = "="  Then '当为主键
					If Trim(f)<>"" Then arr = ComFun.Push(arr, f & " IN(" & v & ")")
				Else
					If Not ComFun.IsNum(v) Then '支持日期格式 如 #2014-3-20 15:06:18#
						If ComFun.RegTest(v,"^#(.+?)#$") Then
							t = ComFun.RegReplace(v,"^#(.+?)#$", "$1")
							If Not isDate(t) Then
								v = "'" & v & "'"
							End If
						Else
							v = "'" & v & "'"
						End If
					End If
					If Trim(f)<>"" Then arr = ComFun.Push(arr, f & c & v)
				End If
			Next
			s_find = "1=1"
			For Each j In arr
				If Left(LCase(Trim(j)),3) = "or " Or Left(LCase(Trim(j)),4) = "and " Then
					s_find = s_find & " " & j
				Else
					s_find = s_find & " And " & j
				End If
			Next
		ElseIf ComFun.IsNum(Trim(id)) Then '数字
			id = CLng(Trim(id))
			'If id>0 Then
				s_find = s_pk & " = " & id & ""
			'End If
		ElseIf ComFun.isStr(id) Then '字符串
			If ComFun.RegTest(Trim(id),"^([\d\,\s]+)$") Then
				arr = ComFun.Fetch(id,",")
				id = ComFun.Join(arr, ",")
				If Trim(id)<>"" Then s_find = s_pk & " in (" & id & ")"
			Else
				s_find = id
			End If
		End If
		If Trim(s_find)<>"" Then
			If ComFun.IsNul(o_ds("where")) Then
				o_ds("where") = Empty
				o_ds("where") = s_find
			Else
				If ComFun.IsDict(o_ds("where")) Then
					i_find = i_find + 1
					Set o = o_ds("where")
					o("+"& i_find) = s_find
					Set o_ds("where") = o
					Set o = Nothing
				ElseIf IsArray(o_ds("where")) Then
					o_ds("where") = ComFun.Push(o_ds("where"), s_find)
				Else
					o_ds("where") = o_ds("where") & " And " & s_find
				End If
			End If
		End If
		Set Find = Me
		On Error Goto 0
	End Function

	'获取主键字段名
	Public Function getPk()
		Dim tb, s_pk : s_pk = "id"
		tb = Trim(o_ds("table"))
		If tb<>"" Then
			If o_fs.Exists(LCase(tb)) Then
				s_pk = o_fs(LCase(tb))
			Else
				s_pk = Me.db.tbAutoID(s_tbPrefix & tb)
				o_fs(LCase(tb)) = s_pk
			End If
		End If
		getPk = s_pk
    End Function

	'返回影响的行数
	Public Function AffectedRows()
		Dim t, n : n = 0
		If b_changed = True Then
			n = i_affected
		ElseIf s_execType = 4 Or s_execType = 3 Or s_execType = 2 Then '执行Delete、Update、Insert操作
			n = Me.db.AffectedRows()
		ElseIf s_execType = -1 Then
			t = LCase(Trim(s_execSql))
			If Left(t,6)="delete" Or Left(t,6)="update" Or Left(t,6)="insert" Then
				n = Me.db.AffectedRows()
			End If
		Else
			'n = Me.db.AffectedRows()
			n = 0
		End If
		AffectedRows = n
	End Function
	Public Function affRows() : affRows = AffectedRows() : End Function

	'编译解析
	Public Sub Compile()
		Dim Matches, Match, t
		s_execSql = ""
		o_ds("table") = Trim(o_ds("table"))
		If Instr(o_ds("table")," ")>0 Then
			o_ds("table") = Trim(ComFun.CLeft(o_ds("table")," "))
			o_ds("alias") = Trim(ComFun.CRight(o_ds("table")," "))
		End If
		Select Case s_execType
			Case 1 : s_execSql = parseSql(s_selectSql, o_ds)
			Case 2 : s_execSql = parseSql(s_insertSql, o_ds)
			Case 3 : s_execSql = parseSql(s_updateSql, o_ds)
			Case 4 : s_execSql = parseSql(s_deleteSql, o_ds)
			Case Else : s_execSql = parseSql(s_querySql, "")
		End Select
		'让其支持类似{rq:id}获取Request.QueryString("id")数据
		Set Matches = ComFun.RegMatch(s_execSql, "\{rq\:(\w+)\}")
		For Each Match In Matches
			t = Trim(Match.SubMatches(0))
			s_execSql = ComFun.RP(s_execSql, Match.Value, Request.QueryString(t))
		Next
		'让其支持类似{$id}获取全局变量id的数据
		s_execSql = ComFun.RP(s_execSql,Array("\\","\$"),Array(Chr(15),Chr(16)))
		Set Matches = ComFun.RegMatch(s_execSql, "\{\$(\w+)\}")
		For Each Match In Matches
			t = Trim(Match.SubMatches(0))
			s_execSql = ComFun.RP(s_execSql, Match.Value, Eval(t))
		Next
		s_execSql = ComFun.RP(s_execSql,Array(Chr(15),Chr(16)),Array("\","$"))
		Set Matches = Nothing
	End Sub

	'重置数据查询（清空上次查询）
	Public Function Reset()
        o_ds.RemoveAll() : o_ds("table") = "TABLE"
		s_execType = 1
		s_querySql = ""
		i_affected = 0
		b_changed = False
		Set Reset = Me
    End Function

	Public Function Query(ByVal s)
        If Trim(s)<>"" Then
			s_querySql = s
			s_execType = -1
		End If
		Set Query = Me
    End Function

	'单数据删除数据
	Public Function Del()
		On Error Resume Next
		Del = False
		s_execType = 4
		Me.Compile()
		Me.db.Exec(s_execSql)
		''Me.Reset() '重置数据查询
		b_changed = True
		i_affected = Me.db.AffectedRows()
		If Err.Number=0 Then Del = True
		On Error Goto 0
    End Function

	'批量数据删除, 支持数组，字符串，数字
	'注：此用法自由度比较高，比如要删除 id=1,3,4 这三条数据，
	'可以用：Delete(Array(1,3,4))， Delete("1,3,5")， Delete("id in(1,3,5)") 等用法
	Public Function Delete(ByVal id)
		On Error Resume Next
		Delete = False
		If Not ComFun.IsNul(id) Then
			Me.Find(id)
			s_execType = 4
			Me.Compile()
			Me.db.Exec(s_execSql)
			''Me.Reset() '重置数据查询
			b_changed = True
			i_affected = Me.db.AffectedRows()
			If Err.Number=0 Then Delete = True
		End If
		On Error Goto 0
	End Function

	'更新数据
	Public Function [Set](ByVal d)
		On Error Resume Next
		[Set] = False
		Dim Rs, i, f, v, n, fields, pk : n = 0
		Dim b_up : b_up = 0
		If ComFun.IsNul(d) Then
			[Set] = False
			i_affected = 0
			Exit Function
		End If
		Set Rs = Me.Result()
		pk = Me.getPk()
		fields = Me.RsFields(Rs)
		fields = ComFun.Del(fields, pk) '移除自增主键
		n = Rs.RecordCount
		Do While Not Rs.Eof
			If ComFun.IsDict(d) Then
				For Each i In d
					If ComFun.InArray(i,fields) Then
						v = d(i)
						If ComFun.IsNum(v) Then v = CLng(v)
						Rs(i) = v
					End If
				Next
			ElseIf IsArray(d) Then '数组，格式: Array("typeid:1", "name:jack", "workyear:2014")
				For Each i In d
					f = ComFun.CLeft(i,":")
					v = ComFun.CRight(i,":")
					If ComFun.IsNum(v) Then v = CLng(v)
					If ComFun.InArray(f,fields) Then
						Rs(f) = v
					End If
				Next
			ElseIf IsObject(d) And (TypeName(d)="IRequestDictionary" Or TypeName(d)="IRequest" Or TypeName(d)="Object") Then '整个表单数据
				IF ComForm.Count>0 Then
					For Each i In ComForm.Items
						If ComFun.InArray(i,fields) Then
							v = ComForm.Item(i)
							If ComFun.IsNum(v) Then v = CLng(v)
							Rs(i) = v
						End If
					Next
				End IF
			ElseIf ComFun.isStr(d) Then '字符串，格式："typeid:1"
				f = ComFun.CLeft(d,":")
				v = ComFun.CRight(d,":")
				If ComFun.IsNum(v) Then v = CLng(v)
				If ComFun.InArray(f,fields) Then
					Rs(f) = v
				End If
			Else
				b_up = 1
				Exit Do
			End If
			Rs.Update()
			If Not Rs.Eof Then Rs.MoveNext
		Loop
		Set Rs = Nothing
		b_changed = True
		If Err.Number=0 And b_up=0 Then
			[Set] = True
			i_affected = n
		Else
			i_affected = 0
		End If
		On Error Goto 0
    End Function

	Public Function Update(ByVal d)
        Update = [Set](d)
    End Function

	Public Function Edit(ByVal d)
        Edit = [Set](d)
    End Function

	'更新字段
	Public Function setField(ByVal k, ByVal v)
		On Error Resume Next
		setField = False
		Dim Rs, i, j, t, n, fields : n = 0 : b_changed = False
		If ComFun.IsNul(k) Then
			setField = False
			i_affected = 0
			Exit Function
		End If
		Set Rs = Me.Result()
		fields = Me.RsFields(Rs)
		n = Rs.RecordCount
		If IsArray(k) Then
			t = v
			For i=0 To UBound(k)
				If IsArray(v) Then
					If UBound(v)>=UBound(k) Then
						t = v(i)
					Else
						If i<=UBound(v) Then
							t = v(i)
						Else
							t = ""
						End If
					End If
				End If
				Rs(k(i)) = t
			Next
		Else
			Rs(k) = v
		End If
		Rs.Update()
		Set Rs = Nothing
		b_changed = True
		If Err.Number=0 Then
			setField = True
			i_affected = 1
		Else
			i_affected = 0
		End If
		On Error Goto 0
    End Function

	'添加数据
	Public Function Add(ByVal d)
		On Error Resume Next
		Add = False
		Dim Rs, i, f, v, fields, pk : b_changed = False
		If ComFun.IsNul(d) Then
			Add = False
			Exit Function
		End If
		Set Rs = Me.Result()
		pk = Me.getPk()
		fields = Me.RsFields(Rs)
		fields = ComFun.Del(fields, pk) '移除自增主键
		Rs.AddNew()
		If ComFun.IsDict(d) Then
			For Each i In d
				If ComFun.InArray(i,fields) Then
					v = d(i)
					If ComFun.IsNum(v) Then v = CLng(v)
					Rs(i) = v
				End If
			Next
			b_changed = True
		ElseIf IsArray(d) Then '数组，格式: Array("typeid:1", "name:jack", "workyear:2014")
			For Each i In d
				f = ComFun.CLeft(i,":")
				v = ComFun.CRight(i,":")
				If ComFun.IsNum(v) Then v = CLng(v)
				If ComFun.InArray(f,fields) Then
					Rs(f) = v
				End If
			Next
			b_changed = True
		ElseIf IsObject(d) And (TypeName(d)="IRequestDictionary" Or TypeName(d)="IRequest" Or TypeName(d)="Object") Then '整个表单数据
			IF ComForm.Count>0 Then
				For Each i In ComForm.Items
					If ComFun.InArray(i,fields) Then
						v = ComForm.Item(i)
						If ComFun.IsNum(v) Then v = CLng(v)
						Rs(i) = v
					End If
				Next
			End IF
			b_changed = True
		ElseIf ComFun.isStr(d) Then '字符串，格式："typeid:1"
			f = ComFun.CLeft(d,":")
			v = ComFun.CRight(d,":")
			If ComFun.IsNum(v) Then v = CLng(v)
			If ComFun.InArray(f,fields) Then
				Rs(f) = v
			End If
			b_changed = True
		Else
			b_changed = False
		End If
		Rs.Update()
		Set Rs = Nothing
		If Err.Number=0 Then
			Add = True
			i_affected = 1
		Else
			i_affected = 0
		End If
		On Error Goto 0
    End Function

	'保存数据（智能更新或添加数据）
	Public Function Save(ByVal d)
		On Error Resume Next
		Dim Rs : Save = False
		If Not ComFun.IsNul(o_ds("where")) Or Not ComFun.IsNul(o_ds("top")) Then
			Set Rs = Me.Result()
			If Not (rs.Eof Or rs.Bof) Then
				Save = Me.Update(d)
			End If
		Else
			Save = Me.Add(d)
		End If
		On Error Goto 0
    End Function

	Public Function getSQL()
		Me.Compile() '自编译
        getSQL = s_execSql
    End Function
	Public Function lastSQL() : lastSQL = Me.getSQL() : End Function

	'执行SQL语句操作
	Public Function [Execute]()
		Me.Compile() '自编译
		Me.db.Exec(s_execSql)
		''Me.Reset()	'重置数据查询
	End Function
	Public Function Exec()
		Me.[Execute]()
	End Function

	'获取数据列表(数组数据)
	'Dim arrRs : arrRs = Dao.Select("id,name").Where("id<10").List()
	Public Function List()
		Me.Compile() '自编译
        List = Me.db.Run(s_execSql,"arr")
		''Me.Reset()	'重置数据查询
    End Function
	
	'获取Rs结果集
	Public Function Result()
		On Error Resume Next
		Me.Compile() '自编译
		''Set Result = Me.db.GRS(s_execSql) '只读
		'Set Result = Me.db.Exec(s_execSql) '可读写
		Set Result = Me.db.Run(s_execSql,"rst3") '可读写
		''Me.Reset()	'重置数据查询
		If o_ds.Exists("offset") Or o_ds.Exists("rows") Then
			Dim offset, rows, start, over, n, i
			offset = CLng(o_ds("offset"))
			rows = CLng(o_ds("rows"))
			Set Result = Me.LimitRs(Result,offset,rows)
		End If
		On Error Goto 0
    End Function
	Public Function GetRs() : Set GetRs = Me.Result() : End Function

	'对Rs结果集进行Limit限制
	Public Function LimitRs(ByVal Rs, ByVal offset, ByVal rows)
		On Error Resume Next
		Dim start, over, n, i
		offset = CLng(offset) : rows = CLng(rows)
		If ComFun.IsRs(Rs) Then
			Set LimitRs = Rs
			If Not ( ComFun.IsNul(Rs) Or (offset<=0 And rows<=0) ) Then
				If offset<0 Then offset=0
				If rows<0 Then rows=0
				n = Rs.RecordCount
				If rows=0 Then rows = n
				start = offset + 1
				over = offset + rows
				If over>n Then over = n
				Set LimitRs = Me.CloneRs(Rs)
				i = 1
				If start>n Then
					Do While Not LimitRs.Eof
						i = i + 1
						LimitRs.Delete
						LimitRs.MoveNext
					Loop
					If i > 1 Then
						LimitRs.UpdateBatch()
						LimitRs.MoveFirst()
					End If
				Else
					Do While Not LimitRs.Eof
						If i<start Then LimitRs.Delete
						If i>over Then LimitRs.Delete
						i = i + 1
						LimitRs.MoveNext
					Loop
					If i > 1 Then
						LimitRs.UpdateBatch()
						If LimitRs.RecordCount > 0 Then LimitRs.MoveFirst()
					End If
				End If
			End If
		Else
			If IsObject(Rs) Then Set LimitRs = Rs Else LimitRs = Rs
		End If
		On Error Goto 0
    End Function

	'取Rs结果集
	Public Function Fetch()
		Set Fetch = Me.Result()
	End Function
	Public Function FetchRs() : Set FetchRs = Me.Result() : End Function

	'取第一行单条Rs数据
	Public Function FetchOne()
		Me.Top(1)
		Set FetchOne = Me.Result()
	End Function
	Public Function One() : Set One = Me.FetchOne() : End Function

	'取数据列表(数组数据)
	Public Function FetchArray()
		FetchArray = Me.List()
	End Function

	'获取Rs结果集中的第n+1行单条数据(n为偏移量)
	Public Function FetchRow(ByVal n)
		On Error Resume Next
		n = CLng(n)
		If n<0 Then n=0
		Set FetchRow = Me.Result()
		' If Not Rs.Eof Then
			' FetchRow.Move(n)
		' End If
		Set FetchRow = Me.LimitRs(FetchRow,n,1)
		On Error Goto 0
	End Function
	Public Function Row(ByVal n) : Set Row = Me.FetchRow(n) : End Function

	'克隆Rs数据集
	Public Function CloneRs(ByVal Rs)
		On Error Resume Next
		Dim t_db : Set t_db = New Cls_DB
		Set CloneRs = t_db.CloneRs(Rs)
		On Error Goto 0
	End Function

	'获取数据条数
	Public Function Count()
		On Error Resume Next
		Dim c, rs : c = 0
		Set rs = Me.Result()
		If Not rs.Eof Then c = rs.RecordCount
		Set rs = Nothing
		Count = c
		On Error Goto 0
    End Function

	'获取字段信息组数
	Public Function FieldsData()
		On Error Resume Next
		Dim item, tRs, arr : arr = Array()
		Set tRs = Me.Result()
		For Each item In tRs.Fields
			arr = ComFun.Push(arr, item.name)
		Next
		Set tRs = Nothing
		FieldsData = arr
		On Error Goto 0
    End Function

	'获取字段数
	Public Function FieldsCount()
		Dim arr : arr = Me.FieldsData()
		FieldsCount = ComFun.Len(arr)
    End Function
	Public Function FieldsNum()
		FieldsNum = Me.FieldsCount()
    End Function

    '-- 替换SQL语句中表达式
	Private Function parseSql(ByVal sql, ByVal opt)
		sql = ComFun.RP(sql, Array("\\","\@"), Array(Chr(17),Chr(18)))
		sql = ComFun.RP(sql, "#@", s_tbPrefix)
		sql = ComFun.RP(sql, "@", s_tbPrefix)
		sql = ComFun.RP(sql, Array(Chr(17),Chr(18)), Array("\","@"))
		If ComFun.IsDict(opt) Then
			sql = ComFun.RP(sql, _
				array("%TABLE%","%ALIAS%","%FIELD%","%TOP%","%JOIN%","%ON%","%WHERE%","%GROUP%","%HAVING%","%ORDER%","%UNION%"), _
				array( _
					parseTable(ComFun.IIF(Not(ComFun.IsNul(opt("table"))), s_tbPrefix & opt("table"), "TABLE")), _
					parseAlias(ComFun.IIF(Not(ComFun.IsNul(opt("alias"))), opt("alias"), "")), _
					parseField(ComFun.IIF(Not(ComFun.IsNul(opt("field"))), opt("field"), "*")), _
					parseTop(ComFun.IIF(Not(ComFun.IsNul(opt("top"))), ComFun.IIF(CLng(opt("top"))>0, opt("top"), ""), "")), _
					parseJoin(ComFun.IIF(Not(ComFun.IsNul(opt("join"))), opt("join"), "")), _
					parseOn(ComFun.IIF(Not(ComFun.IsNul(opt("on"))), opt("on"), "")), _
					parseWhere(ComFun.IIF(Not(ComFun.IsNul(opt("where"))), opt("where"), "")), _
					parseGroup(ComFun.IIF(Not(ComFun.IsNul(opt("group"))), opt("group"), "")), _
					parseHaving(ComFun.IIF(Not(ComFun.IsNul(opt("having"))), opt("having"), "")), _
					parseOrder(ComFun.IIF(Not(ComFun.IsNul(opt("order"))), opt("order"), "")), _
					parseUnion(ComFun.IIF(Not(ComFun.IsNul(opt("union"))), opt("union"), "")) _
				))
		End If
		parseSql = sql
    End Function
	
    '-- table分析
	Private Function parseTable(ByVal tables)
		Dim arr : arr = Array()
        If Not ComFun.IsNul(tables) Then
            If IsArray(tables) Then
				For Each j in tables
					arr = ComFun.Push(arr, j)
				Next
				tables = ComFun.Join(arr, ", ")
            End If
        End If
		If ComFun.IsNul(tables) Then tables = ""
		parseTable = tables
    End Function

    '-- 表别名Alias分析
	'e.g. parseAlias("a.cid = b.cid")
    Private Function parseAlias(ByVal str)
		If Not ComFun.IsNul(str) Then
			str = " " & str
		Else
			str = ""
		End If
		str = ReplaceTable(str)
		parseAlias = str
    End Function

    '-- field分析
	Private Function parseField(ByVal field)
		Dim a, i
		If Not ComFun.IsNul(field) Then
			If IsArray(field) Then
				a = Array()
				For Each i In a
					If Trim(i)<>"" Then a = ComFun.Push(a,i)
				Next
				field = Join(a, ",")
			End If
			If Trim(field)="" Then field = "*"
		Else
			field = "*"
		End If
		field = ReplaceTable(field)
		parseField = field
    End Function

    '-- where分析
	Private Function parseWhere(ByVal where)
		Dim s_where, arr, Match, Matches, i, j, f, v, c, t, a
		If Not ComFun.IsNul(where) Then
			If IsArray(where) Then '数组
				arr = Array()
				For Each i in where
					If Trim(i)<>"" Then arr = ComFun.Push(arr, i)
				Next
				''where = ComFun.Join(arr, " And ") '弃用这个，为了更好的兼容下面的 And Or 模式
				s_where = "1=1"
				For Each j in arr
					If Left(LCase(Trim(j)),3) = "or " Or Left(LCase(Trim(j)),4) = "and " Then
						s_where = s_where & " " & j
					Else
						s_where = s_where & " And " & j
					End If
				Next
			ElseIf ComFun.IsDict(where) Then
				'字典数据,格式如： o_ds("name")="jack" : o_ds("typeid<")=5 : o_ds("email<>")="lajox@19www.com" : o_ds("class*")="%test%" : o_ds("class[]")=Array(1,3,5)
				arr = Array()
				For Each i In where
					i = Trim(i) : f = "" : c = "" : v = ""
					If InStr(i,":")>0 Then
						f = ComFun.CLeft(i,":") : c = "="
					ElseIf InStr(i,">=")>0 Then
						f = ComFun.CLeft(i,">=") : c = ">="
					ElseIf InStr(i,"<=")>0 Then
						f = ComFun.CLeft(i,"<=") : c = "<="
					ElseIf InStr(i,"<>")>0 Then
						f = ComFun.CLeft(i,"<>") : c = "<>"
					ElseIf InStr(i,"!=")>0 Then
						f = ComFun.CLeft(i,"!=") : c = "<>"
					ElseIf InStr(i,"=")>0 Then
						f = ComFun.CLeft(i,"=") : c = "="
					ElseIf InStr(i,">")>0 Then
						f = ComFun.CLeft(i,">") : c = ">"
					ElseIf InStr(i,"<")>0 Then
						f = ComFun.CLeft(i,"<") : c = "<"
					ElseIf InStr(i,"*")>0 Then '星号匹配like
						f = ComFun.CLeft(i,"*") : c = " LIKE "
					ElseIf InStr(i,"[]")>0 Then '[]号匹配in
						f = ComFun.CLeft(i,"[]") : c = " IN "
					ElseIf ComFun.RegTest(Trim(i),"^\w+$") Then
						f = Trim(i) : c = "="
					Else
						f = ComFun.RP(i,Array("=",">","<","!"),Array("","","","")) : c = "="
					End If
					v = where(i)
					f = Trim(f)
					''自由语句,如 o_ds("")="id <> 6" 、o_ds("+1")="name like '%jack%'" 、 o_ds("+2")="email like '%@gmail.com%'"
					If UCase(Trim(c)) = "IN" Or IsArray(v) Then
						If IsArray(v) Then
							a = Array()
							For Each t In v
								If ComFun.IsInt(t) Then a = ComFun.Push(a, t) Else a = ComFun.Push(a, "'"& t & "'")
							Next
							v = ComFun.Join(a, ",")
						End If
						If Trim(f)<>"" Then arr = ComFun.Push(arr, f & " IN(" & v & ")")
					ElseIf (f="" Or Instr(f,"+")>0) And Trim(v)<>"" Then 
						arr = ComFun.Push(arr, v)
					ElseIf f = Me.getPk() And c = "="  Then '当为主键
						If Trim(f)<>"" Then arr = ComFun.Push(arr, f & " IN(" & v & ")")
					Else
						If Not ComFun.IsNum(v) Then
							If ComFun.RegTest(v,"^#(.+?)#$") Then
								t = ComFun.RegReplace(v,"^#(.+?)#$", "$1")
								If Not isDate(t) Then
									v = "'" & v & "'"
								End If
							Else
								v = "'" & v & "'"
							End If
						End If
						If Trim(f)<>"" Then arr = ComFun.Push(arr, f & c & v)
					End If
				Next
				s_where = "1=1"
				For Each j In arr
					If Left(LCase(Trim(j)),3) = "or " Or Left(LCase(Trim(j)),4) = "and " Then
						s_where = s_where & " " & j
					Else
						s_where = s_where & " And " & j
					End If
				Next
			Else '字符串
				s_where = where
			End If
			If Trim(s_where)<>"" Then
				where = " WHERE "& s_where
			End If
		Else
			where = ""
		End If
		where = ReplaceTable(where)
		parseWhere = where
    End Function

    '-- top分析
	Private Function parseTop(ByVal top)
		If Trim(top)<>"" Then
			If Instr(Lcase(top),"top ")>0 Then
				top = UCase(top)
			Else
				top = " TOP " & top
			End If
		Else
			top = ""
		End If
		parseTop = top
    End Function

    '-- join分析
	'e.g. parseJoin("join __TEST__")
    Private Function parseJoin(ByVal join)
		Dim joinStr : joinStr = ""
        If Not ComFun.IsNul(join) Then
            If IsArray(join) Then
				For Each j in join
					If ComFun.RegTest(Lcase(j), "^\s*join\s+") Then
						joinStr = joinStr & " " & ComFun.RegReplace(j, "^\s*join\s+", "JOIN ")
					ElseIf ComFun.RegTest(Lcase(j), "^\s*left\s+join\s+") Then
						joinStr = joinStr & " " & ComFun.RegReplace(j, "^\s*left\s+join\s+", "LEFT JOIN ")
					ElseIf ComFun.RegTest(Lcase(j), "^\s*right\s+join\s+") Then
						joinStr = joinStr & " " & ComFun.RegReplace(j, "^\s*right\s+join\s+", "RIGHT JOIN ")
					Else
						joinStr = joinStr & " LEFT JOIN " & j
					End If
				Next
            Else
				If ComFun.RegTest(Lcase(join), "^\s*join\s+") Then
					joinStr = joinStr & " " & ComFun.RegReplace(join, "^\s*join\s+", "JOIN ")
				ElseIf ComFun.RegTest(Lcase(join), "^\s*left\s+join\s+") Then
					joinStr = joinStr & " " & ComFun.RegReplace(join, "^\s*left\s+join\s+", "LEFT JOIN ")
				ElseIf ComFun.RegTest(Lcase(join), "^\s*right\s+join\s+") Then
					joinStr = joinStr & " " & ComFun.RegReplace(join, "^\s*right\s+join\s+", "RIGHT JOIN ")
				Else
					joinStr = joinStr & " LEFT JOIN " & join
				End If
            End If
        End If
		joinStr = ReplaceTable(joinStr)
        parseJoin = joinStr
    End Function

    '-- on分析
	'e.g. parseOn("a.cid = b.cid")
    Private Function parseOn(ByVal str)
		If Not ComFun.IsNul(str) Then
			str = " ON " & str
		Else
			str = ""
		End If
		str = ReplaceTable(str)
		parseOn = str
    End Function

    '-- order分析
	'e.g. parseOrder("listnum desc, id asc")
    Private Function parseOrder(ByVal order)
		If IsArray(order) Then
			Dim arr : arr = Array()
			For Each j in order
				arr = ComFun.Push(arr, j)
			Next
			order = ComFun.Join(arr, ", ")
		End If
		If Not ComFun.IsNul(order) Then
			order = " ORDER BY " & order
		Else
			order = ""
		End If
		order = ReplaceTable(order)
		parseOrder = order
    End Function

    '-- group分析
	'e.g. parseGroup("name")
    Private Function parseGroup(ByVal group)
		Dim arr : arr = Array()
		If IsArray(group) Then
			For Each j in group
				arr = ComFun.Push(arr, j)
			Next
			group = ComFun.Join(arr, ", ")
		End If
		If Not ComFun.IsNul(group) Then
			group = " GROUP BY " & group
		Else
			group = ""
		End If
		group = ReplaceTable(group)
		parseGroup = group
    End Function

    '-- having分析
	'e.g. parseHaving("name")
    Private Function parseHaving(ByVal having)
		If Not ComFun.IsNul(having) Then
			having = " HAVING " & having
		Else
			having = ""
		End If
		having = ReplaceTable(having)
		parseHaving = having
    End Function

	'-- union分析
    Private Function parseUnion(ByVal union)
		If Not ComFun.IsNul(union) Then
			If ComFun.RegTest(Lcase(union), "^([ |]?)union\s+") Then
				union = " " & union
			Else
				union = " UNION " & union
			End If
		Else
			union = ""
		End If
		union = ReplaceTable(union)
		parseUnion = union
    End Function

	'处理替换数据表
	Private Function ReplaceTable(ByVal str)
		Dim Matches, Match
		'将__TABLE_NAME__这样的字符串替换成正规的表名,并且带上前缀和后缀
		'str = ComFun.RegReplace(str, "__([A-Z_-]+)__", s_tbPrefix & "$1" )
		Set Matches = ComFun.RegMatch(str, "__([A-Z_-]+)__")
		For Each Match in Matches
			str = Replace(str, Match.Value, s_tbPrefix & LCase(Match.SubMatches(0)))
		Next
		Set Matches = Nothing
		str = ComFun.RP(str, "#@", s_tbPrefix) '替换数据表前缀
		ReplaceTable = str
    End Function

End Class
%>