<%
'######################################################################
'## Db.Cls.asp
'## -------------------------------------------------------------------
'## Feature     :   AspBox Database Control
'## Version     :   v1.0.0.1
'## Author      :   Lajox(lajox@19www.com)
'## Update Date :   2014/03/25 12:51
'## Description :   AspBox database controller
'######################################################################

Class Cls_DB

	Private s_connstr, s_dbType
	Private i_queryType, i_errNumber, i_pageIndex, i_fetchCount, i_affected
	Private o_conn, p_conn, o_rs, b_connect, b_debug, a_setdb
	Private s_tbPrefix, s_tbSuffix '数据表前缀和后缀
	Public sql, acc, mysql, oracle
	Public ComFun

	Private Sub Class_Initialize()
		Set ComFun = New Cls_ComFunc
		b_debug 		= True
		b_connect 		= False
		Init()
	End Sub

	Private Sub Init()
		Err.Clear
		i_fetchCount 	= 0
		i_queryType 	= 0
		s_dbType 		= ""
		s_tbPrefix 		= ""
		s_tbSuffix 		= ""
		Set sql 		= New Cls_DB_MSSQL
		Set acc 		= New Cls_DB_ACCESS
		Set mysql 		= New Cls_DB_MYSQL
		Set oracle 		= New Cls_DB_ORACLE
	End Sub

	Private Sub Class_Terminate()
		If IsObject(o_conn) And TypeName(o_conn) = "Connection" Then
			If o_conn.State = 1 Then o_conn.Close()
			b_connect = False
		End If
		Set o_conn = Nothing
		Set sql 		= Nothing
		Set acc 		= Nothing
		Set mysql 		= Nothing
		Set oracle 		= Nothing
	End Sub

	Public Property Let Debug(ByVal b)
		b_debug = b
	End Property
	Public Property Get Debug
		Debug = b_debug
	End Property

	Public Property Let tbPrefix(ByVal s)
		s_tbPrefix = s
	End Property
	Public Property Get tbPrefix()
		tbPrefix = s_tbPrefix
	End Property

	Public Property Let tbSuffix(ByVal s)
		s_tbSuffix = s
	End Property
	Public Property Get tbSuffix()
		tbSuffix = s_tbSuffix
	End Property

	Public Property Let Conn(ByVal pdbConn)
		If TypeName(pdbConn) = "Connection" Then
			Set o_conn = pdbConn
			s_dbType = GetDataType(pdbConn)
		Else
			If b_debug Then
				ComFun.ShowErr "无效的数据库连接！", Err.Number, Err.Description, Err.Source
			End If
		End If
	End Property

	Public Property Get Conn()
		If IsConn(o_conn) Then
			Set Conn = o_conn
		Else
			If IsConn(p_conn) Then Set Conn = p_conn
		End If
		If Not IsConn(o_conn) Then : Set Conn = Nothing : Exit Property : End If
	End Property

	Public Property Get isConnect:isConnect = b_connect:End Property
	Public Property Get State
		If b_connect Then : State = 1 : Else : State = 0 : End If
	End Property

	Public Property Get ifConn()
		Dim b_cn : b_cn = False
		If TypeName(o_conn) = "Connection" Then
			If o_conn.State = 1 Then b_cn = True Else b_cn = False
		Else
			b_cn = False
		End If
		ifConn = b_cn
	End Property

	Public Property Get DatabaseType()
		s_dbType = UCase(s_dbType)
		Select Case UCase(s_dbType)
			Case "0","MSSQL","SQL" : s_dbType = "MSSQL"
			Case "1","ACCESS","ACC","" : s_dbType = "ACCESS"
			Case "2","MYSQL" : s_dbType = "MYSQL"
			Case "3","ORACLE" : s_dbType = "ORACLE"
			Case Else : s_dbType = "ACCESS"
		End Select
		DatabaseType = s_dbType
	End Property

	Public Property Let DatabaseType(byval strType)
		Select Case UCase(strType)
			Case "0","MSSQL","SQL" : s_dbType = "MSSQL"
			Case "1","ACCESS","ACC","" : s_dbType = "ACCESS"
			Case "2","MYSQL" : s_dbType = "MYSQL"
			Case "3","ORACLE" : s_dbType = "ORACLE"
			Case Else : s_dbType = "ACCESS"
		End Select
	End Property

	Public Property Get DbType()
		DbType = DatabaseType()
	End Property

	Public Property Let DbType(byval strType)
		Select Case UCase(strType)
			Case "0","MSSQL","SQL" : s_dbType = "MSSQL"
			Case "1","ACCESS","ACC","" : s_dbType = "ACCESS"
			Case "2","MYSQL" : s_dbType = "MYSQL"
			Case "3","ORACLE" : s_dbType = "ORACLE"
			Case Else : s_dbType = "ACCESS"
		End Select
	End Property

	Public Property Let QueryType(ByVal str)
		Select Case LCase(str)
			Case "1","command","cmd" : i_queryType = 1
			Case "2","rst2" : i_queryType = 2
			Case "3","rst3" : i_queryType = 3
			Case "0","recordset","rs","rst","rst1" : i_queryType = 0
			Case Else : i_queryType = 0
		End Select
	End Property

	Public Property Get QueryType()
		Select Case LCase(i_queryType)
			Case "1","command","cmd" : i_queryType = 1
			Case "2","rst2" : i_queryType = 2
			Case "3","rst3" : i_queryType = 3
			Case "0","recordset","rs","rst1" : i_queryType = 0
			Case Else : i_queryType = 0
		End Select
		QueryType = i_queryType
	End Property

	Public Property Get ConnStr()
		s_connstr = getConnStr__()
		ConnStr = s_connstr
	End Property

	Public Property Get DBSet()
		Dim temp : If IsArray(a_setdb) Then temp = a_setdb
		DBSet = temp
	End Property

	Public Function [Set](ByVal dbType, ByVal strDB, ByVal strServer)
		Dim TempStr, objConn, s, u, p, port, [Return]
		s = "" : u = "" : p = "" : port = ""
		If Instr(strServer,"@")>0 Then
			s = Trim(Mid(strServer,InstrRev(strServer,"@")+1))
			u = Trim(Left(strServer,InstrRev(strServer,"@")-1))
			If Instr(s,":")>0 Then : port = Trim(Mid(s,Instr(s,":")+1)) : s = Trim(Left(s,Instr(s,":")-1))
			If Instr(u,":")>0 Then : p = Trim(Mid(u,Instr(u,":")+1)) : u = Trim(Left(u,Instr(u,":")-1))
		Else
			If Instr(strServer,":")>0 Then
				u = Trim(Left(strServer,Instr(strServer,":")-1))
				p = Trim(Mid(strServer,Instr(strServer,":")+1))
			Else
				p = Trim(strServer)
			End If
		End If
		s_dbType = UCase(Cstr(dbType))
		If s_dbType = "" Then s_dbType = "ACCESS"
		Select Case UCase(dbType)
			Case "0","MSSQL","SQL"
				sql.server = s : sql.db = strDB : sql.uid = u : sql.pwd = p
				If port <> "" Then sql.port = port
				s_dbType = "MSSQL"
				[Return] = Array(s_dbType, sql.server, sql.db, sql.uid, sql.pwd, sql.port)
			Case "1","ACCESS","ACC",""
				acc.db = strDB : acc.pwd = p
				s_dbType = "ACCESS"
				[Return] = Array(s_dbType, acc.db, acc.pwd)
			Case "2","MYSQL"
				mysql.server = s : mysql.db = strDB : mysql.uid = u : mysql.pwd = p
				If port = "" Then port = "3306" : mysql.port = port
				s_dbType = "MYSQL"
				[Return] = Array(s_dbType, mysql.server, mysql.db, mysql.uid, mysql.pwd, mysql.port)
			Case "3","ORACLE"
				oracle.server = s : oracle.uid = u : oracle.pwd = p
				s_dbType = "ORACLE"
				[Return] = Array(s_dbType, oracle.server, oracle.uid, oracle.pwd)
		End Select
		a_setdb = [Return]
		[Set] = [Return] '返回数组(该数组包含数据库配置信息)
	End Function

	Public Function OpenConn(ByVal dbType, ByVal strDB, ByVal strServer)
		Dim temp : temp = [Set](dbType, strDB, strServer)
		s_connstr = Me.ConnStr
		Set OpenConn = CreatConn(s_connstr)
		If IsConn(OpenConn) Then : Set p_conn = OpenConn : Conn = OpenConn : End If
	End Function

	Public Function CreatConn(ByVal ConnStr)
		On Error Resume Next
		Dim objConn : Set objConn = Server.CreateObject("ADODB.Connection")
		objConn.Open ConnStr
		If Err.Number = 0 Then b_connect = True
		If Err.number <> 0 Then
			b_connect = False
			objConn.Close
			Set objConn = Nothing
			If b_debug Then
				ComFun.ShowErr "数据库服务器端连接错误，请检查数据库连接信息是否正确！<br />(""" & ConnStr & """)", Err.Number, Err.Description, Err.Source
			End If
		End If
		Set CreatConn = objConn
		If IsConn(CreatConn) Then : Set p_conn = CreatConn : If Not IsConn(Conn) Then Conn = CreatConn : End If
		On Error Goto 0
	End Function

	Public Function Open()
		s_connstr = Me.ConnStr
		Set Open = CreatConn(s_connstr)
	End Function

	Public Function IsConn(ByVal obj)
		IsConn = False
		If Not IsObject(obj) Then Exit Function
		If Lcase(TypeName(obj)) = "connection" Then IsConn = True
	End Function

	Public Function GetDataType(ByVal connObj)
		If Not IsConn(connObj) Then Exit Function
		Dim str,i : str = UCase(connObj.Provider)
		Dim MSSQL, ACCESS, MYSQL, ORACLE
		MSSQL = Split("SQLNCLI10, SQLXMLOLEDB, SQLNCLI, SQLOLEDB, MSDASQL",", ")
		ACCESS = Split("MICROSOFT.ACE.OLEDB.12.0, MICROSOFT.JET.OLEDB.4.0",", ")
		MYSQL = "MYSQLPROV"
		ORACLE = Split("MSDAORA, OLEDB.ORACLE",", ")
		For i = 0 To Ubound(MSSQL)
			If Instr(str,MSSQL(i))>0 Then
				GetDataType = "MSSQL" : Exit Function
			End If
		Next
		For i = 0 To Ubound(ACCESS)
			If Instr(str,ACCESS(i))>0 Then
				GetDataType = "ACCESS" : Exit Function
			End If
		Next
		If Instr(str,MYSQL)>0 Then
			GetDataType = "MYSQL" : Exit Function
		End If
		For i = 0 To Ubound(ORACLE)
			If Instr(str,ORACLE(i))>0 Then
				GetDataType = "ORACLE" : Exit Function
			End If
		Next
	End Function

	Public Function GetTables(Byval conn)
		On Error Goto 0
		Dim tables, t, tb, arr, i : tables = Array()
		If ComFun.isNul(conn) Or Not Me.isConn(conn) Then
			Set t = Me.Conn.OpenSchema(20,Array(Empty,Empty,Empty,"TABLE"))
		Else
			Set t = conn.OpenSchema(20,Array(Empty,Empty,Empty,"TABLE"))
		End If
		If IsObject(t) Then
			If Not (t.eof Or t.bof) Then arr = t.GetRows(-1)
			If Not ComFun.isNul(arr) Then
				For i = 0 To Ubound(arr,2)
					tb = arr(2,i)
					tables = ComFun.Push(tables, tb)
				Next
			End If
			t.Close()
			Set t = Nothing
		End If
		GetTables = tables
		On Error Resume Next
	End Function

	Public Function tbExists(Byval TableName)
		Dim isExist : isExist = False
		Dim tb,fi : tb = TableName
		If InStr(tb,":") > 0 Then
			tb = Abx_Param(TableName)(0)
			fi = Abx_Param(TableName)(1)
			isExist = fieldExists(tb, fi)
		Else
			isExist = Abx_tbExists(tb)
		End If
		tbExists = isExist
	End Function

	Public Function fieldExists(Byval table, Byval field)
		On Error Resume Next
		Dim isExist : isExist = False
		Dim tb : tb = table : tb = "{prefix}" & DelFix(tb)
		tb = FixSQL(tb)
		Dim sql : sql = "select * from "&tb&""
		Dim item,tRs,temp : Set tRs = Exec(sql)
		For Each item In tRs.Fields
			temp = item.name
			If field = temp Then isExist = True
		Next
		Close(tRs)
		fieldExists = isExist
		If Err.Number <> 0 Then
			If b_debug Then
				ComFun.ShowErr "无效的查询条件，无法获取记录集！<br />" & sql, Err.Number, Err.Description, Err.Source
			End If
		End If
		On Error Goto 0
	End Function

	Public Function tbAutoID(ByVal table)
		If TypeName(o_conn)<>"Connection" Then Exit Function
		Dim t,dbtype,t_autoid,t_field,t_isautoid,t_nullable,t_default
		Dim tb : tb = table : tb = "{prefix}" & DelFix(tb)
		tb = FixSQL(tb) : tb = Trim(ComFun.CLeft(tb,":"))
		Set t = o_conn.OpenSchema(4,Array(Empty,Empty,tb,Empty))
		dbtype = DatabaseType
		Do While Not t.Eof
			t_field = t("COLUMN_NAME")
			If dbtype = "MSSQL" Then
				t_isautoid = isSQLAutoID(t("DATA_TYPE"),t("COLUMN_FLAGS"))
			ElseIf dbtype = "ACCESS" Then
				t_isautoid = isACCAutoID(t("DATA_TYPE"),t("COLUMN_FLAGS"))
			End If
			t_nullable = ComFun.IIF(t("IS_NULLABLE"),True,False)
			t_default = t("COLUMN_DEFAULT")
			If t_isautoid Then : t_autoid = t_field : Exit Do : End If
			t.MoveNext
		Loop
		tbAutoID = t_autoid
		Close(t)
	End Function

	Public Function AutoID(ByVal TableName)
		On Error Resume Next
		Dim rs, newRs, tmp, fID, tmpID : fID = "" : tmpID = 0
		Dim sqlt1, sqlt2, tmp1, tmp2, rst1, rst2, p : p = 1
		Dim tb : tb = TableName : tb = DelFix(tb)
		tmp = Abx_Param(tb)
		tb = trim(tmp(0))
		If ComFun.Has(tmp(1)) Then : fID = trim(tmp(1)) : tmp = "" : End If
		If p = 1 Then '采用此算法（精确）
			tmp1 = tbAutoID(tb)
			tmp2 = ComFun.IIF(fID<>"", ""&fID&"", ""&tmp1&"")
			If tbExists("LXTEST_TB_TEMP1") Then DoExecute("Drop Table {prefix}LXTEST_TB_TEMP1")
			sqlt1 = FixSQL("select "&tmp2&" into {prefix}LXTEST_TB_TEMP1 from  [{prefix}"&tb&"]")
			DoExecute(sqlt1)
			sqlt2 = FixSQL("select * from {prefix}LXTEST_TB_TEMP1")
			Set rst1 = DoExecute(sqlt2)
			If Err.number <> 0 Then
				If b_debug Then
					ComFun.ShowErr "无效的查询条件，无法获取新的ID号！", Err.Number, Err.Description, Err.Source
				End If
			End If
			rst1.addnew : rst1.update : Set rst1 = Nothing
			Set rs = GRS("Select " & ComFun.IIF(fID<>"", "Max("&fID&")", "Top 1 *") & " From {prefix}LXTEST_TB_TEMP1")
			If rs.eof Then
				AutoID = 1 : Exit Function
			Else
				If fID<>"" Then
					If ComFun.isNul(rs.Fields.Item(0).Value) Then AutoID = 0 : Exit Function
					AutoID = rs.Fields.Item(0).Value : Exit Function
				Else
					Set newRs = GRS("Select Max("&rs.Fields.Item(0).Name&") From [{prefix}LXTEST_TB_TEMP1]")
					tmpID = newRS.Fields.Item(0).Value
					newRs.Close() : Set newRs = Nothing
				End If
			End If
			If tbExists("LXTEST_TB_TEMP1") Then DoExecute("Drop Table {prefix}LXTEST_TB_TEMP1")
		Else
			Set rs = GRS("Select " & ComFun.IIF(fID<>"", "Max("&fID&")", "Top 1 *") & " From [{prefix}"&tb&"]")
			If rs.eof Then
				AutoID = 1 : Exit Function
			Else
				If fID<>"" Then
					If ComFun.isNul(rs.Fields.Item(0).Value) Then AutoID = 1 : Exit Function
					AutoID = rs.Fields.Item(0).Value + 1 : Exit Function
				Else
					Set newRs = GRS("Select Max("&rs.Fields.Item(0).Name&") From [{prefix}"&tb&"]")
					tmpID = newRS.Fields.Item(0).Value + 1
					newRs.Close() : Set newRs = Nothing
				End If
			End If
		End If
		Close(rs)
		If Err.number <> 0 Then
			If b_debug Then
				ComFun.ShowErr "无效的查询条件，无法获取新的ID号！", Err.Number, Err.Description, Err.Source
			End If
		End If
		AutoID = tmpID
		On Error Goto 0
	End Function

	Public Function GetRecord(ByVal TableName,ByVal Condition,ByVal OrderField)
		Set GetRecord = GRS(wGetRecord(TableName,Condition,OrderField))
	End Function

	Public Function GR(ByVal TableName,ByVal Condition,ByVal OrderField)
		Set GR = GetRecord(TableName, Condition, OrderField)
	End Function

	Public Function wGetRecord(ByVal TableName,ByVal Condition,ByVal OrderField)
		Dim sql, FieldsList, ShowN, o, p
		FieldsList = "" : ShowN = 0
		Dim tb : tb = TableName : tb = DelFix(tb)
		o = Abx_Param(tb)
		If ComFun.Has(o(1)) Then
			tb = Trim(o(0)) : FieldsList = Trim(o(1)) : o = ""
			p = Abx_Param(FieldsList)
			If ComFun.Has(p(1)) Then
				FieldsList = Trim(p(0)) : ShowN = Int(Trim(p(1))) : p = ""
			Else
				If isNumeric(FieldsList) Then ShowN = Int(FieldsList) : FieldsList = ""
			End If
		End If
		sql = "Select "
		If ShowN > 0 Then sql = sql & "Top " & ShowN & " "
		sql = sql & ComFun.IIF(FieldsList <> "", FieldsList, "* ")
		sql = sql & " From [{prefix}" & tb & "]"
		If isArray(Condition) Then
			sql = sql & " Where " & ValueToSql(tb,Condition,1)
		Else
			If Condition <> "" Then sql = sql & " Where " & Condition
		End If
		If OrderField <> "" Then sql = sql & " Order By " & OrderField
		sql = FixSQL(sql)
		wGetRecord = sql
	End Function

	Public Function wGR(ByVal TableName,ByVal Condition,ByVal OrderField)
		wGR = wGetRecord(TableName, Condition, OrderField)
	End Function

	Public Function GetRecordBySQL(ByVal sql)
		On Error Resume Next
		sql = FixSQL(sql)
		Dim rs
		Select Case LCase(i_queryType)
			Case "1","command","cmd"
				Dim cmd : Set cmd = Server.CreateObject("ADODB.Command")
				With cmd
					.ActiveConnection = o_conn
					.CommandText = sql
					Set GetRecordBySQL = .Execute
				End With
				Set cmd = Nothing
			Case "2","rst2"
				Set GetRecordBySQL = Server.CreateObject("Adodb.Recordset")
				GetRecordBySQL.Open sql,o_conn,3,3
			Case "3","rst3"
				Set GetRecordBySQL = Server.CreateObject("Adodb.Recordset")
				GetRecordBySQL.Open sql,o_conn,1,3
			Case "4","exe","exec"
				Set GetRecordBySQL = o_conn.Execute(sql)
			Case Else '如值："0","recordset","rs","rst","rst1"
				Set GetRecordBySQL = Server.CreateObject("Adodb.Recordset")
				With GetRecordBySQL
					.ActiveConnection = o_conn
					.CursorType = 1
					.LockType = 1
					.Source = sql
					.Open
				End With
		End Select
		If IsObject(rs) Then : rs.close : Set rs = Nothing : End If
		If Err.number <> 0 Then
			If b_debug Then
				ComFun.ShowErr "无效的查询条件，无法获取记录集！<br />"& sql, Err.Number, Err.Description, Err.Source
			End If
		End If
		On Error Goto 0
	End Function

	Public Function GRS(ByVal sql)
		Set GRS = GetRecordBySQL(sql)
	End Function

	Public Function Run(byval sql,byval queryType)
		On Error Resume Next
		sql = FixSQL(sql)
		Dim rs
		If Trim(queryType)="" Or IsNull(queryType) Then queryType = 0
		Select Case LCase(queryType)
			Case "0","recordset","rs","rst","rst1"
				Set Run = Server.CreateObject("Adodb.Recordset")
				Run.Open sql,o_conn,1,1
			Case "1","command","cmd"
				Set Run = DoExecute(sql)
			Case "2","rst2"
				Set Run = Server.CreateObject("Adodb.Recordset")
				Run.Open sql,o_conn,3,3
			Case "3","rst3"
				Set Run = Server.CreateObject("Adodb.Recordset")
				Run.Open sql,o_conn,1,3
			Case "4","exe","exec"
				Set Run = o_conn.Execute(sql)
			Case "5","arr","array"
				Set rs = Server.CreateObject("Adodb.Recordset")
				rs.Open sql,o_conn,1,1
				IF Not rs.Eof Then
					IF i_fetchCount > 0 Then Run = rs.getRows(i_fetchCount) Else Run = rs.getRows() : End IF
				End IF
			Case Else
				Set Run = Server.CreateObject("Adodb.Recordset")
				Run.Open sql,o_conn,1,1
		End Select
		If IsObject(rs) Then : rs.close : Set rs = Nothing : End If
		If Err.number <> 0 Then
			If b_debug Then
				ComFun.ShowErr "无效的查询条件，无法获取记录集！<br />"& sql, Err.Number, Err.Description, Err.Source
			End If
		End If
		On Error Goto 0
	End Function

	Public Function GetRecordDetail(ByVal TableName,ByVal Condition)
		Dim tb : tb = TableName : tb = DelFix(tb)
		Dim sql : sql = "Select * From [{prefix}" & tb & "] Where " & ValueToSql(tb,Condition,1)
		sql = FixSQL(sql)
		GetRecordDetail = sql
		Set GetRecordDetail = GRS(sql)
	End Function

	Public Function GRD(ByVal TableName,ByVal Condition)
		Set GRD = GetRecordDetail(TableName, Condition)
	End Function

	Public Function wAddRecord(ByVal TableName,ByVal ValueList)
		Dim sql, TempFiled, TempValue, o
		Dim tb : tb = TableName : tb = DelFix(tb)
		o = Abx_Param(tb) : If ComFun.Has(o(1)) Then tb = o(0)
		TempFiled = ValueToSql(tb,ValueList,2)
		TempValue = ValueToSql(tb,ValueList,3)
		sql = "Insert Into [{prefix}" & tb & "] (" & TempFiled & ") Values (" & TempValue & ")"
		sql = FixSQL(sql)
		wAddRecord = sql
	End Function

	Public Function AR(ByVal TableName,ByVal ValueList)
		AR = AddRecord(TableName,ValueList)
	End Function

	Public Function wAR(ByVal TableName,ByVal ValueList)
		wAR = wAddRecord(TableName,ValueList)
	End Function

	Public Function UpdateRecord(ByVal TableName,ByVal Condition,ByVal ValueList)
		On Error Resume Next
		Dim tb : tb = TableName : tb = DelFix(tb)
		Dim s : s = wUpdateRecord(tb,Condition,ValueList)
		DoExecute s
		If Err.number <> 0 Then
			If b_debug Then
				ComFun.ShowErr "更新数据库记录出错！<br />" & s, Err.Number, Err.Description, Err.Source
			End If
		End If
		UpdateRecord = 1
		On Error Goto 0
	End Function

	Public Function UR(ByVal TableName,ByVal Condition,ByVal ValueList)
		UR = UpdateRecord(TableName, Condition, ValueList)
	End Function

	Public Function wUpdateRecord(ByVal TableName,ByVal Condition,ByVal ValueList)
		Dim sql
		Dim tb : tb = TableName : tb = DelFix(tb)
		sql = "Update [{prefix}"&tb&"] Set "
		sql = sql & ValueToSql(tb,ValueList,0)
		If ComFun.Has(Condition) Then sql = sql & " Where " & ValueToSql(tb,Condition,1)
		sql = FixSQL(sql)
		wUpdateRecord = sql
	End Function

	Public Function wUR(ByVal TableName,ByVal Condition,ByVal ValueList)
		wUR = wUpdateRecord(TableName, Condition, ValueList)
	End Function

	Public Function DeleteRecord(ByVal TableName,ByVal Condition)
		On Error Resume Next
		Dim tb : tb = TableName : tb = DelFix(tb)
		Dim s : s = wDeleteRecord(tb,Condition)
		DoExecute s
		If Err.number <> 0 Then
			If b_debug Then
				ComFun.ShowErr "从数据库删除数据出错！<br />" & s, Err.Number, Err.Description, Err.Source
			End If
		End If
		DeleteRecord = 1
		On Error Goto 0
	End Function

	Public Function DR(ByVal TableName,ByVal Condition)
		DR = DeleteRecord(TableName, Condition)
	End Function

	Public Function wDeleteRecord(ByVal TableName,ByVal Condition)
		Dim IDFieldName, IDValues, Sql, p : IDFieldName = "" : IDValues = ""
		Dim tb : tb = TableName : tb = DelFix(tb)
		If Not isArray(Condition) Then
			p = Abx_Param(Condition)
			If ComFun.Has(p(1)) Then
				IDFieldName = p(0)
				If Instr(IDFieldName," ")=0 Then
					IDValues = p(1)
				Else
					IDFieldName = ""
				End If
			End If
		End If
		Sql = "Delete From [{prefix}"&tb&"] Where " & ComFun.IIF(IDFieldName="", ValueToSql(tb,Condition,1), "["&IDFieldName&"] In (" & IDValues & ")")
		Sql = FixSQL(Sql)
		wDeleteRecord = Sql
	End Function

	Public Function wDR(ByVal TableName,ByVal Condition)
		wDR = wDeleteRecord(TableName, Condition)
	End Function

	Public Function ReadTable(ByVal TableName,ByVal Condition,ByVal GetFieldNames)
		On Error Resume Next
		Dim rs,Sql,arrTemp,arrStr,TempStr,i
		Dim tb : tb = TableName : tb = DelFix(tb)
		TempStr = "" : arrStr = ""
		Sql = "Select "&GetFieldNames&" From [{prefix}"&tb&"] Where " & ValueToSql(tb,Condition,1)
		sql = FixSQL(sql)
		Set rs = GRS(Sql)
		If Not rs.Eof Then
			If Instr(GetFieldNames,",") > 0 Then
				arrTemp = Split(GetFieldNames,",")
				For i = 0 To Ubound(arrTemp)
					If i<>0 Then arrStr = arrStr & Chr(0)
					arrStr = arrStr & rs.Fields.Item(i).Value
				Next
				TempStr = Split(arrStr,Chr(0))
			Else
				TempStr = rs.Fields.Item(0).Value
			End If
		End If
		rs.close() : Set rs = Nothing
		If Err.number <> 0 Then
			If b_debug Then
				ComFun.ShowErr "从数据库获取数据出错！", Err.Number, Err.Description, Err.Source
			End If
		End If
		ReadTable = TempStr
		On Error Goto 0
	End Function

	Public Function RT(ByVal TableName,ByVal Condition,ByVal GetFieldNames)
		RT = ReadTable(TableName, Condition, GetFieldNames)
	End Function

	Public Function Close(ByRef o)
		On Error Resume Next
		If IsObject(o) Then 'Object
			o.Close() : Set o = Nothing
		ElseIF VarType(o) = 8 Then 'String
			Dim temp : temp = Eval("LCase(TypeName(o))")
			If temp = "connection" Then : Execute("If o.State = 1 Then o.Close()") : End If
			If temp = "recordset" Then : Execute("If o.State = 1 Then o.Close()") : End If
			Execute("Set "& o &" = Nothing")
		End If
		IF Err Then Err.Clear
		On Error Goto 0
	End Function

	Public Function C(ByRef o)
		On Error Resume Next
		If IsObject(o) Then 'Object
			o.Close() : Set o = Nothing
		ElseIF VarType(o) = 8 Then 'String
			Dim temp : temp = Eval("LCase(TypeName(o))")
			If temp = "connection" Then : Execute("If o.State = 1 Then o.Close()") : End If
			If temp = "recordset" Then : Execute("If o.State = 1 Then o.Close()") : End If
			Execute("Set "& o &" = Nothing")
		End If
		IF Err Then Err.Clear
		On Error Goto 0
	End Function

	'克隆Rs数据集
	Public Function CloneRs(ByVal Rs)
		On Error Resume Next
		Dim newRs, i, j, f, v, a, b, pos : pos = 0
		If ComFun.IsRs(Rs) Then
			pos = Rs.AbsolutePosition '记录游标位置
			Set newRs = ComFun.NewRs()
			newRs.CursorLocation = 1
			newRs.CursorType = 3
			For i = 0 To Rs.Fields.Count-1
				f = Rs.Fields(i).Name
				v = Rs.Fields(i).Value
				newRs.Fields.Append Rs.Fields(i).Name, Rs.Fields(i).Type, Rs.Fields(i).DefinedSize, Rs.Fields(i).Attributes
			Next
			newRs.Open
			If Rs.RecordCount>0 Then Rs.MoveFirst()
			Do While Not Rs.eof
				a = Array()
				b = Array()
				For j = 0 To Rs.Fields.Count-1
					f = Rs.Fields(j).Name
					v = Rs.Fields(j).Value
					If Not ComFun.InArray(Rs.Fields(j).Type, Array( 7, 135 )) Then
						'v = ComFun.IIF(ComFun.isNul(v),"",v)
					End If
					a = ComFun.Push(a, f)
					b = ComFun.Push(b, v)
				Next
				newRs.AddNew a, b
				newRs.Update()
				Rs.MoveNext
			Loop
			If newRs.RecordCount>0 Then newRs.MoveFirst()
			If pos>0 Then
				Rs.MoveFirst()
				Rs.Move(pos-1)
			End If
			Set CloneRs = newRs
		End If
		On Error Goto 0
	End Function

	Public Function getRs(ByVal sql)
		Set getRs = Server.CreateObject("Adodb.Recordset")
		getRs.Open sql,o_conn,1,1
		If Err.number <> 0 Then
			If b_debug Then
				ComFun.ShowErr "无效的查询条件，无法获取记录集！<br />" & sql, Err.Number, Err.Description, Err.Source
			End If
		End If
	End Function

	Public Function Rs(ByVal sql)
		Set Rs = Server.CreateObject("Adodb.Recordset")
		Rs.Open sql,o_conn,1,3
		If Err.number <> 0 Then
			If b_debug Then
				ComFun.ShowErr "无效的查询条件，无法获取记录集！<br />" &sql, Err.Number, Err.Description, Err.Source
			End If
		End If
	End Function

	Public Function Exec(ByVal sql)
		On Error Resume Next
		sql = FixSQL(sql)
		If Lcase(Left(sql,6)) = "select" Then
			'Set Exec = o_conn.Execute(sql)
			'_以下等同于: Set Exec = Server.CreateObject("Adodb.Recordset") : Exec.Open sql,o_conn,1,3
			Dim i : i = i_queryType
			i_queryType = 3
			Set Exec = GRS(sql)
			i_queryType = i
		Else
			Exec = 1 : DoExecute(sql)
			If Err.number <> 0 Then Exec = 0
		End If
		If Err.number <> 0 Then
			If b_debug Then
				ComFun.ShowErr "执行SQL语句出错！<br />" &sql, Err.Number, Err.Description, Err.Source
			End If
		End If
		On Error Goto 0
	End Function

	Public Function Cmd(ByVal sql)
		'Set Cmd = DoExecute(sql)
		Dim ExecuteCmd : Set ExecuteCmd = Server.CreateObject("ADODB.Command")
		sql = FixSQL(sql)
		With ExecuteCmd
			.ActiveConnection = o_conn
			.CommandText = sql
			Set Cmd = .Execute
		End With
		Set ExecuteCmd = Nothing
		If Err.number <> 0 Then
			If b_debug Then
				ComFun.ShowErr "无效的查询条件，无法获取记录集！<br />" &sql, Err.Number, Err.Description, Err.Source
			End If
		End If
	End Function

	Public Function GPR(ByVal PageSetup, ByVal Condition)
		Set GPR = GetPageRecord(PageSetup, Condition)
	End Function

	Public Function FixSQL(ByVal str)
		Dim temp : temp = str
		temp = ComFun.RP(temp, "{prefix}" ,s_tbPrefix)
		temp = ComFun.RP(temp, "{suffix}" ,s_tbSuffix)
		FixSQL = temp
	End Function

	Public Function DelFix(ByVal str)
		Dim temp : temp = str
		temp = ComFun.RP(temp, "{prefix}" ,"")
		temp = ComFun.RP(temp, "{suffix}" ,"")
		DelFix = temp
	End Function

	Private Function ValueToSql(ByVal TableName, ByVal ValueList, ByVal sType)
		On Error Resume Next
		Dim StrTemp : StrTemp = ValueList
		If IsArray(ValueList) Then
			StrTemp = ""
			Dim rsTemp, CurrentField, CurrentValue, CurrentSign, i
			Set rsTemp = GRS("Select Top 1 * From [{prefix}" & TableName & "] Where 1 = -1")
			For i = 0 to Ubound(ValueList)
				CurrentField = Abx_Param(ValueList(i))(0)
				CurrentValue = Abx_Param(ValueList(i))(1)
				CurrentSign = Abx_Param(ValueList(i))(2)
				If i <> 0 Then StrTemp = StrTemp & ComFun.IIF(sType=1, " And ", ", ")
				If sType = 2 Then
					StrTemp = StrTemp & "[" & CurrentField & "]"
				Else
					If Trim(CurrentValue)<>"" Then
						s_dbType = UCase(Cstr(dbType))
						If s_dbType = "" Then s_dbType = "ACCESS"
						If CurrentSign = "" Then CurrentSign = "="
						Select Case rsTemp.Fields(CurrentField).Type
							Case 8,129,130,133,134,200,201,202,203
								StrTemp = StrTemp & ComFun.IIF(sType = 3, "'"&CurrentValue&"'", "[" & CurrentField & "] "&CurrentSign&" '"&CurrentValue&"'")
							Case 7,135
								CurrentValue = ComFun.IIF(ComFun.isNul(CurrentValue),"NULL","'"&CurrentValue&"'")
								StrTemp = StrTemp & ComFun.IIF(sType = 3, CurrentValue, "[" & CurrentField & "] "&CurrentSign&" " & CurrentValue)
							Case 11
								Dim tmpTF, tmpTFV : tmpTFV = UCase(cstr(Trim(CurrentValue)))
								tmpTF = ComFun.IIF(tmpTFV="TRUE" or tmpTFV = "1", ComFun.IIF(s_dbType="ACCESS","True","1"), ComFun.IIF(s_dbType="ACCESS",ComFun.IIF(tmpTFV="","NULL","False"),ComFun.IIF(tmpTFV="","NULL","0")))
								StrTemp = StrTemp & ComFun.IIF(sType = 3, tmpTF, "[" & CurrentField & "] "&CurrentSign&" " & tmpTF)
							Case Else
								CurrentValue = ComFun.IIF(ComFun.isNul(CurrentValue),"NULL",CurrentValue)
								StrTemp = StrTemp & ComFun.IIF(sType = 3, CurrentValue, "[" & CurrentField & "] "&CurrentSign&" " & CurrentValue)
						End Select
					Else
						StrTemp = StrTemp & CurrentField & ""
					End If
				End If
			Next
			rsTemp.Close() : Set rsTemp = Nothing
			If Err.number <> 0 Then
				If b_debug Then
					ComFun.ShowErr "生成SQL语句出错！", Err.Number, Err.Description, Err.Source
				End If
			End If
		End If
		ValueToSql = StrTemp
		On Error Goto 0
	End Function

	Private Function DoExecute(ByVal sql)
		On Error Resume Next
		Dim ExecuteCmd
		sql = FixSQL(sql)
		i_affected = 0
		''Set DoExecute = o_conn.Execute(sql, i_affected, adCmdText)
		Set DoExecute = o_conn.Execute(sql, i_affected, 1)
		If Err.Number <> 0 Then
			Err.Clear()
			Set ExecuteCmd = Server.CreateObject("ADODB.Command")
			With ExecuteCmd
				.ActiveConnection = o_conn
				''.Commandtype = adCmdText
				.Commandtype = 1
				.CommandText = sql
				''Set DoExecute = .Execute
				Set DoExecute = .Execute(i_affected,,adExecuteNoRecords)
				If Err.Number <> 0 Then
					Err.Clear()
					Set DoExecute = .Execute
				End If
			End With
			Set ExecuteCmd = Nothing
		End If
		On Error Goto 0
	End Function

	'返回影响的行数，如直接执行Update或Delete语句操作。
	Public Function AffectedRows()
		If IsEmpty(i_affected) Then i_affected = 0
		AffectedRows = i_affected
	End Function

	Private Function Abx_tbExists(Byval table)
		Dim rsSchema,isExist : isExist = False
		Set rsSchema = o_conn.openSchema(20)
		Dim tb : tb = table : tb = "{prefix}" & DelFix(tb)
		tb = FixSQL(tb)
		rsSchema.MoveFirst
		Do Until rsSchema.EOF
			If rsSchema("TABLE_TYPE")="TABLE" Then
				If LCase(rsSchema("TABLE_NAME")) = LCase(tb) Then
					isExist = True
					Exit Do
				End If
			End If
			rsSchema.movenext
		Loop
		Close(rsSchema)
		Abx_tbExists = isExist
		If Err.Number <> 0 Then
			If b_debug Then
				ComFun.ShowErr "查询记录出错", Err.Number, Err.Description, Err.Source
			End If
		End If
	End Function

	Private Function isSQLAutoID(ByVal typeid, ByVal flag)
		isSQLAutoID = False
		Dim tmp1, tmp2
		Select Case typeid
			Case 2
				tmp1 = "smallint"
				tmp2 = ComFun.IIF(flag=16,"自增","")
			Case 3
				tmp1 = "int"
				tmp2 = ComFun.IIF(flag=20,"自增","")
			Case 17
				tmp1 = "tinyint"
				tmp2 = ComFun.IIF(flag=16,"自增","")
			Case 20
				tmp1 = "bigint"
				tmp2 = ComFun.IIF(flag=16,"自增","")
		End Select
		If tmp2="自增" Then isSQLAutoID = True
	End Function

	Private Function isACCAutoID(ByVal typeid, ByVal flag)
		isACCAutoID = False
		Dim tmp1, tmp2
		Select Case typeid
			Case 2
				tmp1 = "num"
			Case 3
				tmp1 = "int"
				tmp2 = ComFun.IIF(flag=90,"自增","")
		End Select
		If tmp2="自增" Then isACCAutoID = True
	End Function

	Private Function Abx_Param(ByVal s)
		Dim arr(2),t : t = Instr(s,":")
		If t > 0 Then
			arr(0) = Trim(Left(s,t-1)) : arr(1) = Trim(Mid(s,t+1))
		Else
			If trim(s)="" Then
				arr(0) = "" : arr(1) = "" : arr(2) = ""
			Else
				If Instr(s,">=") > 0 Then
					arr(0) = Trim(ComFun.CLeft(s,">=")) : arr(1) = Trim(ComFun.CRight(s,">=")) : arr(2) = ">="
				ElseIf Instr(s,"<=") > 0 Then
					arr(0) = Trim(ComFun.CLeft(s,"<=")) : arr(1) = Trim(ComFun.CRight(s,"<=")) : arr(2) = "<="
				ElseIf Instr(s,"<>") > 0 Then
					arr(0) = Trim(ComFun.CLeft(s,"<>")) : arr(1) = Trim(ComFun.CRight(s,"<>")) : arr(2) = "<>"
				ElseIf Instr(s,"!=") > 0 Then
					arr(0) = Trim(ComFun.CLeft(s,"<=")) : arr(1) = Trim(ComFun.CRight(s,"!=")) : arr(2) = "<>"
				ElseIf Instr(s,">") > 0 Then
					arr(0) = Trim(ComFun.CLeft(s,">")) : arr(1) = Trim(ComFun.CRight(s,">")) : arr(2) = ">"
				ElseIf Instr(s,"<") > 0 Then
					arr(0) = Trim(ComFun.CLeft(s,"<")) : arr(1) = Trim(ComFun.CRight(s,"<")) : arr(2) = "<"
				ElseIf Instr(s,"=") > 0 Then
					arr(0) = Trim(ComFun.CLeft(s,"=")) : arr(1) = Trim(ComFun.CRight(s,"=")) : arr(2) = "="
				Else
					arr(0) = s : arr(1) = "" : arr(2) = ""
				End If
			End If
		End If
		Abx_Param = arr
	End Function

	Private Function getConnStr__()
		Dim a_sql(5), a_acc(2), a_mysql(1), a_oracle(1), tempstr
		If s_dbType = "" Or UCase(s_dbType) = "ACC" Then s_dbType = "ACCESS"
		If UCase(s_dbType) = "SQL" Then s_dbType = "MSSQL"
		IF UCase(s_dbType) = "SQL" Or UCase(s_dbType) = "MSSQL" Then
			a_sql(0) = "DRIVER={SQL SERVER}; Server = " & sql.server & ComFun.IfThen(ComFun.Has(sql.port), "," & sql.port) & "; Uid = " & sql.uid & "; Pwd = " & sql.pwd & "; Database = " & sql.db & ";"
			a_sql(1) = "Provider = SQLOLEDB; Server = " & sql.server & ComFun.IfThen(ComFun.Has(sql.port), "," & sql.port) & "; Uid = " & sql.uid & "; Pwd = " & sql.pwd & "; Database = " & sql.db & ";"
			a_sql(2) = "Provider = SQLOLEDB.1; Persist Security Info=False; Server=" & sql.server & ComFun.IfThen(ComFun.Has(sql.port), "," & sql.port) & ",1433; User ID = " & sql.uid & "; Password = " & sql.pwd & "; Database = " & sql.db & ";"
			a_sql(3) = "Provider = SQLOLEDB; Data Source = " & sql.server & ComFun.IfThen(ComFun.Has(sql.port), "," & sql.port) & "; Initial Catalog = " & sql.db & "; User ID = " & sql.uid & "; Password = " & sql.pwd & ";"
			a_sql(4) = "Provider = SQLOLEDB.1; DATA SOURCE=" & sql.server & ComFun.IfThen(ComFun.Has(sql.port), "," & sql.port) & "; UID="& sql.uid &"; PWD="& sql.pwd &"; Database="& sql.db &"; Pooling=true; MAX Pool Size=512; Min Pool Size=50; Connection Lifetime=30"
			tempstr = a_sql(3)
		ElseIf UCase(s_dbType) = "MYSQL" Then
			If mysql.port = "" Then mysql.port = "3306"
			a_mysql(0) = "Driver={mySQL};Server=" & mysql.server & ";Port=" & mysql.port & ";Option=131072;Stmt=;Database=" & mysql.db & ";Uid=" & mysql.uid & ";Pwd=" & mysql.pwd & ";"
			tempstr = a_mysql(0)
		ElseIf UCase(s_dbType) = "ORACLE" Then
			a_oracle(0) = "Provider=msdaora;Data Source=" & oracle.server & ";User Id=" & oracle.uid & ";Password=" & oracle.pwd & ";"
			tempstr = a_oracle(0)
		Else
			Dim tDb : tDb = acc.db : If Instr(acc.db,":")>0 Then : tDb = acc.db : Else : If Trim(tDb) <> "" Then tDb = Server.MapPath(acc.db) : End If
			a_acc(0) = "DBQ="+ tDb +";DefaultDir=;DRIVER={Microsoft Access Driver (*.mdb)};"
			a_acc(1) = "Provider=Microsoft.Jet.OLEdb.4.0;Data Source=" & tDb
			'==acc带密码
			If acc.pwd<>"" Then a_acc(0) = a_acc(0) & "Persist Security Info=False;pwd="& acc.pwd &""
			If acc.pwd<>"" Then a_acc(1) = a_acc(1) & "Persist Security info=false;Jet OLEDB:Database password="& acc.pwd &""
			tempstr = a_acc(1)
		End IF
		s_connstr = tempstr
		getConnStr__ = s_connstr
	End Function

End Class
Class Cls_DB_MSSQL : Dim [server], db, uid, pwd, port: End Class
Class Cls_DB_ACCESS : Dim db, pwd: End Class
Class Cls_DB_MYSQL : Dim [server], uid, pwd, port, db: End Class
Class Cls_DB_ORACLE : Dim [server], uid, pwd, db: End Class
%>