 
 
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1"><title>
	首页
</title>
    <script language="javascript" type="text/javascript">

//MzTreeView1.0网页树类, 在实例化的时候请把实例名作参数传递进来
function MzTreeView(Tname)
{
  if(typeof(Tname) != "string" || Tname == "")
    throw(new Error(-1, '创建类实例的时候请把类实例的引用变量名传递进来！'));
  
  //【property】
  this.url      = "#";
  this.target   = "table_index";
  this.name     = Tname;
  this.wordLine = false;
  this.currentNode = null;
  this.useArrow = true;
  this.nodes = {};
  this.node  = {};
  this.names = "";
  this._d    = "\x0f";
  this.index = 0;
  this.divider   = "_";
  this.node["0"] =
  {
    "id": "0",
    "path": "0",
    "isLoad": false,
    "childNodes": [],
    "childAppend": "",
    "sourceIndex": "-1"
  };

  this.colors   =
  {
    "highLight" : "#0A246A",
    "highLightText" : "#FFFFFF",
    "mouseOverBgColor" : "#D4D0C8"
  };
  this.icons    = {
    L0        : 'L0.gif',  //┏
    L1        : 'L1.gif',  //┣
    L2        : 'L2.gif',  //┗
    L3        : 'L3.gif',  //━
    L4        : 'L4.gif',  //┃
    PM0       : 'P0.gif',  //＋┏
    PM1       : 'P1.gif',  //＋┣
    PM2       : 'P2.gif',  //＋┗
    PM3       : 'P3.gif',  //＋━
    empty     : 'L5.gif',     //空白图
    root      : 'root.gif',   //缺省的根节点图标
    folder    : 'folder.gif', //缺省的文件夹图标
    file      : 'file.gif',   //缺省的文件图标
    exit      : 'exit.gif'
  };
  this.iconsExpand = {  //存放节点图片在展开时的对应图片
    PM0       : 'M0.gif',     //－┏
    PM1       : 'M1.gif',     //－┣
    PM2       : 'M2.gif',     //－┗
    PM3       : 'M3.gif',     //－━
    folder    : 'folderopen.gif',

    exit      : 'exit.gif'
  };

  //扩展 document.getElementById(id) 多浏览器兼容性
  //id 要查找的对象 id
  this.getElementById = function(id)
  {
    if (typeof(id) != "string" || id == "") return null;
    if (document.getElementById) return document.getElementById(id);
    if (document.all) return document.all(id);
    try {return eval(id);} catch(e){ return null;}
  }

  //MzTreeView 初始化入口函数
  this.toString = function()
  {
    this.browserCheck();
    this.dataFormat();
    this.setStyle();
    this.load("0");
    var rootCN = this.node["0"].childNodes;
    var str = "<A id='"+ this.name +"_RootLink' href='#' style='DISPLAY: none'></A>";
    
    if(rootCN.length>0)
    {
      this.node["0"].hasChild = true;
      for(var i=0; i<rootCN.length; i++)
        str += this.nodeToHTML(rootCN[i], i==rootCN.length-1);
      setTimeout(this.name +".expand('"+ rootCN[0].id +"', true); "+ 
        this.name +".focusClientNode('"+ rootCN[0].id +"'); "+ this.name +".atRootIsEmpty()",10);
    }

    if (this.useArrow)  //使用方向键控制跳转到上级下级父级子级节点
    {
      if (document.attachEvent)
          document.attachEvent("onkeydown", this.onkeydown);
      else if (document.addEventListener)
          document.addEventListener('keydown', this.onkeydown, false);
    }
    return "<DIV class='MzTreeView' "+
      "onclick='"+ this.name +".clickHandle(event)' "+
      "ondblclick='"+ this.name +".dblClickHandle(event)' "+
      ">"+ str +"</DIV>";
  };

  this.onkeydown= function(e)
  {
    e = window.event || e; var key = e.keyCode || e.which;
    switch(key)
    {
      case 37 : eval(Tname).upperNode(); break;  //Arrow left, shrink child node
      case 38 : eval(Tname).pervNode();  break;  //Arrow up
      case 39 : eval(Tname).lowerNode(); break;  //Arrow right, expand child node
      case 40 : eval(Tname).nextNode();  break;  //Arrow down
    }
  };
}

//浏览器类型及版本检测
MzTreeView.prototype.browserCheck = function()
{
  var ua = window.navigator.userAgent.toLowerCase(), bname;
  if(/msie/i.test(ua))
  {
    this.navigator = /opera/i.test(ua) ? "opera" : "";
    if(!this.navigator) this.navigator = "msie";
  }
  else if(/gecko/i.test(ua))
  {
    var vendor = window.navigator.vendor.toLowerCase();
    if(vendor == "firefox") this.navigator = "firefox";
    else if(vendor == "netscape") this.navigator = "netscape";
    else if(vendor == "") this.navigator = "mozilla";
  }
  else this.navigator = "msie";
  if(window.opera) this.wordLine = false;
};

//给 TreeView 树加上样式设置
MzTreeView.prototype.setStyle = function()
{
  /*
    width: 16px; \
    height: 16px; \
    width: 20px; \
    height: 20px; \
  */
  var style = "<style>"+
  "DIV.MzTreeView DIV IMG{border: 0px solid #FFFFFF;}"+
  "DIV.MzTreeView DIV SPAN IMG{border: 0px solid #FFFFFF;}";
  if(this.wordLine)
  {
    style +="\
    DIV.MzTreeView DIV\
    {\
      height: 20px;"+
      (this.navigator=="firefox" ? "line-height: 20px;" : "" ) +
      (this.navigator=="netscape" ? "" : "overflow: hidden;" ) +"\
    }\
    DIV.MzTreeView DIV SPAN\
    {\
      vertical-align: middle; font-size: 21px; height: 20px; color: #D4D0C8; cursor: default;\
    }\
    DIV.MzTreeView DIV SPAN.pm\
    {\
      width: "+ (this.navigator=="msie"||this.navigator=="opera" ? "11" : "9") +"px;\
      height: "+ (this.navigator=="netscape"?"9":(this.navigator=="firefox"?"10":"11")) +"px;\
      font-size: 7pt;\
      overflow: hidden;\
      margin-left: -16px;\
      margin-right: 5px;\
      color: #000080; \
      vertical-align: middle;\
      border: 1px solid #D4D0C8;\
      cursor: "+ (this.navigator=="msie" ? "hand" : "pointer") +";\
      padding: 0 2px 0 2px;\
      text-align: center;\
      background-color: #F0F0F0;\
    }";
  }
  style += "<\/style>";
  document.write(style);
};

//当根节点为空的时候做的处理
MzTreeView.prototype.atRootIsEmpty = function()
{
  var RCN = this.node["0"].childNodes;
  for(var i=0; i<RCN.length; i++)
  {
    if(!RCN[i].isLoad) this.expand(RCN[i].id);
    if (RCN[i].text=="")
    {
      var node = RCN[i].childNodes[0], HCN  = node.hasChild;
      if(this.wordLine)
      {
        var span = this.getElementById(this.name +"_tree_"+ node.id);
        span = span.childNodes[0].childNodes[0].childNodes[0];
        span.innerHTML = RCN[i].childNodes.length>1 ? "┌" : "─";
      }
      else
      {
        node.iconExpand  =  RCN[i].childNodes.length>1 ? HCN ? "PM0" : "L0" : HCN ? "PM3" : "L3"
        this.getElementById(this.name +"_expand_"+ node.id).src = this.icons[node.iconExpand].src;
      }
    }
  }
};

//初始化数据源里的数据以便后面的快速检索
MzTreeView.prototype.dataFormat = function()
{
  var a = new Array();
  for (var id in this.nodes) a[a.length] = id;
  this.names = a.join(this._d + this._d);
  this.totalNode = a.length; a = null;
};

//在数据源检索所需的数据节点
//id  客户端节点对应的id
MzTreeView.prototype.load = function(id)
{
  var node = this.node[id], d = this.divider, _d = this._d;
  var sid = node.sourceIndex.substr(node.sourceIndex.indexOf(d) + d.length);
  var reg = new RegExp("(^|"+_d+")"+ sid +d+"[^"+_d+d +"]+("+_d+"|$)", "g");
  var cns = this.names.match(reg), tcn = this.node[id].childNodes; if (cns){
  reg = new RegExp(_d, "g"); for (var i=0; i<cns.length; i++)
  tcn[tcn.length] = this.nodeInit(cns[i].replace(reg, ""), id); }
  node.isLoad = true;
};

//初始化节点信息, 根据 this.nodes 数据源生成节点的详细信息
//sourceIndex 数据源中的父子节点组合的字符串 0_1
//parentId    当前树节点在客户端的父节点的 id
MzTreeView.prototype.nodeInit = function(sourceIndex, parentId)
{
  this.index++;
  var source= this.nodes[sourceIndex], d = this.divider;
  var text  = this.getAttribute(source, "text");
  var hint  = this.getAttribute(source, "hint");
  var sid   = sourceIndex.substr(sourceIndex.indexOf(d) + d.length);
  this.node[this.index] =
  {
    "id"    : this.index,
    "text"  : text,
    "hint"  : hint ? hint : text,
    "icon"  : this.getAttribute(source, "icon"),
    "path"  : this.node[parentId].path + d + this.index,
    "isLoad": false,
    "isExpand": false,
    "parentId": parentId,
    "parentNode": this.node[parentId],
    "sourceIndex" : sourceIndex,
    "childAppend" : ""
  };
     this.nodes[sourceIndex] = "index:"+ this.index +";"+ source;
     this.node[this.index].hasChild = this.names.indexOf(this._d + sid + d)>-1;
  if(this.node[this.index].hasChild)  this.node[this.index].childNodes = [];
  return this.node[this.index];
};

//从XML格式字符串里提取信息
//source 数据源里的节点信息字符串(以后可以扩展对XML的支持)
//name   要提取的属性名
MzTreeView.prototype.getAttribute = function(source, name)
{
  var reg = new RegExp("(^|;|\\s)"+ name +"\\s*:\\s*([^;]*)(\\s|;|$)", "i");
  if (reg.test(source)) return RegExp.$2.replace(/[\x0f]/g, ";"); return "";
};

//根据节点的详细信息生成HTML
//node   树在客户端的节点对象
//AtEnd  布尔值  当前要转换的这个节点是否为父节点的子节点集中的最后一项
MzTreeView.prototype.nodeToHTML = function(node, AtEnd)
{
  var source = this.nodes[node.sourceIndex];
  var target = this.getAttribute(source, "target");
  var data = this.getAttribute(source, "data");
  var url  = this.getAttribute(source, "url");
  if(!url) url = this.url;
  if(data) url += (url.indexOf("?")==-1?"?":"&") + data;
  if(!target) target = this.target;

  var id   = node.id;
  var HCN  = node.hasChild, isRoot = node.parentId=="0";
  if(isRoot && node.icon=="") node.icon = "root";
  if(node.icon=="" || typeof(this.icons[node.icon])=="undefined")
    node.icon = HCN ? "folder" : "file";
  node.iconExpand  = AtEnd ? "└" : "├";

  var HTML = "<DIV noWrap='True'><NOBR>";
  if(!isRoot)
  {
    node.childAppend = node.parentNode.childAppend + (AtEnd ? "　" : "│");
    if(this.wordLine)
    {
      HTML += "<SPAN>"+ node.parentNode.childAppend + (AtEnd ? "└" : "├") +"</SPAN>";
      if(HCN) HTML += "<SPAN class='pm' id='"+ this.name +"_expand_"+ id +"'>+</SPAN>";
    }
    else
    {
      node.iconExpand  = HCN ? AtEnd ? "PM2" : "PM1" : AtEnd ? "L2" : "L1";
      HTML += "<SPAN>"+ this.word2image(node.parentNode.childAppend) +"<IMG "+
        "align='absmiddle' id='"+ this.name +"_expand_"+ id +"' "+
        "src='"+ this.icons[node.iconExpand].src +"' style='cursor: "+ (!node.hasChild ? "":
        (this.navigator=="msie"||this.navigator=="opera"? "hand" : "pointer")) +"'></SPAN>";
    }
  }
  HTML += "<IMG "+
    "align='absMiddle' "+
    "id='"+ this.name +"_icon_"+ id +"' "+
    "src='"+ this.icons[node.icon].src +"'><A "+
    "class='MzTreeview' hideFocus "+
    "id='"+ this.name +"_link_"+ id +"' "+
    "href='"+ url +"' "+
    "target='"+ target +"' "+
    "title='"+ node.hint +"' "+
    "onfocus=\""+ this.name +".focusLink('"+ id +"')\" "+
    "onclick=\"return "+ this.name +".nodeClick('"+ id +"')\">"+ node.text +
  "</A></NOBR></DIV>";
  if(isRoot && node.text=="") HTML = "";

  HTML = "\r\n<SPAN id='"+ this.name +"_tree_"+ id +"'>"+ HTML 
  HTML +="<SPAN style='DISPLAY: none'></SPAN></SPAN>";
  return HTML;
};

//在使用图片的时候对 node.childAppend 的转换
MzTreeView.prototype.word2image = function(word)
{
  var str = "";
  for(var i=0; i<word.length; i++)
  {
    var img = "";
    switch (word.charAt(i))
    {
      case "│" : img = "L4"; break;
      case "└" : img = "L2"; break;
      case "　" : img = "empty"; break;
      case "├" : img = "L1"; break;
      case "─" : img = "L3"; break;
      case "┌" : img = "L0"; break;
      //case "�" : img = "L4";break;
    }
    if(img!="")
      str += "<IMG align='absMiddle' src='"+ this.icons[img].src +"' height='20'>";
  }
  return str;
}


//将某个节点下的所有子节点转化成详细的<HTML>元素表达
//id 树的客户端节点 id
MzTreeView.prototype.buildNode = function(id)
{
  if(this.node[id].hasChild)
  {
    var tcn = this.node[id].childNodes, str = "";
    for (var i=0; i<tcn.length; i++)
      str += this.nodeToHTML(tcn[i], i==tcn.length-1);
    var temp = this.getElementById(this.name +"_tree_"+ id).childNodes;
    temp[temp.length-1].innerHTML = str;
  }
};

//聚集到客户端生成的某个节点上
//id  客户端树节点的id
MzTreeView.prototype.focusClientNode      = function(id)
{
  if(!this.currentNode) this.currentNode=this.node["0"];

  var a = this.getElementById(this.name +"_link_"+ id); if(a){ a.focus();
  var link = this.getElementById(this.name +"_link_"+ this.currentNode.id);
  if(link)with(link.style){color="";   backgroundColor="";}
  with(a.style){color = this.colors.highLightText;
  backgroundColor = this.colors.highLight;}
  this.currentNode= this.node[id];}
};

//焦点聚集到树里的节点链接时的处理
//id 客户端节点 id
MzTreeView.prototype.focusLink= function(id)
{
  if(this.currentNode && this.currentNode.id==id) return;
  this.focusClientNode(id);
};

//点击展开树节点的对应方法
MzTreeView.prototype.expand   = function(id, sureExpand)
{
  if(id=="1")
  {
  sureExpand=true;
  }
  var node  = this.node[id];
  if (sureExpand && node.isExpand) return;
  if (!node.hasChild) return;
  var area  = this.getElementById(this.name +"_tree_"+ id);
  if (area)   area = area.childNodes[area.childNodes.length-1];
  if (area)
  {
    var icon  = this.icons[node.icon];
    var iconE = this.iconsExpand[node.icon];
    var Bool  = node.isExpand = sureExpand || area.style.display == "none";
    var img   = this.getElementById(this.name +"_icon_"+ id);
    if (img)  img.src = !Bool ? icon.src :typeof(iconE)=="undefined" ? icon.src : iconE.src;
    var exp   = this.icons[node.iconExpand];
    var expE  = this.iconsExpand[node.iconExpand];
    var expand= this.getElementById(this.name +"_expand_"+ id);
    if (expand)
    {
      if(this.wordLine) expand.innerHTML = !Bool ? "+"  : "-";
      else expand.src = !Bool ? exp.src : typeof(expE) =="undefined" ? exp.src  : expE.src;
    }
    if(!Bool && this.currentNode.path.indexOf(node.path)==0 && this.currentNode.id!=id)
    {
      try{this.getElementById(this.name +"_link_"+ id).click();}
      catch(e){this.focusClientNode(id);}
    }
    area.style.display = !Bool ? "none" : "block";//(this.navigator=="netscape" ? "block" : "");
    if(!node.isLoad)
    {
      this.load(id);
      if(node.id=="0") return;

      //当子节点过多时, 给用户一个正在加载的提示语句
      if(node.hasChild && node.childNodes.length>200)
      {
        setTimeout(this.name +".buildNode('"+ id +"')", 1);
        var temp = this.getElementById(this.name +"_tree_"+ id).childNodes;
        temp[temp.length-1].innerHTML = "<DIV noWrap><NOBR><SPAN>"+ (this.wordLine ?
        node.childAppend +"└" : this.word2image(node.childAppend +"└")) +"</SPAN>"+
        "<IMG border='0' height='16' align='absmiddle' src='"+this.icons["file"].src+"'>"+
        "<A style='background-Color: "+ this.colors.highLight +"; color: "+
        this.colors.highLightText +"; font-size: 9pt'>请稍候...</A></NOBR></DIV>";
      }
      else this.buildNode(id);
    }
  }
};

//节点链接单击事件处理方法
//id 客户端树节点的 id
MzTreeView.prototype.nodeClick = function(id)
{

  var source = this.nodes[this.node[id].sourceIndex];
  eval(this.getAttribute(source, "method"));
  return !(!this.getAttribute(source, "url") && this.url=="#");
};

//为配合系统初始聚集某节点而写的函数, 得到某节点在数据源里的路径
//sourceId 数据源里的节点 id
MzTreeView.prototype.getPath= function(sourceId)
{
  
Array.prototype.indexOf = function(item)
  {
    for(var i=0; i<this.length; i++)
    {
      if(this[i]==item) return i;
    }
    return -1;
  };
  var _d = this._d, d = this.divider;
  var A = new Array(), id=sourceId; A[0] = id;
  while(id!="0" && id!="")
  {
    var str = "(^|"+_d+")([^"+_d+d+"]+"+d+ id +")("+_d+"|$)";
    if (new RegExp(str).test(this.names))
    {
      id = RegExp.$2.substring(0, RegExp.$2.indexOf(d));
      if(A.indexOf(id)>-1) break;
      A[A.length] = id;
    }
    else break;
  }
  return A.reverse();
};

//在源代码里指定 MzTreeView 初始聚集到某个节点
//sourceId 节点在数据源里的 id
MzTreeView.prototype.focus = function(sourceId, defer)
{
  if (!defer)
  {
    setTimeout(this.name +".focus('"+ sourceId +"', true)", 100);
    return;
  }
  var path = this.getPath(sourceId);
  if(path[0]!="0")
  {
    alert("节点 "+ sourceId +" 没有正确的挂靠有效树节点上！\r\n"+
      "节点 id 序列 = "+ path.join(this.divider));
    return;
  }
  var root = this.node["0"], len = path.length;
  for(var i=1; i<len; i++)
  {
    if(root.hasChild)
    {
      var sourceIndex= path[i-1] + this.divider + path[i];
      for (var k=0; k<root.childNodes.length; k++)
      {
        if (root.childNodes[k].sourceIndex == sourceIndex)
        {
          root = root.childNodes[k];
          if(i<len - 1) this.expand(root.id, true);
          else this.focusClientNode(root.id);
          break;
        }
      }
    }
  }
};

//树的单击事件处理函数
MzTreeView.prototype.clickHandle = function(e)
{
  e = window.event || e; e = e.srcElement || e.target;
  //alert(e.tagName)
  switch(e.tagName)
  {
    case "IMG" :
      if(e.id)
      {
        if(e.id.indexOf(this.name +"_icon_")==0)
          this.focusClientNode(e.id.substr(e.id.lastIndexOf("_") + 1));
        else if (e.id.indexOf(this.name +"_expand_")==0)
          this.expand(e.id.substr(e.id.lastIndexOf("_") + 1));
      }
      break;
    case "A" :
      if(e.id)   
      {   
          this.focusClientNode(e.id.substr(e.id.lastIndexOf("_")   +   1));   
          var   id   =   e.id.substr(e.id.lastIndexOf("_")   +   1);   
          if(this.node[id].hasChild)   this.expand(id);   
      }   
      break;
    case "SPAN" :
      if(e.className=="pm")
        this.expand(e.id.substr(e.id.lastIndexOf("_") + 1));
      break;
    default :
      if(this.navigator=="netscape") e = e.parentNode;
      if(e.tagName=="SPAN" && e.className=="pm")
        this.expand(e.id.substr(e.id.lastIndexOf("_") + 1));
      break;
  }
};

//MzTreeView 双击事件的处理函数
MzTreeView.prototype.dblClickHandle = function(e)
{
  e = window.event || e; e = e.srcElement || e.target;
  if((e.tagName=="A" || e.tagName=="IMG")&& e.id)
  {
    var id = e.id.substr(e.id.lastIndexOf("_") + 1);
    if(this.node[id].hasChild) this.expand(id);
  }
};

//回到树当前节点的父层节点
MzTreeView.prototype.upperNode = function()
{
  if(!this.currentNode) return;
  if(this.currentNode.id=="0" || this.currentNode.parentId=="0") return;
  if (this.currentNode.hasChild && this.currentNode.isExpand)
    this.expand(this.currentNode.id, false);
  else this.focusClientNode(this.currentNode.parentId);
};

//展开当前节点并
MzTreeView.prototype.lowerNode = function()
{
  if (!this.currentNode) this.currentNode = this.node["0"];
  if (this.currentNode.hasChild)
  {
    if (this.currentNode.isExpand)
      this.focusClientNode(this.currentNode.childNodes[0].id);
    else this.expand(this.currentNode.id, true);
  }
}

//聚集到树当前节点的上一节点
MzTreeView.prototype.pervNode = function()
{
  if(!this.currentNode) return; var e = this.currentNode;
  if(e.id=="0") return; var a = this.node[e.parentId].childNodes;
  for(var i=0; i<a.length; i++){if(a[i].id==e.id){if(i>0){e=a[i-1];
  while(e.hasChild){this.expand(e.id, true);
  e = e.childNodes[e.childNodes.length - 1];}
  this.focusClientNode(e.id); return;} else {
  this.focusClientNode(e.parentId); return;}}}
};

//聚集到树当前节点的下一节点
MzTreeView.prototype.nextNode = function()
{
  var e = this.currentNode; if(!e) e = this.node["0"];
  if (e.hasChild){this.expand(e.id, true);
  this.focusClientNode(e.childNodes[0].id); return;}
  while(typeof(e.parentId)!="undefined"){
  var a = this.node[e.parentId].childNodes;
  for(var i=0; i<a.length; i++){ if(a[i].id==e.id){
  if(i<a.length-1){this.focusClientNode(a[i+1].id); return;}
  else e = this.node[e.parentId];}}}
};

//展开树的所有节点
MzTreeView.prototype.expandAll = function()
{
  if(this.totalNode>500) if(
    confirm("您是否要停止展开全部节点？\r\n\r\n节点过多！展开很耗时")) return;
  if(this.node["0"].childNodes.length==0) return;
  var e = this.node["0"].childNodes[0];
  var isdo = t = false;
  while(e.id != "0")
  {
    var p = this.node[e.parentId].childNodes, pn = p.length;
    if(p[pn-1].id==e.id && (isdo || !e.hasChild)){e=this.node[e.parentId]; isdo = true;}
    else
    {
      if(e.hasChild && !isdo)
      {
        this.expand(e.id, true), t = false;
        for(var i=0; i<e.childNodes.length; i++)
        {
          if(e.childNodes[i].hasChild){e = e.childNodes[i]; t = true; break;}
        }
        if(!t) isdo = true;
      }
      else
      {
        isdo = false;
        for(var i=0; i<pn; i++)
        {
          if(p[i].id==e.id) {e = p[i+1]; break;}
        }
      }
    }
  }
};

//本树将要用动的图片的字义及预载函数
//path 图片存放的路径名
MzTreeView.prototype.setIconPath  = function(path)
{
  var k = 0, d = new Date().getTime();
  for(var i in this.icons)
  {
    var tmp = this.icons[i];
    this.icons[i] = new Image();
    this.icons[i].src = path + tmp;
   // if(k==9 && (new Date().getTime()-d)>20)
     // this.wordLine = true; k++;
  }
  for(var i in this.iconsExpand)
  {
    var tmp = this.iconsExpand[i];
    this.iconsExpand[i]=new Image();
    this.iconsExpand[i].src = path + tmp;
  }
};

//设置树的默认链接
//url 默认链接  若不设置, 其初始值为 #
MzTreeView.prototype.setURL     = function(url){this.url = url;};

//设置树的默认的目标框架名 target
//target 目标框架名  若不设置, 其初始值为 _self
MzTreeView.prototype.setTarget  = function(target){this.target = target;};
// --></script>
 
<style> 
 
 
    <style type="text/css">
/* 全局样式 */
 
body,ul,ol,li,p,h1,h2,h3,h4,h5,h6,form,fieldset,table,td,img,div{margin:0;padding:0;border:0;}
body{font-size:12px; margin-top:5px;font-family:"宋体";}
 
ul,ol{list-style-type:none;}
select,input,img,select{vertical-align:middle;}
 
 
.clearit{clear:both;}
 
/* page */
#page{width:950px; overflow: visible; _display:inline-block; margin:0 auto;}
 
/* 顶部 top */
.top{position:relative; z-index:99; padding:1px; border:1px #fdd26c solid; border-bottom:1px #e1a841 solid; color:#000;}
.top a,.top a:visited{color:#000; text-decoration:none;}
.top a:hover,.top a:active{color:#000; text-decoration:underline;}
 
body { margin: 0px 0px 0px 0px; padding: 0px; font-family: "宋体,Sans-Serif"; font-size: 13px; font-weight: normal; }
a:link { color: #003278; text-decoration: none; }
a:visited { color: #003278; text-decoration: none; }
a:hover { color: #2a9c2c; text-decoration: underline; }
a:active { color: #003278; text-decoration: none; }
ul { padding: 0; margin: 5 0 0 20px; }
.Closed ul { display: none; }
</style>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"></head>
<body style="background:#fff">
    <div style="width: 100%; height: 100%; overflow: auto; ">
        <form name="form1" method="post" action="leftmenu1.aspx" id="form1">
<div>
<input type="hidden" name="__VIEWSTATE" id="__VIEWSTATE" value="/wEPDwUJOTU4MjMyMzI1ZGT9cBPWKWYSfm0Mh1Y6PG7P/dbFIw==" />
</div>
 
 
            <div id="treeviewtop" style="margin-left:20px; margin-top:5px;">
<script language="JavaScript">
         
          var tree = new MzTreeView("tree");
tree.icons["property"] = "property.gif";
 tree.icons["css"] = "collection.gif";
   tree.icons["book"]   = "book.gif";
   tree.iconsExpand["book"] = "bookopen.gif"; //展开时对应的图片
 
  tree.setIconPath("images/treeimage/"); //可用相对路径
tree.nodes['-1_0'] = "text:首页;url:mainbody.aspx; target:table_index;data:id=0";
 tree.nodes["302_13"]   =   "text:培训管理;hint:;icon:;target:table_index;data:1"; tree.nodes["2_14"]   =   "text:人事审批;hint:;icon:;target:table_index;data:2"; tree.nodes["2_15"]   =   "text:岗位管理;hint:;icon:;target:table_index;data:3"; tree.nodes["2_16"]   =   "text:管理人员竞聘;hint:;icon:;target:table_index;data:4"; tree.nodes["2_17"]   =   "text:月末考评;hint:;icon:;target:table_index;data:5"; tree.nodes["2_18"]   =   "text:人事基础;hint:;icon:;target:table_index;data:6"; tree.nodes["3_19"]   =   "text:财务办公;hint:;icon:;target:table_index;data:7"; tree.nodes["3_20"]   =   "text:工资管理;hint:;icon:;target:table_index;data:8"; tree.nodes["3_21"]   =   "text:财务审批;hint:;icon:;target:table_index;data:9"; tree.nodes["238_24"]   =   "text:营销奖励;hint:;icon:;target:table_index;url:Lj_OA/Lj_DownFile.asp;data:10"; tree.nodes["7_32"]   =   "text:查看文件;hint:;icon:;target:table_index;url:Lj_OA/Lj_DownFile.asp;data:11"; tree.nodes["7_33"]   =   "text:上传文件;hint:;icon:;target:table_index;url:Lj_OA/Lj_DownFileEdit.asp;data:12"; tree.nodes["8_34"]   =   "text:晨会查看;hint:;icon:;target:table_index;url:oa/oa_ch_look.aspx;data:13"; tree.nodes["8_35"]   =   "text:晨会管理;hint:;icon:;target:table_index;url:oa/oa_ch_manage.aspx;data:14"; tree.nodes["9_36"]   =   "text:学习交流;hint:;icon:;target:table_index;url:oa/oa_lt_forums.aspx?flag=1;data:15"; tree.nodes["9_37"]   =   "text:栏目管理;hint:;icon:;target:table_index;url:oa/oa_lt_manage.aspx;data:16"; tree.nodes["10_38"]   =   "text:会议通知;hint:;icon:;target:table_index;url:oa/oa_Meeting.aspx;data:17"; tree.nodes["10_39"]   =   "text:重要请示;hint:;icon:;target:table_index;url:oa/oa_importantRequest.aspx;data:18"; tree.nodes["10_40"]   =   "text:管理作业;hint:;icon:;target:table_index;url:oa/default.aspx;data:19"; tree.nodes["10_41"]   =   "text:月计划汇报;hint:;icon:;target:table_index;url:oa/oa_MonthPlan.aspx;data:20"; tree.nodes["207_26"]   =   "text:客户联络进展;hint:;icon:;target:table_index;url:shic/sc_CustomMain.aspx;data:21"; tree.nodes["212_27"]   =   "text:工作日志;hint:;icon:;target:table_index;url:shic/sc_EveryDayReport.aspx;data:22"; tree.nodes["212_28"]   =   "text:日志审核;hint:;icon:;target:table_index;url:shic/EveryDayReportView.aspx;data:23"; tree.nodes["13_73"]   =   "text:培训安排;hint:;icon:;target:table_index;url:hr/hr_PeiXunPlan.aspx;data:24"; tree.nodes["14_80"]   =   "text:岗位调动;hint:;icon:;target:table_index;url:hr/hr_Manoeuvre.aspx;data:25"; tree.nodes["14_81"]   =   "text:劝退申请;hint:;icon:;target:table_index;url:hr/hr_Persuade.aspx;data:26"; tree.nodes["14_82"]   =   "text:离职申请;hint:;icon:;target:table_index;url:hr/hr_Dimission.aspx;data:27"; tree.nodes["14_83"]   =   "text:员工奖惩;hint:;icon:;target:table_index;url:hr/hr_jiangcheng.aspx?page=jiangcheng;data:28"; tree.nodes["14_84"]   =   "text:薪酬调整;hint:;icon:;target:table_index;url:hr/SalaryChange.aspx;data:29"; tree.nodes["14_85"]   =   "text:员工转正;hint:;icon:;target:table_index;url:hr/hr_NewPositive.aspx;data:30"; tree.nodes["14_86"]   =   "text:人事增减;hint:;icon:;target:table_index;url:hr/hr_PersonChange.aspx;data:31"; tree.nodes["14_87"]   =   "text:自我调整;hint:;icon:;target:table_index;url:hr/hr_RelieveGuard.aspx;data:32"; tree.nodes["14_88"]   =   "text:员工请假;hint:;icon:;target:table_index;url:hr/hr_MemberLeave.aspx;data:33"; tree.nodes["14_89"]   =   "text:合同续签;hint:;icon:;target:table_index;url:hr/hr_WorkContract.aspx;data:34"; tree.nodes["14_90"]   =   "text:创新奖励;hint:;icon:;target:table_index;url:hr/hr_Bounty.aspx;data:35"; tree.nodes["15_91"]   =   "text:空缺岗位;hint:;icon:;target:table_index;url:hr/jl_list.aspx;data:36"; tree.nodes["15_92"]   =   "text:发布岗位;hint:;icon:;target:table_index;url:hr/hr_ZhiWeiList.aspx;data:37"; tree.nodes["15_93"]   =   "text:岗位查看;hint:;icon:;target:table_index;url:hr/hr_duty.aspx;data:38"; tree.nodes["16_95"]   =   "text:申请职位;hint:;icon:;target:table_index;url:hr/IndexShow.aspx;data:39"; tree.nodes["16_96"]   =   "text:竟聘审批;hint:;icon:;target:table_index;url:hr/jl_shenpi.aspx;data:40"; tree.nodes["17_97"]   =   "text:管理考评;hint:;icon:;target:table_index;url:hr/hr_ExamInfo.aspx;data:41"; tree.nodes["17_98"]   =   "text:利润考评;hint:;icon:;target:table_index;url:shic/sc_Examineeditor.aspx;data:42"; tree.nodes["17_99"]   =   "text:量化考评;hint:;icon:;target:table_index;url:hr/hr_Examineheadquarters.aspx;data:43"; tree.nodes["17_100"]   =   "text:目标考评;hint:;icon:;target:table_index;url:hr/hr_Examinestorage.aspx;data:44"; tree.nodes["17_101"]   =   "text:考评统计;hint:;icon:;target:table_index;url:hr/ExamTongJi.aspx;data:45"; tree.nodes["18_102"]   =   "text:人事信息;hint:;icon:;target:table_index;url:Lj_Hr/Lj_Hr_Renshi.Asp"; tree.nodes["18_103"]   =   "text:学历管理;hint:;icon:;target:table_index;url:Lj_Hr/Lj_Hr_Xueli.Asp"; tree.nodes["18_104"]   =   "text:证件管理;hint:;icon:;target:table_index;url:Lj_Hr/Lj_Hr_ZhengJian.Asp"; tree.nodes["18_105"]   =   "text:讲师库;hint:;icon:;target:table_index;url:hr/hr_Teacher.aspx;data:49"; tree.nodes["21_127"]   =   "text:日常借支;hint:;icon:;target:table_index;url:caiwu2/cw_DueBill.aspx;data:50"; tree.nodes["21_128"]   =   "text:运费借支;hint:;icon:;target:table_index;url:caiwu2/cw_yunfei.aspx;data:51"; tree.nodes["21_129"]   =   "text:编目借支;hint:;icon:;target:table_index;url:caiwu2/cw_BianMu.aspx;data:52"; tree.nodes["238_130"]   =   "text:三工转换申请;hint:;icon:;target:table_index;url:shic/sc_Apply.aspx;data:53"; tree.nodes["231_75"]   =   "text:教材管理;hint:;icon:;target:table_index;url:hr/hr_TeachingList.aspx;data:54"; tree.nodes["232_76"]   =   "text:试题管理;hint:;icon:;target:table_index;url:hr/hr_OnlineTester.aspx?pg=0;data:55"; tree.nodes["307_138"]   =   "text:考试详情;hint:;icon:;target:table_index;url:hr/hr_OnlineCheck.aspx;data:56"; tree.nodes["18_144"]   =   "text:人员调动;hint:;icon:;target:table_index;url:hr/hr_DiaoDongPeople.aspx;data:57"; tree.nodes["18_158"]   =   "text:薪资调整;hint:;icon:;target:table_index;url:hr/hr_SalaryChang.aspx;data:58"; tree.nodes["232_159"]   =   "text:题库管理;hint:;icon:;target:table_index;url:hr/ExamMatter.aspx;data:59"; tree.nodes["14_162"]   =   "text:年度工作总结;hint:;icon:;target:table_index;url:hr/hr_ReportofYear.aspx;data:60"; tree.nodes["307_166"]   =   "text:模拟考试;hint:;icon:;target:table_index;url:hr/hr_OnlineModel.aspx;data:61"; tree.nodes["207_169"]   =   "text:客户调配显示;hint:;icon:;target:table_index;url:shic/sc_CustomChangeShow.aspx;data:62"; tree.nodes["183_184"]   =   "text:出库管理;hint:;icon:;target:table_index;url:outer/ou_ShuziOut.aspx;data:63"; tree.nodes["18_188"]   =   "text:人事合同;hint:;icon:;target:table_index;url:hr/hr_compact.aspx;data:64"; tree.nodes["207_168"]   =   "text:客户转让申请;hint:;icon:;target:table_index;url:shic/sc_CustomZhuanRang.aspx;data:65"; tree.nodes["18_167"]   =   "text:部门管理;hint:;icon:;target:table_index;url:hr/hr_BumenInfo.aspx;data:66"; tree.nodes["238_199"]   =   "text:客户新需求申报;hint:;icon:;target:table_index;url:shic/sc_RequireMent.aspx;data:67"; tree.nodes["302_231"]   =   "text:教材库;hint:;icon:;target:table_index;url:;data:68"; tree.nodes["2_252"]   =   "text:招聘管理;hint:;icon:;target:table_index;url:;data:69"; tree.nodes["21_325"]   =   "text:接待费申请;hint:;icon:;target:table_index;url:caiwu2/cw_JieDai.aspx;data:70"; tree.nodes["30_201"]   =   "text:个人资产;hint:;icon:;target:table_index;url:oa/oa_computerInfos.aspx;data:71"; tree.nodes["21_324"]   =   "text:开票申请;hint:;icon:;target:table_index;url:caiwu2/cw_Invoice.aspx;data:72"; tree.nodes["14_256"]   =   "text:代表上岗申请;hint:;icon:;target:table_index;url:hr/hr_applyjobshow.aspx;data:73"; tree.nodes["14_259"]   =   "text:变更区域申请;hint:;icon:;target:table_index;url:hr/hr_areachangeshow.aspx;data:74"; tree.nodes["4_260"]   =   "text:本家书管理;hint:;icon:;target:no;url:;data:75"; tree.nodes["260_262"]   =   "text:图书管理;hint:;icon:;target:table_index;url:lzj_yanfa/lzj_book_manage.aspx;data:76"; tree.nodes["260_264"]   =   "text:出版社管理;hint:;icon:;target:table_index;url:lzj_yanfa/lzj_press_list.aspx;data:77"; tree.nodes["211_266"]   =   "text:访前检查;hint:;icon:;target:table_index;url:shic/sc_beforeVisiting.aspx;data:78"; tree.nodes["211_267"]   =   "text:访前检查统计;hint:;icon:;target:table_index;url:shic/sc_beforeVisitingTongji.aspx;data:79"; tree.nodes["183_278"]   =   "text:稿费发放明细;hint:;icon:;target:table_index;url:outer/ou_gaofeiFafang.aspx;data:80"; tree.nodes["183_272"]   =   "text:稿费申请;hint:;icon:;target:table_index;url:outer/ou_gaofei.aspx;data:81"; tree.nodes["2_302"]   =   "text:培训中心;hint:;icon:;target:table_index;url:;data:82"; tree.nodes["252_306"]   =   "text:人才储备库;hint:;icon:;target:table_index;url:hr/hr_reservePeopleByself.aspx;data:83"; tree.nodes["302_307"]   =   "text:个人培训;hint:;icon:;target:table_index;url:;data:84"; tree.nodes["3_312"]   =   "text:财务应收;hint:;icon:;target:table_index;url:;data:85"; tree.nodes["11_327"]   =   "text:调休申请;hint:;icon:;target:table_index;url:oa/oa_rest.aspx;data:86"; tree.nodes["21_346"]   =   "text:点卡销售情况;hint:;icon:;target:table_index;url:caiwu2/cw_DianKa.aspx;data:87"; tree.nodes["233_225"]   =   "text:教师评分;hint:;icon:;target:table_index;url:hr/hr_TeacherCommentScore.aspx;data:88"; tree.nodes["302_232"]   =   "text:考试管理;hint:;icon:;target:table_index;url:;data:89"; tree.nodes["302_233"]   =   "text:讲师评分系统;hint:;icon:;target:table_index;url:;data:90"; tree.nodes["307_308"]   =   "text:教材收藏;hint:;icon:;target:table_index;url:hr/hr_TeachingSelf.aspx;data:91"; tree.nodes["211_245"]   =   "text:市场知识管理;hint:;icon:;target:table_index;url:oa/oa_BumenKnowledgeClass.aspx?object=shic;data:92"; tree.nodes["12_49"]   =   "text:出勤管理;hint:;icon:;target:table_index;url:oa/oa_ChuQinRight.aspx;data:93"; tree.nodes["11_42"]   =   "text:配备申请;hint:;icon:;target:table_index;url:oa/oa_StockPlan.aspx;data:94"; tree.nodes["0_1"]   =   "text:办公系统;hint:;icon:;target:table_index;data:95"; tree.nodes["1_7"]   =   "text:文件管理;hint:;icon:;target:table_index;data:96"; tree.nodes["312_106"]   =   "text:回款管理;hint:;icon:;target:table_index;url:caiwu2/cw_HuiKuan.aspx;data:97"; tree.nodes["30_134"]   =   "text:修改密码;hint:;icon:;target:table_index;url:tools/tl_center.aspx?type=0;data:98"; tree.nodes["30_135"]   =   "text:万年历;hint:;icon:;target:table_index;url:tools/tl_center.aspx?type=1;data:99"; tree.nodes["20_110"]   =   "text:工资管理明细;hint:;icon:;target:table_index;url:caiwu2/cw_LzjPay.aspx;data:100"; tree.nodes["4_211"]   =   "text:市场工作;hint:;icon:;target:table_index;url:;data:101"; tree.nodes["211_230"]   =   "text:营销知识管理;hint:;icon:;target:table_index;url:shic/sc_MarketBigclass.aspx;data:102"; tree.nodes["30_190"]   =   "text:个人信息;hint:;icon:;target:table_index;url:tools/tl_HrInfo.aspx?flag=one;data:103"; tree.nodes["312_180"]   =   "text:财务合同;hint:;icon:;target:table_index;url:caiwu2/cw_CaiwuContract.aspx;data:104"; tree.nodes["4_238"]   =   "text:市场审批;hint:;icon:;target:table_index;url:;data:105"; tree.nodes["21_117"]   =   "text:订货合同申请;hint:;icon:;target:table_index;url:caiwu2/cw_Compact.aspx;data:106"; tree.nodes["20_64"]   =   "text:话费扣款;hint:;icon:;target:table_index;url:oa/oa_HuaFei_KouKuan.aspx;data:107"; tree.nodes["12_51"]   =   "text:通讯录;hint:;icon:;target:table_index;url:oa/oa_AddressList.aspx;data:108"; tree.nodes["1_8"]   =   "text:晨会内容;hint:;icon:;target:table_index;data:109"; tree.nodes["0_2"]   =   "text:人事管理;hint:;icon:;target:table_index;data:110"; tree.nodes["11_43"]   =   "text:采购下单;hint:;icon:;target:table_index;url:oa/oa_Stock.aspx;data:111"; tree.nodes["11_44"]   =   "text:采购入库;hint:;icon:;target:table_index;url:oa/oa_In.aspx;data:112"; tree.nodes["12_50"]   =   "text:电子通讯录;hint:;icon:;target:table_index;url:oa/oa_AddressRight.aspx;data:113"; tree.nodes["0_3"]   =   "text:财务管理;hint:;icon:;target:table_index;data:114"; tree.nodes["1_9"]   =   "text:内部学习;hint:;icon:;target:table_index;data:115"; tree.nodes["20_65"]   =   "text:宿舍扣款;hint:;icon:;target:table_index;url:oa/oa_SusheKoukuan.aspx;data:116"; tree.nodes["21_118"]   =   "text:特殊事项申请;hint:;icon:;target:table_index;url:caiwu2/cw_Proceeding.aspx;data:117"; tree.nodes["19_140"]   =   "text:增值税票登记;hint:;icon:;target:table_index;url:caiwu2/cw_Taxreceipt.aspx;data:118"; tree.nodes["4_207"]   =   "text:客户资源管理;hint:;icon:;target:table_index;url:;data:119"; tree.nodes["30_182"]   =   "text:个人网盘;hint:;icon:;target:table_index;url:tools/tl_MyDocument.aspx;data:120"; tree.nodes["211_204"]   =   "text:产品管理;hint:;icon:;target:table_index;url:shic/sc_ApplyProduct.aspx;data:121"; tree.nodes["312_153"]   =   "text:财务出库查看;hint:;icon:;target:table_index;url:caiwu2/cw_Receivables.aspx;data:122"; tree.nodes["211_185"]   =   "text:在线调研;hint:;icon:;target:table_index;url:hr/hr_OnlineTester.aspx?pg=1;data:123"; tree.nodes["30_141"]   =   "text:个人工资查看;hint:;icon:;target:table_index;url:tools/tl_LzjPayOne_.aspx;data:124"; tree.nodes["20_66"]   =   "text:邮资扣款;hint:;icon:;target:table_index;url:oa/oa_YouZi_KouKuan.aspx;data:125"; tree.nodes["12_52"]   =   "text:外联查询;hint:;icon:;target:table_index;url:oa/oa_WaiLian.aspx;data:126"; tree.nodes["1_10"]   =   "text:工作计划;hint:;icon:;target:table_index;data:127"; tree.nodes["0_4"]   =   "text:市场管理;hint:;icon:;target:table_index;data:128"; tree.nodes["30_309"]   =   "text:个人报账明细;hint:;icon:;target:table_index;url:caiwu2/cw_baozhang_stateSelf.aspx;data:129"; tree.nodes["211_25"]   =   "text:营销奖励统计;hint:;icon:;target:table_index;url:shic/IncentiveBase.aspx?page=1;data:130"; tree.nodes["11_46"]   =   "text:物品借用申请;hint:;icon:;target:table_index;url:oa/oa_Borrow.aspx;data:131"; tree.nodes["12_53"]   =   "text:快递管理;hint:;icon:;target:table_index;url:oa/oa_Ems.aspx;data:132"; tree.nodes["20_67"]   =   "text:宿舍水电补助;hint:;icon:;target:table_index;url:hr/hr_ShuiDian.aspx;data:133"; tree.nodes["0_183"]   =   "text:教师网络资源中心;hint:;icon:;target:table_index;url:;data:134"; tree.nodes["1_212"]   =   "text:报岗管理;hint:;icon:;target:table_index;url:;data:135"; tree.nodes["11_48"]   =   "text:外住申请;hint:;icon:;target:table_index;url:oa/oa_WaiZhu.aspx;data:136"; tree.nodes["211_131"]   =   "text:转换统计;hint:;icon:;target:table_index;url:shic/sc_ApplyShow.aspx;data:137"; tree.nodes["20_68"]   =   "text:外住补助;hint:;icon:;target:table_index;url:oa/oa_WaiZhu_buzhu.aspx;data:138"; tree.nodes["12_54"]   =   "text:铁路快件;hint:;icon:;target:table_index;url:oa/oa_RailageList.aspx;data:139"; tree.nodes["1_11"]   =   "text:办公审批;hint:;icon:;target:table_index;data:140"; tree.nodes["1_12"]   =   "text:内部办公;hint:;icon:;target:table_index;data:141"; tree.nodes["0_30"]   =   "text:个人管理;hint:;icon:;target:table_index;data:142"; tree.nodes["11_45"]   =   "text:手机卡座机申请;hint:;icon:;target:table_index;url:oa/oa_TongXun.aspx;data:143"; tree.nodes["12_55"]   =   "text:派车管理;hint:;icon:;target:table_index;url:oa/oa_Car.aspx;data:144"; tree.nodes["20_107"]   =   "text:礼品书扣款;hint:;icon:;target:table_index;url:caiwu2/cw_LiPinshu.aspx;data:145"; tree.nodes["21_122"]   =   "text:办公用品报销;hint:;icon:;target:table_index;url:caiwu2/cw_ Baoxiao.aspx;data:146"; tree.nodes["211_239"]   =   "text:业务指导跟踪表;hint:;icon:;target:table_index;url:shic/sc_GuideWork.aspx;data:147"; tree.nodes["211_240"]   =   "text:业务指导统计;hint:;icon:;target:table_index;url:shic/sc_GuideWorkTongji.aspx;data:148"; tree.nodes["20_111"]   =   "text:其他补助;hint:;icon:;target:table_index;url:caiwu2/cw_other.aspx?page=other;data:149"; tree.nodes["12_56"]   =   "text:手机信息管理;hint:;icon:;target:table_index;url:oa/oa_ShouJiRight.aspx;data:150"; tree.nodes["11_47"]   =   "text:礼品书订货申请;hint:;icon:;target:table_index;url:oa/oa_Order.aspx;data:151"; tree.nodes["30_236"]   =   "text:个人应收款;hint:;icon:;target:table_index;url:tools/tl_CaiwucontractSelf.aspx;data:152"; tree.nodes["30_271"]   =   "text:个人记事本;hint:;icon:;target:table_index;url:tools/tl_notebookList.aspx;data:153"; tree.nodes["0_6"]   =   "text:内部论坛;hint:;icon:;target:table_index;url:BBS/Default.aspx;data:154"; tree.nodes["12_57"]   =   "text:手机信息变动;hint:;icon:;target:table_index;url:oa/oa_Telephone.aspx?page=shouji;data:155"; tree.nodes["20_112"]   =   "text:借支扣款;hint:;icon:;target:table_index;url:caiwu2/cw_other.aspx?page=jiezhi;data:156"; tree.nodes["21_124"]   =   "text:招标保证金申请;hint:;icon:;target:table_index;url:caiwu2/cw_ReCogniZance.aspx;data:157"; tree.nodes["30_202"]   =   "text:个人登陆统计;hint:;icon:;target:table_index;url:tools/tl_PeopleOneSelf.aspx;data:158"; tree.nodes["30_142"]   =   "text:个人出勤查看;hint:;icon:;target:table_index;url:tools/tl_People_ForWork.aspx;data:159"; tree.nodes["30_181"]   =   "text:业务回款查看;hint:;icon:;target:table_index;url:tools/tl_HuiKuanSelf.aspx;data:160"; tree.nodes["21_125"]   =   "text:招投标服务费申请;hint:;icon:;target:table_index;url:caiwu2/cw_ZhongBiaoList.aspx;data:161"; tree.nodes["20_113"]   =   "text:文件奖罚;hint:;icon:;target:table_index;url:caiwu2/cw_other.aspx?page=penalty;data:162"; tree.nodes["30_155"]   =   "text:账务公开查看;hint:;icon:;target:table_index;url:tools\tl_BalanceLook.aspx;data:163"; tree.nodes["30_139"]   =   "text:日记账表管理;hint:;icon:;target:table_index;url:tools/tl_Balance.aspx;data:164"; tree.nodes["12_71"]   =   "text:手机费用报帐;hint:;icon:;target:table_index;url:oa/oa_Mobile.aspx;data:165"; tree.nodes["0_220"]   =   "text:中心平台;hint:;icon:;target:table_index;url:Branchs/Index.aspx;data:166"; tree.nodes["0_223"]   =   "text:产品知识库;hint:;icon:;target:table_index;url:Product/ProductMain.aspx;data:167"; tree.nodes["12_58"]   =   "text:座机信息管理;hint:;icon:;target:table_index;url:oa/oa_ZuoJiRight.aspx;data:168"; tree.nodes["20_114"]   =   "text:授课费用;hint:;icon:;target:table_index;url:caiwu2/cw_other.aspx?page=schoolteaching;data:169"; tree.nodes["21_126"]   =   "text:货款保证金退返申请;hint:;icon:;target:table_index;url:caiwu2/cw_ReturnMent.aspx;data:170"; tree.nodes["30_136"]   =   "text:邮件快递查询;hint:;icon:;target:table_index;url:tools/tl_center.aspx?type=2;data:171"; tree.nodes["30_137"]   =   "text:邮编区号查询;hint:;icon:;target:table_index;url:tools/tl_center.aspx?type=3;data:172"; tree.nodes["19_192"]   =   "text:中心库存查看;hint:;icon:;target:table_index;url:caiwu2/cw_Storage.aspx;data:173"; tree.nodes["20_154"]   =   "text:提成奖金管理;hint:;icon:;target:table_index;url:caiwu2/cw_TiCheng.aspx;data:174"; tree.nodes["21_177"]   =   "text:编目保证金申请;hint:;icon:;target:table_index;url:caiwu2/cw_BianMuApply.aspx;data:175"; tree.nodes["12_59"]   =   "text:座机信息变动;hint:;icon:;target:table_index;url:oa/oa_TelephotoZouji.aspx?page=zuoji;data:176"; tree.nodes["0_237"]   =   "text:营销知识库;hint:;icon:;target:table_index;url:shic/sc_Market.aspx;data:177"; tree.nodes["0_300"]   =   "text:岗位知识库;hint:;icon:;target:table_index;url:shic/sc_Position.aspx;data:178"; tree.nodes["12_72"]   =   "text:座机费用报账;hint:;icon:;target:table_index;url:oa/oa_Tel.aspx;data:179"; tree.nodes["20_157"]   =   "text:计件工资管理;hint:;icon:;target:table_index;url:caiwu2/cw_JiJian.aspx?page=jijian;data:180"; tree.nodes["30_160"]   =   "text:部门工资查看;hint:;icon:;target:table_index;url:tools/tl_LzjPayBumen.aspx;data:181"; tree.nodes["30_165"]   =   "text:已读信息;hint:;icon:;target:table_index;url:tools/tl_MsgRead.aspx;data:182"; tree.nodes["21_151"]   =   "text:销售主管年终奖申请;hint:;icon:;target:table_index;url:caiwu2/cw_DecemberManager.aspx;data:183"; tree.nodes["20_152"]   =   "text:任务保证金管理;hint:;icon:;target:table_index;url:caiwu2/cw_TastDeposit.aspx;data:184"; tree.nodes["0_74"]   =   "text:培训教材库;hint:;icon:;target:table_index;url:hr/hr_TeachingClass.aspx;data:185"; tree.nodes["12_60"]   =   "text:宿舍管理;hint:;icon:;target:table_index;url:oa/oa_Domicile.aspx;data:186"; tree.nodes["12_61"]   =   "text:宿舍人员调动;hint:;icon:;target:table_index;url:oa/oa_Domicile_People.aspx;data:187"; tree.nodes["20_149"]   =   "text:货款尾数管理;hint:;icon:;target:table_index;url:caiwu2/cw_Mantissa.aspx;data:188"; tree.nodes["21_150"]   =   "text:代表年终奖申请;hint:;icon:;target:table_index;url:caiwu2/cw_Decemberbonus.aspx;data:189"; tree.nodes["0_261"]   =   "text:服务中心oa;hint:;icon:;target:table_index;url:sys/sys_OaSystem.aspx;data:190"; tree.nodes["0_280"]   =   "text:企业邮箱;hint:;icon:;target:table_index;url:mail.aspx;data:191"; tree.nodes["20_147"]   =   "text:资金占用费管理;hint:;icon:;target:table_index;url:caiwu2/cw_CostofPossession.aspx;data:192"; tree.nodes["21_187"]   =   "text:日常报账;hint:;icon:;target:table_index;url:caiwu2/cw_baozhangEveryday.aspx;data:193"; tree.nodes["12_62"]   =   "text:外住登记;hint:;icon:;target:table_index;url:oa/oa_WaizhuTouch.aspx;data:194"; tree.nodes["12_69"]   =   "text:水电报账;hint:;icon:;target:table_index;url:hr/hr_Utilit.aspx;data:195"; tree.nodes["20_156"]   =   "text:营销费用管理;hint:;icon:;target:table_index;url:caiwu2/cw_Travelexpense.aspx?page=travelexpense;data:196"; tree.nodes["21_143"]   =   "text:减免事项申请;hint:;icon:;target:table_index;url:caiwu2/cw_Derate.aspx;data:197"; tree.nodes["12_70"]   =   "text:房租报账;hint:;icon:;target:table_index;url:hr/hr_Rent.aspx;data:198"; tree.nodes["20_108"]   =   "text:工资卡管理;hint:;icon:;target:table_index;url:caiwu2/cw_GongZiKa.aspx;data:199"; tree.nodes["12_164"]   =   "text:水票报帐;hint:;icon:;target:table_index;url:oa/oa_WaterTicketCollected.aspx;data:200"; tree.nodes["21_254"]   =   "text:营销费用申请;hint:;icon:;target:table_index;url:caiwu2/cw_marketingexpenses.aspx;data:201"; tree.nodes["21_288"]   =   "text:图书编辑费用申请;hint:;icon:;target:table_index;url:caiwu2/lzj_servepayment_list.aspx;data:202"; tree.nodes["12_161"]   =   "text:水票登记;hint:;icon:;target:table_index;url:oa/oa_WaterTicket.aspx;data:203"; tree.nodes["20_109"]   =   "text:集资款表单;hint:;icon:;target:table_index;url:caiwu2/cw_JiZi.aspx;data:204"; tree.nodes["12_63"]   =   "text:节假日管理;hint:;icon:;target:table_index;url:hr/hr_Holiday.aspx;data:205"; tree.nodes["12_163"]   =   "text:平台短信;hint:;icon:;target:table_index;url:oa/oa_Msg.aspx;data:206"; tree.nodes["12_195"]   =   "text:常用通讯录;hint:;icon:;target:table_index;url:PeopleTel.aspx;data:207"; tree.nodes["12_294"]   =   "text:来电处理;hint:;icon:;target:table_index;url:oa/oa_customPhone.aspx;data:208";
//          var str=Default2.aa().value;
//          var ar=str.split("~");
 
//         for(var i=0;i<ar.length-1;i++)
//         {
//            tree.nodes[ar[i].split("*")[0]] =ar[i].split("*")[1];
//         }  
 
 
         document.write(tree.toString());
          //下面这句代码就是一展开即聚焦到某一节点上的示例
 
         
         </script>
         </div>
        </form>
    </div>
</body>
</html>

