﻿<%
If request("BackUrl") =" " Then
    BackUrl = Trim(Request.ServerVariables("HTTP_REFERER"))
else
    BackUrl = Trim(request("BackUrl"))
End if

'**************************************************
'函数名：IsValIDEmail
'作  者：王国强
'作  用：检查Email地址合法性
'返回值：True  ----合法
'        False ----不合法
'**************************************************
Function IsValIDEmail(strng) 
	IsValIDEmail = false 
	dim regEx, Match 
	Set regEx = New RegExp 
	regEx.Pattern = "^\w+((-\w+)|(\.\w+))*\@[A-Za-z0-9]+((\.|-)[A-Za-z0-9]+)*\.[A-Za-z0-9]+$" 
	regEx.IgnoreCase = True 
	Set Match = regEx.Execute(strng) 
	if match.count Then IsValIDEmail= true 
End Function

'**************************************************
'函数名：IsValIDUserName
'作  者：王国强
'作  用：检查用户名的合法性
'返回值：True  ----合法
'        False ----不合法
'**************************************************
Function IsValIDUserName(strng) 
	IsValIDUserName = false 
	dim regEx, Match 
	Set regEx = New RegExp 
	regEx.Pattern = "^[a-zA-Z][a-zA-Z0-9_]{2,20}$" 
	regEx.IgnoreCase = True 
	Set Match = regEx.Execute(strng) 
	if match.count Then IsValIDUserName= true 
End Function

'**************************************************
'函数名：IsValIDPassword
'作  者：王国强
'作  用：检查密码的合法性
'返回值：True  ----合法
'        False ----不合法
'**************************************************
Function IsValIDPassword(strng) 
	IsValIDPassword = false 
	dim regEx, Match 
	Set regEx = New RegExp 
	regEx.Pattern = "^[a-zA-Z0-9_]{6,20}$" 
	regEx.IgnoreCase = True 
	Set Match = regEx.Execute(strng) 
	if match.count Then IsValIDPassword= true 
End Function

'**************************************************
'函数名：IsValIDURL
'作  者：王国强
'作  用：检查URL的合法性
'返回值：True  ----合法
'        False ----不合法
'**************************************************
Function IsValIDURL(strng) 
	IsValIDURL = false 
	dim regEx, Match 
	Set regEx = New RegExp 
	regEx.Pattern = "^http[s]?:\\/\\/([\\w-]+\\.)+[\\w-]+([\\w-./?%&=]*)?$" 
	regEx.IgnoreCase = True 
	Set Match = regEx.Execute(strng) 
	if match.count Then IsValIDURL= true 
End Function

'**************************************************
'函数名：IsValIDPhone
'作  者：王国强
'作  用：检查电话的合法性
'返回值：True  ----合法
'        False ----不合法
'**************************************************
Function IsValIDPhone(strng) 
	IsValIDPhone = false 
	dim regEx, Match 
	Set regEx = New RegExp 
	regEx.Pattern = "^((\(\d{3}\))|(\d{3}\-))?(\(0\d{2,3}\)|0\d{2,3}-)?[1-9]\d{6,7}$" 
	regEx.IgnoreCase = True 
	Set Match = regEx.Execute(strng) 
	if match.count Then IsValIDPhone= true 
End Function

'**************************************************
'函数名：IsValIDZip
'作  者：王国强
'作  用：检查邮政编码的合法性
'返回值：True  ----合法
'        False ----不合法
'**************************************************
Function IsValIDZip(strng) 
	IsValIDZip = false 
	dim regEx, Match 
	Set regEx = New RegExp 
	regEx.Pattern = "^\d{6}$" 
	regEx.IgnoreCase = True 
	Set Match = regEx.Execute(strng) 
	if match.count Then IsValIDZip= true 
End Function

'**************************************************
'函数名：IsValIDMobile
'作  者：王国强
'作  用：检查手机的合法性
'返回值：True  ----合法
'        False ----不合法
'**************************************************
Function IsValIDMobile(strng) 
	IsValIDMobile = false 
	dim regEx, Match 
	Set regEx = New RegExp 
	regEx.Pattern = "^(13[0-9]|15[0|3|6|7|8|9]|18[8|9])\d{8}$" 
	regEx.IgnoreCase = True 
	Set Match = regEx.Execute(strng) 
	if match.count Then IsValIDMobile= true 
End Function

'**************************************************
'函数名：IsValIDInteger
'作  者：王国强
'作  用：检查是否为正整数
'返回值：True  ----合法
'        False ----不合法
'**************************************************
Function IsValIDInteger(strng) 
	IsValIDInteger = false 
	dim regEx, Match 
	Set regEx = New RegExp 
	regEx.Pattern = "^[0-9]*[1-9][0-9]*$" 
	regEx.IgnoreCase = True 
	Set Match = regEx.Execute(strng) 
	if match.count Then IsValIDInteger= true 
End Function

'**************************************************
'函数名：IsValIDData
'作  者：王国强
'作  用：检查是否为日期0000-00-00
'返回值：True  ----合法
'        False ----不合法
'**************************************************
Function IsValIDData(strng) 
	IsValIDData = false 
	dim regEx, Match 
	Set regEx = New RegExp 
	regEx.Pattern = "^((19\d{2})|2\d{3})-((0\d{1})|(\d{1})|(1[0-2]{1}))-(([0-2]\d{1})|30|31)$" 
	regEx.IgnoreCase = True 
	Set Match = regEx.Execute(strng) 
	if match.count Then IsValIDData= true 
End Function

'**************************************************
'函数名：IsValIDPrice
'作  者：王国强
'作  用：价格的合法性
'返回值：True  ----合法
'        False ----不合法
'**************************************************
Function IsValIDPrice(strng) 
	IsValIDPrice = false 
	dim regEx, Match 
	Set regEx = New RegExp 
	regEx.Pattern = "^(\d|([1-9]\d{1,}))(\.\d{1,3}){0,1}$" 
	regEx.IgnoreCase = True 
	Set Match = regEx.Execute(strng) 
	if match.count Then IsValIDPrice= true 
End Function

'**************************************************
'函数名：GetFormatDate
'作  者：王国强
'作  用：日期格式化
'**************************************************
Public Function GetFormatDate(str, para)
	On Error Resume Next
	dim y, m, d, h, mi, s, strDateTime
	GetFormatDate = str
	If Not IsNumeric(para) Then Exit Function
	If Not IsDate(str) Then Exit Function
	y = CStr(Year(str))
	m = CStr(Month(str))
	If Len(m) = 1 Then m = "0" & m
	d = CStr(Day(str))
	If Len(d) = 1 Then d = "0" & d
	h = CStr(Hour(str))
	If Len(h) = 1 Then h = "0" & h
	mi = CStr(Minute(str))
	If Len(mi) = 1 Then mi = "0" & mi
	s = CStr(Second(str))
	If Len(s) = 1 Then s = "0" & s
	Select Case para
	Case "1"
    '显示格式：09年07月06日 13:44 
    strDateTime = y & "-" & m & "-" & d & " " & h & ":" & mi & ":" & s
     Case "2"
    '显示格式：2009-07-06
    strDateTime = y & "-" & m & "-" & d
     Case "3"
    '显示格式：2009/07/06
    strDateTime = y & "/" & m & "/" & d
     Case "4"
    '显示格式：2009年07月06日
    strDateTime = y & "年" & m & "月" & d & "日"
     Case "5"
    '显示格式：07-06 13:45
    strDateTime = m & "-" & d & " " & h & ":" & mi
     Case "6"
    '显示格式：07/06
    strDateTime = m & "/" & d
     Case "7"
    '显示格式：07月06日
    strDateTime = m & "月" & d & "日"
     Case "8"
    '显示格式：2009年07月
    strDateTime = y & "年" & m & "月"
	Case "9"
    '显示格式：2009-07
    strDateTime = y & "-" & m
	Case "10"
    '显示格式：2009/07
    strDateTime = y & "/" & m
	Case "11"
	'显示格式：09年07月06日 13:45
    strDateTime = right(y,2) & "年" &m & "月" & d & "日 " & h & ":" & mi
	Case "12"
    '显示格式：09-07-06
    strDateTime = right(y,2) & "-" &m & "-" & d
	Case "13"
    '显示格式：07-06
    strDateTime = m & "-" & d
	Case "14"
    '显示格式：13:45
    strDateTime = h & ":" & mi
	Case Else
    strDateTime = str
	End Select
	GetFormatDate = strDateTime
End Function

'**************************************************
'函数名：IsObjInstalled
'作  用：检查组件是否已经安装
'参  数：strClassString ----组件名
'返回值：True  ----已经安装
'       False ----没有安装
'**************************************************
Function IsObjInstalled(strClassString)
	On Error Resume Next
	IsObjInstalled = False
	Err = 0
	dim xTestObj
	Set xTestObj = Server.CreateObject(strClassString)
	If 0 = Err Then IsObjInstalled = True
	Set xTestObj = Nothing
	Err = 0
End Function

'// <summary>
'// 禁止外部提交
'// </summary>
Function CheckPost() 
	dim strREFERER,strSERVER
	strREFERER = Cstr(Request.ServerVariables("HTTP_REFERER"))
	strSERVER = Cstr(Request.ServerVariables("SERVER_NAME"))
	If Mid(strREFERER,8,Len(strSERVER)) <> strSERVER Then Response.Write "请不要从外部提交." : Response.End
End Function

'********************************
'返回当前页的完整URL(带参数)
'********************************
Function getCurrentPageURL()
	dim strReturnPage,strQuery,thing
	strReturnPage="http://" & Request.ServerVariables("HTTP_HOST") & Request.ServerVariables("SCRIPT_NAME")
	strQuery=""
	for each thing in Request.QueryString
	    if  thing<>"Page" Then
	   		if strQuery="" Then
	   			strQuery=thing & "=" & Request.QueryString(thing) 
	   		else
	   			strQuery=strQuery & "&" & thing & "=" & Request.QueryString(thing) 
	   		End if
	    End if
	next
	if strQuery="" Then
		getCurrentPageURL=strReturnPage
	else
		getCurrentPageURL=strReturnPage & "?" & strQuery
	End if
end Function

'**************************************************
'函数名：GetCLng
'作  用：将字符转为整型数值 
'**************************************************
Function GetCLng(ByVal str)
    If IsNumeric(str) Then
        GetCLng = Fix(CDbl(str))
    Else
        GetCLng = 0
    End if
End Function

'**************************************************
'函数名：strleach
'作  用：过滤非法字符函数 
'**************************************************
function strLeach(str)'
	dim strHTML 
	if str="" Then exit function 
	strHTML=replace(str,chr(34),"")' " 
	strHTML=replace(strHTML,chr(39),"")' ' 
	strHTML=replace(strHTML,chr(60),"")' < 
	strHTML=replace(strHTML,chr(62),"")' > 
	strHTML=replace(strHTML,chr(37),"")' % 
	strHTML=replace(strHTML,chr(38),"")' & 
	strHTML=replace(strHTML,chr(40),"")' ( 
	strHTML=replace(strHTML,chr(41),"")' ) 
	strHTML=replace(strHTML,chr(59),"")' ; 
	strHTML=replace(strHTML,chr(43),"")' + 
	strHTML=replace(strHTML,chr(45),"")' - 
	strHTML=replace(strHTML,chr(91),"")' [ 
	strHTML=replace(strHTML,chr(93),"")' ] 
	strHTML=replace(strHTML,chr(123),"")' { 
	strHTML=replace(strHTML,chr(125),"")' } 
	strleach=strHTML 
end function 

'**************************************************
'函数名：strLength
'作  用：求字符串长度。汉字算两个字符，英文算一个字符。
'参  数：str  ----要求长度的字符串
'返回值：字符串长度
'**************************************************
function strLength(str)
	ON ERROR RESUME NEXT
	dim WINNT_CHINESE
	WINNT_CHINESE    = (len("中国")=2)
	if WINNT_CHINESE Then
        dim l,t,c
        dim i
        l=len(str)
        t=l
        for i=1 to l
        	c=asc(mID(str,i,1))
            if c<0 Then c=c+65536
            if c>255 Then
                t=t+1
            End if
        next
        strLength=t
    else 
        strLength=len(str)
    End if
    if err.number<>0 Then err.clear
end function

'**************************************************
'函数名：GetIsServlets
'作  用：检查后台用户是否登录
'参  数：无
'返回值：True ----已经登录
'        False ---没有登录
'**************************************************
function GetIsServlets()
	Logined=True
	strUserName=session("strUserName")
	strPassword=session("strPassword")
	strInherited=session("strInherited")

	if strUserName="" Then
		Logined=False
	End if
	if strPassword="" Then
		Logined=False
	End if
	if strInherited="" Then
		Logined=False
	End if

	if Logined=True Then
		strUserName=replace(trim(strUserName),"'","")
		strPassword=replace(trim(strPassword),"'","")
		strInherited=cint(trim(strInherited))

		set pRs = server.createobject("adodb.recordset")
		sql="select * from tblSystem where UserName='" & strUserName & "' and PassWord='" & strPassword &"' and Inherited=" & strInherited &""
		pRs.open sql,conn,1,1
		if pRs.bof and pRs.eof Then
			Logined=False
		else
			if strUserName<>pRs("UserName") or strPassword<>pRs("PassWord") Then
				Logined=False
			End if
		End if
		pRs.close
		set pRs=nothing
	End if
	GetIsServlets=Logined
End function


'// <summary>
'// 显示错误提示信息
'// </summary>
sub ErrMsg(Message)
	dim strErr
	strErr=strErr & "<!DOCTYPE html PUBLIC ""-//W3C//DTD XHTML 1.0 Transitional//EN"" ""http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd""><html xmlns=""http://www.w3.org/1999/xhtml""><head><title>提示信息</title><meta http-equiv='Content-Type' content='text/html; charset=utf-8'>" & vbcrlf
	strErr=strErr & "<style type='text/css'>" & vbcrlf
	strErr=strErr & "<!--" & vbcrlf
	strErr=strErr & "body {font:12.8px Arial, Helvetica, sans-serif;margin-top: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;COLOR: #6e6e6e;}td {font: 12px/1.6em Tahoma,Verdana;line-height: 18.8px;}A:link {COLOR: #000000; TEXT-DECORATION: none}A:active {COLOR: #000000;TEXT-DECORATION: underline}A:visited {COLOR: #000000; TEXT-DECORATION: none}A:hover {COLOR: #000000;TEXT-DECORATION: underline}ul,li{list-style:circle;}" & vbcrlf
	strErr=strErr & "-->" & vbcrlf
	strErr=strErr & "</style>" & vbcrlf
	strErr=strErr & "</head><body><br><br>" & vbcrlf
	strErr=strErr & "<table width=""60%"" border=""0"" cellpadding=""5"" cellspacing=""1"" bgcolor=""#dfdfdf"" align=""center"">" & vbcrlf
	strErr=strErr & "<tr>" & vbcrlf
	strErr=strErr & "<td bgcolor=""e8f3fd"">提示信息</td>" & vbcrlf
	strErr=strErr & "</tr>" & vbcrlf
	strErr=strErr & "<tr>" & vbcrlf
	strErr=strErr & "<td bgcolor=""#FFFFFF"">" & Message &"" & vbcrlf
	strErr=strErr & "<br>" & vbcrlf
	strErr=strErr & "<a href=""javascript:history.back(1)"">点击这里返回</a>" & vbcrlf
	strErr=strErr & "</td>" & vbcrlf
	strErr=strErr & "</tr>" & vbcrlf
	strErr=strErr & "</table>" & vbcrlf
	strErr=strErr &  vbCrlf
	strErr=strErr & "</body></html>" & vbcrlf
	response.write strErr
End sub

'// <summary>
'// 显示成功提示信息
'// </summary>
sub performMsg(Perform, BackUrl)
    dim strPerform
	strPerform=strPerform & "<!DOCTYPE html PUBLIC ""-//W3C//DTD XHTML 1.0 Transitional//EN"" ""http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd""><html xmlns=""http://www.w3.org/1999/xhtml""><head><title>提示信息</title><meta http-equiv='Content-Type' content='text/html; charset=utf-8'>" & vbcrlf
	strPerform=strPerform & "<style type='text/css'>" & vbcrlf
	strPerform=strPerform & "<!--" & vbcrlf
	strPerform=strPerform & "body {font:12.8px Arial, Helvetica, sans-serif;margin-top: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;COLOR: #6e6e6e;}td {font: 12px/1.6em Tahoma,Verdana;line-height: 18.8px;}A:link {COLOR: #000000; TEXT-DECORATION: none}A:active {COLOR: #000000;TEXT-DECORATION: underline}A:visited {COLOR: #000000; TEXT-DECORATION: none}A:hover {COLOR: #000000;TEXT-DECORATION: underline}ul,li{list-style:circle;}" & vbcrlf
	strPerform=strPerform & "-->" & vbcrlf
	strPerform=strPerform & "</style>" & vbcrlf
	strPerform=strPerform & "</head><body><br><br>" & vbcrlf
	strPerform=strPerform & "<table width=""60%"" border=""0"" cellpadding=""5"" cellspacing=""1"" bgcolor=""#dfdfdf"" align=""center"">" & vbcrlf
	strPerform=strPerform & "<tr>" & vbcrlf
	strPerform=strPerform & "<td bgcolor=""e8f3fd"">提示信息</td>" & vbcrlf
	strPerform=strPerform & "</tr>" & vbcrlf
	strPerform=strPerform & "<tr>" & vbcrlf
	strPerform=strPerform & "<td bgcolor=""#FFFFFF"">" & Perform &"" & vbcrlf
	strPerform=strPerform & "<br>" & vbcrlf
    If BackUrl <> "" Then
	strPerform = strPerform & "<a href='" & BackUrl & "'>点击这里返回</a>"
    Else
	strPerform = strPerform & "<a href='" & Trim(Request.ServerVariables("HTTP_REFERER")) & "'>点击这里返回</a>"
    End if
	strPerform=strPerform & "</td>" & vbcrlf
	strPerform=strPerform & "</tr>" & vbcrlf
	strPerform=strPerform & "</table>" & vbcrlf
	strPerform=strPerform & "</body></html>" & vbcrlf
	response.write strPerform
End Sub

'****************************************************
'函数名：SendMail
'作  用：用Jmail组件发送邮件
'参  数：MailtoAddress  ----收信人地址
'        MailtoName    -----收信人姓名
'        Subject       -----主题
'        MailBody      -----信件内容
'        defFromName      -----发信人姓名
'        defMailFrom      -----发信人地址
'        defPriority      -----信件优先级
'****************************************************
function SendMail(MailtoAddress,MailtoName,Subject,MailBody,defFromName,defMailFrom,defPriority)
	on error resume next
	dim JMail
	Set JMail=Server.CreateObject("JMail.Message")
	if err Then
		SendMail= "<li>没有安装JMail组件</li>"
		err.clear
		exit function
	End if
	JMail.Charset=defJmailCharset          '邮件编码
	JMail.silent=true
	JMail.ContentType = "text/html"     '邮件正文格式
	'JMail.ServerAddress=defMailServer     '用来发送邮件的SMTP服务器
   	'如果服务器需要SMTP身份验证则还需指定以下参数
	JMail.MailServerUserName = defMailServerUserName    '登录用户名
   	JMail.MailServerPassWord = defMailServerPassWord        '登录密码
  	JMail.MailDomain = defMailDomain       '域名（如果用“name@domain.com”这样的用户名登录时，请指明domain.com
	JMail.AddRecipient MailtoAddress,MailtoName     '收信人
	JMail.Subject=Subject         '主题
	JMail.HMTLBody=MailBody       '邮件正文（HTML格式）
	JMail.Body=MailBody          '邮件正文（纯文本格式）
	JMail.FromName=defFromName         '发信人姓名
	JMail.From = defMailFrom         '发信人Email
	JMail.Priority=defPriority              '邮件等级，1为加急，3为普通，5为低级
	JMail.Send(defMailServer)
	SendMail =JMail.ErrorMessage
	JMail.Close
	Set JMail=nothing
end function

'********************************
'函数名：GetExtend
'验证上传文件格式
Function GetExtend(str,strng)  
	iStrTmpe=strng
	iStrExtdim=split(iStrTmpe,"|")  
	iStr=0
	For i=0 to Ubound(iStrExtdim)-1 
		If StrComp(str,iStrExtdim(i),1) = 0 Then
			iStr=1
			Exit For			
		End if  
	Next  
	GetExtend=iStr  
End Function

'********************************
'函数名：getZone
'权限组
'********************************
Private Function getZone(text,i)
dim txt
txt = text
	if not isNull(txt) or txt <> "" Then
	txt = mid(txt, i+(i-1), 1)
		if txt = "1" Then
			getZone = False'表示通过验证
		else
			getZone = True '表示没通过
		End if
	else
		getZone = True '表示没通过
	End if
End Function

'---------------------------------------------------------------------------------------------------
'FSO操作相关
'---------------------------------------------------------------------------------------------------
'****************************************************
'过程名：GetFileName
'作  用：生成文件名
'****************************************************
function GetFileName() 
	dim rannum 
	dim dtnow 
	dtnow=now() 
	randomize 
	rannum=int(90*rnd)+10 
	GetFileName=year(dtnow) &"_"& right("0" & month(dtnow),2) &"_"& right("0" & day(dtnow),2) &"_"& right("0" & hour(dtnow),2) & right("0" & minute(dtnow),2) & right("0" & second(dtnow),2) & rannum 
end function

'****************************************************
'函数名：GetIsFolder
'作  用：判断目录是否存在
'****************************************************
Function GetIsFolder(str)
	dim fso
	Set fso = CreateObject("Scripting.FileSystemObject")
	If fso.FolderExists(Server.MapPath(str)) Then
		GetIsFolder = True
	Else
		GetIsFolder = False
	End if
	Set fso = nothing
End Function

'****************************************************
'函数名：GetCreateFolder
'作  用：创建目录
'****************************************************
Function GetCreateFolder(Byval str)
	On Error Resume Next 
	dim astrPath, ulngPath, i, strTmpPath , strPath
	dim objFSO
	strPath = Server.MapPath(str)
	If InStr(strPath, "\") <=0 or InStr(strPath, ":") <= 0 Then 
		CreateFolder = False 
		Exit Function 
	End if
	set objFSO = Server.CreateObject("Scripting.FileSystemObject") 
	If objFSO.FolderExists(strPath) Then 
		CreateFolder = True 
		Exit Function 
	End if 
	astrPath = Split(strPath, "\") 
	ulngPath = UBound(astrPath) 
	strTmpPath = "" 
	For i = 0 To ulngPath 
		strTmpPath = strTmpPath & astrPath(i) & "\" 
		If Not objFSO.FolderExists(strTmpPath) Then 
			'创建 
			objFSO.CreateFolder(strTmpPath) 
		End if 
	Next 
	set objFSO = Nothing 
	If Err = 0 Then 
		CreateFolder = True 
	Else 
		Err.Clear
		CreateFolder = False 
	End if 
End Function  

'****************************************************
'函数名：GetIsFile
'作  用：测试某一文件是否存在
'****************************************************
Public Function GetIsFile(ByVal str)
	GetIsFile=False
	Set fso = CreateObject("Scripting.FileSystemObject")
	If fso.FileExists(Server.MapPath(str)) Then
		GetIsFile=True
	End if
	Set fso = Nothing
End Function

'****************************************************
'函数名：GetFormatFileSize
'作  用：格式化文件大小
'****************************************************
Function GetFormatFileSize(FileSize)
	If FileSize<1024 Then GetFormatFileSize = FileSize & " Byte"
		If FileSize/1024 <1024 And FileSize/1024 > 1 Then 
			FileSize = FileSize/1024
            GetFormatFileSize=round(FileSize*100)/100 & " KB"
        Elseif FileSize/(1024*1024) > 1 Then
            FileSize = FileSize/(1024*1024)
            GetFormatFileSize = round(FileSize*100)/100 & " MB"
	End if
End function

'****************************************************
'函数名：GetCopyFile
'作  用：文件复制
'****************************************************
Function GetCopyFile(SourceFile,DestinationFile)
	Set fso = CreateObject("Scripting.FileSystemObject")
	If GetIsFile(SourceFile) = True Then
		Set f = fso.GetFile(Server.MapPath(SourceFile))
		f.Copy (Server.MapPath(DestinationFile))
		GetCopyFile = 1
	Else
		GetCopyFile = -1
	End if
	Set fso = Nothing
End Function

'****************************************************
'函数名：GetFileDel
'作  用：删除文件或文件夹
'****************************************************
Function GetFileDel(str,oType)
	On Error Resume Next
	Set fso = Server.CreateObject("Scripting.FileSystemObject")
	if oType=0 Then
		if not fso.fileExists(Server.MapPath(str)) Then exit function 'IF文件不存在，退出
		fso.deletefile(Server.MapPath(str))
	else
		if not fso.folderExists(Server.MapPath(str)) Then exit function 'IF文件不存在，退出
		fso.deletefolder(Server.MapPath(str))
	End if
	Set fso = Nothing
End Function

'****************************************************
'函数名：GetFileMove
'作  用：移动文件或文件夹
'****************************************************
Function GetFileMove(SourceFile,DestinationFile,oType) 
	SourceFile = Server.MapPath(SourceFile) 
	DestinationFile = Server.MapPath(DestinationFile) 
	Set fso = CreateObject("Scripting.FileSystemObject")
	if oType=0 Then
		if Not fso.fileExists(SourceFile) Then exit function 'IF文件不存在，退出
		fso.MoveFile SourceFile,DestinationFile
	Else
		if Not fso.folderExists(SourceFile) Then Exit function 'IF文件夹不存在，退出
		fso.MoveFolder SourceFile,DestinationFile
	End if
	Set fso = Nothing 
End Function

'****************************************************
'函数名：GetFileSize
'作  用：取得文件的大小
'****************************************************
Function GetFileSize(str)
	Set fso = CreateObject("Scripting.FileSystemObject")
	If GetIsFile(str) = True Then
		Set f = fso.Getfile(Server.MapPath(str))
		GetFileSize = f.Size
	Else
		GetFileSize = 0
	End if
	Set fso = Nothing
End Function 

'****************************************************
'函数名：OpenFile
'作  用：读取文件内容
'****************************************************
Function OpenFile(ByVal fileUrl)
    dim stm
    On Error Resume Next
    Set stm = Server.CreateObject("ado"&"db"&"."&"str"&"eam")
    With stm
        .Type = 2
        .Mode = 3
        .Open
        .Charset = "utf-8"
        .Position = 0
        .LoadFromFile Server.MapPath(fileUrl)
        If Err.Number<>0 Then
			Response.Write "出错，文件不存在"
			Err.Clear
			Set stm = Noting
			Exit Function
        End if
        OpenFile = .ReadText
        .Close
    End With
    Set stm = Nothing
End Function

'// <summary>
'// 写入文件内容
'// </summary>
function CreateFile(ByVal fileUrl, ByVal oContent)
	On Error Resume Next
	fileUrl = replace(fileUrl, "\", "/") : fileUrl = replace(fileUrl, "//", "/")
	If Right(fileUrl, 1) = "/" Then CreateFile = False: Exit Function
		Call GetCreateFolder(Left(fileUrl, InStrRev(fileUrl,"/")))	'自动创建文件夹
	If InStr(fileUrl, ":") = 0 Then fileUrl = Server.MapPath(fileUrl)
	dim stm
	Set stm = CreateObject("ADODB.Stream")
	stm.Type = 2 '设置为可读可写
	stm.Mode = 3 '设置内容为文本
	stm.Charset = "utf-8"
	stm.Open
	'stm.Position = stm.Size
	stm.WriteText oContent
	stm.SaveToFile fileUrl, 2
	stm.Close
	Set stm = Nothing
	If Err.Number <> 0 Then Err.Clear
End Function

'// <summary>
'// 以年月创建上传文件夹
'// </summary>
Function CreatePath(str)
    dim objFSO,Fsofolder,uploadpath
    uploadpath=year(now)&"-"&month(now) '以年月创建上传文件夹，格式：2003－8
    On Error Resume Next
    Set objFSO = Server.CreateObject("Scripting.FileSystemObject")
    If objFSO.FolderExists(Server.MapPath(str&uploadpath))=False Then
        objFSO.CreateFolder Server.MapPath(str&uploadpath)
    End if
    If Err.Number = 0 Then
        CreatePath=uploadpath&"/"
    Else
        CreatePath=""
    End if
    Set objFSO = Nothing
End Function

'// <summary>
'// Textarea输入框
'// </summary>
sub GetTextarea(strForm,strDefine, strWidth, strHeight, strValue)
	Response.write("<div align=""left""><textarea name="""& strDefine &""" style=""width:"& strWidth & "%"" rows="""& strHeight &""" id="""& strDefine &""">"& strValue &"</textarea>")
	Response.write("<span onclick=""javascript:document."& strForm & "."& strDefine & ".rows+= " & strHeight & ";"" title=""点击向下拉长"" style=""cursor:hand"">")
	Response.write("<img src=""images/length.gif"" border=""0""></span>")
	Response.write("<span onclick=""javascript:if(document."& strForm & "."& strDefine & ".rows != "& strHeight & "){document."& strForm & "."& strDefine & ".rows-="& strHeight &";}else{document."& strForm & "."& strDefine & ".rows="& strHeight &";}"" title=""点击向上缩短"" style=""cursor:hand"">")
	Response.write("<img src=""images/short.gif"" border=""0""></span></div>")
End sub

'// <summary>
'// 通用的实现<SELECT>内容的函数
'// CommonSelect("sex","男,女","男,女","男")
'// </summary>
Function CommonSelect(idname,liststr,valuestr,selectstr)
	dim arrlist
	dim arrvalue
	dim markstr
	arrlist=split(liststr,",")
	IF len(trim(valuestr))=0 Then valuestr=liststr
	IF selectstr="" Then selectstr=arrlist(0)
	arrvalue=split(valuestr,",")
	IF Ubound(arrlist)<>Ubound(arrvalue) Then
		Exit Function
	End if
	strHTML="<select name=""" & idname & """ id=""" & idname & """>"
	For i=0 to Ubound(arrlist)
	    IF Cstr(arrvalue(i)) = Cstr(selectstr) Then
	       markstr=" selected "
	    Else   
	       markstr=""
	    End if
	    strHTML = strHTML & "<option " &  markstr & "value='" & arrvalue(i) &"'>" &  arrlist(i) & "</option>"
	Next
	CommonSelect = strHTML & "</select>"
End Function

'// <summary>
'// 通用单选框
'// CommonRadio("sex","男,女","男,女","男")
'// </summary>
Function CommonRadio(idname,liststr,valuestr,checkstr)
	dim arrlist
	dim arrvalue
	dim markstr
	arrlist=split(liststr,",")
	IF len(trim(valuestr))=0 Then valuestr=liststr
	IF selectstr="" Then selectstr=arrlist(0)
	arrvalue=split(valuestr,",")
	IF Ubound(arrlist)<>Ubound(arrvalue) Then
		Exit Function
	End IF
	marked=false
	For i=0 to Ubound(arrlist)
	    if checkstr=""  and Not marked Then
		     markstr=" checked "
		     marked=true
		  else
		    IF Cstr(arrvalue(i)) = Cstr(checkstr)  Then
		       markstr=" checked "
		    Else   
		       markstr=""
		    End IF
		 end if
	    strHTML= strHTML & "<input type=radio " & markstr & " value='" & arrvalue(i) &"' name='" & idname & "' id='" & idname & "'>" & arrlist(i) & "&nbsp;"
	Next
	CommonRadio = strHTML
End Function

'// <summary>
'// 格式化目录名称
'// </summary>
Function GetFormatFolder(str)
	if isnull(str) or trim(str)="" Then
		GetFormatFolder=""
		exit function
	End if
	if left(str, 1) <> "/" Then str = "/"& str
	if right(str, 1) <> "/" Then str = str & "/"
	str = replace(str, "\", "/")
	str = replace(str, "//", "/")
	GetFormatFolder=str
End Function 

'// <summary>
'// 自动识别文件
'// </summary>
Function SelPlay(strUrl,strWidth,StrHeight)
If strUrl <> "" Then
   isExt = LCase(Mid(strUrl,InStrRev(strUrl, ".")+1))
Else
   isExt = ""
End if
If strWidth="" Then strWidth=640
If StrHeight="" Then StrHeight=480
Select Case isExt
	Case "avi","wmv","asf","mov","mpg","mpeg"
		strHTML=strHTML & "<div align=""center""><EMBED id=MediaPlayer src="&strUrl&" width="&strWidth&" height="&strHeight&" loop=""false"" autostart=""true""></EMBED></div>"
	Case "mov","rm","ra","ram"
		strHTML=strHTML & "<div align=""center""><OBJECT height="&strHeight&" width="&strWidth&" classid=clsid:CFCDAA03-8BE4-11cf-B84B-0020AFBBCCFA>"
		strHTML=strHTML & "<PARAM NAME=""_ExtentX"" VALUE=""12700"">"
		strHTML=strHTML & "<PARAM NAME=""_ExtentY"" VALUE=""9525"">"
		strHTML=strHTML & "<PARAM NAME=""AUTOSTART"" VALUE=""-1"">"
		strHTML=strHTML & "<PARAM NAME=""SHUFFLE"" VALUE=""0"">"
		strHTML=strHTML & "<PARAM NAME=""PREFETCH"" VALUE=""0"">"
		strHTML=strHTML & "<PARAM NAME=""NOLABELS"" VALUE=""0"">"
		strHTML=strHTML & "<PARAM NAME=""SRC"" VALUE="""&strUrl&""">"
		strHTML=strHTML & "<PARAM NAME=""CONTROLS"" VALUE=""ImageWindow"">"
		strHTML=strHTML & "<PARAM NAME=""CONSOLE"" VALUE=""Clip"">"
		strHTML=strHTML & "<PARAM NAME=""LOOP"" VALUE=""0"">"
		strHTML=strHTML & "<PARAM NAME=""NUMLOOP"" VALUE=""0"">"
		strHTML=strHTML & "<PARAM NAME=""CENTER"" VALUE=""0"">"
		strHTML=strHTML & "<PARAM NAME=""MAINTAINASPECT"" VALUE=""0"">"
		strHTML=strHTML & "<PARAM NAME=""BACKGROUNDCOLOR"" VALUE=""#000000"">"
		strHTML=strHTML & "</OBJECT>"
		strHTML=strHTML & "<BR>"
		strHTML=strHTML & "<OBJECT height=32 width="&strWidth&" classid=clsid:CFCDAA03-8BE4-11cf-B84B-0020AFBBCCFA>"
		strHTML=strHTML & "<PARAM NAME=""_ExtentX"" VALUE=""12700"">"
		strHTML=strHTML & "<PARAM NAME=""_ExtentY"" VALUE=""847"">"
		strHTML=strHTML & "<PARAM NAME=""AUTOSTART"" VALUE=""0"">"
		strHTML=strHTML & "<PARAM NAME=""SHUFFLE"" VALUE=""0"">"
		strHTML=strHTML & "<PARAM NAME=""PREFETCH"" VALUE=""0"">"
		strHTML=strHTML & "<PARAM NAME=""NOLABELS"" VALUE=""0"">"
		strHTML=strHTML & "<PARAM NAME=""CONTROLS"" VALUE=""ControlPanel,StatusBar"">"
		strHTML=strHTML & "<PARAM NAME=""CONSOLE"" VALUE=""Clip"">"
		strHTML=strHTML & "<PARAM NAME=""LOOP"" VALUE=""0"">"
		strHTML=strHTML & "<PARAM NAME=""NUMLOOP"" VALUE=""0"">"
		strHTML=strHTML & "<PARAM NAME=""CENTER"" VALUE=""0"">"
		strHTML=strHTML & "<PARAM NAME=""MAINTAINASPECT"" VALUE=""0"">"
		strHTML=strHTML & "<PARAM NAME=""BACKGROUNDCOLOR"" VALUE=""#000000"">"
		strHTML=strHTML & "</OBJECT></div>"
	Case "flv"
		strHTML=strHTML & "<div id=""player"" align=""center""><a href=""http://www.macromedia.com/go/getflashplayer"">Get Flash</a> to see this player.</div>" & vbCrlf
		strHTML=strHTML & "<script type=""text/javascript"">" & vbCrlf
		strHTML=strHTML & "var so = new SWFObject('"&defInstalldir&"global/images/player.swf','player','"&strWIDth&"','"&strHeight&"','7');" & vbCrlf
		strHTML=strHTML & "so.addParam(""allowfullscreen"",""true"");" & vbCrlf
		strHTML=strHTML & "so.addVariable(""file"","""&strUrl&""");" & vbCrlf
		strHTML=strHTML & "so.write('player');" & vbCrlf
		strHTML=strHTML & "</script>" & vbCrlf
	Case "mp3"
		strHTML=strHTML & "<script type=""text/javascript"" src="""&defInstalldir&"global/script/audio-player.js""></script>" & vbCrlf
		strHTML=strHTML & "<script type=""text/javascript"">  " & vbCrlf
		strHTML=strHTML & "AudioPlayer.setup("""&defInstalldir&"global/images/audioplayer.swf"", {   " & vbCrlf
		'strHTML=strHTML & "titles: ""Title"",   " & vbCrlf
		strHTML=strHTML & "width: 290   " & vbCrlf
		strHTML=strHTML & "});   " & vbCrlf
		strHTML=strHTML & "</script>  " & vbCrlf
		strHTML=strHTML & "<div id=""audioplayer"" align=""center"">Alternative content</div>  " & vbCrlf
		strHTML=strHTML & "<script type=""text/javascript"">  " & vbCrlf
		strHTML=strHTML & "AudioPlayer.embed(""audioplayer"", {soundFile: """&strUrl&"""});   " & vbCrlf
		strHTML=strHTML & "</script>  " & vbCrlf
	Case "rar","zip","pdf","ppt"
		strHTML=strHTML & ""&strUrl&""
End Select
SelPlay=strHTML
End Function

'// <summary>
'// 获得文件扩展名
'// </summary>
Function GetFileExt(str)
	GetFileExt = MID(str,InstrRev(str,".")+1)
End Function

'// <summary>
'// 验证是否图片
'// </summary>
Function GeIsPicture(str)
	Select Case GetFileExt(Lcase(str))
		Case "jpg","gif","jpeg","bmp","png":GeIsPicture=1
		Case Else:GeIsPicture=0
   End Select
End Function

'// <summary>
'// 图片水印
'// </summary>
Function Jpeg_Canvas(JpegFiles)
	IF Not IsObjInstalled("Persits.Jpeg") Or Not defIsJpeg Then Exit Function
	IF GeIsPicture(JpegFiles)=0 Then Exit Function
	Set AspJpeg=Server.CreateObject("Persits.Jpeg")
	IF AspJpeg.Expires < Now Then Exit Function
	AspJpeg.Open Trim(JpegFiles)
	IF AspJpeg.OriginalWidth>defJpegCoordinate(0)*2 Then
		IF defJpegStyle Then
			IF Len(defJpegPrintText)>0 And Len(defJpegColor)>0 Then
				LogoWidth=(defJpegSize+1)*strLength(defJpegPrintText)/2
				LogoHeight=defJpegSize+1
				iLeft=GetPosition_X(AspJpeg.OriginalWidth, LogoWidth, defJpegCoordinate(0))
				iTop=GetPosition_Y(AspJpeg.OriginalHeight, LogoHeight, defJpegCoordinate(1))
				AspJpeg.Canvas.Font.COLOR=defJpegColor         ' 文字的颜色
				AspJpeg.Canvas.Font.Family=defJpegFamily         ' 文字的字体
				AspJpeg.Canvas.Font.Size=defJpegSize          ' 文字的大小
				AspJpeg.Canvas.Font.Bold=defJpegBold              ' 文字是否粗体
				AspJpeg.Canvas.Font.Quality=4                              ' Antialiased
				AspJpeg.Canvas.PrintText iLeft,iTop,defJpegPrintText         ' 加入文字及坐标位置
				AspJpeg.Canvas.Pen.COLOR=&H0               ' 边框的颜色
				AspJpeg.Canvas.Pen.Width=1                 ' 边框的粗细
				AspJpeg.Canvas.Brush.Solid=False           ' 图片边框内是否填充颜色
				AspJpeg.Quality=defJpegQuality
				AspJpeg.save JpegFiles     ' 生成文件
			End if
		Else
			Set fso=CreateObject("Scripting.FileSystemObject")
			IF Not fso.FileExists(Server.MapPath(defJpegImage)) Then
				Exit Function
			End if
			Set fso=Nothing
			dim iAspJpeg
			Set iAspJpeg=Server.CreateObject("Persits.Jpeg")
			iAspJpeg.Open Server.MapPath(defJpegImage)  '打开水印图片
			
			iLeft=GetPosition_X(AspJpeg.OriginalWidth,iAspJpeg.Width,defJpegCoordinate(0))
			iTop=GetPosition_Y(AspJpeg.OriginalHeight,iAspJpeg.Height,defJpegCoordinate(1))
			
			IF defJpegBackground="" Then
				AspJpeg.DrawImage iLeft,iTop,iAspJpeg,defJpegLucency,100
			Else
				AspJpeg.DrawImage iLeft,iTop,iAspJpeg,defJpegLucency,defJpegBackground,100
			End if
			AspJpeg.Quality=defJpegQuality
			AspJpeg.Save JpegFiles
			Set iAspJpeg=Nothing	
		End if
	End if
	Set AspJpeg = Nothing
End Function

'// <summary>
'// 图片缩略图
'// </summary>
Function Jpeg_Thumb(JpegFiles,ObjectFiles)
	IF Not IsObjInstalled("Persits.Jpeg") Or Not defIsJpeg Then Exit Function
	IF GeIsPicture(JpegFiles)=0 Then Exit Function
	Set AspJpeg=Server.CreateObject("Persits.Jpeg")
	Set iAspJpeg=Server.CreateObject("Persits.Jpeg")
	IF AspJpeg.Expires < Now Then Exit Function
	AspJpeg.Open Trim(JpegFiles)
	iAspJpeg.Open Trim(JpegFiles)	
	bl_w=defJpegThumbWidth/AspJpeg.OriginalWidth
	bl_h=defJpegThumbHeight/AspJpeg.OriginalHeight
	IF defJpegThumbWidth>0 Then
		IF defJpegThumbHeight>0 Then
			Select Case defJpegMeans
			Case "0"'常规算法：宽度和高度都大于0时，直接缩小成指定大小，其中一个为0时，按比例缩小
				IF bl_w<1 Or bl_h<1 Then
					AspJpeg.Width=defJpegThumbWidth
					AspJpeg.Height=defJpegThumbHeight
					AspJpeg.Quality=defJpegQuality
					AspJpeg.save ObjectFiles
				End if
			Case "1"'裁剪法：宽度和高度都大于0时，先按最佳比例缩小再裁剪成指定大小，其中一个为0时，按比例缩小
				IF bl_w<1 Or bl_h<1 Then
					If bl_w<bl_h Then
						AspJpeg.Height=defJpegThumbHeight
						AspJpeg.Width=Round(AspJpeg.OriginalWidth * bl_h)   '按缩小成大比例者
					Else
						AspJpeg.Width=defJpegThumbWidth
						AspJpeg.Height=Round(AspJpeg.OriginalHeight * bl_w)
					End if
					AspJpeg.Crop 0, 0, defJpegThumbWidth, defJpegThumbHeight
					AspJpeg.Quality=defJpegQuality
					AspJpeg.Save ObjectFiles
				End if
			Case "2"'补充法：在指定大小的背景图上附加上按最佳比例缩小的图片
				'创建一个指定大小的背景图
				iAspJpeg.Width=defJpegThumbWidth
				iAspJpeg.Height=defJpegThumbHeight
				iAspJpeg.Canvas.Brush.Solid=True            ' 图片边框内是否填充颜色
				iAspJpeg.Canvas.Brush.COLOR="&HFFFFFF"  '设定背景颜色
				iAspJpeg.Canvas.Bar -1, -1, iAspJpeg.Width+1, iAspJpeg.Height+1 '填充

				'按最佳比例缩小图片
				IF bl_w>bl_h Then
					IF bl_h<1 Then
						AspJpeg.Height=defJpegThumbHeight
						AspJpeg.Width=Round(AspJpeg.OriginalWidth*bl_h)   '按缩小成小比例者
					End if
				Else
					IF bl_w<1 Then
						AspJpeg.Width=defJpegThumbWidth
						AspJpeg.Height=Round(AspJpeg.OriginalHeight*bl_w)
					End if
				End if

				'得到缩略图的坐标
				iLeft=(iAspJpeg.Width-AspJpeg.Width)/2
				iTop=(iAspJpeg.Height-AspJpeg.Height)/2
				iAspJpeg.DrawImage iLeft,iTop,AspJpeg   '将缩略图附加到背景上
				iAspJpeg.Quality=defJpegQuality
				iAspJpeg.Save ObjectFiles
			End Select
		Else
			IF bl_w<1 Then
				AspJpeg.Width=defJpegThumbWidth
				AspJpeg.Height=Round(AspJpeg.OriginalHeight*bl_w)
				AspJpeg.Quality=defJpegQuality
				AspJpeg.Save ObjectFiles
			End if
		End if
	Else
		IF defJpegThumbHeight>0 And bl_h<1 Then
			AspJpeg.Height=defJpegThumbHeight
			AspJpeg.Width=Round(AspJpeg.OriginalWidth*bl_h)
			AspJpeg.Quality=defJpegQuality
			AspJpeg.Save ObjectFiles
		End if
	End if
	Set AspJpeg=Nothing
	Set iAspJpeg=Nothing
End Function

Function GetPosition_X(strOriginalWidth, strWidthHeight, strCoordinate)
    Select Case defJpegCoordinateStart
		Case 0:GetPosition_X=strCoordinate'左上
		Case 1:GetPosition_X=strCoordinate'左下
		Case 2:GetPosition_X=(strOriginalWidth-strWidthHeight)/2'居中
		Case 3:GetPosition_X=strOriginalWidth-strWidthHeight-strCoordinate'右上
		Case 4:GetPosition_X=strOriginalWidth-strWidthHeight-strCoordinate'右下
		Case Else:GetPosition_X=0'不显示
	End Select
End Function

Function GetPosition_Y(strOriginalWidth,strWidthHeight,strCoordinate)
    Select Case defJpegCoordinateStart
		Case 0:GetPosition_Y=strCoordinate'左上
		Case 1:GetPosition_Y=strOriginalWidth-strWidthHeight-strCoordinate'左下
		Case 2:GetPosition_Y=(strOriginalWidth-strWidthHeight)/2'居中
		Case 3:GetPosition_Y=strCoordinate'右上
		Case 4:GetPosition_Y=strOriginalWidth-strWidthHeight-strCoordinate'右下
		Case Else:GetPosition_Y=0'不显示
    End Select
End Function

'// <summary>
'// 当前节点Id,链接?后所带的参数值
'// </summary>
Function GetCategoryPath(Id,Url)
	Counter=0
	StopRun=false
    If Instr(Url,"?")=0 Then
        Url=Url&"?"
    Else
        If Right(Url,1)<>"?" Then
            Url=Url&"&"
        End if
    End if
    do
        Sql="Select * From tblCatalog Where catalogId="&Id
        Set pRs=Conn.ExeCute(Sql)
        If Not(pRs.Eof And pRs.Bof)Then
            str=" > <a href='"&Url&"Parent="&pRs("catalogId")&"'>"&pRs("CateName")&"</a>"&str
            Id=CInt(pRs("ParentID"))
        Else
            StopRun=true    
        End if
        pRs.Close
    Loop Until(StopRun Or Id=0)
    str="<a href='"&Url&"Parent=0'>根类别</a>" & str    
    GetCategoryPath=str
End Function

'// <summary>
'// 递归搜当前目录下所有的下级目录
'// </summary>
Function ChildenList(Parent)
        Dim SQL, Rs, Result
        SQL = "SELECT catalogId FROM tblCatalog WHERE ParentID = " & Parent
        Set pRs = Conn.ExeCute(SQL)
        While Not pRs.Eof
            If ChildenList <> "" Then
                ChildenList = ChildenList & "," & pRs("catalogId")
            Else
                ChildenList = pRs("catalogId")
            End If
            Result = ChildenList(pRs("catalogId"))
           If Result <> "" Then
                ChildenList = ChildenList & "," & Result
            End If
            pRs.MoveNext
        Wend
        pRs.Close
        Set pRs = Nothing
End Function

'// <summary>
'// 获得资源指定数据库字段的信息
'// </summary>
Function GetField(field,table,where)
    dim SQL
	SQL="Select "&field&" From "&table&" Where "&where
    dim pRs
    Set pRs=Conn.ExeCute(SQL)
    If Not(pRs.Eof and pRs.Bof) Then
        GetField=pRs(Field)
    Else
        GetField=Null
    End If
    pRs.Close
    Set pRs=Nothing
End Function

'// <summary>
'// 取记录总数
'// </summary>
Function GetTotal(ByVal reference,ByVal table)
	set rs=server.createobject("adodb.recordset")
	SQL="select count("&reference&") from "&table&""
	set count=conn.execute(SQL)
	Count=Count(0)
	GetTotal=count
End Function

'// <summary>
'// 过滤目录名
'// </summary>
function GeLeach(fString,str)
	if isnull(fString) or trim(fString)="" Then
		GeLeach=""
		exit function
	End if
	if str=1 Then
		fString = replace(fString, ".", "_")
    End if
	fString = replace(fString, "..", "_")
    fString = replace(fString, "//", "_")
    GeLeach = fString
end function

'// <summary>
'// HTML格式化
'// </summary>
function HTMLEncode(byval fString)
	if isnull(fString) or trim(fString)="" Then
		HTMLEncode=""
		exit function
	End if
    fString = replace(fString, ">", "&gt;")
    fString = replace(fString, "<", "&lt;")

    fString = Replace(fString, CHR(32), "&nbsp;")
    fString = Replace(fString, CHR(9), "&nbsp;")
    fString = Replace(fString, CHR(34), "&quot;")
    fString = Replace(fString, CHR(39), "&#39;")
    fString = Replace(fString, CHR(13), "")
    fString = Replace(fString, CHR(10) & CHR(10), "</P><P> ")
    fString = Replace(fString, CHR(10), "<BR> ")

    HTMLEncode = fString
end function

function HTMLDecode(byval fString)
	if isnull(fString) or trim(fString)="" Then
		HTMLDecode=""
		exit function
	End if
    fString = replace(fString, "&gt;", ">")
    fString = replace(fString, "&lt;", "<")

    fString = Replace(fString,  "&nbsp;"," ")
    fString = Replace(fString, "&quot;", CHR(34))
    fString = Replace(fString, "&#39;", CHR(39))
    fString = Replace(fString, "</P><P> ",CHR(10) & CHR(10))
    fString = Replace(fString, "<BR> ", CHR(10))

    HTMLDecode = fString
end function

'// <summary>
'// 去除所有HTML标记
'// </summary>
Function cutHTMLStr(str,strlen) 
	dim re 
	Set re=new RegExp 
	re.IgnoreCase =True 
	re.Global=True 
	re.Pattern="<(.[^>]*)>" 
	str=re.Replace(str,"") 
	set re=Nothing 
	dim l,t,c,i 
	l=Len(str) 
	t=0 
	For i=1 to l 
	c=Abs(Asc(MID(str,i,1))) 
	If c>255 Then 
	t=t+2 
	Else 
	t=t+1 
	End if 
	If t>=strlen Then 
	cutHTMLStr=left(str,i)&"..." 
	Exit For 
	Else 
	cutHTMLStr=str 
	End if 
	Next 
	cutHTMLStr=Replace(cutHTMLStr,chr(10),"") 
	cutHTMLStr=Replace(cutHTMLStr,chr(13),"") 
End Function

'// <summary>
'// 格式化文件大小
'// </summary>
sub GetFormatSize(itemsize)
	Response.Write "<td>" &vbCrLf
	Select case Len(itemsize)
	Case "1", "2", "3" 
		Response.Write itemsize & " bytes"
	Case "4", "5", "6"
		Response.Write Round(itemsize/1000) & " kb"
	Case "7", "8", "9"
		Response.Write Round(itemsize/1000000) & " mb"
	End Select
	Response.Write "</td>" &vbCrLf
end sub

'// <summary>
'// 关键字替换函数
'// </summary>
Function GetKeyWord(str)
	tempText = str
	SQL="select * from tblSetting"
	set rs=conn.execute(SQL)
	If Not rs.eof Then
	KeyWord = rs("KeyWord")
	tempTxt = Split(KeyWord, vbCrLf)
	For i = 0 To UBound(tempTxt)
		txt = tempTxt(i)
		If txt <> "" Then
			txts = Split(txt, "|")
			For O = 0 To UBound(txts)
				Select Case O
				Case 0
					KeyWordTxt = txts(O)
				Case 1
					KeyWordUrl = txts(O)
				End Select
			Next
			tempText = Replace(tempText, KeyWordTxt, "<a href=" & KeyWordUrl & " title=" & KeyWordTxt & " target=_blank>" & KeyWordTxt & "</a>")
		End if
	Next
	End if
	GetKeyWord = tempText
End Function

'// <summary>
'// 生成标签
'// </summary>
Function SmartGetTag(str)
	oStr=str
	strTxt=split(oStr,",")
	if isarray(strTxt) Then
		for i=0 to ubound(strTxt)   
			tempText="<a href="&defInstalldir&"search.asp?tag="&Server.URLEncode(strTxt(i))&">"&strTxt(i)&"</a>,"&tempText
		next
	End if
	SmartGetTag = tempText
End Function

'// <summary>
'// 上一条下一条
'// </summary>
Function GetPreOrNext(id, str)
    Set pRs = Server.CreateObject("Adodb.Recordset")
    If str = "pre" Then SQL = "select * from tblPage where ID < " & ID & " order by ID desc"
    If str = "next" Then SQL = "select * from tblPage where ID > " & ID & " order by ID"
    pRs.Open SQL, conn, 1, 1
    If pRs.eof Then
        GetPreOrNext = "-"
    Else
        GetPreOrNext = "<a href="& GetField("PathName","tblCatalog","catalogId="&pRs("catalogId")&"")&""& pRs("ID")&""& pRs("FileExtend")&" target=_blank>" & pRs("Title") & "</a>"
	End if
End Function

'// <summary>
'// HTML(模板)格式化
'// </summary>
Function templateEncode(str)
	IF IsNull(str) Then Exit Function
	str=Replace(str, "<", "&lt;")
	str=Replace(str, ">", "&gt;")
	templateEncode=str
End Function

'// <summary>
'// 通用分页过程
'// 调用说明：GetPage(总记录数，每页大小，总页数,当前页,Url参数)
'// </summary>
Function GetPage(ByVal RecordCount,ByVal PageSize,ByVal PageCount,ByVal Page,ByVal Url)
	strHTML="<div class=""paging""><a href='"&Replace(Url,"{Page}",1)&"'>|&lt;</a>"
	if Page>1 Then
		strHTML=strHTML+"<a href='"&Replace(Url,"{Page}",Page-1)&"'>&lt;</a>"
	Else
		strHTML=strHTML+"<span class=""current"">&lt;</span>" 
	End If

	strHTML=strHTML+""&Page&"/"&PageCount&""	  
	
	if Page<PageCount Then
		strHTML=strHTML+"<a href='"&Replace(Url,"{Page}",Page+1)&"'>&gt;</a>"
	Else
		strHTML=strHTML+"<span class=""current"">&gt;</span>"	  
	End if 
	strHTML=strHTML+"<a href='"&Replace(Url,"{Page}",PageCount)&"'>&gt;|</a></div>"
	GetPage=strHTML
End Function

'// <summary>
'// 验证为空
'// </summary>
Function IsBlank(ByRef strng)
	IsBlank = False
	Select Case VarType(strng)
	Case 0, 1
	IsBlank = True
	Case 8
	If Len(strng) = 0 Then
	IsBlank = True
	End if
	Case 9
	tmpType = TypeName(strng)
	If (tmpType = "Nothing") Or (tmpType = "Empty") Then
	IsBlank = True
	End if
	Case 8192, 8204, 8209
	If UBound(strng) = -1 Then
	IsBlank = True
	End if
	End Select
End Function
	
'// <summary>
'// 截取字符串长度函数
'// </summary>
Function cutStr(str,strlen) 
	dim l,t,c 
	l=len(str) 
	t=0 
	for i=1 to l 
	c=Abs(Asc(Mid(str,i,1))) 
	if c>255 Then 
	t=t+2 
	Else 
	t=t+1 
	End if 
	if t>=strlen Then 
	cutStr=left(str,i) 
	exit for 
	Else 
	cutStr=str 
	End if 
	next 
	cutStr=replace(cutStr,chr(10),"") 
End Function
%>