var knEncode = {
	xmkey:"",
	charset:"",
	setxmkey:function(key){
		this.xmkey = key;
	},
	decode:function(toDEC){
		toDEC = this.unBase64(toDEC);
		var length = toDEC.length;
		var i=0;
		var newString = "";
		for(i=0;i<length;i++){
			newString += this.blowChar(i,toDEC.charCodeAt(i));
		}
		if(this.charset=='utf-8' || this.charset=="utf8" || this.charset==""){
			var final_val = this.utf8_decode(newString);
		}else{
			var final_val = newString;
		}
		return final_val;
	},
	blowChar:function(offset,cc){
		var xmkeylen = this.xmkey.length;
		offset = offset % xmkeylen;
		return String.fromCharCode((256 + cc - this.xmkey.charCodeAt(offset))%256);
	},
	unBase64:function(input) {
		var _keyStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
		var output = "";
		var chr1, chr2, chr3;
		var enc1, enc2, enc3, enc4;
		var i = 0;
		input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");
		while (i < input.length) {
			enc1 = _keyStr.indexOf(input.charAt(i++));
			enc2 = _keyStr.indexOf(input.charAt(i++));
			enc3 = _keyStr.indexOf(input.charAt(i++));
			enc4 = _keyStr.indexOf(input.charAt(i++));
			chr1 = (enc1 << 2) | (enc2 >> 4);
			chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
			chr3 = ((enc3 & 3) << 6) | enc4;
			output = output + String.fromCharCode(chr1); 
			if (enc3 != 64) {
				output = output + String.fromCharCode(chr2);
			}
			if (enc4 != 64) {
				output = output + String.fromCharCode(chr3);
			}
		}
		return output;
	},
	utf8_decode:function(utftext) {
		var string = "";
		var i = 0;
		var c = c1 = c2 = 0;
		while ( i < utftext.length ) {
			c = utftext.charCodeAt(i);
			if (c < 128) {
				string += String.fromCharCode(c);
				i++;
			}
			else if((c > 191) && (c < 224)) {
				c2 = utftext.charCodeAt(i+1);
				string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
				i += 2;
			}
			else {
				c2 = utftext.charCodeAt(i+1);
				c3 = utftext.charCodeAt(i+2);
				string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
				i += 3;
			} 
		}
		return string;
	}
}