DROP TABLE IF EXISTS mo_accessory;
CREATE TABLE `mo_accessory` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `name` varchar(150) NOT NULL,  `selfname` varchar(150) NOT NULL,  `trends_path` varchar(20) NOT NULL,  `path` varchar(150) NOT NULL,  `width` int(11) NOT NULL,  `height` int(11) NOT NULL,  `size` varchar(30) NOT NULL,  `mediatype` tinyint(1) NOT NULL,  `extension` char(5) NOT NULL,  `created` int(10) NOT NULL,  PRIMARY KEY (`id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='附件管理表';
DROP TABLE IF EXISTS mo_admin_log;
CREATE TABLE `mo_admin_log` (  `log_id` int(10) unsigned NOT NULL AUTO_INCREMENT,  `log_time` int(10) unsigned NOT NULL DEFAULT '0',  `admin_name` varchar(20) NOT NULL DEFAULT '',  `log_info` varchar(255) NOT NULL DEFAULT '',  `module_name` varchar(20) NOT NULL DEFAULT '',  `ip_address` varchar(15) NOT NULL DEFAULT '',  PRIMARY KEY (`log_id`),  KEY `log_time` (`log_time`),  KEY `user_id` (`admin_name`)) ENGINE=MyISAM AUTO_INCREMENT=119 DEFAULT CHARSET=utf8 COMMENT='管理员操作日志表';
DROP TABLE IF EXISTS mo_adposition;
CREATE TABLE `mo_adposition` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `adname` varchar(100) NOT NULL,  `adtypeid` int(11) NOT NULL,  `adtypename` varchar(50) NOT NULL,  `useclumn` int(11) NOT NULL,  `clumnname` varchar(50) NOT NULL,  `adpos` varchar(50) DEFAULT NULL,  `pos` tinyint(2) NOT NULL DEFAULT '0',  `adsize` varchar(50) NOT NULL,  `adnum` int(11) NOT NULL DEFAULT '0',  `fontnum` int(11) DEFAULT '0',  `addescript` varchar(500) NOT NULL,  PRIMARY KEY (`id`)) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='广告位管理';
DROP TABLE IF EXISTS mo_adtype;
CREATE TABLE `mo_adtype` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `typename` varchar(50) NOT NULL,  `typefilename` varchar(50) NOT NULL,  `state` tinyint(2) NOT NULL,  `attribute` tinyint(2) NOT NULL DEFAULT '0',  `adposition` tinyint(2) NOT NULL DEFAULT '0',  `adsize` tinyint(2) NOT NULL,  `adtime` tinyint(2) NOT NULL,  `adtype` varchar(10) NOT NULL,  `wordnum` tinyint(2) DEFAULT '0',  `wordeffect` tinyint(2) DEFAULT '0',  `closeefftct` tinyint(2) DEFAULT '0',  `adnum` tinyint(2) NOT NULL,  PRIMARY KEY (`id`)) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COMMENT='广告类型管理';
DROP TABLE IF EXISTS mo_advert;
CREATE TABLE `mo_advert` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `adtitle` varchar(150) NOT NULL,  `adpositionid` int(11) NOT NULL,  `timetype` tinyint(1) NOT NULL,  `addtime` varchar(10) NOT NULL,  `starttime` varchar(10) NOT NULL,  `endtime` varchar(10) NOT NULL DEFAULT '',  `sort` int(11) NOT NULL,  `clicknum` int(11) NOT NULL,  `adimg` text NOT NULL,  PRIMARY KEY (`id`)) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='广告管理';
DROP TABLE IF EXISTS mo_area;
CREATE TABLE `mo_area` (  `area_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,  `parent_id` smallint(5) unsigned NOT NULL DEFAULT '0',  `area_name` varchar(120) NOT NULL DEFAULT '',  `area_type` tinyint(1) NOT NULL DEFAULT '2',  `agency_id` smallint(5) unsigned NOT NULL DEFAULT '0',  PRIMARY KEY (`area_id`),  KEY `parent_id` (`parent_id`),  KEY `region_type` (`area_type`),  KEY `agency_id` (`agency_id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='区域表';
DROP TABLE IF EXISTS mo_article;
CREATE TABLE `mo_article` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `maintable_id` int(11) NOT NULL,  `content` text NOT NULL,  `template` varchar(150) NOT NULL,  `readpower` varchar(255) NOT NULL,  `allowcomment` tinyint(2) NOT NULL DEFAULT '1',  PRIMARY KEY (`id`),  KEY `subsidiary_maintable_id` (`maintable_id`)) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='文章表';
DROP TABLE IF EXISTS mo_attribute;
CREATE TABLE `mo_attribute` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `name` varchar(50) NOT NULL,  `sort` int(11) NOT NULL,  `dataname` varchar(50) NOT NULL,  `fieldtype` varchar(30) NOT NULL,  `fieldtips` varchar(100) NOT NULL,  `defaultvalue` varchar(100) NOT NULL,  `minval` int(11) NOT NULL,  `maxval` int(11) NOT NULL,  `regex` varchar(150) NOT NULL,  `regkey` tinyint(3) NOT NULL,  `errortips` varchar(150) NOT NULL,  `uniqueness` tinyint(2) NOT NULL DEFAULT '1',  `isnessary` tinyint(2) NOT NULL DEFAULT '2',  `ismain` tinyint(2) NOT NULL DEFAULT '2',  `issearch` tinyint(2) NOT NULL DEFAULT '2',  `created` int(10) NOT NULL,  `modelid` int(11) NOT NULL,  `state` tinyint(2) NOT NULL,  PRIMARY KEY (`id`),  KEY `modelid` (`modelid`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='留言类别模型属性表';
DROP TABLE IF EXISTS mo_category;
CREATE TABLE `mo_category` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `pid` int(11) NOT NULL DEFAULT '0',  `catname` varchar(20) NOT NULL,  `model` int(11) NOT NULL,  `filepath` varchar(50) NOT NULL,  `indextpl` varchar(50) NOT NULL,  `columntpl` varchar(50) NOT NULL,  `contenttpl` varchar(50) NOT NULL,  `isnav` tinyint(2) NOT NULL,  `columnoption` tinyint(2) NOT NULL,  `dirpath` varchar(50) NOT NULL,  `columnattr` tinyint(2) NOT NULL,  `columncross` varchar(255) NOT NULL,  `crossid` varchar(1000) NOT NULL,  `ordernum` int(11) NOT NULL,  `seo_title` varchar(100) NOT NULL,  `seo_keywords` varchar(300) NOT NULL,  `seo_description` varchar(500) NOT NULL,  `content` text NOT NULL,  `created` int(10) NOT NULL,  PRIMARY KEY (`id`),  KEY `mo_category_catename` (`catname`(6)),  KEY `mo_category_index` (`seo_title`(10),`seo_keywords`(20),`seo_description`(20))) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COMMENT='栏目分类表';
DROP TABLE IF EXISTS mo_comment;
CREATE TABLE `mo_comment` (  `comment_id` int(11) NOT NULL AUTO_INCREMENT,  `comment_infoid` int(11) NOT NULL,  `comment_modelid` int(11) NOT NULL,  `comment_userid` int(11) NOT NULL,  `comment_content` text NOT NULL,  `comment_status` tinyint(2) NOT NULL DEFAULT '1',  `comment_time` int(10) NOT NULL,  `reply_isreply` tinyint(1) NOT NULL DEFAULT '2',  `reply_content` varchar(500) NOT NULL,  `reply_userid` int(11) NOT NULL,  `reply_time` int(10) NOT NULL,  PRIMARY KEY (`comment_id`),  KEY `mo_comment_index` (`comment_time`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='评论表';
DROP TABLE IF EXISTS mo_company;
CREATE TABLE `mo_company` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `model_id` int(11) DEFAULT NULL,  PRIMARY KEY (`id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='企业表';
DROP TABLE IF EXISTS mo_faillogin;
CREATE TABLE `mo_faillogin` (  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,  `username` varchar(50) NOT NULL,  `ip` varchar(50) NOT NULL,  `logintime` int(11) NOT NULL,  `num` tinyint(4) NOT NULL DEFAULT '1',  PRIMARY KEY (`id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='登录失败';
DROP TABLE IF EXISTS mo_field;
CREATE TABLE `mo_field` (  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,  `modelid` smallint(5) unsigned NOT NULL,  `field` varchar(255) NOT NULL,  `name` varchar(255) NOT NULL,  `fieldtype` varchar(255) NOT NULL,  `issystem` tinyint(2) NOT NULL DEFAULT '2',  `tips` varchar(255) NOT NULL,  `errortips` varchar(255) NOT NULL,  `emptytips` varchar(255) NOT NULL,  `defaultvalue` varchar(255) NOT NULL,  `maxlength` int(11) NOT NULL,  `minlength` int(11) NOT NULL,  `pattern` varchar(255) NOT NULL,  `isunique` tinyint(2) NOT NULL DEFAULT '2',  `isnull` tinyint(2) NOT NULL DEFAULT '2',  `issearch` tinyint(2) NOT NULL DEFAULT '1',  `sortid` tinyint(4) NOT NULL,  `addtime` int(11) NOT NULL,  `flag` tinyint(2) NOT NULL DEFAULT '1',  `ismain` tinyint(2) NOT NULL DEFAULT '2',  PRIMARY KEY (`id`),  KEY `model_field_id` (`modelid`)) ENGINE=MyISAM AUTO_INCREMENT=38 DEFAULT CHARSET=utf8 COMMENT='模型字段表';
DROP TABLE IF EXISTS mo_goods;
CREATE TABLE `mo_goods` (  `goodsid` int(11) NOT NULL AUTO_INCREMENT,  `goodssn` varchar(50) NOT NULL,  `goodsname` varchar(100) NOT NULL,  `subname` varchar(150) NOT NULL,  `categoryid` int(11) NOT NULL,  `sortid` int(11) NOT NULL,  `brandid` int(11) NOT NULL,  `is_sell` tinyint(1) NOT NULL DEFAULT '1',  `typeid` int(11) NOT NULL DEFAULT '0',  `userid` int(11) NOT NULL DEFAULT '0',  `hits` int(11) NOT NULL DEFAULT '0',  `isbest` tinyint(1) NOT NULL DEFAULT '2',  `isnew` tinyint(1) NOT NULL DEFAULT '2',  `ishot` tinyint(1) NOT NULL DEFAULT '2',  `isspecial` tinyint(1) NOT NULL DEFAULT '2',  `keywords` varchar(100) NOT NULL,  `brief` varchar(500) NOT NULL,  `content` text NOT NULL,  `marketprice` decimal(8,2) unsigned DEFAULT '0.00',  `shopprice` decimal(8,2) unsigned DEFAULT '0.00',  `unit` varchar(10) NOT NULL,  `publishtime` char(10) NOT NULL,  `publishopt` tinyint(1) NOT NULL DEFAULT '2',  `alowpower` varchar(500) NOT NULL DEFAULT '-1',  `iscomment` tinyint(1) NOT NULL DEFAULT '1',  `goodstpl` varchar(100) NOT NULL,  `modification` int(10) NOT NULL,  `created` int(10) NOT NULL,  PRIMARY KEY (`goodsid`),  KEY `mo_goods_index` (`goodsname`(6),`brandid`,`created`)) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='商品表';
DROP TABLE IF EXISTS mo_goods_album;
CREATE TABLE `mo_goods_album` (  `albumid` int(11) NOT NULL AUTO_INCREMENT,  `goodsid` int(11) NOT NULL,  `photo` varchar(150) NOT NULL,  `created` int(10) NOT NULL,  PRIMARY KEY (`albumid`)) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='商品相册表';
DROP TABLE IF EXISTS mo_goods_attr;
CREATE TABLE `mo_goods_attr` (  `attrid` int(11) NOT NULL AUTO_INCREMENT,  `attrname` varchar(30) NOT NULL,  `typeid` int(11) NOT NULL,  `ordernum` int(11) NOT NULL,  `fieldtype` tinyint(4) NOT NULL,  `fieldtips` varchar(200) NOT NULL,  `defaultvalue` varchar(500) NOT NULL,  `minvalue` int(11) NOT NULL,  `maxvalue` int(11) NOT NULL,  `uniqueness` tinyint(1) NOT NULL DEFAULT '2',  `issearch` tinyint(1) NOT NULL DEFAULT '2',  `enabled` tinyint(1) NOT NULL DEFAULT '1',  `created` int(10) NOT NULL,  PRIMARY KEY (`attrid`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='商品属性表';
DROP TABLE IF EXISTS mo_goods_attr_value;
CREATE TABLE `mo_goods_attr_value` (  `valueid` int(11) NOT NULL AUTO_INCREMENT,  `attrid` int(11) NOT NULL,  `value` varchar(500) NOT NULL,  `goodsid` int(11) NOT NULL,  `attr_price` varchar(100) NOT NULL,  PRIMARY KEY (`valueid`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='商品属性值表';
DROP TABLE IF EXISTS mo_goods_brand;
CREATE TABLE `mo_goods_brand` (  `brandid` int(11) NOT NULL AUTO_INCREMENT,  `brandname` varchar(50) NOT NULL,  `url` varchar(200) NOT NULL,  `logo` varchar(300) NOT NULL,  `brief` varchar(500) NOT NULL,  `created` int(10) NOT NULL,  PRIMARY KEY (`brandid`),  KEY `mo_goods_brand_brandname` (`brandname`(6))) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='商品品牌表';
DROP TABLE IF EXISTS mo_goods_link_goods;
CREATE TABLE `mo_goods_link_goods` (  `linkid` int(11) NOT NULL AUTO_INCREMENT,  `goodsid` int(11) NOT NULL,  `relgoodsid` int(11) NOT NULL,  `relation` tinyint(2) NOT NULL,  PRIMARY KEY (`linkid`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='商品关联表';
DROP TABLE IF EXISTS mo_goods_sort;
CREATE TABLE `mo_goods_sort` (  `sortid` int(11) NOT NULL AUTO_INCREMENT,  `pid` int(11) NOT NULL,  `sortname` varchar(50) NOT NULL,  `ordernum` int(11) NOT NULL,  `isdefault` tinyint(1) NOT NULL DEFAULT '2',  `created` int(10) NOT NULL,  PRIMARY KEY (`sortid`),  KEY `mo_goods_sort_sortname` (`sortname`(6))) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='商品分类表';
DROP TABLE IF EXISTS mo_goods_type;
CREATE TABLE `mo_goods_type` (  `typeid` int(11) NOT NULL AUTO_INCREMENT,  `typename` varchar(50) NOT NULL,  `status` tinyint(2) NOT NULL DEFAULT '1',  `attr_type` varchar(255) NOT NULL,  `created` int(10) NOT NULL,  PRIMARY KEY (`typeid`)) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='商品类型';
DROP TABLE IF EXISTS mo_guide;
CREATE TABLE `mo_guide` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `cid` int(11) NOT NULL,  `modelid` int(11) NOT NULL,  `ispage` int(4) NOT NULL DEFAULT '0',  `rows` int(11) DEFAULT NULL,  `pagesize` int(11) DEFAULT NULL,  `order` varchar(255) DEFAULT NULL,  `ordertype` varchar(255) DEFAULT NULL,  `content` varchar(1000) DEFAULT NULL,  `source` text NOT NULL,  `created` int(11) NOT NULL,  `updatetime` int(11) NOT NULL,  PRIMARY KEY (`id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='标签向导列表';
DROP TABLE IF EXISTS mo_imc_users;
CREATE TABLE `mo_imc_users` (  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,  `username` varchar(20) NOT NULL DEFAULT '',  `password` varchar(32) NOT NULL DEFAULT '',  `email` varchar(32) NOT NULL DEFAULT '',  `regip` varchar(15) NOT NULL DEFAULT '',  `regdate` int(11) unsigned NOT NULL DEFAULT '0',  `lastip` varchar(15) NOT NULL DEFAULT '0',  `lastdate` int(11) unsigned NOT NULL DEFAULT '0',  `updatedate` int(11) unsigned NOT NULL DEFAULT '0',  `appname` varchar(15) NOT NULL,  `status` tinyint(1) NOT NULL DEFAULT '0',  `isdel` tinyint(1) NOT NULL,  `isadmin` tinyint(1) NOT NULL,  `isimc` tinyint(1) NOT NULL,  PRIMARY KEY (`id`)) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='IMCenter用户表';
DROP TABLE IF EXISTS mo_link;
CREATE TABLE `mo_link` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `name` varchar(50) NOT NULL,  `logo` varchar(100) DEFAULT NULL,  `com_url` varchar(100) DEFAULT NULL,  `sort` int(11) NOT NULL DEFAULT '0',  `link_type` tinyint(1) NOT NULL,  `member` varchar(50) DEFAULT NULL,  `introduce` varchar(500) DEFAULT NULL,  PRIMARY KEY (`id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='友情链接';
DROP TABLE IF EXISTS mo_linkage;
CREATE TABLE `mo_linkage` (  `linkageid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,  `name` varchar(30) NOT NULL,  `style` varchar(35) NOT NULL,  `parentid` smallint(5) unsigned NOT NULL DEFAULT '0',  `keyid` smallint(5) unsigned NOT NULL DEFAULT '0',  `description` varchar(255) DEFAULT NULL,  `isglobal` tinyint(1) NOT NULL DEFAULT '1',  PRIMARY KEY (`linkageid`,`keyid`),  KEY `parentid` (`parentid`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='关联表';
DROP TABLE IF EXISTS mo_linkage_bill;
CREATE TABLE `mo_linkage_bill` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `lin_id` int(11) NOT NULL,  `pid` int(11) NOT NULL DEFAULT '0',  `name` varchar(20) NOT NULL,  `ordernum` int(11) NOT NULL,  `created` int(10) NOT NULL,  PRIMARY KEY (`id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='联动菜单表';
DROP TABLE IF EXISTS mo_mailstate;
CREATE TABLE `mo_mailstate` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `title` varchar(50) NOT NULL,  `userid` int(11) NOT NULL,  `username` varchar(50) NOT NULL,  `reciver` varchar(50) NOT NULL,  `state` tinyint(1) NOT NULL DEFAULT '0',  `sendtime` varchar(10) NOT NULL,  `errorinfor` varchar(8000) DEFAULT NULL,  `mailcontent` varchar(5000) DEFAULT NULL,  PRIMARY KEY (`id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='邮件状态';
DROP TABLE IF EXISTS mo_mailtemplate;
CREATE TABLE `mo_mailtemplate` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `theme` varchar(50) NOT NULL,  `content` varchar(500) NOT NULL,  `createtime` varchar(10) NOT NULL,  `flag` tinyint(1) NOT NULL,  PRIMARY KEY (`id`)) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='邮件模板';
DROP TABLE IF EXISTS mo_maintable;
CREATE TABLE `mo_maintable` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `categoryid` int(11) NOT NULL,  `title` varchar(150) NOT NULL,  `subtitle` varchar(300) NOT NULL,  `thumb` text NOT NULL,  `keywords` varchar(50) NOT NULL,  `description` varchar(250) NOT NULL,  `brief` varchar(1000) NOT NULL,  `source` varchar(300) NOT NULL,  `sorttype` int(11) NOT NULL DEFAULT '0',  `sortnum` int(11) NOT NULL,  `publishopt` tinyint(2) NOT NULL DEFAULT '1',  `publishtime` int(11) NOT NULL,  `hits` int(11) NOT NULL,  `publishuser` varchar(50) NOT NULL,  `username` varchar(50) NOT NULL,  `updatetime` int(10) NOT NULL,  `updateuser` varchar(50) NOT NULL,  `created` int(10) NOT NULL,  PRIMARY KEY (`id`)) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COMMENT='主表';
DROP TABLE IF EXISTS mo_manager_cate_per;
CREATE TABLE `mo_manager_cate_per` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `categoryid` int(11) NOT NULL,  `roleid` int(11) NOT NULL,  `permissionid` tinyint(2) NOT NULL,  PRIMARY KEY (`id`)) ENGINE=MyISAM AUTO_INCREMENT=73 DEFAULT CHARSET=utf8 COMMENT='管理员栏目操作权限表';
DROP TABLE IF EXISTS mo_member;
CREATE TABLE `mo_member` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `username` varchar(50) NOT NULL,  `password` varchar(50) NOT NULL,  `nickname` varchar(50) NOT NULL,  `email` varchar(50) NOT NULL,  `groupid` int(11) NOT NULL,  `levelid` int(11) NOT NULL,  `point` int(11) unsigned NOT NULL,  `totalpoint` int(11) unsigned NOT NULL,  `createtime` int(11) NOT NULL,  `createip` varchar(20) NOT NULL,  `lastloginip` varchar(20) NOT NULL,  `lastlogintime` int(11) NOT NULL,  `loginnum` int(11) NOT NULL,  `status` tinyint(4) NOT NULL,  `isdel` tinyint(4) NOT NULL,  PRIMARY KEY (`id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='会员信息表';
DROP TABLE IF EXISTS mo_member_1;
CREATE TABLE `mo_member_1` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `model_id` int(11) NOT NULL,  PRIMARY KEY (`id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='个人表单';
DROP TABLE IF EXISTS mo_member_2;
CREATE TABLE `mo_member_2` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `model_id` int(11) NOT NULL,  PRIMARY KEY (`id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='企业表单';
DROP TABLE IF EXISTS mo_member_cate_per;
CREATE TABLE `mo_member_cate_per` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `categoryid` int(11) NOT NULL,  `groupid` int(11) NOT NULL,  `permissionid` tinyint(2) NOT NULL,  PRIMARY KEY (`id`)) ENGINE=MyISAM AUTO_INCREMENT=37 DEFAULT CHARSET=utf8 COMMENT='会员栏目操作权限表';
DROP TABLE IF EXISTS mo_member_group;
CREATE TABLE `mo_member_group` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `groupname` varchar(50) NOT NULL,  `registerform` int(11) NOT NULL,  `registerdeal` int(11) NOT NULL,  `status` tinyint(4) NOT NULL,  `upgrade` tinyint(4) NOT NULL,  `regverify` tinyint(4) NOT NULL DEFAULT '0',  `mailverify` tinyint(4) NOT NULL DEFAULT '0',  PRIMARY KEY (`id`)) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 COMMENT='会员分组表';
DROP TABLE IF EXISTS mo_member_level;
CREATE TABLE `mo_member_level` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `groupid` int(11) NOT NULL,  `levelname` varchar(50) NOT NULL,  `point` int(11) NOT NULL,  `status` tinyint(4) NOT NULL,  PRIMARY KEY (`id`)) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='会员级别表';
DROP TABLE IF EXISTS mo_message_manage;
CREATE TABLE `mo_message_manage` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `title` varchar(150) NOT NULL,  `typeid` int(11) NOT NULL,  `message_id` int(11) NOT NULL,  `userid` int(11) NOT NULL,  `username` varchar(50) NOT NULL,  `replymember` int(11) NOT NULL,  `replytime` int(10) NOT NULL,  `isreply` tinyint(1) NOT NULL DEFAULT '2',  `ischeck` tinyint(1) NOT NULL DEFAULT '2',  `replayinfor` varchar(1000) DEFAULT '',  `leavetime` varchar(10) NOT NULL,  PRIMARY KEY (`id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='留言管理';
DROP TABLE IF EXISTS mo_mix_model;
CREATE TABLE `mo_mix_model` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `tablename` varchar(50) NOT NULL,  `name` varchar(50) NOT NULL,  `num` int(11) DEFAULT NULL,  `addtime` int(10) NOT NULL,  `count` int(11) DEFAULT NULL,  `forminfor` varchar(500) DEFAULT '',  `def` tinyint(1) NOT NULL DEFAULT '0',  `flag` tinyint(1) NOT NULL,  `state` tinyint(1) NOT NULL DEFAULT '2',  PRIMARY KEY (`id`)) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='会员及留言模型';
DROP TABLE IF EXISTS mo_model;
CREATE TABLE `mo_model` (  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,  `name` varchar(255) NOT NULL,  `tablename` varchar(255) NOT NULL,  `category_template` varchar(255) NOT NULL,  `list_template` varchar(255) NOT NULL,  `content_template` varchar(255) NOT NULL,  `sortid` tinyint(4) NOT NULL,  `addtime` int(11) NOT NULL,  `updatetime` int(11) NOT NULL,  `type` tinyint(2) NOT NULL DEFAULT '2',  `flag` tinyint(2) NOT NULL DEFAULT '1',  PRIMARY KEY (`id`),  UNIQUE KEY `tablename` (`tablename`)) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='模型表';
DROP TABLE IF EXISTS mo_msg_message;
CREATE TABLE `mo_msg_message` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `title` varchar(100) NOT NULL,  `content` text NOT NULL,  `created` int(10) NOT NULL,  PRIMARY KEY (`id`),  KEY `mo_msg_message_index` (`title`(10),`created`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='站内信表';
DROP TABLE IF EXISTS mo_msg_relation;
CREATE TABLE `mo_msg_relation` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `msgid` int(11) NOT NULL,  `recipients` int(11) NOT NULL,  `senderid` int(11) NOT NULL,  `isread` tinyint(2) NOT NULL DEFAULT '2',  `isreply` tinyint(2) NOT NULL DEFAULT '2',  `recipients_del` tinyint(2) NOT NULL DEFAULT '2',  `sender_del` tinyint(2) NOT NULL DEFAULT '2',  `created` int(10) NOT NULL,  PRIMARY KEY (`id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='站内信关系表';
DROP TABLE IF EXISTS mo_offer;
CREATE TABLE `mo_offer` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `maintable_id` int(11) NOT NULL,  `content` text NOT NULL,  `template` varchar(150) NOT NULL,  `readpower` varchar(255) NOT NULL,  `allowcomment` tinyint(2) NOT NULL DEFAULT '1',  `offer_time` varchar(255) DEFAULT '',  `offer_style` varchar(255) DEFAULT '',  `offer_sample` varchar(255) DEFAULT '',  `offer_place` varchar(255) DEFAULT '',  `offer_price` varchar(255) DEFAULT '',  PRIMARY KEY (`id`)) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS mo_payment;
CREATE TABLE `mo_payment` (  `pay_id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,  `pay_code` varchar(20) NOT NULL DEFAULT '',  `pay_name` varchar(120) NOT NULL DEFAULT '',  `pay_fee` varchar(10) NOT NULL DEFAULT '0',  `pay_desc` text NOT NULL,  `pay_order` tinyint(3) unsigned NOT NULL DEFAULT '0',  `pay_config` text NOT NULL,  `enabled` tinyint(1) unsigned NOT NULL DEFAULT '0',  `is_cod` tinyint(1) unsigned NOT NULL DEFAULT '0',  `is_online` tinyint(1) unsigned NOT NULL DEFAULT '0',  `website` varchar(100) NOT NULL,  `version` varchar(20) NOT NULL,  PRIMARY KEY (`pay_id`),  UNIQUE KEY `pay_code` (`pay_code`)) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='支付功能相关';
DROP TABLE IF EXISTS mo_person;
CREATE TABLE `mo_person` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `model_id` int(11) DEFAULT NULL,  PRIMARY KEY (`id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='个人表';
DROP TABLE IF EXISTS mo_position;
CREATE TABLE `mo_position` (  `pos_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,  `model_id` smallint(5) unsigned DEFAULT '0',  `cat_id` smallint(5) unsigned DEFAULT '0',  `name` char(100) NOT NULL DEFAULT '',  `alter_time` int(10) unsigned NOT NULL DEFAULT '0',  `special` tinyint(1) unsigned NOT NULL DEFAULT '0',  `max_num` char(10) NOT NULL DEFAULT '',  PRIMARY KEY (`pos_id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='推荐位';
DROP TABLE IF EXISTS mo_position_info;
CREATE TABLE `mo_position_info` (  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,  `headline` char(30) NOT NULL DEFAULT '',  `cat_id` smallint(5) unsigned NOT NULL DEFAULT '0',  `ag_id` mediumint(8) unsigned NOT NULL DEFAULT '0',  `pos_id` smallint(5) unsigned NOT NULL DEFAULT '0',  `model_id` smallint(6) unsigned DEFAULT '0',  `alter_time` int(10) unsigned NOT NULL DEFAULT '0',  `sortby` mediumint(8) DEFAULT '0',  `pos_img` varchar(200) NOT NULL DEFAULT '',  `pos_info` mediumtext,  PRIMARY KEY (`id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='推荐位数据表';
DROP TABLE IF EXISTS mo_registdeal;
CREATE TABLE `mo_registdeal` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `name` varchar(100) NOT NULL,  `iseffect` tinyint(1) NOT NULL,  `content` varchar(8000) NOT NULL,  PRIMARY KEY (`id`)) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='注册协议';
DROP TABLE IF EXISTS mo_remind;
CREATE TABLE `mo_remind` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `tpl_name` varchar(50) NOT NULL,  `tpl_path` varchar(100) NOT NULL,  `remind_type` tinyint(1) NOT NULL DEFAULT '2',  `status` tinyint(1) NOT NULL DEFAULT '2',  `created` int(10) NOT NULL,  PRIMARY KEY (`id`)) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='提醒设置表';
DROP TABLE IF EXISTS mo_scores_rule;
CREATE TABLE `mo_scores_rule` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `app` int(11) NOT NULL,  `ratio1` smallint(5) NOT NULL,  `ratio2` smallint(5) NOT NULL,  `created` int(10) NOT NULL,  PRIMARY KEY (`id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='积分规则表';
DROP TABLE IF EXISTS mo_search;
CREATE TABLE `mo_search` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `keywords` varchar(150) NOT NULL,  `nums` int(11) NOT NULL,  PRIMARY KEY (`id`),  UNIQUE KEY `keywords` (`keywords`)) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='搜索表';
DROP TABLE IF EXISTS mo_site_log;
CREATE TABLE `mo_site_log` (  `log_id` int(10) unsigned NOT NULL AUTO_INCREMENT,  `log_time` int(10) unsigned NOT NULL DEFAULT '0',  `user_id` tinyint(3) unsigned NOT NULL DEFAULT '0',  `admin_name` varchar(20) NOT NULL DEFAULT '',  `remark` varchar(255) NOT NULL DEFAULT '',  `operation` varchar(20) NOT NULL DEFAULT '',  `ip_address` varchar(15) NOT NULL DEFAULT '',  PRIMARY KEY (`log_id`),  KEY `log_time` (`log_time`),  KEY `user_id` (`user_id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='网站关联系统日志';
DROP TABLE IF EXISTS mo_synchronize;
CREATE TABLE `mo_synchronize` (  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,  `name` varchar(120) NOT NULL DEFAULT '',  `appkey` varchar(120) NOT NULL DEFAULT '',  `secret` varchar(120) NOT NULL DEFAULT '',  `description` text NOT NULL,  `config` text NOT NULL,  `enabled` tinyint(1) unsigned NOT NULL DEFAULT '0',  PRIMARY KEY (`id`)) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='同步登录配置表';
DROP TABLE IF EXISTS mo_upgrade_log;
CREATE TABLE `mo_upgrade_log` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `name` varchar(20) NOT NULL,  `version` varchar(10) NOT NULL,  `suit_version` varchar(30) NOT NULL,  `description` varchar(500) NOT NULL,  `charset` varchar(20) NOT NULL,  `technology` varchar(200) NOT NULL,  `author_name` varchar(20) NOT NULL,  `author_email` varchar(30) NOT NULL,  `upgrade_time` int(10) NOT NULL,  PRIMARY KEY (`id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='升级日志表';
DROP TABLE IF EXISTS mo_web_config;
CREATE TABLE `mo_web_config` (  `par_id` smallint(8) unsigned NOT NULL DEFAULT '0',  `par_name` varchar(100) NOT NULL DEFAULT '',  `info` varchar(100) NOT NULL DEFAULT '',  `group_id` smallint(6) NOT NULL DEFAULT '1',  `par_type` varchar(10) NOT NULL DEFAULT 'string',  `par_value` text,  PRIMARY KEY (`par_name`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='网站各基本参数配置';
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('1','1371783837','admin','成功登录后台','登录后台','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('2','1371797233','admin','成功登录后台','登录后台','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('3','1371798047','admin','修改站点设置','网站设置','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('4','1371799220','admin','修改站点设置','网站设置','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('5','1371799298','admin','增加了新栏目：新闻动态','添加了新栏目','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('6','1371800571','admin','增加了新栏目：作品案例','添加了新栏目','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('7','1371800835','admin','添加了模型套系报价','添加模型','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('8','1372039261','admin','成功登录后台','登录后台','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('9','1372066959','admin','成功登录后台','登录后台','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('10','1372123922','admin','成功登录后台','登录后台','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('11','1372123967','admin','添加商品属性fsdf','添加商品属性','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('12','1372143103','admin','添加了字段拍摄时间','添加字段','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('13','1372144058','admin','添加了字段礼服造型','添加字段','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('14','1372144080','admin','添加了字段拍摄样片','添加字段','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('15','1372144096','admin','添加了字段拍摄地点','添加字段','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('16','1372144112','admin','添加了字段套系价格','添加字段','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('17','1372149430','admin','成功登录后台','登录后台','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('18','1372150988','admin','增加了新栏目：套系报价','添加了新栏目','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('19','1372151065','admin','增加了新栏目：关于我们','添加了新栏目','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('20','1372155823','admin','替换了模板default','替换模板','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('21','1372156267','admin','替换了模板default','替换模板','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('22','1372214712','admin','成功登录后台','登录后台','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('23','1372225777','admin','成功登录后台','登录后台','192.168.3.95');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('24','1372225949','admin','添加了文章巴黎婚纱婚博会，省钱计划——合伙占便宜','添加文章','192.168.3.95');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('25','1372226029','admin','修改了文章巴黎婚纱婚博会，省钱计划——合伙占便宜','修改文章','192.168.3.95');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('26','1372226231','admin','修改了文章巴黎婚纱婚博会，省钱计划——合伙占便宜','修改文章','192.168.3.95');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('27','1372730508','admin','成功登录后台','登录后台','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('28','1372736083','admin','添加了内容婚纱礼服着装技巧穿出你的时尚范儿(1)','添加内容','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('29','1372745526','admin','成功登录后台','登录后台','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('30','1372745892','admin','添加了内容低碳婚礼进行中租赁可循环再用婚纱','添加内容','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('31','1372747595','admin','添加了内容夏天拍婚纱照如何选择合适的婚纱照服装','添加内容','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('32','1372747595','admin','添加了内容夏天拍婚纱照如何选择合适的婚纱照服装','添加内容','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('33','1372747616','admin','修改了夏天拍婚纱照如何选择合适的婚纱照服装','修改内容','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('34','1372747657','admin','修改了巴黎婚纱婚博会，省钱计划——合伙占便宜','修改内容','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('35','1372747684','admin','修改了婚纱礼服着装技巧穿出你的时尚范儿(1)','修改内容','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('36','1372747708','admin','修改了低碳婚礼进行中租赁可循环再用婚纱','修改内容','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('37','1372747720','admin','修改了夏天拍婚纱照如何选择合适的婚纱照服装','修改内容','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('38','1372747730','admin','修改了夏天拍婚纱照如何选择合适的婚纱照服装','修改内容','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('39','1372747748','admin','修改了巴黎婚纱婚博会，省钱计划——合伙占便宜','修改内容','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('40','1372748626','admin','添加了内容特惠婚纱套系','添加内容','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('41','1372748761','admin','添加了内容定制婚纱套系','添加内容','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('42','1372749036','admin','添加了内容高级婚纱套系','添加内容','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('43','1372749152','admin','添加了内容华贵婚纱套系','添加内容','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('44','1372749252','admin','添加了内容尊贵婚纱套系','添加内容','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('45','1372750831','admin','添加了商品:伴娘的春天','添加商品','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('46','1372987725','admin','成功登录后台','登录后台','192.168.3.95');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('47','1372988532','admin','添加了商品:伴娘的春天1','添加商品','192.168.3.95');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('48','1372988582','admin','修改了商品:伴娘的春天1','修改商品','192.168.3.95');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('49','1372993617','admin','成功登录后台','登录后台','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('50','1372994462','admin','添加首页广告1广告位','添加广告位','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('51','1372994495','admin','添加首页广告1广告','添加广告','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('52','1372994852','admin','添加ad2广告位','添加广告位','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('53','1372994876','admin','添加ad3广告位','添加广告位','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('54','1372994898','admin','添加ad4广告位','添加广告位','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('55','1372994913','admin','添加ad2广告','添加广告','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('56','1372994991','admin','修改首页广告1广告','修改广告','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('57','1372995000','admin','修改ad2广告','修改广告','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('58','1372995018','admin','添加ad3广告','添加广告','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('59','1372995033','admin','添加ad4广告','添加广告','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('60','1372995272','admin','增加了新栏目：最新动态','添加了新栏目','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('61','1372995293','admin','增加了新栏目：业界资讯','添加了新栏目','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('62','1372995311','admin','增加了新栏目：婚纱摄影','添加了新栏目','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('63','1372995327','admin','增加了新栏目：婚礼指南','添加了新栏目','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('64','1372995348','admin','增加了新栏目：婚饰礼品','添加了新栏目','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('65','1372995361','admin','修改了栏目：婚纱摄影','修改了栏目','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('66','1372995370','admin','修改了栏目：婚礼指南','修改了栏目','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('67','1373002232','admin','增加了新栏目：室内婚纱','添加了新栏目','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('68','1373002248','admin','增加了新栏目：室外婚纱','添加了新栏目','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('69','1373004612','admin','成功登录后台','登录后台','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('70','1373004628','admin','增加了新栏目：明星艺人','添加了新栏目','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('71','1373012122','admin','成功登录后台','登录后台','192.168.3.49');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('72','1373012317','admin','修改首页广告1广告','修改广告','192.168.3.49');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('73','1373012362','admin','修改ad2广告','修改广告','192.168.3.49');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('74','1373012397','admin','成功登录后台','登录后台','192.168.3.63');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('75','1373012399','admin','修改了文章夏天拍婚纱照如何选择合适的婚纱照服装','修改文章','192.168.3.49');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('76','1373012434','admin','修改了文章夏天拍婚纱照如何选择合适的婚纱照服装','修改文章','192.168.3.49');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('77','1373012444','admin','修改了文章低碳婚礼进行中租赁可循环再用婚纱','修改文章','192.168.3.49');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('78','1373012460','admin','修改了文章婚纱礼服着装技巧穿出你的时尚范儿(1)','修改文章','192.168.3.49');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('79','1373012472','admin','修改了文章巴黎婚纱婚博会，省钱计划——合伙占便宜','修改文章','192.168.3.49');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('80','1373012488','admin','修改了文章巴黎婚纱婚博会，省钱计划——合伙占便宜','修改文章','192.168.3.49');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('81','1373012505','admin','修改了文章婚纱礼服着装技巧穿出你的时尚范儿(1)','修改文章','192.168.3.49');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('82','1373012516','admin','修改了文章低碳婚礼进行中租赁可循环再用婚纱','修改文章','192.168.3.49');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('83','1373015513','admin','成功登录后台','登录后台','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('84','1373016810','admin','成功登录后台','登录后台','192.168.3.95');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('85','1373016924','admin','修改了关于我们','修改内容','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('86','1373018104','admin','增加了新栏目：test','添加了新栏目','192.168.3.95');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('87','1373245979','admin','成功登录后台','登录后台','192.168.3.95');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('88','1373341493','admin','成功登录后台','登录后台','192.168.3.128');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('89','1373351107','admin','修改ad3广告','修改广告','192.168.3.128');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('90','1373351155','admin','修改ad4广告','修改广告','192.168.3.128');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('91','1373418375','admin','成功登录后台','登录后台','192.168.3.95');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('92','1373418633','admin','删除了栏目：test','删除了栏目','192.168.3.95');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('93','1373418735','admin','增加了新栏目：加入我们','添加了新栏目','192.168.3.95');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('94','1373418880','admin','添加了商品:伴娘的春天2','添加商品','192.168.3.95');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('95','1373420028','admin','成功登录后台','登录后台','192.168.3.128');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('96','1373421662','admin','成功登录后台','登录后台','192.168.3.59');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('97','1373423620','admin','成功登录后台','登录后台','192.168.3.59');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('98','1373438262','admin','成功登录后台','登录后台','192.168.3.59');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('99','1373605829','admin','成功登录后台','登录后台','192.168.3.95');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('100','1373605838','admin','修改站点设置','网站设置','192.168.3.95');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('101','1373606177','admin','修改站点设置','网站设置','192.168.3.95');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('102','1373607390','admin','成功登录后台','登录后台','192.168.3.128');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('103','1373607435','admin','成功登录后台','登录后台','192.168.3.95');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('104','1373621007','admin','成功登录后台','登录后台','192.168.3.128');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('105','1373621039','admin','修改了栏目：站点地图','修改了栏目','192.168.3.128');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('106','1373621591','admin','添加了内容广告服务','添加内容','192.168.3.128');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('107','1373621739','admin','修改了广告服务','修改内容','192.168.3.128');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('108','1373622070','admin','添加了内容联系我们','添加内容','192.168.3.128');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('109','1373622107','admin','添加了内容版权所有','添加内容','192.168.3.128');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('110','1373622161','admin','修改了栏目：站点地图','修改了栏目','192.168.3.128');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('111','1373622776','admin','成功登录后台','登录后台','192.168.3.63');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('112','1373623223','admin','修改了特惠婚纱套系','修改内容','192.168.3.128');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('113','1373848346','admin','成功登录后台','登录后台','192.168.3.127');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('114','1373959834','admin','成功登录后台','登录后台','192.168.3.63');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('115','1374142042','admin','成功登录后台','登录后台','192.168.3.95');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('116','1374142087','admin','修改站点设置','网站设置','192.168.3.95');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('117','1374142219','admin','修改站点设置','网站设置','192.168.3.95');
INSERT INTO `mo_admin_log` (`log_id`,`log_time`,`admin_name`,`log_info`,`module_name`,`ip_address`) VALUES ('118','1376533127','admin','成功登录后台','登录后台','192.168.3.95');
INSERT INTO `mo_adposition` (`id`,`adname`,`adtypeid`,`adtypename`,`useclumn`,`clumnname`,`adpos`,`pos`,`adsize`,`adnum`,`fontnum`,`addescript`) VALUES ('1','首页广告1','6','图片广告','0','不限栏目',',','1','246,339','1','0','');
INSERT INTO `mo_adposition` (`id`,`adname`,`adtypeid`,`adtypename`,`useclumn`,`clumnname`,`adpos`,`pos`,`adsize`,`adnum`,`fontnum`,`addescript`) VALUES ('2','ad2','6','图片广告','0','不限栏目',',','1','960,200','1','0','');
INSERT INTO `mo_adposition` (`id`,`adname`,`adtypeid`,`adtypename`,`useclumn`,`clumnname`,`adpos`,`pos`,`adsize`,`adnum`,`fontnum`,`addescript`) VALUES ('3','ad3','6','图片广告','0','不限栏目',',','1','230,300','1','0','');
INSERT INTO `mo_adposition` (`id`,`adname`,`adtypeid`,`adtypename`,`useclumn`,`clumnname`,`adpos`,`pos`,`adsize`,`adnum`,`fontnum`,`addescript`) VALUES ('4','ad4','6','图片广告','0','不限栏目',',','1','230,298','1','0','');
INSERT INTO `mo_adtype` (`id`,`typename`,`typefilename`,`state`,`attribute`,`adposition`,`adsize`,`adtime`,`adtype`,`wordnum`,`wordeffect`,`closeefftct`,`adnum`) VALUES ('1','对联广告','couplet','1','1','2','2','2','1,3','2','0','0','0');
INSERT INTO `mo_adtype` (`id`,`typename`,`typefilename`,`state`,`attribute`,`adposition`,`adsize`,`adtime`,`adtype`,`wordnum`,`wordeffect`,`closeefftct`,`adnum`) VALUES ('3','轮播广告','change','1','0','1','1','1','1','5','0','0','0');
INSERT INTO `mo_adtype` (`id`,`typename`,`typefilename`,`state`,`attribute`,`adposition`,`adsize`,`adtime`,`adtype`,`wordnum`,`wordeffect`,`closeefftct`,`adnum`) VALUES ('4','文字广告','word','1','0','1','0','1','3','6','1','1','0');
INSERT INTO `mo_adtype` (`id`,`typename`,`typefilename`,`state`,`attribute`,`adposition`,`adsize`,`adtime`,`adtype`,`wordnum`,`wordeffect`,`closeefftct`,`adnum`) VALUES ('5','背投广告','back','1','0','0','1','1','1,2','1','0','0','0');
INSERT INTO `mo_adtype` (`id`,`typename`,`typefilename`,`state`,`attribute`,`adposition`,`adsize`,`adtime`,`adtype`,`wordnum`,`wordeffect`,`closeefftct`,`adnum`) VALUES ('6','图片广告','imagechange','1','0','1','1','1','1','1','0','0','1');
INSERT INTO `mo_adtype` (`id`,`typename`,`typefilename`,`state`,`attribute`,`adposition`,`adsize`,`adtime`,`adtype`,`wordnum`,`wordeffect`,`closeefftct`,`adnum`) VALUES ('7','翻卷广告','turnup','1','0','1','1','1','1','1','0','0','0');
INSERT INTO `mo_adtype` (`id`,`typename`,`typefilename`,`state`,`attribute`,`adposition`,`adsize`,`adtime`,`adtype`,`wordnum`,`wordeffect`,`closeefftct`,`adnum`) VALUES ('8','全屏广告','fullscreen','1','0','1','1','1','1,2','1','0','0','3');
INSERT INTO `mo_adtype` (`id`,`typename`,`typefilename`,`state`,`attribute`,`adposition`,`adsize`,`adtime`,`adtype`,`wordnum`,`wordeffect`,`closeefftct`,`adnum`) VALUES ('9','弹窗广告','adwindow','1','0','1','1','2','1,2','1','0','0','0');
INSERT INTO `mo_adtype` (`id`,`typename`,`typefilename`,`state`,`attribute`,`adposition`,`adsize`,`adtime`,`adtype`,`wordnum`,`wordeffect`,`closeefftct`,`adnum`) VALUES ('2','漂浮广告','float','1','0','0','1','1','1,2','1','0','0','0');
INSERT INTO `mo_advert` (`id`,`adtitle`,`adpositionid`,`timetype`,`addtime`,`starttime`,`endtime`,`sort`,`clicknum`,`adimg`) VALUES ('1','首页广告1','1','1','1372994495','0','0','0','0','YToxOntpOjA7YTozOntzOjQ6ImxpbmsiO3M6NTM6Imh0dHA6Ly9uZXc0LmIyYi5tYWlub25lLmNuL2NvbnRlbnQvQ29udGVudC9pbmRleC9pZC82IjtzOjQ6ImZvbnQiO3M6MDoiIjtzOjM6ImltZyI7YTo5OntzOjg6InNlbGZuYW1lIjtzOjc6ImFkMS5qcGciO3M6MTE6InRyZW5kc19wYXRoIjtzOjc6IjIwMTNfMDciO3M6NDoicGF0aCI7czozNDoiMjAxM18wNy8yMDEzMDcwNTAzMjEzNV8xNjY1XzU3LmpwZyI7czo1OiJ3aWR0aCI7aToyNDY7czo2OiJoZWlnaHQiO2k6MzM5O3M6NDoic2l6ZSI7ZDo0MjtzOjk6ImV4dGVuc2lvbiI7czozOiJqcGciO3M6NjoiZm9sZGVyIjtzOjY6ImFkdmVydCI7czo4OiJmaWxlbmFtZSI7czoyNjoiMjAxMzA3MDUwMzIxMzVfMTY2NV81Ny5qcGciO319fQ==');
INSERT INTO `mo_advert` (`id`,`adtitle`,`adpositionid`,`timetype`,`addtime`,`starttime`,`endtime`,`sort`,`clicknum`,`adimg`) VALUES ('2','ad2','2','1','1372994913','0','0','0','0','YToxOntpOjA7YTozOntzOjQ6ImxpbmsiO3M6NTM6Imh0dHA6Ly9uZXc0LmIyYi5tYWlub25lLmNuL2NvbnRlbnQvQ29udGVudC9pbmRleC9pZC83IjtzOjQ6ImZvbnQiO3M6MDoiIjtzOjM6ImltZyI7YTo5OntzOjg6InNlbGZuYW1lIjtzOjc6ImFkMi5qcGciO3M6MTE6InRyZW5kc19wYXRoIjtzOjc6IjIwMTNfMDciO3M6NDoicGF0aCI7czozNDoiMjAxM18wNy8yMDEzMDcwNTAzMjgzM180MzcxXzE4LmpwZyI7czo1OiJ3aWR0aCI7aTo5NjA7czo2OiJoZWlnaHQiO2k6MjAwO3M6NDoic2l6ZSI7ZDo4MjtzOjk6ImV4dGVuc2lvbiI7czozOiJqcGciO3M6NjoiZm9sZGVyIjtzOjY6ImFkdmVydCI7czo4OiJmaWxlbmFtZSI7czoyNjoiMjAxMzA3MDUwMzI4MzNfNDM3MV8xOC5qcGciO319fQ==');
INSERT INTO `mo_advert` (`id`,`adtitle`,`adpositionid`,`timetype`,`addtime`,`starttime`,`endtime`,`sort`,`clicknum`,`adimg`) VALUES ('3','ad3','3','1','1372995018','0','0','0','0','YToxOntpOjA7YTozOntzOjQ6ImxpbmsiO3M6NTM6Imh0dHA6Ly9uZXc0LmIyYi5tYWlub25lLmNuL2NvbnRlbnQvQ29udGVudC9pbmRleC9pZC81IjtzOjQ6ImZvbnQiO3M6MDoiIjtzOjM6ImltZyI7YTo5OntzOjg6InNlbGZuYW1lIjtzOjc6ImFkMy5qcGciO3M6MTE6InRyZW5kc19wYXRoIjtzOjc6IjIwMTNfMDciO3M6NDoicGF0aCI7czozNDoiMjAxM18wNy8yMDEzMDcwNTAzMzAxOF8zOTYyXzkxLmpwZyI7czo1OiJ3aWR0aCI7aToyMzA7czo2OiJoZWlnaHQiO2k6MzAwO3M6NDoic2l6ZSI7ZDozMztzOjk6ImV4dGVuc2lvbiI7czozOiJqcGciO3M6NjoiZm9sZGVyIjtzOjY6ImFkdmVydCI7czo4OiJmaWxlbmFtZSI7czoyNjoiMjAxMzA3MDUwMzMwMThfMzk2Ml85MS5qcGciO319fQ==');
INSERT INTO `mo_advert` (`id`,`adtitle`,`adpositionid`,`timetype`,`addtime`,`starttime`,`endtime`,`sort`,`clicknum`,`adimg`) VALUES ('4','ad4','4','1','1372995033','0','0','0','0','YToxOntpOjA7YTozOntzOjQ6ImxpbmsiO3M6NDg6Imh0dHA6Ly9uZXc0LmIyYi5tYWlub25lLmNuL2dvb2RzL0dvb2RzL2luZm8vaWQvMSI7czo0OiJmb250IjtzOjA6IiI7czozOiJpbWciO2E6OTp7czo4OiJzZWxmbmFtZSI7czo3OiJhZDQuanBnIjtzOjExOiJ0cmVuZHNfcGF0aCI7czo3OiIyMDEzXzA3IjtzOjQ6InBhdGgiO3M6MzQ6IjIwMTNfMDcvMjAxMzA3MDUwMzMwMzNfODc0MF82Ni5qcGciO3M6NToid2lkdGgiO2k6MjMwO3M6NjoiaGVpZ2h0IjtpOjI5ODtzOjQ6InNpemUiO2Q6MzE7czo5OiJleHRlbnNpb24iO3M6MzoianBnIjtzOjY6ImZvbGRlciI7czo2OiJhZHZlcnQiO3M6ODoiZmlsZW5hbWUiO3M6MjY6IjIwMTMwNzA1MDMzMDMzXzg3NDBfNjYuanBnIjt9fX0=');
INSERT INTO `mo_article` (`id`,`maintable_id`,`content`,`template`,`readpower`,`allowcomment`) VALUES ('1','1','<pstyle="text-align:center;">&nbsp;</p><p>巴黎婚纱6月省钱计划，与一群志同道合的人，快乐地做一件幸福的事情，只要你的参与，力量才是最大的。</p><p>让所有的新人们一起在这个夏季的到来前，抢先入手超值的婚博会专享套系，这个便宜你赚到了吗？</p><p>三大省钱计划&mdash;&mdash;&mdash;&mdash;你进店，我组团！（合伙就有大便宜）<br/>1.省：爱情基金：300抵500<br/>2.省：点评返现金200元<br/>3.省：8000元爱情彩礼</p><p>活动时间：2013年6月10日-2013年6月30日（期间每逢周一、周三）</p>','content_contact.html','','1');
INSERT INTO `mo_article` (`id`,`maintable_id`,`content`,`template`,`readpower`,`allowcomment`) VALUES ('2','2','<p>　　不管你是婚礼上的主角还是配角，这里都为您准备了各种最全面最时尚的婚礼着装技巧，教你穿出时尚范儿！</p><p><br/>&nbsp;　　新娘</p><p><br/>&nbsp;　　新娘结婚的当天一般要准备4~5套服装，包括两套白色婚纱和两套到三套的礼服，一套婚纱用于新郎到新娘家接新娘用，另一套用于在婚宴上接待宾客和婚宴开始阶段用，礼服用于婚宴当天进酒和其他环节用，颜色可以根据新娘的喜爱挑选，一般以金色、天蓝、粉色为主，同时可以准备一款中式的旗袍。</p><p><br/>&nbsp;　　注意事项：</p><p><br/>&nbsp;　　新娘的婚纱一般一套为拖地婚纱，用于婚宴；另一套应为正好盖过脚背的婚纱，用于结婚当天的早上，这样可以方便走动，另礼服也应该不选择拖地款式，因为婚宴要走动，拖地式不方便，而且容易被踩住，造成危险。</p><p><br/>&nbsp;　　新郎</p><p><br/>&nbsp;　　新郎的服装相对比较简单，大体上以黑白西装为主，领带以红色为主，突出喜庆的色彩，衬衫以白色为最佳，当然可以根据自己的喜好选择，不过不可过于艳色。</p><p><br/>&nbsp;　　注意事项：</p><p><br/>&nbsp;　　新郎的服装虽然相对比较简单，但色彩上的搭配还是要注意，西装的色彩以黑、白、灰三色为最佳，千万不要选择一款色彩过于艳丽的西装，例如暗红色，这样会显得很土，只要领带的色彩为红色即可。</p><p><br/>&nbsp;　　伴娘</p><p><br/>&nbsp;　　伴娘的礼服一般都会事前挑选好，一般新娘会帮伴娘准备服装，如果没有，伴娘要事前准备好服装，一般以小礼服为主，款式要简洁大气一点，千万不要选择拖地或则让自己有寸步难行的感觉的，因为伴娘当天要陪伴在新娘的身边。</p><p><br/>&nbsp;　　注意事项：</p><p><br/>&nbsp;　　伴娘的服装一定要简洁大气，不要抢了新娘的风头，色彩以粉色、米白色、蓝色、紫色为主，不要穿过于鲜亮的色彩，只要显得大方得体即可，记住这天的主角不是你，而是新娘。</p><p><br/>&nbsp;　　伴郎</p><p><br/>&nbsp;　　伴郎的服装也比较简单，基本以黑色为主，不要选择白色，因为白色比较显眼，适合新郎穿，伴郎西装的色彩要显得稳重即可，千万不要挑选其他个性的色彩，会让人觉得在抢新郎的风头。</p>','content_news.html','','1');
INSERT INTO `mo_article` (`id`,`maintable_id`,`content`,`template`,`readpower`,`allowcomment`) VALUES ('3','3','<p>　　北方网讯记者刘延春报道运用可循环再用的婚纱，婚宴上用其他食品替代鱼翅、燕窝，乃至要在婚礼上实行不离婚的&ldquo;低碳答应&rdquo;&mdash;&mdash;全港&ldquo;可连续&rdquo;环保婚礼大举动2010日前启动，边疆第一站即选择了深圳，下一站将到上海，三地各将召集100对新人及约请100间婚嫁商户参与本次活动。</p><p><br/>&nbsp;　　&ldquo;低碳婚礼，我们是地球首推！&rdquo;据香港婚礼管理协会会长邝虹女士说明，婚嫁行业触及到酒店、婚纱礼服、汽车、房屋装修等40余个行业，因而引导大众自发选择节能环保、低碳排放的消费形式意义严重。据说明，该活动在&ldquo;衣食住行&rdquo;等方面创意的环保婚礼元素包括：运用可循环再用的婚纱，或改用窗帘布、被单等来做婚纱；倡导无翅菜单，用其他食物顶替燕窝等；新居装修运用低碳油漆、低碳灯灯环保资料；婚车用脚踏车替代奢华大排量轿车等。</p><p><br/>&nbsp;　　婚礼实行曲也可低碳？对此香港婚礼管理协会会长邝虹说明，&ldquo;低碳婚曲&rdquo;是香港词曲人张佳添之作，但并非歌词意义上的低碳，而究竟此是哪些层面的低碳，其称6月26日将会在香港揭晓机密。另据说明，港、深、沪三地各召集的100对新人还要在低碳婚礼上作出答应：除了要确保婚后运用环保用品、践行低碳生活外，还要答应彼此相爱终身，由于&ldquo;不离婚更是低碳婚礼&rdquo;。</p>','content_news.html','','1');
INSERT INTO `mo_article` (`id`,`maintable_id`,`content`,`template`,`readpower`,`allowcomment`) VALUES ('4','4','<p>&nbsp;&nbsp;三伏天到了，拍婚纱照可是一件辛苦事！然而婚期既定，这婚纱照如果不拍，那是无论如何说不过去的！那么，在炎热的夏天，想拍婚纱照的新娘，应该选择什么样的婚纱照服装才可以免受酷热之苦呢？<br/>　　第一、要选择前短后长款的婚纱</p><p>　　款式更为清凉简约的婚纱，可以避免让整个婚纱包裹住自己，这样就不会透不过气！婚纱前半部分是中裙甚至短裙的设计，能完美展示新娘的修长美腿和精心挑选的婚鞋，而后面的传统拖摆婚纱设计，则仍旧使这款前短后长的婚纱带有隆重的仪式感！</p><p>　　第二、夏天亮色系的服装最受欢迎</p><p>　　亮丽的颜色是夏天的符号，春夏婚纱礼服颜色最亮丽，春夏流行色系，如裸色、橙色、黄色等颜色会将新娘子青春靓丽美好曼妙的一面完全地展现出来，绝对是值得一试的！用心搭配出来的多彩婚纱，充满创意的色彩概念，这样的婚纱照，岂不是让你如此与众不同？！</p><p>　　当然，要穿上五彩缤纷的流行色婚纱拍照，也要注意衣服颜色和自己的肤色是否搭配，还有发型发色的协调也是非常重要的！</p><p>　　第三、如何选择婚纱照服装的质地</p><p>　　在如此炎热的夏天，一切衣着都以清凉为前提，因此，婚纱也是如此！一定要尽量选择质地轻薄、做工简约的婚纱，轻纱裹体，新娘子曼妙身材也能展露无遗，气质自然也就更为温柔婉约了！</p><p>　　婚纱质地一般有常见的氨纶与真丝。当然，不管哪一种面料，婚纱的颜色和款式是最重要的，一定要根据自己的肤色、身型来选择搭配！</p><p>　　第四、婚纱照服装款式的选择</p><p>　　短款的婚纱照服装肯定是夏天拍婚纱照的第一选择！</p><p>　　而且，一般来说，短款礼服由于其设计理念，一般都显得更为活泼时尚，也更能体现新娘子的青春靓丽！</p><p>　　在轻柔的纱料中露出白皙匀称的小腿，性感之余，却也有一份雍容华贵！</p><p>　　不过，短款婚纱对新娘的腿部线条要求比较高，如果新娘子刚好有如此的好身材，那么，搭配上亮丽的颜色，效果更是完美！</p>','content_news.html','','1');
INSERT INTO `mo_article` (`id`,`maintable_id`,`content`,`template`,`readpower`,`allowcomment`) VALUES ('5','5','<p>&nbsp;&nbsp;三伏天到了，拍婚纱照可是一件辛苦事！然而婚期既定，这婚纱照如果不拍，那是无论如何说不过去的！那么，在炎热的夏天，想拍婚纱照的新娘，应该选择什么样的婚纱照服装才可以免受酷热之苦呢？<br/>　　第一、要选择前短后长款的婚纱</p><p>　　款式更为清凉简约的婚纱，可以避免让整个婚纱包裹住自己，这样就不会透不过气！婚纱前半部分是中裙甚至短裙的设计，能完美展示新娘的修长美腿和精心挑选的婚鞋，而后面的传统拖摆婚纱设计，则仍旧使这款前短后长的婚纱带有隆重的仪式感！</p><p>　　第二、夏天亮色系的服装最受欢迎</p><p>　　亮丽的颜色是夏天的符号，春夏婚纱礼服颜色最亮丽，春夏流行色系，如裸色、橙色、黄色等颜色会将新娘子青春靓丽美好曼妙的一面完全地展现出来，绝对是值得一试的！用心搭配出来的多彩婚纱，充满创意的色彩概念，这样的婚纱照，岂不是让你如此与众不同？！</p><p>　　当然，要穿上五彩缤纷的流行色婚纱拍照，也要注意衣服颜色和自己的肤色是否搭配，还有发型发色的协调也是非常重要的！</p><p>　　第三、如何选择婚纱照服装的质地</p><p>　　在如此炎热的夏天，一切衣着都以清凉为前提，因此，婚纱也是如此！一定要尽量选择质地轻薄、做工简约的婚纱，轻纱裹体，新娘子曼妙身材也能展露无遗，气质自然也就更为温柔婉约了！</p><p>　　婚纱质地一般有常见的氨纶与真丝。当然，不管哪一种面料，婚纱的颜色和款式是最重要的，一定要根据自己的肤色、身型来选择搭配！</p><p>　　第四、婚纱照服装款式的选择</p><p>　　短款的婚纱照服装肯定是夏天拍婚纱照的第一选择！</p><p>　　而且，一般来说，短款礼服由于其设计理念，一般都显得更为活泼时尚，也更能体现新娘子的青春靓丽！</p><p>　　在轻柔的纱料中露出白皙匀称的小腿，性感之余，却也有一份雍容华贵！</p><p>　　不过，短款婚纱对新娘的腿部线条要求比较高，如果新娘子刚好有如此的好身材，那么，搭配上亮丽的颜色，效果更是完美！</p>','content_news.html','','1');
INSERT INTO `mo_article` (`id`,`maintable_id`,`content`,`template`,`readpower`,`allowcomment`) VALUES ('6','11','铭万---中国最大的中小企业信息化服务商，本着&quot;诚信为本长期服务&quot;的经营宗旨，为中小企业提供企业建站、在线推广、按需定制软件（SaaS）等服务。<br/><br/>六年，缔造中国企业发展神话！铭万成立于2004年4月27日，短短六年的时间，已经拥有40多间分公司，3000多人的服务团队,为中小企业提供面对面&quot;顾问式&quot;服务，获得了超过20万家中小企业客户认可，并与IBM、联想等世界五百强企业达成合作，现为中国最大的中小企业信息化服务商。<br/><br/>高端技术，保证服务品质！铭万拥有来自美国硅谷的研发团队，拥有五项国家专利技术，取得二十项核心知识产权，被授予高新技术企业和双软认证企业！铭万网，权威的中国企业的电子商务平台，为中国广大企业提供全面、优质、专业的线上线下一站式服务；铭万八方通宝，中国软件协会&quot;中国优秀软件&quot;五连冠；中国B2B联盟，由铭万网发起成立，在各大核心行业中精选数百家旗舰级行业网站组建的联盟，全国最优秀的行业网站联合起来服务企业。金榜题名，专业化搜索时代的最佳利器，铭万智能网站，&quot;2005年度国家重点新产品计划项目&quot;；铭万在线客服系统，&quot;北京火炬计划项目&quot;；铭万小财神，最受中小企业家欢迎的即时通讯软件；<br/><br/>广告业务联系：<br/><br/>联系电话：010-58271212<br/><br/>电子邮件：mail.b2b.cn','content_contact.html','','1');
INSERT INTO `mo_article` (`id`,`maintable_id`,`content`,`template`,`readpower`,`allowcomment`) VALUES ('7','12','北京铭万智达科技有限公司（北京总部）<br/><br/>&nbsp;&nbsp;&nbsp;地　址：北京市朝阳区安苑路15号铭万信息大厦<br/>&nbsp;&nbsp;&nbsp;电　话：(+86)010-58271212<br/>&nbsp;&nbsp;&nbsp;传　真：(+86)010-59207580<br/>&nbsp;&nbsp;&nbsp;邮　编：100029<br/><br/>客户服务<br/><br/>&nbsp;&nbsp;&nbsp;电　话：400-700-1818（免长途费）<br/>&nbsp;&nbsp;&nbsp;传　真：(+86)010-59207580<br/>&nbsp;&nbsp;&nbsp;邮　箱：Service@mainone.cn','content_contact.html','','1');
INSERT INTO `mo_article` (`id`,`maintable_id`,`content`,`template`,`readpower`,`allowcomment`) VALUES ('8','13','本公司对其发行的或与合作公司共同发行的包括但不限于产品或服务的全部内容及本网站上的材料拥有版权等知识产权，受法律保护。<br/>　　未经本公司书面许可，任何单位及个人不得以任何方式或理由对上述产品、服务、信息、材料的任何部分进行使用、复制、修改、抄录、传播或与其它产品捆绑使用、销售。<br/>　　凡侵犯本公司版权等知识产权的，本公司必依法追究其法律责任。<br/>　　本公司法律事务部受本公司指示，特此郑重法律声明！<br/>　　隐私权声明<br/>　　本公司注重对保护您的个人隐私的保护。有时候我们需要某些信息才能为您提供您请求的服务，本隐私权声明解释了这些情况下的数据收集和使用情况。本隐私权声明适用于本网站的所有相关服务。<br/>　　您个人信息的安全<br/>　　严格保护您的个人信息的安全。我们使用各种安全技术和程序来保护您的个人信息不被未经授权的访问、使用或泄漏。如果您对我们的隐私保护有任何置疑，请email至cmsb2b@mail.b2b.cn<br/>　　关于免责<br/>　　就下列相关事宜的发生，本公司不承担任何法律责任：<br/>　　本公司根据法律规定或相关政府的要求提供您的个人信息；<br/>　　由于您将用户密码告知他人或与他人共享注册帐户，由此导致的任何个人信息的泄漏，或其他非因本公司原因导致的个人信息的泄漏；<br/>　　任何第三方根据本公司各服务条款及声明中所列明的情况使用您的个人信息，由此所产生的纠纷；<br/>　　任何由于黑客攻击、电脑病毒侵入或政府管制而造成的暂时性网站关闭；<br/>　　因不可抗力导致的任何后果；<br/>　　本公司在各服务条款及声明中列明的使用方式或免责情形。<br/>　　本公司会不时更新本隐私权声明。更新时，我们还会修改隐私权声明顶部的&quot;最近更新&quot;的日期。<br/>　　相关法律查阅<br/>　　《中华人民共和国刑法》<br/>　　《中华人民共和国商标法》<br/>　　《全国人民代表大会常务委员会关于维护互联网安全的决定》<br/>　　《计算机信息网络国际联网安全保护管理办法》<br/>　　《计算机软件保护条例》<br/>　　网站标识<br/>　　www.b2b.cn为本公司网站域名，用户欲了解本公司网站的备案详情，请登陆国家相关网站查询。<br/>　　本公司郑重提醒广大用户，切勿登陆访问仿冒本公司的不法网站，以免上当受害。','content_contact.html','','1');
INSERT INTO `mo_category` (`id`,`pid`,`catname`,`model`,`filepath`,`indextpl`,`columntpl`,`contenttpl`,`isnav`,`columnoption`,`dirpath`,`columnattr`,`columncross`,`crossid`,`ordernum`,`seo_title`,`seo_keywords`,`seo_description`,`content`,`created`) VALUES ('1','0','新闻动态','1','xinwendongtai','index_news.html','list_bj.html','content_news.html','1','3','1','1','1','','0','','','','','1371799298');
INSERT INTO `mo_category` (`id`,`pid`,`catname`,`model`,`filepath`,`indextpl`,`columntpl`,`contenttpl`,`isnav`,`columnoption`,`dirpath`,`columnattr`,`columncross`,`crossid`,`ordernum`,`seo_title`,`seo_keywords`,`seo_description`,`content`,`created`) VALUES ('2','0','作品案例','2','zuopinanli','index_works.html','list_bj.html','content_works.html','1','3','1','1','1','','0','','','','','1371800571');
INSERT INTO `mo_category` (`id`,`pid`,`catname`,`model`,`filepath`,`indextpl`,`columntpl`,`contenttpl`,`isnav`,`columnoption`,`dirpath`,`columnattr`,`columncross`,`crossid`,`ordernum`,`seo_title`,`seo_keywords`,`seo_description`,`content`,`created`) VALUES ('3','0','套系报价','3','taoxibaojia','index_offer.html','list_bj.html','content_works.html','1','3','1','1','1','','0','','','','','1372150988');
INSERT INTO `mo_category` (`id`,`pid`,`catname`,`model`,`filepath`,`indextpl`,`columntpl`,`contenttpl`,`isnav`,`columnoption`,`dirpath`,`columnattr`,`columncross`,`crossid`,`ordernum`,`seo_title`,`seo_keywords`,`seo_description`,`content`,`created`) VALUES ('4','0','关于我们','1','guanyuwomen','index_contact.html','list_chwl.html','content_chwl.html','1','3','1','1','1','','0','','','','','1372151065');
INSERT INTO `mo_category` (`id`,`pid`,`catname`,`model`,`filepath`,`indextpl`,`columntpl`,`contenttpl`,`isnav`,`columnoption`,`dirpath`,`columnattr`,`columncross`,`crossid`,`ordernum`,`seo_title`,`seo_keywords`,`seo_description`,`content`,`created`) VALUES ('5','1','最新动态','1','zuixindongtai','index_news.html','list_bj.html','content_news.html','2','3','1','1','1','','0','','','','','1372995272');
INSERT INTO `mo_category` (`id`,`pid`,`catname`,`model`,`filepath`,`indextpl`,`columntpl`,`contenttpl`,`isnav`,`columnoption`,`dirpath`,`columnattr`,`columncross`,`crossid`,`ordernum`,`seo_title`,`seo_keywords`,`seo_description`,`content`,`created`) VALUES ('6','1','业界资讯','1','yejiezixun','index_news.html','list_bj.html','content_news.html','2','3','1','1','1','','0','','','','','1372995293');
INSERT INTO `mo_category` (`id`,`pid`,`catname`,`model`,`filepath`,`indextpl`,`columntpl`,`contenttpl`,`isnav`,`columnoption`,`dirpath`,`columnattr`,`columncross`,`crossid`,`ordernum`,`seo_title`,`seo_keywords`,`seo_description`,`content`,`created`) VALUES ('7','1','婚纱摄影','1','hunshasheying','index_news.html','list_bj.html','content_news.html','2','3','1','1','1','','0','','','','','1372995311');
INSERT INTO `mo_category` (`id`,`pid`,`catname`,`model`,`filepath`,`indextpl`,`columntpl`,`contenttpl`,`isnav`,`columnoption`,`dirpath`,`columnattr`,`columncross`,`crossid`,`ordernum`,`seo_title`,`seo_keywords`,`seo_description`,`content`,`created`) VALUES ('8','1','婚礼指南','1','hunlizhinan','index_news.html','list_bj.html','content_news.html','2','3','1','1','1','','0','','','','','1372995327');
INSERT INTO `mo_category` (`id`,`pid`,`catname`,`model`,`filepath`,`indextpl`,`columntpl`,`contenttpl`,`isnav`,`columnoption`,`dirpath`,`columnattr`,`columncross`,`crossid`,`ordernum`,`seo_title`,`seo_keywords`,`seo_description`,`content`,`created`) VALUES ('9','1','婚饰礼品','1','hunshilipin','index_news.html','list_bj.html','content_news.html','2','3','1','1','1','','0','','','','','1372995348');
INSERT INTO `mo_category` (`id`,`pid`,`catname`,`model`,`filepath`,`indextpl`,`columntpl`,`contenttpl`,`isnav`,`columnoption`,`dirpath`,`columnattr`,`columncross`,`crossid`,`ordernum`,`seo_title`,`seo_keywords`,`seo_description`,`content`,`created`) VALUES ('10','2','室内婚纱','2','shineihunsha','index_works.html','list_bj.html','content_works.html','2','3','1','1','1','','0','','','','','1373002232');
INSERT INTO `mo_category` (`id`,`pid`,`catname`,`model`,`filepath`,`indextpl`,`columntpl`,`contenttpl`,`isnav`,`columnoption`,`dirpath`,`columnattr`,`columncross`,`crossid`,`ordernum`,`seo_title`,`seo_keywords`,`seo_description`,`content`,`created`) VALUES ('11','2','室外婚纱','2','shiwaihunsha','index_works.html','list_bj.html','content_works.html','2','3','1','1','1','','0','','','','','1373002248');
INSERT INTO `mo_category` (`id`,`pid`,`catname`,`model`,`filepath`,`indextpl`,`columntpl`,`contenttpl`,`isnav`,`columnoption`,`dirpath`,`columnattr`,`columncross`,`crossid`,`ordernum`,`seo_title`,`seo_keywords`,`seo_description`,`content`,`created`) VALUES ('12','2','明星艺人','2','mingxingyiren','index_works.html','list_bj.html','content_works.html','2','3','1','1','1','','0','','','','','1373004628');
INSERT INTO `mo_category` (`id`,`pid`,`catname`,`model`,`filepath`,`indextpl`,`columntpl`,`contenttpl`,`isnav`,`columnoption`,`dirpath`,`columnattr`,`columncross`,`crossid`,`ordernum`,`seo_title`,`seo_keywords`,`seo_description`,`content`,`created`) VALUES ('14','4','站点地图','1','jiaruwomen','index_map.html','list_bj.html','content_contact.html','2','3','1','1','1','','0','','','','','1373418735');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('1','1','categoryid','栏目','categoryid','1','请选择栏目','','请选择栏目','','1','1','','2','1','1','3','1123213','1','1');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('2','1','title','标题','title','1','请输入标题','','标题不能为空,最大长度为100','','100','1','','2','1','1','1','1123213','1','1');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('3','1','subtitle','副标题','text','1','请填写副标题','','标题格式不正确,最大长度为100','','100','0','','2','2','1','2','1123213','1','1');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('4','1','thumb','缩略图','image','1','','','','','0','0','','2','2','2','8','1123213','1','1');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('5','1','keywords','关键字','keywords','1','','','关键字格式不正确,最大长度为50','','50','0','','2','2','1','4','1123213','1','1');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('6','1','description','内容简介','description','1','','','内容简介格式不正确,最大长度为500','','500','0','','2','2','2','5','1123213','1','1');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('7','1','source','来源','text','1','','','来源格式不正确,最大长度为100','','100','0','','2','2','2','6','1123213','1','1');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('8','1','username','作者','text','1','','','作者格式不正确,最大长度为50','','50','0','','2','2','2','7','1123213','1','1');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('9','1','sorttype','排序方式','sorttype','1','','','','','0','0','','2','2','2','11','1123213','1','1');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('10','1','publishopt','发布选项','publishopt','1','请选择发布选项','','','','0','0','','2','1','2','13','1123213','1','1');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('11','1','hits','点击量','text','1','','','','','0','0','^[1-9]\\d*$','2','2','2','10','1123213','1','1');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('12','1','publishtime','发布时间','datetime','1','请选择发布时间','','','','0','0','','2','2','2','14','1123213','1','1');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('13','1','allowcomment','评论选项','allowcomment','2','','','','','0','0','','2','1','2','9','1123213','1','1');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('14','1','content','内容','editor','2','','','','','0','0','','2','2','1','7','1123213','1','1');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('15','1','template','选择模板','template','2','','','','','0','0','','2','1','2','15','1123213','1','1');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('16','1','readpower','阅读权限','readpower','2','','','','','0','0','','2','2','2','12','1123213','1','1');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('17','3','categoryid','栏目','categoryid','1','请选择栏目','','请选择栏目','','1','1','','2','1','1','1','1123213','1','1');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('18','3','title','标题','title','1','请输入标题','','标题不能为空,最大长度为100','','100','1','','2','1','1','4','1123213','1','1');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('19','3','subtitle','副标题','text','1','请填写副标题','','标题格式不正确,最大长度为100','','100','0','','2','2','1','19','1123213','1','1');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('20','3','thumb','缩略图','image','1','','','','','0','0','','2','2','2','3','1123213','1','1');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('21','3','keywords','关键字','keywords','1','','','关键字格式不正确,最大长度为50','','50','0','','2','2','1','18','1123213','1','1');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('22','3','description','内容简介','description','1','','','内容简介格式不正确,最大长度为500','','500','0','','2','2','2','17','1123213','1','1');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('23','3','source','来源','text','1','','','来源格式不正确,最大长度为100','','100','0','','2','2','2','26','1123213','2','1');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('24','3','username','作者','text','1','','','作者格式不正确,最大长度为50','','50','0','','2','2','2','27','1123213','2','1');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('25','3','sorttype','排序方式','sorttype','1','','','','','0','0','','2','2','2','51','1123213','1','1');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('26','3','publishopt','发布选项','publishopt','1','请选择发布选项','','','','0','0','','2','1','2','2','1123213','1','1');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('27','3','publishtime','发布时间','datetime','1','请选择发布时间','','','','0','0','','2','1','2','54','1123213','1','1');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('28','3','hits','点击量','text','1','','','','','0','0','^[1-9]\\d*$','2','2','2','20','1123213','1','1');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('29','3','content','内容','editor','2','','','','','0','0','','2','2','1','16','1123213','1','1');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('30','3','template','选择模板','template','2','','','','','0','0','','2','1','2','22','1123213','1','1');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('31','3','allowcomment','评论选项','allowcomment','2','','','','','0','0','','2','1','2','29','1123213','1','1');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('32','3','readpower','阅读权限','readpower','2','','','','','0','0','','2','2','2','52','1123213','1','1');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('33','3','offer_time','拍摄时间','text','2','','','','','0','0','','2','2','2','15','1372143103','1','2');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('34','3','offer_style','礼服造型','text','2','','','','','0','0','','2','2','2','14','1372144058','1','2');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('35','3','offer_sample','拍摄样片','text','2','','','','','0','0','','2','2','2','13','1372144080','1','2');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('36','3','offer_place','拍摄地点','text','2','','','','','0','0','','2','2','2','12','1372144096','1','2');
INSERT INTO `mo_field` (`id`,`modelid`,`field`,`name`,`fieldtype`,`issystem`,`tips`,`errortips`,`emptytips`,`defaultvalue`,`maxlength`,`minlength`,`pattern`,`isunique`,`isnull`,`issearch`,`sortid`,`addtime`,`flag`,`ismain`) VALUES ('37','3','offer_price','套系价格','text','2','','','','','0','0','','2','2','2','11','1372144112','1','2');
INSERT INTO `mo_goods` (`goodsid`,`goodssn`,`goodsname`,`subname`,`categoryid`,`sortid`,`brandid`,`is_sell`,`typeid`,`userid`,`hits`,`isbest`,`isnew`,`ishot`,`isspecial`,`keywords`,`brief`,`content`,`marketprice`,`shopprice`,`unit`,`publishtime`,`publishopt`,`alowpower`,`iscomment`,`goodstpl`,`modification`,`created`) VALUES ('1','SN:13727508315963','伴娘的春天','','2','1','0','1','0','1','55','2','2','2','2','','','0','0.00','0.00','','','2','-1','1','content_works.html','1372750831','1372750831');
INSERT INTO `mo_goods` (`goodsid`,`goodssn`,`goodsname`,`subname`,`categoryid`,`sortid`,`brandid`,`is_sell`,`typeid`,`userid`,`hits`,`isbest`,`isnew`,`ishot`,`isspecial`,`keywords`,`brief`,`content`,`marketprice`,`shopprice`,`unit`,`publishtime`,`publishopt`,`alowpower`,`iscomment`,`goodstpl`,`modification`,`created`) VALUES ('2','SN:13729885328648','伴娘的春天1','','2','1','0','1','0','1','15','2','2','2','2','','','新娘结婚的当天一般要准备4~5套服装，包括两套白色婚纱和两套到三套的礼服，一套婚纱用于新郎到新娘家接新娘用，另一套用于在婚宴上接待宾客和婚宴开始阶段用，礼服用于婚宴当天进酒和其他环节用，颜色可以根据新娘的喜爱挑选，一般以金色、天蓝、粉色为主，同时可以准备一款中式的旗袍。&lt;p&gt;&lt;br/&gt;&amp;nbsp;　　注意事项：&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&amp;nbsp;　　新娘的婚纱一般一套为拖地婚纱，用于婚宴；另一套应为正好盖过脚背的婚纱，用于结婚当天的早上，这样可以方便走动，另礼服也应该不选择拖地款式，因为婚宴要走动，拖地式不方便，而且容易被踩住，造成危险。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&amp;nbsp;　　新郎&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&amp;nbsp;　　新郎的服装相对比较简单，大体上以黑白西装为主，领带以红色为主，突出喜庆的色彩，衬衫以白色为最佳，当然可以根据自己的喜好选择，不过不可过于艳色。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&amp;nbsp;　　注意事项：&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&amp;nbsp;　　新郎的服装虽然相对比较简单，但色彩上的搭配还是要注意，西装的色彩以黑、白、灰三色为最佳，千万不要选择一款色彩过于艳丽的西装，例如暗红色，这样会显得很土，只要领带的色彩为红色即可。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&amp;nbsp;　　伴娘&lt;/p&gt;&lt;p&gt;&amp;nbsp;&lt;/p&gt;','0.00','0.00','','','2','-1','1','content_xwjh.html','1372988582','1372988532');
INSERT INTO `mo_goods` (`goodsid`,`goodssn`,`goodsname`,`subname`,`categoryid`,`sortid`,`brandid`,`is_sell`,`typeid`,`userid`,`hits`,`isbest`,`isnew`,`ishot`,`isspecial`,`keywords`,`brief`,`content`,`marketprice`,`shopprice`,`unit`,`publishtime`,`publishopt`,`alowpower`,`iscomment`,`goodstpl`,`modification`,`created`) VALUES ('3','SN:13734188806965','伴娘的春天2','','12','1','0','1','0','1','1','2','2','2','2','','','test','0.00','0.00','','','2','-1','1','content_contact.html','1373418880','1373418880');
INSERT INTO `mo_goods_album` (`albumid`,`goodsid`,`photo`,`created`) VALUES ('1','1','2013_07/20130702074031_6108_28.jpg','1372750831');
INSERT INTO `mo_goods_album` (`albumid`,`goodsid`,`photo`,`created`) VALUES ('2','2','2013_07/20130705014302_1160_78.png','1372988582');
INSERT INTO `mo_goods_album` (`albumid`,`goodsid`,`photo`,`created`) VALUES ('3','3','2013_07/20130710011440_6911_91.png','1373418880');
INSERT INTO `mo_goods_sort` (`sortid`,`pid`,`sortname`,`ordernum`,`isdefault`,`created`) VALUES ('1','0','默认分类','1','1','1370313703');
INSERT INTO `mo_goods_type` (`typeid`,`typename`,`status`,`attr_type`,`created`) VALUES ('1','fsdf','1','','1372123967');
INSERT INTO `mo_imc_users` (`id`,`username`,`password`,`email`,`regip`,`regdate`,`lastip`,`lastdate`,`updatedate`,`appname`,`status`,`isdel`,`isadmin`,`isimc`) VALUES ('1','admin','00ba1a9fae0438223f3c8bda42e01926','123@123.com','192.168.3.207','1371783587','192.168.3.207','1371783587','1371783587','mocms','1','0','1','1');
INSERT INTO `mo_mailtemplate` (`id`,`theme`,`content`,`createtime`,`flag`) VALUES ('1','会员激活邮件模板','','','1');
INSERT INTO `mo_mailtemplate` (`id`,`theme`,`content`,`createtime`,`flag`) VALUES ('2','会员找回密码邮件模板','','','2');
INSERT INTO `mo_maintable` (`id`,`categoryid`,`title`,`subtitle`,`thumb`,`keywords`,`description`,`brief`,`source`,`sorttype`,`sortnum`,`publishopt`,`publishtime`,`hits`,`publishuser`,`username`,`updatetime`,`updateuser`,`created`) VALUES ('1','4','关于我们','','{"savename":"map2.gif","filename":"{07301A53-6685-60E2-51B5-35662FBA563B}.gif","size":108,"src":"content\/2013_07\/{07301A53-6685-60E2-51B5-35662FBA563B}.gif"}','','巴黎婚纱6月省钱计划，与一群志同道合的人，快乐地做一件幸福的事情，只要你的参与，力量才是最大的。让所有的新人们一起在这个夏季的到来前，抢先入手超值的婚博会专享套系，这个便宜你赚到了吗？三大省钱计划————你进店，我组团！（合伙就有大便宜）','','','1372204800','0','2','1372204800','29','admin','','1373016924','admin','1372204800');
INSERT INTO `mo_maintable` (`id`,`categoryid`,`title`,`subtitle`,`thumb`,`keywords`,`description`,`brief`,`source`,`sorttype`,`sortnum`,`publishopt`,`publishtime`,`hits`,`publishuser`,`username`,`updatetime`,`updateuser`,`created`) VALUES ('2','1','婚纱礼服着装技巧穿出你的时尚范儿(1)','','{"savename":"\u9ed8\u8ba4\u56fe\u65b0.jpg","filename":"{F9E725E8-55BC-F5D9-752F-1C9D4BB894C6}.jpg","size":"24","src":"content\/2013_07\/{F9E725E8-55BC-F5D9-752F-1C9D4BB894C6}.jpg"}','','　　不管你是婚礼上的主角还是配角，这里都为您准备了各种最全面最时尚的婚礼着装技巧，教你穿出时尚范儿！　　新娘　　新娘结婚的当天一般要准备4~5套服装，包括两套白色婚纱和两套到三套的礼服，一套婚纱用于新郎到新娘家接新娘用，另一套用于在婚宴上接待宾客和婚宴开始阶段用，礼服用于婚宴当天进酒和其他环节用，颜色可以根据新娘的喜爱挑选，一般以金色、天蓝、粉色为主，同时可以准备一款中式的旗袍。','','','1372723200','0','2','1372723200','31','admin','','1373012505','admin','1372723200');
INSERT INTO `mo_maintable` (`id`,`categoryid`,`title`,`subtitle`,`thumb`,`keywords`,`description`,`brief`,`source`,`sorttype`,`sortnum`,`publishopt`,`publishtime`,`hits`,`publishuser`,`username`,`updatetime`,`updateuser`,`created`) VALUES ('3','1','低碳婚礼进行中租赁可循环再用婚纱','','{"savename":"\u9ed8\u8ba4\u56fe\u65b0.jpg","filename":"{8B03BFE5-36D0-EF48-0BB7-C422069E7AA3}.jpg","size":"24","src":"content\/2013_07\/{8B03BFE5-36D0-EF48-0BB7-C422069E7AA3}.jpg"}','','　　北方网讯记者刘延春报道运用可循环再用的婚纱，婚宴上用其他食品替代鱼翅、燕窝，乃至要在婚礼上实行不离婚的“低碳答应”——全港“可连续”环保婚礼大举动2010日前启动，边疆第一站即选择了深圳，下一站将到上海，三地各将召集100对新人及约请100间婚嫁商户参与本次活动。','','','1372723200','0','2','1372723200','3','admin','','1373012516','admin','1372723200');
INSERT INTO `mo_maintable` (`id`,`categoryid`,`title`,`subtitle`,`thumb`,`keywords`,`description`,`brief`,`source`,`sorttype`,`sortnum`,`publishopt`,`publishtime`,`hits`,`publishuser`,`username`,`updatetime`,`updateuser`,`created`) VALUES ('4','7','夏天拍婚纱照如何选择合适的婚纱照服装','','{"savename":"\u9ed8\u8ba4\u56fe\u65b0.jpg","filename":"{C4B39FAD-798F-8810-C92B-FEC37A6DD983}.jpg","size":"24","src":"content\/2013_07\/{C4B39FAD-798F-8810-C92B-FEC37A6DD983}.jpg"}','','三伏天到了，拍婚纱照可是一件辛苦事！然而婚期既定，这婚纱照如果不拍，那是无论如何说不过去的！那么，在炎热的夏天，想拍婚纱照的新娘，应该选择什么样的婚纱照服装才可以免受酷热之苦呢？　　第一、要选择前短后长款的婚纱','','','1372723200','0','2','1372723200','1','admin','','1373012434','admin','1372723200');
INSERT INTO `mo_maintable` (`id`,`categoryid`,`title`,`subtitle`,`thumb`,`keywords`,`description`,`brief`,`source`,`sorttype`,`sortnum`,`publishopt`,`publishtime`,`hits`,`publishuser`,`username`,`updatetime`,`updateuser`,`created`) VALUES ('5','9','夏天拍婚纱照如何选择合适的婚纱照服装','','{"savename":"\u9ed8\u8ba4\u56fe\u65b0.jpg","filename":"{C4B39FAD-798F-8810-C92B-FEC37A6DD983}.jpg","size":"24","src":"content\/2013_07\/{C4B39FAD-798F-8810-C92B-FEC37A6DD983}.jpg"}','','三伏天到了，拍婚纱照可是一件辛苦事！然而婚期既定，这婚纱照如果不拍，那是无论如何说不过去的！那么，在炎热的夏天，想拍婚纱照的新娘，应该选择什么样的婚纱照服装才可以免受酷热之苦呢？　　第一、要选择前短后长款的婚纱','','','1372723200','0','2','1372723200','9','admin','','1373012399','admin','1372723200');
INSERT INTO `mo_maintable` (`id`,`categoryid`,`title`,`subtitle`,`thumb`,`keywords`,`description`,`brief`,`source`,`sorttype`,`sortnum`,`publishopt`,`publishtime`,`hits`,`publishuser`,`username`,`updatetime`,`updateuser`,`created`) VALUES ('6','3','特惠婚纱套系','','{"savename":"pic2.jpg","filename":"{8E70503E-F53B-500A-368A-050791D2B5C6}.jpg","size":"15","src":"content\/2013_07\/{8E70503E-F53B-500A-368A-050791D2B5C6}.jpg"}','','三伏天到了，拍婚纱照可是一件辛苦事！然而婚期既定，这婚纱照如果不拍，那是无论如何说不过去的！那么，在炎热的夏天，想拍婚纱照的新娘，应该选择什么样的婚纱照服装才可以免受酷热之苦呢？','','','1372723200','0','2','1372723200','37','admin','','1373623223','admin','1372723200');
INSERT INTO `mo_maintable` (`id`,`categoryid`,`title`,`subtitle`,`thumb`,`keywords`,`description`,`brief`,`source`,`sorttype`,`sortnum`,`publishopt`,`publishtime`,`hits`,`publishuser`,`username`,`updatetime`,`updateuser`,`created`) VALUES ('7','3','定制婚纱套系','','{"savename":"pic3.jpg","filename":"{2A3CBA67-E56D-F91D-3166-EC9D6C6544C9}.jpg","size":21,"src":"content\/2013_07\/{2A3CBA67-E56D-F91D-3166-EC9D6C6544C9}.jpg"}','','　　款式更为清凉简约的婚纱，可以避免让整个婚纱包裹住自己，这样就不会透不过气！婚纱前半部分是中裙甚至短裙的设计，能完美展示新娘的修长美腿和精心挑选的婚鞋，而后面的传统拖摆婚纱设计，则仍旧使这款前短后长的婚纱带有隆重的仪式感！','','','1372723200','0','2','1372723200','10','admin','','1372723200','admin','1372723200');
INSERT INTO `mo_maintable` (`id`,`categoryid`,`title`,`subtitle`,`thumb`,`keywords`,`description`,`brief`,`source`,`sorttype`,`sortnum`,`publishopt`,`publishtime`,`hits`,`publishuser`,`username`,`updatetime`,`updateuser`,`created`) VALUES ('8','3','高级婚纱套系','','{"savename":"pic4.jpg","filename":"{748566C5-3DF0-9D01-B388-63D2374ED890}.jpg","size":17,"src":"content\/2013_07\/{748566C5-3DF0-9D01-B388-63D2374ED890}.jpg"}','','　　亮丽的颜色是夏天的符号，春夏婚纱礼服颜色最亮丽，春夏流行色系，如裸色、橙色、黄色等颜色会将新娘子青春靓丽美好曼妙的一面完全地展现出来，绝对是值得一试的！用心搭配出来的多彩婚纱，充满创意的色彩概念，这样的婚纱照，岂不是让你如此与众不同？！','','','1372723200','0','2','1372723200','3','admin','','1372723200','admin','1372723200');
INSERT INTO `mo_maintable` (`id`,`categoryid`,`title`,`subtitle`,`thumb`,`keywords`,`description`,`brief`,`source`,`sorttype`,`sortnum`,`publishopt`,`publishtime`,`hits`,`publishuser`,`username`,`updatetime`,`updateuser`,`created`) VALUES ('9','3','华贵婚纱套系','','{"savename":"pic5.jpg","filename":"{C25690D4-F8B4-A65F-C068-4916A9C2CCCD}.jpg","size":21,"src":"content\/2013_07\/{C25690D4-F8B4-A65F-C068-4916A9C2CCCD}.jpg"}','','　　婚纱质地一般有常见的氨纶与真丝。当然，不管哪一种面料，婚纱的颜色和款式是最重要的，一定要根据自己的肤色、身型来选择搭配！','','','1372723200','0','2','1372723200','3','admin','','1372723200','admin','1372723200');
INSERT INTO `mo_maintable` (`id`,`categoryid`,`title`,`subtitle`,`thumb`,`keywords`,`description`,`brief`,`source`,`sorttype`,`sortnum`,`publishopt`,`publishtime`,`hits`,`publishuser`,`username`,`updatetime`,`updateuser`,`created`) VALUES ('10','3','尊贵婚纱套系','','{"savename":"pic6.jpg","filename":"{14AB78D4-88E7-B55D-AC34-F89BB50427C2}.jpg","size":20,"src":"content\/2013_07\/{14AB78D4-88E7-B55D-AC34-F89BB50427C2}.jpg"}','','　　婚纱质地一般有常见的氨纶与真丝。当然，不管哪一种面料，婚纱的颜色和款式是最重要的，一定要根据自己的肤色、身型来选择搭配！　　第四、婚纱照服装款式的选择','','','1372723200','0','2','1372723200','2','admin','','1372723200','admin','1372723200');
INSERT INTO `mo_maintable` (`id`,`categoryid`,`title`,`subtitle`,`thumb`,`keywords`,`description`,`brief`,`source`,`sorttype`,`sortnum`,`publishopt`,`publishtime`,`hits`,`publishuser`,`username`,`updatetime`,`updateuser`,`created`) VALUES ('11','4','广告服务','广告服务','','广告服务','铭万---中国最大的中小企业信息化服务商，本着"诚信为本长期服务"的经营宗旨，为中小企业提供企业建站、在线推广、按需定制软件（SaaS）等服务。','','','1373587200','0','2','1373587200','18','admin','','1373621739','admin','1373587200');
INSERT INTO `mo_maintable` (`id`,`categoryid`,`title`,`subtitle`,`thumb`,`keywords`,`description`,`brief`,`source`,`sorttype`,`sortnum`,`publishopt`,`publishtime`,`hits`,`publishuser`,`username`,`updatetime`,`updateuser`,`created`) VALUES ('12','4','联系我们','联系我们','','联系我们','北京铭万智达科技有限公司（北京总部）地　址：北京市朝阳区安苑路15号铭万信息大厦电　话：(+86)010-58271212传　真：(+86)010-59207580邮　编：100029客户服务电　话：400-700-1818（免长途费）传　真：(+86)010-59207580邮　箱：Service@mainone.cn','','','1373587200','0','2','1373587200','5','admin','','1373587200','admin','1373587200');
INSERT INTO `mo_maintable` (`id`,`categoryid`,`title`,`subtitle`,`thumb`,`keywords`,`description`,`brief`,`source`,`sorttype`,`sortnum`,`publishopt`,`publishtime`,`hits`,`publishuser`,`username`,`updatetime`,`updateuser`,`created`) VALUES ('13','4','版权所有','版权所有','','版权所有','本公司对其发行的或与合作公司共同发行的包括但不限于产品或服务的全部内容及本网站上的材料拥有版权等知识产权，受法律保护','','','1373587200','0','2','1373587200','7','admin','','1373587200','admin','1373587200');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('1','1','1','2');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('2','1','1','3');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('3','1','1','4');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('4','1','1','5');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('5','2','1','2');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('6','2','1','3');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('7','2','1','4');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('8','2','1','5');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('9','3','1','2');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('10','3','1','3');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('11','3','1','4');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('12','3','1','5');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('13','4','1','2');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('14','4','1','3');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('15','4','1','4');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('16','4','1','5');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('17','5','1','2');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('18','5','1','3');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('19','5','1','4');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('20','5','1','5');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('21','6','1','2');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('22','6','1','3');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('23','6','1','4');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('24','6','1','5');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('40','7','1','5');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('39','7','1','4');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('38','7','1','3');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('37','7','1','2');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('44','8','1','5');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('43','8','1','4');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('42','8','1','3');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('41','8','1','2');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('33','9','1','2');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('34','9','1','3');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('35','9','1','4');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('36','9','1','5');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('45','10','1','2');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('46','10','1','3');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('47','10','1','4');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('48','10','1','5');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('49','11','1','2');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('50','11','1','3');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('51','11','1','4');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('52','11','1','5');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('53','12','1','2');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('54','12','1','3');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('55','12','1','4');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('56','12','1','5');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('72','14','1','5');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('71','14','1','4');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('70','14','1','3');
INSERT INTO `mo_manager_cate_per` (`id`,`categoryid`,`roleid`,`permissionid`) VALUES ('69','14','1','2');
INSERT INTO `mo_member_cate_per` (`id`,`categoryid`,`groupid`,`permissionid`) VALUES ('1','1','24','1');
INSERT INTO `mo_member_cate_per` (`id`,`categoryid`,`groupid`,`permissionid`) VALUES ('2','1','24','2');
INSERT INTO `mo_member_cate_per` (`id`,`categoryid`,`groupid`,`permissionid`) VALUES ('3','2','24','1');
INSERT INTO `mo_member_cate_per` (`id`,`categoryid`,`groupid`,`permissionid`) VALUES ('4','2','24','2');
INSERT INTO `mo_member_cate_per` (`id`,`categoryid`,`groupid`,`permissionid`) VALUES ('5','3','24','1');
INSERT INTO `mo_member_cate_per` (`id`,`categoryid`,`groupid`,`permissionid`) VALUES ('6','3','24','2');
INSERT INTO `mo_member_cate_per` (`id`,`categoryid`,`groupid`,`permissionid`) VALUES ('7','4','24','1');
INSERT INTO `mo_member_cate_per` (`id`,`categoryid`,`groupid`,`permissionid`) VALUES ('8','4','24','2');
INSERT INTO `mo_member_cate_per` (`id`,`categoryid`,`groupid`,`permissionid`) VALUES ('9','5','24','1');
INSERT INTO `mo_member_cate_per` (`id`,`categoryid`,`groupid`,`permissionid`) VALUES ('10','5','24','2');
INSERT INTO `mo_member_cate_per` (`id`,`categoryid`,`groupid`,`permissionid`) VALUES ('11','6','24','1');
INSERT INTO `mo_member_cate_per` (`id`,`categoryid`,`groupid`,`permissionid`) VALUES ('12','6','24','2');
INSERT INTO `mo_member_cate_per` (`id`,`categoryid`,`groupid`,`permissionid`) VALUES ('20','7','24','2');
INSERT INTO `mo_member_cate_per` (`id`,`categoryid`,`groupid`,`permissionid`) VALUES ('19','7','24','1');
INSERT INTO `mo_member_cate_per` (`id`,`categoryid`,`groupid`,`permissionid`) VALUES ('22','8','24','2');
INSERT INTO `mo_member_cate_per` (`id`,`categoryid`,`groupid`,`permissionid`) VALUES ('21','8','24','1');
INSERT INTO `mo_member_cate_per` (`id`,`categoryid`,`groupid`,`permissionid`) VALUES ('17','9','24','1');
INSERT INTO `mo_member_cate_per` (`id`,`categoryid`,`groupid`,`permissionid`) VALUES ('18','9','24','2');
INSERT INTO `mo_member_cate_per` (`id`,`categoryid`,`groupid`,`permissionid`) VALUES ('23','10','24','1');
INSERT INTO `mo_member_cate_per` (`id`,`categoryid`,`groupid`,`permissionid`) VALUES ('24','10','24','2');
INSERT INTO `mo_member_cate_per` (`id`,`categoryid`,`groupid`,`permissionid`) VALUES ('25','11','24','1');
INSERT INTO `mo_member_cate_per` (`id`,`categoryid`,`groupid`,`permissionid`) VALUES ('26','11','24','2');
INSERT INTO `mo_member_cate_per` (`id`,`categoryid`,`groupid`,`permissionid`) VALUES ('27','12','24','1');
INSERT INTO `mo_member_cate_per` (`id`,`categoryid`,`groupid`,`permissionid`) VALUES ('28','12','24','2');
INSERT INTO `mo_member_cate_per` (`id`,`categoryid`,`groupid`,`permissionid`) VALUES ('36','14','24','2');
INSERT INTO `mo_member_cate_per` (`id`,`categoryid`,`groupid`,`permissionid`) VALUES ('35','14','24','1');
INSERT INTO `mo_member_group` (`id`,`groupname`,`registerform`,`registerdeal`,`status`,`upgrade`,`regverify`,`mailverify`) VALUES ('24','默认分组','1','1','1','1','0','0');
INSERT INTO `mo_member_level` (`id`,`groupid`,`levelname`,`point`,`status`) VALUES ('1','24','默认级别','100','1');
INSERT INTO `mo_mix_model` (`id`,`tablename`,`name`,`num`,`addtime`,`count`,`forminfor`,`def`,`flag`,`state`) VALUES ('1','member_1','个人会员','0','0','0','','1','2','2');
INSERT INTO `mo_mix_model` (`id`,`tablename`,`name`,`num`,`addtime`,`count`,`forminfor`,`def`,`flag`,`state`) VALUES ('2','member_2','企业会员','0','0','0','','1','2','2');
INSERT INTO `mo_model` (`id`,`name`,`tablename`,`category_template`,`list_template`,`content_template`,`sortid`,`addtime`,`updatetime`,`type`,`flag`) VALUES ('1','文章模型','article','index_001.html','list_001.html','content_001.html','0','1359451908','1359451908','1','1');
INSERT INTO `mo_model` (`id`,`name`,`tablename`,`category_template`,`list_template`,`content_template`,`sortid`,`addtime`,`updatetime`,`type`,`flag`) VALUES ('2','商品模型','goods','index_001.html','list_001.html','content_001.html','0','1359451908','1359970842','1','1');
INSERT INTO `mo_model` (`id`,`name`,`tablename`,`category_template`,`list_template`,`content_template`,`sortid`,`addtime`,`updatetime`,`type`,`flag`) VALUES ('3','套系报价','offer','index_works.html','list_bj.html','content_works.html','0','1371800835','1371800835','2','1');
INSERT INTO `mo_offer` (`id`,`maintable_id`,`content`,`template`,`readpower`,`allowcomment`,`offer_time`,`offer_style`,`offer_sample`,`offer_place`,`offer_price`) VALUES ('1','6','<p>&nbsp;&nbsp;三伏天到了，拍婚纱照可是一件辛苦事！然而婚期既定，这婚纱照如果不拍，那是无论如何说不过去的！那么，在炎热的夏天，想拍婚纱照的新娘，应该选择什么样的婚纱照服装才可以免受酷热之苦呢？<br/>　　第一、要选择前短后长款的婚纱</p><p>　　款式更为清凉简约的婚纱，可以避免让整个婚纱包裹住自己，这样就不会透不过气！婚纱前半部分是中裙甚至短裙的设计，能完美展示新娘的修长美腿和精心挑选的婚鞋，而后面的传统拖摆婚纱设计，则仍旧使这款前短后长的婚纱带有隆重的仪式感！</p><p>　　第二、夏天亮色系的服装最受欢迎</p><p>　　亮丽的颜色是夏天的符号，春夏婚纱礼服颜色最亮丽，春夏流行色系，如裸色、橙色、黄色等颜色会将新娘子青春靓丽美好曼妙的一面完全地展现出来，绝对是值得一试的！用心搭配出来的多彩婚纱，充满创意的色彩概念，这样的婚纱照，岂不是让你如此与众不同？！</p><p>　　当然，要穿上五彩缤纷的流行色婚纱拍照，也要注意衣服颜色和自己的肤色是否搭配，还有发型发色的协调也是非常重要的！</p><p>　　第三、如何选择婚纱照服装的质地</p><p>　　在如此炎热的夏天，一切衣着都以清凉为前提，因此，婚纱也是如此！一定要尽量选择质地轻薄、做工简约的婚纱，轻纱裹体，新娘子曼妙身材也能展露无遗，气质自然也就更为温柔婉约了！</p>','content_news.html','','1','2天','中式古典','200张','室内+外景','3698元');
INSERT INTO `mo_offer` (`id`,`maintable_id`,`content`,`template`,`readpower`,`allowcomment`,`offer_time`,`offer_style`,`offer_sample`,`offer_place`,`offer_price`) VALUES ('2','7','<p>&nbsp;&nbsp;三伏天到了，拍婚纱照可是一件辛苦事！然而婚期既定，这婚纱照如果不拍，那是无论如何说不过去的！那么，在炎热的夏天，想拍婚纱照的新娘，应该选择什么样的婚纱照服装才可以免受酷热之苦呢？<br/>　　第一、要选择前短后长款的婚纱</p><p>　　款式更为清凉简约的婚纱，可以避免让整个婚纱包裹住自己，这样就不会透不过气！婚纱前半部分是中裙甚至短裙的设计，能完美展示新娘的修长美腿和精心挑选的婚鞋，而后面的传统拖摆婚纱设计，则仍旧使这款前短后长的婚纱带有隆重的仪式感！</p><p>　　第二、夏天亮色系的服装最受欢迎</p><p>　　亮丽的颜色是夏天的符号，春夏婚纱礼服颜色最亮丽，春夏流行色系，如裸色、橙色、黄色等颜色会将新娘子青春靓丽美好曼妙的一面完全地展现出来，绝对是值得一试的！用心搭配出来的多彩婚纱，充满创意的色彩概念，这样的婚纱照，岂不是让你如此与众不同？！</p><p>　　当然，要穿上五彩缤纷的流行色婚纱拍照，也要注意衣服颜色和自己的肤色是否搭配，还有发型发色的协调也是非常重要的！</p><p>　　第三、如何选择婚纱照服装的质地</p><p>　　在如此炎热的夏天，一切衣着都以清凉为前提，因此，婚纱也是如此！一定要尽量选择质地轻薄、做工简约的婚纱，轻纱裹体，新娘子曼妙身材也能展露无遗，气质自然也就更为温柔婉约了！</p>','content_news.html','','1','2天','传统+中式古典','300张以上','室内+室外','4698元');
INSERT INTO `mo_offer` (`id`,`maintable_id`,`content`,`template`,`readpower`,`allowcomment`,`offer_time`,`offer_style`,`offer_sample`,`offer_place`,`offer_price`) VALUES ('3','8','<p>&nbsp;&nbsp;三伏天到了，拍婚纱照可是一件辛苦事！然而婚期既定，这婚纱照如果不拍，那是无论如何说不过去的！那么，在炎热的夏天，想拍婚纱照的新娘，应该选择什么样的婚纱照服装才可以免受酷热之苦呢？<br/>　　第一、要选择前短后长款的婚纱</p><p>　　款式更为清凉简约的婚纱，可以避免让整个婚纱包裹住自己，这样就不会透不过气！婚纱前半部分是中裙甚至短裙的设计，能完美展示新娘的修长美腿和精心挑选的婚鞋，而后面的传统拖摆婚纱设计，则仍旧使这款前短后长的婚纱带有隆重的仪式感！</p><p>　　第二、夏天亮色系的服装最受欢迎</p><p>　　亮丽的颜色是夏天的符号，春夏婚纱礼服颜色最亮丽，春夏流行色系，如裸色、橙色、黄色等颜色会将新娘子青春靓丽美好曼妙的一面完全地展现出来，绝对是值得一试的！用心搭配出来的多彩婚纱，充满创意的色彩概念，这样的婚纱照，岂不是让你如此与众不同？！</p><p>　　当然，要穿上五彩缤纷的流行色婚纱拍照，也要注意衣服颜色和自己的肤色是否搭配，还有发型发色的协调也是非常重要的！</p><p>　　第三、如何选择婚纱照服装的质地</p><p>　　在如此炎热的夏天，一切衣着都以清凉为前提，因此，婚纱也是如此！一定要尽量选择质地轻薄、做工简约的婚纱，轻纱裹体，新娘子曼妙身材也能展露无遗，气质自然也就更为温柔婉约了！</p>','content_news.html','','1','3天','西式+古典+中式','500张以上','室内+室外+海边（雪山）','6689元');
INSERT INTO `mo_offer` (`id`,`maintable_id`,`content`,`template`,`readpower`,`allowcomment`,`offer_time`,`offer_style`,`offer_sample`,`offer_place`,`offer_price`) VALUES ('4','9','<p>　　婚纱质地一般有常见的氨纶与真丝。当然，不管哪一种面料，婚纱的颜色和款式是最重要的，一定要根据自己的肤色、身型来选择搭配！</p><p>　　第四、婚纱照服装款式的选择</p><p>　　短款的婚纱照服装肯定是夏天拍婚纱照的第一选择！</p><p>　　而且，一般来说，短款礼服由于其设计理念，一般都显得更为活泼时尚，也更能体现新娘子的青春靓丽！</p><p>　　在轻柔的纱料中露出白皙匀称的小腿，性感之余，却也有一份雍容华贵！</p><p>　　不过，短款婚纱对新娘的腿部线条要求比较高，如果新娘子刚好有如此的好身材，那么，搭配上亮丽的颜色，效果更是完美！</p>','content_news.html','','1','4天','五种自选','800张以上','室内+室外+定制','8689元');
INSERT INTO `mo_offer` (`id`,`maintable_id`,`content`,`template`,`readpower`,`allowcomment`,`offer_time`,`offer_style`,`offer_sample`,`offer_place`,`offer_price`) VALUES ('5','10','<p>　　婚纱质地一般有常见的氨纶与真丝。当然，不管哪一种面料，婚纱的颜色和款式是最重要的，一定要根据自己的肤色、身型来选择搭配！</p><p>　　第四、婚纱照服装款式的选择</p><p>　　短款的婚纱照服装肯定是夏天拍婚纱照的第一选择！</p><p>　　而且，一般来说，短款礼服由于其设计理念，一般都显得更为活泼时尚，也更能体现新娘子的青春靓丽！</p><p>　　在轻柔的纱料中露出白皙匀称的小腿，性感之余，却也有一份雍容华贵！</p><p>　　不过，短款婚纱对新娘的腿部线条要求比较高，如果新娘子刚好有如此的好身材，那么，搭配上亮丽的颜色，效果更是完美！</p>','content_news.html','','1','十天以内','不限','不限','客户定制','10689元');
INSERT INTO `mo_payment` (`pay_id`,`pay_code`,`pay_name`,`pay_fee`,`pay_desc`,`pay_order`,`pay_config`,`enabled`,`is_cod`,`is_online`,`website`,`version`) VALUES ('1','1','支付宝','0','','0','','0','0','0','','');
INSERT INTO `mo_payment` (`pay_id`,`pay_code`,`pay_name`,`pay_fee`,`pay_desc`,`pay_order`,`pay_config`,`enabled`,`is_cod`,`is_online`,`website`,`version`) VALUES ('2','2','财付通','0','','0','','0','0','0','','');
INSERT INTO `mo_payment` (`pay_id`,`pay_code`,`pay_name`,`pay_fee`,`pay_desc`,`pay_order`,`pay_config`,`enabled`,`is_cod`,`is_online`,`website`,`version`) VALUES ('3','3','快钱','0','','0','','0','0','0','','');
INSERT INTO `mo_payment` (`pay_id`,`pay_code`,`pay_name`,`pay_fee`,`pay_desc`,`pay_order`,`pay_config`,`enabled`,`is_cod`,`is_online`,`website`,`version`) VALUES ('4','4','易宝','0','','0','','0','0','0','','');
INSERT INTO `mo_registdeal` (`id`,`name`,`iseffect`,`content`) VALUES ('1','默认注册协议','1','');
INSERT INTO `mo_remind` (`id`,`tpl_name`,`tpl_path`,`remind_type`,`status`,`created`) VALUES ('1','新注册会员首次登录','public/remind_first_login.html','2','2','1373440021');
INSERT INTO `mo_remind` (`id`,`tpl_name`,`tpl_path`,`remind_type`,`status`,`created`) VALUES ('2','会员升级','public/remind_member_upgrade.html','2','2','1368772590');
INSERT INTO `mo_remind` (`id`,`tpl_name`,`tpl_path`,`remind_type`,`status`,`created`) VALUES ('3','修改密码','public/remind_edit_password.html','2','2','1368772588');
INSERT INTO `mo_remind` (`id`,`tpl_name`,`tpl_path`,`remind_type`,`status`,`created`) VALUES ('4','会员到期提醒','public/remind_member_expire.html','2','2','1368688190');
INSERT INTO `mo_search` (`id`,`keywords`,`nums`) VALUES ('1','穿','4');
INSERT INTO `mo_search` (`id`,`keywords`,`nums`) VALUES ('2','夏天','10');
INSERT INTO `mo_search` (`id`,`keywords`,`nums`) VALUES ('3','1','4');
INSERT INTO `mo_search` (`id`,`keywords`,`nums`) VALUES ('4','婚纱','4');
INSERT INTO `mo_search` (`id`,`keywords`,`nums`) VALUES ('5','时尚','2');
INSERT INTO `mo_synchronize` (`id`,`name`,`appkey`,`secret`,`description`,`config`,`enabled`) VALUES ('1','新浪','','','','','0');
INSERT INTO `mo_synchronize` (`id`,`name`,`appkey`,`secret`,`description`,`config`,`enabled`) VALUES ('2','腾讯','','','','','0');
INSERT INTO `mo_synchronize` (`id`,`name`,`appkey`,`secret`,`description`,`config`,`enabled`) VALUES ('3','百度','','','','','0');
INSERT INTO `mo_synchronize` (`id`,`name`,`appkey`,`secret`,`description`,`config`,`enabled`) VALUES ('4','人人','','','','','0');
INSERT INTO `mo_synchronize` (`id`,`name`,`appkey`,`secret`,`description`,`config`,`enabled`) VALUES ('5','豆瓣','','','','','0');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('725','mo_addon_domain','附件目录的二级域名','7','string','');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('724','mo_addon_domainbind','附件目录是否绑定为指定的二级域名','7','bool','N');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('738','mo_addon_savetype','附件保存形式(按data函数日期参数)','3','string','');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('66','mo_album_col','图集多行多列样式默认列数','3','number','');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('69','mo_album_ddwidth','图集默认缩略图大小','3','number','200');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('746','mo_album_mark','图集是否使用水印(小图也会受影响)','3','bool','N');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('67','mo_album_pagesize','图集多页多图每页显示最大数','3','number','12');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('65','mo_album_row','图集多行多列样式默认行数','3','number','');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('68','mo_album_style','图集默认样式<br/>1为多页多图,2为多页单图,3为缩略图列表','3','number','');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('63','mo_album_width','图集默认显示图片的大小','3','number','800');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('707','mo_allsearch_limit','网站全局搜索时间限制','2','string','1');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('30','mo_arcautosp','(是/否)开启长文章自动分页','6','bool','N');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('31','mo_arcautosp_size','文章自动分页大小（单位:K）','6','number','5');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('31','mo_arcautosp_sum','文章字符个数（单位:个）','6','number','200');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('10','mo_arcdir','文档HTML默认保存路径','1','string','/a');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('29','mo_arcsptitle','(是/否)开启分页标题，开启会影响HTML生成速度','6','bool','N');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('61','mo_arc_autokeyword','自动提取关键字','7','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('60','mo_arc_autopic','提取第一张图片作为缩略图','7','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('737','mo_arc_click','文档默认点击数(-1表示随机50-200)','7','number','-1');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('59','mo_arc_dellink','删除非站内链接','7','bool','N');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('735','mo_arc_dirname','是否允许用目录作为文档文件名<br/>文档命名规则需改为：{typedir}/{aid}/index.html','7','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('32','mo_auot_description','自动摘要长度（0-250，0表示不启用）','7','number','240');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('5','mo_backup_dir','数据备份目录（在data目录内）','2','string','backupdata');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('95','mo_baidunews_limit','百度新闻xml更新新闻数量最大100','8','string','100');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('712','mo_beian','网站备案号','1','string','');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('716','mo_cache_type','id文档ID，content标签最终内容<br/>(修改此变量后必须更新系统缓存)','6','string','id');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('89','mo_caicai_add','被顶扣除文章好评度','5','number','2');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('88','mo_caicai_sub','被踩扣除文章好评度','5','number','2');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('64','mo_check_title','发布文档时是否检测重复标题','7','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('47','mo_cli_time','服务器时区设置','2','number','8');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('3','mo_cookie_encode','cookie加密码','2','string','SaQDl2195N');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('759','mo_cross_sectypeid','支持交叉栏目显示副栏目内容','7','bool','N');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('743','mo_ddimg_bgcolor','缩略图空白背景填充颜色(0-白,1-黑)','3','number','0');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('742','mo_ddimg_full','缩略图是否使用强制大小(对背景填充)','3','bool','N');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('13','mo_ddimg_height','缩略图默认高度','3','number','150');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('12','mo_ddimg_width','缩略图默认宽度','3','number','80');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('709','mo_delete','文章回收站(是/否)开启','2','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('711','mo_description','站点描述','1','bstring','爱站CMS是一款专业的内容管理系统,适合广大设计师、技术人员以及想建立自己网站的用户来搭建自己的网站。爱站CMS采用PHP语言进行编写，开源设计，方便广大技术应用人员的修改和使用。');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('726','mo_df_dutyadmin','默认责任编辑(dutyadmin)','7','string','admin');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('24','mo_df_style','模板默认风格','1','string','default');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('760','mo_digg_update','顶踩缓存异步更新间隔（0为不缓存）','6','number','0');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('731','mo_face_adds','上传头像增加积分','5','number','10');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('23','mo_fck_xhtml','编辑器(是/否)使用XHTML','1','bool','N');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('21','mo_feedbackcheck','评论及留言(是/否)需审核','5','bool','N');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('90','mo_feedback_add','详细好评可获好评度','5','number','5');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('39','mo_feedback_ck','评论加验证码重确认','5','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('721','mo_feedback_forbid','是否禁止所有评论(将包括禁止顶踩等)','5','bool','N');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('761','mo_feedback_guest','是否允许匿名评论','5','bool','N');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('77','mo_feedback_numip','每个IP一小时内最大评论数','5','number','30');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('91','mo_feedback_sub','详细恶评扣除好评度','5','number','5');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('76','mo_feedback_time','两次评论至少间隔时间(秒钟)','5','number','30');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('33','mo_ftp_host','FTP主机','2','string','');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('38','mo_ftp_mkdir','是否强制用FTP创建目录','2','bool','N');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('34','mo_ftp_port','FTP端口','2','number','21');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('36','mo_ftp_pwd','FTP密码','2','string','');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('37','mo_ftp_root','网站根在FTP中的目录','2','string','/');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('35','mo_ftp_user','FTP用户名','2','string','');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('9','mo_html_editor','Html编辑器（ckeditor,需要fck的用户可以去官网下载）','2','string','ckeditor');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('15','mo_imgtype','图片浏览器文件类型','3','string','jpg|gif|png');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('6','mo_indexname','主页链接名','1','string','主页');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('53','mo_index_cache','arclist标签调用缓存<br/>(0不启用，大于0值为多少秒)','6','number','86400');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('52','mo_index_max','网站主页调用函数最大索引文档数<br>不适用于经常单栏目采集过多内容的网站<br>不启用本项此值设置为0即可','6','number','10000');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('722','mo_jump_once','跳转网址是否直接跳转？（否则显示中转页）','7','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('710','mo_keywords','站点默认关键字','1','string','开源;建站;免费;CMS;爱站;铭万;mainone;官网;智能网站;金榜;内容管理;必途;');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('51','mo_keyword_like','使用关键词关连文章','6','bool','N');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('22','mo_keyword_replace','关键字替换(是/否)使用本功能会影响HTML生成速度','2','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('40','mo_list_son','上级列表是否包含子类内容','6','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('19','mo_list_symbol','栏目位置的间隔符号','2','string','>');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('740','mo_login_adds','登录会员中心获积分','5','number','2');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('719','mo_makeindex','发布文章后马上更新网站主页','6','bool','N');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('56','mo_makesign_cache','发布/修改单个文档是否使用调用缓存','6','bool','N');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('719','mo_make_andcat','发表文章后马上更新相关栏目','6','bool','N');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('720','mo_make_prenext','发表文章后马上更新上下篇','6','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('717','mo_max_face','会员上传头像大小限制(单位：KB)','3','number','50');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('48','mo_mb_addontype','会员附件许可的类型','4','bstring','swf|mpg|mp3|rm|rmvb|wmv|wma|wav|mid|mov|zip|rar|doc|xsl|ppt|wps');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('729','mo_mb_adminlock','是否禁止访问管理员帐号的空间','4','bool','N');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('42','mo_mb_album','是否开启会员图集功能','4','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('727','mo_mb_allowncarc','是否允许用户空间显示未审核文章','4','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('728','mo_mb_allowreg','是否允许新会员注册','4','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('83','mo_mb_cktitle','会员投稿是否检测重复标题','5','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('84','mo_mb_editday','投稿多长时间后不能再修改[天]','5','number','7');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('747','mo_mb_feedcheck','会员动态是否需要审核','4','bool','N');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('71','mo_mb_idmin','用户id最小长度','4','number','3');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('49','mo_mb_max','会员附件总大小限制(MB)','4','number','500');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('748','mo_mb_msgischeck','会员状态是否需要审核','4','bool','N');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('70','mo_mb_notallow','不允许注册的会员id','4','bstring','www,bbs,ftp,mail,user,users,admin,administrator');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('41','mo_mb_open','是否开启会员功能','4','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('72','mo_mb_pwdmin','用户密码最小长度','4','number','3');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('72','mo_mb_pwdtype','前台密码验证类型：默认32—32位md5，可选：<br/>l16—前16位，r16—后16位，m16—中间16位','4','string','32');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('74','mo_mb_rank','注册会员默认级别<br>[会员权限管理中]查看级别代表的数字','4','number','10');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('749','mo_mb_reginfo','注册是否需要完成详细资料的填写','4','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('46','mo_mb_rmdown','是否把会员指定的远程文档下载到本地','4','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('45','mo_mb_sendall','是否开放会员对自定义模型投稿','4','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('730','mo_mb_spaceallarc','会员空间中所有文档的频道ID(不限为0)','4','number','0');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('79','mo_mb_spacesta','会员使用权限开通状态<br>(-10邮件验证-1手工审核,0没限制)','4','number','-10');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('43','mo_mb_upload','是否允许会员上传非图片附件','4','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('44','mo_mb_upload_size','会员上传文件大小(K)','4','number','1024');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('734','mo_mb_wnameone','是否允许用户笔名/昵称重复','4','bool','N');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('73','mo_md_idurl','是否严格限定会员登录id<br>允许会员使用二级域名必须设置此项','4','bool','N');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('78','mo_md_mailtest','是否限制Email只能注册一个帐号','4','bool','N');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('11','mo_logo_dir','网站LOGO图片默认路径','1','string','/logo/{EB705512-8961-A6B6-24D8-089C8CAFC2CA}.png');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('17','mo_mediatype','允许的多媒体文件类型','3','bstring','mp3|mp4|swf|flv|wmv');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('26','mo_picturetype','允许上传的图片类型','3','bstring','jpg|png|bmp|gif');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('50','mo_filetype','允许上传的文件类型','3','bstring','php|jsp|doc|xls|zip|rar');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('756','mo_memcache_enable','是否启用memcache缓存，如果为否(N)，默认使用文件缓存','6','bool','N');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('757','mo_memcache_mc_defa','默认memcache缓存服务器地址','6','string','memcache://127.0.0.1:11211/default127');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('758','mo_memcache_mc_oth','附加memcache缓存服务器地址','6','string','');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('733','mo_money_scores','多少积分可以兑换一个金币','5','number','50');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('732','mo_moreinfo_adds','填写详细资料增加积分','5','number','20');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('25','mo_multi_site','(是/否)支持多站点，开启此项后附件、栏目连接、arclist内容启用绝对网址','2','bool','N');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('752','mo_mysql_type','数据库类型（支持mysql和mysqli）','2','string','mysql');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('713','mo_need_typeid2','是否启用副栏目','6','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('227','mo_online_type','在线支付网关类型','2','string','nps');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('28','mo_powerby','网站版权信息','1','bstring','婚纱摄影模板版权所有©2009-2013铭万智达科技有限公司版权归铭万所有盗用必究');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('736','mo_puccache_time','需缓存内容全局缓存时间(秒)','6','number','36000');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('739','mo_qk_uploadlit','异步上传缩略图(空间太不稳定的用户关闭此项)','3','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('750','mo_remote_site','是否启用远程站点','2','bool','N');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('20','mo_replacestr','被替换词语<br/>用|分开，但不要在结尾加|','5','bstring','她妈|它妈|他妈|你妈|去死|贱人');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('20','mo_replacer','替换后词语','5','string','***');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('20','mo_replace_type','替换方式','5','number','1');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('744','mo_replace_num','文档内容同一关键词替换次数(0为全部替换)','7','number','2');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('708','mo_rewrite','是否使用伪静态','2','bool','N');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('58','mo_rm_remote','远程图片本地化','7','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('92','mo_search_max','最大搜索检查文档数','6','number','50000');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('93','mo_search_maxrc','最大返回搜索结果数','6','number','300');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('94','mo_search_time','搜索间隔时间(秒/对网站所有用户)','6','number','3');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('729','mo_sendarc_scores','投稿可获取积分','5','number','10');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('730','mo_sendfb_scores','参与评论可获积分','5','number','3');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('221','mo_sendmail_bysmtp','是否启用smtp方式发送邮件','2','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('226','mo_smtp_password','发送邮件邮箱密码','2','string','7260444huxiao');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('223','mo_smtp_port','smtp服务器端口','2','string','25');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('222','mo_smtp_server','smtp服务器','2','string','smtp.qq.com');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('225','mo_smtp_user','发送邮件用户名称','2','string','desdev');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('224','mo_smtp_usermail','发送邮件邮箱账号','2','string','desdev@vip.qq.com');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('16','mo_addon_num','允许上传附件数量','3','number','5');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('18','mo_specnote','专题的最大节点数','2','number','6');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('753','mo_sphinx_article','是否启用文章全文检索功能（需配置sphinx服务器）','7','bool','N');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('754','mo_sphinx_host','Sphinx服务器主机地址','7','string','localhost');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('755','mo_sphinx_port','Sphinx服务器端口号','7','number','9312');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('723','mo_task_pwd','系统计划任务客户端许可密码<br/>(需要客户端，通常不会太重要)','7','string','');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('62','mo_title_maxlen','文档标题最大长度<br>改此参数后需要手工修改数据表','7','number','60');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('751','mo_title_site','是否发布和编辑文档时远程发布(启用远程站点的前提下)','2','bool','N');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('54','mo_tplcache','是否启用模板缓存','6','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('55','mo_tplcache_dir','模板缓存目录','6','string','/data/tplcache');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('718','mo_typedir_df','栏目网址使用目录名（不显示默认页，即是/a/abc/形式）','2','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('96','mo_updateperi','百度新闻xml更新时间（单位：分钟）','8','string','15');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('745','mo_uplitpic_cut','上传缩略图后是否马上弹出裁剪框','3','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('706','mo_upload_switch','删除文章文件同时删除相关附件文件','2','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('741','mo_userad_adds','会员推广获积分','5','number','10');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('81','mo_vdcode_member','会员投稿是否使用验证码','5','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('7','mo_webname','网站名称','1','string','爱站CMS婚纱摄影类模板4');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('907','mo_shut_down','是否关闭网站','1','bool','N');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('907','mo_shut_reason','网站关闭原因','1','string','网站正在维护...');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('908','mo_captcha_reg','注册页使用验证码','11','bool','');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('909','mo_captcha_log','登录页使用验证码','11','bool','');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('910','mo_captcha_com','评论页使用验证码','11','bool','');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('911','mo_captcha_type','验证码类型','11','string','mix');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('912','mo_color_rand','颜色随机','11','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('913','mo_lean_rand','倾斜度随机','11','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('914','mo_date_format','日期格式','11','string','年-月-日');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('915','mo_time_format','时间格式','11','string','时:分:秒');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('916','mo_time_zone','时区','11','string','中国北京');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('917','mo_ip_forbid','启用IP禁止','11','bool','N');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('918','mo_forbidden_area','IP禁止区域','11','string','');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('919','mo_forbidden_start','IP段禁止起始','11','string','');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('910','mo_forbidden_end','IP段禁止结束','11','string','');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('911','mo_admin_log','启用后台管理操作日志','11','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('912','mo_save_error_log','保存错误日志','11','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('913','mo_max_logintime','最大失败登录次数','11','number','8');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('110','mo_start_watermark','上传图片开启水印功能','8','bool','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('111','mo_watermark_type','水印类型','8','string','image');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('112','mo_watermark_dir','水印图片路径','8','string','/uploadfile');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('113','mo_img_diaphaneity','水印图片透明度/百分比','8','number','50');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('114','mo_img_scaling','水印图片缩放比/百分比','8','number','50');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('115','mo_mark_content','水印图片上文字内容','8','string','铭万');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('116','mo_word_size','水印图片文字大小','8','string','12');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('117','mo_word_color','水印图片字体颜色','8','string','#3DE63');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('118','mo_mark_position','水印图片上文字位置','8','string','rb');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('119','mo_markimage_url','水印图片保存路径','8','string','');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('120','mo_notice_type','系统告知提醒方式','8','number','1');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('121','mo_notice_login','注册提醒模板','8','string','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('121','mo_notice_update','升级提醒模板','8','string','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('121','mo_notice_password','修改密码提醒模板','8','string','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('121','mo_notice_deadline','回到到期提醒模板','8','string','Y');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('901','mo_send_style','邮件发送方式','9','int','1');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('902','mo_send_user','发送邮件用户名称','9','string','example');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('903','mo_service','SMTP服务器','9','string','example.163.com');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('904','mo_service_port','SMTP服务器端口','9','int','25');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('905','mo_mail_account','发送邮件邮箱账号','9','string','example@sohu.com');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('906','mo_mail_password','发送邮件邮箱密码','9','string','example');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('101','mo_isanony','是否允许匿名','10','smallint','');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('102','mo_isexamine','是否审核','10','smallint','');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('103','mo_max_num','每页最多条数','10','int','');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('104','mo_word_num','留言最多字数','10','int','');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('905','mo_forbidname','禁止用户名','12','string','');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('906','mo_forbidemail','禁止的email','12','string','');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('101','mo_allowemail','允许的email','12','string','');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('102','mo_forbidip','禁止的ip','12','string','');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('103','mo_allowip','允许的ip','12','string','');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('104','mo_flag','是否允许同一个E-mail注册多个用户','12','smallint','');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('1','mo_basehost','站点根网址','1','string','http://demo4.izhancms.com');
INSERT INTO `mo_web_config` (`par_id`,`par_name`,`info`,`group_id`,`par_type`,`par_value`) VALUES ('105','mo_izhan_copyright','控制爱站CMS版权信息显示与否','1','string','Y');
