/*
 * Decompiled with CFR 0.152.
 */
package android.accessibilityservice;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.accessibilityservice.IAccessibilityServiceConnection;
import android.accessibilityservice.IEventListener;
import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.view.accessibility.AccessibilityEvent;
import com.android.internal.os.HandlerCaller;

public abstract class AccessibilityService
extends Service {
    private static final String LOG_TAG = "AccessibilityService";
    public static final String SERVICE_INTERFACE = "android.accessibilityservice.AccessibilityService";
    IAccessibilityServiceConnection mConnection;
    private AccessibilityServiceInfo mInfo;

    private void sendServiceInfo() {
        if (this.mInfo == null) {
            return;
        }
        if (this.mConnection == null) {
            return;
        }
        try {
            IAccessibilityServiceConnection iAccessibilityServiceConnection = this.mConnection;
            AccessibilityServiceInfo accessibilityServiceInfo = this.mInfo;
            iAccessibilityServiceConnection.setServiceInfo(accessibilityServiceInfo);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.w(LOG_TAG, "Error while setting AccessibilityServiceInfo", remoteException);
            return;
        }
    }

    public abstract void onAccessibilityEvent(AccessibilityEvent var1);

    @Override
    public final IBinder onBind(Intent intent) {
        return new IEventListenerWrapper(this);
    }

    public abstract void onInterrupt();

    protected void onServiceConnected() {
    }

    public final void setServiceInfo(AccessibilityServiceInfo accessibilityServiceInfo) {
        this.mInfo = accessibilityServiceInfo;
        this.sendServiceInfo();
    }

    class IEventListenerWrapper
    extends IEventListener.Stub
    implements HandlerCaller.Callback {
        private static final int DO_ON_ACCESSIBILITY_EVENT = 30;
        private static final int DO_ON_INTERRUPT = 20;
        private static final int DO_SET_SET_CONNECTION = 10;
        private final HandlerCaller mCaller;
        private final AccessibilityService mTarget;

        public IEventListenerWrapper(AccessibilityService accessibilityService2) {
            HandlerCaller handlerCaller;
            this.mTarget = accessibilityService2;
            this.mCaller = handlerCaller = new HandlerCaller(accessibilityService2, this);
        }

        @Override
        public void executeMessage(Message message) {
            IAccessibilityServiceConnection iAccessibilityServiceConnection;
            switch (message.what) {
                default: {
                    StringBuilder stringBuilder = new StringBuilder().append("Unknown message type ");
                    int n = message.what;
                    String string2 = stringBuilder.append(n).toString();
                    int n2 = Log.w(AccessibilityService.LOG_TAG, string2);
                    return;
                }
                case 30: {
                    AccessibilityEvent accessibilityEvent = (AccessibilityEvent)message.obj;
                    if (accessibilityEvent == null) {
                        return;
                    }
                    this.mTarget.onAccessibilityEvent(accessibilityEvent);
                    accessibilityEvent.recycle();
                    return;
                }
                case 20: {
                    this.mTarget.onInterrupt();
                    return;
                }
                case 10: 
            }
            AccessibilityService accessibilityService = AccessibilityService.this;
            accessibilityService.mConnection = iAccessibilityServiceConnection = (IAccessibilityServiceConnection)message.obj;
            this.mTarget.onServiceConnected();
        }

        @Override
        public void onAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
            Message message = this.mCaller.obtainMessageO(30, accessibilityEvent);
            this.mCaller.sendMessage(message);
        }

        @Override
        public void onInterrupt() {
            Message message = this.mCaller.obtainMessage(20);
            this.mCaller.sendMessage(message);
        }

        @Override
        public void setConnection(IAccessibilityServiceConnection iAccessibilityServiceConnection) {
            Message message = this.mCaller.obtainMessageO(10, iAccessibilityServiceConnection);
            this.mCaller.sendMessage(message);
        }
    }
}

