/*
 * Decompiled with CFR 0.152.
 */
package android.accounts;

import android.accounts.Account;
import android.accounts.AccountAuthenticatorResponse;
import android.accounts.AccountManager;
import android.accounts.IAccountAuthenticator;
import android.accounts.IAccountAuthenticatorResponse;
import android.accounts.NetworkErrorException;
import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.util.Arrays;
import java.util.Set;

public abstract class AbstractAccountAuthenticator {
    private static final String TAG = "AccountAuthenticator";
    private final Context mContext;
    private Transport mTransport;

    public AbstractAccountAuthenticator(Context context) {
        Transport transport;
        this.mTransport = transport = new Transport();
        this.mContext = context;
    }

    private void checkBinderPermission() {
        int n = Binder.getCallingUid();
        if (this.mContext.checkCallingOrSelfPermission("android.permission.ACCOUNT_MANAGER") == 0) {
            return;
        }
        String string2 = "caller uid " + n + " lacks " + "android.permission.ACCOUNT_MANAGER";
        throw new SecurityException(string2);
    }

    public abstract Bundle addAccount(AccountAuthenticatorResponse var1, String var2, String var3, String[] var4, Bundle var5) throws NetworkErrorException;

    public abstract Bundle confirmCredentials(AccountAuthenticatorResponse var1, Account var2, Bundle var3) throws NetworkErrorException;

    public abstract Bundle editProperties(AccountAuthenticatorResponse var1, String var2);

    public Bundle getAccountRemovalAllowed(AccountAuthenticatorResponse accountAuthenticatorResponse, Account account) throws NetworkErrorException {
        Bundle bundle = new Bundle();
        bundle.putBoolean("booleanResult", true);
        return bundle;
    }

    public abstract Bundle getAuthToken(AccountAuthenticatorResponse var1, Account var2, String var3, Bundle var4) throws NetworkErrorException;

    public abstract String getAuthTokenLabel(String var1);

    public final IBinder getIBinder() {
        return this.mTransport.asBinder();
    }

    public abstract Bundle hasFeatures(AccountAuthenticatorResponse var1, Account var2, String[] var3) throws NetworkErrorException;

    public abstract Bundle updateCredentials(AccountAuthenticatorResponse var1, Account var2, String var3, Bundle var4) throws NetworkErrorException;

    private class Transport
    extends IAccountAuthenticator.Stub {
        private Transport() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void addAccount(IAccountAuthenticatorResponse iAccountAuthenticatorResponse, String string2, String string3, String[] stringArray, Bundle bundle) throws RemoteException {
            if (Log.isLoggable(AbstractAccountAuthenticator.TAG, 2)) {
                String string4 = AbstractAccountAuthenticator.TAG;
                StringBuilder stringBuilder = new StringBuilder().append("addAccount: accountType ").append(string2).append(", authTokenType ").append(string3).append(", features ");
                String string5 = stringArray == null ? "[]" : Arrays.toString(stringArray);
                String string6 = stringBuilder.append(string5).toString();
                int n = Log.v(string4, string6);
            }
            AbstractAccountAuthenticator.this.checkBinderPermission();
            try {
                AbstractAccountAuthenticator abstractAccountAuthenticator = AbstractAccountAuthenticator.this;
                AccountAuthenticatorResponse accountAuthenticatorResponse = new AccountAuthenticatorResponse(iAccountAuthenticatorResponse);
                String string7 = string2;
                String string8 = string3;
                String[] stringArray2 = stringArray;
                Bundle bundle2 = bundle;
                Bundle bundle3 = abstractAccountAuthenticator.addAccount(accountAuthenticatorResponse, string7, string8, stringArray2, bundle2);
                if (Log.isLoggable(AbstractAccountAuthenticator.TAG, 2)) {
                    Set<String> set = bundle3.keySet();
                    StringBuilder stringBuilder = new StringBuilder().append("addAccount: result ");
                    Bundle bundle4 = AccountManager.sanitizeResult(bundle3);
                    String string9 = stringBuilder.append(bundle4).toString();
                    int n = Log.v(AbstractAccountAuthenticator.TAG, string9);
                }
                if (bundle3 == null) {
                    return;
                }
                iAccountAuthenticatorResponse.onResult(bundle3);
                return;
            }
            catch (NetworkErrorException networkErrorException) {
                if (Log.isLoggable(AbstractAccountAuthenticator.TAG, 2)) {
                    int n = Log.v(AbstractAccountAuthenticator.TAG, "addAccount", networkErrorException);
                }
                String string10 = networkErrorException.getMessage();
                iAccountAuthenticatorResponse.onError(3, string10);
                return;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (Log.isLoggable(AbstractAccountAuthenticator.TAG, 2)) {
                    int n = Log.v(AbstractAccountAuthenticator.TAG, "addAccount", unsupportedOperationException);
                }
                iAccountAuthenticatorResponse.onError(6, "addAccount not supported");
                return;
            }
        }

        @Override
        public void confirmCredentials(IAccountAuthenticatorResponse iAccountAuthenticatorResponse, Account account, Bundle bundle) throws RemoteException {
            if (Log.isLoggable(AbstractAccountAuthenticator.TAG, 2)) {
                String string2 = "confirmCredentials: " + account;
                int n = Log.v(AbstractAccountAuthenticator.TAG, string2);
            }
            AbstractAccountAuthenticator.this.checkBinderPermission();
            try {
                AbstractAccountAuthenticator abstractAccountAuthenticator = AbstractAccountAuthenticator.this;
                AccountAuthenticatorResponse accountAuthenticatorResponse = new AccountAuthenticatorResponse(iAccountAuthenticatorResponse);
                Bundle bundle2 = abstractAccountAuthenticator.confirmCredentials(accountAuthenticatorResponse, account, bundle);
                if (Log.isLoggable(AbstractAccountAuthenticator.TAG, 2)) {
                    Set<String> set = bundle2.keySet();
                    StringBuilder stringBuilder = new StringBuilder().append("confirmCredentials: result ");
                    Bundle bundle3 = AccountManager.sanitizeResult(bundle2);
                    String string3 = stringBuilder.append(bundle3).toString();
                    int n = Log.v(AbstractAccountAuthenticator.TAG, string3);
                }
                if (bundle2 == null) {
                    return;
                }
                iAccountAuthenticatorResponse.onResult(bundle2);
                return;
            }
            catch (NetworkErrorException networkErrorException) {
                if (Log.isLoggable(AbstractAccountAuthenticator.TAG, 2)) {
                    int n = Log.v(AbstractAccountAuthenticator.TAG, "confirmCredentials", networkErrorException);
                }
                String string4 = networkErrorException.getMessage();
                iAccountAuthenticatorResponse.onError(3, string4);
                return;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (Log.isLoggable(AbstractAccountAuthenticator.TAG, 2)) {
                    int n = Log.v(AbstractAccountAuthenticator.TAG, "confirmCredentials", unsupportedOperationException);
                }
                iAccountAuthenticatorResponse.onError(6, "confirmCredentials not supported");
                return;
            }
        }

        @Override
        public void editProperties(IAccountAuthenticatorResponse iAccountAuthenticatorResponse, String string2) throws RemoteException {
            AbstractAccountAuthenticator.this.checkBinderPermission();
            try {
                AbstractAccountAuthenticator abstractAccountAuthenticator = AbstractAccountAuthenticator.this;
                AccountAuthenticatorResponse accountAuthenticatorResponse = new AccountAuthenticatorResponse(iAccountAuthenticatorResponse);
                Bundle bundle = abstractAccountAuthenticator.editProperties(accountAuthenticatorResponse, string2);
                if (bundle == null) {
                    return;
                }
                iAccountAuthenticatorResponse.onResult(bundle);
                return;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                iAccountAuthenticatorResponse.onError(6, "editProperties not supported");
                return;
            }
        }

        @Override
        public void getAccountRemovalAllowed(IAccountAuthenticatorResponse iAccountAuthenticatorResponse, Account account) throws RemoteException {
            AbstractAccountAuthenticator.this.checkBinderPermission();
            try {
                AbstractAccountAuthenticator abstractAccountAuthenticator = AbstractAccountAuthenticator.this;
                AccountAuthenticatorResponse accountAuthenticatorResponse = new AccountAuthenticatorResponse(iAccountAuthenticatorResponse);
                Bundle bundle = abstractAccountAuthenticator.getAccountRemovalAllowed(accountAuthenticatorResponse, account);
                if (bundle == null) {
                    return;
                }
                iAccountAuthenticatorResponse.onResult(bundle);
                return;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                iAccountAuthenticatorResponse.onError(6, "getAccountRemovalAllowed not supported");
                return;
            }
            catch (NetworkErrorException networkErrorException) {
                String string2 = networkErrorException.getMessage();
                iAccountAuthenticatorResponse.onError(3, string2);
                return;
            }
        }

        @Override
        public void getAuthToken(IAccountAuthenticatorResponse iAccountAuthenticatorResponse, Account account, String string2, Bundle bundle) throws RemoteException {
            if (Log.isLoggable(AbstractAccountAuthenticator.TAG, 2)) {
                String string3 = "getAuthToken: " + account + ", authTokenType " + string2;
                int n = Log.v(AbstractAccountAuthenticator.TAG, string3);
            }
            AbstractAccountAuthenticator.this.checkBinderPermission();
            try {
                AbstractAccountAuthenticator abstractAccountAuthenticator = AbstractAccountAuthenticator.this;
                AccountAuthenticatorResponse accountAuthenticatorResponse = new AccountAuthenticatorResponse(iAccountAuthenticatorResponse);
                Bundle bundle2 = abstractAccountAuthenticator.getAuthToken(accountAuthenticatorResponse, account, string2, bundle);
                if (Log.isLoggable(AbstractAccountAuthenticator.TAG, 2)) {
                    Set<String> set = bundle2.keySet();
                    StringBuilder stringBuilder = new StringBuilder().append("getAuthToken: result ");
                    Bundle bundle3 = AccountManager.sanitizeResult(bundle2);
                    String string4 = stringBuilder.append(bundle3).toString();
                    int n = Log.v(AbstractAccountAuthenticator.TAG, string4);
                }
                if (bundle2 == null) {
                    return;
                }
                iAccountAuthenticatorResponse.onResult(bundle2);
                return;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (Log.isLoggable(AbstractAccountAuthenticator.TAG, 2)) {
                    int n = Log.v(AbstractAccountAuthenticator.TAG, "getAuthToken", unsupportedOperationException);
                }
                iAccountAuthenticatorResponse.onError(6, "getAuthToken not supported");
                return;
            }
            catch (NetworkErrorException networkErrorException) {
                if (Log.isLoggable(AbstractAccountAuthenticator.TAG, 2)) {
                    int n = Log.v(AbstractAccountAuthenticator.TAG, "getAuthToken", networkErrorException);
                }
                String string5 = networkErrorException.getMessage();
                iAccountAuthenticatorResponse.onError(3, string5);
                return;
            }
        }

        @Override
        public void getAuthTokenLabel(IAccountAuthenticatorResponse iAccountAuthenticatorResponse, String string2) throws RemoteException {
            if (Log.isLoggable(AbstractAccountAuthenticator.TAG, 2)) {
                String string3 = "getAuthTokenLabel: authTokenType " + string2;
                int n = Log.v(AbstractAccountAuthenticator.TAG, string3);
            }
            AbstractAccountAuthenticator.this.checkBinderPermission();
            try {
                Bundle bundle = new Bundle();
                String string4 = AbstractAccountAuthenticator.this.getAuthTokenLabel(string2);
                bundle.putString("authTokenLabelKey", string4);
                if (Log.isLoggable(AbstractAccountAuthenticator.TAG, 2)) {
                    Set<String> set = bundle.keySet();
                    StringBuilder stringBuilder = new StringBuilder().append("getAuthTokenLabel: result ");
                    Bundle bundle2 = AccountManager.sanitizeResult(bundle);
                    String string5 = stringBuilder.append(bundle2).toString();
                    int n = Log.v(AbstractAccountAuthenticator.TAG, string5);
                }
                if (bundle == null) {
                    return;
                }
                iAccountAuthenticatorResponse.onResult(bundle);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (Log.isLoggable(AbstractAccountAuthenticator.TAG, 2)) {
                    int n = Log.v(AbstractAccountAuthenticator.TAG, "getAuthTokenLabel", illegalArgumentException);
                }
                iAccountAuthenticatorResponse.onError(7, "unknown authTokenType");
                return;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (Log.isLoggable(AbstractAccountAuthenticator.TAG, 2)) {
                    int n = Log.v(AbstractAccountAuthenticator.TAG, "getAuthTokenLabel", unsupportedOperationException);
                }
                iAccountAuthenticatorResponse.onError(6, "getAuthTokenTypeLabel not supported");
                return;
            }
        }

        @Override
        public void hasFeatures(IAccountAuthenticatorResponse iAccountAuthenticatorResponse, Account account, String[] stringArray) throws RemoteException {
            AbstractAccountAuthenticator.this.checkBinderPermission();
            try {
                AbstractAccountAuthenticator abstractAccountAuthenticator = AbstractAccountAuthenticator.this;
                AccountAuthenticatorResponse accountAuthenticatorResponse = new AccountAuthenticatorResponse(iAccountAuthenticatorResponse);
                Bundle bundle = abstractAccountAuthenticator.hasFeatures(accountAuthenticatorResponse, account, stringArray);
                if (bundle == null) {
                    return;
                }
                iAccountAuthenticatorResponse.onResult(bundle);
                return;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                iAccountAuthenticatorResponse.onError(6, "hasFeatures not supported");
                return;
            }
            catch (NetworkErrorException networkErrorException) {
                String string2 = networkErrorException.getMessage();
                iAccountAuthenticatorResponse.onError(3, string2);
                return;
            }
        }

        @Override
        public void updateCredentials(IAccountAuthenticatorResponse iAccountAuthenticatorResponse, Account account, String string2, Bundle bundle) throws RemoteException {
            if (Log.isLoggable(AbstractAccountAuthenticator.TAG, 2)) {
                String string3 = "updateCredentials: " + account + ", authTokenType " + string2;
                int n = Log.v(AbstractAccountAuthenticator.TAG, string3);
            }
            AbstractAccountAuthenticator.this.checkBinderPermission();
            try {
                AbstractAccountAuthenticator abstractAccountAuthenticator = AbstractAccountAuthenticator.this;
                AccountAuthenticatorResponse accountAuthenticatorResponse = new AccountAuthenticatorResponse(iAccountAuthenticatorResponse);
                Bundle bundle2 = abstractAccountAuthenticator.updateCredentials(accountAuthenticatorResponse, account, string2, bundle);
                if (Log.isLoggable(AbstractAccountAuthenticator.TAG, 2)) {
                    Set<String> set = bundle2.keySet();
                    StringBuilder stringBuilder = new StringBuilder().append("updateCredentials: result ");
                    Bundle bundle3 = AccountManager.sanitizeResult(bundle2);
                    String string4 = stringBuilder.append(bundle3).toString();
                    int n = Log.v(AbstractAccountAuthenticator.TAG, string4);
                }
                if (bundle2 == null) {
                    return;
                }
                iAccountAuthenticatorResponse.onResult(bundle2);
                return;
            }
            catch (NetworkErrorException networkErrorException) {
                if (Log.isLoggable(AbstractAccountAuthenticator.TAG, 2)) {
                    int n = Log.v(AbstractAccountAuthenticator.TAG, "updateCredentials", networkErrorException);
                }
                String string5 = networkErrorException.getMessage();
                iAccountAuthenticatorResponse.onError(3, string5);
                return;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (Log.isLoggable(AbstractAccountAuthenticator.TAG, 2)) {
                    int n = Log.v(AbstractAccountAuthenticator.TAG, "updateCredentials", unsupportedOperationException);
                }
                iAccountAuthenticatorResponse.onError(6, "updateCredentials not supported");
                return;
            }
        }
    }
}

