/*
 * Decompiled with CFR 0.152.
 */
package android.accounts;

import android.accounts.Account;
import android.accounts.AccountManagerCallback;
import android.accounts.AccountManagerFuture;
import android.accounts.AccountManagerResponse;
import android.accounts.AuthenticatorDescription;
import android.accounts.AuthenticatorException;
import android.accounts.IAccountManager;
import android.accounts.IAccountManagerResponse;
import android.accounts.OnAccountsUpdateListener;
import android.accounts.OperationCanceledException;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.SQLException;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AccountManager {
    public static final String ACTION_AUTHENTICATOR_INTENT = "android.accounts.AccountAuthenticator";
    public static final String AUTHENTICATOR_ATTRIBUTES_NAME = "account-authenticator";
    public static final String AUTHENTICATOR_META_DATA_NAME = "android.accounts.AccountAuthenticator";
    public static final int ERROR_CODE_BAD_ARGUMENTS = 7;
    public static final int ERROR_CODE_BAD_REQUEST = 8;
    public static final int ERROR_CODE_CANCELED = 4;
    public static final int ERROR_CODE_INVALID_RESPONSE = 5;
    public static final int ERROR_CODE_NETWORK_ERROR = 3;
    public static final int ERROR_CODE_REMOTE_EXCEPTION = 1;
    public static final int ERROR_CODE_UNSUPPORTED_OPERATION = 6;
    public static final String KEY_ACCOUNTS = "accounts";
    public static final String KEY_ACCOUNT_AUTHENTICATOR_RESPONSE = "accountAuthenticatorResponse";
    public static final String KEY_ACCOUNT_MANAGER_RESPONSE = "accountManagerResponse";
    public static final String KEY_ACCOUNT_NAME = "authAccount";
    public static final String KEY_ACCOUNT_TYPE = "accountType";
    public static final String KEY_AUTHENTICATOR_TYPES = "authenticator_types";
    public static final String KEY_AUTHTOKEN = "authtoken";
    public static final String KEY_AUTH_FAILED_MESSAGE = "authFailedMessage";
    public static final String KEY_AUTH_TOKEN_LABEL = "authTokenLabelKey";
    public static final String KEY_BOOLEAN_RESULT = "booleanResult";
    public static final String KEY_ERROR_CODE = "errorCode";
    public static final String KEY_ERROR_MESSAGE = "errorMessage";
    public static final String KEY_INTENT = "intent";
    public static final String KEY_PASSWORD = "password";
    public static final String KEY_USERDATA = "userdata";
    public static final String LOGIN_ACCOUNTS_CHANGED_ACTION = "android.accounts.LOGIN_ACCOUNTS_CHANGED";
    private static final String TAG = "AccountManager";
    private final BroadcastReceiver mAccountsChangedBroadcastReceiver;
    private final HashMap<OnAccountsUpdateListener, Handler> mAccountsUpdatedListeners;
    private final Context mContext;
    private final Handler mMainHandler;
    private final IAccountManager mService;

    public AccountManager(Context context, IAccountManager iAccountManager) {
        Handler handler;
        BroadcastReceiver broadcastReceiver;
        HashMap hashMap = Maps.newHashMap();
        this.mAccountsUpdatedListeners = hashMap;
        this.mAccountsChangedBroadcastReceiver = broadcastReceiver = new BroadcastReceiver(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                Account[] accountArray = AccountManager.this.getAccounts();
                HashMap hashMap = AccountManager.this.mAccountsUpdatedListeners;
                synchronized (hashMap) {
                    Iterator iterator = AccountManager.this.mAccountsUpdatedListeners.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        AccountManager accountManager = AccountManager.this;
                        Handler handler = (Handler)entry.getValue();
                        OnAccountsUpdateListener onAccountsUpdateListener = (OnAccountsUpdateListener)entry.getKey();
                        accountManager.postToHandler(handler, onAccountsUpdateListener, accountArray);
                    }
                    return;
                }
            }
        };
        this.mContext = context;
        this.mService = iAccountManager;
        Looper looper = this.mContext.getMainLooper();
        this.mMainHandler = handler = new Handler(looper);
    }

    public AccountManager(Context context, IAccountManager iAccountManager, Handler handler) {
        BroadcastReceiver broadcastReceiver;
        HashMap hashMap = Maps.newHashMap();
        this.mAccountsUpdatedListeners = hashMap;
        this.mAccountsChangedBroadcastReceiver = broadcastReceiver = new /* invalid duplicate definition of identical inner class */;
        this.mContext = context;
        this.mService = iAccountManager;
        this.mMainHandler = handler;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Exception convertErrorToException(int n, String string2) {
        void var3_4;
        if (n == 3) {
            IOException iOException = new IOException(string2);
            return var3_4;
        }
        if (n == 6) {
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException(string2);
            return var3_4;
        }
        if (n == 5) {
            AuthenticatorException authenticatorException = new AuthenticatorException(string2);
            return var3_4;
        }
        if (n == 7) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string2);
            return var3_4;
        }
        AuthenticatorException authenticatorException = new AuthenticatorException(string2);
        return var3_4;
    }

    private void ensureNotOnMainThread() {
        Looper looper = Looper.myLooper();
        if (looper == null) {
            return;
        }
        Looper looper2 = this.mContext.getMainLooper();
        if (looper != looper2) {
            return;
        }
        IllegalStateException illegalStateException = new IllegalStateException("calling this from your main thread can lead to deadlock");
        int n = Log.e(TAG, "calling this from your main thread can lead to deadlock and/or ANRs", illegalStateException);
        if (this.mContext.getApplicationInfo().targetSdkVersion < 8) {
            return;
        }
        throw illegalStateException;
    }

    public static AccountManager get(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context is null");
        }
        return (AccountManager)context.getSystemService("account");
    }

    private void postToHandler(Handler handler, final AccountManagerCallback<Bundle> accountManagerCallback, final AccountManagerFuture<Bundle> accountManagerFuture) {
        if (handler == null) {
            handler = this.mMainHandler;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AccountManagerCallback accountManagerCallback2 = accountManagerCallback;
                AccountManagerFuture accountManagerFuture2 = accountManagerFuture;
                accountManagerCallback2.run(accountManagerFuture2);
            }
        };
        boolean bl = handler.post(runnable);
    }

    private void postToHandler(Handler handler, final OnAccountsUpdateListener onAccountsUpdateListener, Account[] accountArray) {
        final Account[] accountArray2 = new Account[accountArray.length];
        int n = accountArray2.length;
        System.arraycopy(accountArray, 0, accountArray2, 0, n);
        if (handler == null) {
            handler = this.mMainHandler;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    OnAccountsUpdateListener onAccountsUpdateListener2 = onAccountsUpdateListener;
                    Account[] accountArray = accountArray2;
                    onAccountsUpdateListener2.onAccountsUpdated(accountArray);
                    return;
                }
                catch (SQLException sQLException) {
                    int n = Log.e(AccountManager.TAG, "Can't update accounts", sQLException);
                    return;
                }
            }
        };
        boolean bl = handler.post(runnable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Bundle sanitizeResult(Bundle bundle) {
        if (bundle == null) return bundle;
        if (!bundle.containsKey(KEY_AUTHTOKEN)) return bundle;
        if (TextUtils.isEmpty(bundle.getString(KEY_AUTHTOKEN))) return bundle;
        Bundle bundle2 = new Bundle(bundle);
        bundle2.putString(KEY_AUTHTOKEN, "<omitted for logging purposes>");
        return bundle2;
    }

    public AccountManagerFuture<Bundle> addAccount(String string2, String string3, String[] stringArray, Bundle bundle, Activity activity, AccountManagerCallback<Bundle> accountManagerCallback, Handler handler) {
        if (string2 == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        AccountManager accountManager = this;
        Activity activity2 = activity;
        Handler handler2 = handler;
        AccountManagerCallback<Bundle> accountManagerCallback2 = accountManagerCallback;
        final String string4 = string2;
        final String string5 = string3;
        final String[] stringArray2 = stringArray;
        final Activity activity3 = activity;
        final Bundle bundle2 = bundle;
        return new AmsTask(activity2, handler2, accountManagerCallback2){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void doWork() throws RemoteException {
                IAccountManager iAccountManager = AccountManager.this.mService;
                IAccountManagerResponse iAccountManagerResponse = this.mResponse;
                String string2 = string4;
                String string3 = string5;
                String[] stringArray = stringArray2;
                boolean bl = activity3 != null;
                Bundle bundle = bundle2;
                iAccountManager.addAcount(iAccountManagerResponse, string2, string3, stringArray, bl, bundle);
            }
        }.start();
    }

    public boolean addAccountExplicitly(Account account, String string2, Bundle bundle) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        try {
            boolean bl = this.mService.addAccount(account, string2, bundle);
            return bl;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void addOnAccountsUpdatedListener(OnAccountsUpdateListener onAccountsUpdateListener, Handler handler, boolean bl) {
        if (onAccountsUpdateListener == null) {
            throw new IllegalArgumentException("the listener is null");
        }
        HashMap<OnAccountsUpdateListener, Handler> hashMap = this.mAccountsUpdatedListeners;
        // MONITORENTER : hashMap
        if (this.mAccountsUpdatedListeners.containsKey(onAccountsUpdateListener)) {
            throw new IllegalStateException("this listener is already added");
        }
        boolean bl2 = this.mAccountsUpdatedListeners.isEmpty();
        Handler handler2 = this.mAccountsUpdatedListeners.put(onAccountsUpdateListener, handler);
        if (bl2) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction(LOGIN_ACCOUNTS_CHANGED_ACTION);
            intentFilter.addAction("android.intent.action.DEVICE_STORAGE_OK");
            Context context = this.mContext;
            BroadcastReceiver broadcastReceiver = this.mAccountsChangedBroadcastReceiver;
            Intent intent = context.registerReceiver(broadcastReceiver, intentFilter);
        }
        // MONITOREXIT : hashMap
        if (!bl) {
            return;
        }
        Account[] accountArray = this.getAccounts();
        this.postToHandler(handler, onAccountsUpdateListener, accountArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String blockingGetAuthToken(Account account, String string2, boolean bl) throws OperationCanceledException, IOException, AuthenticatorException {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        AccountManager accountManager = this;
        Account account2 = account;
        String string3 = string2;
        boolean bl2 = bl;
        Handler handler = null;
        Bundle bundle = accountManager.getAuthToken(account2, string3, bl2, null, handler).getResult();
        if (bundle != null) return bundle.getString(KEY_AUTHTOKEN);
        String string4 = "blockingGetAuthToken: null was returned from getResult() for " + account + ", authTokenType " + string2;
        int n = Log.e(TAG, string4);
        return null;
    }

    public void clearPassword(Account account) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        try {
            this.mService.clearPassword(account);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public AccountManagerFuture<Bundle> confirmCredentials(Account account, Bundle bundle, Activity activity, AccountManagerCallback<Bundle> accountManagerCallback, Handler handler) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        AccountManager accountManager = this;
        Activity activity2 = activity;
        Handler handler2 = handler;
        AccountManagerCallback<Bundle> accountManagerCallback2 = accountManagerCallback;
        final Account account2 = account;
        final Bundle bundle2 = bundle;
        final Activity activity3 = activity;
        return new AmsTask(activity2, handler2, accountManagerCallback2){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void doWork() throws RemoteException {
                IAccountManager iAccountManager = AccountManager.this.mService;
                IAccountManagerResponse iAccountManagerResponse = this.mResponse;
                Account account = account2;
                Bundle bundle = bundle2;
                boolean bl = activity3 != null;
                iAccountManager.confirmCredentials(iAccountManagerResponse, account, bundle, bl);
            }
        }.start();
    }

    public AccountManagerFuture<Bundle> editProperties(String string2, Activity activity, AccountManagerCallback<Bundle> accountManagerCallback, Handler handler) {
        if (string2 == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        AccountManager accountManager = this;
        Activity activity2 = activity;
        Handler handler2 = handler;
        AccountManagerCallback<Bundle> accountManagerCallback2 = accountManagerCallback;
        final String string3 = string2;
        final Activity activity3 = activity;
        return new AmsTask(activity2, handler2, accountManagerCallback2){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void doWork() throws RemoteException {
                IAccountManager iAccountManager = AccountManager.this.mService;
                IAccountManagerResponse iAccountManagerResponse = this.mResponse;
                String string2 = string3;
                boolean bl = activity3 != null;
                iAccountManager.editProperties(iAccountManagerResponse, string2, bl);
            }
        }.start();
    }

    public Account[] getAccounts() {
        try {
            Account[] accountArray = this.mService.getAccounts(null);
            return accountArray;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public Account[] getAccountsByType(String string2) {
        try {
            Account[] accountArray = this.mService.getAccounts(string2);
            return accountArray;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public AccountManagerFuture<Account[]> getAccountsByTypeAndFeatures(String string2, String[] stringArray, AccountManagerCallback<Account[]> accountManagerCallback, Handler handler) {
        if (string2 == null) {
            throw new IllegalArgumentException("type is null");
        }
        AccountManager accountManager = this;
        Handler handler2 = handler;
        AccountManagerCallback<Account[]> accountManagerCallback2 = accountManagerCallback;
        final String string3 = string2;
        final String[] stringArray2 = stringArray;
        return new Future2Task<Account[]>(handler2, accountManagerCallback2){

            @Override
            public Account[] bundleToResult(Bundle bundle) throws AuthenticatorException {
                int n;
                if (!bundle.containsKey(AccountManager.KEY_ACCOUNTS)) {
                    throw new AuthenticatorException("no result in response");
                }
                Parcelable[] parcelableArray = bundle.getParcelableArray(AccountManager.KEY_ACCOUNTS);
                Account[] accountArray = new Account[parcelableArray.length];
                for (int i = 0; i < (n = parcelableArray.length); ++i) {
                    Account account;
                    accountArray[i] = account = (Account)parcelableArray[i];
                }
                return accountArray;
            }

            @Override
            public void doWork() throws RemoteException {
                IAccountManager iAccountManager = AccountManager.this.mService;
                IAccountManagerResponse iAccountManagerResponse = this.mResponse;
                String string2 = string3;
                String[] stringArray = stringArray2;
                iAccountManager.getAccountsByFeatures(iAccountManagerResponse, string2, stringArray);
            }
        }.start();
    }

    public AccountManagerFuture<Bundle> getAuthToken(Account account, String string2, Bundle bundle, Activity activity, AccountManagerCallback<Bundle> accountManagerCallback, Handler handler) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        AccountManager accountManager = this;
        Activity activity2 = activity;
        Handler handler2 = handler;
        AccountManagerCallback<Bundle> accountManagerCallback2 = accountManagerCallback;
        final Account account2 = account;
        final String string3 = string2;
        final Bundle bundle2 = bundle;
        return new AmsTask(activity2, handler2, accountManagerCallback2){

            @Override
            public void doWork() throws RemoteException {
                IAccountManager iAccountManager = AccountManager.this.mService;
                IAccountManagerResponse iAccountManagerResponse = this.mResponse;
                Account account = account2;
                String string2 = string3;
                Bundle bundle = bundle2;
                iAccountManager.getAuthToken(iAccountManagerResponse, account, string2, false, true, bundle);
            }
        }.start();
    }

    public AccountManagerFuture<Bundle> getAuthToken(Account account, String string2, boolean bl, AccountManagerCallback<Bundle> accountManagerCallback, Handler handler) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        AccountManager accountManager = this;
        Handler handler2 = handler;
        AccountManagerCallback<Bundle> accountManagerCallback2 = accountManagerCallback;
        final Account account2 = account;
        final String string3 = string2;
        final boolean bl2 = bl;
        return new AmsTask(null, handler2, accountManagerCallback2){

            @Override
            public void doWork() throws RemoteException {
                IAccountManager iAccountManager = AccountManager.this.mService;
                IAccountManagerResponse iAccountManagerResponse = this.mResponse;
                Account account = account2;
                String string2 = string3;
                boolean bl = bl2;
                iAccountManager.getAuthToken(iAccountManagerResponse, account, string2, bl, false, null);
            }
        }.start();
    }

    public AccountManagerFuture<Bundle> getAuthTokenByFeatures(String string2, String string3, String[] stringArray, Activity activity, Bundle bundle, Bundle bundle2, AccountManagerCallback<Bundle> accountManagerCallback, Handler handler) {
        if (string2 == null) {
            throw new IllegalArgumentException("account type is null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        AccountManager accountManager = this;
        String string4 = string2;
        String string5 = string3;
        String[] stringArray2 = stringArray;
        Activity activity2 = activity;
        Bundle bundle3 = bundle;
        Bundle bundle4 = bundle2;
        AccountManagerCallback<Bundle> accountManagerCallback2 = accountManagerCallback;
        Handler handler2 = handler;
        GetAuthTokenByTypeAndFeaturesTask getAuthTokenByTypeAndFeaturesTask = accountManager.new GetAuthTokenByTypeAndFeaturesTask(string4, string5, stringArray2, activity2, bundle3, bundle4, accountManagerCallback2, handler2);
        AccountManagerFuture<Bundle> accountManagerFuture = getAuthTokenByTypeAndFeaturesTask.start();
        return getAuthTokenByTypeAndFeaturesTask;
    }

    public AuthenticatorDescription[] getAuthenticatorTypes() {
        try {
            AuthenticatorDescription[] authenticatorDescriptionArray = this.mService.getAuthenticatorTypes();
            return authenticatorDescriptionArray;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public String getPassword(Account account) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        try {
            String string2 = this.mService.getPassword(account);
            return string2;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public String getUserData(Account account, String string2) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("key is null");
        }
        try {
            String string3 = this.mService.getUserData(account, string2);
            return string3;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public AccountManagerFuture<Boolean> hasFeatures(Account account, String[] stringArray, AccountManagerCallback<Boolean> accountManagerCallback, Handler handler) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("features is null");
        }
        AccountManager accountManager = this;
        Handler handler2 = handler;
        AccountManagerCallback<Boolean> accountManagerCallback2 = accountManagerCallback;
        final Account account2 = account;
        final String[] stringArray2 = stringArray;
        return new Future2Task<Boolean>(handler2, accountManagerCallback2){

            @Override
            public Boolean bundleToResult(Bundle bundle) throws AuthenticatorException {
                if (!bundle.containsKey(AccountManager.KEY_BOOLEAN_RESULT)) {
                    throw new AuthenticatorException("no result in response");
                }
                return bundle.getBoolean(AccountManager.KEY_BOOLEAN_RESULT);
            }

            @Override
            public void doWork() throws RemoteException {
                IAccountManager iAccountManager = AccountManager.this.mService;
                IAccountManagerResponse iAccountManagerResponse = this.mResponse;
                Account account = account2;
                String[] stringArray = stringArray2;
                iAccountManager.hasFeatures(iAccountManagerResponse, account, stringArray);
            }
        }.start();
    }

    public void invalidateAuthToken(String string2, String string3) {
        if (string2 == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        if (string3 == null) {
            return;
        }
        try {
            this.mService.invalidateAuthToken(string2, string3);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public String peekAuthToken(Account account, String string2) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        try {
            String string3 = this.mService.peekAuthToken(account, string2);
            return string3;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public AccountManagerFuture<Boolean> removeAccount(final Account account, AccountManagerCallback<Boolean> accountManagerCallback, Handler handler) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        return new Future2Task<Boolean>(handler, accountManagerCallback){

            @Override
            public Boolean bundleToResult(Bundle bundle) throws AuthenticatorException {
                if (!bundle.containsKey(AccountManager.KEY_BOOLEAN_RESULT)) {
                    throw new AuthenticatorException("no result in response");
                }
                return bundle.getBoolean(AccountManager.KEY_BOOLEAN_RESULT);
            }

            @Override
            public void doWork() throws RemoteException {
                IAccountManager iAccountManager = AccountManager.this.mService;
                IAccountManagerResponse iAccountManagerResponse = this.mResponse;
                Account account2 = account;
                iAccountManager.removeAccount(iAccountManagerResponse, account2);
            }
        }.start();
    }

    public void removeOnAccountsUpdatedListener(OnAccountsUpdateListener onAccountsUpdateListener) {
        if (onAccountsUpdateListener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        HashMap<OnAccountsUpdateListener, Handler> hashMap = this.mAccountsUpdatedListeners;
        synchronized (hashMap) {
            if (!this.mAccountsUpdatedListeners.containsKey(onAccountsUpdateListener)) {
                int n = Log.e(TAG, "Listener was not previously added");
                return;
            }
            Handler handler = this.mAccountsUpdatedListeners.remove(onAccountsUpdateListener);
            if (this.mAccountsUpdatedListeners.isEmpty()) {
                Context context = this.mContext;
                BroadcastReceiver broadcastReceiver = this.mAccountsChangedBroadcastReceiver;
                context.unregisterReceiver(broadcastReceiver);
            }
            return;
        }
    }

    public void setAuthToken(Account account, String string2, String string3) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        try {
            this.mService.setAuthToken(account, string2, string3);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void setPassword(Account account, String string2) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        try {
            this.mService.setPassword(account, string2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void setUserData(Account account, String string2, String string3) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("key is null");
        }
        try {
            this.mService.setUserData(account, string2, string3);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public AccountManagerFuture<Bundle> updateCredentials(Account account, String string2, Bundle bundle, Activity activity, AccountManagerCallback<Bundle> accountManagerCallback, Handler handler) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        AccountManager accountManager = this;
        Activity activity2 = activity;
        Handler handler2 = handler;
        AccountManagerCallback<Bundle> accountManagerCallback2 = accountManagerCallback;
        final Account account2 = account;
        final String string3 = string2;
        final Activity activity3 = activity;
        final Bundle bundle2 = bundle;
        return new AmsTask(activity2, handler2, accountManagerCallback2){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void doWork() throws RemoteException {
                IAccountManager iAccountManager = AccountManager.this.mService;
                IAccountManagerResponse iAccountManagerResponse = this.mResponse;
                Account account = account2;
                String string2 = string3;
                boolean bl = activity3 != null;
                Bundle bundle = bundle2;
                iAccountManager.updateCredentials(iAccountManagerResponse, account, string2, bl, bundle);
            }
        }.start();
    }

    private class GetAuthTokenByTypeAndFeaturesTask
    extends AmsTask
    implements AccountManagerCallback<Bundle> {
        final String mAccountType;
        final Bundle mAddAccountOptions;
        final String mAuthTokenType;
        final String[] mFeatures;
        volatile AccountManagerFuture<Bundle> mFuture;
        final Bundle mLoginOptions;
        final AccountManagerCallback<Bundle> mMyCallback;
        private volatile int mNumAccounts;

        GetAuthTokenByTypeAndFeaturesTask(String string2, String string3, String[] stringArray, Activity activity, Bundle bundle, Bundle bundle2, AccountManagerCallback<Bundle> accountManagerCallback, Handler handler) {
            super(activity, handler, accountManagerCallback);
            this.mFuture = null;
            this.mNumAccounts = 0;
            if (string2 == null) {
                throw new IllegalArgumentException("account type is null");
            }
            this.mAccountType = string2;
            this.mAuthTokenType = string3;
            this.mFeatures = stringArray;
            this.mAddAccountOptions = bundle;
            this.mLoginOptions = bundle2;
            this.mMyCallback = this;
        }

        static /* synthetic */ int access$1202(GetAuthTokenByTypeAndFeaturesTask getAuthTokenByTypeAndFeaturesTask, int n) {
            getAuthTokenByTypeAndFeaturesTask.mNumAccounts = n;
            return n;
        }

        @Override
        public void doWork() throws RemoteException {
            AccountManager accountManager = AccountManager.this;
            String string2 = this.mAccountType;
            String[] stringArray = this.mFeatures;
            AccountManagerCallback<Account[]> accountManagerCallback = new AccountManagerCallback<Account[]>(){

                @Override
                public void run(AccountManagerFuture<Account[]> accountManagerFuture) {
                    Parcelable[] parcelableArray;
                    block12: {
                        GetAuthTokenByTypeAndFeaturesTask getAuthTokenByTypeAndFeaturesTask;
                        try {
                            parcelableArray = accountManagerFuture.getResult();
                            getAuthTokenByTypeAndFeaturesTask = GetAuthTokenByTypeAndFeaturesTask.this;
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            GetAuthTokenByTypeAndFeaturesTask.this.setException(operationCanceledException);
                            return;
                        }
                        catch (IOException iOException) {
                            GetAuthTokenByTypeAndFeaturesTask.this.setException(iOException);
                            return;
                        }
                        catch (AuthenticatorException authenticatorException) {
                            GetAuthTokenByTypeAndFeaturesTask.this.setException(authenticatorException);
                            return;
                        }
                        int n = parcelableArray.length;
                        int n2 = GetAuthTokenByTypeAndFeaturesTask.access$1202(getAuthTokenByTypeAndFeaturesTask, n);
                        if (parcelableArray.length != 0) break block12;
                        if (GetAuthTokenByTypeAndFeaturesTask.this.mActivity != null) {
                            GetAuthTokenByTypeAndFeaturesTask getAuthTokenByTypeAndFeaturesTask2 = GetAuthTokenByTypeAndFeaturesTask.this;
                            AccountManager accountManager = AccountManager.this;
                            String string2 = GetAuthTokenByTypeAndFeaturesTask.this.mAccountType;
                            String string3 = GetAuthTokenByTypeAndFeaturesTask.this.mAuthTokenType;
                            String[] stringArray = GetAuthTokenByTypeAndFeaturesTask.this.mFeatures;
                            Bundle bundle = GetAuthTokenByTypeAndFeaturesTask.this.mAddAccountOptions;
                            Activity activity = GetAuthTokenByTypeAndFeaturesTask.this.mActivity;
                            AccountManagerCallback<Bundle> accountManagerCallback = GetAuthTokenByTypeAndFeaturesTask.this.mMyCallback;
                            Handler handler = GetAuthTokenByTypeAndFeaturesTask.this.mHandler;
                            AccountManagerFuture<Bundle> accountManagerFuture2 = accountManager.addAccount(string2, string3, stringArray, bundle, activity, accountManagerCallback, handler);
                            getAuthTokenByTypeAndFeaturesTask2.mFuture = accountManagerFuture2;
                            return;
                        }
                        Bundle bundle = new Bundle();
                        bundle.putString(AccountManager.KEY_ACCOUNT_NAME, null);
                        bundle.putString(AccountManager.KEY_ACCOUNT_TYPE, null);
                        bundle.putString(AccountManager.KEY_AUTHTOKEN, null);
                        try {
                            GetAuthTokenByTypeAndFeaturesTask.this.mResponse.onResult(bundle);
                            return;
                        }
                        catch (RemoteException remoteException) {
                            return;
                        }
                    }
                    if (parcelableArray.length == 1) {
                        if (GetAuthTokenByTypeAndFeaturesTask.this.mActivity == null) {
                            GetAuthTokenByTypeAndFeaturesTask getAuthTokenByTypeAndFeaturesTask = GetAuthTokenByTypeAndFeaturesTask.this;
                            AccountManager accountManager = AccountManager.this;
                            Account account = parcelableArray[0];
                            String string4 = GetAuthTokenByTypeAndFeaturesTask.this.mAuthTokenType;
                            AccountManagerCallback<Bundle> accountManagerCallback = GetAuthTokenByTypeAndFeaturesTask.this.mMyCallback;
                            Handler handler = GetAuthTokenByTypeAndFeaturesTask.this.mHandler;
                            AccountManagerFuture<Bundle> accountManagerFuture3 = accountManager.getAuthToken(account, string4, false, accountManagerCallback, handler);
                            getAuthTokenByTypeAndFeaturesTask.mFuture = accountManagerFuture3;
                            return;
                        }
                        GetAuthTokenByTypeAndFeaturesTask getAuthTokenByTypeAndFeaturesTask = GetAuthTokenByTypeAndFeaturesTask.this;
                        AccountManager accountManager = AccountManager.this;
                        Account account = parcelableArray[0];
                        String string5 = GetAuthTokenByTypeAndFeaturesTask.this.mAuthTokenType;
                        Bundle bundle = GetAuthTokenByTypeAndFeaturesTask.this.mLoginOptions;
                        Activity activity = GetAuthTokenByTypeAndFeaturesTask.this.mActivity;
                        AccountManagerCallback<Bundle> accountManagerCallback = GetAuthTokenByTypeAndFeaturesTask.this.mMyCallback;
                        Handler handler = GetAuthTokenByTypeAndFeaturesTask.this.mHandler;
                        AccountManagerFuture<Bundle> accountManagerFuture4 = accountManager.getAuthToken(account, string5, bundle, activity, accountManagerCallback, handler);
                        getAuthTokenByTypeAndFeaturesTask.mFuture = accountManagerFuture4;
                        return;
                    }
                    if (GetAuthTokenByTypeAndFeaturesTask.this.mActivity != null) {
                        IAccountManagerResponse.Stub stub = new IAccountManagerResponse.Stub(){

                            @Override
                            public void onError(int n, String string2) throws RemoteException {
                                GetAuthTokenByTypeAndFeaturesTask.this.mResponse.onError(n, string2);
                            }

                            @Override
                            public void onResult(Bundle bundle) throws RemoteException {
                                String string2 = bundle.getString(AccountManager.KEY_ACCOUNT_NAME);
                                String string3 = bundle.getString(AccountManager.KEY_ACCOUNT_TYPE);
                                Account account = new Account(string2, string3);
                                GetAuthTokenByTypeAndFeaturesTask getAuthTokenByTypeAndFeaturesTask = GetAuthTokenByTypeAndFeaturesTask.this;
                                AccountManager accountManager = AccountManager.this;
                                String string4 = GetAuthTokenByTypeAndFeaturesTask.this.mAuthTokenType;
                                Bundle bundle2 = GetAuthTokenByTypeAndFeaturesTask.this.mLoginOptions;
                                Activity activity = GetAuthTokenByTypeAndFeaturesTask.this.mActivity;
                                AccountManagerCallback<Bundle> accountManagerCallback = GetAuthTokenByTypeAndFeaturesTask.this.mMyCallback;
                                Handler handler = GetAuthTokenByTypeAndFeaturesTask.this.mHandler;
                                AccountManagerFuture<Bundle> accountManagerFuture = accountManager.getAuthToken(account, string4, bundle2, activity, accountManagerCallback, handler);
                                getAuthTokenByTypeAndFeaturesTask.mFuture = accountManagerFuture;
                            }
                        };
                        Intent intent = new Intent();
                        Intent intent2 = intent.setClassName("android", "android.accounts.ChooseAccountActivity");
                        Intent intent3 = intent.putExtra(AccountManager.KEY_ACCOUNTS, parcelableArray);
                        AccountManagerResponse accountManagerResponse = new AccountManagerResponse(stub);
                        Intent intent4 = intent.putExtra(AccountManager.KEY_ACCOUNT_MANAGER_RESPONSE, accountManagerResponse);
                        GetAuthTokenByTypeAndFeaturesTask.this.mActivity.startActivity(intent);
                        return;
                    }
                    Bundle bundle = new Bundle();
                    bundle.putString(AccountManager.KEY_ACCOUNTS, null);
                    try {
                        GetAuthTokenByTypeAndFeaturesTask.this.mResponse.onResult(bundle);
                        return;
                    }
                    catch (RemoteException remoteException) {
                        return;
                    }
                }
            };
            Handler handler = this.mHandler;
            AccountManagerFuture<Account[]> accountManagerFuture = accountManager.getAccountsByTypeAndFeatures(string2, stringArray, accountManagerCallback, handler);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run(AccountManagerFuture<Bundle> accountManagerFuture) {
            Bundle bundle;
            try {
                bundle = accountManagerFuture.getResult();
                if (this.mNumAccounts == 0) {
                    String string2 = bundle.getString(AccountManager.KEY_ACCOUNT_NAME);
                    String string3 = bundle.getString(AccountManager.KEY_ACCOUNT_TYPE);
                    if (!TextUtils.isEmpty(string2) && !TextUtils.isEmpty(string3)) {
                        Account account = new Account(string2, string3);
                        this.mNumAccounts = 1;
                        AccountManager accountManager = AccountManager.this;
                        String string4 = this.mAuthTokenType;
                        Activity activity = this.mActivity;
                        AccountManagerCallback<Bundle> accountManagerCallback = this.mMyCallback;
                        Handler handler = this.mHandler;
                        AccountManagerFuture<Bundle> accountManagerFuture2 = accountManager.getAuthToken(account, string4, null, activity, accountManagerCallback, handler);
                        return;
                    }
                    AuthenticatorException authenticatorException = new AuthenticatorException("account not in result");
                    this.setException(authenticatorException);
                    return;
                }
            }
            catch (OperationCanceledException operationCanceledException) {
                boolean bl = this.cancel(true);
                return;
            }
            catch (IOException iOException) {
                this.setException(iOException);
                return;
            }
            catch (AuthenticatorException authenticatorException) {
                this.setException(authenticatorException);
                return;
            }
            {
                this.set(bundle);
                return;
            }
        }
    }

    private abstract class Future2Task<T>
    extends BaseFutureTask<T>
    implements AccountManagerFuture<T> {
        final AccountManagerCallback<T> mCallback;

        public Future2Task(Handler handler, AccountManagerCallback<T> accountManagerCallback) {
            super(handler);
            this.mCallback = accountManagerCallback;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private T internalGetResult(Long l, TimeUnit timeUnit) throws OperationCanceledException, IOException, AuthenticatorException {
            Throwable throwable;
            block22: {
                Object object;
                Object object2;
                if (!this.isDone()) {
                    AccountManager.this.ensureNotOnMainThread();
                }
                if (l == null) {
                    try {
                        Object v;
                        object2 = v = this.get();
                        return (T)object2;
                    }
                    catch (InterruptedException interruptedException) {
                        throw new OperationCanceledException();
                    }
                }
                try {
                    Object object3;
                    try {
                        object3 = object = l.longValue();
                    }
                    catch (CancellationException cancellationException) {
                        throw new OperationCanceledException();
                    }
                    catch (TimeoutException timeoutException) {
                        throw new OperationCanceledException();
                    }
                    object = this.get((long)object3, timeUnit);
                }
                catch (ExecutionException executionException) {
                    throwable = executionException.getCause();
                    if (throwable instanceof IOException) {
                        throw (IOException)throwable;
                    }
                    break block22;
                }
                object2 = object;
                return (T)object2;
                catch (Throwable throwable2) {
                    throw throwable2;
                }
            }
            if (throwable instanceof UnsupportedOperationException) {
                throw new AuthenticatorException(throwable);
            }
            if (throwable instanceof AuthenticatorException) {
                throw (AuthenticatorException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (!(throwable instanceof Error)) throw new IllegalStateException(throwable);
            throw (Error)throwable;
            catch (CancellationException cancellationException) {
                throw new OperationCanceledException();
            }
            catch (CancellationException cancellationException) {
                throw new OperationCanceledException();
            }
            catch (TimeoutException timeoutException) {
                throw new OperationCanceledException();
            }
        }

        @Override
        protected void done() {
            if (this.mCallback == null) {
                return;
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AccountManagerCallback accountManagerCallback = Future2Task.this.mCallback;
                    Future2Task future2Task = Future2Task.this;
                    accountManagerCallback.run(future2Task);
                }
            };
            this.postRunnableToHandler(runnable);
        }

        @Override
        public T getResult() throws OperationCanceledException, IOException, AuthenticatorException {
            return this.internalGetResult(null, null);
        }

        @Override
        public T getResult(long l, TimeUnit timeUnit) throws OperationCanceledException, IOException, AuthenticatorException {
            Long l2 = l;
            return this.internalGetResult(l2, timeUnit);
        }

        public Future2Task<T> start() {
            this.startTask();
            return this;
        }
    }

    private abstract class BaseFutureTask<T>
    extends FutureTask<T> {
        final Handler mHandler;
        public final IAccountManagerResponse mResponse;

        public BaseFutureTask(Handler handler) {
            Callable callable = new Callable<T>(){

                @Override
                public T call() throws Exception {
                    throw new IllegalStateException("this should never be called");
                }
            };
            super(callable);
            this.mHandler = handler;
            Response response = new Response();
            this.mResponse = response;
        }

        static /* synthetic */ void access$700(BaseFutureTask baseFutureTask, Object object) {
            baseFutureTask.set(object);
        }

        public abstract T bundleToResult(Bundle var1) throws AuthenticatorException;

        public abstract void doWork() throws RemoteException;

        /*
         * Enabled aggressive block sorting
         */
        protected void postRunnableToHandler(Runnable runnable) {
            Handler handler = this.mHandler == null ? AccountManager.this.mMainHandler : this.mHandler;
            boolean bl = handler.post(runnable);
        }

        protected void startTask() {
            try {
                this.doWork();
                return;
            }
            catch (RemoteException remoteException) {
                this.setException(remoteException);
                return;
            }
        }

        protected class Response
        extends IAccountManagerResponse.Stub {
            protected Response() {
            }

            @Override
            public void onError(int n, String string2) {
                if (n == 4) {
                    boolean bl = BaseFutureTask.this.cancel(true);
                    return;
                }
                BaseFutureTask baseFutureTask = BaseFutureTask.this;
                Exception exception = AccountManager.this.convertErrorToException(n, string2);
                baseFutureTask.setException(exception);
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public void onResult(Bundle var1_1) {
                try {
                    var2_2 = BaseFutureTask.this.bundleToResult(var1_1);
                    if (var2_2 == null) {
                        return;
                    }
                    BaseFutureTask.access$700(BaseFutureTask.this, var2_2);
                    return;
                }
                catch (ClassCastException var3_3) lbl-1000:
                // 2 sources

                {
                    while (true) {
                        this.onError(5, "no result in response");
                        return;
                    }
                }
                catch (AuthenticatorException var4_4) {
                    ** continue;
                }
            }
        }
    }

    private abstract class AmsTask
    extends FutureTask<Bundle>
    implements AccountManagerFuture<Bundle> {
        final Activity mActivity;
        final AccountManagerCallback<Bundle> mCallback;
        final Handler mHandler;
        final IAccountManagerResponse mResponse;

        public AmsTask(Activity activity, Handler handler, AccountManagerCallback<Bundle> accountManagerCallback) {
            Callable<Bundle> callable = new Callable<Bundle>(){

                @Override
                public Bundle call() throws Exception {
                    throw new IllegalStateException("this should never be called");
                }
            };
            super(callable);
            this.mHandler = handler;
            this.mCallback = accountManagerCallback;
            this.mActivity = activity;
            Response response = new Response();
            this.mResponse = response;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Bundle internalGetResult(Long var1_1, TimeUnit var2_2) throws OperationCanceledException, IOException, AuthenticatorException {
            if (!this.isDone()) {
                AccountManager.access$200(AccountManager.this);
            }
            if (var1_1 != null) ** GOTO lbl16
            try {
                try {
                    var4_5 /* !! */  = var3_3 = this.get();
                }
                finally {
                    var8_9 = this.cancel(true);
                }
                var4_5 /* !! */  = (Bundle)var4_5 /* !! */ ;
                return var4_5 /* !! */ ;
lbl16:
                // 3 sources

                var3_4 /* !! */  = var1_1;
                var4_5 /* !! */  = var3_4 /* !! */ ;
                var3_4 /* !! */  = (long)this.get((long)var4_5 /* !! */ , var2_2);
                var4_5 /* !! */  = var3_4 /* !! */ ;
                var4_5 /* !! */  = (Bundle)var4_5 /* !! */ ;
                return var4_5 /* !! */ ;
            }
            catch (CancellationException var6_7) {
                throw new OperationCanceledException();
            }
            catch (ExecutionException var9_10) {
                var10_11 = var9_10.getCause();
                if (var10_11 instanceof IOException) {
                    throw (IOException)var10_11;
                }
                if (var10_11 instanceof UnsupportedOperationException) {
                    throw new AuthenticatorException(var10_11);
                }
                if (var10_11 instanceof AuthenticatorException) {
                    throw (AuthenticatorException)var10_11;
                }
                if (var10_11 instanceof RuntimeException) {
                    throw (RuntimeException)var10_11;
                }
                if (var10_11 instanceof Error == false) throw new IllegalStateException(var10_11);
                throw (Error)var10_11;
            }
            catch (InterruptedException var11_12) lbl-1000:
            // 6 sources

            {
                while (true) {
                    var12_13 = this.cancel(true);
                    throw new OperationCanceledException();
                }
            }
            catch (TimeoutException var17_18) {
                ** GOTO lbl-1000
            }
            catch (InterruptedException var16_17) {
                ** GOTO lbl-1000
            }
            catch (InterruptedException var15_16) {
                ** GOTO lbl-1000
            }
            catch (InterruptedException var14_15) {
                ** GOTO lbl-1000
            }
            catch (InterruptedException var13_14) {
                ** continue;
            }
        }

        public abstract void doWork() throws RemoteException;

        @Override
        protected void done() {
            if (this.mCallback == null) {
                return;
            }
            AccountManager accountManager = AccountManager.this;
            Handler handler = this.mHandler;
            AccountManagerCallback<Bundle> accountManagerCallback = this.mCallback;
            accountManager.postToHandler(handler, accountManagerCallback, this);
        }

        @Override
        public Bundle getResult() throws OperationCanceledException, IOException, AuthenticatorException {
            return this.internalGetResult(null, null);
        }

        @Override
        public Bundle getResult(long l, TimeUnit timeUnit) throws OperationCanceledException, IOException, AuthenticatorException {
            Long l2 = l;
            return this.internalGetResult(l2, timeUnit);
        }

        @Override
        protected void set(Bundle bundle) {
            if (bundle == null) {
                Exception exception = new Exception();
                int n = Log.e(AccountManager.TAG, "the bundle must not be null", exception);
            }
            super.set(bundle);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final AccountManagerFuture<Bundle> start() {
            try {
                this.doWork();
                return this;
            }
            catch (RemoteException remoteException) {
                this.setException(remoteException);
                return this;
            }
        }

        private class Response
        extends IAccountManagerResponse.Stub {
            private Response() {
            }

            @Override
            public void onError(int n, String string2) {
                if (n == 4) {
                    boolean bl = AmsTask.this.cancel(true);
                    return;
                }
                AmsTask amsTask = AmsTask.this;
                Exception exception = AccountManager.this.convertErrorToException(n, string2);
                amsTask.setException(exception);
            }

            @Override
            public void onResult(Bundle bundle) {
                Intent intent = (Intent)bundle.getParcelable(AccountManager.KEY_INTENT);
                if (intent != null && AmsTask.this.mActivity != null) {
                    AmsTask.this.mActivity.startActivity(intent);
                    return;
                }
                if (bundle.getBoolean("retry")) {
                    try {
                        AmsTask.this.doWork();
                        return;
                    }
                    catch (RemoteException remoteException) {
                        return;
                    }
                }
                AmsTask.this.set(bundle);
            }
        }
    }
}

