/*
 * Decompiled with CFR 0.152.
 */
package android.accounts;

import android.accounts.Account;
import android.accounts.AccountAuthenticatorCache;
import android.accounts.AccountAuthenticatorResponse;
import android.accounts.AuthenticatorDescription;
import android.accounts.GrantCredentialsPermissionActivity;
import android.accounts.IAccountAuthenticator;
import android.accounts.IAccountAuthenticatorResponse;
import android.accounts.IAccountManager;
import android.accounts.IAccountManagerResponse;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.RegisteredServicesCache;
import android.content.pm.RegisteredServicesCacheListener;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Binder;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.android.internal.telephony.ITelephony;
import java.io.File;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class AccountManagerService
extends IAccountManager.Stub
implements RegisteredServicesCacheListener<AuthenticatorDescription> {
    private static final Intent ACCOUNTS_CHANGED_INTENT;
    private static final String ACCOUNTS_ID = "_id";
    private static final String ACCOUNTS_NAME = "name";
    private static final String ACCOUNTS_PASSWORD = "password";
    private static final String ACCOUNTS_TYPE = "type";
    private static final String ACCOUNTS_TYPE_COUNT = "count(type)";
    private static final String[] ACCOUNT_NAME_TYPE_PROJECTION;
    private static final String[] ACCOUNT_TYPE_COUNT_PROJECTION;
    private static final String AUTHTOKENS_ACCOUNTS_ID = "accounts_id";
    private static final String AUTHTOKENS_AUTHTOKEN = "authtoken";
    private static final String AUTHTOKENS_ID = "_id";
    private static final String AUTHTOKENS_TYPE = "type";
    private static final String COUNT_OF_MATCHING_GRANTS = "SELECT COUNT(*) FROM grants, accounts WHERE accounts_id=_id AND uid=? AND auth_token_type=? AND name=? AND type=?";
    private static final String DATABASE_NAME = "accounts.db";
    private static final int DATABASE_VERSION = 4;
    private static final Account[] EMPTY_ACCOUNT_ARRAY;
    private static final String EXTRAS_ACCOUNTS_ID = "accounts_id";
    private static final String EXTRAS_ID = "_id";
    private static final String EXTRAS_KEY = "key";
    private static final String EXTRAS_VALUE = "value";
    private static final String GOOGLE_ACCOUNT_TYPE = "com.google";
    private static final String GRANTS_ACCOUNTS_ID = "accounts_id";
    private static final String GRANTS_AUTH_TOKEN_TYPE = "auth_token_type";
    private static final String GRANTS_GRANTEE_UID = "uid";
    private static final int MESSAGE_TIMED_OUT = 3;
    private static final String META_KEY = "key";
    private static final String META_VALUE = "value";
    private static final String NO_BROADCAST_FLAG = "nobroadcast";
    private static final String TABLE_ACCOUNTS = "accounts";
    private static final String TABLE_AUTHTOKENS = "authtokens";
    private static final String TABLE_EXTRAS = "extras";
    private static final String TABLE_GRANTS = "grants";
    private static final String TABLE_META = "meta";
    private static final String TAG = "AccountManagerService";
    private static final int TIMEOUT_DELAY_MS = 60000;
    private static final boolean isDebuggableMonkeyBuild;
    private static AtomicReference<AccountManagerService> sThis;
    private final AccountAuthenticatorCache mAuthenticatorCache;
    private final Context mContext;
    private final HashMap<Pair<Pair<Account, String>, Integer>, Integer> mCredentialsPermissionNotificationIds;
    private final MessageHandler mMessageHandler;
    private HandlerThread mMessageThread;
    private final AtomicInteger mNotificationIds;
    private final DatabaseHelper mOpenHelper;
    private final LinkedHashMap<String, Session> mSessions;
    private final HashMap<Account, Integer> mSigninRequiredNotificationIds;
    private final SimWatcher mSimWatcher;

    static {
        String[] stringArray = new String[]{"_id", ACCOUNTS_NAME, "type"};
        ACCOUNT_NAME_TYPE_PROJECTION = stringArray;
        String[] stringArray2 = new String[]{"type", ACCOUNTS_TYPE_COUNT};
        ACCOUNT_TYPE_COUNT_PROJECTION = stringArray2;
        sThis = new AtomicReference();
        isDebuggableMonkeyBuild = SystemProperties.getBoolean("ro.monkey", false);
        EMPTY_ACCOUNT_ARRAY = new Account[0];
        ACCOUNTS_CHANGED_INTENT = new Intent("android.accounts.LOGIN_ACCOUNTS_CHANGED");
        Intent intent = ACCOUNTS_CHANGED_INTENT.setFlags(0x10000000);
    }

    public AccountManagerService(Context context) {
        SimWatcher simWatcher;
        AccountAuthenticatorCache accountAuthenticatorCache;
        MessageHandler messageHandler;
        HandlerThread handlerThread;
        DatabaseHelper databaseHelper;
        AtomicInteger atomicInteger;
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        this.mSessions = linkedHashMap;
        this.mNotificationIds = atomicInteger = new AtomicInteger(1);
        HashMap hashMap = new HashMap();
        this.mCredentialsPermissionNotificationIds = hashMap;
        HashMap hashMap2 = new HashMap();
        this.mSigninRequiredNotificationIds = hashMap2;
        Context context2 = this.mContext = context;
        this.mOpenHelper = databaseHelper = new DatabaseHelper(context2);
        this.mMessageThread = handlerThread = new HandlerThread(TAG);
        this.mMessageThread.start();
        Looper looper = this.mMessageThread.getLooper();
        this.mMessageHandler = messageHandler = new MessageHandler(looper);
        Context context3 = this.mContext;
        this.mAuthenticatorCache = accountAuthenticatorCache = new AccountAuthenticatorCache(context3);
        this.mAuthenticatorCache.setListener(this, null);
        Context context4 = this.mContext;
        this.mSimWatcher = simWatcher = new SimWatcher(context4);
        sThis.set(this);
        this.validateAccounts();
    }

    static /* synthetic */ Integer access$700(AccountManagerService accountManagerService, Account account) {
        return accountManagerService.getSigninRequiredNotificationId(account);
    }

    static /* synthetic */ void access$800(AccountManagerService accountManagerService, int n) {
        accountManagerService.cancelNotification(n);
    }

    private void cancelNotification(int n) {
        long l = AccountManagerService.clearCallingIdentity();
        try {
            ((NotificationManager)this.mContext.getSystemService("notification")).cancel(n);
            return;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    private void checkAuthenticateAccountsPermission(Account account) {
        String[] stringArray = new String[]{"android.permission.AUTHENTICATE_ACCOUNTS"};
        this.checkBinderPermission(stringArray);
        this.checkCallingUidAgainstAuthenticator(account);
    }

    private void checkBinderPermission(String ... stringArray) {
        int n = Binder.getCallingUid();
        for (String string2 : stringArray) {
            if (this.mContext.checkCallingOrSelfPermission(string2) != 0) continue;
            if (!Log.isLoggable(TAG, 2)) {
                return;
            }
            String string3 = "caller uid " + n + " has " + string2;
            int n2 = Log.v(TAG, string3);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append("caller uid ").append(n).append(" lacks any of ");
        String string4 = TextUtils.join((CharSequence)",", stringArray);
        String string5 = stringBuilder.append(string4).toString();
        int n3 = Log.w(TAG, string5);
        throw new SecurityException(string5);
    }

    private void checkCallingUidAgainstAuthenticator(Account account) {
        String string2;
        int n = Binder.getCallingUid();
        if (account == null || !this.hasAuthenticatorUid(string2 = account.type, n)) {
            String string3 = "caller uid " + n + " is different than the authenticator's uid";
            int n2 = Log.w(TAG, string3);
            throw new SecurityException(string3);
        }
        if (!Log.isLoggable(TAG, 2)) {
            return;
        }
        String string4 = "caller uid " + n + " is the same as the authenticator's uid";
        int n3 = Log.v(TAG, string4);
    }

    private void checkManageAccountsOrUseCredentialsPermissions() {
        String[] stringArray = new String[]{"android.permission.MANAGE_ACCOUNTS", "android.permission.USE_CREDENTIALS"};
        this.checkBinderPermission(stringArray);
    }

    private void checkManageAccountsPermission() {
        String[] stringArray = new String[]{"android.permission.MANAGE_ACCOUNTS"};
        this.checkBinderPermission(stringArray);
    }

    private void checkReadAccountsPermission() {
        String[] stringArray = new String[]{"android.permission.GET_ACCOUNTS"};
        this.checkBinderPermission(stringArray);
    }

    private void createNoCredentialsPermissionNotification(Account account, Intent intent) {
        int n = intent.getIntExtra(GRANTS_GRANTEE_UID, -1);
        String string2 = intent.getStringExtra("authTokenType");
        String string3 = intent.getStringExtra("authTokenLabel");
        Notification notification = new Notification(17301642, null, 0L);
        Context context = this.mContext;
        Object[] objectArray = new Object[1];
        String string4 = account.name;
        objectArray[0] = string4;
        String string5 = context.getString(17040224, objectArray);
        int n2 = string5.indexOf(10);
        String string6 = string5.substring(0, n2);
        int n3 = n2 + 1;
        String string7 = string5.substring(n3);
        Context context2 = this.mContext;
        PendingIntent pendingIntent = PendingIntent.getActivity(this.mContext, 0, intent, 0x10000000);
        notification.setLatestEventInfo(context2, string6, string7, pendingIntent);
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        int n4 = this.getCredentialPermissionNotificationId(account, string2, n);
        notificationManager.notify(n4, notification);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doNotification(Account account, CharSequence charSequence, Intent intent) {
        long l = AccountManagerService.clearCallingIdentity();
        try {
            String string2;
            String string3;
            if (Log.isLoggable(TAG, 2)) {
                String string4 = "doNotification: " + charSequence + " intent:" + intent;
                int n = Log.v(TAG, string4);
            }
            if (intent.getComponent() != null && (string3 = GrantCredentialsPermissionActivity.class.getName()).equals(string2 = intent.getComponent().getClassName())) {
                this.createNoCredentialsPermissionNotification(account, intent);
                return;
            }
            Integer n = this.getSigninRequiredNotificationId(account);
            String string5 = String.valueOf(n);
            Intent intent2 = intent.addCategory(string5);
            Notification notification = new Notification(17301642, null, 0L);
            String string6 = ((Object)this.mContext.getText(17039624)).toString();
            Context context = this.mContext;
            Object[] objectArray = new Object[1];
            String string7 = account.name;
            objectArray[0] = string7;
            String string8 = String.format(string6, objectArray);
            PendingIntent pendingIntent = PendingIntent.getActivity(this.mContext, 0, intent, 0x10000000);
            notification.setLatestEventInfo(context, string8, charSequence, pendingIntent);
            NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
            int n2 = n;
            notificationManager.notify(n2, notification);
            return;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getAccountId(SQLiteDatabase sQLiteDatabase, Account account) {
        String[] stringArray = new String[]{"_id"};
        String string2 = account.name;
        String string3 = account.type;
        String[] stringArray2 = new String[]{string2, string3};
        SQLiteDatabase sQLiteDatabase2 = sQLiteDatabase;
        String string4 = null;
        String string5 = null;
        Cursor cursor = sQLiteDatabase2.query(TABLE_ACCOUNTS, stringArray, "name=? AND type=?", stringArray2, null, string4, string5);
        try {
            long l;
            long l2 = cursor.moveToNext() ? (l = cursor.getLong(0)) : 65535L;
            return l2;
        }
        finally {
            cursor.close();
        }
    }

    private Integer getCredentialPermissionNotificationId(Account account, String string2, int n) {
        HashMap<Pair<Pair<Account, String>, Integer>, Integer> hashMap = this.mCredentialsPermissionNotificationIds;
        synchronized (hashMap) {
            Pair<Account, String> pair = new Pair<Account, String>(account, string2);
            Integer n2 = n;
            Pair<Pair<Account, String>, Integer> pair2 = new Pair<Pair<Account, String>, Integer>(pair, n2);
            Integer n3 = this.mCredentialsPermissionNotificationIds.get(pair2);
            if (n3 == null) {
                n3 = this.mNotificationIds.incrementAndGet();
                Integer n4 = this.mCredentialsPermissionNotificationIds.put(pair2, n3);
            }
            return n3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getDatabaseName() {
        if (!Environment.isEncryptedFilesystemEnabled()) return DATABASE_NAME;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = Environment.getSystemSecureDirectory().getPath();
        StringBuilder stringBuilder2 = stringBuilder.append(string2);
        String string3 = File.separator;
        return stringBuilder2.append(string3).append(DATABASE_NAME).toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getExtrasId(SQLiteDatabase sQLiteDatabase, long l, String string2) {
        String[] stringArray = new String[]{"_id"};
        String string3 = "accounts_id=" + l + " AND " + "key" + "=?";
        String[] stringArray2 = new String[]{string2};
        SQLiteDatabase sQLiteDatabase2 = sQLiteDatabase;
        String string4 = null;
        String string5 = null;
        Cursor cursor = sQLiteDatabase2.query(TABLE_EXTRAS, stringArray, string3, stringArray2, null, string4, string5);
        try {
            long l2;
            long l3 = cursor.moveToNext() ? (l2 = cursor.getLong(0)) : 65535L;
            return l3;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getMetaValue(String string2) {
        Cursor cursor;
        block2: {
            String string3;
            SQLiteDatabase sQLiteDatabase = this.mOpenHelper.getReadableDatabase();
            String[] stringArray = new String[]{"value"};
            String[] stringArray2 = new String[]{string2};
            String string4 = null;
            String string5 = null;
            cursor = sQLiteDatabase.query(TABLE_META, stringArray, "key=?", stringArray2, null, string4, string5);
            try {
                String string6;
                if (!cursor.moveToNext()) break block2;
                string3 = string6 = cursor.getString(0);
                cursor.close();
            }
            catch (Throwable throwable) {
                cursor.close();
                throw throwable;
            }
            return string3;
        }
        cursor.close();
        return null;
    }

    private Integer getSigninRequiredNotificationId(Account account) {
        HashMap<Account, Integer> hashMap = this.mSigninRequiredNotificationIds;
        synchronized (hashMap) {
            Integer n = this.mSigninRequiredNotificationIds.get(account);
            if (n == null) {
                n = this.mNotificationIds.incrementAndGet();
                Integer n2 = this.mSigninRequiredNotificationIds.put(account, n);
            }
            return n;
        }
    }

    public static AccountManagerService getSingleton() {
        return sThis.get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasAuthenticatorUid(String string2, int n) {
        int n2;
        RegisteredServicesCache.ServiceInfo serviceInfo;
        Iterator iterator = this.mAuthenticatorCache.getAllServices().iterator();
        do {
            if (!iterator.hasNext()) return false;
            serviceInfo = iterator.next();
        } while (!((AuthenticatorDescription)serviceInfo.type).type.equals(string2));
        if (serviceInfo.uid == n) return true;
        PackageManager packageManager = this.mContext.getPackageManager();
        if (packageManager.checkSignatures(n2 = serviceInfo.uid, n) != 0) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean hasExplicitlyGrantedPermission(Account account, String string2) {
        String string3;
        String string4;
        if (Binder.getCallingUid() == 1000) {
            return true;
        }
        SQLiteDatabase sQLiteDatabase = this.mOpenHelper.getReadableDatabase();
        String string5 = String.valueOf(Binder.getCallingUid());
        String[] stringArray = new String[]{string5, string2, string4 = account.name, string3 = account.type};
        if (DatabaseUtils.longForQuery(sQLiteDatabase, COUNT_OF_MATCHING_GRANTS, stringArray) != 0L) {
            return true;
        }
        boolean bl = false;
        if (bl) return bl;
        if (!isDebuggableMonkeyBuild) return bl;
        StringBuilder stringBuilder = new StringBuilder().append("no credentials permission for usage of ").append(account).append(", ").append(string2).append(" by uid ");
        int n = Binder.getCallingUid();
        String string6 = stringBuilder.append(n).append(" but ignoring since this is a monkey build").toString();
        int n2 = Log.d(TAG, string6);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean inSystemImage(int n) {
        String[] stringArray = this.mContext.getPackageManager().getPackagesForUid(n);
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string2 = stringArray[n3];
            try {
                int n4 = this.mContext.getPackageManager().getPackageInfo((String)string2, (int)0).applicationInfo.flags;
                if ((n4 & 1) != 0) {
                    return true;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return false;
            }
            ++n3;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean insertAccountIntoDatabase(Account account, String string2, Bundle bundle) {
        SQLiteDatabase sQLiteDatabase = this.mOpenHelper.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        if (account == null) {
            return false;
        }
        boolean bl = false;
        try {
            boolean bl2;
            String string3;
            String string4;
            if (account.type.equals(GOOGLE_ACCOUNT_TYPE)) {
                Bundle bundle2 = bundle;
                String string5 = NO_BROADCAST_FLAG;
                boolean bl3 = false;
                bl = bundle2.getBoolean(string5, bl3);
                Bundle bundle3 = bundle;
                String string6 = NO_BROADCAST_FLAG;
                bundle3.remove(string6);
            }
            String[] stringArray = new String[]{string4 = account.name, string3 = account.type};
            if (DatabaseUtils.longForQuery(sQLiteDatabase, "select count(*) from accounts WHERE name=? AND type=?", stringArray) > 0L) {
                bl2 = false;
                return bl2;
            }
            ContentValues contentValues = new ContentValues();
            String string7 = account.name;
            contentValues.put(ACCOUNTS_NAME, string7);
            String string8 = account.type;
            contentValues.put("type", string8);
            ContentValues contentValues2 = contentValues;
            String string9 = ACCOUNTS_PASSWORD;
            String string10 = string2;
            contentValues2.put(string9, string10);
            long l = sQLiteDatabase.insert(TABLE_ACCOUNTS, ACCOUNTS_NAME, contentValues);
            if (l < 0L) {
                bl2 = false;
                return bl2;
            }
            if (bundle != null) {
                for (String string11 : bundle.keySet()) {
                    String string12;
                    Bundle bundle4;
                    String string13;
                    if (this.insertExtra(sQLiteDatabase, l, string11, string13 = (bundle4 = bundle).getString(string12 = string11)) >= 0L) continue;
                    bl2 = false;
                    return bl2;
                }
            } else {
                sQLiteDatabase.setTransactionSuccessful();
                if (!bl) {
                    this.sendAccountsChangedBroadcast();
                }
                bl2 = true;
            }
            return bl2;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    private long insertExtra(SQLiteDatabase sQLiteDatabase, long l, String string2, String string3) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("key", string2);
        Long l2 = l;
        contentValues.put("accounts_id", l2);
        contentValues.put("value", string3);
        return sQLiteDatabase.insert(TABLE_EXTRAS, "key", contentValues);
    }

    private void invalidateAuthToken(SQLiteDatabase sQLiteDatabase, String string2, String string3) {
        if (string3 == null) {
            return;
        }
        if (string2 == null) {
            return;
        }
        String[] stringArray = new String[]{string3, string2};
        Cursor cursor = sQLiteDatabase.rawQuery("SELECT authtokens._id, accounts.name, authtokens.type FROM accounts JOIN authtokens ON accounts._id = accounts_id WHERE authtoken = ? AND accounts.type = ?", stringArray);
        try {
            while (cursor.moveToNext()) {
                long l = cursor.getLong(0);
                String string4 = cursor.getString(1);
                String string5 = cursor.getString(2);
                String string6 = "_id=" + l;
                int n = sQLiteDatabase.delete(TABLE_AUTHTOKENS, string6, null);
            }
        }
        finally {
            cursor.close();
        }
    }

    private Intent newGrantCredentialsPermissionIntent(Account account, int n, AccountAuthenticatorResponse accountAuthenticatorResponse, String string2, String string3) {
        Context context = this.mContext;
        Intent intent = new Intent(context, GrantCredentialsPermissionActivity.class);
        String string4 = String.valueOf(this.getCredentialPermissionNotificationId(account, string2, n));
        Intent intent2 = intent.addCategory(string4);
        Intent intent3 = intent.putExtra("account", account);
        Intent intent4 = intent.putExtra("authTokenType", string2);
        Intent intent5 = intent.putExtra("response", accountAuthenticatorResponse);
        Intent intent6 = intent.putExtra(GRANTS_GRANTEE_UID, n);
        return intent;
    }

    private void onResult(IAccountManagerResponse iAccountManagerResponse, Bundle bundle) {
        try {
            iAccountManagerResponse.onResult(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            if (!Log.isLoggable(TAG, 2)) {
                return;
            }
            int n = Log.v(TAG, "failure while notifying response", remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean permissionIsGranted(Account account, String string2, int n) {
        String string3;
        boolean bl = this.inSystemImage(n);
        boolean bl2 = account != null && this.hasAuthenticatorUid(string3 = account.type, n);
        boolean bl3 = account != null && this.hasExplicitlyGrantedPermission(account, string2);
        if (Log.isLoggable(TAG, 2)) {
            String string4 = "checkGrantsOrCallingUidAgainstAuthenticator: caller uid " + n + ", account " + account + ": is authenticator? " + bl2 + ", has explicit permission? " + bl3;
            int n2 = Log.v(TAG, string4);
        }
        if (bl2) return true;
        if (bl3) return true;
        if (bl) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String readPasswordFromDatabase(Account account) {
        if (account == null) {
            return null;
        }
        SQLiteDatabase sQLiteDatabase = this.mOpenHelper.getReadableDatabase();
        String[] stringArray = new String[]{ACCOUNTS_PASSWORD};
        String string2 = account.name;
        String string3 = account.type;
        String[] stringArray2 = new String[]{string2, string3};
        String string4 = null;
        String string5 = null;
        Cursor cursor = sQLiteDatabase.query(TABLE_ACCOUNTS, stringArray, "name=? AND type=?", stringArray2, null, string4, string5);
        try {
            if (cursor.moveToNext()) {
                String string6;
                String string7 = string6 = cursor.getString(0);
                cursor.close();
                return string7;
            }
            cursor.close();
            return null;
        }
        catch (Throwable throwable) {
            cursor.close();
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String readUserDataFromDatabase(Account account, String string2) {
        if (account == null) {
            return null;
        }
        SQLiteDatabase sQLiteDatabase = this.mOpenHelper.getReadableDatabase();
        String[] stringArray = new String[]{"value"};
        String string3 = account.name;
        String string4 = account.type;
        String[] stringArray2 = new String[]{string3, string4, string2};
        String string5 = null;
        String string6 = null;
        Cursor cursor = sQLiteDatabase.query(TABLE_EXTRAS, stringArray, "accounts_id=(select _id FROM accounts WHERE name=? AND type=?) AND key=?", stringArray2, null, string5, string6);
        try {
            if (cursor.moveToNext()) {
                String string7;
                String string8 = string7 = cursor.getString(0);
                cursor.close();
                return string8;
            }
            cursor.close();
            return null;
        }
        catch (Throwable throwable) {
            cursor.close();
            throw throwable;
        }
    }

    private void removeAccount(Account account) {
        SQLiteDatabase sQLiteDatabase = this.mOpenHelper.getWritableDatabase();
        String string2 = account.name;
        String string3 = account.type;
        String[] stringArray = new String[]{string2, string3};
        int n = sQLiteDatabase.delete(TABLE_ACCOUNTS, "name=? AND type=?", stringArray);
        this.sendAccountsChangedBroadcast();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean saveAuthTokenToDatabase(Account account, String string2, String string3) {
        long l;
        SQLiteDatabase sQLiteDatabase;
        block7: {
            long l2;
            if (account == null) return false;
            if (string2 == null) {
                return false;
            }
            int n = this.getSigninRequiredNotificationId(account);
            this.cancelNotification(n);
            sQLiteDatabase = this.mOpenHelper.getWritableDatabase();
            sQLiteDatabase.beginTransaction();
            l = l2 = this.getAccountId(sQLiteDatabase, account);
            if (l >= 0L) break block7;
            sQLiteDatabase.endTransaction();
            return false;
        }
        try {
            boolean bl;
            String string4 = "accounts_id=" + l + " AND " + "type" + "=?";
            String[] stringArray = new String[]{string2};
            int n = sQLiteDatabase.delete(TABLE_AUTHTOKENS, string4, stringArray);
            ContentValues contentValues = new ContentValues();
            Long l3 = l;
            contentValues.put("accounts_id", l3);
            contentValues.put("type", string2);
            contentValues.put(AUTHTOKENS_AUTHTOKEN, string3);
            if (sQLiteDatabase.insert(TABLE_AUTHTOKENS, AUTHTOKENS_AUTHTOKEN, contentValues) >= 0L) {
                sQLiteDatabase.setTransactionSuccessful();
                bl = true;
                return bl;
            }
            bl = false;
            return bl;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean scanArgs(String[] stringArray, String string2) {
        if (stringArray == null) return false;
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        int n2 = 0;
        while (n2 < n) {
            String string3 = stringArray2[n2];
            if (string2.equals(string3)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void sendAccountsChangedBroadcast() {
        Context context = this.mContext;
        Intent intent = ACCOUNTS_CHANGED_INTENT;
        context.sendBroadcast(intent);
    }

    private void setMetaValue(String string2, String string3) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("key", string2);
        contentValues.put("value", string3);
        long l = this.mOpenHelper.getWritableDatabase().replace(TABLE_META, "key", contentValues);
    }

    private void setPasswordInDB(Account account, String string2) {
        if (account == null) {
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.mOpenHelper.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            ContentValues contentValues = new ContentValues();
            contentValues.put(ACCOUNTS_PASSWORD, string2);
            long l = this.getAccountId(sQLiteDatabase, account);
            if (l >= 0L) {
                String string3 = String.valueOf(l);
                String[] stringArray = new String[]{string3};
                int n = sQLiteDatabase.update(TABLE_ACCOUNTS, contentValues, "_id=?", stringArray);
                int n2 = sQLiteDatabase.delete(TABLE_AUTHTOKENS, "accounts_id=?", stringArray);
                sQLiteDatabase.setTransactionSuccessful();
            }
            this.sendAccountsChangedBroadcast();
            return;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    private void validateAccounts() {
        boolean bl = false;
        SQLiteDatabase sQLiteDatabase = this.mOpenHelper.getWritableDatabase();
        String[] stringArray = new String[]{"_id", "type", ACCOUNTS_NAME};
        String[] stringArray2 = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Cursor cursor = sQLiteDatabase.query(TABLE_ACCOUNTS, stringArray, null, stringArray2, string2, string3, string4);
        block2: while (true) {
            try {
                while (cursor.moveToNext()) {
                    long l = cursor.getLong(0);
                    String string5 = cursor.getString(1);
                    String string6 = cursor.getString(2);
                    AccountAuthenticatorCache accountAuthenticatorCache = this.mAuthenticatorCache;
                    AuthenticatorDescription authenticatorDescription = AuthenticatorDescription.newKey(string5);
                    if (accountAuthenticatorCache.getServiceInfo(authenticatorDescription) != null) continue;
                    String string7 = "deleting account " + string6 + " because type " + string5 + " no longer has a registered authenticator";
                    int n = Log.d(TAG, string7);
                    String string8 = "_id=" + l;
                    int n2 = sQLiteDatabase.delete(TABLE_ACCOUNTS, string8, null);
                    bl = true;
                    continue block2;
                }
                break;
            }
            catch (Throwable throwable) {
                cursor.close();
                if (bl) {
                    this.sendAccountsChangedBroadcast();
                }
                throw throwable;
            }
        }
        cursor.close();
        if (!bl) {
            return;
        }
        this.sendAccountsChangedBroadcast();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeUserdataIntoDatabase(Account account, String string2, String string3) {
        SQLiteDatabase sQLiteDatabase;
        block9: {
            if (account == null) {
                return;
            }
            if (string2 == null) {
                return;
            }
            sQLiteDatabase = this.mOpenHelper.getWritableDatabase();
            sQLiteDatabase.beginTransaction();
            try {
                long l;
                long l2 = l = this.getAccountId(sQLiteDatabase, account);
                if (l2 < 0L) break block9;
                long l3 = this.getExtrasId(sQLiteDatabase, l2, string2);
                if (l3 < 0L) {
                    AccountManagerService accountManagerService = this;
                    String string4 = string2;
                    String string5 = string3;
                    if (accountManagerService.insertExtra(sQLiteDatabase, l2, string4, string5) < 0L) break block9;
                } else {
                    ContentValues contentValues = new ContentValues();
                    contentValues.put("value", string3);
                    boolean bl = true;
                    String string6 = "_id=" + l3;
                    l = sQLiteDatabase.update(TABLE_EXTRAS, (ContentValues)bl, string6, null);
                    long l4 = l;
                    if (bl != l4) break block9;
                }
                sQLiteDatabase.setTransactionSuccessful();
                {
                }
            }
            catch (Throwable throwable) {
                sQLiteDatabase.endTransaction();
                throw throwable;
            }
        }
        sQLiteDatabase.endTransaction();
    }

    @Override
    public boolean addAccount(Account account, String string2, Bundle bundle) {
        boolean bl;
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        this.checkAuthenticateAccountsPermission(account);
        long l = AccountManagerService.clearCallingIdentity();
        try {
            boolean bl2;
            bl = bl2 = this.insertAccountIntoDatabase(account, string2, bundle);
        }
        catch (Throwable throwable) {
            AccountManagerService.restoreCallingIdentity(l);
            throw throwable;
        }
        AccountManagerService.restoreCallingIdentity(l);
        return bl;
    }

    @Override
    public void addAcount(IAccountManagerResponse iAccountManagerResponse, String string2, String string3, String[] stringArray, boolean bl, Bundle bundle) {
        if (iAccountManagerResponse == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        this.checkManageAccountsPermission();
        long l = AccountManagerService.clearCallingIdentity();
        try {
            AccountManagerService accountManagerService = this;
            IAccountManagerResponse iAccountManagerResponse2 = iAccountManagerResponse;
            String string4 = string2;
            boolean bl2 = bl;
            final String string5 = string3;
            final String[] stringArray2 = stringArray;
            final Bundle bundle2 = bundle;
            final String string6 = string2;
            new Session(iAccountManagerResponse2, string4, bl2, true){

                @Override
                public void run() throws RemoteException {
                    IAccountAuthenticator iAccountAuthenticator = this.mAuthenticator;
                    String string2 = this.mAccountType;
                    String string3 = string5;
                    String[] stringArray = stringArray2;
                    Bundle bundle = bundle2;
                    3 var6_6 = this;
                    iAccountAuthenticator.addAccount(var6_6, string2, string3, stringArray, bundle);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                protected String toDebugString(long l) {
                    String string2;
                    StringBuilder stringBuilder = new StringBuilder();
                    String string3 = super.toDebugString(l);
                    StringBuilder stringBuilder2 = stringBuilder.append(string3).append(", addAccount").append(", accountType ");
                    String string4 = string6;
                    StringBuilder stringBuilder3 = stringBuilder2.append(string4).append(", requiredFeatures ");
                    if (stringArray2 != null) {
                        Object[] objectArray = stringArray2;
                        string2 = TextUtils.join((CharSequence)",", objectArray);
                        return stringBuilder3.append(string2).toString();
                    }
                    string2 = null;
                    return stringBuilder3.append(string2).toString();
                }
            }.bind();
            return;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    @Override
    public void clearPassword(Account account) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        this.checkManageAccountsPermission();
        long l = AccountManagerService.clearCallingIdentity();
        String string2 = null;
        try {
            this.setPasswordInDB(account, string2);
            return;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    @Override
    public void confirmCredentials(IAccountManagerResponse iAccountManagerResponse, Account account, Bundle bundle, boolean bl) {
        if (iAccountManagerResponse == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        this.checkManageAccountsPermission();
        long l = AccountManagerService.clearCallingIdentity();
        try {
            String string2 = account.type;
            AccountManagerService accountManagerService = this;
            IAccountManagerResponse iAccountManagerResponse2 = iAccountManagerResponse;
            boolean bl2 = bl;
            final Account account2 = account;
            final Bundle bundle2 = bundle;
            new Session(iAccountManagerResponse2, string2, bl2, true){

                @Override
                public void run() throws RemoteException {
                    IAccountAuthenticator iAccountAuthenticator = this.mAuthenticator;
                    Account account = account2;
                    Bundle bundle = bundle2;
                    iAccountAuthenticator.confirmCredentials(this, account, bundle);
                }

                @Override
                protected String toDebugString(long l) {
                    StringBuilder stringBuilder = new StringBuilder();
                    String string2 = super.toDebugString(l);
                    StringBuilder stringBuilder2 = stringBuilder.append(string2).append(", confirmCredentials").append(", ");
                    Account account = account2;
                    return stringBuilder2.append(account).toString();
                }
            }.bind();
            return;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        Cursor cursor;
        String string2;
        String[] stringArray2;
        String[] stringArray3 = stringArray;
        String string3 = "--checkin";
        boolean bl = AccountManagerService.scanArgs(stringArray3, string3) || AccountManagerService.scanArgs(stringArray2 = stringArray, string2 = "-c");
        if (bl) {
            SQLiteDatabase sQLiteDatabase = this.mOpenHelper.getReadableDatabase();
            String[] stringArray4 = ACCOUNT_TYPE_COUNT_PROJECTION;
            cursor = sQLiteDatabase.query(TABLE_ACCOUNTS, stringArray4, null, null, "type", null, null);
            try {
                while (cursor.moveToNext()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    String string4 = cursor.getString(0);
                    StringBuilder stringBuilder2 = stringBuilder.append(string4).append(",");
                    String string5 = cursor.getString(1);
                    String string6 = stringBuilder2.append(string5).toString();
                    PrintWriter printWriter2 = printWriter;
                    String string7 = string6;
                    printWriter2.println(string7);
                }
            }
            catch (Throwable throwable) {
                if (cursor != null) {
                    cursor.close();
                }
                throw throwable;
            }
        } else {
            int n;
            Iterator iterator;
            AccountManagerService accountManagerService = this;
            String string8 = null;
            Account[] accountArray = accountManagerService.getAccountsByType(string8);
            StringBuilder stringBuilder = new StringBuilder().append("Accounts: ");
            int n2 = accountArray.length;
            String string9 = stringBuilder.append(n2).toString();
            PrintWriter printWriter3 = printWriter;
            String string10 = string9;
            printWriter3.println(string10);
            Account[] accountArray2 = accountArray;
            int n3 = accountArray2.length;
            Iterator iterator2 = null;
            while ((iterator = iterator2) < (n = n3)) {
                Account account = accountArray2[iterator2];
                String string11 = "  " + account;
                PrintWriter printWriter4 = printWriter;
                String string12 = string11;
                printWriter4.println(string12);
                Object var30_31 = iterator2 + true;
            }
            printWriter.println();
            LinkedHashMap<String, Session> linkedHashMap = this.mSessions;
            synchronized (linkedHashMap) {
                long l = SystemClock.elapsedRealtime();
                StringBuilder stringBuilder3 = new StringBuilder().append("Active Sessions: ");
                int n4 = this.mSessions.size();
                String string13 = stringBuilder3.append(n4).toString();
                PrintWriter printWriter5 = printWriter;
                String string14 = string13;
                printWriter5.println(string14);
                iterator2 = this.mSessions.values().iterator();
                while (true) {
                    if (!iterator2.hasNext()) {
                        // MONITOREXIT @DISABLED, blocks:[3, 7, 9, 11] lbl58 : MonitorExitStatement: MONITOREXIT : var37_38
                        printWriter.println();
                        AccountAuthenticatorCache accountAuthenticatorCache = this.mAuthenticatorCache;
                        FileDescriptor fileDescriptor2 = fileDescriptor;
                        PrintWriter printWriter6 = printWriter;
                        String[] stringArray5 = stringArray;
                        accountAuthenticatorCache.dump(fileDescriptor2, printWriter6, stringArray5);
                        return;
                    }
                    Session session = (Session)iterator2.next();
                    StringBuilder stringBuilder4 = new StringBuilder().append("  ");
                    Session session2 = session;
                    long l2 = l;
                    String string15 = session2.toDebugString(l2);
                    String string16 = stringBuilder4.append(string15).toString();
                    PrintWriter printWriter7 = printWriter;
                    String string17 = string16;
                    printWriter7.println(string17);
                }
            }
        }
        if (cursor == null) {
            return;
        }
        cursor.close();
    }

    @Override
    public void editProperties(IAccountManagerResponse iAccountManagerResponse, String string2, boolean bl) {
        if (iAccountManagerResponse == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        this.checkManageAccountsPermission();
        long l = AccountManagerService.clearCallingIdentity();
        try {
            AccountManagerService accountManagerService = this;
            IAccountManagerResponse iAccountManagerResponse2 = iAccountManagerResponse;
            String string3 = string2;
            boolean bl2 = bl;
            final String string4 = string2;
            new Session(iAccountManagerResponse2, string3, bl2, true){

                @Override
                public void run() throws RemoteException {
                    IAccountAuthenticator iAccountAuthenticator = this.mAuthenticator;
                    String string2 = this.mAccountType;
                    iAccountAuthenticator.editProperties(this, string2);
                }

                @Override
                protected String toDebugString(long l) {
                    StringBuilder stringBuilder = new StringBuilder();
                    String string2 = super.toDebugString(l);
                    StringBuilder stringBuilder2 = stringBuilder.append(string2).append(", editProperties").append(", accountType ");
                    String string3 = string4;
                    return stringBuilder2.append(string3).toString();
                }
            }.bind();
            return;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    String getAccountLabel(String string2) {
        AccountAuthenticatorCache accountAuthenticatorCache = this.mAuthenticatorCache;
        AuthenticatorDescription authenticatorDescription = AuthenticatorDescription.newKey(string2);
        RegisteredServicesCache.ServiceInfo<AuthenticatorDescription> serviceInfo = accountAuthenticatorCache.getServiceInfo(authenticatorDescription);
        if (serviceInfo == null) {
            String string3 = "unknown account type: " + string2;
            throw new IllegalArgumentException(string3);
        }
        try {
            Context context;
            Context context2 = this.mContext;
            String string4 = ((AuthenticatorDescription)serviceInfo.type).packageName;
            Context context3 = context = context2.createPackageContext(string4, 0);
            int n = ((AuthenticatorDescription)serviceInfo.type).labelId;
            return context3.getString(n);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string5 = "unknown account type: " + string2;
            throw new IllegalArgumentException(string5);
        }
    }

    @Override
    public Account[] getAccounts(String string2) {
        Account[] accountArray;
        this.checkReadAccountsPermission();
        long l = AccountManagerService.clearCallingIdentity();
        try {
            Account[] accountArray2;
            accountArray = accountArray2 = this.getAccountsByType(string2);
        }
        catch (Throwable throwable) {
            AccountManagerService.restoreCallingIdentity(l);
            throw throwable;
        }
        AccountManagerService.restoreCallingIdentity(l);
        return accountArray;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void getAccountsByFeatures(IAccountManagerResponse var1_1, String var2_2, String[] var3_3) {
        if (var1_1 == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (var2_2 == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        this.checkReadAccountsPermission();
        if (var3_3 != null && var2_2 == null) {
            if (var1_1 == null) {
                return;
            }
            var4_4 = 7;
            var1_1.onError(var4_4, "type is null");
            return;
        }
        var5_5 = AccountManagerService.clearCallingIdentity();
        if (var3_3 == null) ** GOTO lbl17
        try {
            block14: {
                if (var3_3.length != 0) break block14;
lbl17:
                // 2 sources

                var7_6 = this.getAccountsByType(var2_2);
                var8_7 = new Bundle();
                var8_7.putParcelableArray("accounts", var7_6);
                this.onResult(var1_1, var8_7);
lbl21:
                // 2 sources

                return;
            }
            new GetAccountsByTypeAndFeatureSession(var1_1, var2_2, var3_3).bind();
            ** continue;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(var5_5);
        }
        catch (RemoteException var10_9) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Account[] getAccountsByType(String string2) {
        String[] stringArray;
        SQLiteDatabase sQLiteDatabase = this.mOpenHelper.getReadableDatabase();
        String string3 = string2 == null ? null : "type=?";
        if (string2 == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[]{string2};
            stringArray = stringArray2;
        }
        String[] stringArray3 = ACCOUNT_NAME_TYPE_PROJECTION;
        String string4 = null;
        String string5 = null;
        Cursor cursor = sQLiteDatabase.query(TABLE_ACCOUNTS, stringArray3, string3, stringArray, null, string4, string5);
        int n = 0;
        try {
            Account[] accountArray = new Account[cursor.getCount()];
            while (cursor.moveToNext()) {
                Account account;
                String string6 = cursor.getString(1);
                String string7 = cursor.getString(2);
                accountArray[n] = account = new Account(string6, string7);
                ++n;
            }
            return accountArray;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void getAuthToken(IAccountManagerResponse var1_1, Account var2_2, String var3_3, boolean var4_4, boolean var5_5, Bundle var6_6) {
        if (var1_1 == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (var2_2 == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (var3_3 == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        var7_7 = new String[]{"android.permission.USE_CREDENTIALS"};
        var8_8 = this;
        var9_9 = var7_7;
        var8_8.checkBinderPermission(var9_9);
        var10_10 = Binder.getCallingUid();
        var11_11 = this;
        var12_12 = var2_2;
        var13_13 = var3_3;
        var14_14 = var10_10;
        var15_15 = var11_11.permissionIsGranted(var12_12, var13_13, var14_14);
        var16_16 = AccountManagerService.clearCallingIdentity();
        if (!var15_15) ** GOTO lbl45
        try {
            var18_17 = this;
            var19_18 = var2_2;
            var20_19 = var3_3;
            var21_20 = var18_17.readAuthTokenFromDatabase(var19_18, var20_19);
            if (var21_20 != null) {
                var23_22 = var22_21 = new Bundle();
                var24_23 = "authtoken";
                var25_24 = var21_20;
                var23_22.putString(var24_23, var25_24);
                var26_25 = var2_2.name;
                var27_26 = var22_21;
                var28_27 = "authAccount";
                var29_28 = var26_25;
                var27_26.putString(var28_27, var29_28);
                var30_29 = var2_2.type;
                var31_30 = var22_21;
                var32_31 = "accountType";
                var33_32 = var30_29;
                var31_30.putString(var32_31, var33_32);
                var34_33 = this;
                var35_34 = var1_1;
                var36_35 = var22_21;
                var34_33.onResult(var35_34, var36_35);
lbl43:
                // 2 sources

                return;
            }
lbl45:
            // 3 sources

            var37_36 = var2_2.type;
            var38_37 = this;
            var39_38 = var1_1;
            var40_39 = var5_5;
            var41_40 = var6_6;
            var42_41 = var2_2;
            var43_42 = var3_3;
            var44_43 = var4_4;
            new Session(var39_38, var37_36, var40_39, false){

                @Override
                public void onResult(Bundle bundle) {
                    if (bundle != null) {
                        Intent intent;
                        if (bundle.containsKey("authTokenLabelKey")) {
                            AccountManagerService accountManagerService = AccountManagerService.this;
                            Account account = var42_41;
                            int n = var10_10;
                            AccountAuthenticatorResponse accountAuthenticatorResponse = new AccountAuthenticatorResponse(this);
                            String string2 = var43_42;
                            String string3 = bundle.getString("authTokenLabelKey");
                            Intent intent2 = accountManagerService.newGrantCredentialsPermissionIntent(account, n, accountAuthenticatorResponse, string2, string3);
                            Bundle bundle2 = new Bundle();
                            bundle2.putParcelable("intent", intent2);
                            this.onResult(bundle2);
                            return;
                        }
                        String string4 = bundle.getString(AccountManagerService.AUTHTOKENS_AUTHTOKEN);
                        if (string4 != null) {
                            String string5 = bundle.getString("authAccount");
                            String string6 = bundle.getString("accountType");
                            if (TextUtils.isEmpty(string6) || TextUtils.isEmpty(string5)) {
                                this.onError(5, "the type and name should not be empty");
                                return;
                            }
                            AccountManagerService accountManagerService = AccountManagerService.this;
                            Account account = new Account(string5, string6);
                            String string7 = var43_42;
                            boolean bl = accountManagerService.saveAuthTokenToDatabase(account, string7, string4);
                        }
                        if ((intent = (Intent)bundle.getParcelable("intent")) != null && var44_43) {
                            AccountManagerService accountManagerService = AccountManagerService.this;
                            Account account = var42_41;
                            String string8 = bundle.getString("authFailedMessage");
                            accountManagerService.doNotification(account, string8, intent);
                        }
                    }
                    super.onResult(bundle);
                }

                @Override
                public void run() throws RemoteException {
                    if (!var15_15) {
                        IAccountAuthenticator iAccountAuthenticator = this.mAuthenticator;
                        String string2 = var43_42;
                        iAccountAuthenticator.getAuthTokenLabel(this, string2);
                        return;
                    }
                    IAccountAuthenticator iAccountAuthenticator = this.mAuthenticator;
                    Account account = var42_41;
                    String string3 = var43_42;
                    Bundle bundle = var41_40;
                    iAccountAuthenticator.getAuthToken(this, account, string3, bundle);
                }

                @Override
                protected String toDebugString(long l) {
                    if (var41_40 != null) {
                        Set<String> set = var41_40.keySet();
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    String string2 = super.toDebugString(l);
                    StringBuilder stringBuilder2 = stringBuilder.append(string2).append(", getAuthToken").append(", ");
                    Account account = var42_41;
                    StringBuilder stringBuilder3 = stringBuilder2.append(account).append(", authTokenType ");
                    String string3 = var43_42;
                    StringBuilder stringBuilder4 = stringBuilder3.append(string3).append(", loginOptions ");
                    Bundle bundle = var41_40;
                    StringBuilder stringBuilder5 = stringBuilder4.append(bundle).append(", notifyOnAuthFailure ");
                    boolean bl = var44_43;
                    return stringBuilder5.append(bl).toString();
                }
            }.bind();
            ** continue;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(var16_16);
        }
    }

    void getAuthTokenLabel(IAccountManagerResponse iAccountManagerResponse, Account account, String string2) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        String[] stringArray = new String[]{"android.permission.USE_CREDENTIALS"};
        this.checkBinderPermission(stringArray);
        long l = AccountManagerService.clearCallingIdentity();
        try {
            String string3 = account.type;
            AccountManagerService accountManagerService = this;
            IAccountManagerResponse iAccountManagerResponse2 = iAccountManagerResponse;
            final Account account2 = account;
            final String string4 = string2;
            new Session(iAccountManagerResponse2, string3, false, false){

                @Override
                public void onResult(Bundle bundle) {
                    if (bundle != null) {
                        String string2 = bundle.getString("authTokenLabelKey");
                        Bundle bundle2 = new Bundle();
                        bundle2.putString("authTokenLabelKey", string2);
                        super.onResult(bundle2);
                        return;
                    }
                    super.onResult(bundle);
                }

                @Override
                public void run() throws RemoteException {
                    IAccountAuthenticator iAccountAuthenticator = this.mAuthenticator;
                    String string2 = string4;
                    iAccountAuthenticator.getAuthTokenLabel(this, string2);
                }

                @Override
                protected String toDebugString(long l) {
                    StringBuilder stringBuilder = new StringBuilder();
                    String string2 = super.toDebugString(l);
                    StringBuilder stringBuilder2 = stringBuilder.append(string2).append(", getAuthTokenLabel").append(", ");
                    Account account = account2;
                    StringBuilder stringBuilder3 = stringBuilder2.append(account).append(", authTokenType ");
                    String string3 = string4;
                    return stringBuilder3.append(string3).toString();
                }
            }.bind();
            return;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    @Override
    public AuthenticatorDescription[] getAuthenticatorTypes() {
        AuthenticatorDescription[] authenticatorDescriptionArray;
        long l = AccountManagerService.clearCallingIdentity();
        try {
            Collection collection = this.mAuthenticatorCache.getAllServices();
            authenticatorDescriptionArray = new AuthenticatorDescription[collection.size()];
            int n = 0;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                AuthenticatorDescription authenticatorDescription;
                authenticatorDescriptionArray[n] = authenticatorDescription = (AuthenticatorDescription)iterator.next().type;
                ++n;
            }
        }
        catch (Throwable throwable) {
            AccountManagerService.restoreCallingIdentity(l);
            throw throwable;
        }
        AccountManagerService.restoreCallingIdentity(l);
        return authenticatorDescriptionArray;
    }

    @Override
    public String getPassword(Account account) {
        String string2;
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        this.checkAuthenticateAccountsPermission(account);
        long l = AccountManagerService.clearCallingIdentity();
        try {
            String string3;
            string2 = string3 = this.readPasswordFromDatabase(account);
        }
        catch (Throwable throwable) {
            AccountManagerService.restoreCallingIdentity(l);
            throw throwable;
        }
        AccountManagerService.restoreCallingIdentity(l);
        return string2;
    }

    @Override
    public String getUserData(Account account, String string2) {
        String string3;
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("key is null");
        }
        this.checkAuthenticateAccountsPermission(account);
        long l = AccountManagerService.clearCallingIdentity();
        try {
            String string4;
            string3 = string4 = this.readUserDataFromDatabase(account, string2);
        }
        catch (Throwable throwable) {
            AccountManagerService.restoreCallingIdentity(l);
            throw throwable;
        }
        AccountManagerService.restoreCallingIdentity(l);
        return string3;
    }

    public void grantAppPermission(Account account, String string2, int n) {
        if (account == null || string2 == null) {
            Exception exception = new Exception();
            int n2 = Log.e(TAG, "grantAppPermission: called with invalid arguments", exception);
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.mOpenHelper.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            long l = this.getAccountId(sQLiteDatabase, account);
            if (l >= 0L) {
                ContentValues contentValues = new ContentValues();
                Long l2 = l;
                contentValues.put("accounts_id", l2);
                contentValues.put(GRANTS_AUTH_TOKEN_TYPE, string2);
                Integer n3 = n;
                contentValues.put(GRANTS_GRANTEE_UID, n3);
                long l3 = sQLiteDatabase.insert(TABLE_GRANTS, "accounts_id", contentValues);
                sQLiteDatabase.setTransactionSuccessful();
            }
            int n4 = this.getCredentialPermissionNotificationId(account, string2, n);
            this.cancelNotification(n4);
            return;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @Override
    public void hasFeatures(IAccountManagerResponse iAccountManagerResponse, Account account, String[] stringArray) {
        if (iAccountManagerResponse == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("features is null");
        }
        this.checkReadAccountsPermission();
        long l = AccountManagerService.clearCallingIdentity();
        try {
            new TestFeaturesSession(iAccountManagerResponse, account, stringArray).bind();
            return;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public void invalidateAuthToken(String string2, String string3) {
        if (string2 == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("authToken is null");
        }
        this.checkManageAccountsOrUseCredentialsPermissions();
        long l = AccountManagerService.clearCallingIdentity();
        SQLiteDatabase sQLiteDatabase = this.mOpenHelper.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        {
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        try {
            this.invalidateAuthToken(sQLiteDatabase, string2, string3);
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            sQLiteDatabase.endTransaction();
            throw throwable;
        }
        try {
            sQLiteDatabase.endTransaction();
            return;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    public IBinder onBind(Intent intent) {
        return this.asBinder();
    }

    @Override
    public void onServiceChanged(AuthenticatorDescription authenticatorDescription, boolean bl) {
        boolean bl2 = false;
        SQLiteDatabase sQLiteDatabase = this.mOpenHelper.getWritableDatabase();
        String[] stringArray = new String[]{"_id", "type", ACCOUNTS_NAME};
        String string2 = authenticatorDescription.type;
        String[] stringArray2 = new String[]{string2};
        Cursor cursor = sQLiteDatabase.query(TABLE_ACCOUNTS, stringArray, "type=?", stringArray2, null, null, null);
        while (true) {
            try {
                if (!cursor.moveToNext()) break;
                long l = cursor.getLong(0);
                String string3 = cursor.getString(1);
                String string4 = cursor.getString(2);
                String string5 = "deleting account " + string4 + " because type " + string3 + " no longer has a registered authenticator";
                int n = Log.d(TAG, string5);
                String string6 = "_id=" + l;
                int n2 = sQLiteDatabase.delete(TABLE_ACCOUNTS, string6, null);
                bl2 = true;
            }
            catch (Throwable throwable) {
                cursor.close();
                if (bl2) {
                    this.sendAccountsChangedBroadcast();
                }
                throw throwable;
            }
        }
        cursor.close();
        if (!bl2) {
            return;
        }
        this.sendAccountsChangedBroadcast();
    }

    @Override
    public String peekAuthToken(Account account, String string2) {
        String string3;
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        this.checkAuthenticateAccountsPermission(account);
        long l = AccountManagerService.clearCallingIdentity();
        try {
            String string4;
            string3 = string4 = this.readAuthTokenFromDatabase(account, string2);
        }
        catch (Throwable throwable) {
            AccountManagerService.restoreCallingIdentity(l);
            throw throwable;
        }
        AccountManagerService.restoreCallingIdentity(l);
        return string3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String readAuthTokenFromDatabase(Account account, String string2) {
        if (account == null) return null;
        if (string2 == null) {
            return null;
        }
        SQLiteDatabase sQLiteDatabase = this.mOpenHelper.getReadableDatabase();
        String[] stringArray = new String[]{AUTHTOKENS_AUTHTOKEN};
        String string3 = account.name;
        String string4 = account.type;
        String[] stringArray2 = new String[]{string3, string4, string2};
        String string5 = null;
        String string6 = null;
        Cursor cursor = sQLiteDatabase.query(TABLE_AUTHTOKENS, stringArray, "accounts_id=(select _id FROM accounts WHERE name=? AND type=?) AND type=?", stringArray2, null, string5, string6);
        try {
            if (cursor.moveToNext()) {
                String string7;
                String string8 = string7 = cursor.getString(0);
                cursor.close();
                return string8;
            }
            cursor.close();
            return null;
        }
        catch (Throwable throwable) {
            cursor.close();
            throw throwable;
        }
    }

    @Override
    public void removeAccount(IAccountManagerResponse iAccountManagerResponse, Account account) {
        if (iAccountManagerResponse == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        this.checkManageAccountsPermission();
        long l = AccountManagerService.clearCallingIdentity();
        try {
            new RemoveAccountSession(iAccountManagerResponse, account).bind();
            return;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    public void revokeAppPermission(Account account, String string2, int n) {
        if (account == null || string2 == null) {
            Exception exception = new Exception();
            int n2 = Log.e(TAG, "revokeAppPermission: called with invalid arguments", exception);
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.mOpenHelper.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            long l = this.getAccountId(sQLiteDatabase, account);
            if (l >= 0L) {
                String string3;
                String string4 = String.valueOf(l);
                String[] stringArray = new String[]{string4, string2, string3 = String.valueOf(n)};
                int n3 = sQLiteDatabase.delete(TABLE_GRANTS, "accounts_id=? AND auth_token_type=? AND uid=?", stringArray);
                sQLiteDatabase.setTransactionSuccessful();
            }
            int n4 = this.getCredentialPermissionNotificationId(account, string2, n);
            this.cancelNotification(n4);
            return;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @Override
    public void setAuthToken(Account account, String string2, String string3) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        this.checkAuthenticateAccountsPermission(account);
        long l = AccountManagerService.clearCallingIdentity();
        try {
            boolean bl = this.saveAuthTokenToDatabase(account, string2, string3);
            return;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    @Override
    public void setPassword(Account account, String string2) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        this.checkAuthenticateAccountsPermission(account);
        long l = AccountManagerService.clearCallingIdentity();
        try {
            this.setPasswordInDB(account, string2);
            return;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    @Override
    public void setUserData(Account account, String string2, String string3) {
        if (string2 == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        this.checkAuthenticateAccountsPermission(account);
        long l = AccountManagerService.clearCallingIdentity();
        if (account == null) {
            return;
        }
        if (account.type.equals(GOOGLE_ACCOUNT_TYPE) && string2.equals("broadcast")) {
            this.sendAccountsChangedBroadcast();
            return;
        }
        try {
            this.writeUserdataIntoDatabase(account, string2, string3);
            return;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    @Override
    public void updateCredentials(IAccountManagerResponse iAccountManagerResponse, Account account, String string2, boolean bl, Bundle bundle) {
        if (iAccountManagerResponse == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        this.checkManageAccountsPermission();
        long l = AccountManagerService.clearCallingIdentity();
        try {
            String string3 = account.type;
            AccountManagerService accountManagerService = this;
            IAccountManagerResponse iAccountManagerResponse2 = iAccountManagerResponse;
            boolean bl2 = bl;
            final Account account2 = account;
            final String string4 = string2;
            final Bundle bundle2 = bundle;
            new Session(iAccountManagerResponse2, string3, bl2, true){

                @Override
                public void run() throws RemoteException {
                    IAccountAuthenticator iAccountAuthenticator = this.mAuthenticator;
                    Account account = account2;
                    String string2 = string4;
                    Bundle bundle = bundle2;
                    iAccountAuthenticator.updateCredentials(this, account, string2, bundle);
                }

                @Override
                protected String toDebugString(long l) {
                    if (bundle2 != null) {
                        Set<String> set = bundle2.keySet();
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    String string2 = super.toDebugString(l);
                    StringBuilder stringBuilder2 = stringBuilder.append(string2).append(", updateCredentials").append(", ");
                    Account account = account2;
                    StringBuilder stringBuilder3 = stringBuilder2.append(account).append(", authTokenType ");
                    String string3 = string4;
                    StringBuilder stringBuilder4 = stringBuilder3.append(string3).append(", loginOptions ");
                    Bundle bundle = bundle2;
                    return stringBuilder4.append(bundle).toString();
                }
            }.bind();
            return;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    private class SimWatcher
    extends BroadcastReceiver {
        public SimWatcher(Context context) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SIM_STATE_CHANGED");
            intentFilter.addAction("android.intent.action.DEVICE_STORAGE_OK");
            Intent intent = context.registerReceiver(this, intentFilter);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            SQLiteDatabase sQLiteDatabase;
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager == null) {
                int n = Log.w(AccountManagerService.TAG, "failed to get TelephonyManager");
                return;
            }
            String string2 = telephonyManager.getSubscriberId();
            if (TextUtils.isEmpty(string2)) {
                return;
            }
            String string3 = AccountManagerService.this.getMetaValue("imsi");
            if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                String string4 = "current IMSI=" + string2 + "; stored IMSI=" + string3;
                int n = Log.v(AccountManagerService.TAG, string4);
            }
            if (string2.equals(string3)) {
                return;
            }
            if (telephonyManager.getPhoneType() == 2) {
                boolean bl;
                IBinder iBinder = ServiceManager.checkService("phone");
                if (iBinder == null) {
                    int n = Log.w(AccountManagerService.TAG, "call to checkService(TELEPHONY_SERVICE) failed");
                    return;
                }
                ITelephony iTelephony = ITelephony.Stub.asInterface(iBinder);
                if (iTelephony == null) {
                    int n = Log.w(AccountManagerService.TAG, "failed to get ITelephony interface");
                    return;
                }
                try {
                    boolean bl2;
                    bl = bl2 = iTelephony.getCdmaNeedsProvisioning();
                }
                catch (RemoteException remoteException) {
                    int n = Log.w(AccountManagerService.TAG, "exception while checking provisioning", remoteException);
                    bl = true;
                }
                if (bl) {
                    if (!Log.isLoggable(AccountManagerService.TAG, 2)) {
                        return;
                    }
                    String string5 = "current IMSI=" + string2 + " (needs provisioning); stored IMSI=" + string3;
                    int n = Log.v(AccountManagerService.TAG, string5);
                    return;
                }
            }
            if (!string2.equals(string3) && !TextUtils.isEmpty(string3)) {
                String string6 = "wiping all passwords and authtokens because IMSI changed (stored=" + string3 + ", current=" + string2 + ")";
                int n = Log.w(AccountManagerService.TAG, string6);
                sQLiteDatabase = AccountManagerService.this.mOpenHelper.getWritableDatabase();
                sQLiteDatabase.beginTransaction();
                sQLiteDatabase.execSQL("DELETE from authtokens");
                sQLiteDatabase.execSQL("UPDATE accounts SET password = ''");
                AccountManagerService.this.sendAccountsChangedBroadcast();
                sQLiteDatabase.setTransactionSuccessful();
            }
            AccountManagerService.this.setMetaValue("imsi", string2);
            return;
            finally {
                sQLiteDatabase.endTransaction();
            }
        }
    }

    private class DatabaseHelper
    extends SQLiteOpenHelper {
        public DatabaseHelper(Context context) {
            String string2 = AccountManagerService.getDatabaseName();
            super(context, string2, null, 4);
        }

        private void createAccountsDeletionTrigger(SQLiteDatabase sQLiteDatabase) {
            sQLiteDatabase.execSQL(" CREATE TRIGGER accountsDelete DELETE ON accounts BEGIN   DELETE FROM authtokens     WHERE accounts_id=OLD._id ;   DELETE FROM extras     WHERE accounts_id=OLD._id ;   DELETE FROM grants     WHERE accounts_id=OLD._id ; END");
        }

        private void createGrantsTable(SQLiteDatabase sQLiteDatabase) {
            sQLiteDatabase.execSQL("CREATE TABLE grants (  accounts_id INTEGER NOT NULL, auth_token_type STRING NOT NULL,  uid INTEGER NOT NULL,  UNIQUE (accounts_id,auth_token_type,uid))");
        }

        @Override
        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            sQLiteDatabase.execSQL("CREATE TABLE accounts ( _id INTEGER PRIMARY KEY AUTOINCREMENT, name TEXT NOT NULL, type TEXT NOT NULL, password TEXT, UNIQUE(name,type))");
            sQLiteDatabase.execSQL("CREATE TABLE authtokens (  _id INTEGER PRIMARY KEY AUTOINCREMENT,  accounts_id INTEGER NOT NULL, type TEXT NOT NULL,  authtoken TEXT,  UNIQUE (accounts_id,type))");
            this.createGrantsTable(sQLiteDatabase);
            sQLiteDatabase.execSQL("CREATE TABLE extras ( _id INTEGER PRIMARY KEY AUTOINCREMENT, accounts_id INTEGER, key TEXT NOT NULL, value TEXT, UNIQUE(accounts_id,key))");
            sQLiteDatabase.execSQL("CREATE TABLE meta ( key TEXT PRIMARY KEY NOT NULL, value TEXT)");
            this.createAccountsDeletionTrigger(sQLiteDatabase);
        }

        @Override
        public void onOpen(SQLiteDatabase sQLiteDatabase) {
            if (!Log.isLoggable(AccountManagerService.TAG, 2)) {
                return;
            }
            int n = Log.v(AccountManagerService.TAG, "opened database accounts.db");
        }

        @Override
        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
            String string2 = "upgrade from version " + n + " to version " + n2;
            int n3 = Log.e(AccountManagerService.TAG, string2);
            if (n == 1) {
                ++n;
            }
            if (n == 2) {
                this.createGrantsTable(sQLiteDatabase);
                sQLiteDatabase.execSQL("DROP TRIGGER accountsDelete");
                this.createAccountsDeletionTrigger(sQLiteDatabase);
                ++n;
            }
            if (n != 3) {
                return;
            }
            sQLiteDatabase.execSQL("UPDATE accounts SET type = 'com.google' WHERE type == 'com.google.GAIA'");
            int n4 = n + 1;
        }
    }

    private class MessageHandler
    extends Handler {
        MessageHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    StringBuilder stringBuilder = new StringBuilder().append("unhandled message: ");
                    int n = message.what;
                    String string2 = stringBuilder.append(n).toString();
                    throw new IllegalStateException(string2);
                }
                case 3: 
            }
            ((Session)message.obj).onTimedOut();
        }
    }

    private abstract class Session
    extends IAccountAuthenticatorResponse.Stub
    implements IBinder.DeathRecipient,
    ServiceConnection {
        final String mAccountType;
        IAccountAuthenticator mAuthenticator = null;
        final long mCreationTime;
        final boolean mExpectActivityLaunch;
        private int mNumErrors = 0;
        private int mNumRequestContinued = 0;
        public int mNumResults = 0;
        IAccountManagerResponse mResponse;
        private final boolean mStripAuthTokenFromResult;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Session(IAccountManagerResponse iAccountManagerResponse, String string2, boolean bl, boolean bl2) {
            long l;
            if (iAccountManagerResponse == null) {
                throw new IllegalArgumentException("response is null");
            }
            if (string2 == null) {
                throw new IllegalArgumentException("accountType is null");
            }
            this.mStripAuthTokenFromResult = bl2;
            this.mResponse = iAccountManagerResponse;
            this.mAccountType = string2;
            this.mExpectActivityLaunch = bl;
            this.mCreationTime = l = SystemClock.elapsedRealtime();
            LinkedHashMap linkedHashMap = AccountManagerService.this.mSessions;
            synchronized (linkedHashMap) {
                LinkedHashMap linkedHashMap2 = AccountManagerService.this.mSessions;
                String string3 = this.toString();
                Session session = linkedHashMap2.put(string3, this);
            }
            try {
                iAccountManagerResponse.asBinder().linkToDeath(this, 0);
                return;
            }
            catch (RemoteException remoteException) {
                this.mResponse = null;
                this.binderDied();
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean bindToAuthenticator(String string2) {
            AuthenticatorDescription authenticatorDescription;
            AccountAuthenticatorCache accountAuthenticatorCache = AccountManagerService.this.mAuthenticatorCache;
            RegisteredServicesCache.ServiceInfo<AuthenticatorDescription> serviceInfo = accountAuthenticatorCache.getServiceInfo(authenticatorDescription = AuthenticatorDescription.newKey(string2));
            if (serviceInfo == null) {
                if (!Log.isLoggable(AccountManagerService.TAG, 2)) return false;
                String string3 = "there is no authenticator for " + string2 + ", bailing out";
                int n = Log.v(AccountManagerService.TAG, string3);
                return false;
            }
            Intent intent = new Intent();
            Intent intent2 = intent.setAction("android.accounts.AccountAuthenticator");
            ComponentName componentName = serviceInfo.componentName;
            Intent intent3 = intent.setComponent(componentName);
            if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                StringBuilder stringBuilder = new StringBuilder().append("performing bindService to ");
                ComponentName componentName2 = serviceInfo.componentName;
                String string4 = stringBuilder.append(componentName2).toString();
                int n = Log.v(AccountManagerService.TAG, string4);
            }
            if (AccountManagerService.this.mContext.bindService(intent, this, 1)) return true;
            if (!Log.isLoggable(AccountManagerService.TAG, 2)) return false;
            StringBuilder stringBuilder = new StringBuilder().append("bindService to ");
            ComponentName componentName3 = serviceInfo.componentName;
            String string5 = stringBuilder.append(componentName3).append(" failed").toString();
            int n = Log.v(AccountManagerService.TAG, string5);
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void close() {
            LinkedHashMap linkedHashMap = AccountManagerService.this.mSessions;
            // MONITORENTER : linkedHashMap
            LinkedHashMap linkedHashMap2 = AccountManagerService.this.mSessions;
            String string2 = this.toString();
            if (linkedHashMap2.remove(string2) == null) {
                // MONITOREXIT : linkedHashMap
                return;
            }
            // MONITOREXIT : linkedHashMap
            if (this.mResponse != null) {
                boolean bl = this.mResponse.asBinder().unlinkToDeath(this, 0);
                this.mResponse = null;
            }
            this.cancelTimeout();
            this.unbind();
        }

        private void unbind() {
            if (this.mAuthenticator == null) {
                return;
            }
            this.mAuthenticator = null;
            AccountManagerService.this.mContext.unbindService(this);
        }

        void bind() {
            String string2;
            if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                StringBuilder stringBuilder = new StringBuilder().append("initiating bind to authenticator type ");
                String string3 = this.mAccountType;
                String string4 = stringBuilder.append(string3).toString();
                int n = Log.v(AccountManagerService.TAG, string4);
            }
            if (this.bindToAuthenticator(string2 = this.mAccountType)) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder().append("bind attempt failed for ");
            String string5 = this.toDebugString();
            String string6 = stringBuilder.append(string5).toString();
            int n = Log.d(AccountManagerService.TAG, string6);
            this.onError(1, "bind failure");
        }

        @Override
        public void binderDied() {
            this.mResponse = null;
            this.close();
        }

        public void cancelTimeout() {
            AccountManagerService.this.mMessageHandler.removeMessages(3, this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        IAccountManagerResponse getResponseAndClose() {
            if (this.mResponse == null) {
                return null;
            }
            IAccountManagerResponse iAccountManagerResponse = this.mResponse;
            this.close();
            return iAccountManagerResponse;
        }

        @Override
        public void onError(int n, String string2) {
            IAccountManagerResponse iAccountManagerResponse;
            int n2;
            this.mNumErrors = n2 = this.mNumErrors + 1;
            if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                String string3 = "Session.onError: " + n + ", " + string2;
                int n3 = Log.v(AccountManagerService.TAG, string3);
            }
            if ((iAccountManagerResponse = this.getResponseAndClose()) != null) {
                if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                    int n4 = Log.v(AccountManagerService.TAG, "Session.onError: responding");
                }
                try {
                    iAccountManagerResponse.onError(n, string2);
                    return;
                }
                catch (RemoteException remoteException) {
                    if (!Log.isLoggable(AccountManagerService.TAG, 2)) {
                        return;
                    }
                    int n5 = Log.v(AccountManagerService.TAG, "Session.onError: caught RemoteException while responding", remoteException);
                    return;
                }
            }
            if (!Log.isLoggable(AccountManagerService.TAG, 2)) {
                return;
            }
            int n6 = Log.v(AccountManagerService.TAG, "Session.onError: already closed");
        }

        @Override
        public void onRequestContinued() {
            int n;
            this.mNumRequestContinued = n = this.mNumRequestContinued + 1;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void onResult(Bundle var1_1) {
            block10: {
                this.mNumResults = var2_2 = this.mNumResults + 1;
                if (var1_1 != null && !TextUtils.isEmpty(var1_1.getString("authtoken"))) {
                    var3_3 = var1_1.getString("authAccount");
                    var4_4 = var1_1.getString("accountType");
                    if (!TextUtils.isEmpty(var3_3) && !TextUtils.isEmpty(var4_4)) {
                        var5_5 = new Account(var3_3, var4_4);
                        var6_6 = AccountManagerService.this;
                        var7_7 = AccountManagerService.access$700(AccountManagerService.this, var5_5);
                        AccountManagerService.access$800(var6_6, var7_7);
                    }
                }
                if (this.mExpectActivityLaunch && var1_1 != null && var1_1.containsKey("intent")) {
                    var8_8 = this.mResponse;
lbl12:
                    // 2 sources

                    while (true) {
                        if (var8_8 == null) {
                            return;
                        }
                        if (var1_1 != null) break block10;
                        var9_9 = 5;
                        var8_8.onError(var9_9, "null bundle returned");
                        return;
                        break;
                    }
                }
                var8_8 = this.getResponseAndClose();
                ** while (true)
            }
            try {
                if (this.mStripAuthTokenFromResult) {
                    var1_1.remove("authtoken");
                }
                var8_8.onResult(var1_1);
                return;
            }
            catch (RemoteException var10_10) {
                if (!Log.isLoggable("AccountManagerService", 2)) {
                    return;
                }
                var11_11 = Log.v("AccountManagerService", "failure while notifying response", var10_10);
                return;
            }
        }

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            IAccountAuthenticator iAccountAuthenticator;
            this.mAuthenticator = iAccountAuthenticator = IAccountAuthenticator.Stub.asInterface(iBinder);
            try {
                this.run();
                return;
            }
            catch (RemoteException remoteException) {
                this.onError(1, "remote exception");
                return;
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            this.mAuthenticator = null;
            if (this.getResponseAndClose() == null) {
                return;
            }
            this.onError(1, "disconnected");
        }

        public void onTimedOut() {
            if (this.getResponseAndClose() == null) {
                return;
            }
            this.onError(1, "timeout");
        }

        public abstract void run() throws RemoteException;

        public void scheduleTimeout() {
            MessageHandler messageHandler = AccountManagerService.this.mMessageHandler;
            Message message = AccountManagerService.this.mMessageHandler.obtainMessage(3, this);
            boolean bl = messageHandler.sendMessageDelayed(message, 60000L);
        }

        protected String toDebugString() {
            long l = SystemClock.elapsedRealtime();
            return this.toDebugString(l);
        }

        /*
         * Enabled aggressive block sorting
         */
        protected String toDebugString(long l) {
            StringBuilder stringBuilder = new StringBuilder().append("Session: expectLaunch ");
            boolean bl = this.mExpectActivityLaunch;
            StringBuilder stringBuilder2 = stringBuilder.append(bl).append(", connected ");
            boolean bl2 = this.mAuthenticator != null;
            StringBuilder stringBuilder3 = stringBuilder2.append(bl2).append(", stats (");
            int n = this.mNumResults;
            StringBuilder stringBuilder4 = stringBuilder3.append(n).append("/");
            int n2 = this.mNumRequestContinued;
            StringBuilder stringBuilder5 = stringBuilder4.append(n2).append("/");
            int n3 = this.mNumErrors;
            StringBuilder stringBuilder6 = stringBuilder5.append(n3).append(")").append(", lifetime ");
            long l2 = this.mCreationTime;
            double d = (double)(l - l2) / 1000.0;
            return stringBuilder6.append(d).toString();
        }
    }

    private class GetAccountsByTypeAndFeatureSession
    extends Session {
        private volatile Account[] mAccountsOfType;
        private volatile ArrayList<Account> mAccountsWithFeatures;
        private volatile int mCurrentAccount;
        private final String[] mFeatures;

        public GetAccountsByTypeAndFeatureSession(IAccountManagerResponse iAccountManagerResponse, String string2, String[] stringArray) {
            GetAccountsByTypeAndFeatureSession getAccountsByTypeAndFeatureSession = this;
            AccountManagerService accountManagerService2 = AccountManagerService.this;
            IAccountManagerResponse iAccountManagerResponse2 = iAccountManagerResponse;
            String string3 = string2;
            super(iAccountManagerResponse2, string3, false, true);
            this.mAccountsOfType = null;
            this.mAccountsWithFeatures = null;
            this.mCurrentAccount = 0;
            this.mFeatures = stringArray;
        }

        public void checkAccount() {
            int n = this.mCurrentAccount;
            int n2 = this.mAccountsOfType.length;
            if (n >= n2) {
                this.sendResult();
                return;
            }
            IAccountAuthenticator iAccountAuthenticator = this.mAuthenticator;
            if (iAccountAuthenticator == null) {
                if (!Log.isLoggable(AccountManagerService.TAG, 2)) {
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder().append("checkAccount: aborting session since we are no longer connected to the authenticator, ");
                String string2 = this.toDebugString();
                String string3 = stringBuilder.append(string2).toString();
                int n3 = Log.v(AccountManagerService.TAG, string3);
                return;
            }
            try {
                Account[] accountArray = this.mAccountsOfType;
                int n4 = this.mCurrentAccount;
                Account account = accountArray[n4];
                String[] stringArray = this.mFeatures;
                iAccountAuthenticator.hasFeatures(this, account, stringArray);
                return;
            }
            catch (RemoteException remoteException) {
                this.onError(1, "remote exception");
                return;
            }
        }

        @Override
        public void onResult(Bundle bundle) {
            int n;
            int n2;
            this.mNumResults = n2 = this.mNumResults + 1;
            if (bundle == null) {
                this.onError(5, "null bundle");
                return;
            }
            if (bundle.getBoolean("booleanResult", false)) {
                ArrayList<Account> arrayList = this.mAccountsWithFeatures;
                Account[] accountArray = this.mAccountsOfType;
                int n3 = this.mCurrentAccount;
                Account account = accountArray[n3];
                boolean bl = arrayList.add(account);
            }
            this.mCurrentAccount = n = this.mCurrentAccount + 1;
            this.checkAccount();
        }

        @Override
        public void run() throws RemoteException {
            AccountManagerService accountManagerService = AccountManagerService.this;
            String string2 = this.mAccountType;
            Account[] accountArray = accountManagerService.getAccountsByType(string2);
            this.mAccountsOfType = accountArray;
            int n = this.mAccountsOfType.length;
            ArrayList arrayList = new ArrayList(n);
            this.mAccountsWithFeatures = arrayList;
            this.mCurrentAccount = 0;
            this.checkAccount();
        }

        public void sendResult() {
            IAccountManagerResponse iAccountManagerResponse = this.getResponseAndClose();
            if (iAccountManagerResponse == null) {
                return;
            }
            try {
                int n;
                Parcelable[] parcelableArray = new Account[this.mAccountsWithFeatures.size()];
                for (int i = 0; i < (n = parcelableArray.length); ++i) {
                    Account account = this.mAccountsWithFeatures.get(i);
                    parcelableArray[i] = account;
                }
                Bundle bundle = new Bundle();
                bundle.putParcelableArray(AccountManagerService.TABLE_ACCOUNTS, parcelableArray);
                iAccountManagerResponse.onResult(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                if (!Log.isLoggable(AccountManagerService.TAG, 2)) {
                    return;
                }
                int n = Log.v(AccountManagerService.TAG, "failure while notifying response", remoteException);
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected String toDebugString(long l) {
            String string2;
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = super.toDebugString(l);
            StringBuilder stringBuilder2 = stringBuilder.append(string3).append(", getAccountsByTypeAndFeatures").append(", ");
            if (this.mFeatures != null) {
                Object[] objectArray = this.mFeatures;
                string2 = TextUtils.join((CharSequence)",", objectArray);
                return stringBuilder2.append(string2).toString();
            }
            string2 = null;
            return stringBuilder2.append(string2).toString();
        }
    }

    private class RemoveAccountSession
    extends Session {
        final Account mAccount;

        public RemoveAccountSession(IAccountManagerResponse iAccountManagerResponse, Account account) {
            String string2 = account.type;
            RemoveAccountSession removeAccountSession = this;
            AccountManagerService accountManagerService2 = AccountManagerService.this;
            IAccountManagerResponse iAccountManagerResponse2 = iAccountManagerResponse;
            super(iAccountManagerResponse2, string2, false, true);
            this.mAccount = account;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onResult(Bundle bundle) {
            if (bundle != null && bundle.containsKey("booleanResult") && !bundle.containsKey("intent")) {
                IAccountManagerResponse iAccountManagerResponse;
                boolean bl = bundle.getBoolean("booleanResult");
                if (bl) {
                    AccountManagerService accountManagerService = AccountManagerService.this;
                    Account account = this.mAccount;
                    accountManagerService.removeAccount(account);
                }
                if ((iAccountManagerResponse = this.getResponseAndClose()) != null) {
                    Bundle bundle2 = new Bundle();
                    bundle2.putBoolean("booleanResult", bl);
                    try {
                        iAccountManagerResponse.onResult(bundle2);
                    }
                    catch (RemoteException remoteException) {}
                }
            }
            super.onResult(bundle);
        }

        @Override
        public void run() throws RemoteException {
            IAccountAuthenticator iAccountAuthenticator = this.mAuthenticator;
            Account account = this.mAccount;
            iAccountAuthenticator.getAccountRemovalAllowed(this, account);
        }

        @Override
        protected String toDebugString(long l) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = super.toDebugString(l);
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(", removeAccount").append(", account ");
            Account account = this.mAccount;
            return stringBuilder2.append(account).toString();
        }
    }

    private class TestFeaturesSession
    extends Session {
        private final Account mAccount;
        private final String[] mFeatures;

        public TestFeaturesSession(IAccountManagerResponse iAccountManagerResponse, Account account, String[] stringArray) {
            String string2 = account.type;
            TestFeaturesSession testFeaturesSession = this;
            AccountManagerService accountManagerService2 = AccountManagerService.this;
            IAccountManagerResponse iAccountManagerResponse2 = iAccountManagerResponse;
            super(iAccountManagerResponse2, string2, false, true);
            this.mFeatures = stringArray;
            this.mAccount = account;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void onResult(Bundle var1_1) {
            var2_2 = this.getResponseAndClose();
            if (var2_2 == null) {
                return;
            }
            if (var1_1 != null) ** GOTO lbl9
            var3_3 = 5;
            try {
                this.onError(var3_3, "null bundle");
                return;
lbl9:
                // 1 sources

                var4_4 = new Bundle();
                var5_5 = var1_1.getBoolean("booleanResult", false);
                var4_4.putBoolean("booleanResult", var5_5);
                var2_2.onResult(var4_4);
                return;
            }
            catch (RemoteException var6_6) {
                if (!Log.isLoggable("AccountManagerService", 2)) {
                    return;
                }
                var7_7 = Log.v("AccountManagerService", "failure while notifying response", var6_6);
                return;
            }
        }

        @Override
        public void run() throws RemoteException {
            try {
                IAccountAuthenticator iAccountAuthenticator = this.mAuthenticator;
                Account account = this.mAccount;
                String[] stringArray = this.mFeatures;
                iAccountAuthenticator.hasFeatures(this, account, stringArray);
                return;
            }
            catch (RemoteException remoteException) {
                this.onError(1, "remote exception");
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected String toDebugString(long l) {
            String string2;
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = super.toDebugString(l);
            StringBuilder stringBuilder2 = stringBuilder.append(string3).append(", hasFeatures").append(", ");
            Account account = this.mAccount;
            StringBuilder stringBuilder3 = stringBuilder2.append(account).append(", ");
            if (this.mFeatures != null) {
                Object[] objectArray = this.mFeatures;
                string2 = TextUtils.join((CharSequence)",", objectArray);
                return stringBuilder3.append(string2).toString();
            }
            string2 = null;
            return stringBuilder3.append(string2).toString();
        }
    }

    public class AuthTokenKey {
        public final Account mAccount;
        public final String mAuthTokenType;
        private final int mHashCode;

        public AuthTokenKey(Account account, String string2) {
            int n;
            this.mAccount = account;
            this.mAuthTokenType = string2;
            this.mHashCode = n = this.computeHashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int computeHashCode() {
            int n;
            int n2 = 17 * 31;
            int n3 = (this.mAccount.hashCode() + 527) * 31;
            if (this.mAuthTokenType == null) {
                n = 0;
                return n3 + n;
            }
            n = this.mAuthTokenType.hashCode();
            return n3 + n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof AuthTokenKey)) {
                return false;
            }
            AuthTokenKey authTokenKey = (AuthTokenKey)object;
            Account account = this.mAccount;
            Account account2 = authTokenKey.mAccount;
            if (!account.equals(account2)) {
                return false;
            }
            if (this.mAuthTokenType == null) {
                if (authTokenKey.mAuthTokenType != null) return false;
                return true;
            }
            String string2 = this.mAuthTokenType;
            String string3 = authTokenKey.mAuthTokenType;
            return string2.equals(string3);
        }

        public int hashCode() {
            return this.mHashCode;
        }
    }
}

