/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityManagerNative;
import android.app.IThumbnailReceiver;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.ConfigurationInfo;
import android.content.pm.IPackageDataObserver;
import android.graphics.Bitmap;
import android.os.Debug;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.text.TextUtils;
import java.util.List;

public class ActivityManager {
    private static boolean DEBUG = false;
    public static final int RECENT_IGNORE_UNAVAILABLE = 2;
    public static final int RECENT_WITH_EXCLUDED = 1;
    private static String TAG = "ActivityManager";
    private static boolean localLOGV;
    private final Context mContext;
    private final Handler mHandler;

    /*
     * Enabled aggressive block sorting
     */
    static {
        DEBUG = false;
        boolean bl = DEBUG;
        localLOGV = bl;
    }

    ActivityManager(Context context, Handler handler) {
        this.mContext = context;
        this.mHandler = handler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isUserAMonkey() {
        try {
            boolean bl = ActivityManagerNative.getDefault().isUserAMonkey();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public static int staticGetMemoryClass() {
        String string2 = SystemProperties.get("dalvik.vm.heapsize", "16m");
        int n = string2.length() - 1;
        return Integer.parseInt(string2.substring(0, n));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean clearApplicationUserData(String string2, IPackageDataObserver iPackageDataObserver) {
        try {
            boolean bl = ActivityManagerNative.getDefault().clearApplicationUserData(string2, iPackageDataObserver);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void forceStopPackage(String string2) {
        try {
            ActivityManagerNative.getDefault().forceStopPackage(string2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ConfigurationInfo getDeviceConfigurationInfo() {
        try {
            ConfigurationInfo configurationInfo = ActivityManagerNative.getDefault().getDeviceConfigurationInfo();
            return configurationInfo;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public int getMemoryClass() {
        return ActivityManager.staticGetMemoryClass();
    }

    public void getMemoryInfo(MemoryInfo memoryInfo) {
        try {
            ActivityManagerNative.getDefault().getMemoryInfo(memoryInfo);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Debug.MemoryInfo[] getProcessMemoryInfo(int[] nArray) {
        try {
            Debug.MemoryInfo[] memoryInfoArray = ActivityManagerNative.getDefault().getProcessMemoryInfo(nArray);
            return memoryInfoArray;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<ProcessErrorStateInfo> getProcessesInErrorState() {
        try {
            List<ProcessErrorStateInfo> list = ActivityManagerNative.getDefault().getProcessesInErrorState();
            return list;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<RecentTaskInfo> getRecentTasks(int n, int n2) throws SecurityException {
        try {
            List<RecentTaskInfo> list = ActivityManagerNative.getDefault().getRecentTasks(n, n2);
            return list;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<RunningAppProcessInfo> getRunningAppProcesses() {
        try {
            List<RunningAppProcessInfo> list = ActivityManagerNative.getDefault().getRunningAppProcesses();
            return list;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<ApplicationInfo> getRunningExternalApplications() {
        try {
            List<ApplicationInfo> list = ActivityManagerNative.getDefault().getRunningExternalApplications();
            return list;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PendingIntent getRunningServiceControlPanel(ComponentName componentName) throws SecurityException {
        try {
            PendingIntent pendingIntent = ActivityManagerNative.getDefault().getRunningServiceControlPanel(componentName);
            return pendingIntent;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<RunningServiceInfo> getRunningServices(int n) throws SecurityException {
        try {
            List list = ActivityManagerNative.getDefault().getServices(n, 0);
            return list;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public List<RunningTaskInfo> getRunningTasks(int n) throws SecurityException {
        return this.getRunningTasks(n, 0, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<RunningTaskInfo> getRunningTasks(int n, int n2, IThumbnailReceiver iThumbnailReceiver) throws SecurityException {
        try {
            List list = ActivityManagerNative.getDefault().getTasks(n, n2, iThumbnailReceiver);
            return list;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public void killBackgroundProcesses(String string2) {
        try {
            ActivityManagerNative.getDefault().killBackgroundProcesses(string2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Deprecated
    public void restartPackage(String string2) {
        this.killBackgroundProcesses(string2);
    }

    public static class RunningAppProcessInfo
    implements Parcelable {
        public static final Parcelable.Creator<RunningAppProcessInfo> CREATOR = new Parcelable.Creator<RunningAppProcessInfo>(){

            @Override
            public RunningAppProcessInfo createFromParcel(Parcel parcel) {
                return new RunningAppProcessInfo(parcel);
            }

            public RunningAppProcessInfo[] newArray(int n) {
                return new RunningAppProcessInfo[n];
            }
        };
        public static final int FLAG_CANT_SAVE_STATE = 1;
        public static final int FLAG_PERSISTENT = 2;
        public static final int IMPORTANCE_BACKGROUND = 400;
        public static final int IMPORTANCE_CANT_SAVE_STATE = 170;
        public static final int IMPORTANCE_EMPTY = 500;
        public static final int IMPORTANCE_FOREGROUND = 100;
        public static final int IMPORTANCE_PERCEPTIBLE = 130;
        public static final int IMPORTANCE_SERVICE = 300;
        public static final int IMPORTANCE_VISIBLE = 200;
        public static final int REASON_PROVIDER_IN_USE = 1;
        public static final int REASON_SERVICE_IN_USE = 2;
        public static final int REASON_UNKNOWN;
        public int flags;
        public int importance;
        public int importanceReasonCode;
        public ComponentName importanceReasonComponent;
        public int importanceReasonPid;
        public int lru;
        public int pid;
        public String[] pkgList;
        public String processName;
        public int uid;

        public RunningAppProcessInfo() {
            this.importance = 100;
            this.importanceReasonCode = 0;
        }

        private RunningAppProcessInfo(Parcel parcel) {
            this.readFromParcel(parcel);
        }

        public RunningAppProcessInfo(String string2, int n, String[] stringArray) {
            this.processName = string2;
            this.pid = n;
            this.pkgList = stringArray;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public void readFromParcel(Parcel parcel) {
            ComponentName componentName;
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            String string2;
            this.processName = string2 = parcel.readString();
            this.pid = n7 = parcel.readInt();
            this.uid = n6 = parcel.readInt();
            String[] stringArray = parcel.readStringArray();
            this.pkgList = stringArray;
            this.flags = n5 = parcel.readInt();
            this.importance = n4 = parcel.readInt();
            this.lru = n3 = parcel.readInt();
            this.importanceReasonCode = n2 = parcel.readInt();
            this.importanceReasonPid = n = parcel.readInt();
            this.importanceReasonComponent = componentName = ComponentName.readFromParcel(parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            String string2 = this.processName;
            parcel.writeString(string2);
            int n2 = this.pid;
            parcel.writeInt(n2);
            int n3 = this.uid;
            parcel.writeInt(n3);
            String[] stringArray = this.pkgList;
            parcel.writeStringArray(stringArray);
            int n4 = this.flags;
            parcel.writeInt(n4);
            int n5 = this.importance;
            parcel.writeInt(n5);
            int n6 = this.lru;
            parcel.writeInt(n6);
            int n7 = this.importanceReasonCode;
            parcel.writeInt(n7);
            int n8 = this.importanceReasonPid;
            parcel.writeInt(n8);
            ComponentName.writeToParcel(this.importanceReasonComponent, parcel);
        }
    }

    public static class ProcessErrorStateInfo
    implements Parcelable {
        public static final int CRASHED = 1;
        public static final Parcelable.Creator<ProcessErrorStateInfo> CREATOR = new Parcelable.Creator<ProcessErrorStateInfo>(){

            @Override
            public ProcessErrorStateInfo createFromParcel(Parcel parcel) {
                return new ProcessErrorStateInfo(parcel);
            }

            public ProcessErrorStateInfo[] newArray(int n) {
                return new ProcessErrorStateInfo[n];
            }
        };
        public static final int NOT_RESPONDING = 2;
        public static final int NO_ERROR;
        public int condition;
        public byte[] crashData = null;
        public String longMsg;
        public int pid;
        public String processName;
        public String shortMsg;
        public String stackTrace;
        public String tag;
        public int uid;

        public ProcessErrorStateInfo() {
        }

        private ProcessErrorStateInfo(Parcel parcel) {
            this.readFromParcel(parcel);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public void readFromParcel(Parcel parcel) {
            String string2;
            String string3;
            String string4;
            String string5;
            int n;
            int n2;
            String string6;
            int n3;
            this.condition = n3 = parcel.readInt();
            this.processName = string6 = parcel.readString();
            this.pid = n2 = parcel.readInt();
            this.uid = n = parcel.readInt();
            this.tag = string5 = parcel.readString();
            this.shortMsg = string4 = parcel.readString();
            this.longMsg = string3 = parcel.readString();
            this.stackTrace = string2 = parcel.readString();
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            int n2 = this.condition;
            parcel.writeInt(n2);
            String string2 = this.processName;
            parcel.writeString(string2);
            int n3 = this.pid;
            parcel.writeInt(n3);
            int n4 = this.uid;
            parcel.writeInt(n4);
            String string3 = this.tag;
            parcel.writeString(string3);
            String string4 = this.shortMsg;
            parcel.writeString(string4);
            String string5 = this.longMsg;
            parcel.writeString(string5);
            String string6 = this.stackTrace;
            parcel.writeString(string6);
        }
    }

    public static class MemoryInfo
    implements Parcelable {
        public static final Parcelable.Creator<MemoryInfo> CREATOR = new Parcelable.Creator<MemoryInfo>(){

            @Override
            public MemoryInfo createFromParcel(Parcel parcel) {
                return new MemoryInfo(parcel);
            }

            public MemoryInfo[] newArray(int n) {
                return new MemoryInfo[n];
            }
        };
        public long availMem;
        public boolean lowMemory;
        public long threshold;

        public MemoryInfo() {
        }

        private MemoryInfo(Parcel parcel) {
            this.readFromParcel(parcel);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void readFromParcel(Parcel parcel) {
            long l;
            long l2;
            this.availMem = l2 = parcel.readLong();
            this.threshold = l = parcel.readLong();
            boolean bl = parcel.readInt() != 0;
            this.lowMemory = bl;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            long l = this.availMem;
            parcel.writeLong(l);
            long l2 = this.threshold;
            parcel.writeLong(l2);
            int n2 = this.lowMemory ? 1 : 0;
            parcel.writeInt(n2);
        }
    }

    public static class RunningServiceInfo
    implements Parcelable {
        public static final Parcelable.Creator<RunningServiceInfo> CREATOR = new Parcelable.Creator<RunningServiceInfo>(){

            @Override
            public RunningServiceInfo createFromParcel(Parcel parcel) {
                return new RunningServiceInfo(parcel);
            }

            public RunningServiceInfo[] newArray(int n) {
                return new RunningServiceInfo[n];
            }
        };
        public static final int FLAG_FOREGROUND = 2;
        public static final int FLAG_PERSISTENT_PROCESS = 8;
        public static final int FLAG_STARTED = 1;
        public static final int FLAG_SYSTEM_PROCESS = 4;
        public long activeSince;
        public int clientCount;
        public int clientLabel;
        public String clientPackage;
        public int crashCount;
        public int flags;
        public boolean foreground;
        public long lastActivityTime;
        public int pid;
        public String process;
        public long restarting;
        public ComponentName service;
        public boolean started;
        public int uid;

        public RunningServiceInfo() {
        }

        private RunningServiceInfo(Parcel parcel) {
            this.readFromParcel(parcel);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void readFromParcel(Parcel parcel) {
            int n;
            String string2;
            int n2;
            long l;
            long l2;
            int n3;
            int n4;
            long l3;
            String string3;
            int n5;
            int n6;
            ComponentName componentName;
            this.service = componentName = ComponentName.readFromParcel(parcel);
            this.pid = n6 = parcel.readInt();
            this.uid = n5 = parcel.readInt();
            this.process = string3 = parcel.readString();
            boolean bl = parcel.readInt() != 0;
            this.foreground = bl;
            this.activeSince = l3 = parcel.readLong();
            boolean bl2 = parcel.readInt() != 0;
            this.started = bl2;
            this.clientCount = n4 = parcel.readInt();
            this.crashCount = n3 = parcel.readInt();
            this.lastActivityTime = l2 = parcel.readLong();
            this.restarting = l = parcel.readLong();
            this.flags = n2 = parcel.readInt();
            this.clientPackage = string2 = parcel.readString();
            this.clientLabel = n = parcel.readInt();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            ComponentName.writeToParcel(this.service, parcel);
            int n2 = this.pid;
            parcel.writeInt(n2);
            int n3 = this.uid;
            parcel.writeInt(n3);
            String string2 = this.process;
            parcel.writeString(string2);
            int n4 = this.foreground ? 1 : 0;
            parcel.writeInt(n4);
            long l = this.activeSince;
            parcel.writeLong(l);
            int n5 = this.started ? 1 : 0;
            parcel.writeInt(n5);
            int n6 = this.clientCount;
            parcel.writeInt(n6);
            int n7 = this.crashCount;
            parcel.writeInt(n7);
            long l2 = this.lastActivityTime;
            parcel.writeLong(l2);
            long l3 = this.restarting;
            parcel.writeLong(l3);
            int n8 = this.flags;
            parcel.writeInt(n8);
            String string3 = this.clientPackage;
            parcel.writeString(string3);
            int n9 = this.clientLabel;
            parcel.writeInt(n9);
        }
    }

    public static class RunningTaskInfo
    implements Parcelable {
        public static final Parcelable.Creator<RunningTaskInfo> CREATOR = new Parcelable.Creator<RunningTaskInfo>(){

            @Override
            public RunningTaskInfo createFromParcel(Parcel parcel) {
                return new RunningTaskInfo(parcel);
            }

            public RunningTaskInfo[] newArray(int n) {
                return new RunningTaskInfo[n];
            }
        };
        public ComponentName baseActivity;
        public CharSequence description;
        public int id;
        public int numActivities;
        public int numRunning;
        public Bitmap thumbnail;
        public ComponentName topActivity;

        public RunningTaskInfo() {
        }

        private RunningTaskInfo(Parcel parcel) {
            this.readFromParcel(parcel);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void readFromParcel(Parcel parcel) {
            int n;
            int n2;
            CharSequence charSequence;
            Bitmap bitmap;
            ComponentName componentName;
            ComponentName componentName2;
            int n3;
            this.id = n3 = parcel.readInt();
            this.baseActivity = componentName2 = ComponentName.readFromParcel(parcel);
            this.topActivity = componentName = ComponentName.readFromParcel(parcel);
            this.thumbnail = parcel.readInt() != 0 ? (bitmap = Bitmap.CREATOR.createFromParcel(parcel)) : null;
            this.description = charSequence = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
            this.numActivities = n2 = parcel.readInt();
            this.numRunning = n = parcel.readInt();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            int n2 = this.id;
            parcel.writeInt(n2);
            ComponentName.writeToParcel(this.baseActivity, parcel);
            ComponentName.writeToParcel(this.topActivity, parcel);
            if (this.thumbnail != null) {
                parcel.writeInt(1);
                this.thumbnail.writeToParcel(parcel, 0);
            } else {
                parcel.writeInt(0);
            }
            TextUtils.writeToParcel(this.description, parcel, 1);
            int n3 = this.numActivities;
            parcel.writeInt(n3);
            int n4 = this.numRunning;
            parcel.writeInt(n4);
        }
    }

    public static class RecentTaskInfo
    implements Parcelable {
        public static final Parcelable.Creator<RecentTaskInfo> CREATOR = new Parcelable.Creator<RecentTaskInfo>(){

            @Override
            public RecentTaskInfo createFromParcel(Parcel parcel) {
                return new RecentTaskInfo(parcel);
            }

            public RecentTaskInfo[] newArray(int n) {
                return new RecentTaskInfo[n];
            }
        };
        public Intent baseIntent;
        public int id;
        public ComponentName origActivity;

        public RecentTaskInfo() {
        }

        private RecentTaskInfo(Parcel parcel) {
            this.readFromParcel(parcel);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void readFromParcel(Parcel parcel) {
            ComponentName componentName;
            Intent intent;
            int n;
            this.id = n = parcel.readInt();
            this.baseIntent = parcel.readInt() != 0 ? (intent = Intent.CREATOR.createFromParcel(parcel)) : null;
            this.origActivity = componentName = ComponentName.readFromParcel(parcel);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            int n2 = this.id;
            parcel.writeInt(n2);
            if (this.baseIntent != null) {
                parcel.writeInt(1);
                this.baseIntent.writeToParcel(parcel, 0);
            } else {
                parcel.writeInt(0);
            }
            ComponentName.writeToParcel(this.origActivity, parcel);
        }
    }
}

