/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityManager;
import android.app.ActivityManagerProxy;
import android.app.ApplicationErrorReport;
import android.app.ApplicationThreadNative;
import android.app.IActivityController;
import android.app.IActivityManager;
import android.app.IActivityWatcher;
import android.app.IApplicationThread;
import android.app.IInstrumentationWatcher;
import android.app.IServiceConnection;
import android.app.IThumbnailReceiver;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.IIntentReceiver;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ApplicationInfo;
import android.content.pm.ConfigurationInfo;
import android.content.pm.IPackageDataObserver;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class ActivityManagerNative
extends Binder
implements IActivityManager {
    private static IActivityManager gDefault;
    static boolean sSystemReady;

    static {
        sSystemReady = false;
    }

    public ActivityManagerNative() {
        this.attachInterface(this, "android.app.IActivityManager");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IActivityManager asInterface(IBinder iBinder) {
        if (iBinder == null) {
            return null;
        }
        IActivityManager iActivityManager = (IActivityManager)iBinder.queryLocalInterface("android.app.IActivityManager");
        if (iActivityManager == null) return new ActivityManagerProxy(iBinder);
        return iActivityManager;
    }

    public static void broadcastStickyIntent(Intent intent, String string2) {
        try {
            IActivityManager iActivityManager = ActivityManagerNative.getDefault();
            Intent intent2 = intent;
            int n = iActivityManager.broadcastIntent(null, intent2, null, null, -1, null, null, null, false, true);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IActivityManager getDefault() {
        if (gDefault == null) return gDefault = ActivityManagerNative.asInterface(ServiceManager.getService("activity"));
        return gDefault;
    }

    public static boolean isSystemReady() {
        if (!sSystemReady) {
            sSystemReady = ActivityManagerNative.getDefault().testIsSystemReady();
        }
        return sSystemReady;
    }

    public static void noteWakeupAlarm(PendingIntent pendingIntent) {
        try {
            IActivityManager iActivityManager = ActivityManagerNative.getDefault();
            IIntentSender iIntentSender = pendingIntent.getTarget();
            iActivityManager.noteWakeupAlarm(iIntentSender);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public IBinder asBinder() {
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
        switch (n) {
            default: {
                return super.onTransact(n, parcel, parcel2, n2);
            }
            case 3: {
                Parcel parcel3 = parcel;
                String string2 = "android.app.IActivityManager";
                parcel3.enforceInterface(string2);
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                Parcelable.Creator<Intent> creator = Intent.CREATOR;
                Parcel parcel4 = parcel;
                Intent intent = creator.createFromParcel(parcel4);
                String string3 = parcel.readString();
                Parcelable.Creator<Uri> creator2 = Uri.CREATOR;
                Parcel parcel5 = parcel;
                Parcelable.Creator<Uri> creator3 = creator2;
                Uri[] uriArray = parcel5.createTypedArray(creator3);
                int n3 = parcel.readInt();
                IBinder iBinder = parcel.readStrongBinder();
                String string4 = parcel.readString();
                int n4 = parcel.readInt();
                boolean bl = parcel.readInt() != 0;
                boolean bl2 = parcel.readInt() != 0;
                int n5 = this.startActivity(iApplicationThread, intent, string3, uriArray, n3, iBinder, string4, n4, bl, bl2);
                parcel2.writeNoException();
                Parcel parcel6 = parcel2;
                int n6 = n5;
                parcel6.writeInt(n6);
                return true;
            }
            case 105: {
                Parcel parcel7 = parcel;
                String string5 = "android.app.IActivityManager";
                parcel7.enforceInterface(string5);
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                Parcelable.Creator<Intent> creator = Intent.CREATOR;
                Parcel parcel8 = parcel;
                Intent intent = creator.createFromParcel(parcel8);
                String string6 = parcel.readString();
                Parcelable.Creator<Uri> creator4 = Uri.CREATOR;
                Parcel parcel9 = parcel;
                Parcelable.Creator<Uri> creator5 = creator4;
                Uri[] uriArray = parcel9.createTypedArray(creator5);
                int n7 = parcel.readInt();
                IBinder iBinder = parcel.readStrongBinder();
                String string7 = parcel.readString();
                int n8 = parcel.readInt();
                boolean bl = parcel.readInt() != 0;
                boolean bl3 = parcel.readInt() != 0;
                IActivityManager.WaitResult waitResult = this.startActivityAndWait(iApplicationThread, intent, string6, uriArray, n7, iBinder, string7, n8, bl, bl3);
                parcel2.writeNoException();
                IActivityManager.WaitResult waitResult2 = waitResult;
                Parcel parcel10 = parcel2;
                int n9 = 0;
                waitResult2.writeToParcel(parcel10, n9);
                return true;
            }
            case 107: {
                Parcel parcel11 = parcel;
                String string8 = "android.app.IActivityManager";
                parcel11.enforceInterface(string8);
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                Parcelable.Creator<Intent> creator = Intent.CREATOR;
                Parcel parcel12 = parcel;
                Intent intent = creator.createFromParcel(parcel12);
                String string9 = parcel.readString();
                Parcelable.Creator<Uri> creator6 = Uri.CREATOR;
                Parcel parcel13 = parcel;
                Parcelable.Creator<Uri> creator7 = creator6;
                Uri[] uriArray = parcel13.createTypedArray(creator7);
                int n10 = parcel.readInt();
                IBinder iBinder = parcel.readStrongBinder();
                String string10 = parcel.readString();
                int n11 = parcel.readInt();
                boolean bl = parcel.readInt() != 0;
                boolean bl4 = parcel.readInt() != 0;
                Parcelable.Creator<Configuration> creator8 = Configuration.CREATOR;
                Parcel parcel14 = parcel;
                Configuration configuration = creator8.createFromParcel(parcel14);
                int n12 = this.startActivityWithConfig(iApplicationThread, intent, string9, uriArray, n10, iBinder, string10, n11, bl, bl4, configuration);
                parcel2.writeNoException();
                Parcel parcel15 = parcel2;
                int n13 = n12;
                parcel15.writeInt(n13);
                return true;
            }
            case 100: {
                Parcel parcel16 = parcel;
                String string11 = "android.app.IActivityManager";
                parcel16.enforceInterface(string11);
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                Parcelable.Creator<IntentSender> creator = IntentSender.CREATOR;
                Parcel parcel17 = parcel;
                IntentSender intentSender = creator.createFromParcel(parcel17);
                Intent intent = null;
                if (parcel.readInt() != 0) {
                    Parcelable.Creator<Intent> creator9 = Intent.CREATOR;
                    Parcel parcel18 = parcel;
                    intent = creator9.createFromParcel(parcel18);
                }
                String string12 = parcel.readString();
                IBinder iBinder = parcel.readStrongBinder();
                String string13 = parcel.readString();
                int n14 = parcel.readInt();
                int n15 = parcel.readInt();
                int n16 = parcel.readInt();
                ActivityManagerNative activityManagerNative = this;
                IApplicationThread iApplicationThread2 = iApplicationThread;
                IntentSender intentSender2 = intentSender;
                String string14 = string12;
                IBinder iBinder2 = iBinder;
                String string15 = string13;
                int n17 = n14;
                int n18 = activityManagerNative.startActivityIntentSender(iApplicationThread2, intentSender2, intent, string14, iBinder2, string15, n17, n15, n16);
                parcel2.writeNoException();
                Parcel parcel19 = parcel2;
                int n19 = n18;
                parcel19.writeInt(n19);
                return true;
            }
            case 67: {
                Parcel parcel20 = parcel;
                String string16 = "android.app.IActivityManager";
                parcel20.enforceInterface(string16);
                IBinder iBinder = parcel.readStrongBinder();
                Parcelable.Creator<Intent> creator = Intent.CREATOR;
                Parcel parcel21 = parcel;
                Intent intent = creator.createFromParcel(parcel21);
                ActivityManagerNative activityManagerNative = this;
                IBinder iBinder3 = iBinder;
                Intent intent2 = intent;
                boolean bl = activityManagerNative.startNextMatchingActivity(iBinder3, intent2);
                parcel2.writeNoException();
                int n20 = bl ? 1 : 0;
                Parcel parcel22 = parcel2;
                int n21 = n20;
                parcel22.writeInt(n21);
                return true;
            }
            case 11: {
                Parcel parcel23 = parcel;
                String string17 = "android.app.IActivityManager";
                parcel23.enforceInterface(string17);
                IBinder iBinder = parcel.readStrongBinder();
                Intent intent = null;
                int n22 = parcel.readInt();
                if (parcel.readInt() != 0) {
                    Parcelable.Creator<Intent> creator = Intent.CREATOR;
                    Parcel parcel24 = parcel;
                    Intent intent3 = creator.createFromParcel(parcel24);
                }
                ActivityManagerNative activityManagerNative = this;
                IBinder iBinder4 = iBinder;
                int n23 = n22;
                Intent intent4 = intent;
                boolean bl = activityManagerNative.finishActivity(iBinder4, n23, intent4);
                parcel2.writeNoException();
                int n24 = bl ? 1 : 0;
                Parcel parcel25 = parcel2;
                int n25 = n24;
                parcel25.writeInt(n25);
                return true;
            }
            case 32: {
                Parcel parcel26 = parcel;
                String string18 = "android.app.IActivityManager";
                parcel26.enforceInterface(string18);
                IBinder iBinder = parcel.readStrongBinder();
                String string19 = parcel.readString();
                int n26 = parcel.readInt();
                ActivityManagerNative activityManagerNative = this;
                IBinder iBinder5 = iBinder;
                String string20 = string19;
                int n27 = n26;
                activityManagerNative.finishSubActivity(iBinder5, string20, n27);
                parcel2.writeNoException();
                return true;
            }
            case 106: {
                Parcel parcel27 = parcel;
                String string21 = "android.app.IActivityManager";
                parcel27.enforceInterface(string21);
                IBinder iBinder = parcel.readStrongBinder();
                ActivityManagerNative activityManagerNative = this;
                IBinder iBinder6 = iBinder;
                boolean bl = activityManagerNative.willActivityBeVisible(iBinder6);
                parcel2.writeNoException();
                int n28 = bl ? 1 : 0;
                Parcel parcel28 = parcel2;
                int n29 = n28;
                parcel28.writeInt(n29);
                return true;
            }
            case 12: {
                Parcel parcel29 = parcel;
                String string22 = "android.app.IActivityManager";
                parcel29.enforceInterface(string22);
                IBinder iBinder = parcel.readStrongBinder();
                IApplicationThread iApplicationThread = iBinder != null ? ApplicationThreadNative.asInterface(iBinder) : null;
                IBinder iBinder7 = parcel.readStrongBinder();
                IIntentReceiver iIntentReceiver = iBinder7 != null ? IIntentReceiver.Stub.asInterface(iBinder7) : null;
                Parcelable.Creator<IntentFilter> creator = IntentFilter.CREATOR;
                Parcel parcel30 = parcel;
                IntentFilter intentFilter = creator.createFromParcel(parcel30);
                String string23 = parcel.readString();
                ActivityManagerNative activityManagerNative = this;
                IApplicationThread iApplicationThread3 = iApplicationThread;
                IIntentReceiver iIntentReceiver2 = iIntentReceiver;
                IntentFilter intentFilter2 = intentFilter;
                String string24 = string23;
                Intent intent = activityManagerNative.registerReceiver(iApplicationThread3, iIntentReceiver2, intentFilter2, string24);
                parcel2.writeNoException();
                if (intent != null) {
                    Parcel parcel31 = parcel2;
                    int n30 = 1;
                    parcel31.writeInt(n30);
                    Intent intent5 = intent;
                    Parcel parcel32 = parcel2;
                    int n31 = 0;
                    intent5.writeToParcel(parcel32, n31);
                    return true;
                } else {
                    Parcel parcel33 = parcel2;
                    int n32 = 0;
                    parcel33.writeInt(n32);
                }
                return true;
            }
            case 13: {
                Parcel parcel34 = parcel;
                String string25 = "android.app.IActivityManager";
                parcel34.enforceInterface(string25);
                IBinder iBinder = parcel.readStrongBinder();
                if (iBinder == null) {
                    return true;
                }
                IIntentReceiver iIntentReceiver = IIntentReceiver.Stub.asInterface(iBinder);
                ActivityManagerNative activityManagerNative = this;
                IIntentReceiver iIntentReceiver3 = iIntentReceiver;
                activityManagerNative.unregisterReceiver(iIntentReceiver3);
                parcel2.writeNoException();
                return true;
            }
            case 14: {
                Parcel parcel35 = parcel;
                String string26 = "android.app.IActivityManager";
                parcel35.enforceInterface(string26);
                IBinder iBinder = parcel.readStrongBinder();
                IApplicationThread iApplicationThread = iBinder != null ? ApplicationThreadNative.asInterface(iBinder) : null;
                Parcelable.Creator<Intent> creator = Intent.CREATOR;
                Parcel parcel36 = parcel;
                Intent intent = creator.createFromParcel(parcel36);
                String string27 = parcel.readString();
                IBinder iBinder8 = parcel.readStrongBinder();
                IIntentReceiver iIntentReceiver = iBinder8 != null ? IIntentReceiver.Stub.asInterface(iBinder8) : null;
                int n33 = parcel.readInt();
                String string28 = parcel.readString();
                Bundle bundle = parcel.readBundle();
                String string29 = parcel.readString();
                boolean bl = parcel.readInt() != 0;
                boolean bl5 = parcel.readInt() != 0;
                ActivityManagerNative activityManagerNative = this;
                IApplicationThread iApplicationThread4 = iApplicationThread;
                Intent intent6 = intent;
                String string30 = string27;
                IIntentReceiver iIntentReceiver4 = iIntentReceiver;
                int n34 = activityManagerNative.broadcastIntent(iApplicationThread4, intent6, string30, iIntentReceiver4, n33, string28, bundle, string29, bl, bl5);
                parcel2.writeNoException();
                Parcel parcel37 = parcel2;
                int n35 = n34;
                parcel37.writeInt(n35);
                return true;
            }
            case 15: {
                Parcel parcel38 = parcel;
                String string31 = "android.app.IActivityManager";
                parcel38.enforceInterface(string31);
                IBinder iBinder = parcel.readStrongBinder();
                IApplicationThread iApplicationThread = iBinder != null ? ApplicationThreadNative.asInterface(iBinder) : null;
                Parcelable.Creator<Intent> creator = Intent.CREATOR;
                Parcel parcel39 = parcel;
                Intent intent = creator.createFromParcel(parcel39);
                ActivityManagerNative activityManagerNative = this;
                IApplicationThread iApplicationThread5 = iApplicationThread;
                Intent intent7 = intent;
                activityManagerNative.unbroadcastIntent(iApplicationThread5, intent7);
                parcel2.writeNoException();
                return true;
            }
            case 16: {
                Parcel parcel40 = parcel;
                String string32 = "android.app.IActivityManager";
                parcel40.enforceInterface(string32);
                IBinder iBinder = parcel.readStrongBinder();
                int n36 = parcel.readInt();
                String string33 = parcel.readString();
                Bundle bundle = parcel.readBundle();
                boolean bl = parcel.readInt() != 0;
                if (iBinder != null) {
                    ActivityManagerNative activityManagerNative = this;
                    int n37 = n36;
                    String string34 = string33;
                    Bundle bundle2 = bundle;
                    activityManagerNative.finishReceiver(iBinder, n37, string34, bundle2, bl);
                }
                parcel2.writeNoException();
                return true;
            }
            case 17: {
                Parcel parcel41 = parcel;
                String string35 = "android.app.IActivityManager";
                parcel41.enforceInterface(string35);
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                if (iApplicationThread != null) {
                    ActivityManagerNative activityManagerNative = this;
                    IApplicationThread iApplicationThread6 = iApplicationThread;
                    activityManagerNative.attachApplication(iApplicationThread6);
                }
                parcel2.writeNoException();
                return true;
            }
            case 18: {
                Parcel parcel42 = parcel;
                String string36 = "android.app.IActivityManager";
                parcel42.enforceInterface(string36);
                IBinder iBinder = parcel.readStrongBinder();
                Configuration configuration = null;
                if (parcel.readInt() != 0) {
                    Parcelable.Creator<Configuration> creator = Configuration.CREATOR;
                    Parcel parcel43 = parcel;
                    Configuration configuration2 = creator.createFromParcel(parcel43);
                }
                if (iBinder != null) {
                    ActivityManagerNative activityManagerNative = this;
                    IBinder iBinder9 = iBinder;
                    Configuration configuration3 = configuration;
                    activityManagerNative.activityIdle(iBinder9, configuration3);
                }
                parcel2.writeNoException();
                return true;
            }
            case 19: {
                Parcel parcel44 = parcel;
                String string37 = "android.app.IActivityManager";
                parcel44.enforceInterface(string37);
                IBinder iBinder = parcel.readStrongBinder();
                Bundle bundle = parcel.readBundle();
                ActivityManagerNative activityManagerNative = this;
                IBinder iBinder10 = iBinder;
                Bundle bundle3 = bundle;
                activityManagerNative.activityPaused(iBinder10, bundle3);
                parcel2.writeNoException();
                return true;
            }
            case 20: {
                Bitmap bitmap;
                Parcel parcel45 = parcel;
                String string38 = "android.app.IActivityManager";
                parcel45.enforceInterface(string38);
                IBinder iBinder = parcel.readStrongBinder();
                if (parcel.readInt() != 0) {
                    Parcelable.Creator<Bitmap> creator = Bitmap.CREATOR;
                    Parcel parcel46 = parcel;
                    bitmap = creator.createFromParcel(parcel46);
                } else {
                    bitmap = null;
                }
                Parcelable.Creator<CharSequence> creator = TextUtils.CHAR_SEQUENCE_CREATOR;
                Parcel parcel47 = parcel;
                CharSequence charSequence = creator.createFromParcel(parcel47);
                ActivityManagerNative activityManagerNative = this;
                IBinder iBinder11 = iBinder;
                Bitmap bitmap2 = bitmap;
                CharSequence charSequence2 = charSequence;
                activityManagerNative.activityStopped(iBinder11, bitmap2, charSequence2);
                parcel2.writeNoException();
                return true;
            }
            case 62: {
                Parcel parcel48 = parcel;
                String string39 = "android.app.IActivityManager";
                parcel48.enforceInterface(string39);
                IBinder iBinder = parcel.readStrongBinder();
                ActivityManagerNative activityManagerNative = this;
                IBinder iBinder12 = iBinder;
                activityManagerNative.activityDestroyed(iBinder12);
                parcel2.writeNoException();
                return true;
            }
            case 21: {
                String string40;
                Parcel parcel49 = parcel;
                String string41 = "android.app.IActivityManager";
                parcel49.enforceInterface(string41);
                IBinder iBinder = parcel.readStrongBinder();
                if (iBinder != null) {
                    ActivityManagerNative activityManagerNative = this;
                    IBinder iBinder13 = iBinder;
                    string40 = activityManagerNative.getCallingPackage(iBinder13);
                } else {
                    string40 = null;
                }
                parcel2.writeNoException();
                Parcel parcel50 = parcel2;
                String string42 = string40;
                parcel50.writeString(string42);
                return true;
            }
            case 22: {
                Parcel parcel51 = parcel;
                String string43 = "android.app.IActivityManager";
                parcel51.enforceInterface(string43);
                IBinder iBinder = parcel.readStrongBinder();
                ActivityManagerNative activityManagerNative = this;
                IBinder iBinder14 = iBinder;
                ComponentName componentName = activityManagerNative.getCallingActivity(iBinder14);
                parcel2.writeNoException();
                ComponentName componentName2 = componentName;
                Parcel parcel52 = parcel2;
                ComponentName.writeToParcel(componentName2, parcel52);
                return true;
            }
            case 23: {
                Parcel parcel53 = parcel;
                String string44 = "android.app.IActivityManager";
                parcel53.enforceInterface(string44);
                int n38 = parcel.readInt();
                int n39 = parcel.readInt();
                IBinder iBinder = parcel.readStrongBinder();
                IThumbnailReceiver iThumbnailReceiver = iBinder != null ? IThumbnailReceiver.Stub.asInterface(iBinder) : null;
                ActivityManagerNative activityManagerNative = this;
                int n40 = n38;
                int n41 = n39;
                IThumbnailReceiver iThumbnailReceiver2 = iThumbnailReceiver;
                List list = activityManagerNative.getTasks(n40, n41, iThumbnailReceiver2);
                parcel2.writeNoException();
                int n42 = list != null ? list.size() : -1;
                Parcel parcel54 = parcel2;
                int n43 = n42;
                parcel54.writeInt(n43);
                int n44 = 0;
                while (true) {
                    int n45;
                    int n46;
                    if ((n46 = n44) >= (n45 = n42)) {
                        return true;
                    }
                    List list2 = list;
                    int n47 = n44;
                    ActivityManager.RunningTaskInfo runningTaskInfo = (ActivityManager.RunningTaskInfo)list2.get(n47);
                    Parcel parcel55 = parcel2;
                    int n48 = 0;
                    runningTaskInfo.writeToParcel(parcel55, n48);
                    int n49 = n44 + 1;
                }
            }
            case 60: {
                Parcel parcel56 = parcel;
                String string45 = "android.app.IActivityManager";
                parcel56.enforceInterface(string45);
                int n50 = parcel.readInt();
                int n51 = parcel.readInt();
                ActivityManagerNative activityManagerNative = this;
                int n52 = n50;
                int n53 = n51;
                List<ActivityManager.RecentTaskInfo> list = activityManagerNative.getRecentTasks(n52, n53);
                parcel2.writeNoException();
                Parcel parcel57 = parcel2;
                List<ActivityManager.RecentTaskInfo> list3 = list;
                parcel57.writeTypedList(list3);
                return true;
            }
            case 81: {
                Parcel parcel58 = parcel;
                String string46 = "android.app.IActivityManager";
                parcel58.enforceInterface(string46);
                int n54 = parcel.readInt();
                int n55 = parcel.readInt();
                ActivityManagerNative activityManagerNative = this;
                int n56 = n54;
                int n57 = n55;
                List list = activityManagerNative.getServices(n56, n57);
                parcel2.writeNoException();
                int n58 = list != null ? list.size() : -1;
                Parcel parcel59 = parcel2;
                int n59 = n58;
                parcel59.writeInt(n59);
                int n60 = 0;
                while (true) {
                    int n61;
                    int n62;
                    if ((n62 = n60) >= (n61 = n58)) {
                        return true;
                    }
                    List list4 = list;
                    int n63 = n60++;
                    ActivityManager.RunningServiceInfo runningServiceInfo = (ActivityManager.RunningServiceInfo)list4.get(n63);
                    Parcel parcel60 = parcel2;
                    int n64 = 0;
                    runningServiceInfo.writeToParcel(parcel60, n64);
                }
            }
            case 77: {
                Parcel parcel61 = parcel;
                String string47 = "android.app.IActivityManager";
                parcel61.enforceInterface(string47);
                List<ActivityManager.ProcessErrorStateInfo> list = this.getProcessesInErrorState();
                parcel2.writeNoException();
                Parcel parcel62 = parcel2;
                List<ActivityManager.ProcessErrorStateInfo> list5 = list;
                parcel62.writeTypedList(list5);
                return true;
            }
            case 83: {
                Parcel parcel63 = parcel;
                String string48 = "android.app.IActivityManager";
                parcel63.enforceInterface(string48);
                List<ActivityManager.RunningAppProcessInfo> list = this.getRunningAppProcesses();
                parcel2.writeNoException();
                Parcel parcel64 = parcel2;
                List<ActivityManager.RunningAppProcessInfo> list6 = list;
                parcel64.writeTypedList(list6);
                return true;
            }
            case 108: {
                Parcel parcel65 = parcel;
                String string49 = "android.app.IActivityManager";
                parcel65.enforceInterface(string49);
                List<ApplicationInfo> list = this.getRunningExternalApplications();
                parcel2.writeNoException();
                Parcel parcel66 = parcel2;
                List<ApplicationInfo> list7 = list;
                parcel66.writeTypedList(list7);
                return true;
            }
            case 24: {
                Parcel parcel67 = parcel;
                String string50 = "android.app.IActivityManager";
                parcel67.enforceInterface(string50);
                int n65 = parcel.readInt();
                ActivityManagerNative activityManagerNative = this;
                int n66 = n65;
                activityManagerNative.moveTaskToFront(n66);
                parcel2.writeNoException();
                return true;
            }
            case 25: {
                Parcel parcel68 = parcel;
                String string51 = "android.app.IActivityManager";
                parcel68.enforceInterface(string51);
                int n67 = parcel.readInt();
                ActivityManagerNative activityManagerNative = this;
                int n68 = n67;
                activityManagerNative.moveTaskToBack(n68);
                parcel2.writeNoException();
                return true;
            }
            case 75: {
                Parcel parcel69 = parcel;
                String string52 = "android.app.IActivityManager";
                parcel69.enforceInterface(string52);
                IBinder iBinder = parcel.readStrongBinder();
                boolean bl = parcel.readInt() != 0;
                ActivityManagerNative activityManagerNative = this;
                IBinder iBinder15 = iBinder;
                boolean bl6 = bl;
                boolean bl7 = activityManagerNative.moveActivityTaskToBack(iBinder15, bl6);
                parcel2.writeNoException();
                int n69 = bl7 ? 1 : 0;
                Parcel parcel70 = parcel2;
                int n70 = n69;
                parcel70.writeInt(n70);
                return true;
            }
            case 26: {
                Parcel parcel71 = parcel;
                String string53 = "android.app.IActivityManager";
                parcel71.enforceInterface(string53);
                int n71 = parcel.readInt();
                ActivityManagerNative activityManagerNative = this;
                int n72 = n71;
                activityManagerNative.moveTaskBackwards(n72);
                parcel2.writeNoException();
                return true;
            }
            case 27: {
                int n73;
                Parcel parcel72 = parcel;
                String string54 = "android.app.IActivityManager";
                parcel72.enforceInterface(string54);
                IBinder iBinder = parcel.readStrongBinder();
                boolean bl = parcel.readInt() != 0;
                if (iBinder != null) {
                    ActivityManagerNative activityManagerNative = this;
                    IBinder iBinder16 = iBinder;
                    boolean bl8 = bl;
                    n73 = activityManagerNative.getTaskForActivity(iBinder16, bl8);
                } else {
                    n73 = -1;
                }
                parcel2.writeNoException();
                Parcel parcel73 = parcel2;
                int n74 = n73;
                parcel73.writeInt(n74);
                return true;
            }
            case 39: {
                Parcel parcel74 = parcel;
                String string55 = "android.app.IActivityManager";
                parcel74.enforceInterface(string55);
                IBinder iBinder = parcel.readStrongBinder();
                ComponentName componentName = ComponentName.readFromParcel(parcel);
                ActivityManagerNative activityManagerNative = this;
                IBinder iBinder17 = iBinder;
                ComponentName componentName3 = componentName;
                activityManagerNative.finishOtherInstances(iBinder17, componentName3);
                parcel2.writeNoException();
                return true;
            }
            case 28: {
                Bitmap bitmap;
                Parcel parcel75 = parcel;
                String string56 = "android.app.IActivityManager";
                parcel75.enforceInterface(string56);
                IBinder iBinder = parcel.readStrongBinder();
                if (parcel.readInt() != 0) {
                    Parcelable.Creator<Bitmap> creator = Bitmap.CREATOR;
                    Parcel parcel76 = parcel;
                    bitmap = creator.createFromParcel(parcel76);
                } else {
                    bitmap = null;
                }
                Parcelable.Creator<CharSequence> creator = TextUtils.CHAR_SEQUENCE_CREATOR;
                Parcel parcel77 = parcel;
                CharSequence charSequence = creator.createFromParcel(parcel77);
                ActivityManagerNative activityManagerNative = this;
                IBinder iBinder18 = iBinder;
                Bitmap bitmap3 = bitmap;
                CharSequence charSequence3 = charSequence;
                activityManagerNative.reportThumbnail(iBinder18, bitmap3, charSequence3);
                parcel2.writeNoException();
                return true;
            }
            case 29: {
                Parcel parcel78 = parcel;
                String string57 = "android.app.IActivityManager";
                parcel78.enforceInterface(string57);
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                String string58 = parcel.readString();
                ActivityManagerNative activityManagerNative = this;
                IApplicationThread iApplicationThread7 = iApplicationThread;
                String string59 = string58;
                IActivityManager.ContentProviderHolder contentProviderHolder = activityManagerNative.getContentProvider(iApplicationThread7, string59);
                parcel2.writeNoException();
                if (contentProviderHolder != null) {
                    Parcel parcel79 = parcel2;
                    int n75 = 1;
                    parcel79.writeInt(n75);
                    IActivityManager.ContentProviderHolder contentProviderHolder2 = contentProviderHolder;
                    Parcel parcel80 = parcel2;
                    int n76 = 0;
                    contentProviderHolder2.writeToParcel(parcel80, n76);
                    return true;
                } else {
                    Parcel parcel81 = parcel2;
                    int n77 = 0;
                    parcel81.writeInt(n77);
                }
                return true;
            }
            case 30: {
                Parcel parcel82 = parcel;
                String string60 = "android.app.IActivityManager";
                parcel82.enforceInterface(string60);
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                Parcelable.Creator<IActivityManager.ContentProviderHolder> creator = IActivityManager.ContentProviderHolder.CREATOR;
                Parcel parcel83 = parcel;
                Parcelable.Creator<IActivityManager.ContentProviderHolder> creator10 = creator;
                ArrayList<IActivityManager.ContentProviderHolder> arrayList = parcel83.createTypedArrayList(creator10);
                ActivityManagerNative activityManagerNative = this;
                IApplicationThread iApplicationThread8 = iApplicationThread;
                ArrayList<IActivityManager.ContentProviderHolder> arrayList2 = arrayList;
                activityManagerNative.publishContentProviders(iApplicationThread8, arrayList2);
                parcel2.writeNoException();
                return true;
            }
            case 69: {
                Parcel parcel84 = parcel;
                String string61 = "android.app.IActivityManager";
                parcel84.enforceInterface(string61);
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                String string62 = parcel.readString();
                ActivityManagerNative activityManagerNative = this;
                IApplicationThread iApplicationThread9 = iApplicationThread;
                String string63 = string62;
                activityManagerNative.removeContentProvider(iApplicationThread9, string63);
                parcel2.writeNoException();
                return true;
            }
            case 33: {
                Parcel parcel85 = parcel;
                String string64 = "android.app.IActivityManager";
                parcel85.enforceInterface(string64);
                Parcelable.Creator<ComponentName> creator = ComponentName.CREATOR;
                Parcel parcel86 = parcel;
                ComponentName componentName = creator.createFromParcel(parcel86);
                ActivityManagerNative activityManagerNative = this;
                ComponentName componentName4 = componentName;
                PendingIntent pendingIntent = activityManagerNative.getRunningServiceControlPanel(componentName4);
                parcel2.writeNoException();
                PendingIntent pendingIntent2 = pendingIntent;
                Parcel parcel87 = parcel2;
                PendingIntent.writePendingIntentOrNullToParcel(pendingIntent2, parcel87);
                return true;
            }
            case 34: {
                Parcel parcel88 = parcel;
                String string65 = "android.app.IActivityManager";
                parcel88.enforceInterface(string65);
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                Parcelable.Creator<Intent> creator = Intent.CREATOR;
                Parcel parcel89 = parcel;
                Intent intent = creator.createFromParcel(parcel89);
                String string66 = parcel.readString();
                ActivityManagerNative activityManagerNative = this;
                IApplicationThread iApplicationThread10 = iApplicationThread;
                Intent intent8 = intent;
                String string67 = string66;
                ComponentName componentName = activityManagerNative.startService(iApplicationThread10, intent8, string67);
                parcel2.writeNoException();
                ComponentName componentName5 = componentName;
                Parcel parcel90 = parcel2;
                ComponentName.writeToParcel(componentName5, parcel90);
                return true;
            }
            case 35: {
                Parcel parcel91 = parcel;
                String string68 = "android.app.IActivityManager";
                parcel91.enforceInterface(string68);
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                Parcelable.Creator<Intent> creator = Intent.CREATOR;
                Parcel parcel92 = parcel;
                Intent intent = creator.createFromParcel(parcel92);
                String string69 = parcel.readString();
                ActivityManagerNative activityManagerNative = this;
                IApplicationThread iApplicationThread11 = iApplicationThread;
                Intent intent9 = intent;
                String string70 = string69;
                int n78 = activityManagerNative.stopService(iApplicationThread11, intent9, string70);
                parcel2.writeNoException();
                Parcel parcel93 = parcel2;
                int n79 = n78;
                parcel93.writeInt(n79);
                return true;
            }
            case 48: {
                Parcel parcel94 = parcel;
                String string71 = "android.app.IActivityManager";
                parcel94.enforceInterface(string71);
                ComponentName componentName = ComponentName.readFromParcel(parcel);
                IBinder iBinder = parcel.readStrongBinder();
                int n80 = parcel.readInt();
                ActivityManagerNative activityManagerNative = this;
                ComponentName componentName6 = componentName;
                IBinder iBinder19 = iBinder;
                int n81 = n80;
                boolean bl = activityManagerNative.stopServiceToken(componentName6, iBinder19, n81);
                parcel2.writeNoException();
                int n82 = bl ? 1 : 0;
                Parcel parcel95 = parcel2;
                int n83 = n82;
                parcel95.writeInt(n83);
                return true;
            }
            case 74: {
                Parcel parcel96 = parcel;
                String string72 = "android.app.IActivityManager";
                parcel96.enforceInterface(string72);
                ComponentName componentName = ComponentName.readFromParcel(parcel);
                IBinder iBinder = parcel.readStrongBinder();
                int n84 = parcel.readInt();
                Notification notification = null;
                if (parcel.readInt() != 0) {
                    Parcelable.Creator<Notification> creator = Notification.CREATOR;
                    Parcel parcel97 = parcel;
                    notification = creator.createFromParcel(parcel97);
                }
                boolean bl = parcel.readInt() != 0;
                this.setServiceForeground(componentName, iBinder, n84, notification, bl);
                parcel2.writeNoException();
                return true;
            }
            case 36: {
                Parcel parcel98 = parcel;
                String string73 = "android.app.IActivityManager";
                parcel98.enforceInterface(string73);
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                IBinder iBinder = parcel.readStrongBinder();
                Parcelable.Creator<Intent> creator = Intent.CREATOR;
                Parcel parcel99 = parcel;
                Intent intent = creator.createFromParcel(parcel99);
                String string74 = parcel.readString();
                IBinder iBinder20 = parcel.readStrongBinder();
                int n85 = parcel.readInt();
                IServiceConnection iServiceConnection = IServiceConnection.Stub.asInterface(iBinder20);
                ActivityManagerNative activityManagerNative = this;
                IApplicationThread iApplicationThread12 = iApplicationThread;
                IBinder iBinder21 = iBinder;
                String string75 = string74;
                int n86 = activityManagerNative.bindService(iApplicationThread12, iBinder21, intent, string75, iServiceConnection, n85);
                parcel2.writeNoException();
                Parcel parcel100 = parcel2;
                int n87 = n86;
                parcel100.writeInt(n87);
                return true;
            }
            case 37: {
                Parcel parcel101 = parcel;
                String string76 = "android.app.IActivityManager";
                parcel101.enforceInterface(string76);
                IServiceConnection iServiceConnection = IServiceConnection.Stub.asInterface(parcel.readStrongBinder());
                ActivityManagerNative activityManagerNative = this;
                IServiceConnection iServiceConnection2 = iServiceConnection;
                boolean bl = activityManagerNative.unbindService(iServiceConnection2);
                parcel2.writeNoException();
                int n88 = bl ? 1 : 0;
                Parcel parcel102 = parcel2;
                int n89 = n88;
                parcel102.writeInt(n89);
                return true;
            }
            case 38: {
                Parcel parcel103 = parcel;
                String string77 = "android.app.IActivityManager";
                parcel103.enforceInterface(string77);
                IBinder iBinder = parcel.readStrongBinder();
                Parcelable.Creator<Intent> creator = Intent.CREATOR;
                Parcel parcel104 = parcel;
                Intent intent = creator.createFromParcel(parcel104);
                IBinder iBinder22 = parcel.readStrongBinder();
                ActivityManagerNative activityManagerNative = this;
                IBinder iBinder23 = iBinder;
                Intent intent10 = intent;
                IBinder iBinder24 = iBinder22;
                activityManagerNative.publishService(iBinder23, intent10, iBinder24);
                parcel2.writeNoException();
                return true;
            }
            case 72: {
                Parcel parcel105 = parcel;
                String string78 = "android.app.IActivityManager";
                parcel105.enforceInterface(string78);
                IBinder iBinder = parcel.readStrongBinder();
                Parcelable.Creator<Intent> creator = Intent.CREATOR;
                Parcel parcel106 = parcel;
                Intent intent = creator.createFromParcel(parcel106);
                boolean bl = parcel.readInt() != 0;
                ActivityManagerNative activityManagerNative = this;
                IBinder iBinder25 = iBinder;
                Intent intent11 = intent;
                boolean bl9 = bl;
                activityManagerNative.unbindFinished(iBinder25, intent11, bl9);
                parcel2.writeNoException();
                return true;
            }
            case 61: {
                Parcel parcel107 = parcel;
                String string79 = "android.app.IActivityManager";
                parcel107.enforceInterface(string79);
                IBinder iBinder = parcel.readStrongBinder();
                int n90 = parcel.readInt();
                int n91 = parcel.readInt();
                int n92 = parcel.readInt();
                ActivityManagerNative activityManagerNative = this;
                IBinder iBinder26 = iBinder;
                int n93 = n90;
                int n94 = n91;
                int n95 = n92;
                activityManagerNative.serviceDoneExecuting(iBinder26, n93, n94, n95);
                parcel2.writeNoException();
                return true;
            }
            case 44: {
                Parcel parcel108 = parcel;
                String string80 = "android.app.IActivityManager";
                parcel108.enforceInterface(string80);
                ComponentName componentName = ComponentName.readFromParcel(parcel);
                String string81 = parcel.readString();
                int n96 = parcel.readInt();
                Bundle bundle = parcel.readBundle();
                IInstrumentationWatcher iInstrumentationWatcher = IInstrumentationWatcher.Stub.asInterface(parcel.readStrongBinder());
                ActivityManagerNative activityManagerNative = this;
                ComponentName componentName7 = componentName;
                int n97 = n96;
                boolean bl = activityManagerNative.startInstrumentation(componentName7, string81, n97, bundle, iInstrumentationWatcher);
                parcel2.writeNoException();
                int n98 = bl ? 1 : 0;
                Parcel parcel109 = parcel2;
                int n99 = n98;
                parcel109.writeInt(n99);
                return true;
            }
            case 45: {
                Parcel parcel110 = parcel;
                String string82 = "android.app.IActivityManager";
                parcel110.enforceInterface(string82);
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                int n100 = parcel.readInt();
                Bundle bundle = parcel.readBundle();
                ActivityManagerNative activityManagerNative = this;
                IApplicationThread iApplicationThread13 = iApplicationThread;
                int n101 = n100;
                Bundle bundle4 = bundle;
                activityManagerNative.finishInstrumentation(iApplicationThread13, n101, bundle4);
                parcel2.writeNoException();
                return true;
            }
            case 46: {
                Parcel parcel111 = parcel;
                String string83 = "android.app.IActivityManager";
                parcel111.enforceInterface(string83);
                Configuration configuration = this.getConfiguration();
                parcel2.writeNoException();
                Configuration configuration4 = configuration;
                Parcel parcel112 = parcel2;
                int n102 = 0;
                configuration4.writeToParcel(parcel112, n102);
                return true;
            }
            case 47: {
                Parcel parcel113 = parcel;
                String string84 = "android.app.IActivityManager";
                parcel113.enforceInterface(string84);
                Parcelable.Creator<Configuration> creator = Configuration.CREATOR;
                Parcel parcel114 = parcel;
                Configuration configuration = creator.createFromParcel(parcel114);
                ActivityManagerNative activityManagerNative = this;
                Configuration configuration5 = configuration;
                activityManagerNative.updateConfiguration(configuration5);
                parcel2.writeNoException();
                return true;
            }
            case 70: {
                Parcel parcel115 = parcel;
                String string85 = "android.app.IActivityManager";
                parcel115.enforceInterface(string85);
                IBinder iBinder = parcel.readStrongBinder();
                int n103 = parcel.readInt();
                ActivityManagerNative activityManagerNative = this;
                IBinder iBinder27 = iBinder;
                int n104 = n103;
                activityManagerNative.setRequestedOrientation(iBinder27, n104);
                parcel2.writeNoException();
                return true;
            }
            case 71: {
                Parcel parcel116 = parcel;
                String string86 = "android.app.IActivityManager";
                parcel116.enforceInterface(string86);
                IBinder iBinder = parcel.readStrongBinder();
                ActivityManagerNative activityManagerNative = this;
                IBinder iBinder28 = iBinder;
                int n105 = activityManagerNative.getRequestedOrientation(iBinder28);
                parcel2.writeNoException();
                Parcel parcel117 = parcel2;
                int n106 = n105;
                parcel117.writeInt(n106);
                return true;
            }
            case 49: {
                Parcel parcel118 = parcel;
                String string87 = "android.app.IActivityManager";
                parcel118.enforceInterface(string87);
                IBinder iBinder = parcel.readStrongBinder();
                ActivityManagerNative activityManagerNative = this;
                IBinder iBinder29 = iBinder;
                ComponentName componentName = activityManagerNative.getActivityClassForToken(iBinder29);
                parcel2.writeNoException();
                ComponentName componentName8 = componentName;
                Parcel parcel119 = parcel2;
                ComponentName.writeToParcel(componentName8, parcel119);
                return true;
            }
            case 50: {
                Parcel parcel120 = parcel;
                String string88 = "android.app.IActivityManager";
                parcel120.enforceInterface(string88);
                IBinder iBinder = parcel.readStrongBinder();
                parcel2.writeNoException();
                ActivityManagerNative activityManagerNative = this;
                IBinder iBinder30 = iBinder;
                String string89 = activityManagerNative.getPackageForToken(iBinder30);
                Parcel parcel121 = parcel2;
                String string90 = string89;
                parcel121.writeString(string90);
                return true;
            }
            case 63: {
                Intent intent;
                Parcel parcel122 = parcel;
                String string91 = "android.app.IActivityManager";
                parcel122.enforceInterface(string91);
                int n107 = parcel.readInt();
                String string92 = parcel.readString();
                IBinder iBinder = parcel.readStrongBinder();
                String string93 = parcel.readString();
                int n108 = parcel.readInt();
                if (parcel.readInt() != 0) {
                    Parcelable.Creator<Intent> creator = Intent.CREATOR;
                    Parcel parcel123 = parcel;
                    intent = creator.createFromParcel(parcel123);
                } else {
                    intent = null;
                }
                String string94 = parcel.readString();
                int n109 = parcel.readInt();
                ActivityManagerNative activityManagerNative = this;
                IBinder iBinder31 = iBinder;
                String string95 = string93;
                int n110 = n108;
                int n111 = n109;
                IIntentSender iIntentSender = activityManagerNative.getIntentSender(n107, string92, iBinder31, string95, n110, intent, string94, n111);
                parcel2.writeNoException();
                IBinder iBinder32 = iIntentSender != null ? iIntentSender.asBinder() : null;
                Parcel parcel124 = parcel2;
                IBinder iBinder33 = iBinder32;
                parcel124.writeStrongBinder(iBinder33);
                return true;
            }
            case 64: {
                Parcel parcel125 = parcel;
                String string96 = "android.app.IActivityManager";
                parcel125.enforceInterface(string96);
                IIntentSender iIntentSender = IIntentSender.Stub.asInterface(parcel.readStrongBinder());
                ActivityManagerNative activityManagerNative = this;
                IIntentSender iIntentSender2 = iIntentSender;
                activityManagerNative.cancelIntentSender(iIntentSender2);
                parcel2.writeNoException();
                return true;
            }
            case 65: {
                Parcel parcel126 = parcel;
                String string97 = "android.app.IActivityManager";
                parcel126.enforceInterface(string97);
                IIntentSender iIntentSender = IIntentSender.Stub.asInterface(parcel.readStrongBinder());
                ActivityManagerNative activityManagerNative = this;
                IIntentSender iIntentSender3 = iIntentSender;
                String string98 = activityManagerNative.getPackageForIntentSender(iIntentSender3);
                parcel2.writeNoException();
                Parcel parcel127 = parcel2;
                String string99 = string98;
                parcel127.writeString(string99);
                return true;
            }
            case 51: {
                Parcel parcel128 = parcel;
                String string100 = "android.app.IActivityManager";
                parcel128.enforceInterface(string100);
                int n112 = parcel.readInt();
                ActivityManagerNative activityManagerNative = this;
                int n113 = n112;
                activityManagerNative.setProcessLimit(n113);
                parcel2.writeNoException();
                return true;
            }
            case 52: {
                Parcel parcel129 = parcel;
                String string101 = "android.app.IActivityManager";
                parcel129.enforceInterface(string101);
                int n114 = this.getProcessLimit();
                parcel2.writeNoException();
                Parcel parcel130 = parcel2;
                int n115 = n114;
                parcel130.writeInt(n115);
                return true;
            }
            case 73: {
                Parcel parcel131 = parcel;
                String string102 = "android.app.IActivityManager";
                parcel131.enforceInterface(string102);
                IBinder iBinder = parcel.readStrongBinder();
                int n116 = parcel.readInt();
                boolean bl = parcel.readInt() != 0;
                ActivityManagerNative activityManagerNative = this;
                IBinder iBinder34 = iBinder;
                int n117 = n116;
                boolean bl10 = bl;
                activityManagerNative.setProcessForeground(iBinder34, n117, bl10);
                parcel2.writeNoException();
                return true;
            }
            case 53: {
                Parcel parcel132 = parcel;
                String string103 = "android.app.IActivityManager";
                parcel132.enforceInterface(string103);
                String string104 = parcel.readString();
                int n118 = parcel.readInt();
                int n119 = parcel.readInt();
                ActivityManagerNative activityManagerNative = this;
                String string105 = string104;
                int n120 = n118;
                int n121 = n119;
                int n122 = activityManagerNative.checkPermission(string105, n120, n121);
                parcel2.writeNoException();
                Parcel parcel133 = parcel2;
                int n123 = n122;
                parcel133.writeInt(n123);
                return true;
            }
            case 54: {
                Parcel parcel134 = parcel;
                String string106 = "android.app.IActivityManager";
                parcel134.enforceInterface(string106);
                Parcelable.Creator<Uri> creator = Uri.CREATOR;
                Parcel parcel135 = parcel;
                Uri uri = creator.createFromParcel(parcel135);
                int n124 = parcel.readInt();
                int n125 = parcel.readInt();
                int n126 = parcel.readInt();
                ActivityManagerNative activityManagerNative = this;
                Uri uri2 = uri;
                int n127 = n124;
                int n128 = n125;
                int n129 = n126;
                int n130 = activityManagerNative.checkUriPermission(uri2, n127, n128, n129);
                parcel2.writeNoException();
                Parcel parcel136 = parcel2;
                int n131 = n130;
                parcel136.writeInt(n131);
                return true;
            }
            case 78: {
                Parcel parcel137 = parcel;
                String string107 = "android.app.IActivityManager";
                parcel137.enforceInterface(string107);
                String string108 = parcel.readString();
                IPackageDataObserver iPackageDataObserver = IPackageDataObserver.Stub.asInterface(parcel.readStrongBinder());
                ActivityManagerNative activityManagerNative = this;
                String string109 = string108;
                IPackageDataObserver iPackageDataObserver2 = iPackageDataObserver;
                boolean bl = activityManagerNative.clearApplicationUserData(string109, iPackageDataObserver2);
                parcel2.writeNoException();
                int n132 = bl ? 1 : 0;
                Parcel parcel138 = parcel2;
                int n133 = n132;
                parcel138.writeInt(n133);
                return true;
            }
            case 55: {
                Parcel parcel139 = parcel;
                String string110 = "android.app.IActivityManager";
                parcel139.enforceInterface(string110);
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                String string111 = parcel.readString();
                Parcelable.Creator<Uri> creator = Uri.CREATOR;
                Parcel parcel140 = parcel;
                Uri uri = creator.createFromParcel(parcel140);
                int n134 = parcel.readInt();
                ActivityManagerNative activityManagerNative = this;
                IApplicationThread iApplicationThread14 = iApplicationThread;
                String string112 = string111;
                Uri uri3 = uri;
                int n135 = n134;
                activityManagerNative.grantUriPermission(iApplicationThread14, string112, uri3, n135);
                parcel2.writeNoException();
                return true;
            }
            case 56: {
                Parcel parcel141 = parcel;
                String string113 = "android.app.IActivityManager";
                parcel141.enforceInterface(string113);
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                Parcelable.Creator<Uri> creator = Uri.CREATOR;
                Parcel parcel142 = parcel;
                Uri uri = creator.createFromParcel(parcel142);
                int n136 = parcel.readInt();
                ActivityManagerNative activityManagerNative = this;
                IApplicationThread iApplicationThread15 = iApplicationThread;
                Uri uri4 = uri;
                int n137 = n136;
                activityManagerNative.revokeUriPermission(iApplicationThread15, uri4, n137);
                parcel2.writeNoException();
                return true;
            }
            case 58: {
                Parcel parcel143 = parcel;
                String string114 = "android.app.IActivityManager";
                parcel143.enforceInterface(string114);
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                boolean bl = parcel.readInt() != 0;
                ActivityManagerNative activityManagerNative = this;
                IApplicationThread iApplicationThread16 = iApplicationThread;
                boolean bl11 = bl;
                activityManagerNative.showWaitingForDebugger(iApplicationThread16, bl11);
                parcel2.writeNoException();
                return true;
            }
            case 76: {
                Parcel parcel144 = parcel;
                String string115 = "android.app.IActivityManager";
                parcel144.enforceInterface(string115);
                ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
                ActivityManagerNative activityManagerNative = this;
                ActivityManager.MemoryInfo memoryInfo2 = memoryInfo;
                activityManagerNative.getMemoryInfo(memoryInfo2);
                parcel2.writeNoException();
                ActivityManager.MemoryInfo memoryInfo3 = memoryInfo;
                Parcel parcel145 = parcel2;
                int n138 = 0;
                memoryInfo3.writeToParcel(parcel145, n138);
                return true;
            }
            case 4: {
                Parcel parcel146 = parcel;
                String string116 = "android.app.IActivityManager";
                parcel146.enforceInterface(string116);
                this.unhandledBack();
                parcel2.writeNoException();
                return true;
            }
            case 5: {
                Parcel parcel147 = parcel;
                String string117 = "android.app.IActivityManager";
                parcel147.enforceInterface(string117);
                Uri uri = Uri.parse(parcel.readString());
                ActivityManagerNative activityManagerNative = this;
                Uri uri5 = uri;
                ParcelFileDescriptor parcelFileDescriptor = activityManagerNative.openContentUri(uri5);
                parcel2.writeNoException();
                if (parcelFileDescriptor != null) {
                    Parcel parcel148 = parcel2;
                    int n139 = 1;
                    parcel148.writeInt(n139);
                    ParcelFileDescriptor parcelFileDescriptor2 = parcelFileDescriptor;
                    Parcel parcel149 = parcel2;
                    int n140 = 1;
                    parcelFileDescriptor2.writeToParcel(parcel149, n140);
                    return true;
                } else {
                    Parcel parcel150 = parcel2;
                    int n141 = 0;
                    parcel150.writeInt(n141);
                }
                return true;
            }
            case 40: {
                Parcel parcel151 = parcel;
                String string118 = "android.app.IActivityManager";
                parcel151.enforceInterface(string118);
                this.goingToSleep();
                parcel2.writeNoException();
                return true;
            }
            case 41: {
                Parcel parcel152 = parcel;
                String string119 = "android.app.IActivityManager";
                parcel152.enforceInterface(string119);
                this.wakingUp();
                parcel2.writeNoException();
                return true;
            }
            case 42: {
                Parcel parcel153 = parcel;
                String string120 = "android.app.IActivityManager";
                parcel153.enforceInterface(string120);
                String string121 = parcel.readString();
                boolean bl = parcel.readInt() != 0;
                boolean bl12 = parcel.readInt() != 0;
                ActivityManagerNative activityManagerNative = this;
                String string122 = string121;
                boolean bl13 = bl;
                boolean bl14 = bl12;
                activityManagerNative.setDebugApp(string122, bl13, bl14);
                parcel2.writeNoException();
                return true;
            }
            case 43: {
                Parcel parcel154 = parcel;
                String string123 = "android.app.IActivityManager";
                parcel154.enforceInterface(string123);
                boolean bl = parcel.readInt() != 0;
                ActivityManagerNative activityManagerNative = this;
                boolean bl15 = bl;
                activityManagerNative.setAlwaysFinish(bl15);
                parcel2.writeNoException();
                return true;
            }
            case 57: {
                Parcel parcel155 = parcel;
                String string124 = "android.app.IActivityManager";
                parcel155.enforceInterface(string124);
                IActivityController iActivityController = IActivityController.Stub.asInterface(parcel.readStrongBinder());
                ActivityManagerNative activityManagerNative = this;
                IActivityController iActivityController2 = iActivityController;
                activityManagerNative.setActivityController(iActivityController2);
                return true;
            }
            case 66: {
                Parcel parcel156 = parcel;
                String string125 = "android.app.IActivityManager";
                parcel156.enforceInterface(string125);
                this.enterSafeMode();
                parcel2.writeNoException();
                return true;
            }
            case 68: {
                Parcel parcel157 = parcel;
                String string126 = "android.app.IActivityManager";
                parcel157.enforceInterface(string126);
                IIntentSender iIntentSender = IIntentSender.Stub.asInterface(parcel.readStrongBinder());
                ActivityManagerNative activityManagerNative = this;
                IIntentSender iIntentSender4 = iIntentSender;
                activityManagerNative.noteWakeupAlarm(iIntentSender4);
                parcel2.writeNoException();
                return true;
            }
            case 80: {
                Parcel parcel158 = parcel;
                String string127 = "android.app.IActivityManager";
                parcel158.enforceInterface(string127);
                int[] nArray = parcel.createIntArray();
                String string128 = parcel.readString();
                ActivityManagerNative activityManagerNative = this;
                int[] nArray2 = nArray;
                String string129 = string128;
                boolean bl = activityManagerNative.killPids(nArray2, string129);
                parcel2.writeNoException();
                int n142 = bl ? 1 : 0;
                Parcel parcel159 = parcel2;
                int n143 = n142;
                parcel159.writeInt(n143);
                return true;
            }
            case 1: {
                Parcel parcel160 = parcel;
                String string130 = "android.app.IActivityManager";
                parcel160.enforceInterface(string130);
                String string131 = parcel.readString();
                String string132 = parcel.readString();
                String string133 = parcel.readString();
                String string134 = parcel.readString();
                ActivityManagerNative activityManagerNative = this;
                String string135 = string131;
                String string136 = string132;
                String string137 = string133;
                String string138 = string134;
                activityManagerNative.startRunning(string135, string136, string137, string138);
                parcel2.writeNoException();
                return true;
            }
            case 2: {
                ApplicationErrorReport.CrashInfo crashInfo;
                Parcel parcel161 = parcel;
                String string139 = "android.app.IActivityManager";
                parcel161.enforceInterface(string139);
                IBinder iBinder = parcel.readStrongBinder();
                ApplicationErrorReport.CrashInfo crashInfo2 = crashInfo;
                Parcel parcel162 = parcel;
                crashInfo2(parcel162);
                ActivityManagerNative activityManagerNative = this;
                IBinder iBinder35 = iBinder;
                ApplicationErrorReport.CrashInfo crashInfo3 = crashInfo;
                activityManagerNative.handleApplicationCrash(iBinder35, crashInfo3);
                parcel2.writeNoException();
                return true;
            }
            case 102: {
                ApplicationErrorReport.CrashInfo crashInfo;
                Parcel parcel163 = parcel;
                String string140 = "android.app.IActivityManager";
                parcel163.enforceInterface(string140);
                IBinder iBinder = parcel.readStrongBinder();
                String string141 = parcel.readString();
                ApplicationErrorReport.CrashInfo crashInfo4 = crashInfo;
                Parcel parcel164 = parcel;
                crashInfo4(parcel164);
                ActivityManagerNative activityManagerNative = this;
                IBinder iBinder36 = iBinder;
                String string142 = string141;
                ApplicationErrorReport.CrashInfo crashInfo5 = crashInfo;
                boolean bl = activityManagerNative.handleApplicationWtf(iBinder36, string142, crashInfo5);
                parcel2.writeNoException();
                int n144 = bl ? 1 : 0;
                Parcel parcel165 = parcel2;
                int n145 = n144;
                parcel165.writeInt(n145);
                return true;
            }
            case 110: {
                StrictMode.ViolationInfo violationInfo;
                Parcel parcel166 = parcel;
                String string143 = "android.app.IActivityManager";
                parcel166.enforceInterface(string143);
                IBinder iBinder = parcel.readStrongBinder();
                int n146 = parcel.readInt();
                StrictMode.ViolationInfo violationInfo2 = violationInfo;
                Parcel parcel167 = parcel;
                violationInfo2(parcel167);
                ActivityManagerNative activityManagerNative = this;
                IBinder iBinder37 = iBinder;
                int n147 = n146;
                StrictMode.ViolationInfo violationInfo3 = violationInfo;
                activityManagerNative.handleApplicationStrictModeViolation(iBinder37, n147, violationInfo3);
                parcel2.writeNoException();
                return true;
            }
            case 59: {
                Parcel parcel168 = parcel;
                String string144 = "android.app.IActivityManager";
                parcel168.enforceInterface(string144);
                int n148 = parcel.readInt();
                ActivityManagerNative activityManagerNative = this;
                int n149 = n148;
                activityManagerNative.signalPersistentProcesses(n149);
                parcel2.writeNoException();
                return true;
            }
            case 103: {
                Parcel parcel169 = parcel;
                String string145 = "android.app.IActivityManager";
                parcel169.enforceInterface(string145);
                String string146 = parcel.readString();
                ActivityManagerNative activityManagerNative = this;
                String string147 = string146;
                activityManagerNative.killBackgroundProcesses(string147);
                parcel2.writeNoException();
                return true;
            }
            case 79: {
                Parcel parcel170 = parcel;
                String string148 = "android.app.IActivityManager";
                parcel170.enforceInterface(string148);
                String string149 = parcel.readString();
                ActivityManagerNative activityManagerNative = this;
                String string150 = string149;
                activityManagerNative.forceStopPackage(string150);
                parcel2.writeNoException();
                return true;
            }
            case 84: {
                Parcel parcel171 = parcel;
                String string151 = "android.app.IActivityManager";
                parcel171.enforceInterface(string151);
                ConfigurationInfo configurationInfo = this.getDeviceConfigurationInfo();
                parcel2.writeNoException();
                ConfigurationInfo configurationInfo2 = configurationInfo;
                Parcel parcel172 = parcel2;
                int n150 = 0;
                configurationInfo2.writeToParcel(parcel172, n150);
                return true;
            }
            case 86: {
                Parcel parcel173 = parcel;
                String string152 = "android.app.IActivityManager";
                parcel173.enforceInterface(string152);
                String string153 = parcel.readString();
                boolean bl = parcel.readInt() != 0;
                String string154 = parcel.readString();
                ParcelFileDescriptor parcelFileDescriptor = parcel.readInt() != 0 ? parcel.readFileDescriptor() : null;
                ActivityManagerNative activityManagerNative = this;
                String string155 = string153;
                boolean bl16 = bl;
                String string156 = string154;
                ParcelFileDescriptor parcelFileDescriptor3 = parcelFileDescriptor;
                boolean bl17 = activityManagerNative.profileControl(string155, bl16, string156, parcelFileDescriptor3);
                parcel2.writeNoException();
                int n151 = bl17 ? 1 : 0;
                Parcel parcel174 = parcel2;
                int n152 = n151;
                parcel174.writeInt(n152);
                return true;
            }
            case 87: {
                Parcel parcel175 = parcel;
                String string157 = "android.app.IActivityManager";
                parcel175.enforceInterface(string157);
                int n153 = parcel.readInt();
                ActivityManagerNative activityManagerNative = this;
                int n154 = n153;
                boolean bl = activityManagerNative.shutdown(n154);
                parcel2.writeNoException();
                int n155 = bl ? 1 : 0;
                Parcel parcel176 = parcel2;
                int n156 = n155;
                parcel176.writeInt(n156);
                return true;
            }
            case 88: {
                Parcel parcel177 = parcel;
                String string158 = "android.app.IActivityManager";
                parcel177.enforceInterface(string158);
                this.stopAppSwitches();
                parcel2.writeNoException();
                return true;
            }
            case 89: {
                Parcel parcel178 = parcel;
                String string159 = "android.app.IActivityManager";
                parcel178.enforceInterface(string159);
                this.resumeAppSwitches();
                parcel2.writeNoException();
                return true;
            }
            case 85: {
                Parcel parcel179 = parcel;
                String string160 = "android.app.IActivityManager";
                parcel179.enforceInterface(string160);
                Parcelable.Creator<Intent> creator = Intent.CREATOR;
                Parcel parcel180 = parcel;
                Intent intent = creator.createFromParcel(parcel180);
                String string161 = parcel.readString();
                ActivityManagerNative activityManagerNative = this;
                Intent intent12 = intent;
                String string162 = string161;
                IBinder iBinder = activityManagerNative.peekService(intent12, string162);
                parcel2.writeNoException();
                Parcel parcel181 = parcel2;
                IBinder iBinder38 = iBinder;
                parcel181.writeStrongBinder(iBinder38);
                return true;
            }
            case 90: {
                Parcel parcel182 = parcel;
                String string163 = "android.app.IActivityManager";
                parcel182.enforceInterface(string163);
                Parcelable.Creator<ApplicationInfo> creator = ApplicationInfo.CREATOR;
                Parcel parcel183 = parcel;
                ApplicationInfo applicationInfo = creator.createFromParcel(parcel183);
                int n157 = parcel.readInt();
                ActivityManagerNative activityManagerNative = this;
                ApplicationInfo applicationInfo2 = applicationInfo;
                int n158 = n157;
                boolean bl = activityManagerNative.bindBackupAgent(applicationInfo2, n158);
                parcel2.writeNoException();
                int n159 = bl ? 1 : 0;
                Parcel parcel184 = parcel2;
                int n160 = n159;
                parcel184.writeInt(n160);
                return true;
            }
            case 91: {
                Parcel parcel185 = parcel;
                String string164 = "android.app.IActivityManager";
                parcel185.enforceInterface(string164);
                String string165 = parcel.readString();
                IBinder iBinder = parcel.readStrongBinder();
                ActivityManagerNative activityManagerNative = this;
                String string166 = string165;
                IBinder iBinder39 = iBinder;
                activityManagerNative.backupAgentCreated(string166, iBinder39);
                parcel2.writeNoException();
                return true;
            }
            case 92: {
                Parcel parcel186 = parcel;
                String string167 = "android.app.IActivityManager";
                parcel186.enforceInterface(string167);
                Parcelable.Creator<ApplicationInfo> creator = ApplicationInfo.CREATOR;
                Parcel parcel187 = parcel;
                ApplicationInfo applicationInfo = creator.createFromParcel(parcel187);
                ActivityManagerNative activityManagerNative = this;
                ApplicationInfo applicationInfo3 = applicationInfo;
                activityManagerNative.unbindBackupAgent(applicationInfo3);
                parcel2.writeNoException();
                return true;
            }
            case 93: {
                Parcel parcel188 = parcel;
                String string168 = "android.app.IActivityManager";
                parcel188.enforceInterface(string168);
                IActivityWatcher iActivityWatcher = IActivityWatcher.Stub.asInterface(parcel.readStrongBinder());
                ActivityManagerNative activityManagerNative = this;
                IActivityWatcher iActivityWatcher2 = iActivityWatcher;
                activityManagerNative.registerActivityWatcher(iActivityWatcher2);
                return true;
            }
            case 94: {
                Parcel parcel189 = parcel;
                String string169 = "android.app.IActivityManager";
                parcel189.enforceInterface(string169);
                IActivityWatcher iActivityWatcher = IActivityWatcher.Stub.asInterface(parcel.readStrongBinder());
                ActivityManagerNative activityManagerNative = this;
                IActivityWatcher iActivityWatcher3 = iActivityWatcher;
                activityManagerNative.unregisterActivityWatcher(iActivityWatcher3);
                return true;
            }
            case 95: {
                Parcel parcel190 = parcel;
                String string170 = "android.app.IActivityManager";
                parcel190.enforceInterface(string170);
                int n161 = parcel.readInt();
                Parcelable.Creator<Intent> creator = Intent.CREATOR;
                Parcel parcel191 = parcel;
                Intent intent = creator.createFromParcel(parcel191);
                String string171 = parcel.readString();
                IBinder iBinder = parcel.readStrongBinder();
                String string172 = parcel.readString();
                int n162 = parcel.readInt();
                boolean bl = parcel.readInt() != 0;
                ActivityManagerNative activityManagerNative = this;
                Intent intent13 = intent;
                String string173 = string171;
                IBinder iBinder40 = iBinder;
                String string174 = string172;
                int n163 = n162;
                boolean bl18 = bl;
                int n164 = activityManagerNative.startActivityInPackage(n161, intent13, string173, iBinder40, string174, n163, bl18);
                parcel2.writeNoException();
                Parcel parcel192 = parcel2;
                int n165 = n164;
                parcel192.writeInt(n165);
                return true;
            }
            case 96: {
                Parcel parcel193 = parcel;
                String string175 = "android.app.IActivityManager";
                parcel193.enforceInterface(string175);
                String string176 = parcel.readString();
                int n166 = parcel.readInt();
                ActivityManagerNative activityManagerNative = this;
                String string177 = string176;
                int n167 = n166;
                activityManagerNative.killApplicationWithUid(string177, n167);
                parcel2.writeNoException();
                return true;
            }
            case 97: {
                Parcel parcel194 = parcel;
                String string178 = "android.app.IActivityManager";
                parcel194.enforceInterface(string178);
                String string179 = parcel.readString();
                ActivityManagerNative activityManagerNative = this;
                String string180 = string179;
                activityManagerNative.closeSystemDialogs(string180);
                parcel2.writeNoException();
                return true;
            }
            case 98: {
                Parcel parcel195 = parcel;
                String string181 = "android.app.IActivityManager";
                parcel195.enforceInterface(string181);
                int[] nArray = parcel.createIntArray();
                ActivityManagerNative activityManagerNative = this;
                int[] nArray3 = nArray;
                Parcelable[] parcelableArray = activityManagerNative.getProcessMemoryInfo(nArray3);
                parcel2.writeNoException();
                Parcel parcel196 = parcel2;
                Parcelable[] parcelableArray2 = parcelableArray;
                int n168 = 1;
                parcel196.writeTypedArray(parcelableArray2, n168);
                return true;
            }
            case 99: {
                Parcel parcel197 = parcel;
                String string182 = "android.app.IActivityManager";
                parcel197.enforceInterface(string182);
                String string183 = parcel.readString();
                int n169 = parcel.readInt();
                ActivityManagerNative activityManagerNative = this;
                String string184 = string183;
                int n170 = n169;
                activityManagerNative.killApplicationProcess(string184, n170);
                parcel2.writeNoException();
                return true;
            }
            case 101: {
                Parcel parcel198 = parcel;
                String string185 = "android.app.IActivityManager";
                parcel198.enforceInterface(string185);
                IBinder iBinder = parcel.readStrongBinder();
                String string186 = parcel.readString();
                int n171 = parcel.readInt();
                int n172 = parcel.readInt();
                ActivityManagerNative activityManagerNative = this;
                IBinder iBinder41 = iBinder;
                String string187 = string186;
                int n173 = n171;
                int n174 = n172;
                activityManagerNative.overridePendingTransition(iBinder41, string187, n173, n174);
                parcel2.writeNoException();
                return true;
            }
            case 104: {
                Parcel parcel199 = parcel;
                String string188 = "android.app.IActivityManager";
                parcel199.enforceInterface(string188);
                boolean bl = this.isUserAMonkey();
                parcel2.writeNoException();
                int n175 = bl ? 1 : 0;
                Parcel parcel200 = parcel2;
                int n176 = n175;
                parcel200.writeInt(n176);
                return true;
            }
            case 109: {
                Parcel parcel201 = parcel;
                String string189 = "android.app.IActivityManager";
                parcel201.enforceInterface(string189);
                this.finishHeavyWeightApp();
                parcel2.writeNoException();
                return true;
            }
            case 114: {
                Parcel parcel202 = parcel;
                String string190 = "android.app.IActivityManager";
                parcel202.enforceInterface(string190);
                int n177 = parcel.readInt();
                int n178 = parcel.readInt();
                String string191 = parcel.readString();
                String string192 = parcel.readString();
                ActivityManagerNative activityManagerNative = this;
                int n179 = n177;
                int n180 = n178;
                String string193 = string191;
                String string194 = string192;
                activityManagerNative.crashApplication(n179, n180, string193, string194);
                parcel2.writeNoException();
                return true;
            }
            case 115: {
                Parcel parcel203 = parcel;
                String string195 = "android.app.IActivityManager";
                parcel203.enforceInterface(string195);
                Parcelable.Creator<Uri> creator = Uri.CREATOR;
                Parcel parcel204 = parcel;
                Uri uri = creator.createFromParcel(parcel204);
                ActivityManagerNative activityManagerNative = this;
                Uri uri6 = uri;
                String string196 = activityManagerNative.getProviderMimeType(uri6);
                parcel2.writeNoException();
                Parcel parcel205 = parcel2;
                String string197 = string196;
                parcel205.writeString(string197);
                return true;
            }
            case 116: {
                Parcel parcel206 = parcel;
                String string198 = "android.app.IActivityManager";
                parcel206.enforceInterface(string198);
                String string199 = parcel.readString();
                ActivityManagerNative activityManagerNative = this;
                String string200 = string199;
                IBinder iBinder = activityManagerNative.newUriPermissionOwner(string200);
                parcel2.writeNoException();
                Parcel parcel207 = parcel2;
                IBinder iBinder42 = iBinder;
                parcel207.writeStrongBinder(iBinder42);
                return true;
            }
            case 117: {
                Parcel parcel208 = parcel;
                String string201 = "android.app.IActivityManager";
                parcel208.enforceInterface(string201);
                IBinder iBinder = parcel.readStrongBinder();
                int n181 = parcel.readInt();
                String string202 = parcel.readString();
                Parcelable.Creator<Uri> creator = Uri.CREATOR;
                Parcel parcel209 = parcel;
                Uri uri = creator.createFromParcel(parcel209);
                int n182 = parcel.readInt();
                this.grantUriPermissionFromOwner(iBinder, n181, string202, uri, n182);
                parcel2.writeNoException();
                return true;
            }
            case 118: 
        }
        Parcel parcel210 = parcel;
        String string203 = "android.app.IActivityManager";
        parcel210.enforceInterface(string203);
        IBinder iBinder = parcel.readStrongBinder();
        Uri uri = null;
        if (parcel.readInt() != 0) {
            Parcelable.Creator<Uri> creator = Uri.CREATOR;
            Parcel parcel211 = parcel;
            Uri uri7 = creator.createFromParcel(parcel211);
        }
        int n183 = parcel.readInt();
        ActivityManagerNative activityManagerNative = this;
        IBinder iBinder43 = iBinder;
        Uri uri8 = uri;
        int n184 = n183;
        activityManagerNative.revokeUriPermissionFromOwner(iBinder43, uri8, n184);
        parcel2.writeNoException();
        return true;
    }
}

