/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityManager;
import android.app.ApplicationErrorReport;
import android.app.IActivityController;
import android.app.IActivityManager;
import android.app.IActivityWatcher;
import android.app.IApplicationThread;
import android.app.IInstrumentationWatcher;
import android.app.IServiceConnection;
import android.app.IThumbnailReceiver;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.IIntentReceiver;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ApplicationInfo;
import android.content.pm.ConfigurationInfo;
import android.content.pm.IPackageDataObserver;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.Debug;
import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.StrictMode;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;

class ActivityManagerProxy
implements IActivityManager {
    private IBinder mRemote;

    public ActivityManagerProxy(IBinder iBinder) {
        this.mRemote = iBinder;
    }

    @Override
    public void activityDestroyed(IBinder iBinder) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeStrongBinder(iBinder);
        boolean bl = this.mRemote.transact(62, parcel, parcel2, 1);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void activityIdle(IBinder iBinder, Configuration configuration) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeStrongBinder(iBinder);
        if (configuration != null) {
            parcel.writeInt(1);
            configuration.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        boolean bl = this.mRemote.transact(18, parcel, parcel2, 1);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    @Override
    public void activityPaused(IBinder iBinder, Bundle bundle) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeStrongBinder(iBinder);
        parcel.writeBundle(bundle);
        boolean bl = this.mRemote.transact(19, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void activityStopped(IBinder iBinder, Bitmap bitmap, CharSequence charSequence) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeStrongBinder(iBinder);
        if (bitmap != null) {
            parcel.writeInt(1);
            bitmap.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        TextUtils.writeToParcel(charSequence, parcel, 0);
        boolean bl = this.mRemote.transact(20, parcel, parcel2, 1);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    @Override
    public IBinder asBinder() {
        return this.mRemote;
    }

    @Override
    public void attachApplication(IApplicationThread iApplicationThread) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        IBinder iBinder = iApplicationThread.asBinder();
        parcel.writeStrongBinder(iBinder);
        boolean bl = this.mRemote.transact(17, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    @Override
    public void backupAgentCreated(String string2, IBinder iBinder) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeString(string2);
        parcel.writeStrongBinder(iBinder);
        boolean bl = this.mRemote.transact(91, parcel, parcel2, 0);
        parcel2.recycle();
        parcel.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean bindBackupAgent(ApplicationInfo applicationInfo, int n) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        applicationInfo.writeToParcel(parcel, 0);
        parcel.writeInt(n);
        boolean bl = this.mRemote.transact(90, parcel, parcel2, 0);
        parcel2.readException();
        boolean bl2 = parcel2.readInt() != 0;
        parcel2.recycle();
        parcel.recycle();
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int bindService(IApplicationThread iApplicationThread, IBinder iBinder, Intent intent, String string2, IServiceConnection iServiceConnection, int n) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        IBinder iBinder2 = iApplicationThread != null ? iApplicationThread.asBinder() : null;
        parcel.writeStrongBinder(iBinder2);
        parcel.writeStrongBinder(iBinder);
        intent.writeToParcel(parcel, 0);
        parcel.writeString(string2);
        IBinder iBinder3 = iServiceConnection.asBinder();
        parcel.writeStrongBinder(iBinder3);
        parcel.writeInt(n);
        boolean bl = this.mRemote.transact(36, parcel, parcel2, 0);
        parcel2.readException();
        int n2 = parcel2.readInt();
        parcel.recycle();
        parcel2.recycle();
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int broadcastIntent(IApplicationThread iApplicationThread, Intent intent, String string2, IIntentReceiver iIntentReceiver, int n, String string3, Bundle bundle, String string4, boolean bl, boolean bl2) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        IBinder iBinder = iApplicationThread != null ? iApplicationThread.asBinder() : null;
        parcel.writeStrongBinder(iBinder);
        intent.writeToParcel(parcel, 0);
        parcel.writeString(string2);
        IBinder iBinder2 = iIntentReceiver != null ? iIntentReceiver.asBinder() : null;
        parcel.writeStrongBinder(iBinder2);
        parcel.writeInt(n);
        parcel.writeString(string3);
        parcel.writeBundle(bundle);
        parcel.writeString(string4);
        int n2 = bl ? 1 : 0;
        parcel.writeInt(n2);
        int n3 = bl2 ? 1 : 0;
        parcel.writeInt(n3);
        boolean bl3 = this.mRemote.transact(14, parcel, parcel2, 0);
        parcel2.readException();
        int n4 = parcel2.readInt();
        parcel2.recycle();
        parcel.recycle();
        return n4;
    }

    @Override
    public void cancelIntentSender(IIntentSender iIntentSender) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        IBinder iBinder = iIntentSender.asBinder();
        parcel.writeStrongBinder(iBinder);
        boolean bl = this.mRemote.transact(64, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    @Override
    public int checkPermission(String string2, int n, int n2) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeString(string2);
        parcel.writeInt(n);
        parcel.writeInt(n2);
        boolean bl = this.mRemote.transact(53, parcel, parcel2, 0);
        parcel2.readException();
        int n3 = parcel2.readInt();
        parcel.recycle();
        parcel2.recycle();
        return n3;
    }

    @Override
    public int checkUriPermission(Uri uri, int n, int n2, int n3) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        uri.writeToParcel(parcel, 0);
        parcel.writeInt(n);
        parcel.writeInt(n2);
        parcel.writeInt(n3);
        boolean bl = this.mRemote.transact(54, parcel, parcel2, 0);
        parcel2.readException();
        int n4 = parcel2.readInt();
        parcel.recycle();
        parcel2.recycle();
        return n4;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean clearApplicationUserData(String string2, IPackageDataObserver iPackageDataObserver) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeString(string2);
        IBinder iBinder = iPackageDataObserver.asBinder();
        parcel.writeStrongBinder(iBinder);
        boolean bl = this.mRemote.transact(78, parcel, parcel2, 0);
        parcel2.readException();
        boolean bl2 = parcel2.readInt() != 0;
        parcel.recycle();
        parcel2.recycle();
        return bl2;
    }

    @Override
    public void closeSystemDialogs(String string2) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeString(string2);
        boolean bl = this.mRemote.transact(97, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    @Override
    public void crashApplication(int n, int n2, String string2, String string3) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeInt(n);
        parcel.writeInt(n2);
        parcel.writeString(string2);
        parcel.writeString(string3);
        boolean bl = this.mRemote.transact(114, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    @Override
    public void enterSafeMode() throws RemoteException {
        Parcel parcel = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        boolean bl = this.mRemote.transact(66, parcel, null, 0);
        parcel.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean finishActivity(IBinder iBinder, int n, Intent intent) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeStrongBinder(iBinder);
        parcel.writeInt(n);
        if (intent != null) {
            parcel.writeInt(1);
            intent.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        boolean bl = this.mRemote.transact(11, parcel, parcel2, 0);
        parcel2.readException();
        boolean bl2 = parcel2.readInt() != 0;
        parcel.recycle();
        parcel2.recycle();
        return bl2;
    }

    @Override
    public void finishHeavyWeightApp() throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        boolean bl = this.mRemote.transact(109, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void finishInstrumentation(IApplicationThread iApplicationThread, int n, Bundle bundle) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        IBinder iBinder = iApplicationThread != null ? iApplicationThread.asBinder() : null;
        parcel.writeStrongBinder(iBinder);
        parcel.writeInt(n);
        parcel.writeBundle(bundle);
        boolean bl = this.mRemote.transact(45, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    @Override
    public void finishOtherInstances(IBinder iBinder, ComponentName componentName) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeStrongBinder(iBinder);
        ComponentName.writeToParcel(componentName, parcel);
        boolean bl = this.mRemote.transact(39, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void finishReceiver(IBinder iBinder, int n, String string2, Bundle bundle, boolean bl) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeStrongBinder(iBinder);
        parcel.writeInt(n);
        parcel.writeString(string2);
        parcel.writeBundle(bundle);
        int n2 = bl ? 1 : 0;
        parcel.writeInt(n2);
        boolean bl2 = this.mRemote.transact(16, parcel, parcel2, 1);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    @Override
    public void finishSubActivity(IBinder iBinder, String string2, int n) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeStrongBinder(iBinder);
        parcel.writeString(string2);
        parcel.writeInt(n);
        boolean bl = this.mRemote.transact(32, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    @Override
    public void forceStopPackage(String string2) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeString(string2);
        boolean bl = this.mRemote.transact(79, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    @Override
    public ComponentName getActivityClassForToken(IBinder iBinder) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeStrongBinder(iBinder);
        boolean bl = this.mRemote.transact(49, parcel, parcel2, 0);
        parcel2.readException();
        ComponentName componentName = ComponentName.readFromParcel(parcel2);
        parcel.recycle();
        parcel2.recycle();
        return componentName;
    }

    @Override
    public ComponentName getCallingActivity(IBinder iBinder) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeStrongBinder(iBinder);
        boolean bl = this.mRemote.transact(22, parcel, parcel2, 0);
        parcel2.readException();
        ComponentName componentName = ComponentName.readFromParcel(parcel2);
        parcel.recycle();
        parcel2.recycle();
        return componentName;
    }

    @Override
    public String getCallingPackage(IBinder iBinder) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeStrongBinder(iBinder);
        boolean bl = this.mRemote.transact(21, parcel, parcel2, 0);
        parcel2.readException();
        String string2 = parcel2.readString();
        parcel.recycle();
        parcel2.recycle();
        return string2;
    }

    @Override
    public Configuration getConfiguration() throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        boolean bl = this.mRemote.transact(46, parcel, parcel2, 0);
        parcel2.readException();
        Configuration configuration = Configuration.CREATOR.createFromParcel(parcel2);
        parcel2.recycle();
        parcel.recycle();
        return configuration;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public IActivityManager.ContentProviderHolder getContentProvider(IApplicationThread iApplicationThread, String string2) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        IBinder iBinder = iApplicationThread != null ? iApplicationThread.asBinder() : null;
        parcel.writeStrongBinder(iBinder);
        parcel.writeString(string2);
        boolean bl = this.mRemote.transact(29, parcel, parcel2, 0);
        parcel2.readException();
        int n = parcel2.readInt();
        IActivityManager.ContentProviderHolder contentProviderHolder = null;
        if (n != 0) {
            contentProviderHolder = IActivityManager.ContentProviderHolder.CREATOR.createFromParcel(parcel2);
        }
        parcel.recycle();
        parcel2.recycle();
        return contentProviderHolder;
    }

    @Override
    public ConfigurationInfo getDeviceConfigurationInfo() throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        boolean bl = this.mRemote.transact(84, parcel, parcel2, 0);
        parcel2.readException();
        ConfigurationInfo configurationInfo = ConfigurationInfo.CREATOR.createFromParcel(parcel2);
        parcel2.recycle();
        parcel.recycle();
        return configurationInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public IIntentSender getIntentSender(int n, String string2, IBinder iBinder, String string3, int n2, Intent intent, String string4, int n3) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeInt(n);
        parcel.writeString(string2);
        parcel.writeStrongBinder(iBinder);
        parcel.writeString(string3);
        parcel.writeInt(n2);
        if (intent != null) {
            parcel.writeInt(1);
            intent.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeString(string4);
        parcel.writeInt(n3);
        boolean bl = this.mRemote.transact(63, parcel, parcel2, 0);
        parcel2.readException();
        IIntentSender iIntentSender = IIntentSender.Stub.asInterface(parcel2.readStrongBinder());
        parcel.recycle();
        parcel2.recycle();
        return iIntentSender;
    }

    @Override
    public void getMemoryInfo(ActivityManager.MemoryInfo memoryInfo) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        boolean bl = this.mRemote.transact(76, parcel, parcel2, 0);
        parcel2.readException();
        memoryInfo.readFromParcel(parcel2);
        parcel.recycle();
        parcel2.recycle();
    }

    @Override
    public String getPackageForIntentSender(IIntentSender iIntentSender) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        IBinder iBinder = iIntentSender.asBinder();
        parcel.writeStrongBinder(iBinder);
        boolean bl = this.mRemote.transact(65, parcel, parcel2, 0);
        parcel2.readException();
        String string2 = parcel2.readString();
        parcel.recycle();
        parcel2.recycle();
        return string2;
    }

    @Override
    public String getPackageForToken(IBinder iBinder) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeStrongBinder(iBinder);
        boolean bl = this.mRemote.transact(50, parcel, parcel2, 0);
        parcel2.readException();
        String string2 = parcel2.readString();
        parcel.recycle();
        parcel2.recycle();
        return string2;
    }

    @Override
    public int getProcessLimit() throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        boolean bl = this.mRemote.transact(52, parcel, parcel2, 0);
        parcel2.readException();
        int n = parcel2.readInt();
        parcel.recycle();
        parcel2.recycle();
        return n;
    }

    @Override
    public Debug.MemoryInfo[] getProcessMemoryInfo(int[] nArray) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeIntArray(nArray);
        boolean bl = this.mRemote.transact(98, parcel, parcel2, 0);
        parcel2.readException();
        Parcelable.Creator<Debug.MemoryInfo> creator = Debug.MemoryInfo.CREATOR;
        Debug.MemoryInfo[] memoryInfoArray = parcel2.createTypedArray(creator);
        parcel.recycle();
        parcel2.recycle();
        return memoryInfoArray;
    }

    @Override
    public List<ActivityManager.ProcessErrorStateInfo> getProcessesInErrorState() throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        boolean bl = this.mRemote.transact(77, parcel, parcel2, 0);
        parcel2.readException();
        Parcelable.Creator<ActivityManager.ProcessErrorStateInfo> creator = ActivityManager.ProcessErrorStateInfo.CREATOR;
        ArrayList<ActivityManager.ProcessErrorStateInfo> arrayList = parcel2.createTypedArrayList(creator);
        parcel.recycle();
        parcel2.recycle();
        return arrayList;
    }

    @Override
    public String getProviderMimeType(Uri uri) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        uri.writeToParcel(parcel, 0);
        boolean bl = this.mRemote.transact(115, parcel, parcel2, 0);
        parcel2.readException();
        String string2 = parcel2.readString();
        parcel.recycle();
        parcel2.recycle();
        return string2;
    }

    @Override
    public List<ActivityManager.RecentTaskInfo> getRecentTasks(int n, int n2) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeInt(n);
        parcel.writeInt(n2);
        boolean bl = this.mRemote.transact(60, parcel, parcel2, 0);
        parcel2.readException();
        Parcelable.Creator<ActivityManager.RecentTaskInfo> creator = ActivityManager.RecentTaskInfo.CREATOR;
        ArrayList<ActivityManager.RecentTaskInfo> arrayList = parcel2.createTypedArrayList(creator);
        parcel.recycle();
        parcel2.recycle();
        return arrayList;
    }

    @Override
    public int getRequestedOrientation(IBinder iBinder) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeStrongBinder(iBinder);
        boolean bl = this.mRemote.transact(71, parcel, parcel2, 0);
        parcel2.readException();
        int n = parcel2.readInt();
        parcel.recycle();
        parcel2.recycle();
        return n;
    }

    @Override
    public List<ActivityManager.RunningAppProcessInfo> getRunningAppProcesses() throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        boolean bl = this.mRemote.transact(83, parcel, parcel2, 0);
        parcel2.readException();
        Parcelable.Creator<ActivityManager.RunningAppProcessInfo> creator = ActivityManager.RunningAppProcessInfo.CREATOR;
        ArrayList<ActivityManager.RunningAppProcessInfo> arrayList = parcel2.createTypedArrayList(creator);
        parcel.recycle();
        parcel2.recycle();
        return arrayList;
    }

    @Override
    public List<ApplicationInfo> getRunningExternalApplications() throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        boolean bl = this.mRemote.transact(108, parcel, parcel2, 0);
        parcel2.readException();
        Parcelable.Creator<ApplicationInfo> creator = ApplicationInfo.CREATOR;
        ArrayList<ApplicationInfo> arrayList = parcel2.createTypedArrayList(creator);
        parcel.recycle();
        parcel2.recycle();
        return arrayList;
    }

    @Override
    public PendingIntent getRunningServiceControlPanel(ComponentName componentName) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        componentName.writeToParcel(parcel, 0);
        boolean bl = this.mRemote.transact(33, parcel, parcel2, 0);
        parcel2.readException();
        PendingIntent pendingIntent = PendingIntent.readPendingIntentOrNullFromParcel(parcel2);
        parcel.recycle();
        parcel2.recycle();
        return pendingIntent;
    }

    @Override
    public List getServices(int n, int n2) throws RemoteException {
        int n3;
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeInt(n);
        parcel.writeInt(n2);
        boolean bl = this.mRemote.transact(81, parcel, parcel2, 0);
        parcel2.readException();
        ArrayList<ActivityManager.RunningServiceInfo> arrayList = null;
        if (n3 >= 0) {
            arrayList = new ArrayList<ActivityManager.RunningServiceInfo>();
            for (n3 = parcel2.readInt(); n3 > 0; n3 += -1) {
                ActivityManager.RunningServiceInfo runningServiceInfo = ActivityManager.RunningServiceInfo.CREATOR.createFromParcel(parcel2);
                boolean bl2 = arrayList.add(runningServiceInfo);
            }
        }
        parcel.recycle();
        parcel2.recycle();
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getTaskForActivity(IBinder iBinder, boolean bl) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeStrongBinder(iBinder);
        int n = bl ? 1 : 0;
        parcel.writeInt(n);
        boolean bl2 = this.mRemote.transact(27, parcel, parcel2, 0);
        parcel2.readException();
        int n2 = parcel2.readInt();
        parcel.recycle();
        parcel2.recycle();
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public List getTasks(int n, int n2, IThumbnailReceiver iThumbnailReceiver) throws RemoteException {
        int n3;
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeInt(n);
        parcel.writeInt(n2);
        IBinder iBinder = iThumbnailReceiver != null ? iThumbnailReceiver.asBinder() : null;
        parcel.writeStrongBinder(iBinder);
        boolean bl = this.mRemote.transact(23, parcel, parcel2, 0);
        parcel2.readException();
        ArrayList<ActivityManager.RunningTaskInfo> arrayList = null;
        if (n3 >= 0) {
            arrayList = new ArrayList<ActivityManager.RunningTaskInfo>();
            for (n3 = parcel2.readInt(); n3 > 0; n3 += -1) {
                ActivityManager.RunningTaskInfo runningTaskInfo = ActivityManager.RunningTaskInfo.CREATOR.createFromParcel(parcel2);
                boolean bl2 = arrayList.add(runningTaskInfo);
            }
        }
        parcel.recycle();
        parcel2.recycle();
        return arrayList;
    }

    @Override
    public void goingToSleep() throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        boolean bl = this.mRemote.transact(40, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    @Override
    public void grantUriPermission(IApplicationThread iApplicationThread, String string2, Uri uri, int n) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        IBinder iBinder = iApplicationThread.asBinder();
        parcel.writeStrongBinder(iBinder);
        parcel.writeString(string2);
        uri.writeToParcel(parcel, 0);
        parcel.writeInt(n);
        boolean bl = this.mRemote.transact(55, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    @Override
    public void grantUriPermissionFromOwner(IBinder iBinder, int n, String string2, Uri uri, int n2) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeStrongBinder(iBinder);
        parcel.writeInt(n);
        parcel.writeString(string2);
        uri.writeToParcel(parcel, 0);
        parcel.writeInt(n2);
        boolean bl = this.mRemote.transact(55, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    @Override
    public void handleApplicationCrash(IBinder iBinder, ApplicationErrorReport.CrashInfo crashInfo) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeStrongBinder(iBinder);
        crashInfo.writeToParcel(parcel, 0);
        boolean bl = this.mRemote.transact(2, parcel, parcel2, 0);
        parcel2.readException();
        parcel2.recycle();
        parcel.recycle();
    }

    @Override
    public void handleApplicationStrictModeViolation(IBinder iBinder, int n, StrictMode.ViolationInfo violationInfo) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeStrongBinder(iBinder);
        parcel.writeInt(n);
        violationInfo.writeToParcel(parcel, 0);
        boolean bl = this.mRemote.transact(110, parcel, parcel2, 0);
        parcel2.readException();
        parcel2.recycle();
        parcel.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean handleApplicationWtf(IBinder iBinder, String string2, ApplicationErrorReport.CrashInfo crashInfo) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeStrongBinder(iBinder);
        parcel.writeString(string2);
        crashInfo.writeToParcel(parcel, 0);
        boolean bl = this.mRemote.transact(102, parcel, parcel2, 0);
        parcel2.readException();
        boolean bl2 = parcel2.readInt() != 0;
        parcel2.recycle();
        parcel.recycle();
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean isUserAMonkey() throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        boolean bl = this.mRemote.transact(104, parcel, parcel2, 0);
        parcel2.readException();
        boolean bl2 = parcel2.readInt() != 0;
        parcel.recycle();
        parcel2.recycle();
        return bl2;
    }

    @Override
    public void killApplicationProcess(String string2, int n) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeString(string2);
        parcel.writeInt(n);
        boolean bl = this.mRemote.transact(99, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    @Override
    public void killApplicationWithUid(String string2, int n) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeString(string2);
        parcel.writeInt(n);
        boolean bl = this.mRemote.transact(96, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    @Override
    public void killBackgroundProcesses(String string2) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeString(string2);
        boolean bl = this.mRemote.transact(103, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean killPids(int[] nArray, String string2) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeIntArray(nArray);
        parcel.writeString(string2);
        boolean bl = this.mRemote.transact(80, parcel, parcel2, 0);
        boolean bl2 = parcel2.readInt() != 0;
        parcel.recycle();
        parcel2.recycle();
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean moveActivityTaskToBack(IBinder iBinder, boolean bl) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeStrongBinder(iBinder);
        int n = bl ? 1 : 0;
        parcel.writeInt(n);
        boolean bl2 = this.mRemote.transact(75, parcel, parcel2, 0);
        parcel2.readException();
        boolean bl3 = parcel2.readInt() != 0;
        parcel.recycle();
        parcel2.recycle();
        return bl3;
    }

    @Override
    public void moveTaskBackwards(int n) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeInt(n);
        boolean bl = this.mRemote.transact(26, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    @Override
    public void moveTaskToBack(int n) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeInt(n);
        boolean bl = this.mRemote.transact(25, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    @Override
    public void moveTaskToFront(int n) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeInt(n);
        boolean bl = this.mRemote.transact(24, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    @Override
    public IBinder newUriPermissionOwner(String string2) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeString(string2);
        boolean bl = this.mRemote.transact(116, parcel, parcel2, 0);
        parcel2.readException();
        IBinder iBinder = parcel2.readStrongBinder();
        parcel.recycle();
        parcel2.recycle();
        return iBinder;
    }

    @Override
    public void noteWakeupAlarm(IIntentSender iIntentSender) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        IBinder iBinder = iIntentSender.asBinder();
        parcel.writeStrongBinder(iBinder);
        parcel.writeInterfaceToken("android.app.IActivityManager");
        boolean bl = this.mRemote.transact(68, parcel, null, 0);
        parcel.recycle();
    }

    @Override
    public ParcelFileDescriptor openContentUri(Uri uri) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        boolean bl = this.mRemote.transact(5, parcel, parcel2, 0);
        parcel2.readException();
        ParcelFileDescriptor parcelFileDescriptor = null;
        if (parcel2.readInt() != 0) {
            parcelFileDescriptor = ParcelFileDescriptor.CREATOR.createFromParcel(parcel2);
        }
        parcel.recycle();
        parcel2.recycle();
        return parcelFileDescriptor;
    }

    @Override
    public void overridePendingTransition(IBinder iBinder, String string2, int n, int n2) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeStrongBinder(iBinder);
        parcel.writeString(string2);
        parcel.writeInt(n);
        parcel.writeInt(n2);
        boolean bl = this.mRemote.transact(101, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    @Override
    public IBinder peekService(Intent intent, String string2) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        intent.writeToParcel(parcel, 0);
        parcel.writeString(string2);
        boolean bl = this.mRemote.transact(85, parcel, parcel2, 0);
        parcel2.readException();
        IBinder iBinder = parcel2.readStrongBinder();
        parcel2.recycle();
        parcel.recycle();
        return iBinder;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean profileControl(String string2, boolean bl, String string3, ParcelFileDescriptor parcelFileDescriptor) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeString(string2);
        int n = bl ? 1 : 0;
        parcel.writeInt(n);
        parcel.writeString(string3);
        if (parcelFileDescriptor != null) {
            parcel.writeInt(1);
            parcelFileDescriptor.writeToParcel(parcel, 1);
        } else {
            parcel.writeInt(0);
        }
        boolean bl2 = this.mRemote.transact(86, parcel, parcel2, 0);
        parcel2.readException();
        boolean bl3 = parcel2.readInt() != 0;
        parcel2.recycle();
        parcel.recycle();
        return bl3;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void publishContentProviders(IApplicationThread iApplicationThread, List<IActivityManager.ContentProviderHolder> list) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        IBinder iBinder = iApplicationThread != null ? iApplicationThread.asBinder() : null;
        parcel.writeStrongBinder(iBinder);
        parcel.writeTypedList(list);
        boolean bl = this.mRemote.transact(30, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    @Override
    public void publishService(IBinder iBinder, Intent intent, IBinder iBinder2) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeStrongBinder(iBinder);
        intent.writeToParcel(parcel, 0);
        parcel.writeStrongBinder(iBinder2);
        boolean bl = this.mRemote.transact(38, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void registerActivityWatcher(IActivityWatcher iActivityWatcher) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        IBinder iBinder = iActivityWatcher != null ? iActivityWatcher.asBinder() : null;
        parcel.writeStrongBinder(iBinder);
        boolean bl = this.mRemote.transact(93, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Intent registerReceiver(IApplicationThread iApplicationThread, IIntentReceiver iIntentReceiver, IntentFilter intentFilter, String string2) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        IBinder iBinder = iApplicationThread != null ? iApplicationThread.asBinder() : null;
        parcel.writeStrongBinder(iBinder);
        IBinder iBinder2 = iIntentReceiver != null ? iIntentReceiver.asBinder() : null;
        parcel.writeStrongBinder(iBinder2);
        intentFilter.writeToParcel(parcel, 0);
        parcel.writeString(string2);
        boolean bl = this.mRemote.transact(12, parcel, parcel2, 0);
        parcel2.readException();
        Intent intent = null;
        if (parcel2.readInt() != 0) {
            intent = Intent.CREATOR.createFromParcel(parcel2);
        }
        parcel2.recycle();
        parcel.recycle();
        return intent;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void removeContentProvider(IApplicationThread iApplicationThread, String string2) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        IBinder iBinder = iApplicationThread != null ? iApplicationThread.asBinder() : null;
        parcel.writeStrongBinder(iBinder);
        parcel.writeString(string2);
        boolean bl = this.mRemote.transact(69, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void reportThumbnail(IBinder iBinder, Bitmap bitmap, CharSequence charSequence) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeStrongBinder(iBinder);
        if (bitmap != null) {
            parcel.writeInt(1);
            bitmap.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        TextUtils.writeToParcel(charSequence, parcel, 0);
        boolean bl = this.mRemote.transact(28, parcel, parcel2, 1);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    @Override
    public void resumeAppSwitches() throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        boolean bl = this.mRemote.transact(89, parcel, parcel2, 0);
        parcel2.readException();
        parcel2.recycle();
        parcel.recycle();
    }

    @Override
    public void revokeUriPermission(IApplicationThread iApplicationThread, Uri uri, int n) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        IBinder iBinder = iApplicationThread.asBinder();
        parcel.writeStrongBinder(iBinder);
        uri.writeToParcel(parcel, 0);
        parcel.writeInt(n);
        boolean bl = this.mRemote.transact(56, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void revokeUriPermissionFromOwner(IBinder iBinder, Uri uri, int n) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeStrongBinder(iBinder);
        if (uri != null) {
            parcel.writeInt(1);
            uri.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(n);
        boolean bl = this.mRemote.transact(56, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    @Override
    public void serviceDoneExecuting(IBinder iBinder, int n, int n2, int n3) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeStrongBinder(iBinder);
        parcel.writeInt(n);
        parcel.writeInt(n2);
        parcel.writeInt(n3);
        boolean bl = this.mRemote.transact(61, parcel, parcel2, 1);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setActivityController(IActivityController iActivityController) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        IBinder iBinder = iActivityController != null ? iActivityController.asBinder() : null;
        parcel.writeStrongBinder(iBinder);
        boolean bl = this.mRemote.transact(57, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setAlwaysFinish(boolean bl) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        int n = bl ? 1 : 0;
        parcel.writeInt(n);
        boolean bl2 = this.mRemote.transact(43, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setDebugApp(String string2, boolean bl, boolean bl2) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeString(string2);
        int n = bl ? 1 : 0;
        parcel.writeInt(n);
        int n2 = bl2 ? 1 : 0;
        parcel.writeInt(n2);
        boolean bl3 = this.mRemote.transact(42, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setProcessForeground(IBinder iBinder, int n, boolean bl) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeStrongBinder(iBinder);
        parcel.writeInt(n);
        int n2 = bl ? 1 : 0;
        parcel.writeInt(n2);
        boolean bl2 = this.mRemote.transact(73, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    @Override
    public void setProcessLimit(int n) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeInt(n);
        boolean bl = this.mRemote.transact(51, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    @Override
    public void setRequestedOrientation(IBinder iBinder, int n) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeStrongBinder(iBinder);
        parcel.writeInt(n);
        boolean bl = this.mRemote.transact(70, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setServiceForeground(ComponentName componentName, IBinder iBinder, int n, Notification notification, boolean bl) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        ComponentName.writeToParcel(componentName, parcel);
        parcel.writeStrongBinder(iBinder);
        parcel.writeInt(n);
        if (notification != null) {
            parcel.writeInt(1);
            notification.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        int n2 = bl ? 1 : 0;
        parcel.writeInt(n2);
        boolean bl2 = this.mRemote.transact(74, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void showWaitingForDebugger(IApplicationThread iApplicationThread, boolean bl) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        IBinder iBinder = iApplicationThread.asBinder();
        parcel.writeStrongBinder(iBinder);
        int n = bl ? 1 : 0;
        parcel.writeInt(n);
        boolean bl2 = this.mRemote.transact(58, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean shutdown(int n) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeInt(n);
        boolean bl = this.mRemote.transact(87, parcel, parcel2, 0);
        parcel2.readException();
        boolean bl2 = parcel2.readInt() != 0;
        parcel2.recycle();
        parcel.recycle();
        return bl2;
    }

    @Override
    public void signalPersistentProcesses(int n) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeInt(n);
        boolean bl = this.mRemote.transact(59, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int startActivity(IApplicationThread iApplicationThread, Intent intent, String string2, Uri[] uriArray, int n, IBinder iBinder, String string3, int n2, boolean bl, boolean bl2) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        IBinder iBinder2 = iApplicationThread != null ? iApplicationThread.asBinder() : null;
        parcel.writeStrongBinder(iBinder2);
        intent.writeToParcel(parcel, 0);
        parcel.writeString(string2);
        parcel.writeTypedArray(uriArray, 0);
        parcel.writeInt(n);
        parcel.writeStrongBinder(iBinder);
        parcel.writeString(string3);
        parcel.writeInt(n2);
        int n3 = bl ? 1 : 0;
        parcel.writeInt(n3);
        int n4 = bl2 ? 1 : 0;
        parcel.writeInt(n4);
        boolean bl3 = this.mRemote.transact(3, parcel, parcel2, 0);
        parcel2.readException();
        int n5 = parcel2.readInt();
        parcel2.recycle();
        parcel.recycle();
        return n5;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public IActivityManager.WaitResult startActivityAndWait(IApplicationThread iApplicationThread, Intent intent, String string2, Uri[] uriArray, int n, IBinder iBinder, String string3, int n2, boolean bl, boolean bl2) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        IBinder iBinder2 = iApplicationThread != null ? iApplicationThread.asBinder() : null;
        parcel.writeStrongBinder(iBinder2);
        intent.writeToParcel(parcel, 0);
        parcel.writeString(string2);
        parcel.writeTypedArray(uriArray, 0);
        parcel.writeInt(n);
        parcel.writeStrongBinder(iBinder);
        parcel.writeString(string3);
        parcel.writeInt(n2);
        int n3 = bl ? 1 : 0;
        parcel.writeInt(n3);
        int n4 = bl2 ? 1 : 0;
        parcel.writeInt(n4);
        boolean bl3 = this.mRemote.transact(105, parcel, parcel2, 0);
        parcel2.readException();
        IActivityManager.WaitResult waitResult = IActivityManager.WaitResult.CREATOR.createFromParcel(parcel2);
        parcel2.recycle();
        parcel.recycle();
        return waitResult;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int startActivityInPackage(int n, Intent intent, String string2, IBinder iBinder, String string3, int n2, boolean bl) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeInt(n);
        intent.writeToParcel(parcel, 0);
        parcel.writeString(string2);
        parcel.writeStrongBinder(iBinder);
        parcel.writeString(string3);
        parcel.writeInt(n2);
        int n3 = bl ? 1 : 0;
        parcel.writeInt(n3);
        boolean bl2 = this.mRemote.transact(95, parcel, parcel2, 0);
        parcel2.readException();
        int n4 = parcel2.readInt();
        parcel2.recycle();
        parcel.recycle();
        return n4;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int startActivityIntentSender(IApplicationThread iApplicationThread, IntentSender intentSender, Intent intent, String string2, IBinder iBinder, String string3, int n, int n2, int n3) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        IBinder iBinder2 = iApplicationThread != null ? iApplicationThread.asBinder() : null;
        parcel.writeStrongBinder(iBinder2);
        intentSender.writeToParcel(parcel, 0);
        if (intent != null) {
            parcel.writeInt(1);
            intent.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeString(string2);
        parcel.writeStrongBinder(iBinder);
        parcel.writeString(string3);
        parcel.writeInt(n);
        parcel.writeInt(n2);
        parcel.writeInt(n3);
        boolean bl = this.mRemote.transact(100, parcel, parcel2, 0);
        parcel2.readException();
        int n4 = parcel2.readInt();
        parcel2.recycle();
        parcel.recycle();
        return n4;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int startActivityWithConfig(IApplicationThread iApplicationThread, Intent intent, String string2, Uri[] uriArray, int n, IBinder iBinder, String string3, int n2, boolean bl, boolean bl2, Configuration configuration) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        IBinder iBinder2 = iApplicationThread != null ? iApplicationThread.asBinder() : null;
        parcel.writeStrongBinder(iBinder2);
        intent.writeToParcel(parcel, 0);
        parcel.writeString(string2);
        parcel.writeTypedArray(uriArray, 0);
        parcel.writeInt(n);
        parcel.writeStrongBinder(iBinder);
        Parcel parcel3 = parcel;
        String string4 = string3;
        parcel3.writeString(string4);
        Parcel parcel4 = parcel;
        int n3 = n2;
        parcel4.writeInt(n3);
        int n4 = bl ? 1 : 0;
        parcel.writeInt(n4);
        int n5 = bl2 ? 1 : 0;
        parcel.writeInt(n5);
        Configuration configuration2 = configuration;
        Parcel parcel5 = parcel;
        int n6 = 0;
        configuration2.writeToParcel(parcel5, n6);
        boolean bl3 = this.mRemote.transact(3, parcel, parcel2, 0);
        parcel2.readException();
        int n7 = parcel2.readInt();
        parcel2.recycle();
        parcel.recycle();
        return n7;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean startInstrumentation(ComponentName componentName, String string2, int n, Bundle bundle, IInstrumentationWatcher iInstrumentationWatcher) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        ComponentName.writeToParcel(componentName, parcel);
        parcel.writeString(string2);
        parcel.writeInt(n);
        parcel.writeBundle(bundle);
        IBinder iBinder = iInstrumentationWatcher != null ? iInstrumentationWatcher.asBinder() : null;
        parcel.writeStrongBinder(iBinder);
        boolean bl = this.mRemote.transact(44, parcel, parcel2, 0);
        parcel2.readException();
        boolean bl2 = parcel2.readInt() != 0;
        parcel2.recycle();
        parcel.recycle();
        return bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean startNextMatchingActivity(IBinder iBinder, Intent intent) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeStrongBinder(iBinder);
        intent.writeToParcel(parcel, 0);
        boolean bl = this.mRemote.transact(67, parcel, parcel2, 0);
        parcel2.readException();
        int n = parcel2.readInt();
        parcel2.recycle();
        parcel.recycle();
        if (n == 0) return false;
        return true;
    }

    @Override
    public void startRunning(String string2, String string3, String string4, String string5) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeString(string2);
        parcel.writeString(string3);
        parcel.writeString(string4);
        parcel.writeString(string5);
        boolean bl = this.mRemote.transact(1, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ComponentName startService(IApplicationThread iApplicationThread, Intent intent, String string2) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        IBinder iBinder = iApplicationThread != null ? iApplicationThread.asBinder() : null;
        parcel.writeStrongBinder(iBinder);
        intent.writeToParcel(parcel, 0);
        parcel.writeString(string2);
        boolean bl = this.mRemote.transact(34, parcel, parcel2, 0);
        parcel2.readException();
        ComponentName componentName = ComponentName.readFromParcel(parcel2);
        parcel.recycle();
        parcel2.recycle();
        return componentName;
    }

    @Override
    public void stopAppSwitches() throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        boolean bl = this.mRemote.transact(88, parcel, parcel2, 0);
        parcel2.readException();
        parcel2.recycle();
        parcel.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int stopService(IApplicationThread iApplicationThread, Intent intent, String string2) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        IBinder iBinder = iApplicationThread != null ? iApplicationThread.asBinder() : null;
        parcel.writeStrongBinder(iBinder);
        intent.writeToParcel(parcel, 0);
        parcel.writeString(string2);
        boolean bl = this.mRemote.transact(35, parcel, parcel2, 0);
        parcel2.readException();
        int n = parcel2.readInt();
        parcel2.recycle();
        parcel.recycle();
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean stopServiceToken(ComponentName componentName, IBinder iBinder, int n) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        ComponentName.writeToParcel(componentName, parcel);
        parcel.writeStrongBinder(iBinder);
        parcel.writeInt(n);
        boolean bl = this.mRemote.transact(48, parcel, parcel2, 0);
        parcel2.readException();
        boolean bl2 = parcel2.readInt() != 0;
        parcel.recycle();
        parcel2.recycle();
        return bl2;
    }

    @Override
    public boolean testIsSystemReady() {
        return true;
    }

    @Override
    public void unbindBackupAgent(ApplicationInfo applicationInfo) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        applicationInfo.writeToParcel(parcel, 0);
        boolean bl = this.mRemote.transact(92, parcel, parcel2, 0);
        parcel2.readException();
        parcel2.recycle();
        parcel.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void unbindFinished(IBinder iBinder, Intent intent, boolean bl) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeStrongBinder(iBinder);
        intent.writeToParcel(parcel, 0);
        int n = bl ? 1 : 0;
        parcel.writeInt(n);
        boolean bl2 = this.mRemote.transact(72, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean unbindService(IServiceConnection iServiceConnection) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        IBinder iBinder = iServiceConnection.asBinder();
        parcel.writeStrongBinder(iBinder);
        boolean bl = this.mRemote.transact(37, parcel, parcel2, 0);
        parcel2.readException();
        boolean bl2 = parcel2.readInt() != 0;
        parcel.recycle();
        parcel2.recycle();
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void unbroadcastIntent(IApplicationThread iApplicationThread, Intent intent) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        IBinder iBinder = iApplicationThread != null ? iApplicationThread.asBinder() : null;
        parcel.writeStrongBinder(iBinder);
        intent.writeToParcel(parcel, 0);
        boolean bl = this.mRemote.transact(15, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    @Override
    public void unhandledBack() throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        boolean bl = this.mRemote.transact(4, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void unregisterActivityWatcher(IActivityWatcher iActivityWatcher) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        IBinder iBinder = iActivityWatcher != null ? iActivityWatcher.asBinder() : null;
        parcel.writeStrongBinder(iBinder);
        boolean bl = this.mRemote.transact(94, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    @Override
    public void unregisterReceiver(IIntentReceiver iIntentReceiver) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        IBinder iBinder = iIntentReceiver.asBinder();
        parcel.writeStrongBinder(iBinder);
        boolean bl = this.mRemote.transact(13, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    @Override
    public void updateConfiguration(Configuration configuration) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        configuration.writeToParcel(parcel, 0);
        boolean bl = this.mRemote.transact(47, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    @Override
    public void wakingUp() throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        boolean bl = this.mRemote.transact(41, parcel, parcel2, 0);
        parcel2.readException();
        parcel.recycle();
        parcel2.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean willActivityBeVisible(IBinder iBinder) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.app.IActivityManager");
        parcel.writeStrongBinder(iBinder);
        boolean bl = this.mRemote.transact(106, parcel, parcel2, 0);
        parcel2.readException();
        boolean bl2 = parcel2.readInt() != 0;
        parcel.recycle();
        parcel2.recycle();
        return bl2;
    }
}

