/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Message;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.android.internal.app.AlertController;

public class AlertDialog
extends Dialog
implements DialogInterface {
    private AlertController mAlert;

    protected AlertDialog(Context context) {
        this(context, 16973987);
    }

    protected AlertDialog(Context context, int n) {
        super(context, n);
        AlertController alertController;
        Window window = this.getWindow();
        this.mAlert = alertController = new AlertController(context, this, window);
    }

    protected AlertDialog(Context context, boolean bl, DialogInterface.OnCancelListener onCancelListener) {
        super(context, 16973987);
        AlertController alertController;
        this.setCancelable(bl);
        this.setOnCancelListener(onCancelListener);
        Window window = this.getWindow();
        this.mAlert = alertController = new AlertController(context, this, window);
    }

    public Button getButton(int n) {
        return this.mAlert.getButton(n);
    }

    public ListView getListView() {
        return this.mAlert.getListView();
    }

    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.mAlert.installContent();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (!this.mAlert.onKeyDown(n, keyEvent)) return super.onKeyDown(n, keyEvent);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        if (!this.mAlert.onKeyUp(n, keyEvent)) return super.onKeyUp(n, keyEvent);
        return true;
    }

    public void setButton(int n, CharSequence charSequence, DialogInterface.OnClickListener onClickListener) {
        this.mAlert.setButton(n, charSequence, onClickListener, null);
    }

    public void setButton(int n, CharSequence charSequence, Message message) {
        this.mAlert.setButton(n, charSequence, null, message);
    }

    @Deprecated
    public void setButton(CharSequence charSequence, DialogInterface.OnClickListener onClickListener) {
        this.setButton(-1, charSequence, onClickListener);
    }

    @Deprecated
    public void setButton(CharSequence charSequence, Message message) {
        this.setButton(-1, charSequence, message);
    }

    @Deprecated
    public void setButton2(CharSequence charSequence, DialogInterface.OnClickListener onClickListener) {
        this.setButton(-1, charSequence, onClickListener);
    }

    @Deprecated
    public void setButton2(CharSequence charSequence, Message message) {
        this.setButton(-1, charSequence, message);
    }

    @Deprecated
    public void setButton3(CharSequence charSequence, DialogInterface.OnClickListener onClickListener) {
        this.setButton(-1, charSequence, onClickListener);
    }

    @Deprecated
    public void setButton3(CharSequence charSequence, Message message) {
        this.setButton(-1, charSequence, message);
    }

    public void setCustomTitle(View view) {
        this.mAlert.setCustomTitle(view);
    }

    public void setIcon(int n) {
        this.mAlert.setIcon(n);
    }

    public void setIcon(Drawable drawable2) {
        this.mAlert.setIcon(drawable2);
    }

    public void setInverseBackgroundForced(boolean bl) {
        this.mAlert.setInverseBackgroundForced(bl);
    }

    public void setMessage(CharSequence charSequence) {
        this.mAlert.setMessage(charSequence);
    }

    @Override
    public void setTitle(CharSequence charSequence) {
        super.setTitle(charSequence);
        this.mAlert.setTitle(charSequence);
    }

    public void setView(View view) {
        this.mAlert.setView(view);
    }

    public void setView(View view, int n, int n2, int n3, int n4) {
        AlertController alertController = this.mAlert;
        View view2 = view;
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        alertController.setView(view2, n5, n6, n7, n8);
    }

    public static class Builder {
        private final AlertController.AlertParams P;

        public Builder(Context context) {
            AlertController.AlertParams alertParams;
            this.P = alertParams = new AlertController.AlertParams(context);
        }

        public AlertDialog create() {
            Context context = this.P.mContext;
            AlertDialog alertDialog = new AlertDialog(context);
            AlertController.AlertParams alertParams = this.P;
            AlertController alertController = alertDialog.mAlert;
            alertParams.apply(alertController);
            boolean bl = this.P.mCancelable;
            alertDialog.setCancelable(bl);
            DialogInterface.OnCancelListener onCancelListener = this.P.mOnCancelListener;
            alertDialog.setOnCancelListener(onCancelListener);
            if (this.P.mOnKeyListener != null) {
                DialogInterface.OnKeyListener onKeyListener = this.P.mOnKeyListener;
                alertDialog.setOnKeyListener(onKeyListener);
            }
            return alertDialog;
        }

        public Builder setAdapter(ListAdapter listAdapter, DialogInterface.OnClickListener onClickListener) {
            this.P.mAdapter = listAdapter;
            this.P.mOnClickListener = onClickListener;
            return this;
        }

        public Builder setCancelable(boolean bl) {
            this.P.mCancelable = bl;
            return this;
        }

        public Builder setCursor(Cursor cursor, DialogInterface.OnClickListener onClickListener, String string2) {
            this.P.mCursor = cursor;
            this.P.mLabelColumn = string2;
            this.P.mOnClickListener = onClickListener;
            return this;
        }

        public Builder setCustomTitle(View view) {
            this.P.mCustomTitleView = view;
            return this;
        }

        public Builder setIcon(int n) {
            this.P.mIconId = n;
            return this;
        }

        public Builder setIcon(Drawable drawable2) {
            this.P.mIcon = drawable2;
            return this;
        }

        public Builder setInverseBackgroundForced(boolean bl) {
            this.P.mForceInverseBackground = bl;
            return this;
        }

        public Builder setItems(int n, DialogInterface.OnClickListener onClickListener) {
            AlertController.AlertParams alertParams = this.P;
            CharSequence[] charSequenceArray = this.P.mContext.getResources().getTextArray(n);
            alertParams.mItems = charSequenceArray;
            this.P.mOnClickListener = onClickListener;
            return this;
        }

        public Builder setItems(CharSequence[] charSequenceArray, DialogInterface.OnClickListener onClickListener) {
            this.P.mItems = charSequenceArray;
            this.P.mOnClickListener = onClickListener;
            return this;
        }

        public Builder setMessage(int n) {
            CharSequence charSequence;
            AlertController.AlertParams alertParams = this.P;
            alertParams.mMessage = charSequence = this.P.mContext.getText(n);
            return this;
        }

        public Builder setMessage(CharSequence charSequence) {
            this.P.mMessage = charSequence;
            return this;
        }

        public Builder setMultiChoiceItems(int n, boolean[] blArray, DialogInterface.OnMultiChoiceClickListener onMultiChoiceClickListener) {
            AlertController.AlertParams alertParams = this.P;
            CharSequence[] charSequenceArray = this.P.mContext.getResources().getTextArray(n);
            alertParams.mItems = charSequenceArray;
            this.P.mOnCheckboxClickListener = onMultiChoiceClickListener;
            this.P.mCheckedItems = blArray;
            this.P.mIsMultiChoice = true;
            return this;
        }

        public Builder setMultiChoiceItems(Cursor cursor, String string2, String string3, DialogInterface.OnMultiChoiceClickListener onMultiChoiceClickListener) {
            this.P.mCursor = cursor;
            this.P.mOnCheckboxClickListener = onMultiChoiceClickListener;
            this.P.mIsCheckedColumn = string2;
            this.P.mLabelColumn = string3;
            this.P.mIsMultiChoice = true;
            return this;
        }

        public Builder setMultiChoiceItems(CharSequence[] charSequenceArray, boolean[] blArray, DialogInterface.OnMultiChoiceClickListener onMultiChoiceClickListener) {
            this.P.mItems = charSequenceArray;
            this.P.mOnCheckboxClickListener = onMultiChoiceClickListener;
            this.P.mCheckedItems = blArray;
            this.P.mIsMultiChoice = true;
            return this;
        }

        public Builder setNegativeButton(int n, DialogInterface.OnClickListener onClickListener) {
            CharSequence charSequence;
            AlertController.AlertParams alertParams = this.P;
            alertParams.mNegativeButtonText = charSequence = this.P.mContext.getText(n);
            this.P.mNegativeButtonListener = onClickListener;
            return this;
        }

        public Builder setNegativeButton(CharSequence charSequence, DialogInterface.OnClickListener onClickListener) {
            this.P.mNegativeButtonText = charSequence;
            this.P.mNegativeButtonListener = onClickListener;
            return this;
        }

        public Builder setNeutralButton(int n, DialogInterface.OnClickListener onClickListener) {
            CharSequence charSequence;
            AlertController.AlertParams alertParams = this.P;
            alertParams.mNeutralButtonText = charSequence = this.P.mContext.getText(n);
            this.P.mNeutralButtonListener = onClickListener;
            return this;
        }

        public Builder setNeutralButton(CharSequence charSequence, DialogInterface.OnClickListener onClickListener) {
            this.P.mNeutralButtonText = charSequence;
            this.P.mNeutralButtonListener = onClickListener;
            return this;
        }

        public Builder setOnCancelListener(DialogInterface.OnCancelListener onCancelListener) {
            this.P.mOnCancelListener = onCancelListener;
            return this;
        }

        public Builder setOnItemSelectedListener(AdapterView.OnItemSelectedListener onItemSelectedListener) {
            this.P.mOnItemSelectedListener = onItemSelectedListener;
            return this;
        }

        public Builder setOnKeyListener(DialogInterface.OnKeyListener onKeyListener) {
            this.P.mOnKeyListener = onKeyListener;
            return this;
        }

        public Builder setPositiveButton(int n, DialogInterface.OnClickListener onClickListener) {
            CharSequence charSequence;
            AlertController.AlertParams alertParams = this.P;
            alertParams.mPositiveButtonText = charSequence = this.P.mContext.getText(n);
            this.P.mPositiveButtonListener = onClickListener;
            return this;
        }

        public Builder setPositiveButton(CharSequence charSequence, DialogInterface.OnClickListener onClickListener) {
            this.P.mPositiveButtonText = charSequence;
            this.P.mPositiveButtonListener = onClickListener;
            return this;
        }

        public Builder setRecycleOnMeasureEnabled(boolean bl) {
            this.P.mRecycleOnMeasure = bl;
            return this;
        }

        public Builder setSingleChoiceItems(int n, int n2, DialogInterface.OnClickListener onClickListener) {
            AlertController.AlertParams alertParams = this.P;
            CharSequence[] charSequenceArray = this.P.mContext.getResources().getTextArray(n);
            alertParams.mItems = charSequenceArray;
            this.P.mOnClickListener = onClickListener;
            this.P.mCheckedItem = n2;
            this.P.mIsSingleChoice = true;
            return this;
        }

        public Builder setSingleChoiceItems(Cursor cursor, int n, String string2, DialogInterface.OnClickListener onClickListener) {
            this.P.mCursor = cursor;
            this.P.mOnClickListener = onClickListener;
            this.P.mCheckedItem = n;
            this.P.mLabelColumn = string2;
            this.P.mIsSingleChoice = true;
            return this;
        }

        public Builder setSingleChoiceItems(ListAdapter listAdapter, int n, DialogInterface.OnClickListener onClickListener) {
            this.P.mAdapter = listAdapter;
            this.P.mOnClickListener = onClickListener;
            this.P.mCheckedItem = n;
            this.P.mIsSingleChoice = true;
            return this;
        }

        public Builder setSingleChoiceItems(CharSequence[] charSequenceArray, int n, DialogInterface.OnClickListener onClickListener) {
            this.P.mItems = charSequenceArray;
            this.P.mOnClickListener = onClickListener;
            this.P.mCheckedItem = n;
            this.P.mIsSingleChoice = true;
            return this;
        }

        public Builder setTitle(int n) {
            CharSequence charSequence;
            AlertController.AlertParams alertParams = this.P;
            alertParams.mTitle = charSequence = this.P.mContext.getText(n);
            return this;
        }

        public Builder setTitle(CharSequence charSequence) {
            this.P.mTitle = charSequence;
            return this;
        }

        public Builder setView(View view) {
            this.P.mView = view;
            this.P.mViewSpacingSpecified = false;
            return this;
        }

        public Builder setView(View view, int n, int n2, int n3, int n4) {
            this.P.mView = view;
            this.P.mViewSpacingSpecified = true;
            this.P.mViewSpacingLeft = n;
            this.P.mViewSpacingTop = n2;
            this.P.mViewSpacingRight = n3;
            this.P.mViewSpacingBottom = n4;
            return this;
        }

        public AlertDialog show() {
            AlertDialog alertDialog = this.create();
            alertDialog.show();
            return alertDialog;
        }
    }
}

