/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemProperties;
import android.provider.Settings;
import android.util.Printer;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ApplicationErrorReport
implements Parcelable {
    public static final Parcelable.Creator<ApplicationErrorReport> CREATOR = new Parcelable.Creator<ApplicationErrorReport>(){

        @Override
        public ApplicationErrorReport createFromParcel(Parcel parcel) {
            return new ApplicationErrorReport(parcel);
        }

        public ApplicationErrorReport[] newArray(int n) {
            return new ApplicationErrorReport[n];
        }
    };
    static final String DEFAULT_ERROR_RECEIVER_PROPERTY = "ro.error.receiver.default";
    static final String SYSTEM_APPS_ERROR_RECEIVER_PROPERTY = "ro.error.receiver.system.apps";
    public static final int TYPE_ANR = 2;
    public static final int TYPE_BATTERY = 3;
    public static final int TYPE_CRASH = 1;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_RUNNING_SERVICE = 5;
    public AnrInfo anrInfo;
    public BatteryInfo batteryInfo;
    public CrashInfo crashInfo;
    public String installerPackageName;
    public String packageName;
    public String processName;
    public RunningServiceInfo runningServiceInfo;
    public boolean systemApp;
    public long time;
    public int type;

    public ApplicationErrorReport() {
    }

    ApplicationErrorReport(Parcel parcel) {
        this.readFromParcel(parcel);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ComponentName getErrorReportReceiver(Context context, String string2, int n) {
        String string3;
        String string4;
        if (Settings.Secure.getInt(context.getContentResolver(), "send_action_app_error", 0) == 0) {
            return null;
        }
        PackageManager packageManager = context.getPackageManager();
        ComponentName componentName = ApplicationErrorReport.getErrorReportReceiver(packageManager, string2, string4 = packageManager.getInstallerPackageName(string2));
        if (componentName != null) {
            return componentName;
        }
        if ((n & 1) != 0 && (componentName = ApplicationErrorReport.getErrorReportReceiver(packageManager, string2, string3 = SystemProperties.get(SYSTEM_APPS_ERROR_RECEIVER_PROPERTY))) != null) {
            return componentName;
        }
        String string5 = SystemProperties.get(DEFAULT_ERROR_RECEIVER_PROPERTY);
        return ApplicationErrorReport.getErrorReportReceiver(packageManager, string2, string5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ComponentName getErrorReportReceiver(PackageManager packageManager, String string2, String string3) {
        if (string3 == null) return null;
        if (string3.length() == 0) {
            return null;
        }
        if (string3.equals(string2)) {
            return null;
        }
        Intent intent = new Intent("android.intent.action.APP_ERROR");
        Intent intent2 = intent.setPackage(string3);
        ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 0);
        if (resolveInfo == null) return null;
        if (resolveInfo.activityInfo == null) {
            return null;
        }
        String string4 = resolveInfo.activityInfo.name;
        return new ComponentName(string3, string4);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void dump(Printer printer, String string2) {
        StringBuilder stringBuilder = new StringBuilder().append(string2).append("type: ");
        int n = this.type;
        String string3 = stringBuilder.append(n).toString();
        printer.println(string3);
        StringBuilder stringBuilder2 = new StringBuilder().append(string2).append("packageName: ");
        String string4 = this.packageName;
        String string5 = stringBuilder2.append(string4).toString();
        printer.println(string5);
        StringBuilder stringBuilder3 = new StringBuilder().append(string2).append("installerPackageName: ");
        String string6 = this.installerPackageName;
        String string7 = stringBuilder3.append(string6).toString();
        printer.println(string7);
        StringBuilder stringBuilder4 = new StringBuilder().append(string2).append("processName: ");
        String string8 = this.processName;
        String string9 = stringBuilder4.append(string8).toString();
        printer.println(string9);
        StringBuilder stringBuilder5 = new StringBuilder().append(string2).append("time: ");
        long l = this.time;
        String string10 = stringBuilder5.append(l).toString();
        printer.println(string10);
        StringBuilder stringBuilder6 = new StringBuilder().append(string2).append("systemApp: ");
        boolean bl = this.systemApp;
        String string11 = stringBuilder6.append(bl).toString();
        printer.println(string11);
        switch (this.type) {
            default: {
                return;
            }
            case 1: {
                this.crashInfo.dump(printer, string2);
                return;
            }
            case 2: {
                this.anrInfo.dump(printer, string2);
                return;
            }
            case 3: 
        }
        this.batteryInfo.dump(printer, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void readFromParcel(Parcel parcel) {
        RunningServiceInfo runningServiceInfo;
        long l;
        String string2;
        String string3;
        String string4;
        int n;
        this.type = n = parcel.readInt();
        this.packageName = string4 = parcel.readString();
        this.installerPackageName = string3 = parcel.readString();
        this.processName = string2 = parcel.readString();
        this.time = l = parcel.readLong();
        boolean bl = parcel.readInt() == 1;
        this.systemApp = bl;
        switch (this.type) {
            default: {
                return;
            }
            case 1: {
                CrashInfo crashInfo;
                this.crashInfo = crashInfo = new CrashInfo(parcel);
                this.anrInfo = null;
                this.batteryInfo = null;
                this.runningServiceInfo = null;
                return;
            }
            case 2: {
                AnrInfo anrInfo;
                this.anrInfo = anrInfo = new AnrInfo(parcel);
                this.crashInfo = null;
                this.batteryInfo = null;
                this.runningServiceInfo = null;
                return;
            }
            case 3: {
                BatteryInfo batteryInfo;
                this.batteryInfo = batteryInfo = new BatteryInfo(parcel);
                this.anrInfo = null;
                this.crashInfo = null;
                this.runningServiceInfo = null;
                return;
            }
            case 5: 
        }
        this.batteryInfo = null;
        this.anrInfo = null;
        this.crashInfo = null;
        this.runningServiceInfo = runningServiceInfo = new RunningServiceInfo(parcel);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = this.type;
        parcel.writeInt(n2);
        String string2 = this.packageName;
        parcel.writeString(string2);
        String string3 = this.installerPackageName;
        parcel.writeString(string3);
        String string4 = this.processName;
        parcel.writeString(string4);
        long l = this.time;
        parcel.writeLong(l);
        int n3 = this.systemApp ? 1 : 0;
        parcel.writeInt(n3);
        switch (this.type) {
            default: {
                return;
            }
            case 1: {
                this.crashInfo.writeToParcel(parcel, n);
                return;
            }
            case 2: {
                this.anrInfo.writeToParcel(parcel, n);
                return;
            }
            case 3: {
                this.batteryInfo.writeToParcel(parcel, n);
                return;
            }
            case 5: 
        }
        this.runningServiceInfo.writeToParcel(parcel, n);
    }

    public static class RunningServiceInfo {
        public long durationMillis;
        public String serviceDetails;

        public RunningServiceInfo() {
        }

        public RunningServiceInfo(Parcel parcel) {
            String string2;
            long l;
            this.durationMillis = l = parcel.readLong();
            this.serviceDetails = string2 = parcel.readString();
        }

        public void dump(Printer printer, String string2) {
            StringBuilder stringBuilder = new StringBuilder().append(string2).append("durationMillis: ");
            long l = this.durationMillis;
            String string3 = stringBuilder.append(l).toString();
            printer.println(string3);
            StringBuilder stringBuilder2 = new StringBuilder().append(string2).append("serviceDetails: ");
            String string4 = this.serviceDetails;
            String string5 = stringBuilder2.append(string4).toString();
            printer.println(string5);
        }

        public void writeToParcel(Parcel parcel, int n) {
            long l = this.durationMillis;
            parcel.writeLong(l);
            String string2 = this.serviceDetails;
            parcel.writeString(string2);
        }
    }

    public static class BatteryInfo {
        public String checkinDetails;
        public long durationMicros;
        public String usageDetails;
        public int usagePercent;

        public BatteryInfo() {
        }

        public BatteryInfo(Parcel parcel) {
            String string2;
            String string3;
            long l;
            int n;
            this.usagePercent = n = parcel.readInt();
            this.durationMicros = l = parcel.readLong();
            this.usageDetails = string3 = parcel.readString();
            this.checkinDetails = string2 = parcel.readString();
        }

        public void dump(Printer printer, String string2) {
            StringBuilder stringBuilder = new StringBuilder().append(string2).append("usagePercent: ");
            int n = this.usagePercent;
            String string3 = stringBuilder.append(n).toString();
            printer.println(string3);
            StringBuilder stringBuilder2 = new StringBuilder().append(string2).append("durationMicros: ");
            long l = this.durationMicros;
            String string4 = stringBuilder2.append(l).toString();
            printer.println(string4);
            StringBuilder stringBuilder3 = new StringBuilder().append(string2).append("usageDetails: ");
            String string5 = this.usageDetails;
            String string6 = stringBuilder3.append(string5).toString();
            printer.println(string6);
            StringBuilder stringBuilder4 = new StringBuilder().append(string2).append("checkinDetails: ");
            String string7 = this.checkinDetails;
            String string8 = stringBuilder4.append(string7).toString();
            printer.println(string8);
        }

        public void writeToParcel(Parcel parcel, int n) {
            int n2 = this.usagePercent;
            parcel.writeInt(n2);
            long l = this.durationMicros;
            parcel.writeLong(l);
            String string2 = this.usageDetails;
            parcel.writeString(string2);
            String string3 = this.checkinDetails;
            parcel.writeString(string3);
        }
    }

    public static class AnrInfo {
        public String activity;
        public String cause;
        public String info;

        public AnrInfo() {
        }

        public AnrInfo(Parcel parcel) {
            String string2;
            String string3;
            String string4;
            this.activity = string4 = parcel.readString();
            this.cause = string3 = parcel.readString();
            this.info = string2 = parcel.readString();
        }

        public void dump(Printer printer, String string2) {
            StringBuilder stringBuilder = new StringBuilder().append(string2).append("activity: ");
            String string3 = this.activity;
            String string4 = stringBuilder.append(string3).toString();
            printer.println(string4);
            StringBuilder stringBuilder2 = new StringBuilder().append(string2).append("cause: ");
            String string5 = this.cause;
            String string6 = stringBuilder2.append(string5).toString();
            printer.println(string6);
            StringBuilder stringBuilder3 = new StringBuilder().append(string2).append("info: ");
            String string7 = this.info;
            String string8 = stringBuilder3.append(string7).toString();
            printer.println(string8);
        }

        public void writeToParcel(Parcel parcel, int n) {
            String string2 = this.activity;
            parcel.writeString(string2);
            String string3 = this.cause;
            parcel.writeString(string3);
            String string4 = this.info;
            parcel.writeString(string4);
        }
    }

    public static class CrashInfo {
        public String exceptionClassName;
        public String exceptionMessage;
        public String stackTrace;
        public String throwClassName;
        public String throwFileName;
        public int throwLineNumber;
        public String throwMethodName;

        public CrashInfo() {
        }

        public CrashInfo(Parcel parcel) {
            String string2;
            int n;
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            this.exceptionClassName = string7 = parcel.readString();
            this.exceptionMessage = string6 = parcel.readString();
            this.throwFileName = string5 = parcel.readString();
            this.throwClassName = string4 = parcel.readString();
            this.throwMethodName = string3 = parcel.readString();
            this.throwLineNumber = n = parcel.readInt();
            this.stackTrace = string2 = parcel.readString();
        }

        public CrashInfo(Throwable throwable) {
            int n;
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            this.stackTrace = string7 = stringWriter.toString();
            this.exceptionMessage = string6 = throwable.getMessage();
            while (throwable.getCause() != null) {
                String string8 = (throwable = throwable.getCause()).getMessage();
                if (string8 == null || string8.length() <= 0) continue;
                this.exceptionMessage = string8;
            }
            this.exceptionClassName = string5 = throwable.getClass().getName();
            StackTraceElement stackTraceElement = throwable.getStackTrace()[0];
            this.throwFileName = string4 = stackTraceElement.getFileName();
            this.throwClassName = string3 = stackTraceElement.getClassName();
            this.throwMethodName = string2 = stackTraceElement.getMethodName();
            this.throwLineNumber = n = stackTraceElement.getLineNumber();
        }

        public void dump(Printer printer, String string2) {
            StringBuilder stringBuilder = new StringBuilder().append(string2).append("exceptionClassName: ");
            String string3 = this.exceptionClassName;
            String string4 = stringBuilder.append(string3).toString();
            printer.println(string4);
            StringBuilder stringBuilder2 = new StringBuilder().append(string2).append("exceptionMessage: ");
            String string5 = this.exceptionMessage;
            String string6 = stringBuilder2.append(string5).toString();
            printer.println(string6);
            StringBuilder stringBuilder3 = new StringBuilder().append(string2).append("throwFileName: ");
            String string7 = this.throwFileName;
            String string8 = stringBuilder3.append(string7).toString();
            printer.println(string8);
            StringBuilder stringBuilder4 = new StringBuilder().append(string2).append("throwClassName: ");
            String string9 = this.throwClassName;
            String string10 = stringBuilder4.append(string9).toString();
            printer.println(string10);
            StringBuilder stringBuilder5 = new StringBuilder().append(string2).append("throwMethodName: ");
            String string11 = this.throwMethodName;
            String string12 = stringBuilder5.append(string11).toString();
            printer.println(string12);
            StringBuilder stringBuilder6 = new StringBuilder().append(string2).append("throwLineNumber: ");
            int n = this.throwLineNumber;
            String string13 = stringBuilder6.append(n).toString();
            printer.println(string13);
            StringBuilder stringBuilder7 = new StringBuilder().append(string2).append("stackTrace: ");
            String string14 = this.stackTrace;
            String string15 = stringBuilder7.append(string14).toString();
            printer.println(string15);
        }

        public void writeToParcel(Parcel parcel, int n) {
            String string2 = this.exceptionClassName;
            parcel.writeString(string2);
            String string3 = this.exceptionMessage;
            parcel.writeString(string3);
            String string4 = this.throwFileName;
            parcel.writeString(string4);
            String string5 = this.throwClassName;
            parcel.writeString(string5);
            String string6 = this.throwMethodName;
            parcel.writeString(string6);
            int n2 = this.throwLineNumber;
            parcel.writeInt(n2);
            String string7 = this.stackTrace;
            parcel.writeString(string7);
        }
    }
}

