/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.accounts.AccountManager;
import android.accounts.IAccountManager;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.AlarmManager;
import android.app.DownloadManager;
import android.app.IActivityManager;
import android.app.IAlarmManager;
import android.app.IServiceConnection;
import android.app.Instrumentation;
import android.app.KeyguardManager;
import android.app.LoadedApk;
import android.app.NotificationManager;
import android.app.QueuedWork;
import android.app.ReceiverRestrictedContext;
import android.app.SearchManager;
import android.app.StatusBarManager;
import android.app.UiModeManager;
import android.app.WallpaperManager;
import android.app.admin.DevicePolicyManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.IContentProvider;
import android.content.IIntentReceiver;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageDeleteObserver;
import android.content.pm.IPackageInstallObserver;
import android.content.pm.IPackageManager;
import android.content.pm.IPackageMoveObserver;
import android.content.pm.IPackageStatsObserver;
import android.content.pm.InstrumentationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.AssetManager;
import android.content.res.CompatibilityInfo;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.hardware.SensorManager;
import android.location.ILocationManager;
import android.location.LocationManager;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.IConnectivityManager;
import android.net.IThrottleManager;
import android.net.ThrottleManager;
import android.net.Uri;
import android.net.wifi.IWifiManager;
import android.net.wifi.WifiManager;
import android.nfc.NfcManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.DropBoxManager;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IBinder;
import android.os.IPowerManager;
import android.os.Looper;
import android.os.PowerManager;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.Vibrator;
import android.os.storage.StorageManager;
import android.telephony.TelephonyManager;
import android.text.ClipboardManager;
import android.util.AndroidRuntimeException;
import android.util.Log;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.WindowManagerImpl;
import android.view.accessibility.AccessibilityManager;
import android.view.inputmethod.InputMethodManager;
import com.android.internal.os.IDropBoxManagerService;
import com.android.internal.policy.PolicyManager;
import com.android.internal.util.XmlUtils;
import com.google.android.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import org.xmlpull.v1.XmlPullParserException;

class ContextImpl
extends Context {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_ICONS = false;
    private static final String[] EMPTY_FILE_LIST;
    private static final String TAG = "ApplicationContext";
    private static AlarmManager sAlarmManager;
    private static ConnectivityManager sConnectivityManager;
    private static long sInstanceCount;
    private static LocationManager sLocationManager;
    private static PowerManager sPowerManager;
    private static final HashMap<String, SharedPreferencesImpl> sSharedPrefs;
    private static final Object sSync;
    private static ThrottleManager sThrottleManager;
    private static WifiManager sWifiManager;
    private AccountManager mAccountManager;
    private ActivityManager mActivityManager = null;
    private IBinder mActivityToken = null;
    private AudioManager mAudioManager;
    private File mCacheDir;
    private ClipboardManager mClipboardManager = null;
    private ApplicationContentResolver mContentResolver;
    private File mDatabasesDir;
    private DevicePolicyManager mDevicePolicyManager = null;
    private DownloadManager mDownloadManager = null;
    private DropBoxManager mDropBoxManager = null;
    private File mExternalCacheDir;
    private File mExternalFilesDir;
    private File mFilesDir;
    private LayoutInflater mLayoutInflater = null;
    ActivityThread mMainThread;
    private NfcManager mNfcManager = null;
    private NotificationManager mNotificationManager = null;
    private Context mOuterContext;
    LoadedApk mPackageInfo;
    private PackageManager mPackageManager;
    private File mPreferencesDir;
    private Context mReceiverRestrictedContext = null;
    private Resources mResources;
    private boolean mRestricted;
    private SearchManager mSearchManager = null;
    private SensorManager mSensorManager = null;
    private StatusBarManager mStatusBarManager = null;
    private StorageManager mStorageManager = null;
    private final Object mSync;
    private TelephonyManager mTelephonyManager = null;
    private Resources.Theme mTheme = null;
    private int mThemeResource = 0;
    private UiModeManager mUiModeManager = null;
    private Vibrator mVibrator = null;
    private WallpaperManager mWallpaperManager = null;

    static {
        sSync = new Object();
        sSharedPrefs = new HashMap();
        sInstanceCount = 0L;
        EMPTY_FILE_LIST = new String[0];
    }

    ContextImpl() {
        Object object;
        this.mSync = object = new Object();
        this.mOuterContext = this;
    }

    public ContextImpl(ContextImpl contextImpl) {
        ApplicationContentResolver applicationContentResolver;
        ActivityThread activityThread;
        Resources resources;
        LoadedApk loadedApk;
        Object object;
        this.mSync = object = new Object();
        ++sInstanceCount;
        this.mPackageInfo = loadedApk = contextImpl.mPackageInfo;
        this.mResources = resources = contextImpl.mResources;
        this.mMainThread = activityThread = contextImpl.mMainThread;
        this.mContentResolver = applicationContentResolver = contextImpl.mContentResolver;
        this.mOuterContext = this;
    }

    static DropBoxManager createDropBoxManager() {
        IDropBoxManagerService iDropBoxManagerService = IDropBoxManagerService.Stub.asInterface(ServiceManager.getService("dropbox"));
        return new DropBoxManager(iDropBoxManagerService);
    }

    static ContextImpl createSystemContext(ActivityThread activityThread) {
        ContextImpl contextImpl = new ContextImpl();
        Resources resources = Resources.getSystem();
        contextImpl.init(resources, activityThread);
        return contextImpl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void enforce(String string2, int n, boolean bl, int n2, String string3) {
        if (n == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = string3 != null ? string3 + ": " : "";
        StringBuilder stringBuilder2 = stringBuilder.append(string4);
        String string5 = bl ? "Neither user " + n2 + " nor current process has " : "User " + n2 + " does not have ";
        String string6 = stringBuilder2.append(string5).append(string2).append(".").toString();
        SecurityException securityException = new SecurityException(string6);
        throw securityException;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void enforceForUri(int n, int n2, boolean bl, int n3, Uri uri, String string2) {
        if (n2 == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = string2 != null ? string2 + ": " : "";
        StringBuilder stringBuilder2 = stringBuilder.append(string3);
        String string4 = bl ? "Neither user " + n3 + " nor current process has " : "User " + n3 + " does not have ";
        StringBuilder stringBuilder3 = stringBuilder2.append(string4);
        String string5 = this.uriModeFlagToString(n);
        String string6 = stringBuilder3.append(string5).append(" permission on ").append(uri).append(".").toString();
        SecurityException securityException = new SecurityException(string6);
        throw securityException;
    }

    private AccountManager getAccountManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mAccountManager == null) {
                AccountManager accountManager;
                IAccountManager iAccountManager = IAccountManager.Stub.asInterface(ServiceManager.getService("account"));
                this.mAccountManager = accountManager = new AccountManager(this, iAccountManager);
            }
            AccountManager accountManager = this.mAccountManager;
            return accountManager;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ActivityManager getActivityManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mActivityManager == null) {
                ActivityManager activityManager;
                Context context = this.getOuterContext();
                Handler handler = this.mMainThread.getHandler();
                this.mActivityManager = activityManager = new ActivityManager(context, handler);
            }
            return this.mActivityManager;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AlarmManager getAlarmManager() {
        Object object = sSync;
        synchronized (object) {
            if (sAlarmManager == null) {
                IAlarmManager iAlarmManager = IAlarmManager.Stub.asInterface(ServiceManager.getService("alarm"));
                sAlarmManager = new AlarmManager(iAlarmManager);
            }
            return sAlarmManager;
        }
    }

    private AudioManager getAudioManager() {
        if (this.mAudioManager == null) {
            AudioManager audioManager;
            this.mAudioManager = audioManager = new AudioManager(this);
        }
        return this.mAudioManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ClipboardManager getClipboardManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mClipboardManager == null) {
                ClipboardManager clipboardManager;
                Context context = this.getOuterContext();
                Handler handler = this.mMainThread.getHandler();
                this.mClipboardManager = clipboardManager = new ClipboardManager(context, handler);
            }
            return this.mClipboardManager;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ConnectivityManager getConnectivityManager() {
        Object object = sSync;
        synchronized (object) {
            if (sConnectivityManager == null) {
                IConnectivityManager iConnectivityManager = IConnectivityManager.Stub.asInterface(ServiceManager.getService("connectivity"));
                sConnectivityManager = new ConnectivityManager(iConnectivityManager);
            }
            return sConnectivityManager;
        }
    }

    private File getDataDirFile() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getDataDirFile();
        }
        throw new RuntimeException("Not supported in system context");
    }

    private File getDatabasesDir() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mDatabasesDir == null) {
                File file;
                File file2 = this.getDataDirFile();
                this.mDatabasesDir = file = new File(file2, "databases");
            }
            if (this.mDatabasesDir.getPath().equals("databases")) {
                File file;
                this.mDatabasesDir = file = new File("/data/system");
            }
            File file = this.mDatabasesDir;
            return file;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DevicePolicyManager getDevicePolicyManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mDevicePolicyManager == null) {
                DevicePolicyManager devicePolicyManager;
                Handler handler = this.mMainThread.getHandler();
                this.mDevicePolicyManager = devicePolicyManager = DevicePolicyManager.create(this, handler);
            }
            return this.mDevicePolicyManager;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DownloadManager getDownloadManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mDownloadManager == null) {
                DownloadManager downloadManager;
                ContentResolver contentResolver = this.getContentResolver();
                String string2 = this.getPackageName();
                this.mDownloadManager = downloadManager = new DownloadManager(contentResolver, string2);
            }
            return this.mDownloadManager;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DropBoxManager getDropBoxManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mDropBoxManager == null) {
                DropBoxManager dropBoxManager;
                this.mDropBoxManager = dropBoxManager = ContextImpl.createDropBoxManager();
            }
            return this.mDropBoxManager;
        }
    }

    public static long getInstanceCount() {
        return sInstanceCount;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LocationManager getLocationManager() {
        Object object = sSync;
        synchronized (object) {
            if (sLocationManager == null) {
                ILocationManager iLocationManager = ILocationManager.Stub.asInterface(ServiceManager.getService("location"));
                sLocationManager = new LocationManager(iLocationManager);
            }
            return sLocationManager;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NfcManager getNfcManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mNfcManager == null) {
                NfcManager nfcManager;
                this.mNfcManager = nfcManager = new NfcManager(this);
            }
            return this.mNfcManager;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NotificationManager getNotificationManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mNotificationManager == null) {
                NotificationManager notificationManager;
                Context context = this.getOuterContext();
                ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper(context, 16973835);
                Handler handler = this.mMainThread.getHandler();
                this.mNotificationManager = notificationManager = new NotificationManager(contextThemeWrapper, handler);
            }
            return this.mNotificationManager;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PowerManager getPowerManager() {
        Object object = sSync;
        synchronized (object) {
            if (sPowerManager == null) {
                IPowerManager iPowerManager = IPowerManager.Stub.asInterface(ServiceManager.getService("power"));
                Handler handler = this.mMainThread.getHandler();
                sPowerManager = new PowerManager(iPowerManager, handler);
            }
            return sPowerManager;
        }
    }

    private File getPreferencesDir() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mPreferencesDir == null) {
                File file;
                File file2 = this.getDataDirFile();
                this.mPreferencesDir = file = new File(file2, "shared_prefs");
            }
            File file = this.mPreferencesDir;
            return file;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SearchManager getSearchManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mSearchManager == null) {
                SearchManager searchManager;
                Context context = this.getOuterContext();
                Handler handler = this.mMainThread.getHandler();
                this.mSearchManager = searchManager = new SearchManager(context, handler);
            }
            return this.mSearchManager;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SensorManager getSensorManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mSensorManager == null) {
                SensorManager sensorManager;
                Looper looper = this.mMainThread.getHandler().getLooper();
                this.mSensorManager = sensorManager = new SensorManager(looper);
            }
            return this.mSensorManager;
        }
    }

    private StorageManager getStorageManager() {
        Object object = this.mSync;
        synchronized (object) {
            block7: {
                StorageManager storageManager;
                StorageManager storageManager2 = this.mStorageManager;
                if (storageManager2 != null) break block7;
                Looper looper = this.mMainThread.getHandler().getLooper();
                this.mStorageManager = storageManager = new StorageManager(looper);
                return this.mStorageManager;
            }
            finally {
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TelephonyManager getTelephonyManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mTelephonyManager == null) {
                TelephonyManager telephonyManager;
                Context context = this.getOuterContext();
                this.mTelephonyManager = telephonyManager = new TelephonyManager(context);
            }
            return this.mTelephonyManager;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ThrottleManager getThrottleManager() {
        Object object = sSync;
        synchronized (object) {
            if (sThrottleManager == null) {
                IThrottleManager iThrottleManager = IThrottleManager.Stub.asInterface(ServiceManager.getService("throttle"));
                sThrottleManager = new ThrottleManager(iThrottleManager);
            }
            return sThrottleManager;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private UiModeManager getUiModeManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mUiModeManager == null) {
                UiModeManager uiModeManager;
                this.mUiModeManager = uiModeManager = new UiModeManager();
            }
            return this.mUiModeManager;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vibrator getVibrator() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mVibrator == null) {
                Vibrator vibrator;
                this.mVibrator = vibrator = new Vibrator();
            }
            return this.mVibrator;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private WallpaperManager getWallpaperManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mWallpaperManager == null) {
                WallpaperManager wallpaperManager;
                Context context = this.getOuterContext();
                Handler handler = this.mMainThread.getHandler();
                this.mWallpaperManager = wallpaperManager = new WallpaperManager(context, handler);
            }
            return this.mWallpaperManager;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private WifiManager getWifiManager() {
        Object object = sSync;
        synchronized (object) {
            if (sWifiManager == null) {
                IWifiManager iWifiManager = IWifiManager.Stub.asInterface(ServiceManager.getService("wifi"));
                Handler handler = this.mMainThread.getHandler();
                sWifiManager = new WifiManager(iWifiManager, handler);
            }
            return sWifiManager;
        }
    }

    private static File makeBackupFile(File file) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = file.getPath();
        String string3 = stringBuilder.append(string2).append(".bak").toString();
        return new File(string3);
    }

    private File makeFilename(File file, String string2) {
        char c = File.separatorChar;
        if (string2.indexOf(c) < 0) {
            return new File(file, string2);
        }
        String string3 = "File " + string2 + " contains a path separator";
        throw new IllegalArgumentException(string3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Intent registerReceiverInternal(BroadcastReceiver broadcastReceiver, IntentFilter intentFilter, String string2, Handler handler, Context context) {
        IIntentReceiver iIntentReceiver = null;
        if (broadcastReceiver != null) {
            if (this.mPackageInfo != null && context != null) {
                if (handler == null) {
                    handler = this.mMainThread.getHandler();
                }
                LoadedApk loadedApk = this.mPackageInfo;
                Instrumentation instrumentation = this.mMainThread.getInstrumentation();
                BroadcastReceiver broadcastReceiver2 = broadcastReceiver;
                Context context2 = context;
                Handler handler2 = handler;
                iIntentReceiver = loadedApk.getReceiverDispatcher(broadcastReceiver2, context2, handler2, instrumentation, true);
            } else {
                if (handler == null) {
                    handler = this.mMainThread.getHandler();
                }
                BroadcastReceiver broadcastReceiver3 = broadcastReceiver;
                Context context3 = context;
                Handler handler3 = handler;
                Instrumentation instrumentation = null;
                iIntentReceiver = new LoadedApk.ReceiverDispatcher(broadcastReceiver3, context3, handler3, instrumentation, true).getIIntentReceiver();
            }
        }
        try {
            IActivityManager iActivityManager = ActivityManagerNative.getDefault();
            ActivityThread.ApplicationThread applicationThread = this.mMainThread.getApplicationThread();
            Intent intent = iActivityManager.registerReceiver(applicationThread, iIntentReceiver, intentFilter, string2);
            return intent;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    private static void setFilePermissionsFromMode(String string2, int n, int n2) {
        int n3 = n2 | 0x1B0;
        if ((n & 1) != 0) {
            n3 |= 4;
        }
        if ((n & 2) != 0) {
            n3 |= 2;
        }
        int n4 = FileUtils.setPermissions(string2, n3, -1, -1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String uriModeFlagToString(int n) {
        switch (n) {
            default: {
                String string2 = "Unknown permission mode flags: " + n;
                throw new IllegalArgumentException(string2);
            }
            case 3: {
                return "read and write";
            }
            case 1: {
                return "read";
            }
            case 2: 
        }
        return "write";
    }

    /*
     * Enabled aggressive block sorting
     */
    private File validateFilePath(String string2, boolean bl) {
        File file;
        File file2;
        char c;
        char c2 = string2.charAt(0);
        if (c2 != (c = File.separatorChar)) {
            char c3 = File.separatorChar;
            int n = string2.lastIndexOf(c3);
            String string3 = string2.substring(0, n);
            file2 = new File(string3);
            char c4 = File.separatorChar;
            int n2 = string2.lastIndexOf(c4);
            String string4 = string2.substring(n2);
            file = new File(file2, string4);
        } else {
            file2 = this.getDatabasesDir();
            file = this.makeFilename(file2, string2);
        }
        if (bl && !file2.isDirectory() && file2.mkdir()) {
            int n = FileUtils.setPermissions(file2.getPath(), 505, -1, -1);
        }
        return file;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean bindService(Intent intent, ServiceConnection serviceConnection, int n) {
        int n2;
        if (this.mPackageInfo == null) throw new RuntimeException("Not supported in system context");
        LoadedApk loadedApk = this.mPackageInfo;
        Context context = this.getOuterContext();
        Handler handler = this.mMainThread.getHandler();
        IServiceConnection iServiceConnection = loadedApk.getServiceDispatcher(serviceConnection, context, handler, n);
        try {
            IActivityManager iActivityManager = ActivityManagerNative.getDefault();
            ActivityThread.ApplicationThread applicationThread = this.mMainThread.getApplicationThread();
            IBinder iBinder = this.getActivityToken();
            ContentResolver contentResolver = this.getContentResolver();
            String string2 = intent.resolveTypeIfNeeded(contentResolver);
            Intent intent2 = intent;
            int n3 = n;
            n2 = iActivityManager.bindService(applicationThread, iBinder, intent2, string2, iServiceConnection, n3);
            if (n2 < 0) {
                String string3 = "Not allowed to bind to service " + intent;
                throw new SecurityException(string3);
            }
        }
        catch (RemoteException remoteException) {
            return false;
        }
        if (n2 == 0) return false;
        return true;
    }

    @Override
    public int checkCallingOrSelfPermission(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("permission is null");
        }
        int n = Binder.getCallingPid();
        int n2 = Binder.getCallingUid();
        return this.checkPermission(string2, n, n2);
    }

    @Override
    public int checkCallingOrSelfUriPermission(Uri uri, int n) {
        int n2 = Binder.getCallingPid();
        int n3 = Binder.getCallingUid();
        return this.checkUriPermission(uri, n2, n3, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int checkCallingPermission(String string2) {
        int n;
        if (string2 == null) {
            throw new IllegalArgumentException("permission is null");
        }
        if (!Process.supportsProcesses()) {
            return 0;
        }
        int n2 = Binder.getCallingPid();
        if (n2 == (n = Process.myPid())) return -1;
        int n3 = Binder.getCallingUid();
        return this.checkPermission(string2, n2, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int checkCallingUriPermission(Uri uri, int n) {
        int n2;
        if (!Process.supportsProcesses()) {
            return 0;
        }
        int n3 = Binder.getCallingPid();
        if (n3 == (n2 = Process.myPid())) return -1;
        int n4 = Binder.getCallingUid();
        return this.checkUriPermission(uri, n3, n4, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int checkPermission(String string2, int n, int n2) {
        if (string2 == null) {
            throw new IllegalArgumentException("permission is null");
        }
        if (!Process.supportsProcesses()) {
            return 0;
        }
        try {
            int n3 = ActivityManagerNative.getDefault().checkPermission(string2, n, n2);
            return n3;
        }
        catch (RemoteException remoteException) {
            return -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int checkUriPermission(Uri uri, int n, int n2, int n3) {
        if (!Process.supportsProcesses()) {
            return 0;
        }
        try {
            int n4 = ActivityManagerNative.getDefault().checkUriPermission(uri, n, n2, n3);
            return n4;
        }
        catch (RemoteException remoteException) {
            return -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int checkUriPermission(Uri uri, String string2, String string3, int n, int n2, int n3) {
        if ((n3 & 1) != 0) {
            if (string2 == null) return 0;
            if (this.checkPermission(string2, n, n2) == 0) {
                return 0;
            }
        }
        if ((n3 & 2) != 0) {
            if (string3 == null) return 0;
            if (this.checkPermission(string3, n, n2) == 0) {
                return 0;
            }
        }
        if (uri == null) return -1;
        return this.checkUriPermission(uri, n, n2, n3);
    }

    @Override
    public void clearWallpaper() throws IOException {
        this.getWallpaperManager().clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Context createPackageContext(String string2, int n) throws PackageManager.NameNotFoundException {
        if (string2.equals("system") || string2.equals("android")) {
            ContextImpl contextImpl = this.mMainThread.getSystemContext();
            return new ContextImpl(contextImpl);
        }
        LoadedApk loadedApk = this.mMainThread.getPackageInfo(string2, n);
        if (loadedApk != null) {
            ContextImpl contextImpl = new ContextImpl();
            boolean bl = (n & 4) == 4;
            contextImpl.mRestricted = bl;
            ActivityThread activityThread = this.mMainThread;
            Resources resources = this.mResources;
            contextImpl.init(loadedApk, null, activityThread, resources);
            if (contextImpl.mResources != null) {
                return contextImpl;
            }
        }
        String string3 = "Application package " + string2 + " not found";
        throw new PackageManager.NameNotFoundException(string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String[] databaseList() {
        String[] stringArray = this.getDatabasesDir().list();
        if (stringArray == null) return EMPTY_FILE_LIST;
        return stringArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean deleteDatabase(String string2) {
        try {
            boolean bl = this.validateFilePath(string2, false).delete();
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean deleteFile(String string2) {
        File file = this.getFilesDir();
        return this.makeFilename(file, string2).delete();
    }

    @Override
    public void enforceCallingOrSelfPermission(String string2, String string3) {
        int n = this.checkCallingOrSelfPermission(string2);
        int n2 = Binder.getCallingUid();
        ContextImpl contextImpl = this;
        String string4 = string2;
        String string5 = string3;
        contextImpl.enforce(string4, n, true, n2, string5);
    }

    @Override
    public void enforceCallingOrSelfUriPermission(Uri uri, int n, String string2) {
        int n2 = this.checkCallingOrSelfUriPermission(uri, n);
        int n3 = Binder.getCallingUid();
        ContextImpl contextImpl = this;
        int n4 = n;
        Uri uri2 = uri;
        String string3 = string2;
        contextImpl.enforceForUri(n4, n2, true, n3, uri2, string3);
    }

    @Override
    public void enforceCallingPermission(String string2, String string3) {
        int n = this.checkCallingPermission(string2);
        int n2 = Binder.getCallingUid();
        ContextImpl contextImpl = this;
        String string4 = string2;
        String string5 = string3;
        contextImpl.enforce(string4, n, false, n2, string5);
    }

    @Override
    public void enforceCallingUriPermission(Uri uri, int n, String string2) {
        int n2 = this.checkCallingUriPermission(uri, n);
        int n3 = Binder.getCallingUid();
        ContextImpl contextImpl = this;
        int n4 = n;
        Uri uri2 = uri;
        String string3 = string2;
        contextImpl.enforceForUri(n4, n2, false, n3, uri2, string3);
    }

    @Override
    public void enforcePermission(String string2, int n, int n2, String string3) {
        int n3 = this.checkPermission(string2, n, n2);
        ContextImpl contextImpl = this;
        String string4 = string2;
        int n4 = n2;
        String string5 = string3;
        contextImpl.enforce(string4, n3, false, n4, string5);
    }

    @Override
    public void enforceUriPermission(Uri uri, int n, int n2, int n3, String string2) {
        int n4 = this.checkUriPermission(uri, n, n2, n3);
        ContextImpl contextImpl = this;
        int n5 = n3;
        int n6 = n2;
        Uri uri2 = uri;
        String string3 = string2;
        contextImpl.enforceForUri(n5, n4, false, n6, uri2, string3);
    }

    @Override
    public void enforceUriPermission(Uri uri, String string2, String string3, int n, int n2, int n3, String string4) {
        int n4 = this.checkUriPermission(uri, string2, string3, n, n2, n3);
        ContextImpl contextImpl = this;
        int n5 = n3;
        int n6 = n2;
        Uri uri2 = uri;
        String string5 = string4;
        contextImpl.enforceForUri(n5, n4, false, n6, uri2, string5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String[] fileList() {
        String[] stringArray = this.getFilesDir().list();
        if (stringArray == null) return EMPTY_FILE_LIST;
        return stringArray;
    }

    final IBinder getActivityToken() {
        return this.mActivityToken;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Context getApplicationContext() {
        if (this.mPackageInfo == null) return this.mMainThread.getApplication();
        return this.mPackageInfo.getApplication();
    }

    @Override
    public ApplicationInfo getApplicationInfo() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getApplicationInfo();
        }
        throw new RuntimeException("Not supported in system context");
    }

    @Override
    public AssetManager getAssets() {
        return this.mResources.getAssets();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File getCacheDir() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mCacheDir == null) {
                File file;
                File file2 = this.getDataDirFile();
                this.mCacheDir = file = new File(file2, "cache");
            }
            if (this.mCacheDir.exists()) return this.mCacheDir;
            if (!this.mCacheDir.mkdirs()) {
                int n = Log.w(TAG, "Unable to create cache directory");
                return null;
            }
            int n = FileUtils.setPermissions(this.mCacheDir.getPath(), 505, -1, -1);
            return this.mCacheDir;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ClassLoader getClassLoader() {
        if (this.mPackageInfo == null) return ClassLoader.getSystemClassLoader();
        return this.mPackageInfo.getClassLoader();
    }

    @Override
    public ContentResolver getContentResolver() {
        return this.mContentResolver;
    }

    @Override
    public File getDatabasePath(String string2) {
        return this.validateFilePath(string2, false);
    }

    @Override
    public File getDir(String string2, int n) {
        String string3 = "app_" + string2;
        File file = this.getDataDirFile();
        File file2 = this.makeFilename(file, string3);
        if (!file2.exists()) {
            boolean bl = file2.mkdir();
            ContextImpl.setFilePermissionsFromMode(file2.getPath(), n, 505);
        }
        return file2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File getExternalCacheDir() {
        Object object = this.mSync;
        synchronized (object) {
            boolean bl;
            if (this.mExternalCacheDir == null) {
                File file;
                this.mExternalCacheDir = file = Environment.getExternalStorageAppCacheDirectory(this.getPackageName());
            }
            if (!(bl = this.mExternalCacheDir.exists())) {
                try {
                    File file = Environment.getExternalStorageAndroidDataDir();
                    boolean bl2 = new File(file, ".nomedia").createNewFile();
                }
                catch (IOException iOException) {}
                if (!this.mExternalCacheDir.mkdirs()) {
                    int n = Log.w(TAG, "Unable to create external cache directory");
                    return null;
                }
            }
            File file = this.mExternalCacheDir;
            return file;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File getExternalFilesDir(String string2) {
        Object object = this.mSync;
        synchronized (object) {
            boolean bl;
            if (this.mExternalFilesDir == null) {
                File file;
                this.mExternalFilesDir = file = Environment.getExternalStorageAppFilesDirectory(this.getPackageName());
            }
            if (!(bl = this.mExternalFilesDir.exists())) {
                try {
                    File file = Environment.getExternalStorageAndroidDataDir();
                    boolean bl2 = new File(file, ".nomedia").createNewFile();
                }
                catch (IOException iOException) {}
                if (!this.mExternalFilesDir.mkdirs()) {
                    int n = Log.w(TAG, "Unable to create external files directory");
                    return null;
                }
            }
            if (string2 == null) {
                File file = this.mExternalFilesDir;
                return file;
            }
            File file = this.mExternalFilesDir;
            File file2 = new File(file, string2);
            if (file2.exists()) return file2;
            if (file2.mkdirs()) return file2;
            String string3 = "Unable to create external media directory " + file2;
            int n = Log.w(TAG, string3);
            return null;
        }
    }

    @Override
    public File getFileStreamPath(String string2) {
        File file = this.getFilesDir();
        return this.makeFilename(file, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public File getFilesDir() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mFilesDir == null) {
                File file;
                File file2 = this.getDataDirFile();
                this.mFilesDir = file = new File(file2, "files");
            }
            if (!this.mFilesDir.exists()) {
                if (!this.mFilesDir.mkdirs()) {
                    int n = Log.w(TAG, "Unable to create files directory");
                    return null;
                }
                int n = FileUtils.setPermissions(this.mFilesDir.getPath(), 505, -1, -1);
            }
            File file = this.mFilesDir;
            return file;
        }
    }

    @Override
    public Looper getMainLooper() {
        return this.mMainThread.getLooper();
    }

    final Context getOuterContext() {
        return this.mOuterContext;
    }

    @Override
    public String getPackageCodePath() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getAppDir();
        }
        throw new RuntimeException("Not supported in system context");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PackageManager getPackageManager() {
        PackageManager packageManager;
        if (this.mPackageManager != null) {
            return this.mPackageManager;
        }
        IPackageManager iPackageManager = ActivityThread.getPackageManager();
        if (iPackageManager == null) return null;
        this.mPackageManager = packageManager = new ApplicationPackageManager(this, iPackageManager);
        return packageManager;
    }

    @Override
    public String getPackageName() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getPackageName();
        }
        throw new RuntimeException("Not supported in system context");
    }

    @Override
    public String getPackageResourcePath() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getResDir();
        }
        throw new RuntimeException("Not supported in system context");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final Context getReceiverRestrictedContext() {
        Context context;
        if (this.mReceiverRestrictedContext != null) {
            return this.mReceiverRestrictedContext;
        }
        Context context2 = this.getOuterContext();
        this.mReceiverRestrictedContext = context = new ReceiverRestrictedContext(context2);
        return context;
    }

    @Override
    public Resources getResources() {
        return this.mResources;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SharedPreferences getSharedPreferences(String string2, int n) {
        File file;
        SharedPreferencesImpl sharedPreferencesImpl;
        boolean bl = false;
        Object object = sSharedPrefs;
        synchronized (object) {
            sharedPreferencesImpl = sSharedPrefs.get(string2);
            if (sharedPreferencesImpl != null && !sharedPreferencesImpl.hasFileChangedUnexpectedly()) {
                return sharedPreferencesImpl;
            }
            file = this.getSharedPrefsFile(string2);
            if (sharedPreferencesImpl == null) {
                sharedPreferencesImpl = new SharedPreferencesImpl(file, n, null);
                SharedPreferencesImpl sharedPreferencesImpl2 = sSharedPrefs.put(string2, sharedPreferencesImpl);
                bl = true;
            }
        }
        synchronized (sharedPreferencesImpl) {
            boolean bl2;
            boolean bl3;
            boolean bl4;
            if (bl && (bl4 = sharedPreferencesImpl.isLoaded())) {
                return sharedPreferencesImpl;
            }
            File file2 = ContextImpl.makeBackupFile(file);
            if (file2.exists()) {
                boolean bl5 = file.delete();
                boolean bl6 = file2.renameTo(file);
            }
            if (file.exists() && !file.canRead()) {
                String string3 = "Attempt to read preferences file " + file + " without permission";
                int n2 = Log.w(TAG, string3);
            }
            HashMap hashMap = null;
            FileUtils.FileStatus fileStatus = new FileUtils.FileStatus();
            object = FileUtils.getFileStatus(file.getPath(), fileStatus);
            if (object != null && (bl3 = (bl2 = file.canRead()))) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    hashMap = XmlUtils.readMapXml(fileInputStream);
                    fileInputStream.close();
                }
                catch (XmlPullParserException xmlPullParserException) {
                    String string4 = TAG;
                    int n3 = Log.w(string4, "getSharedPreferences", xmlPullParserException);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    String string5 = TAG;
                    int n4 = Log.w(string5, "getSharedPreferences", fileNotFoundException);
                }
                catch (IOException iOException) {
                    String string6 = TAG;
                    int n5 = Log.w(string6, "getSharedPreferences", iOException);
                }
            }
            sharedPreferencesImpl.replace(hashMap, fileStatus);
            return sharedPreferencesImpl;
        }
    }

    @Override
    public File getSharedPrefsFile(String string2) {
        File file = this.getPreferencesDir();
        String string3 = string2 + ".xml";
        return this.makeFilename(file, string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getSystemService(String string2) {
        if ("window".equals(string2)) {
            return WindowManagerImpl.getDefault();
        }
        if ("layout_inflater".equals(string2)) {
            Object object = this.mSync;
            synchronized (object) {
                LayoutInflater layoutInflater;
                LayoutInflater layoutInflater2 = this.mLayoutInflater;
                if (layoutInflater2 != null) {
                    return layoutInflater2;
                }
                this.mLayoutInflater = layoutInflater = PolicyManager.makeNewLayoutInflater(this.getOuterContext());
                return layoutInflater;
            }
        }
        if ("activity".equals(string2)) {
            return this.getActivityManager();
        }
        if ("input_method".equals(string2)) {
            return InputMethodManager.getInstance(this);
        }
        if ("alarm".equals(string2)) {
            return this.getAlarmManager();
        }
        if ("account".equals(string2)) {
            return this.getAccountManager();
        }
        if ("power".equals(string2)) {
            return this.getPowerManager();
        }
        if ("connectivity".equals(string2)) {
            return this.getConnectivityManager();
        }
        if ("throttle".equals(string2)) {
            return this.getThrottleManager();
        }
        if ("wifi".equals(string2)) {
            return this.getWifiManager();
        }
        if ("notification".equals(string2)) {
            return this.getNotificationManager();
        }
        if ("keyguard".equals(string2)) {
            return new KeyguardManager();
        }
        if ("accessibility".equals(string2)) {
            return AccessibilityManager.getInstance(this);
        }
        if ("location".equals(string2)) {
            return this.getLocationManager();
        }
        if ("search".equals(string2)) {
            return this.getSearchManager();
        }
        if ("sensor".equals(string2)) {
            return this.getSensorManager();
        }
        if ("storage".equals(string2)) {
            return this.getStorageManager();
        }
        if ("vibrator".equals(string2)) {
            return this.getVibrator();
        }
        if ("statusbar".equals(string2)) {
            Object object = this.mSync;
            synchronized (object) {
                if (this.mStatusBarManager == null) {
                    StatusBarManager statusBarManager;
                    Context context = this.getOuterContext();
                    this.mStatusBarManager = statusBarManager = new StatusBarManager(context);
                }
                StatusBarManager statusBarManager = this.mStatusBarManager;
                return statusBarManager;
            }
        }
        if ("audio".equals(string2)) {
            return this.getAudioManager();
        }
        if ("phone".equals(string2)) {
            return this.getTelephonyManager();
        }
        if ("clipboard".equals(string2)) {
            return this.getClipboardManager();
        }
        if ("wallpaper".equals(string2)) {
            return this.getWallpaperManager();
        }
        if ("dropbox".equals(string2)) {
            return this.getDropBoxManager();
        }
        if ("device_policy".equals(string2)) {
            return this.getDevicePolicyManager();
        }
        if ("uimode".equals(string2)) {
            return this.getUiModeManager();
        }
        if ("download".equals(string2)) {
            return this.getDownloadManager();
        }
        if (!"nfc".equals(string2)) return null;
        return this.getNfcManager();
    }

    @Override
    public Resources.Theme getTheme() {
        if (this.mTheme == null) {
            Resources.Theme theme;
            if (this.mThemeResource == 0) {
                this.mThemeResource = 16973829;
            }
            Resources.Theme theme2 = this.mTheme = (theme = this.mResources.newTheme());
            int n = this.mThemeResource;
            theme2.applyStyle(n, true);
        }
        return this.mTheme;
    }

    @Override
    public Drawable getWallpaper() {
        return this.getWallpaperManager().getDrawable();
    }

    @Override
    public int getWallpaperDesiredMinimumHeight() {
        return this.getWallpaperManager().getDesiredMinimumHeight();
    }

    @Override
    public int getWallpaperDesiredMinimumWidth() {
        return this.getWallpaperManager().getDesiredMinimumWidth();
    }

    @Override
    public void grantUriPermission(String string2, Uri uri, int n) {
        try {
            IActivityManager iActivityManager = ActivityManagerNative.getDefault();
            ActivityThread.ApplicationThread applicationThread = this.mMainThread.getApplicationThread();
            iActivityManager.grantUriPermission(applicationThread, string2, uri, n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    final void init(LoadedApk loadedApk, IBinder iBinder, ActivityThread activityThread) {
        this.init(loadedApk, iBinder, activityThread, null);
    }

    final void init(LoadedApk loadedApk, IBinder iBinder, ActivityThread activityThread, Resources resources) {
        ApplicationContentResolver applicationContentResolver;
        float f;
        float f2;
        Resources resources2;
        this.mPackageInfo = loadedApk;
        this.mResources = resources2 = this.mPackageInfo.getResources(activityThread);
        if (this.mResources != null && resources != null && (f2 = resources.getCompatibilityInfo().applicationScale) != (f = this.mResources.getCompatibilityInfo().applicationScale)) {
            Resources resources3;
            String string2 = this.mPackageInfo.getResDir();
            CompatibilityInfo compatibilityInfo = resources.getCompatibilityInfo().copy();
            this.mResources = resources3 = activityThread.getTopLevelResources(string2, compatibilityInfo);
        }
        this.mMainThread = activityThread;
        this.mContentResolver = applicationContentResolver = new ApplicationContentResolver(this, activityThread);
        this.setActivityToken(iBinder);
    }

    final void init(Resources resources, ActivityThread activityThread) {
        ApplicationContentResolver applicationContentResolver;
        this.mPackageInfo = null;
        this.mResources = resources;
        this.mMainThread = activityThread;
        this.mContentResolver = applicationContentResolver = new ApplicationContentResolver(this, activityThread);
    }

    @Override
    public boolean isRestricted() {
        return this.mRestricted;
    }

    @Override
    public FileInputStream openFileInput(String string2) throws FileNotFoundException {
        File file = this.getFilesDir();
        File file2 = this.makeFilename(file, string2);
        return new FileInputStream(file2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileOutputStream openFileOutput(String string2, int n) throws FileNotFoundException {
        FileOutputStream fileOutputStream;
        boolean bl = (0x8000 & n) != 0;
        File file = this.getFilesDir();
        File file2 = this.makeFilename(file, string2);
        try {
            fileOutputStream = new FileOutputStream(file2, bl);
            ContextImpl.setFilePermissionsFromMode(file2.getPath(), n, 0);
            return fileOutputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            File file3 = file2.getParentFile();
            boolean bl2 = file3.mkdir();
            int n2 = FileUtils.setPermissions(file3.getPath(), 505, -1, -1);
            fileOutputStream = new FileOutputStream(file2, bl);
            ContextImpl.setFilePermissionsFromMode(file2.getPath(), n, 0);
            return fileOutputStream;
        }
    }

    @Override
    public SQLiteDatabase openOrCreateDatabase(String string2, int n, SQLiteDatabase.CursorFactory cursorFactory) {
        File file = this.validateFilePath(string2, true);
        SQLiteDatabase sQLiteDatabase = SQLiteDatabase.openOrCreateDatabase(file, cursorFactory);
        ContextImpl.setFilePermissionsFromMode(file.getPath(), n, 0);
        return sQLiteDatabase;
    }

    @Override
    public Drawable peekWallpaper() {
        return this.getWallpaperManager().peekDrawable();
    }

    final void performFinalCleanup(String string2, String string3) {
        LoadedApk loadedApk = this.mPackageInfo;
        Context context = this.getOuterContext();
        loadedApk.removeContextRegistrations(context, string2, string3);
    }

    @Override
    public Intent registerReceiver(BroadcastReceiver broadcastReceiver, IntentFilter intentFilter) {
        return this.registerReceiver(broadcastReceiver, intentFilter, null, null);
    }

    @Override
    public Intent registerReceiver(BroadcastReceiver broadcastReceiver, IntentFilter intentFilter, String string2, Handler handler) {
        Context context = this.getOuterContext();
        ContextImpl contextImpl = this;
        BroadcastReceiver broadcastReceiver2 = broadcastReceiver;
        IntentFilter intentFilter2 = intentFilter;
        String string3 = string2;
        Handler handler2 = handler;
        return contextImpl.registerReceiverInternal(broadcastReceiver2, intentFilter2, string3, handler2, context);
    }

    @Override
    public void removeStickyBroadcast(Intent intent) {
        ContentResolver contentResolver = this.getContentResolver();
        String string2 = intent.resolveTypeIfNeeded(contentResolver);
        if (string2 != null) {
            Intent intent2 = new Intent(intent);
            Uri uri = intent2.getData();
            Intent intent3 = intent2.setDataAndType(uri, string2);
            intent = intent2;
        }
        try {
            IActivityManager iActivityManager = ActivityManagerNative.getDefault();
            ActivityThread.ApplicationThread applicationThread = this.mMainThread.getApplicationThread();
            iActivityManager.unbroadcastIntent(applicationThread, intent);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void revokeUriPermission(Uri uri, int n) {
        try {
            IActivityManager iActivityManager = ActivityManagerNative.getDefault();
            ActivityThread.ApplicationThread applicationThread = this.mMainThread.getApplicationThread();
            iActivityManager.revokeUriPermission(applicationThread, uri, n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    final void scheduleFinalCleanup(String string2, String string3) {
        this.mMainThread.scheduleContextCleanup(this, string2, string3);
    }

    @Override
    public void sendBroadcast(Intent intent) {
        ContentResolver contentResolver = this.getContentResolver();
        String string2 = intent.resolveTypeIfNeeded(contentResolver);
        try {
            IActivityManager iActivityManager = ActivityManagerNative.getDefault();
            ActivityThread.ApplicationThread applicationThread = this.mMainThread.getApplicationThread();
            Intent intent2 = intent;
            int n = iActivityManager.broadcastIntent(applicationThread, intent2, string2, null, -1, null, null, null, false, false);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void sendBroadcast(Intent intent, String string2) {
        ContentResolver contentResolver = this.getContentResolver();
        String string3 = intent.resolveTypeIfNeeded(contentResolver);
        try {
            IActivityManager iActivityManager = ActivityManagerNative.getDefault();
            ActivityThread.ApplicationThread applicationThread = this.mMainThread.getApplicationThread();
            Intent intent2 = intent;
            String string4 = string2;
            int n = iActivityManager.broadcastIntent(applicationThread, intent2, string3, null, -1, null, null, string4, false, false);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void sendOrderedBroadcast(Intent intent, String string2) {
        ContentResolver contentResolver = this.getContentResolver();
        String string3 = intent.resolveTypeIfNeeded(contentResolver);
        try {
            IActivityManager iActivityManager = ActivityManagerNative.getDefault();
            ActivityThread.ApplicationThread applicationThread = this.mMainThread.getApplicationThread();
            Intent intent2 = intent;
            String string4 = string2;
            int n = iActivityManager.broadcastIntent(applicationThread, intent2, string3, null, -1, null, null, string4, true, false);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void sendOrderedBroadcast(Intent intent, String string2, BroadcastReceiver broadcastReceiver, Handler handler, int n, String string3, Bundle bundle) {
        IIntentReceiver iIntentReceiver = null;
        if (broadcastReceiver != null) {
            if (this.mPackageInfo != null) {
                if (handler == null) {
                    handler = this.mMainThread.getHandler();
                }
                LoadedApk loadedApk = this.mPackageInfo;
                Context context = this.getOuterContext();
                Instrumentation instrumentation = this.mMainThread.getInstrumentation();
                BroadcastReceiver broadcastReceiver2 = broadcastReceiver;
                Handler handler2 = handler;
                iIntentReceiver = loadedApk.getReceiverDispatcher(broadcastReceiver2, context, handler2, instrumentation, false);
            } else {
                if (handler == null) {
                    handler = this.mMainThread.getHandler();
                }
                Context context = this.getOuterContext();
                BroadcastReceiver broadcastReceiver3 = broadcastReceiver;
                Handler handler3 = handler;
                iIntentReceiver = new LoadedApk.ReceiverDispatcher(broadcastReceiver3, context, handler3, null, false).getIIntentReceiver();
            }
        }
        ContentResolver contentResolver = this.getContentResolver();
        String string4 = intent.resolveTypeIfNeeded(contentResolver);
        try {
            IActivityManager iActivityManager = ActivityManagerNative.getDefault();
            ActivityThread.ApplicationThread applicationThread = this.mMainThread.getApplicationThread();
            Intent intent2 = intent;
            int n2 = n;
            String string5 = string3;
            Bundle bundle2 = bundle;
            String string6 = string2;
            int n3 = iActivityManager.broadcastIntent(applicationThread, intent2, string4, iIntentReceiver, n2, string5, bundle2, string6, true, false);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void sendStickyBroadcast(Intent intent) {
        ContentResolver contentResolver = this.getContentResolver();
        String string2 = intent.resolveTypeIfNeeded(contentResolver);
        try {
            IActivityManager iActivityManager = ActivityManagerNative.getDefault();
            ActivityThread.ApplicationThread applicationThread = this.mMainThread.getApplicationThread();
            Intent intent2 = intent;
            int n = iActivityManager.broadcastIntent(applicationThread, intent2, string2, null, -1, null, null, null, false, true);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void sendStickyOrderedBroadcast(Intent intent, BroadcastReceiver broadcastReceiver, Handler handler, int n, String string2, Bundle bundle) {
        IIntentReceiver iIntentReceiver = null;
        if (broadcastReceiver != null) {
            if (this.mPackageInfo != null) {
                if (handler == null) {
                    handler = this.mMainThread.getHandler();
                }
                LoadedApk loadedApk = this.mPackageInfo;
                Context context = this.getOuterContext();
                Instrumentation instrumentation = this.mMainThread.getInstrumentation();
                BroadcastReceiver broadcastReceiver2 = broadcastReceiver;
                Handler handler2 = handler;
                iIntentReceiver = loadedApk.getReceiverDispatcher(broadcastReceiver2, context, handler2, instrumentation, false);
            } else {
                if (handler == null) {
                    handler = this.mMainThread.getHandler();
                }
                Context context = this.getOuterContext();
                BroadcastReceiver broadcastReceiver3 = broadcastReceiver;
                Handler handler3 = handler;
                iIntentReceiver = new LoadedApk.ReceiverDispatcher(broadcastReceiver3, context, handler3, null, false).getIIntentReceiver();
            }
        }
        ContentResolver contentResolver = this.getContentResolver();
        String string3 = intent.resolveTypeIfNeeded(contentResolver);
        try {
            IActivityManager iActivityManager = ActivityManagerNative.getDefault();
            ActivityThread.ApplicationThread applicationThread = this.mMainThread.getApplicationThread();
            Intent intent2 = intent;
            int n2 = n;
            String string4 = string2;
            Bundle bundle2 = bundle;
            int n3 = iActivityManager.broadcastIntent(applicationThread, intent2, string3, iIntentReceiver, n2, string4, bundle2, null, true, true);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    final void setActivityToken(IBinder iBinder) {
        this.mActivityToken = iBinder;
    }

    final void setOuterContext(Context context) {
        this.mOuterContext = context;
    }

    @Override
    public void setTheme(int n) {
        this.mThemeResource = n;
    }

    @Override
    public void setWallpaper(Bitmap bitmap) throws IOException {
        this.getWallpaperManager().setBitmap(bitmap);
    }

    @Override
    public void setWallpaper(InputStream inputStream) throws IOException {
        this.getWallpaperManager().setStream(inputStream);
    }

    @Override
    public void startActivity(Intent intent) {
        if ((intent.getFlags() & 0x10000000) == 0) {
            throw new AndroidRuntimeException("Calling startActivity() from outside of an Activity  context requires the FLAG_ACTIVITY_NEW_TASK flag. Is this really what you want?");
        }
        Instrumentation instrumentation = this.mMainThread.getInstrumentation();
        Context context = this.getOuterContext();
        ActivityThread.ApplicationThread applicationThread = this.mMainThread.getApplicationThread();
        Activity activity = null;
        Intent intent2 = intent;
        Instrumentation.ActivityResult activityResult = instrumentation.execStartActivity(context, applicationThread, null, activity, intent2, -1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean startInstrumentation(ComponentName componentName, String string2, Bundle bundle) {
        try {
            IActivityManager iActivityManager = ActivityManagerNative.getDefault();
            ComponentName componentName2 = componentName;
            String string3 = string2;
            Bundle bundle2 = bundle;
            boolean bl = iActivityManager.startInstrumentation(componentName2, string3, 0, bundle2, null);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void startIntentSender(IntentSender var1_1, Intent var2_2, int var3_3, int var4_4, int var5_5) throws IntentSender.SendIntentException {
        var6_6 = null;
        if (var2_2 == null) ** GOTO lbl6
        try {
            var7_7 = this.getContentResolver();
            var6_6 = var2_2.resolveTypeIfNeeded(var7_7);
lbl6:
            // 2 sources

            if ((var14_14 = (var8_8 = ActivityManagerNative.getDefault()).startActivityIntentSender(var9_9 = this.mMainThread.getApplicationThread(), var10_10 = var1_1, var11_11 = var2_2, var6_6, null, null, 0, var12_12 = var3_3, var13_13 = var4_4)) == -1) {
                throw new IntentSender.SendIntentException();
            }
        }
        catch (RemoteException var15_15) {
            return;
        }
        Instrumentation.checkStartActivityResult(var14_14, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ComponentName startService(Intent intent) {
        try {
            IActivityManager iActivityManager = ActivityManagerNative.getDefault();
            ActivityThread.ApplicationThread applicationThread = this.mMainThread.getApplicationThread();
            ContentResolver contentResolver = this.getContentResolver();
            String string2 = intent.resolveTypeIfNeeded(contentResolver);
            ComponentName componentName = iActivityManager.startService(applicationThread, intent, string2);
            if (componentName == null) return componentName;
            if (!componentName.getPackageName().equals("!")) return componentName;
            StringBuilder stringBuilder = new StringBuilder().append("Not allowed to start service ").append(intent).append(" without permission ");
            String string3 = componentName.getClassName();
            String string4 = stringBuilder.append(string3).toString();
            throw new SecurityException(string4);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean stopService(Intent intent) {
        int n;
        try {
            IActivityManager iActivityManager = ActivityManagerNative.getDefault();
            ActivityThread.ApplicationThread applicationThread = this.mMainThread.getApplicationThread();
            ContentResolver contentResolver = this.getContentResolver();
            String string2 = intent.resolveTypeIfNeeded(contentResolver);
            n = iActivityManager.stopService(applicationThread, intent, string2);
            if (n < 0) {
                String string3 = "Not allowed to stop service " + intent;
                throw new SecurityException(string3);
            }
        }
        catch (RemoteException remoteException) {
            return false;
        }
        if (n == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void unbindService(ServiceConnection serviceConnection) {
        if (this.mPackageInfo == null) throw new RuntimeException("Not supported in system context");
        LoadedApk loadedApk = this.mPackageInfo;
        Context context = this.getOuterContext();
        IServiceConnection iServiceConnection = loadedApk.forgetServiceDispatcher(context, serviceConnection);
        try {
            boolean bl = ActivityManagerNative.getDefault().unbindService(iServiceConnection);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void unregisterReceiver(BroadcastReceiver broadcastReceiver) {
        if (this.mPackageInfo == null) throw new RuntimeException("Not supported in system context");
        LoadedApk loadedApk = this.mPackageInfo;
        Context context = this.getOuterContext();
        IIntentReceiver iIntentReceiver = loadedApk.forgetReceiverDispatcher(context, broadcastReceiver);
        try {
            ActivityManagerNative.getDefault().unregisterReceiver(iIntentReceiver);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    private static final class SharedPreferencesImpl
    implements SharedPreferences {
        private static final Object mContent = new Object();
        private final File mBackupFile;
        private int mDiskWritesInFlight = 0;
        private final File mFile;
        private final WeakHashMap<SharedPreferences.OnSharedPreferenceChangeListener, Object> mListeners;
        private boolean mLoaded = false;
        private Map<String, Object> mMap;
        private final int mMode;
        private long mStatSize;
        private long mStatTimestamp;
        private final Object mWritingToDiskLock;

        /*
         * Enabled aggressive block sorting
         */
        SharedPreferencesImpl(File file, int n, Map hashMap) {
            File file2;
            Object object;
            this.mWritingToDiskLock = object = new Object();
            this.mFile = file;
            this.mBackupFile = file2 = ContextImpl.makeBackupFile(file);
            this.mMode = n;
            boolean bl = hashMap != null;
            this.mLoaded = bl;
            HashMap<String, Object> hashMap2 = hashMap != null ? hashMap : new HashMap();
            this.mMap = hashMap2;
            FileUtils.FileStatus fileStatus = new FileUtils.FileStatus();
            if (FileUtils.getFileStatus(file.getPath(), fileStatus)) {
                long l;
                this.mStatTimestamp = l = fileStatus.mtime;
            }
            WeakHashMap weakHashMap = new WeakHashMap();
            this.mListeners = weakHashMap;
        }

        static /* synthetic */ int access$308(SharedPreferencesImpl sharedPreferencesImpl) {
            int n;
            int n2 = sharedPreferencesImpl.mDiskWritesInFlight;
            sharedPreferencesImpl.mDiskWritesInFlight = n = n2 + 1;
            return n2;
        }

        static /* synthetic */ int access$310(SharedPreferencesImpl sharedPreferencesImpl) {
            int n;
            int n2 = sharedPreferencesImpl.mDiskWritesInFlight;
            sharedPreferencesImpl.mDiskWritesInFlight = n = n2 - 1;
            return n2;
        }

        static /* synthetic */ Map access$402(SharedPreferencesImpl sharedPreferencesImpl, Map map) {
            sharedPreferencesImpl.mMap = map;
            return map;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static FileOutputStream createFileOutputStream(File file) {
            FileOutputStream fileOutputStream = null;
            try {
                FileOutputStream fileOutputStream2;
                fileOutputStream = fileOutputStream2 = new FileOutputStream(file);
                return fileOutputStream;
            }
            catch (FileNotFoundException fileNotFoundException) {
                File file2 = file.getParentFile();
                if (!file2.mkdir()) {
                    String string2 = "Couldn't create directory for SharedPreferences file " + file;
                    int n = Log.e(ContextImpl.TAG, string2);
                    return null;
                }
                int n = FileUtils.setPermissions(file2.getPath(), 505, -1, -1);
                try {
                    FileOutputStream fileOutputStream3 = new FileOutputStream(file);
                    return fileOutputStream3;
                }
                catch (FileNotFoundException fileNotFoundException2) {
                    String string3 = "Couldn't create SharedPreferences file " + file;
                    int n2 = Log.e(ContextImpl.TAG, string3, fileNotFoundException2);
                    return fileOutputStream;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void enqueueDiskWrite(final MemoryCommitResult memoryCommitResult, final Runnable runnable) {
            Runnable runnable2 = new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    Object object = SharedPreferencesImpl.this.mWritingToDiskLock;
                    // MONITORENTER : object
                    SharedPreferencesImpl sharedPreferencesImpl = SharedPreferencesImpl.this;
                    MemoryCommitResult memoryCommitResult2 = memoryCommitResult;
                    sharedPreferencesImpl.writeToFile(memoryCommitResult2);
                    // MONITOREXIT : object
                    SharedPreferencesImpl sharedPreferencesImpl2 = SharedPreferencesImpl.this;
                    // MONITORENTER : sharedPreferencesImpl2
                    int n = SharedPreferencesImpl.access$310(SharedPreferencesImpl.this);
                    // MONITOREXIT : sharedPreferencesImpl2
                    if (runnable == null) {
                        return;
                    }
                    runnable.run();
                }
            };
            boolean bl = runnable == null;
            if (bl) {
                // MONITORENTER : this
                boolean bl2 = this.mDiskWritesInFlight == 1;
                // MONITOREXIT : this
                if (bl2) {
                    runnable2.run();
                    return;
                }
            }
            QueuedWork.singleThreadExecutor().execute(runnable2);
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void writeToFile(MemoryCommitResult memoryCommitResult) {
            block16: {
                if (this.mFile.exists()) {
                    if (!memoryCommitResult.changesMade) {
                        memoryCommitResult.setDiskWriteResult(true);
                        return;
                    }
                    if (!this.mBackupFile.exists()) {
                        File file = this.mFile;
                        File file2 = this.mBackupFile;
                        if (!file.renameTo(file2)) {
                            StringBuilder stringBuilder = new StringBuilder().append("Couldn't rename file ");
                            File file3 = this.mFile;
                            StringBuilder stringBuilder2 = stringBuilder.append(file3).append(" to backup file ");
                            File file4 = this.mBackupFile;
                            String string2 = stringBuilder2.append(file4).toString();
                            int n = Log.e(ContextImpl.TAG, string2);
                            memoryCommitResult.setDiskWriteResult(false);
                            return;
                        }
                    } else {
                        boolean bl = this.mFile.delete();
                    }
                }
                FileOutputStream fileOutputStream = SharedPreferencesImpl.createFileOutputStream(this.mFile);
                if (fileOutputStream == null) {
                    memoryCommitResult.setDiskWriteResult(false);
                    return;
                }
                XmlUtils.writeMapXml(memoryCommitResult.mapToWriteToDisk, fileOutputStream);
                boolean bl = FileUtils.sync(fileOutputStream);
                fileOutputStream.close();
                String string3 = this.mFile.getPath();
                int n = this.mMode;
                ContextImpl.setFilePermissionsFromMode(string3, n, 0);
                FileUtils.FileStatus fileStatus = new FileUtils.FileStatus();
                if (!FileUtils.getFileStatus(this.mFile.getPath(), fileStatus)) break block16;
                synchronized (this) {
                    long l;
                    long l2;
                    this.mStatTimestamp = l2 = fileStatus.mtime;
                    this.mStatSize = l = fileStatus.size;
                }
            }
            try {
                boolean bl = this.mBackupFile.delete();
                memoryCommitResult.setDiskWriteResult(true);
                return;
            }
            catch (XmlPullParserException xmlPullParserException) {
                block17: {
                    int n = Log.w(ContextImpl.TAG, "writeToFile: Got exception:", xmlPullParserException);
                    break block17;
                    catch (IOException iOException) {
                        int n2 = Log.w(ContextImpl.TAG, "writeToFile: Got exception:", iOException);
                    }
                }
                if (this.mFile.exists() && !this.mFile.delete()) {
                    StringBuilder stringBuilder = new StringBuilder().append("Couldn't clean up partially-written file ");
                    File file = this.mFile;
                    String string4 = stringBuilder.append(file).toString();
                    int n = Log.e(ContextImpl.TAG, string4);
                }
                memoryCommitResult.setDiskWriteResult(false);
                return;
            }
        }

        @Override
        public boolean contains(String string2) {
            synchronized (this) {
                boolean bl = this.mMap.containsKey(string2);
                return bl;
            }
        }

        @Override
        public SharedPreferences.Editor edit() {
            return new EditorImpl();
        }

        @Override
        public Map<String, ?> getAll() {
            synchronized (this) {
                Map<String, Object> map = this.mMap;
                HashMap<String, Object> hashMap = new HashMap<String, Object>(map);
                return hashMap;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean getBoolean(String string2, boolean bl) {
            synchronized (this) {
                Boolean bl2 = (Boolean)this.mMap.get(string2);
                if (bl2 == null) return bl;
                return bl2;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public float getFloat(String string2, float f) {
            synchronized (this) {
                Float f2 = (Float)this.mMap.get(string2);
                if (f2 == null) return f;
                return f2.floatValue();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int getInt(String string2, int n) {
            synchronized (this) {
                Integer n2 = (Integer)this.mMap.get(string2);
                if (n2 == null) return n;
                return n2;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public long getLong(String string2, long l) {
            synchronized (this) {
                Long l2 = (Long)this.mMap.get(string2);
                if (l2 == null) return l;
                return l2;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String getString(String string2, String string3) {
            synchronized (this) {
                String string4 = (String)this.mMap.get(string2);
                if (string4 == null) return string3;
                return string4;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean hasFileChangedUnexpectedly() {
            synchronized (this) {
                if (this.mDiskWritesInFlight > 0) {
                    return (boolean)null;
                }
            }
            FileUtils.FileStatus fileStatus = new FileUtils.FileStatus();
            if (!FileUtils.getFileStatus(this.mFile.getPath(), fileStatus)) {
                return (boolean)null;
            }
            synchronized (this) {
                long l = this.mStatTimestamp;
                long l2 = fileStatus.mtime;
                if (l != l2) return (boolean)null;
                long l3 = this.mStatSize;
                long l4 = fileStatus.size;
                if (l3 == l4) return (boolean)null;
                return (boolean)null;
            }
        }

        boolean isLoaded() {
            synchronized (this) {
                boolean bl = this.mLoaded;
                return bl;
            }
        }

        @Override
        public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener onSharedPreferenceChangeListener) {
            synchronized (this) {
                WeakHashMap<SharedPreferences.OnSharedPreferenceChangeListener, Object> weakHashMap = this.mListeners;
                Object object = mContent;
                Object object2 = weakHashMap.put(onSharedPreferenceChangeListener, object);
                return;
            }
        }

        void replace(Map map, FileUtils.FileStatus fileStatus) {
            synchronized (this) {
                this.mLoaded = true;
                if (map != null) {
                    this.mMap = map;
                }
                if (fileStatus != null) {
                    long l;
                    long l2;
                    this.mStatTimestamp = l2 = fileStatus.mtime;
                    this.mStatSize = l = fileStatus.size;
                }
                return;
            }
        }

        @Override
        public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener onSharedPreferenceChangeListener) {
            synchronized (this) {
                Object object = this.mListeners.remove(onSharedPreferenceChangeListener);
                return;
            }
        }

        public final class EditorImpl
        implements SharedPreferences.Editor {
            private boolean mClear;
            private final Map<String, Object> mModified;

            public EditorImpl() {
                HashMap<String, Object> hashMap = Maps.newHashMap();
                this.mModified = hashMap;
                this.mClear = false;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private MemoryCommitResult commitToMemory() {
                MemoryCommitResult memoryCommitResult = new MemoryCommitResult();
                SharedPreferencesImpl sharedPreferencesImpl = SharedPreferencesImpl.this;
                synchronized (sharedPreferencesImpl) {
                    Map map;
                    if (SharedPreferencesImpl.this.mDiskWritesInFlight > 0) {
                        SharedPreferencesImpl sharedPreferencesImpl2 = SharedPreferencesImpl.this;
                        Map map2 = SharedPreferencesImpl.this.mMap;
                        HashMap hashMap = new HashMap(map2);
                        Map map3 = SharedPreferencesImpl.access$402(sharedPreferencesImpl2, hashMap);
                    }
                    memoryCommitResult.mapToWriteToDisk = map = SharedPreferencesImpl.this.mMap;
                    int n = SharedPreferencesImpl.access$308(SharedPreferencesImpl.this);
                    boolean bl = SharedPreferencesImpl.this.mListeners.size() > 0;
                    if (bl) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        memoryCommitResult.keysModified = arrayList;
                        Set set = SharedPreferencesImpl.this.mListeners.keySet();
                        HashSet hashSet = new HashSet(set);
                        memoryCommitResult.listeners = hashSet;
                    }
                    synchronized (this) {
                        if (this.mClear) {
                            if (!SharedPreferencesImpl.this.mMap.isEmpty()) {
                                memoryCommitResult.changesMade = true;
                                SharedPreferencesImpl.this.mMap.clear();
                            }
                            this.mClear = false;
                        }
                        Iterator<Map.Entry<String, Object>> iterator = this.mModified.entrySet().iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                this.mModified.clear();
                                return memoryCommitResult;
                            }
                            Map.Entry<String, Object> entry = iterator.next();
                            String string2 = entry.getKey();
                            Object object = entry.getValue();
                            if (object == this) {
                                if (!SharedPreferencesImpl.this.mMap.containsKey(string2)) continue;
                                Object v = SharedPreferencesImpl.this.mMap.remove(string2);
                            } else {
                                Object v;
                                if (SharedPreferencesImpl.this.mMap.containsKey(string2) && (v = SharedPreferencesImpl.this.mMap.get(string2)) != null && v.equals(object)) continue;
                                Object object2 = SharedPreferencesImpl.this.mMap.put(string2, object);
                            }
                            memoryCommitResult.changesMade = true;
                            if (!bl) continue;
                            boolean bl2 = memoryCommitResult.keysModified.add(string2);
                        }
                    }
                }
            }

            private void notifyListeners(final MemoryCommitResult memoryCommitResult) {
                Looper looper;
                if (memoryCommitResult.listeners == null) {
                    return;
                }
                if (memoryCommitResult.keysModified == null) {
                    return;
                }
                if (memoryCommitResult.keysModified.size() == 0) {
                    return;
                }
                Looper looper2 = Looper.myLooper();
                if (looper2 == (looper = Looper.getMainLooper())) {
                    int n = memoryCommitResult.keysModified.size() - 1;
                    while (true) {
                        if (n < 0) {
                            return;
                        }
                        String string2 = memoryCommitResult.keysModified.get(n);
                        for (SharedPreferences.OnSharedPreferenceChangeListener onSharedPreferenceChangeListener : memoryCommitResult.listeners) {
                            if (onSharedPreferenceChangeListener == null) continue;
                            SharedPreferencesImpl sharedPreferencesImpl = SharedPreferencesImpl.this;
                            onSharedPreferenceChangeListener.onSharedPreferenceChanged(sharedPreferencesImpl, string2);
                        }
                        n += -1;
                    }
                }
                Handler handler = ActivityThread.sMainThreadHandler;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        EditorImpl editorImpl = EditorImpl.this;
                        MemoryCommitResult memoryCommitResult2 = memoryCommitResult;
                        editorImpl.notifyListeners(memoryCommitResult2);
                    }
                };
                boolean bl = handler.post(runnable);
            }

            @Override
            public void apply() {
                final MemoryCommitResult memoryCommitResult = this.commitToMemory();
                final Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            memoryCommitResult.writtenToDiskLatch.await();
                            return;
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                };
                QueuedWork.add(runnable);
                Runnable runnable2 = new Runnable(){

                    @Override
                    public void run() {
                        runnable.run();
                        QueuedWork.remove(runnable);
                    }
                };
                SharedPreferencesImpl.this.enqueueDiskWrite(memoryCommitResult, runnable2);
                this.notifyListeners(memoryCommitResult);
            }

            @Override
            public SharedPreferences.Editor clear() {
                synchronized (this) {
                    this.mClear = true;
                    return this;
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean commit() {
                MemoryCommitResult memoryCommitResult = this.commitToMemory();
                SharedPreferencesImpl.this.enqueueDiskWrite(memoryCommitResult, null);
                try {
                    memoryCommitResult.writtenToDiskLatch.await();
                    this.notifyListeners(memoryCommitResult);
                    return memoryCommitResult.writeToDiskResult;
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
            }

            @Override
            public SharedPreferences.Editor putBoolean(String string2, boolean bl) {
                synchronized (this) {
                    Map<String, Object> map = this.mModified;
                    Boolean bl2 = bl;
                    Object object = map.put(string2, bl2);
                    return this;
                }
            }

            @Override
            public SharedPreferences.Editor putFloat(String string2, float f) {
                synchronized (this) {
                    Map<String, Object> map = this.mModified;
                    Float f2 = Float.valueOf(f);
                    Object object = map.put(string2, f2);
                    return this;
                }
            }

            @Override
            public SharedPreferences.Editor putInt(String string2, int n) {
                synchronized (this) {
                    Map<String, Object> map = this.mModified;
                    Integer n2 = n;
                    Object object = map.put(string2, n2);
                    return this;
                }
            }

            @Override
            public SharedPreferences.Editor putLong(String string2, long l) {
                synchronized (this) {
                    Map<String, Object> map = this.mModified;
                    Long l2 = l;
                    Object object = map.put(string2, l2);
                    return this;
                }
            }

            @Override
            public SharedPreferences.Editor putString(String string2, String string3) {
                synchronized (this) {
                    Object object = this.mModified.put(string2, string3);
                    return this;
                }
            }

            @Override
            public SharedPreferences.Editor remove(String string2) {
                synchronized (this) {
                    Object object = this.mModified.put(string2, this);
                    return this;
                }
            }
        }

        private static class MemoryCommitResult {
            public boolean changesMade;
            public List<String> keysModified;
            public Set<SharedPreferences.OnSharedPreferenceChangeListener> listeners;
            public Map<?, ?> mapToWriteToDisk;
            public volatile boolean writeToDiskResult;
            public final CountDownLatch writtenToDiskLatch;

            private MemoryCommitResult() {
                CountDownLatch countDownLatch;
                this.writtenToDiskLatch = countDownLatch = new CountDownLatch(1);
                this.writeToDiskResult = false;
            }

            public void setDiskWriteResult(boolean bl) {
                this.writeToDiskResult = bl;
                this.writtenToDiskLatch.countDown();
            }
        }
    }

    static final class ApplicationPackageManager
    extends PackageManager {
        private static HashMap<ResourceName, WeakReference<Drawable>> sIconCache;
        private static HashMap<ResourceName, WeakReference<CharSequence>> sStringCache;
        private static final Object sSync;
        int mCachedSafeMode = -1;
        private final ContextImpl mContext;
        private final IPackageManager mPM;

        static {
            sSync = new Object();
            sIconCache = new HashMap();
            sStringCache = new HashMap();
        }

        ApplicationPackageManager(ContextImpl contextImpl, IPackageManager iPackageManager) {
            this.mContext = contextImpl;
            this.mPM = iPackageManager;
        }

        static void configurationChanged() {
            Object object = sSync;
            synchronized (object) {
                sIconCache.clear();
                sStringCache.clear();
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Drawable getCachedIcon(ResourceName resourceName) {
            Object object = sSync;
            synchronized (object) {
                WeakReference<Drawable> weakReference = sIconCache.get(resourceName);
                if (weakReference == null) return null;
                Drawable drawable2 = (Drawable)weakReference.get();
                if (drawable2 != null) {
                    return drawable2;
                }
                WeakReference<Drawable> weakReference2 = sIconCache.remove(resourceName);
                return null;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private CharSequence getCachedString(ResourceName resourceName) {
            Object object = sSync;
            synchronized (object) {
                WeakReference<CharSequence> weakReference = sStringCache.get(resourceName);
                if (weakReference == null) return null;
                CharSequence charSequence = (CharSequence)weakReference.get();
                if (charSequence != null) {
                    return charSequence;
                }
                WeakReference<CharSequence> weakReference2 = sStringCache.remove(resourceName);
                return null;
            }
        }

        static final void handlePackageBroadcast(int n, String[] stringArray, boolean bl) {
            boolean bl2 = false;
            if (n == 1) {
                bl2 = true;
            }
            if (stringArray == null) {
                return;
            }
            if (stringArray.length <= 0) {
                return;
            }
            boolean bl3 = false;
            for (String string2 : stringArray) {
                Object object = sSync;
                synchronized (object) {
                    Iterator<ResourceName> iterator;
                    if (sIconCache.size() > 0) {
                        iterator = sIconCache.keySet().iterator();
                        while (iterator.hasNext()) {
                            if (!iterator.next().packageName.equals(string2)) continue;
                            iterator.remove();
                            bl3 = true;
                        }
                    }
                    if (sStringCache.size() > 0) {
                        iterator = sStringCache.keySet().iterator();
                        while (iterator.hasNext()) {
                            if (!iterator.next().packageName.equals(string2)) continue;
                            iterator.remove();
                            bl3 = true;
                        }
                    }
                }
            }
            if (!bl3 && !bl) {
                return;
            }
            if (bl2) {
                Runtime.getRuntime().gc();
                return;
            }
            ActivityThread.currentActivityThread().scheduleGcIdler();
        }

        private void putCachedIcon(ResourceName resourceName, Drawable drawable2) {
            Object object = sSync;
            synchronized (object) {
                HashMap<ResourceName, WeakReference<Drawable>> hashMap = sIconCache;
                WeakReference<Drawable> weakReference = new WeakReference<Drawable>(drawable2);
                WeakReference<Drawable> weakReference2 = hashMap.put(resourceName, weakReference);
                return;
            }
        }

        private void putCachedString(ResourceName resourceName, CharSequence charSequence) {
            Object object = sSync;
            synchronized (object) {
                HashMap<ResourceName, WeakReference<CharSequence>> hashMap = sStringCache;
                WeakReference<CharSequence> weakReference = new WeakReference<CharSequence>(charSequence);
                WeakReference<CharSequence> weakReference2 = hashMap.put(resourceName, weakReference);
                return;
            }
        }

        @Override
        public void addPackageToPreferred(String string2) {
            try {
                this.mPM.addPackageToPreferred(string2);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public boolean addPermission(PermissionInfo permissionInfo) {
            try {
                boolean bl = this.mPM.addPermission(permissionInfo);
                return bl;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public boolean addPermissionAsync(PermissionInfo permissionInfo) {
            try {
                boolean bl = this.mPM.addPermissionAsync(permissionInfo);
                return bl;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public void addPreferredActivity(IntentFilter intentFilter, int n, ComponentName[] componentNameArray, ComponentName componentName) {
            try {
                this.mPM.addPreferredActivity(intentFilter, n, componentNameArray, componentName);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public String[] canonicalToCurrentPackageNames(String[] stringArray) {
            try {
                String[] stringArray2 = this.mPM.canonicalToCurrentPackageNames(stringArray);
                return stringArray2;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public int checkPermission(String string2, String string3) {
            try {
                int n = this.mPM.checkPermission(string2, string3);
                return n;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public int checkSignatures(int n, int n2) {
            try {
                int n3 = this.mPM.checkUidSignatures(n, n2);
                return n3;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public int checkSignatures(String string2, String string3) {
            try {
                int n = this.mPM.checkSignatures(string2, string3);
                return n;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public void clearApplicationUserData(String string2, IPackageDataObserver iPackageDataObserver) {
            try {
                this.mPM.clearApplicationUserData(string2, iPackageDataObserver);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public void clearPackagePreferredActivities(String string2) {
            try {
                this.mPM.clearPackagePreferredActivities(string2);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public String[] currentToCanonicalPackageNames(String[] stringArray) {
            try {
                String[] stringArray2 = this.mPM.currentToCanonicalPackageNames(stringArray);
                return stringArray2;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public void deleteApplicationCacheFiles(String string2, IPackageDataObserver iPackageDataObserver) {
            try {
                this.mPM.deleteApplicationCacheFiles(string2, iPackageDataObserver);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public void deletePackage(String string2, IPackageDeleteObserver iPackageDeleteObserver, int n) {
            try {
                this.mPM.deletePackage(string2, iPackageDeleteObserver, n);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public void freeStorage(long l, IntentSender intentSender) {
            try {
                this.mPM.freeStorage(l, intentSender);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public void freeStorageAndNotify(long l, IPackageDataObserver iPackageDataObserver) {
            try {
                this.mPM.freeStorageAndNotify(l, iPackageDataObserver);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public Drawable getActivityIcon(ComponentName componentName) throws PackageManager.NameNotFoundException {
            return this.getActivityInfo(componentName, 0).loadIcon(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Drawable getActivityIcon(Intent intent) throws PackageManager.NameNotFoundException {
            if (intent.getComponent() != null) {
                ComponentName componentName = intent.getComponent();
                return this.getActivityIcon(componentName);
            }
            ResolveInfo resolveInfo = this.resolveActivity(intent, 65536);
            if (resolveInfo != null) {
                return resolveInfo.activityInfo.loadIcon(this);
            }
            String string2 = intent.toURI();
            throw new PackageManager.NameNotFoundException(string2);
        }

        @Override
        public ActivityInfo getActivityInfo(ComponentName componentName, int n) throws PackageManager.NameNotFoundException {
            try {
                ActivityInfo activityInfo;
                ActivityInfo activityInfo2 = activityInfo = this.mPM.getActivityInfo(componentName, n);
                if (activityInfo2 != null) {
                    return activityInfo2;
                }
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
            String string2 = componentName.toString();
            throw new PackageManager.NameNotFoundException(string2);
        }

        @Override
        public Drawable getActivityLogo(ComponentName componentName) throws PackageManager.NameNotFoundException {
            return this.getActivityInfo(componentName, 0).loadLogo(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Drawable getActivityLogo(Intent intent) throws PackageManager.NameNotFoundException {
            if (intent.getComponent() != null) {
                ComponentName componentName = intent.getComponent();
                return this.getActivityLogo(componentName);
            }
            ResolveInfo resolveInfo = this.resolveActivity(intent, 65536);
            if (resolveInfo != null) {
                return resolveInfo.activityInfo.loadLogo(this);
            }
            String string2 = intent.toUri(0);
            throw new PackageManager.NameNotFoundException(string2);
        }

        @Override
        public List<PermissionGroupInfo> getAllPermissionGroups(int n) {
            try {
                List<PermissionGroupInfo> list = this.mPM.getAllPermissionGroups(n);
                return list;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int getApplicationEnabledSetting(String string2) {
            try {
                int n = this.mPM.getApplicationEnabledSetting(string2);
                return n;
            }
            catch (RemoteException remoteException) {
                return 0;
            }
        }

        @Override
        public Drawable getApplicationIcon(ApplicationInfo applicationInfo) {
            return applicationInfo.loadIcon(this);
        }

        @Override
        public Drawable getApplicationIcon(String string2) throws PackageManager.NameNotFoundException {
            ApplicationInfo applicationInfo = this.getApplicationInfo(string2, 0);
            return this.getApplicationIcon(applicationInfo);
        }

        @Override
        public ApplicationInfo getApplicationInfo(String string2, int n) throws PackageManager.NameNotFoundException {
            try {
                ApplicationInfo applicationInfo;
                ApplicationInfo applicationInfo2 = applicationInfo = this.mPM.getApplicationInfo(string2, n);
                if (applicationInfo2 != null) {
                    return applicationInfo2;
                }
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
            throw new PackageManager.NameNotFoundException(string2);
        }

        @Override
        public CharSequence getApplicationLabel(ApplicationInfo applicationInfo) {
            return applicationInfo.loadLabel(this);
        }

        @Override
        public Drawable getApplicationLogo(ApplicationInfo applicationInfo) {
            return applicationInfo.loadLogo(this);
        }

        @Override
        public Drawable getApplicationLogo(String string2) throws PackageManager.NameNotFoundException {
            ApplicationInfo applicationInfo = this.getApplicationInfo(string2, 0);
            return this.getApplicationLogo(applicationInfo);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int getComponentEnabledSetting(ComponentName componentName) {
            try {
                int n = this.mPM.getComponentEnabledSetting(componentName);
                return n;
            }
            catch (RemoteException remoteException) {
                return 0;
            }
        }

        @Override
        public Drawable getDefaultActivityIcon() {
            return Resources.getSystem().getDrawable(17301651);
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Drawable getDrawable(String string2, int n, ApplicationInfo applicationInfo) {
            ResourceName resourceName = new ResourceName(string2, n);
            Drawable drawable2 = this.getCachedIcon(resourceName);
            if (drawable2 != null) {
                return drawable2;
            }
            if (applicationInfo == null) {
                ApplicationInfo applicationInfo2;
                int n2 = 0;
                applicationInfo = applicationInfo2 = this.getApplicationInfo(string2, n2);
            }
            drawable2 = this.getResourcesForApplication(applicationInfo).getDrawable(n);
            this.putCachedIcon(resourceName, drawable2);
            return drawable2;
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return null;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                StringBuilder stringBuilder = new StringBuilder().append("Failure retrieving resources for");
                String string3 = applicationInfo.packageName;
                String string4 = stringBuilder.append(string3).toString();
                int n3 = Log.w("PackageManager", string4);
                return null;
            }
            catch (RuntimeException runtimeException) {
                StringBuilder stringBuilder = new StringBuilder().append("Failure retrieving icon 0x");
                String string5 = Integer.toHexString(n);
                String string6 = stringBuilder.append(string5).append(" in package ").append(string2).toString();
                int n4 = Log.w("PackageManager", string6, runtimeException);
                return null;
            }
        }

        @Override
        public List<ApplicationInfo> getInstalledApplications(int n) {
            try {
                List<ApplicationInfo> list = this.mPM.getInstalledApplications(n);
                return list;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public List<PackageInfo> getInstalledPackages(int n) {
            try {
                List<PackageInfo> list = this.mPM.getInstalledPackages(n);
                return list;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String getInstallerPackageName(String string2) {
            try {
                String string3 = this.mPM.getInstallerPackageName(string2);
                return string3;
            }
            catch (RemoteException remoteException) {
                return null;
            }
        }

        @Override
        public InstrumentationInfo getInstrumentationInfo(ComponentName componentName, int n) throws PackageManager.NameNotFoundException {
            try {
                InstrumentationInfo instrumentationInfo;
                InstrumentationInfo instrumentationInfo2 = instrumentationInfo = this.mPM.getInstrumentationInfo(componentName, n);
                if (instrumentationInfo2 != null) {
                    return instrumentationInfo2;
                }
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
            String string2 = componentName.toString();
            throw new PackageManager.NameNotFoundException(string2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Intent getLaunchIntentForPackage(String string2) {
            Intent intent = new Intent("android.intent.action.MAIN");
            Intent intent2 = intent.addCategory("android.intent.category.INFO");
            Intent intent3 = intent.setPackage(string2);
            ResolveInfo resolveInfo = this.resolveActivity(intent, 0);
            if (resolveInfo == null) {
                intent.removeCategory("android.intent.category.INFO");
                Intent intent4 = intent.addCategory("android.intent.category.LAUNCHER");
                Intent intent5 = intent.setPackage(string2);
                resolveInfo = this.resolveActivity(intent, 0);
            }
            if (resolveInfo == null) {
                return null;
            }
            Intent intent6 = new Intent("android.intent.action.MAIN");
            String string3 = resolveInfo.activityInfo.name;
            Intent intent7 = intent6.setClassName(string2, string3);
            Intent intent8 = intent6.setFlags(0x10000000);
            return intent6;
        }

        @Override
        public String getNameForUid(int n) {
            try {
                String string2 = this.mPM.getNameForUid(n);
                return string2;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public int[] getPackageGids(String string2) throws PackageManager.NameNotFoundException {
            try {
                int n;
                int[] nArray = this.mPM.getPackageGids(string2);
                if (nArray == null || (n = nArray.length) > 0) {
                    return nArray;
                }
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
            throw new PackageManager.NameNotFoundException(string2);
        }

        @Override
        public PackageInfo getPackageInfo(String string2, int n) throws PackageManager.NameNotFoundException {
            try {
                PackageInfo packageInfo;
                PackageInfo packageInfo2 = packageInfo = this.mPM.getPackageInfo(string2, n);
                if (packageInfo2 != null) {
                    return packageInfo2;
                }
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
            throw new PackageManager.NameNotFoundException(string2);
        }

        @Override
        public void getPackageSizeInfo(String string2, IPackageStatsObserver iPackageStatsObserver) {
            try {
                this.mPM.getPackageSizeInfo(string2, iPackageStatsObserver);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public String[] getPackagesForUid(int n) {
            try {
                String[] stringArray = this.mPM.getPackagesForUid(n);
                return stringArray;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public PermissionGroupInfo getPermissionGroupInfo(String string2, int n) throws PackageManager.NameNotFoundException {
            try {
                PermissionGroupInfo permissionGroupInfo;
                PermissionGroupInfo permissionGroupInfo2 = permissionGroupInfo = this.mPM.getPermissionGroupInfo(string2, n);
                if (permissionGroupInfo2 != null) {
                    return permissionGroupInfo2;
                }
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
            throw new PackageManager.NameNotFoundException(string2);
        }

        @Override
        public PermissionInfo getPermissionInfo(String string2, int n) throws PackageManager.NameNotFoundException {
            try {
                PermissionInfo permissionInfo;
                PermissionInfo permissionInfo2 = permissionInfo = this.mPM.getPermissionInfo(string2, n);
                if (permissionInfo2 != null) {
                    return permissionInfo2;
                }
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
            throw new PackageManager.NameNotFoundException(string2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int getPreferredActivities(List<IntentFilter> list, List<ComponentName> list2, String string2) {
            try {
                int n = this.mPM.getPreferredActivities(list, list2, string2);
                return n;
            }
            catch (RemoteException remoteException) {
                return 0;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public List<PackageInfo> getPreferredPackages(int n) {
            try {
                List<PackageInfo> list = this.mPM.getPreferredPackages(n);
                return list;
            }
            catch (RemoteException remoteException) {
                return new ArrayList();
            }
        }

        @Override
        public ProviderInfo getProviderInfo(ComponentName componentName, int n) throws PackageManager.NameNotFoundException {
            try {
                ProviderInfo providerInfo;
                ProviderInfo providerInfo2 = providerInfo = this.mPM.getProviderInfo(componentName, n);
                if (providerInfo2 != null) {
                    return providerInfo2;
                }
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
            String string2 = componentName.toString();
            throw new PackageManager.NameNotFoundException(string2);
        }

        @Override
        public ActivityInfo getReceiverInfo(ComponentName componentName, int n) throws PackageManager.NameNotFoundException {
            try {
                ActivityInfo activityInfo;
                ActivityInfo activityInfo2 = activityInfo = this.mPM.getReceiverInfo(componentName, n);
                if (activityInfo2 != null) {
                    return activityInfo2;
                }
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
            String string2 = componentName.toString();
            throw new PackageManager.NameNotFoundException(string2);
        }

        @Override
        public Resources getResourcesForActivity(ComponentName componentName) throws PackageManager.NameNotFoundException {
            ApplicationInfo applicationInfo = this.getActivityInfo((ComponentName)componentName, (int)0).applicationInfo;
            return this.getResourcesForApplication(applicationInfo);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Resources getResourcesForApplication(ApplicationInfo applicationInfo) throws PackageManager.NameNotFoundException {
            LoadedApk loadedApk;
            if (applicationInfo.packageName.equals("system")) {
                return this.mContext.mMainThread.getSystemContext().getResources();
            }
            ActivityThread activityThread = this.mContext.mMainThread;
            int n = applicationInfo.uid;
            int n2 = Process.myUid();
            String string2 = n != n2 ? applicationInfo.sourceDir : applicationInfo.publicSourceDir;
            Resources resources = activityThread.getTopLevelResources(string2, loadedApk = this.mContext.mPackageInfo);
            if (resources != null) {
                return resources;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Unable to open ");
            String string3 = applicationInfo.publicSourceDir;
            String string4 = stringBuilder.append(string3).toString();
            throw new PackageManager.NameNotFoundException(string4);
        }

        @Override
        public Resources getResourcesForApplication(String string2) throws PackageManager.NameNotFoundException {
            ApplicationInfo applicationInfo = this.getApplicationInfo(string2, 0);
            return this.getResourcesForApplication(applicationInfo);
        }

        @Override
        public ServiceInfo getServiceInfo(ComponentName componentName, int n) throws PackageManager.NameNotFoundException {
            try {
                ServiceInfo serviceInfo;
                ServiceInfo serviceInfo2 = serviceInfo = this.mPM.getServiceInfo(componentName, n);
                if (serviceInfo2 != null) {
                    return serviceInfo2;
                }
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
            String string2 = componentName.toString();
            throw new PackageManager.NameNotFoundException(string2);
        }

        @Override
        public FeatureInfo[] getSystemAvailableFeatures() {
            try {
                FeatureInfo[] featureInfoArray = this.mPM.getSystemAvailableFeatures();
                return featureInfoArray;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public String[] getSystemSharedLibraryNames() {
            try {
                String[] stringArray = this.mPM.getSystemSharedLibraryNames();
                return stringArray;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public CharSequence getText(String string2, int n, ApplicationInfo applicationInfo) {
            ResourceName resourceName = new ResourceName(string2, n);
            CharSequence charSequence = this.getCachedString(resourceName);
            if (charSequence != null) {
                return charSequence;
            }
            if (applicationInfo == null) {
                ApplicationInfo applicationInfo2;
                int n2 = 0;
                applicationInfo = applicationInfo2 = this.getApplicationInfo(string2, n2);
            }
            charSequence = this.getResourcesForApplication(applicationInfo).getText(n);
            this.putCachedString(resourceName, charSequence);
            return charSequence;
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return null;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                StringBuilder stringBuilder = new StringBuilder().append("Failure retrieving resources for");
                String string3 = applicationInfo.packageName;
                String string4 = stringBuilder.append(string3).toString();
                int n3 = Log.w("PackageManager", string4);
                return null;
            }
            catch (RuntimeException runtimeException) {
                StringBuilder stringBuilder = new StringBuilder().append("Failure retrieving text 0x");
                String string5 = Integer.toHexString(n);
                String string6 = stringBuilder.append(string5).append(" in package ").append(string2).toString();
                int n4 = Log.w("PackageManager", string6, runtimeException);
                return null;
            }
        }

        @Override
        public int getUidForSharedUser(String string2) throws PackageManager.NameNotFoundException {
            try {
                int n;
                int n2 = n = this.mPM.getUidForSharedUser(string2);
                if (n2 != -1) {
                    return n2;
                }
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
            String string3 = "No shared userid for user:" + string2;
            throw new PackageManager.NameNotFoundException(string3);
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public XmlResourceParser getXml(String string2, int n, ApplicationInfo object) {
            Object object2;
            if (object == null) {
                int n2 = 0;
                object = object2 = this.getApplicationInfo(string2, n2);
            }
            object2 = this.getResourcesForApplication((ApplicationInfo)object).getXml(n);
            return object2;
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return null;
            }
            catch (RuntimeException runtimeException) {
                StringBuilder stringBuilder = new StringBuilder().append("Failure retrieving xml 0x");
                String string3 = Integer.toHexString(n);
                String string4 = stringBuilder.append(string3).append(" in package ").append(string2).toString();
                int n3 = Log.w("PackageManager", string4, runtimeException);
                return null;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                StringBuilder stringBuilder = new StringBuilder().append("Failure retrieving resources for");
                String string5 = ((ApplicationInfo)object).packageName;
                String string6 = stringBuilder.append(string5).toString();
                int n4 = Log.w("PackageManager", string6);
                return null;
            }
        }

        @Override
        public boolean hasSystemFeature(String string2) {
            try {
                boolean bl = this.mPM.hasSystemFeature(string2);
                return bl;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public void installPackage(Uri uri, IPackageInstallObserver iPackageInstallObserver, int n, String string2) {
            try {
                this.mPM.installPackage(uri, iPackageInstallObserver, n, string2);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean isSafeMode() {
            try {
                int n;
                if (this.mCachedSafeMode < 0) {
                    n = this.mPM.isSafeMode() ? 1 : 0;
                    this.mCachedSafeMode = n;
                }
                if ((n = this.mCachedSafeMode) == 0) return false;
                return true;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public void movePackage(String string2, IPackageMoveObserver iPackageMoveObserver, int n) {
            try {
                this.mPM.movePackage(string2, iPackageMoveObserver, n);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public List<ResolveInfo> queryBroadcastReceivers(Intent intent, int n) {
            try {
                IPackageManager iPackageManager = this.mPM;
                ContentResolver contentResolver = this.mContext.getContentResolver();
                String string2 = intent.resolveTypeIfNeeded(contentResolver);
                List<ResolveInfo> list = iPackageManager.queryIntentReceivers(intent, string2, n);
                return list;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public List<ProviderInfo> queryContentProviders(String string2, int n, int n2) {
            try {
                List<ProviderInfo> list = this.mPM.queryContentProviders(string2, n, n2);
                return list;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public List<InstrumentationInfo> queryInstrumentation(String string2, int n) {
            try {
                List<InstrumentationInfo> list = this.mPM.queryInstrumentation(string2, n);
                return list;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public List<ResolveInfo> queryIntentActivities(Intent intent, int n) {
            try {
                IPackageManager iPackageManager = this.mPM;
                ContentResolver contentResolver = this.mContext.getContentResolver();
                String string2 = intent.resolveTypeIfNeeded(contentResolver);
                List<ResolveInfo> list = iPackageManager.queryIntentActivities(intent, string2, n);
                return list;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public List<ResolveInfo> queryIntentActivityOptions(ComponentName componentName, Intent[] intentArray, Intent intent, int n) {
            ContentResolver contentResolver = this.mContext.getContentResolver();
            String[] stringArray = null;
            if (intentArray != null) {
                int n2 = intentArray.length;
                for (int i = 0; i < n2; ++i) {
                    String string2;
                    Intent intent2 = intentArray[i];
                    if (intent2 == null || (string2 = intent2.resolveTypeIfNeeded(contentResolver)) == null) continue;
                    if (stringArray == null) {
                        stringArray = new String[n2];
                    }
                    stringArray[i] = string2;
                }
            }
            try {
                IPackageManager iPackageManager = this.mPM;
                Intent intent3 = intent;
                ContentResolver contentResolver2 = contentResolver;
                String string3 = intent3.resolveTypeIfNeeded(contentResolver2);
                ComponentName componentName2 = componentName;
                Intent[] intentArray2 = intentArray;
                Intent intent4 = intent;
                int n3 = n;
                List<ResolveInfo> list = iPackageManager.queryIntentActivityOptions(componentName2, intentArray2, stringArray, intent4, string3, n3);
                return list;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public List<ResolveInfo> queryIntentServices(Intent intent, int n) {
            try {
                IPackageManager iPackageManager = this.mPM;
                ContentResolver contentResolver = this.mContext.getContentResolver();
                String string2 = intent.resolveTypeIfNeeded(contentResolver);
                List<ResolveInfo> list = iPackageManager.queryIntentServices(intent, string2, n);
                return list;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public List<PermissionInfo> queryPermissionsByGroup(String string2, int n) throws PackageManager.NameNotFoundException {
            try {
                List<PermissionInfo> list;
                List<PermissionInfo> list2 = list = this.mPM.queryPermissionsByGroup(string2, n);
                if (list2 != null) {
                    return list2;
                }
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
            throw new PackageManager.NameNotFoundException(string2);
        }

        @Override
        public void removePackageFromPreferred(String string2) {
            try {
                this.mPM.removePackageFromPreferred(string2);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public void removePermission(String string2) {
            try {
                this.mPM.removePermission(string2);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public void replacePreferredActivity(IntentFilter intentFilter, int n, ComponentName[] componentNameArray, ComponentName componentName) {
            try {
                this.mPM.replacePreferredActivity(intentFilter, n, componentNameArray, componentName);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public ResolveInfo resolveActivity(Intent intent, int n) {
            try {
                IPackageManager iPackageManager = this.mPM;
                ContentResolver contentResolver = this.mContext.getContentResolver();
                String string2 = intent.resolveTypeIfNeeded(contentResolver);
                ResolveInfo resolveInfo = iPackageManager.resolveIntent(intent, string2, n);
                return resolveInfo;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public ProviderInfo resolveContentProvider(String string2, int n) {
            try {
                ProviderInfo providerInfo = this.mPM.resolveContentProvider(string2, n);
                return providerInfo;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public ResolveInfo resolveService(Intent intent, int n) {
            try {
                IPackageManager iPackageManager = this.mPM;
                ContentResolver contentResolver = this.mContext.getContentResolver();
                String string2 = intent.resolveTypeIfNeeded(contentResolver);
                ResolveInfo resolveInfo = iPackageManager.resolveService(intent, string2, n);
                return resolveInfo;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public void setApplicationEnabledSetting(String string2, int n, int n2) {
            try {
                this.mPM.setApplicationEnabledSetting(string2, n, n2);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public void setComponentEnabledSetting(ComponentName componentName, int n, int n2) {
            try {
                this.mPM.setComponentEnabledSetting(componentName, n, n2);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        private static final class ResourceName {
            final int iconId;
            final String packageName;

            ResourceName(ApplicationInfo applicationInfo, int n) {
                String string2 = applicationInfo.packageName;
                this(string2, n);
            }

            ResourceName(ComponentInfo componentInfo, int n) {
                String string2 = componentInfo.applicationInfo.packageName;
                this(string2, n);
            }

            ResourceName(ResolveInfo resolveInfo, int n) {
                String string2 = resolveInfo.activityInfo.applicationInfo.packageName;
                this(string2, n);
            }

            ResourceName(String string2, int n) {
                this.packageName = string2;
                this.iconId = n;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object object) {
                Class<? extends Object> clazz;
                if (this == object) {
                    return true;
                }
                if (object == null) return false;
                Class<? extends Object> clazz2 = this.getClass();
                if (clazz2 != (clazz = object.getClass())) {
                    return false;
                }
                ResourceName resourceName = (ResourceName)object;
                int n = this.iconId;
                int n2 = resourceName.iconId;
                if (n != n2) {
                    return false;
                }
                if (this.packageName != null) {
                    String string2 = this.packageName;
                    String string3 = resourceName.packageName;
                    if (string2.equals(string3)) return true;
                    return false;
                }
                if (resourceName.packageName != null) return false;
                return true;
            }

            public int hashCode() {
                int n = this.packageName.hashCode() * 31;
                int n2 = this.iconId;
                return n + n2;
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder().append("{ResourceName ");
                String string2 = this.packageName;
                StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" / ");
                int n = this.iconId;
                return stringBuilder2.append(n).append("}").toString();
            }
        }
    }

    private static final class ApplicationContentResolver
    extends ContentResolver {
        private final ActivityThread mMainThread;

        public ApplicationContentResolver(Context context, ActivityThread activityThread) {
            super(context);
            this.mMainThread = activityThread;
        }

        @Override
        protected IContentProvider acquireExistingProvider(Context context, String string2) {
            return this.mMainThread.acquireExistingProvider(context, string2);
        }

        @Override
        protected IContentProvider acquireProvider(Context context, String string2) {
            return this.mMainThread.acquireProvider(context, string2);
        }

        @Override
        public boolean releaseProvider(IContentProvider iContentProvider) {
            return this.mMainThread.releaseProvider(iContentProvider);
        }
    }
}

