/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.SearchManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.ContextMenu;
import android.view.ContextThemeWrapper;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import com.android.internal.policy.PolicyManager;
import java.lang.ref.WeakReference;

public class Dialog
implements DialogInterface,
Window.Callback,
KeyEvent.Callback,
View.OnCreateContextMenuListener {
    private static final int CANCEL = 68;
    private static final String DIALOG_HIERARCHY_TAG = "android:dialogHierarchy";
    private static final String DIALOG_SHOWING_TAG = "android:dialogShowing";
    private static final int DISMISS = 67;
    private static final int SHOW = 69;
    private Message mCancelMessage;
    protected boolean mCancelable = true;
    private boolean mCanceledOnTouchOutside = false;
    final Context mContext;
    private boolean mCreated = false;
    View mDecor;
    private final Runnable mDismissAction;
    private Message mDismissMessage;
    private final Handler mHandler;
    private Handler mListenersHandler;
    private DialogInterface.OnKeyListener mOnKeyListener;
    private Activity mOwnerActivity;
    private Message mShowMessage;
    private boolean mShowing = false;
    private final Thread mUiThread;
    Window mWindow;
    final WindowManager mWindowManager;

    public Dialog(Context context) {
        this(context, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Dialog(Context context, int n) {
        Thread thread;
        Window window;
        WindowManager windowManager;
        Runnable runnable;
        Handler handler;
        this.mHandler = handler = new Handler();
        this.mDismissAction = runnable = new Runnable(){

            @Override
            public void run() {
                Dialog.this.dismissDialog();
            }
        };
        int n2 = n == 0 ? 16973835 : n;
        ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper(context, n2);
        this.mContext = contextThemeWrapper;
        this.mWindowManager = windowManager = (WindowManager)context.getSystemService("window");
        this.mWindow = window = PolicyManager.makeNewWindow(this.mContext);
        window.setCallback(this);
        WindowManager windowManager2 = this.mWindowManager;
        window.setWindowManager(windowManager2, null, null);
        window.setGravity(17);
        this.mUiThread = thread = Thread.currentThread();
        ListenersHandler listenersHandler = new ListenersHandler(this);
        this.mListenersHandler = listenersHandler;
    }

    protected Dialog(Context context, boolean bl, DialogInterface.OnCancelListener onCancelListener) {
        this(context);
        this.mCancelable = bl;
        this.setOnCancelListener(onCancelListener);
    }

    @Deprecated
    protected Dialog(Context context, boolean bl, Message message) {
        this(context);
        this.mCancelable = bl;
        this.mCancelMessage = message;
    }

    private void dismissDialog() {
        if (this.mDecor == null) {
            return;
        }
        if (!this.mShowing) {
            return;
        }
        try {
            WindowManager windowManager = this.mWindowManager;
            View view = this.mDecor;
            windowManager.removeView(view);
            return;
        }
        finally {
            this.mDecor = null;
            this.mWindow.closeAllPanels();
            this.onStop();
            this.mShowing = false;
            this.sendDismissMessage();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ComponentName getAssociatedActivity() {
        Activity activity = this.mOwnerActivity;
        Context context = this.getContext();
        while (activity == null && context != null) {
            if (context instanceof Activity) {
                activity = (Activity)context;
                continue;
            }
            if (context instanceof ContextWrapper) {
                context = ((ContextWrapper)context).getBaseContext();
                continue;
            }
            context = null;
        }
        if (activity != null) return activity.getComponentName();
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isOutOfBounds(MotionEvent motionEvent) {
        int n = (int)motionEvent.getX();
        int n2 = (int)motionEvent.getY();
        int n3 = ViewConfiguration.get(this.mContext).getScaledWindowTouchSlop();
        View view = this.getWindow().getDecorView();
        int n4 = -n3;
        if (n < n4) return true;
        int n5 = -n3;
        if (n2 < n5) return true;
        int n6 = view.getWidth() + n3;
        if (n > n6) return true;
        int n7 = view.getHeight() + n3;
        if (n2 <= n7) return false;
        return true;
    }

    private void sendDismissMessage() {
        if (this.mDismissMessage == null) {
            return;
        }
        Message.obtain(this.mDismissMessage).sendToTarget();
    }

    private void sendShowMessage() {
        if (this.mShowMessage == null) {
            return;
        }
        Message.obtain(this.mShowMessage).sendToTarget();
    }

    public void addContentView(View view, ViewGroup.LayoutParams layoutParams) {
        this.mWindow.addContentView(view, layoutParams);
    }

    @Override
    public void cancel() {
        if (this.mCancelMessage != null) {
            Message.obtain(this.mCancelMessage).sendToTarget();
        }
        this.dismiss();
    }

    public void closeOptionsMenu() {
        this.mWindow.closePanel(0);
    }

    @Override
    public void dismiss() {
        Thread thread;
        Thread thread2 = Thread.currentThread();
        if (thread2 != (thread = this.mUiThread)) {
            Handler handler = this.mHandler;
            Runnable runnable = this.mDismissAction;
            boolean bl = handler.post(runnable);
            return;
        }
        this.mDismissAction.run();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        KeyEvent.DispatcherState dispatcherState;
        int n;
        DialogInterface.OnKeyListener onKeyListener;
        if (this.mOnKeyListener != null && (onKeyListener = this.mOnKeyListener).onKey(this, n = keyEvent.getKeyCode(), keyEvent)) {
            return true;
        }
        if (this.mWindow.superDispatchKeyEvent(keyEvent)) {
            return true;
        }
        if (this.mDecor != null) {
            dispatcherState = this.mDecor.getKeyDispatcherState();
            return keyEvent.dispatch(this, dispatcherState, this);
        }
        dispatcherState = null;
        return keyEvent.dispatch(this, dispatcherState, this);
    }

    void dispatchOnCreate(Bundle bundle) {
        if (this.mCreated) {
            return;
        }
        this.onCreate(bundle);
        this.mCreated = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        String string2 = this.getClass().getName();
        accessibilityEvent.setClassName(string2);
        String string3 = this.mContext.getPackageName();
        accessibilityEvent.setPackageName(string3);
        WindowManager.LayoutParams layoutParams = this.getWindow().getAttributes();
        boolean bl = layoutParams.width == -1 && layoutParams.height == -1;
        accessibilityEvent.setFullScreen(bl);
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        if (!this.mWindow.superDispatchTouchEvent(motionEvent)) return this.onTouchEvent(motionEvent);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean dispatchTrackballEvent(MotionEvent motionEvent) {
        if (!this.mWindow.superDispatchTrackballEvent(motionEvent)) return this.onTrackballEvent(motionEvent);
        return true;
    }

    public View findViewById(int n) {
        return this.mWindow.findViewById(n);
    }

    public final Context getContext() {
        return this.mContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public View getCurrentFocus() {
        if (this.mWindow == null) return null;
        return this.mWindow.getCurrentFocus();
    }

    public LayoutInflater getLayoutInflater() {
        return this.getWindow().getLayoutInflater();
    }

    public final Activity getOwnerActivity() {
        return this.mOwnerActivity;
    }

    public final int getVolumeControlStream() {
        return this.getWindow().getVolumeControlStream();
    }

    public Window getWindow() {
        return this.mWindow;
    }

    public void hide() {
        if (this.mDecor == null) {
            return;
        }
        this.mDecor.setVisibility(8);
    }

    public boolean isShowing() {
        return this.mShowing;
    }

    @Override
    public void onAttachedToWindow() {
    }

    public void onBackPressed() {
        if (!this.mCancelable) {
            return;
        }
        this.cancel();
    }

    @Override
    public void onContentChanged() {
    }

    public boolean onContextItemSelected(MenuItem menuItem) {
        return false;
    }

    public void onContextMenuClosed(Menu menu) {
    }

    protected void onCreate(Bundle bundle) {
    }

    @Override
    public void onCreateContextMenu(ContextMenu contextMenu, View view, ContextMenu.ContextMenuInfo contextMenuInfo) {
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onCreatePanelMenu(int n, Menu menu) {
        if (n != 0) return false;
        return this.onCreateOptionsMenu(menu);
    }

    @Override
    public View onCreatePanelView(int n) {
        return null;
    }

    @Override
    public void onDetachedFromWindow() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (n != 4) return false;
        keyEvent.startTracking();
        return true;
    }

    @Override
    public boolean onKeyLongPress(int n, KeyEvent keyEvent) {
        return false;
    }

    @Override
    public boolean onKeyMultiple(int n, int n2, KeyEvent keyEvent) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        if (n != 4) return false;
        if (!keyEvent.isTracking()) return false;
        if (keyEvent.isCanceled()) return false;
        this.onBackPressed();
        return true;
    }

    @Override
    public boolean onMenuItemSelected(int n, MenuItem menuItem) {
        return false;
    }

    @Override
    public boolean onMenuOpened(int n, Menu menu) {
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        return false;
    }

    public void onOptionsMenuClosed(Menu menu) {
    }

    @Override
    public void onPanelClosed(int n, Menu menu) {
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onPreparePanel(int n, View view, Menu menu) {
        if (n != 0) return true;
        if (menu == null) return true;
        if (!this.onPrepareOptionsMenu(menu)) return false;
        if (!menu.hasVisibleItems()) return false;
        return true;
    }

    public void onRestoreInstanceState(Bundle bundle) {
        Bundle bundle2 = bundle.getBundle(DIALOG_HIERARCHY_TAG);
        if (bundle2 == null) {
            return;
        }
        this.dispatchOnCreate(bundle);
        this.mWindow.restoreHierarchyState(bundle2);
        if (!bundle.getBoolean(DIALOG_SHOWING_TAG)) {
            return;
        }
        this.show();
    }

    public Bundle onSaveInstanceState() {
        Bundle bundle = new Bundle();
        boolean bl = this.mShowing;
        bundle.putBoolean(DIALOG_SHOWING_TAG, bl);
        if (this.mCreated) {
            Bundle bundle2 = this.mWindow.saveHierarchyState();
            bundle.putBundle(DIALOG_HIERARCHY_TAG, bundle2);
        }
        return bundle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onSearchRequested() {
        SearchManager searchManager = (SearchManager)this.mContext.getSystemService("search");
        ComponentName componentName = this.getAssociatedActivity();
        if (componentName == null) return false;
        Bundle bundle = null;
        boolean bl = false;
        searchManager.startSearch(null, false, componentName, bundle, bl);
        this.dismiss();
        return true;
    }

    protected void onStart() {
    }

    protected void onStop() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (!this.mCancelable) return false;
        if (!this.mCanceledOnTouchOutside) return false;
        if (motionEvent.getAction() != 0) return false;
        if (!this.isOutOfBounds(motionEvent)) return false;
        this.cancel();
        return true;
    }

    public boolean onTrackballEvent(MotionEvent motionEvent) {
        return false;
    }

    @Override
    public void onWindowAttributesChanged(WindowManager.LayoutParams layoutParams) {
        if (this.mDecor == null) {
            return;
        }
        WindowManager windowManager = this.mWindowManager;
        View view = this.mDecor;
        windowManager.updateViewLayout(view, layoutParams);
    }

    @Override
    public void onWindowFocusChanged(boolean bl) {
    }

    public void openContextMenu(View view) {
        boolean bl = view.showContextMenu();
    }

    public void openOptionsMenu() {
        this.mWindow.openPanel(0, null);
    }

    public void registerForContextMenu(View view) {
        view.setOnCreateContextMenuListener(this);
    }

    public final boolean requestWindowFeature(int n) {
        return this.getWindow().requestFeature(n);
    }

    public void setCancelMessage(Message message) {
        this.mCancelMessage = message;
    }

    public void setCancelable(boolean bl) {
        this.mCancelable = bl;
    }

    public void setCanceledOnTouchOutside(boolean bl) {
        if (bl && !this.mCancelable) {
            this.mCancelable = true;
        }
        this.mCanceledOnTouchOutside = bl;
    }

    public void setContentView(int n) {
        this.mWindow.setContentView(n);
    }

    public void setContentView(View view) {
        this.mWindow.setContentView(view);
    }

    public void setContentView(View view, ViewGroup.LayoutParams layoutParams) {
        this.mWindow.setContentView(view, layoutParams);
    }

    public void setDismissMessage(Message message) {
        this.mDismissMessage = message;
    }

    public final void setFeatureDrawable(int n, Drawable drawable2) {
        this.getWindow().setFeatureDrawable(n, drawable2);
    }

    public final void setFeatureDrawableAlpha(int n, int n2) {
        this.getWindow().setFeatureDrawableAlpha(n, n2);
    }

    public final void setFeatureDrawableResource(int n, int n2) {
        this.getWindow().setFeatureDrawableResource(n, n2);
    }

    public final void setFeatureDrawableUri(int n, Uri uri) {
        this.getWindow().setFeatureDrawableUri(n, uri);
    }

    public void setOnCancelListener(DialogInterface.OnCancelListener onCancelListener) {
        if (onCancelListener != null) {
            Message message;
            this.mCancelMessage = message = this.mListenersHandler.obtainMessage(68, onCancelListener);
            return;
        }
        this.mCancelMessage = null;
    }

    public void setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        if (onDismissListener != null) {
            Message message;
            this.mDismissMessage = message = this.mListenersHandler.obtainMessage(67, onDismissListener);
            return;
        }
        this.mDismissMessage = null;
    }

    public void setOnKeyListener(DialogInterface.OnKeyListener onKeyListener) {
        this.mOnKeyListener = onKeyListener;
    }

    public void setOnShowListener(DialogInterface.OnShowListener onShowListener) {
        if (onShowListener != null) {
            Message message;
            this.mShowMessage = message = this.mListenersHandler.obtainMessage(69, onShowListener);
            return;
        }
        this.mShowMessage = null;
    }

    public final void setOwnerActivity(Activity activity) {
        this.mOwnerActivity = activity;
        Window window = this.getWindow();
        int n = this.mOwnerActivity.getVolumeControlStream();
        window.setVolumeControlStream(n);
    }

    public void setTitle(int n) {
        CharSequence charSequence = this.mContext.getText(n);
        this.setTitle(charSequence);
    }

    public void setTitle(CharSequence charSequence) {
        this.mWindow.setTitle(charSequence);
        this.mWindow.getAttributes().setTitle(charSequence);
    }

    public final void setVolumeControlStream(int n) {
        this.getWindow().setVolumeControlStream(n);
    }

    public void show() {
        View view;
        if (this.mShowing) {
            if (this.mDecor == null) {
                return;
            }
            this.mDecor.setVisibility(0);
            return;
        }
        if (!this.mCreated) {
            this.dispatchOnCreate(null);
        }
        this.onStart();
        this.mDecor = view = this.mWindow.getDecorView();
        WindowManager.LayoutParams layoutParams = this.mWindow.getAttributes();
        if ((layoutParams.softInputMode & 0x100) == 0) {
            int n;
            WindowManager.LayoutParams layoutParams2 = new WindowManager.LayoutParams();
            int n2 = layoutParams2.copyFrom(layoutParams);
            layoutParams2.softInputMode = n = layoutParams2.softInputMode | 0x100;
            layoutParams = layoutParams2;
        }
        WindowManager windowManager = this.mWindowManager;
        View view2 = this.mDecor;
        windowManager.addView(view2, layoutParams);
        this.mShowing = true;
        this.sendShowMessage();
        return;
    }

    public void takeKeyEvents(boolean bl) {
        this.mWindow.takeKeyEvents(bl);
    }

    public void unregisterForContextMenu(View view) {
        view.setOnCreateContextMenuListener(null);
    }

    private static final class ListenersHandler
    extends Handler {
        private WeakReference<DialogInterface> mDialog;

        public ListenersHandler(Dialog dialog) {
            WeakReference<Dialog> weakReference = new WeakReference<Dialog>(dialog);
            this.mDialog = weakReference;
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case 67: {
                    DialogInterface.OnDismissListener onDismissListener = (DialogInterface.OnDismissListener)message.obj;
                    DialogInterface dialogInterface = (DialogInterface)this.mDialog.get();
                    onDismissListener.onDismiss(dialogInterface);
                    return;
                }
                case 68: {
                    DialogInterface.OnCancelListener onCancelListener = (DialogInterface.OnCancelListener)message.obj;
                    DialogInterface dialogInterface = (DialogInterface)this.mDialog.get();
                    onCancelListener.onCancel(dialogInterface);
                    return;
                }
                case 69: 
            }
            DialogInterface.OnShowListener onShowListener = (DialogInterface.OnShowListener)message.obj;
            DialogInterface dialogInterface = (DialogInterface)this.mDialog.get();
            onShowListener.onShow(dialogInterface);
        }
    }
}

