/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.CursorWrapper;
import android.net.Uri;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.provider.Downloads;
import android.util.Pair;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DownloadManager {
    public static final String ACTION_DOWNLOAD_COMPLETE = "android.intent.action.DOWNLOAD_COMPLETE";
    public static final String ACTION_NOTIFICATION_CLICKED = "android.intent.action.DOWNLOAD_NOTIFICATION_CLICKED";
    public static final String ACTION_VIEW_DOWNLOADS = "android.intent.action.VIEW_DOWNLOADS";
    private static final String[] COLUMNS;
    public static final String COLUMN_BYTES_DOWNLOADED_SO_FAR = "bytes_so_far";
    public static final String COLUMN_DESCRIPTION = "description";
    public static final String COLUMN_ID = "_id";
    public static final String COLUMN_LAST_MODIFIED_TIMESTAMP = "last_modified_timestamp";
    public static final String COLUMN_LOCAL_URI = "local_uri";
    public static final String COLUMN_MEDIAPROVIDER_URI = "mediaprovider_uri";
    public static final String COLUMN_MEDIA_TYPE = "media_type";
    public static final String COLUMN_REASON = "reason";
    public static final String COLUMN_STATUS = "status";
    public static final String COLUMN_TITLE = "title";
    public static final String COLUMN_TOTAL_SIZE_BYTES = "total_size";
    public static final String COLUMN_URI = "uri";
    public static final int ERROR_CANNOT_RESUME = 1008;
    public static final int ERROR_DEVICE_NOT_FOUND = 1007;
    public static final int ERROR_FILE_ALREADY_EXISTS = 1009;
    public static final int ERROR_FILE_ERROR = 1001;
    public static final int ERROR_HTTP_DATA_ERROR = 1004;
    public static final int ERROR_INSUFFICIENT_SPACE = 1006;
    public static final int ERROR_TOO_MANY_REDIRECTS = 1005;
    public static final int ERROR_UNHANDLED_HTTP_CODE = 1002;
    public static final int ERROR_UNKNOWN = 1000;
    public static final String EXTRA_DOWNLOAD_ID = "extra_download_id";
    private static final Set<String> LONG_COLUMNS;
    public static final int PAUSED_QUEUED_FOR_WIFI = 3;
    public static final int PAUSED_UNKNOWN = 4;
    public static final int PAUSED_WAITING_FOR_NETWORK = 2;
    public static final int PAUSED_WAITING_TO_RETRY = 1;
    public static final int STATUS_FAILED = 16;
    public static final int STATUS_PAUSED = 4;
    public static final int STATUS_PENDING = 1;
    public static final int STATUS_RUNNING = 2;
    public static final int STATUS_SUCCESSFUL = 8;
    private static final String TAG = "DownloadManager";
    private static final String[] UNDERLYING_COLUMNS;
    private Uri mBaseUri;
    private String mPackageName;
    private ContentResolver mResolver;

    static {
        String[] stringArray = new String[]{COLUMN_ID, COLUMN_MEDIAPROVIDER_URI, COLUMN_TITLE, COLUMN_DESCRIPTION, COLUMN_URI, COLUMN_MEDIA_TYPE, COLUMN_TOTAL_SIZE_BYTES, COLUMN_LOCAL_URI, COLUMN_STATUS, COLUMN_REASON, COLUMN_BYTES_DOWNLOADED_SO_FAR, COLUMN_LAST_MODIFIED_TIMESTAMP};
        COLUMNS = stringArray;
        String[] stringArray2 = new String[]{COLUMN_ID, COLUMN_MEDIAPROVIDER_URI, COLUMN_TITLE, COLUMN_DESCRIPTION, COLUMN_URI, "mimetype", "total_bytes", COLUMN_STATUS, "current_bytes", "lastmod", "destination", "hint", "_data"};
        UNDERLYING_COLUMNS = stringArray2;
        String[] stringArray3 = new String[]{COLUMN_ID, COLUMN_TOTAL_SIZE_BYTES, COLUMN_STATUS, COLUMN_REASON, COLUMN_BYTES_DOWNLOADED_SO_FAR, COLUMN_LAST_MODIFIED_TIMESTAMP};
        List<String> list = Arrays.asList(stringArray3);
        LONG_COLUMNS = new HashSet<String>(list);
    }

    public DownloadManager(ContentResolver contentResolver, String string2) {
        Uri uri;
        this.mBaseUri = uri = Downloads.Impl.CONTENT_URI;
        this.mResolver = contentResolver;
        this.mPackageName = string2;
    }

    static String[] getWhereArgsForIds(long[] lArray) {
        int n;
        String[] stringArray = new String[lArray.length];
        for (int i = 0; i < (n = lArray.length); ++i) {
            String string2;
            stringArray[i] = string2 = Long.toString(lArray[i]);
        }
        return stringArray;
    }

    static String getWhereClauseForIds(long[] lArray) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("(");
        for (int i = 0; i < (n = lArray.length); ++i) {
            if (i > 0) {
                StringBuilder stringBuilder3 = stringBuilder.append("OR ");
            }
            StringBuilder stringBuilder4 = stringBuilder.append(COLUMN_ID);
            StringBuilder stringBuilder5 = stringBuilder.append(" = ? ");
        }
        StringBuilder stringBuilder6 = stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public long enqueue(Request request) {
        String string2 = this.mPackageName;
        ContentValues contentValues = request.toContentValues(string2);
        ContentResolver contentResolver = this.mResolver;
        Uri uri = Downloads.CONTENT_URI;
        return Long.parseLong(contentResolver.insert(uri, contentValues).getLastPathSegment());
    }

    Uri getDownloadUri(long l) {
        return ContentUris.withAppendedId(this.mBaseUri, l);
    }

    public int markRowDeleted(long ... lArray) {
        if (lArray == null || lArray.length == 0) {
            throw new IllegalArgumentException("input param 'ids' can't be null");
        }
        ContentValues contentValues = new ContentValues();
        Integer n = 1;
        contentValues.put("deleted", n);
        ContentResolver contentResolver = this.mResolver;
        Uri uri = this.mBaseUri;
        String string2 = DownloadManager.getWhereClauseForIds(lArray);
        String[] stringArray = DownloadManager.getWhereArgsForIds(lArray);
        return contentResolver.update(uri, contentValues, string2, stringArray);
    }

    public ParcelFileDescriptor openDownloadedFile(long l) throws FileNotFoundException {
        ContentResolver contentResolver = this.mResolver;
        Uri uri = this.getDownloadUri(l);
        return contentResolver.openFileDescriptor(uri, "r");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Cursor query(Query query) {
        ContentResolver contentResolver = this.mResolver;
        String[] stringArray = UNDERLYING_COLUMNS;
        Uri uri = this.mBaseUri;
        Cursor cursor = query.runQuery(contentResolver, stringArray, uri);
        if (cursor == null) {
            return null;
        }
        Uri uri2 = this.mBaseUri;
        return new CursorTranslator(cursor, uri2);
    }

    public int remove(long ... lArray) {
        if (lArray == null || lArray.length == 0) {
            throw new IllegalArgumentException("input param 'ids' can't be null");
        }
        ContentResolver contentResolver = this.mResolver;
        Uri uri = this.mBaseUri;
        String string2 = DownloadManager.getWhereClauseForIds(lArray);
        String[] stringArray = DownloadManager.getWhereArgsForIds(lArray);
        return contentResolver.delete(uri, string2, stringArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void restartDownload(long ... lArray) {
        Query query = new Query().setFilterById(lArray);
        Cursor cursor = this.query(query);
        try {
            boolean bl = cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                int n = cursor.getColumnIndex(COLUMN_STATUS);
                int n2 = cursor.getInt(n);
                if (n2 != 8 && n2 != 16) {
                    StringBuilder stringBuilder = new StringBuilder().append("Cannot restart incomplete download: ");
                    int n3 = cursor.getColumnIndex(COLUMN_ID);
                    long l = cursor.getLong(n3);
                    String string2 = stringBuilder.append(l).toString();
                    throw new IllegalArgumentException(string2);
                }
                boolean bl2 = cursor.moveToNext();
            }
        }
        finally {
            cursor.close();
        }
        ContentValues contentValues = new ContentValues();
        Integer n = 0;
        contentValues.put("current_bytes", n);
        Integer n4 = -1;
        contentValues.put("total_bytes", n4);
        contentValues.putNull("_data");
        Integer n5 = 190;
        contentValues.put(COLUMN_STATUS, n5);
        ContentResolver contentResolver = this.mResolver;
        Uri uri = this.mBaseUri;
        String string3 = DownloadManager.getWhereClauseForIds(lArray);
        String[] stringArray = DownloadManager.getWhereArgsForIds(lArray);
        int n6 = contentResolver.update(uri, contentValues, string3, stringArray);
    }

    public void setAccessAllDownloads(boolean bl) {
        Uri uri;
        if (bl) {
            Uri uri2;
            this.mBaseUri = uri2 = Downloads.Impl.ALL_DOWNLOADS_CONTENT_URI;
            return;
        }
        this.mBaseUri = uri = Downloads.Impl.CONTENT_URI;
    }

    private static class CursorTranslator
    extends CursorWrapper {
        static final /* synthetic */ boolean $assertionsDisabled;
        private Uri mBaseUri;

        /*
         * Enabled aggressive block sorting
         */
        static {
            boolean bl = !DownloadManager.class.desiredAssertionStatus();
            $assertionsDisabled = bl;
        }

        public CursorTranslator(Cursor cursor, Uri uri) {
            super(cursor);
            this.mBaseUri = uri;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private long getErrorCode(int n) {
            if (400 <= n) {
                if (n < 488) return n;
            }
            if (500 <= n && n < 600) {
                return n;
            }
            switch (n) {
                default: {
                    return 1000L;
                }
                case 492: {
                    return 1001L;
                }
                case 493: 
                case 494: {
                    return 1002L;
                }
                case 495: {
                    return 1004L;
                }
                case 497: {
                    return 1005L;
                }
                case 498: {
                    return 1006L;
                }
                case 499: {
                    return 1007L;
                }
                case 489: {
                    return 1008L;
                }
                case 488: 
            }
            return 1009L;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String getLocalUri() {
            long l = this.getUnderlyingLong("destination");
            if (l == 4L) {
                return this.getUnderlyingString("hint");
            }
            if (l == 0L) {
                String string2 = this.getUnderlyingString("_data");
                if (string2 != null) return Uri.fromFile(new File(string2)).toString();
                return null;
            }
            long l2 = this.getUnderlyingLong(DownloadManager.COLUMN_ID);
            return ContentUris.withAppendedId(this.mBaseUri, l2).toString();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private long getPausedReason(int n) {
            switch (n) {
                default: {
                    return 4L;
                }
                case 194: {
                    return 1L;
                }
                case 195: {
                    return 2L;
                }
                case 196: 
            }
            return 3L;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private long getReason(int n) {
            switch (this.translateStatus(n)) {
                default: {
                    return 0L;
                }
                case 16: {
                    return this.getErrorCode(n);
                }
                case 4: 
            }
            return this.getPausedReason(n);
        }

        private long getUnderlyingLong(String string2) {
            int n = super.getColumnIndex(string2);
            return super.getLong(n);
        }

        private String getUnderlyingString(String string2) {
            int n = super.getColumnIndex(string2);
            return super.getString(n);
        }

        private boolean isLongColumn(String string2) {
            return LONG_COLUMNS.contains(string2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private long translateLong(String string2) {
            if (!this.isLongColumn(string2)) {
                return Long.valueOf(this.translateString(string2));
            }
            if (string2.equals(DownloadManager.COLUMN_ID)) {
                return this.getUnderlyingLong(DownloadManager.COLUMN_ID);
            }
            if (string2.equals(DownloadManager.COLUMN_TOTAL_SIZE_BYTES)) {
                return this.getUnderlyingLong("total_bytes");
            }
            if (string2.equals(DownloadManager.COLUMN_STATUS)) {
                int n = (int)this.getUnderlyingLong(DownloadManager.COLUMN_STATUS);
                return this.translateStatus(n);
            }
            if (string2.equals(DownloadManager.COLUMN_REASON)) {
                int n = (int)this.getUnderlyingLong(DownloadManager.COLUMN_STATUS);
                return this.getReason(n);
            }
            if (string2.equals(DownloadManager.COLUMN_BYTES_DOWNLOADED_SO_FAR)) {
                return this.getUnderlyingLong("current_bytes");
            }
            if ($assertionsDisabled) return this.getUnderlyingLong("lastmod");
            if (string2.equals(DownloadManager.COLUMN_LAST_MODIFIED_TIMESTAMP)) return this.getUnderlyingLong("lastmod");
            throw new AssertionError();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int translateStatus(int n) {
            switch (n) {
                default: {
                    if ($assertionsDisabled) return 16;
                    if (Downloads.isStatusError(n)) return 16;
                    throw new AssertionError();
                }
                case 190: {
                    return 1;
                }
                case 192: {
                    return 2;
                }
                case 193: 
                case 194: 
                case 195: 
                case 196: {
                    return 4;
                }
                case 200: {
                    return 8;
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String translateString(String string2) {
            if (this.isLongColumn(string2)) {
                return Long.toString(this.translateLong(string2));
            }
            if (string2.equals(DownloadManager.COLUMN_TITLE)) {
                return this.getUnderlyingString(DownloadManager.COLUMN_TITLE);
            }
            if (string2.equals(DownloadManager.COLUMN_DESCRIPTION)) {
                return this.getUnderlyingString(DownloadManager.COLUMN_DESCRIPTION);
            }
            if (string2.equals(DownloadManager.COLUMN_URI)) {
                return this.getUnderlyingString(DownloadManager.COLUMN_URI);
            }
            if (string2.equals(DownloadManager.COLUMN_MEDIA_TYPE)) {
                return this.getUnderlyingString("mimetype");
            }
            if (string2.equals(DownloadManager.COLUMN_MEDIAPROVIDER_URI)) {
                return this.getUnderlyingString(DownloadManager.COLUMN_MEDIAPROVIDER_URI);
            }
            if ($assertionsDisabled) return this.getLocalUri();
            if (string2.equals(DownloadManager.COLUMN_LOCAL_URI)) return this.getLocalUri();
            throw new AssertionError();
        }

        @Override
        public byte[] getBlob(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getColumnCount() {
            return COLUMNS.length;
        }

        @Override
        public int getColumnIndex(String string2) {
            return Arrays.asList(COLUMNS).indexOf(string2);
        }

        @Override
        public int getColumnIndexOrThrow(String string2) throws IllegalArgumentException {
            int n = this.getColumnIndex(string2);
            if (n == -1) {
                String string3 = "No such column: " + string2;
                throw new IllegalArgumentException(string3);
            }
            return n;
        }

        @Override
        public String getColumnName(int n) {
            int n2 = COLUMNS.length;
            if (n < 0 || n >= n2) {
                String string2 = "Invalid column index " + n + ", " + n2 + " columns exist";
                throw new IllegalArgumentException(string2);
            }
            return COLUMNS[n];
        }

        @Override
        public String[] getColumnNames() {
            String[] stringArray = new String[COLUMNS.length];
            String[] stringArray2 = COLUMNS;
            int n = COLUMNS.length;
            System.arraycopy(stringArray2, 0, stringArray, 0, n);
            return stringArray;
        }

        @Override
        public double getDouble(int n) {
            return this.getLong(n);
        }

        @Override
        public float getFloat(int n) {
            return (float)this.getDouble(n);
        }

        @Override
        public int getInt(int n) {
            return (int)this.getLong(n);
        }

        @Override
        public long getLong(int n) {
            String string2 = this.getColumnName(n);
            return this.translateLong(string2);
        }

        @Override
        public short getShort(int n) {
            return (short)this.getLong(n);
        }

        @Override
        public String getString(int n) {
            String string2 = this.getColumnName(n);
            return this.translateString(string2);
        }
    }

    public static class Query {
        public static final int ORDER_ASCENDING = 1;
        public static final int ORDER_DESCENDING = 2;
        private long[] mIds = null;
        private boolean mOnlyIncludeVisibleInDownloadsUi = false;
        private String mOrderByColumn = "lastmod";
        private int mOrderDirection = 2;
        private Integer mStatusFlags = null;

        private String joinStrings(String string2, Iterable<String> iterable) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            for (String string3 : iterable) {
                if (!bl) {
                    StringBuilder stringBuilder2 = stringBuilder.append(string2);
                }
                StringBuilder stringBuilder3 = stringBuilder.append(string3);
                bl = false;
            }
            return stringBuilder.toString();
        }

        private String statusClause(String string2, int n) {
            return DownloadManager.COLUMN_STATUS + string2 + "'" + n + "'";
        }

        /*
         * Enabled aggressive block sorting
         */
        public Query orderBy(String string2, int n) {
            if (n != 1 && n != 2) {
                String string3 = "Invalid direction: " + n;
                throw new IllegalArgumentException(string3);
            }
            if (string2.equals(DownloadManager.COLUMN_LAST_MODIFIED_TIMESTAMP)) {
                this.mOrderByColumn = "lastmod";
            } else {
                if (!string2.equals(DownloadManager.COLUMN_TOTAL_SIZE_BYTES)) {
                    String string4 = "Cannot order by " + string2;
                    throw new IllegalArgumentException(string4);
                }
                this.mOrderByColumn = "total_bytes";
            }
            this.mOrderDirection = n;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        Cursor runQuery(ContentResolver contentResolver, String[] stringArray, Uri uri) {
            Uri uri2 = uri;
            ArrayList<String> arrayList = new ArrayList<String>();
            String[] stringArray2 = null;
            if (this.mIds != null) {
                String string2 = DownloadManager.getWhereClauseForIds(this.mIds);
                boolean bl = arrayList.add(string2);
                stringArray2 = DownloadManager.getWhereArgsForIds(this.mIds);
            }
            if (this.mStatusFlags != null) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                if ((this.mStatusFlags & 1) != 0) {
                    String string3 = this.statusClause("=", 190);
                    boolean bl = arrayList2.add(string3);
                }
                if ((this.mStatusFlags & 2) != 0) {
                    String string4 = this.statusClause("=", 192);
                    boolean bl = arrayList2.add(string4);
                }
                if ((this.mStatusFlags & 4) != 0) {
                    String string5 = this.statusClause("=", 193);
                    boolean bl = arrayList2.add(string5);
                    String string6 = this.statusClause("=", 194);
                    boolean bl2 = arrayList2.add(string6);
                    String string7 = this.statusClause("=", 195);
                    boolean bl3 = arrayList2.add(string7);
                    String string8 = this.statusClause("=", 196);
                    boolean bl4 = arrayList2.add(string8);
                }
                if ((this.mStatusFlags & 8) != 0) {
                    String string9 = this.statusClause("=", 200);
                    boolean bl = arrayList2.add(string9);
                }
                if ((this.mStatusFlags & 0x10) != 0) {
                    StringBuilder stringBuilder = new StringBuilder().append("(");
                    String string10 = this.statusClause(">=", 400);
                    StringBuilder stringBuilder2 = stringBuilder.append(string10).append(" AND ");
                    String string11 = this.statusClause("<", 600);
                    String string12 = stringBuilder2.append(string11).append(")").toString();
                    boolean bl = arrayList2.add(string12);
                }
                String string13 = this.joinStrings(" OR ", arrayList2);
                boolean bl = arrayList.add(string13);
            }
            if (this.mOnlyIncludeVisibleInDownloadsUi) {
                boolean bl = arrayList.add("is_visible_in_downloads_ui != '0'");
            }
            boolean bl = arrayList.add("deleted != '1'");
            String string14 = this.joinStrings(" AND ", arrayList);
            String string15 = this.mOrderDirection == 1 ? "ASC" : "DESC";
            StringBuilder stringBuilder = new StringBuilder();
            String string16 = this.mOrderByColumn;
            String string17 = stringBuilder.append(string16).append(" ").append(string15).toString();
            ContentResolver contentResolver2 = contentResolver;
            String[] stringArray3 = stringArray;
            return contentResolver2.query(uri2, stringArray3, string14, stringArray2, string17);
        }

        public Query setFilterById(long ... lArray) {
            this.mIds = lArray;
            return this;
        }

        public Query setFilterByStatus(int n) {
            Integer n2;
            this.mStatusFlags = n2 = Integer.valueOf(n);
            return this;
        }

        public Query setOnlyIncludeVisibleInDownloadsUi(boolean bl) {
            this.mOnlyIncludeVisibleInDownloadsUi = bl;
            return this;
        }
    }

    public static class Request {
        static final /* synthetic */ boolean $assertionsDisabled = false;
        public static final int NETWORK_MOBILE = 1;
        public static final int NETWORK_WIFI = 2;
        private int mAllowedNetworkTypes;
        private CharSequence mDescription;
        private Uri mDestinationUri;
        private boolean mIsVisibleInDownloadsUi;
        private String mMimeType;
        private List<Pair<String, String>> mRequestHeaders;
        private boolean mRoamingAllowed;
        private boolean mShowNotification;
        private CharSequence mTitle;
        private Uri mUri;

        /*
         * Enabled aggressive block sorting
         */
        static {
            boolean bl = !DownloadManager.class.desiredAssertionStatus();
            $assertionsDisabled = bl;
        }

        public Request(Uri uri) {
            ArrayList<Pair<String, String>> arrayList = new ArrayList<Pair<String, String>>();
            this.mRequestHeaders = arrayList;
            this.mShowNotification = true;
            this.mRoamingAllowed = true;
            this.mAllowedNetworkTypes = -1;
            this.mIsVisibleInDownloadsUi = true;
            if (uri == null) {
                throw new NullPointerException();
            }
            String string2 = uri.getScheme();
            if (string2 == null || !string2.equals("http")) {
                String string3 = "Can only download HTTP URIs: " + uri;
                throw new IllegalArgumentException(string3);
            }
            this.mUri = uri;
        }

        private void encodeHttpHeaders(ContentValues contentValues) {
            int n = 0;
            Iterator<Pair<String, String>> iterator = this.mRequestHeaders.iterator();
            while (iterator.hasNext()) {
                Pair<String, String> pair = iterator.next();
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = (String)pair.first;
                StringBuilder stringBuilder2 = stringBuilder.append(string2).append(": ");
                String string3 = (String)pair.second;
                String string4 = stringBuilder2.append(string3).toString();
                String string5 = "http_header_" + n;
                contentValues.put(string5, string4);
                ++n;
            }
            return;
        }

        private void putIfNonNull(ContentValues contentValues, String string2, Object object) {
            if (object == null) {
                return;
            }
            String string3 = object.toString();
            contentValues.put(string2, string3);
        }

        private void setDestinationFromBase(File file, String string2) {
            Uri uri;
            if (string2 == null) {
                throw new NullPointerException("subPath cannot be null");
            }
            this.mDestinationUri = uri = Uri.withAppendedPath(Uri.fromFile(file), string2);
        }

        public Request addRequestHeader(String string2, String string3) {
            if (string2 == null) {
                throw new NullPointerException("header cannot be null");
            }
            if (string2.contains(":")) {
                throw new IllegalArgumentException("header may not contain ':'");
            }
            if (string3 == null) {
                string3 = "";
            }
            List<Pair<String, String>> list = this.mRequestHeaders;
            Pair<String, String> pair = Pair.create(string2, string3);
            boolean bl = list.add(pair);
            return this;
        }

        public Request setAllowedNetworkTypes(int n) {
            this.mAllowedNetworkTypes = n;
            return this;
        }

        public Request setAllowedOverRoaming(boolean bl) {
            this.mRoamingAllowed = bl;
            return this;
        }

        public Request setDescription(CharSequence charSequence) {
            this.mDescription = charSequence;
            return this;
        }

        public Request setDestinationInExternalFilesDir(Context context, String string2, String string3) {
            File file = context.getExternalFilesDir(string2);
            this.setDestinationFromBase(file, string3);
            return this;
        }

        public Request setDestinationInExternalPublicDir(String string2, String string3) {
            File file = Environment.getExternalStoragePublicDirectory(string2);
            this.setDestinationFromBase(file, string3);
            return this;
        }

        public Request setDestinationUri(Uri uri) {
            this.mDestinationUri = uri;
            return this;
        }

        public Request setMimeType(String string2) {
            this.mMimeType = string2;
            return this;
        }

        public Request setShowRunningNotification(boolean bl) {
            this.mShowNotification = bl;
            return this;
        }

        public Request setTitle(CharSequence charSequence) {
            this.mTitle = charSequence;
            return this;
        }

        public Request setVisibleInDownloadsUi(boolean bl) {
            this.mIsVisibleInDownloadsUi = bl;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        ContentValues toContentValues(String string2) {
            ContentValues contentValues = new ContentValues();
            if (!$assertionsDisabled && this.mUri == null) {
                throw new AssertionError();
            }
            String string3 = this.mUri.toString();
            contentValues.put(DownloadManager.COLUMN_URI, string3);
            Boolean bl = true;
            contentValues.put("is_public_api", bl);
            contentValues.put("notificationpackage", string2);
            if (this.mDestinationUri != null) {
                Integer n = 4;
                contentValues.put("destination", n);
                String string4 = this.mDestinationUri.toString();
                contentValues.put("hint", string4);
            } else {
                Integer n = 2;
                contentValues.put("destination", n);
            }
            if (!this.mRequestHeaders.isEmpty()) {
                this.encodeHttpHeaders(contentValues);
            }
            CharSequence charSequence = this.mTitle;
            this.putIfNonNull(contentValues, DownloadManager.COLUMN_TITLE, charSequence);
            CharSequence charSequence2 = this.mDescription;
            this.putIfNonNull(contentValues, DownloadManager.COLUMN_DESCRIPTION, charSequence2);
            String string5 = this.mMimeType;
            this.putIfNonNull(contentValues, "mimetype", string5);
            String string6 = "visibility";
            int n = this.mShowNotification ? 0 : 2;
            Integer n2 = n;
            contentValues.put(string6, n2);
            Integer n3 = this.mAllowedNetworkTypes;
            contentValues.put("allowed_network_types", n3);
            Boolean bl2 = this.mRoamingAllowed;
            contentValues.put("allow_roaming", bl2);
            Boolean bl3 = this.mIsVisibleInDownloadsUi;
            contentValues.put("is_visible_in_downloads_ui", bl3);
            return contentValues;
        }
    }
}

