/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.Application;
import android.app.IActivityManager;
import android.app.IApplicationThread;
import android.app.IInstrumentationWatcher;
import android.app.Instrumentation;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.PerformanceCollector;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.AndroidRuntimeException;
import android.util.Log;
import android.view.IWindowManager;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class Instrumentation {
    public static final String REPORT_KEY_IDENTIFIER = "id";
    public static final String REPORT_KEY_STREAMRESULT = "stream";
    private static final String TAG = "Instrumentation";
    private List<ActivityMonitor> mActivityMonitors;
    private Context mAppContext;
    private boolean mAutomaticPerformanceSnapshots;
    private ComponentName mComponent;
    private Context mInstrContext;
    private MessageQueue mMessageQueue;
    private Bundle mPerfMetrics;
    private PerformanceCollector mPerformanceCollector;
    private Thread mRunner;
    private final Object mSync;
    private ActivityThread mThread;
    private List<ActivityWaiter> mWaitingActivities;
    private IInstrumentationWatcher mWatcher;

    public Instrumentation() {
        Bundle bundle;
        Object object;
        this.mSync = object = new Object();
        this.mThread = null;
        this.mMessageQueue = null;
        this.mAutomaticPerformanceSnapshots = false;
        this.mPerfMetrics = bundle = new Bundle();
    }

    private void addValue(String string2, int n, Bundle bundle) {
        if (bundle.containsKey(string2)) {
            ArrayList<Integer> arrayList = bundle.getIntegerArrayList(string2);
            if (arrayList == null) {
                return;
            }
            Integer n2 = n;
            boolean bl = arrayList.add(n2);
            return;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Integer n3 = n;
        boolean bl = arrayList.add(n3);
        bundle.putIntegerArrayList(string2, arrayList);
    }

    static void checkStartActivityResult(int n, Object object) {
        if (n >= 0) {
            return;
        }
        switch (n) {
            default: {
                String string2 = "Unknown error code " + n + " when starting " + object;
                throw new AndroidRuntimeException(string2);
            }
            case -2: 
            case -1: {
                if (object instanceof Intent && ((Intent)object).getComponent() != null) {
                    StringBuilder stringBuilder = new StringBuilder().append("Unable to find explicit activity class ");
                    String string3 = ((Intent)object).getComponent().toShortString();
                    String string4 = stringBuilder.append(string3).append("; have you declared this activity in your AndroidManifest.xml?").toString();
                    throw new ActivityNotFoundException(string4);
                }
                String string5 = "No Activity found to handle " + object;
                throw new ActivityNotFoundException(string5);
            }
            case -4: {
                String string6 = "Not allowed to start activity " + object;
                throw new SecurityException(string6);
            }
            case -3: {
                throw new AndroidRuntimeException("FORWARD_RESULT_FLAG used while also requesting a result");
            }
            case -5: 
        }
        throw new IllegalArgumentException("PendingIntent is not an activity");
    }

    public static Application newApplication(Class<?> clazz, Context context) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Application application = (Application)clazz.newInstance();
        application.attach(context);
        return application;
    }

    private final void validateNotAppThread() {
        if (ActivityThread.currentActivityThread() == null) {
            return;
        }
        throw new RuntimeException("This method can not be called from the main application thread");
    }

    public ActivityMonitor addMonitor(IntentFilter intentFilter, ActivityResult activityResult, boolean bl) {
        ActivityMonitor activityMonitor = new ActivityMonitor(intentFilter, activityResult, bl);
        this.addMonitor(activityMonitor);
        return activityMonitor;
    }

    public ActivityMonitor addMonitor(String string2, ActivityResult activityResult, boolean bl) {
        ActivityMonitor activityMonitor = new ActivityMonitor(string2, activityResult, bl);
        this.addMonitor(activityMonitor);
        return activityMonitor;
    }

    public void addMonitor(ActivityMonitor activityMonitor) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mActivityMonitors == null) {
                ArrayList<ActivityMonitor> arrayList = new ArrayList<ActivityMonitor>();
                this.mActivityMonitors = arrayList;
            }
            boolean bl = this.mActivityMonitors.add(activityMonitor);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void callActivityOnCreate(Activity activity, Bundle bundle) {
        int n;
        int n2;
        if (this.mWaitingActivities != null) {
            Object object = this.mSync;
            synchronized (object) {
                n2 = this.mWaitingActivities.size();
                for (n = 0; n < n2; ++n) {
                    ActivityWaiter activityWaiter = this.mWaitingActivities.get(n);
                    Intent intent = activityWaiter.intent;
                    Intent intent2 = activity.getIntent();
                    if (!intent.filterEquals(intent2)) continue;
                    activityWaiter.activity = activity;
                    MessageQueue messageQueue = this.mMessageQueue;
                    ActivityGoing activityGoing = new ActivityGoing(activityWaiter);
                    messageQueue.addIdleHandler(activityGoing);
                }
            }
        }
        activity.onCreate(bundle);
        if (this.mActivityMonitors == null) {
            return;
        }
        Object object = this.mSync;
        synchronized (object) {
            n2 = this.mActivityMonitors.size();
            n = 0;
            while (n < n2) {
                ActivityMonitor activityMonitor = this.mActivityMonitors.get(n);
                Intent intent = activity.getIntent();
                boolean bl = activityMonitor.match(activity, activity, intent);
                ++n;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void callActivityOnDestroy(Activity activity) {
        int n;
        int n2;
        if (this.mWaitingActivities != null) {
            Object object = this.mSync;
            synchronized (object) {
                n2 = this.mWaitingActivities.size();
                for (n = 0; n < n2; ++n) {
                    ActivityWaiter activityWaiter = this.mWaitingActivities.get(n);
                    Intent intent = activityWaiter.intent;
                    Intent intent2 = activity.getIntent();
                    if (!intent.filterEquals(intent2)) continue;
                    activityWaiter.activity = activity;
                    MessageQueue messageQueue = this.mMessageQueue;
                    ActivityGoing activityGoing = new ActivityGoing(activityWaiter);
                    messageQueue.addIdleHandler(activityGoing);
                }
            }
        }
        activity.onDestroy();
        if (this.mActivityMonitors == null) {
            return;
        }
        Object object = this.mSync;
        synchronized (object) {
            n2 = this.mActivityMonitors.size();
            n = 0;
            while (n < n2) {
                ActivityMonitor activityMonitor = this.mActivityMonitors.get(n);
                Intent intent = activity.getIntent();
                boolean bl = activityMonitor.match(activity, activity, intent);
                ++n;
            }
            return;
        }
    }

    public void callActivityOnNewIntent(Activity activity, Intent intent) {
        activity.onNewIntent(intent);
    }

    public void callActivityOnPause(Activity activity) {
        activity.performPause();
    }

    public void callActivityOnPostCreate(Activity activity, Bundle bundle) {
        activity.onPostCreate(bundle);
    }

    public void callActivityOnRestart(Activity activity) {
        activity.onRestart();
    }

    public void callActivityOnRestoreInstanceState(Activity activity, Bundle bundle) {
        activity.performRestoreInstanceState(bundle);
    }

    public void callActivityOnResume(Activity activity) {
        activity.mResumed = true;
        activity.onResume();
        if (this.mActivityMonitors == null) {
            return;
        }
        Object object = this.mSync;
        synchronized (object) {
            int n = this.mActivityMonitors.size();
            for (int i = 0; i < n; ++i) {
                ActivityMonitor activityMonitor = this.mActivityMonitors.get(i);
                Intent intent = activity.getIntent();
                boolean bl = activityMonitor.match(activity, activity, intent);
            }
            return;
        }
    }

    public void callActivityOnSaveInstanceState(Activity activity, Bundle bundle) {
        activity.performSaveInstanceState(bundle);
    }

    public void callActivityOnStart(Activity activity) {
        activity.onStart();
    }

    public void callActivityOnStop(Activity activity) {
        activity.onStop();
    }

    public void callActivityOnUserLeaving(Activity activity) {
        activity.performUserLeaving();
    }

    public void callApplicationOnCreate(Application application) {
        application.onCreate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkMonitorHit(ActivityMonitor activityMonitor, int n) {
        this.waitForIdleSync();
        Object object = this.mSync;
        synchronized (object) {
            if (activityMonitor.getHits() < n) {
                return (boolean)null;
            }
            boolean bl = this.mActivityMonitors.remove(activityMonitor);
            return (boolean)null;
        }
    }

    public void endPerformanceSnapshot() {
        Bundle bundle;
        if (this.isProfiling()) {
            return;
        }
        this.mPerfMetrics = bundle = this.mPerformanceCollector.endSnapshot();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ActivityResult execStartActivity(Context context, IBinder iBinder, IBinder iBinder2, Activity activity, Intent intent, int n) {
        Object object;
        Object object2 = (IApplicationThread)((Object)iBinder);
        if (this.mActivityMonitors != null) {
            object = this.mSync;
            synchronized (object) {
                int n2;
                int n3;
                int n4 = this.mActivityMonitors.size();
                int n5 = 0;
                while ((n3 = n5) < (n2 = n4)) {
                    int n6;
                    Intent intent2;
                    Activity activity2;
                    Context context2;
                    int n7;
                    ActivityMonitor activityMonitor;
                    ActivityMonitor activityMonitor2;
                    List<ActivityMonitor> list = this.mActivityMonitors;
                    if (!(activityMonitor2 = (activityMonitor = list.get(n7 = n5++))).match(context2 = context, activity2 = null, intent2 = intent)) continue;
                    activityMonitor.mHits = n6 = activityMonitor.mHits + 1;
                    if (!activityMonitor.isBlocking()) break;
                    if (n < 0) return null;
                    object2 = activityMonitor.getResult();
                    return object2;
                }
            }
        }
        try {
            object = ActivityManagerNative.getDefault();
            ContentResolver contentResolver = context.getContentResolver();
            Intent intent3 = intent;
            ContentResolver contentResolver2 = contentResolver;
            String string2 = intent3.resolveTypeIfNeeded(contentResolver2);
            Uri[] uriArray = null;
            int n8 = 0;
            String string3 = activity != null ? activity.mEmbeddedID : null;
            Intent intent4 = intent;
            IBinder iBinder3 = iBinder2;
            int n9 = n;
            int n10 = object.startActivity((IApplicationThread)object2, intent4, string2, uriArray, n8, iBinder3, string3, n9, false, false);
            Intent intent5 = intent;
            Instrumentation.checkStartActivityResult(n10, intent5);
            return null;
        }
        catch (RemoteException remoteException) {}
        return null;
    }

    public void finish(int n, Bundle bundle) {
        if (this.mAutomaticPerformanceSnapshots) {
            this.endPerformanceSnapshot();
        }
        if (this.mPerfMetrics != null) {
            Bundle bundle2 = this.mPerfMetrics;
            bundle.putAll(bundle2);
        }
        this.mThread.finishInstrumentation(n, bundle);
    }

    public Bundle getAllocCounts() {
        Bundle bundle = new Bundle();
        long l = Debug.getGlobalAllocCount();
        bundle.putLong("global_alloc_count", l);
        long l2 = Debug.getGlobalAllocSize();
        bundle.putLong("global_alloc_size", l2);
        long l3 = Debug.getGlobalFreedCount();
        bundle.putLong("global_freed_count", l3);
        long l4 = Debug.getGlobalFreedSize();
        bundle.putLong("global_freed_size", l4);
        long l5 = Debug.getGlobalGcInvocationCount();
        bundle.putLong("gc_invocation_count", l5);
        return bundle;
    }

    public Bundle getBinderCounts() {
        Bundle bundle = new Bundle();
        long l = Debug.getBinderSentTransactions();
        bundle.putLong("sent_transactions", l);
        long l2 = Debug.getBinderReceivedTransactions();
        bundle.putLong("received_transactions", l2);
        return bundle;
    }

    public ComponentName getComponentName() {
        return this.mComponent;
    }

    public Context getContext() {
        return this.mInstrContext;
    }

    public Context getTargetContext() {
        return this.mAppContext;
    }

    final void init(ActivityThread activityThread, Context context, Context context2, ComponentName componentName, IInstrumentationWatcher iInstrumentationWatcher) {
        MessageQueue messageQueue;
        this.mThread = activityThread;
        Looper looper = this.mThread.getLooper();
        this.mMessageQueue = messageQueue = Looper.myQueue();
        this.mInstrContext = context;
        this.mAppContext = context2;
        this.mComponent = componentName;
        this.mWatcher = iInstrumentationWatcher;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean invokeContextMenuAction(Activity activity, int n, int n2) {
        this.validateNotAppThread();
        KeyEvent keyEvent = new KeyEvent(0, 23);
        this.sendKeySync(keyEvent);
        this.waitForIdleSync();
        try {
            Thread.sleep(ViewConfiguration.getLongPressTimeout());
            KeyEvent keyEvent2 = new KeyEvent(1, 23);
            this.sendKeySync(keyEvent2);
            this.waitForIdleSync();
            1ContextMenuRunnable contextMenuRunnable = new 1ContextMenuRunnable(this, activity, n, n2);
            this.runOnMainSync(contextMenuRunnable);
            return contextMenuRunnable.returnValue;
        }
        catch (InterruptedException interruptedException) {
            int n3 = Log.e(TAG, "Could not sleep for long press timeout", interruptedException);
            return false;
        }
    }

    public boolean invokeMenuActionSync(Activity activity, int n, int n2) {
        1MenuRunnable menuRunnable = new 1MenuRunnable(this, activity, n, n2);
        this.runOnMainSync(menuRunnable);
        return menuRunnable.returnValue;
    }

    public boolean isProfiling() {
        return this.mThread.isProfiling();
    }

    public Activity newActivity(Class<?> clazz, Context context, IBinder iBinder, Application application, Intent intent, ActivityInfo activityInfo, CharSequence charSequence, Activity activity, String string2, Object object) throws InstantiationException, IllegalAccessException {
        Activity activity2 = (Activity)clazz.newInstance();
        Configuration configuration = new Configuration();
        Context context2 = context;
        Instrumentation instrumentation = this;
        IBinder iBinder2 = iBinder;
        Application application2 = application;
        Intent intent2 = intent;
        ActivityInfo activityInfo2 = activityInfo;
        CharSequence charSequence2 = charSequence;
        Activity activity3 = activity;
        String string3 = string2;
        Object object2 = object;
        activity2.attach(context2, null, instrumentation, iBinder2, application2, intent2, activityInfo2, charSequence2, activity3, string3, object2, configuration);
        return activity2;
    }

    public Activity newActivity(ClassLoader classLoader, String string2, Intent intent) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return (Activity)classLoader.loadClass(string2).newInstance();
    }

    public Application newApplication(ClassLoader classLoader, String string2, Context context) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return Instrumentation.newApplication(classLoader.loadClass(string2), context);
    }

    public void onCreate(Bundle bundle) {
    }

    public void onDestroy() {
    }

    public boolean onException(Object object, Throwable throwable) {
        return false;
    }

    public void onStart() {
    }

    public void removeMonitor(ActivityMonitor activityMonitor) {
        Object object = this.mSync;
        synchronized (object) {
            boolean bl = this.mActivityMonitors.remove(activityMonitor);
            return;
        }
    }

    public void runOnMainSync(Runnable runnable) {
        this.validateNotAppThread();
        SyncRunnable syncRunnable = new SyncRunnable(runnable);
        boolean bl = this.mThread.getHandler().post(syncRunnable);
        syncRunnable.waitForComplete();
    }

    public void sendCharacterSync(int n) {
        KeyEvent keyEvent = new KeyEvent(0, n);
        this.sendKeySync(keyEvent);
        KeyEvent keyEvent2 = new KeyEvent(1, n);
        this.sendKeySync(keyEvent2);
    }

    public void sendKeyDownUpSync(int n) {
        KeyEvent keyEvent = new KeyEvent(0, n);
        this.sendKeySync(keyEvent);
        KeyEvent keyEvent2 = new KeyEvent(1, n);
        this.sendKeySync(keyEvent2);
    }

    public void sendKeySync(KeyEvent keyEvent) {
        this.validateNotAppThread();
        try {
            boolean bl = IWindowManager.Stub.asInterface(ServiceManager.getService("window")).injectKeyEvent(keyEvent, true);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void sendPointerSync(MotionEvent motionEvent) {
        this.validateNotAppThread();
        try {
            boolean bl = IWindowManager.Stub.asInterface(ServiceManager.getService("window")).injectPointerEvent(motionEvent, true);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void sendStatus(int n, Bundle bundle) {
        if (this.mWatcher == null) {
            return;
        }
        try {
            IInstrumentationWatcher iInstrumentationWatcher = this.mWatcher;
            ComponentName componentName = this.mComponent;
            iInstrumentationWatcher.instrumentationStatus(componentName, n, bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.mWatcher = null;
            return;
        }
    }

    public void sendStringSync(String string2) {
        char[] cArray;
        if (string2 == null) {
            return;
        }
        KeyCharacterMap keyCharacterMap = KeyCharacterMap.load(0);
        KeyEvent[] keyEventArray = keyCharacterMap.getEvents(cArray = string2.toCharArray());
        if (keyEventArray == null) {
            return;
        }
        int n = 0;
        int n2;
        while (n < (n2 = keyEventArray.length)) {
            KeyEvent keyEvent = keyEventArray[n];
            this.sendKeySync(keyEvent);
            ++n;
        }
        return;
    }

    public void sendTrackballEventSync(MotionEvent motionEvent) {
        this.validateNotAppThread();
        try {
            boolean bl = IWindowManager.Stub.asInterface(ServiceManager.getService("window")).injectTrackballEvent(motionEvent, true);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void setAutomaticPerformanceSnapshots() {
        PerformanceCollector performanceCollector;
        this.mAutomaticPerformanceSnapshots = true;
        this.mPerformanceCollector = performanceCollector = new PerformanceCollector();
    }

    public void setInTouchMode(boolean bl) {
        try {
            IWindowManager.Stub.asInterface(ServiceManager.getService("window")).setInTouchMode(bl);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void start() {
        if (this.mRunner != null) {
            throw new RuntimeException("Instrumentation already started");
        }
        StringBuilder stringBuilder = new StringBuilder().append("Instr: ");
        String string2 = this.getClass().getName();
        String string3 = stringBuilder.append(string2).toString();
        InstrumentationThread instrumentationThread = new InstrumentationThread(string3);
        this.mRunner = instrumentationThread;
        this.mRunner.start();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Activity startActivitySync(Intent var1_1) {
        this.validateNotAppThread();
        var2_2 = this.mSync;
        // MONITORENTER : var2_2
        var3_3 = new Intent(var1_1);
        {
            catch (Throwable var7_9) {
                throw var7_8;
            }
        }
        try {
            var4_4 = this.getTargetContext().getPackageManager();
            var5_5 = var3_3.resolveActivityInfo(var4_4, 0);
            if (var5_5 == null) {
                var6_6 = "Unable to resolve activity for: " + var3_3;
                throw new RuntimeException(var6_6);
            }
            var9_11 = this.mThread.getProcessName();
            if (!var5_5.processName.equals(var9_11)) {
                var10_12 = new StringBuilder().append("Intent in process ").append(var9_11).append(" resolved to different process ");
                var11_13 = var5_5.processName;
                var12_14 = var10_12.append(var11_13).append(": ").append(var3_3).toString();
                throw new RuntimeException(var12_14);
            }
            ** GOTO lbl24
        }
        catch (Throwable var7_7) {
            var8_10 = var3_3;
            throw var7_8;
lbl24:
            // 1 sources

            var13_15 = var5_5.applicationInfo.packageName;
            var14_16 = var5_5.name;
            var15_17 = new ComponentName(var13_15, var14_16);
            var16_18 = var3_3.setComponent(var15_17);
            var17_19 = new ActivityWaiter(var3_3);
            if (this.mWaitingActivities == null) {
                var18_20 = new ArrayList<ActivityWaiter>();
                this.mWaitingActivities = var18_20;
            }
            var19_21 = this.mWaitingActivities.add(var17_19);
            this.getTargetContext().startActivity(var3_3);
        }
        do {
            try {
                this.mSync.wait();
            }
            catch (InterruptedException var21_22) {}
        } while (this.mWaitingActivities.contains(var17_19));
        var20_23 = var17_19.activity;
        // MONITOREXIT : var2_2
        return var20_23;
    }

    public void startAllocCounting() {
        Runtime.getRuntime().gc();
        Runtime.getRuntime().runFinalization();
        Runtime.getRuntime().gc();
        Debug.resetAllCounts();
        Debug.startAllocCounting();
    }

    public void startPerformanceSnapshot() {
        if (this.isProfiling()) {
            return;
        }
        this.mPerformanceCollector.beginSnapshot(null);
    }

    public void startProfiling() {
        if (!this.mThread.isProfiling()) {
            return;
        }
        String string2 = this.mThread.getProfileFilePath();
        File file = new File(string2);
        boolean bl = file.getParentFile().mkdirs();
        Debug.startMethodTracing(file.toString(), 0x800000);
    }

    public void stopAllocCounting() {
        Runtime.getRuntime().gc();
        Runtime.getRuntime().runFinalization();
        Runtime.getRuntime().gc();
        Debug.stopAllocCounting();
    }

    public void stopProfiling() {
        if (!this.mThread.isProfiling()) {
            return;
        }
        Debug.stopMethodTracing();
    }

    public void waitForIdle(Runnable runnable) {
        MessageQueue messageQueue = this.mMessageQueue;
        Idler idler = new Idler(runnable);
        messageQueue.addIdleHandler(idler);
        Handler handler = this.mThread.getHandler();
        EmptyRunnable emptyRunnable = new EmptyRunnable();
        boolean bl = handler.post(emptyRunnable);
    }

    public void waitForIdleSync() {
        this.validateNotAppThread();
        Idler idler = new Idler(null);
        this.mMessageQueue.addIdleHandler(idler);
        Handler handler = this.mThread.getHandler();
        EmptyRunnable emptyRunnable = new EmptyRunnable();
        boolean bl = handler.post(emptyRunnable);
        idler.waitForIdle();
    }

    public Activity waitForMonitor(ActivityMonitor activityMonitor) {
        Activity activity = activityMonitor.waitForActivity();
        Object object = this.mSync;
        synchronized (object) {
            boolean bl = this.mActivityMonitors.remove(activityMonitor);
            return activity;
        }
    }

    public Activity waitForMonitorWithTimeout(ActivityMonitor activityMonitor, long l) {
        Activity activity = activityMonitor.waitForActivityWithTimeout(l);
        Object object = this.mSync;
        synchronized (object) {
            boolean bl = this.mActivityMonitors.remove(activityMonitor);
            return activity;
        }
    }

    private static final class Idler
    implements MessageQueue.IdleHandler {
        private final Runnable mCallback;
        private boolean mIdle;

        public Idler(Runnable runnable) {
            this.mCallback = runnable;
            this.mIdle = false;
        }

        @Override
        public final boolean queueIdle() {
            if (this.mCallback != null) {
                this.mCallback.run();
            }
            synchronized (this) {
                boolean bl = true;
                this.mIdle = bl;
                this.notifyAll();
                return false;
            }
        }

        public void waitForIdle() {
            synchronized (this) {
                while (true) {
                    boolean bl = this.mIdle;
                    if (bl) break;
                    try {
                        this.wait();
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                return;
            }
        }
    }

    private final class ActivityGoing
    implements MessageQueue.IdleHandler {
        private final ActivityWaiter mWaiter;

        public ActivityGoing(ActivityWaiter activityWaiter) {
            this.mWaiter = activityWaiter;
        }

        @Override
        public final boolean queueIdle() {
            Object object = Instrumentation.this.mSync;
            synchronized (object) {
                List list = Instrumentation.this.mWaitingActivities;
                ActivityWaiter activityWaiter = this.mWaiter;
                boolean bl = list.remove(activityWaiter);
                Instrumentation.this.mSync.notifyAll();
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
                object = null;
                return (boolean)object;
            }
        }
    }

    private static final class ActivityWaiter {
        public Activity activity;
        public final Intent intent;

        public ActivityWaiter(Intent intent) {
            this.intent = intent;
        }
    }

    private static final class SyncRunnable
    implements Runnable {
        private boolean mComplete;
        private final Runnable mTarget;

        public SyncRunnable(Runnable runnable) {
            this.mTarget = runnable;
        }

        @Override
        public void run() {
            this.mTarget.run();
            synchronized (this) {
                this.mComplete = true;
                this.notifyAll();
                return;
            }
        }

        public void waitForComplete() {
            synchronized (this) {
                while (true) {
                    boolean bl = this.mComplete;
                    if (bl) break;
                    try {
                        this.wait();
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                return;
            }
        }
    }

    private static final class EmptyRunnable
    implements Runnable {
        private EmptyRunnable() {
        }

        @Override
        public void run() {
        }
    }

    private final class InstrumentationThread
    extends Thread {
        public InstrumentationThread(String string2) {
            super(string2);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            IActivityManager iActivityManager = ActivityManagerNative.getDefault();
            try {
                Process.setThreadPriority(-1);
            }
            catch (RuntimeException runtimeException) {
                StringBuilder stringBuilder = new StringBuilder().append("Exception setting priority of instrumentation thread ");
                int n = Process.myTid();
                String string2 = stringBuilder.append(n).toString();
                int n2 = Log.w(Instrumentation.TAG, string2, runtimeException);
            }
            if (Instrumentation.this.mAutomaticPerformanceSnapshots) {
                Instrumentation.this.startPerformanceSnapshot();
            }
            Instrumentation.this.onStart();
        }
    }

    public static final class ActivityResult {
        private final int mResultCode;
        private final Intent mResultData;

        public ActivityResult(int n, Intent intent) {
            this.mResultCode = n;
            this.mResultData = intent;
        }

        public int getResultCode() {
            return this.mResultCode;
        }

        public Intent getResultData() {
            return this.mResultData;
        }
    }

    public static class ActivityMonitor {
        private final boolean mBlock;
        private final String mClass;
        int mHits = 0;
        Activity mLastActivity = null;
        private final ActivityResult mResult;
        private final IntentFilter mWhich;

        public ActivityMonitor(IntentFilter intentFilter, ActivityResult activityResult, boolean bl) {
            this.mWhich = intentFilter;
            this.mClass = null;
            this.mResult = activityResult;
            this.mBlock = bl;
        }

        public ActivityMonitor(String string2, ActivityResult activityResult, boolean bl) {
            this.mWhich = null;
            this.mClass = string2;
            this.mResult = activityResult;
            this.mBlock = bl;
        }

        public final IntentFilter getFilter() {
            return this.mWhich;
        }

        public final int getHits() {
            return this.mHits;
        }

        public final Activity getLastActivity() {
            return this.mLastActivity;
        }

        public final ActivityResult getResult() {
            return this.mResult;
        }

        public final boolean isBlocking() {
            return this.mBlock;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        final boolean match(Context context, Activity activity, Intent intent) {
            synchronized (this) {
                ContentResolver contentResolver;
                IntentFilter intentFilter;
                if (this.mWhich != null && (intentFilter = this.mWhich).match(contentResolver = context.getContentResolver(), intent, true, Instrumentation.TAG) < 0) {
                    return false;
                }
                if (this.mClass != null) {
                    String string2 = null;
                    if (activity != null) {
                        string2 = activity.getClass().getName();
                    } else if (intent.getComponent() != null) {
                        string2 = intent.getComponent().getClassName();
                    }
                    if (string2 == null) return false;
                    if (!this.mClass.equals(string2)) {
                        return false;
                    }
                }
                if (activity == null) return true;
                this.mLastActivity = activity;
                this.notifyAll();
                return true;
            }
        }

        public final Activity waitForActivity() {
            synchronized (this) {
                while (true) {
                    Activity activity = this.mLastActivity;
                    if (activity != null) break;
                    try {
                        this.wait();
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                Activity activity = this.mLastActivity;
                this.mLastActivity = null;
                return activity;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final Activity waitForActivityWithTimeout(long l) {
            synchronized (this) {
                try {
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {}
                if (this.mLastActivity == null) {
                    return null;
                }
                Activity activity = this.mLastActivity;
                this.mLastActivity = null;
                return activity;
            }
        }
    }
}

