/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.view.IOnKeyguardExitResult;
import android.view.IWindowManager;

public class KeyguardManager {
    private IWindowManager mWM;

    KeyguardManager() {
        IWindowManager iWindowManager;
        this.mWM = iWindowManager = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
    }

    public void exitKeyguardSecurely(final OnKeyguardExitResult onKeyguardExitResult) {
        try {
            IWindowManager iWindowManager = this.mWM;
            IOnKeyguardExitResult.Stub stub = new IOnKeyguardExitResult.Stub(){

                @Override
                public void onKeyguardExitResult(boolean bl) throws RemoteException {
                    onKeyguardExitResult.onKeyguardExitResult(bl);
                }
            };
            iWindowManager.exitKeyguardSecurely(stub);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean inKeyguardRestrictedInputMode() {
        try {
            boolean bl = this.mWM.inKeyguardRestrictedInputMode();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public KeyguardLock newKeyguardLock(String string2) {
        return new KeyguardLock(string2);
    }

    public static interface OnKeyguardExitResult {
        public void onKeyguardExitResult(boolean var1);
    }

    public class KeyguardLock {
        private String mTag;
        private IBinder mToken;

        KeyguardLock(String string2) {
            Binder binder = new Binder();
            this.mToken = binder;
            this.mTag = string2;
        }

        public void disableKeyguard() {
            try {
                IWindowManager iWindowManager = KeyguardManager.this.mWM;
                IBinder iBinder = this.mToken;
                String string2 = this.mTag;
                iWindowManager.disableKeyguard(iBinder, string2);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        public void reenableKeyguard() {
            try {
                IWindowManager iWindowManager = KeyguardManager.this.mWM;
                IBinder iBinder = this.mToken;
                iWindowManager.reenableKeyguard(iBinder);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }
    }
}

