/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ListActivity;
import android.content.Intent;
import android.content.pm.ComponentInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.PaintDrawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class LauncherActivity
extends ListActivity {
    IconResizer mIconResizer;
    Intent mIntent;
    PackageManager mPackageManager;

    protected Intent getTargetIntent() {
        return new Intent();
    }

    protected Intent intentForPosition(int n) {
        return ((ActivityAdapter)this.mAdapter).intentForPosition(n);
    }

    protected ListItem itemForPosition(int n) {
        return ((ActivityAdapter)this.mAdapter).itemForPosition(n);
    }

    public List<ListItem> makeListItems() {
        Intent intent = this.mIntent;
        List<ResolveInfo> list = this.onQueryPackageManager(intent);
        PackageManager packageManager = this.mPackageManager;
        ResolveInfo.DisplayNameComparator displayNameComparator = new ResolveInfo.DisplayNameComparator(packageManager);
        Collections.sort(list, displayNameComparator);
        int n = list.size();
        ArrayList<ListItem> arrayList = new ArrayList<ListItem>(n);
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            ResolveInfo resolveInfo = list.get(i);
            PackageManager packageManager2 = this.mPackageManager;
            ListItem listItem = new ListItem(packageManager2, resolveInfo, null);
            boolean bl = arrayList.add(listItem);
        }
        return arrayList;
    }

    @Override
    protected void onCreate(Bundle bundle) {
        Intent intent;
        IconResizer iconResizer;
        PackageManager packageManager;
        super.onCreate(bundle);
        this.mPackageManager = packageManager = this.getPackageManager();
        boolean bl = this.requestWindowFeature(5);
        this.setProgressBarIndeterminateVisibility(true);
        this.onSetContentView();
        this.mIconResizer = iconResizer = new IconResizer();
        Intent intent2 = this.getTargetIntent();
        this.mIntent = intent = new Intent(intent2);
        Intent intent3 = this.mIntent.setComponent(null);
        IconResizer iconResizer2 = this.mIconResizer;
        ActivityAdapter activityAdapter = new ActivityAdapter(iconResizer2);
        ListAdapter listAdapter = this.mAdapter = activityAdapter;
        this.setListAdapter(listAdapter);
        this.getListView().setTextFilterEnabled(true);
        this.setProgressBarIndeterminateVisibility(false);
    }

    @Override
    protected void onListItemClick(ListView listView, View view, int n, long l) {
        Intent intent = this.intentForPosition(n);
        this.startActivity(intent);
    }

    protected List<ResolveInfo> onQueryPackageManager(Intent intent) {
        return this.mPackageManager.queryIntentActivities(intent, 0);
    }

    protected void onSetContentView() {
        this.setContentView(17367060);
    }

    public class IconResizer {
        private Canvas mCanvas;
        private int mIconHeight = -1;
        private int mIconWidth = -1;
        private final Rect mOldBounds;

        public IconResizer() {
            int n;
            Canvas canvas;
            Rect rect;
            this.mOldBounds = rect = new Rect();
            Canvas canvas2 = this.mCanvas = (canvas = new Canvas());
            PaintFlagsDrawFilter paintFlagsDrawFilter = new PaintFlagsDrawFilter(4, 2);
            canvas2.setDrawFilter(paintFlagsDrawFilter);
            this.mIconHeight = n = (int)LauncherActivity.this.getResources().getDimension(0x1050000);
            this.mIconWidth = n;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Drawable createIconThumbnail(Drawable drawable2) {
            int n = this.mIconWidth;
            int n2 = this.mIconHeight;
            int n3 = drawable2.getIntrinsicWidth();
            int n4 = drawable2.getIntrinsicHeight();
            if (drawable2 instanceof PaintDrawable) {
                PaintDrawable paintDrawable = (PaintDrawable)drawable2;
                paintDrawable.setIntrinsicWidth(n);
                paintDrawable.setIntrinsicHeight(n2);
            }
            if (n <= 0) return drawable2;
            if (n2 <= 0) return drawable2;
            if (n >= n3 && n2 >= n4) {
                if (n3 >= n) return drawable2;
                if (n4 >= n2) return drawable2;
                Bitmap.Config config = Bitmap.Config.ARGB_8888;
                int n5 = this.mIconWidth;
                int n6 = this.mIconHeight;
                Bitmap bitmap = Bitmap.createBitmap(n5, n6, config);
                Canvas canvas = this.mCanvas;
                canvas.setBitmap(bitmap);
                Rect rect = this.mOldBounds;
                Rect rect2 = drawable2.getBounds();
                rect.set(rect2);
                int n7 = (n - n3) / 2;
                int n8 = (n2 - n4) / 2;
                int n9 = n7 + n3;
                int n10 = n8 + n4;
                drawable2.setBounds(n7, n8, n9, n10);
                drawable2.draw(canvas);
                Rect rect3 = this.mOldBounds;
                drawable2.setBounds(rect3);
                Resources resources = LauncherActivity.this.getResources();
                return new BitmapDrawable(resources, bitmap);
            }
            float f = n3;
            float f2 = n4;
            float f3 = f / f2;
            if (n3 > n4) {
                n2 = (int)((float)n / f3);
            } else if (n4 > n3) {
                n = (int)((float)n2 * f3);
            }
            Bitmap.Config config = drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
            int n11 = this.mIconWidth;
            int n12 = this.mIconHeight;
            Bitmap bitmap = Bitmap.createBitmap(n11, n12, config);
            Canvas canvas = this.mCanvas;
            canvas.setBitmap(bitmap);
            Rect rect = this.mOldBounds;
            Rect rect4 = drawable2.getBounds();
            rect.set(rect4);
            int n13 = (this.mIconWidth - n) / 2;
            int n14 = (this.mIconHeight - n2) / 2;
            int n15 = n13 + n;
            int n16 = n14 + n2;
            drawable2.setBounds(n13, n14, n15, n16);
            drawable2.draw(canvas);
            Rect rect5 = this.mOldBounds;
            drawable2.setBounds(rect5);
            Resources resources = LauncherActivity.this.getResources();
            return new BitmapDrawable(resources, bitmap);
        }
    }

    private class ActivityAdapter
    extends BaseAdapter
    implements Filterable {
        private final Object lock;
        protected List<ListItem> mActivitiesList;
        private Filter mFilter;
        protected final IconResizer mIconResizer;
        protected final LayoutInflater mInflater;
        private ArrayList<ListItem> mOriginalValues;

        public ActivityAdapter(IconResizer iconResizer) {
            LayoutInflater layoutInflater;
            Object object;
            this.lock = object = new Object();
            this.mIconResizer = iconResizer;
            this.mInflater = layoutInflater = (LayoutInflater)LauncherActivity.this.getSystemService("layout_inflater");
            List<ListItem> list = LauncherActivity.this.makeListItems();
            this.mActivitiesList = list;
        }

        static /* synthetic */ ArrayList access$102(ActivityAdapter activityAdapter, ArrayList arrayList) {
            activityAdapter.mOriginalValues = arrayList;
            return arrayList;
        }

        private void bindView(View view, ListItem listItem) {
            TextView textView = (TextView)view;
            CharSequence charSequence = listItem.label;
            textView.setText(charSequence);
            if (listItem.icon == null) {
                Drawable drawable2;
                IconResizer iconResizer = this.mIconResizer;
                ResolveInfo resolveInfo = listItem.resolveInfo;
                PackageManager packageManager = LauncherActivity.this.getPackageManager();
                Drawable drawable3 = resolveInfo.loadIcon(packageManager);
                listItem.icon = drawable2 = iconResizer.createIconThumbnail(drawable3);
            }
            Drawable drawable4 = listItem.icon;
            textView.setCompoundDrawablesWithIntrinsicBounds(drawable4, null, null, null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int getCount() {
            if (this.mActivitiesList == null) return 0;
            return this.mActivitiesList.size();
        }

        @Override
        public Filter getFilter() {
            if (this.mFilter == null) {
                ArrayFilter arrayFilter = new ArrayFilter();
                this.mFilter = arrayFilter;
            }
            return this.mFilter;
        }

        @Override
        public Object getItem(int n) {
            return n;
        }

        @Override
        public long getItemId(int n) {
            return n;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public View getView(int n, View view, ViewGroup viewGroup) {
            View view2 = view == null ? this.mInflater.inflate(17367061, viewGroup, false) : view;
            ListItem listItem = this.mActivitiesList.get(n);
            this.bindView(view2, listItem);
            return view2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Intent intentForPosition(int n) {
            if (this.mActivitiesList == null) {
                return null;
            }
            Intent intent = LauncherActivity.this.mIntent;
            Intent intent2 = new Intent(intent);
            ListItem listItem = this.mActivitiesList.get(n);
            String string2 = listItem.packageName;
            String string3 = listItem.className;
            Intent intent3 = intent2.setClassName(string2, string3);
            if (listItem.extras == null) return intent2;
            Bundle bundle = listItem.extras;
            Intent intent4 = intent2.putExtras(bundle);
            return intent2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public ListItem itemForPosition(int n) {
            if (this.mActivitiesList != null) return this.mActivitiesList.get(n);
            return null;
        }

        private class ArrayFilter
        extends Filter {
            private ArrayFilter() {
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            protected Filter.FilterResults performFiltering(CharSequence charSequence) {
                Filter.FilterResults filterResults = new Filter.FilterResults();
                if (ActivityAdapter.this.mOriginalValues == null) {
                    Object object = ActivityAdapter.this.lock;
                    synchronized (object) {
                        ActivityAdapter activityAdapter = ActivityAdapter.this;
                        List<ListItem> list = ActivityAdapter.this.mActivitiesList;
                        ArrayList<ListItem> arrayList = new ArrayList<ListItem>(list);
                        ArrayList arrayList2 = ActivityAdapter.access$102(activityAdapter, arrayList);
                    }
                }
                if (charSequence == null || charSequence.length() == 0) {
                    Object object = ActivityAdapter.this.lock;
                    synchronized (object) {
                        int n;
                        ArrayList arrayList;
                        ArrayList arrayList3 = ActivityAdapter.this.mOriginalValues;
                        filterResults.values = arrayList = new ArrayList(arrayList3);
                        filterResults.count = n = arrayList.size();
                        return filterResults;
                    }
                }
                String string2 = ((Object)charSequence).toString().toLowerCase();
                ArrayList arrayList = ActivityAdapter.this.mOriginalValues;
                int n = arrayList.size();
                ArrayList<ListItem> arrayList4 = new ArrayList<ListItem>(n);
                int n2 = 0;
                block6: while (true) {
                    if (n2 >= n) {
                        int n3;
                        filterResults.values = arrayList4;
                        filterResults.count = n3 = arrayList4.size();
                        return filterResults;
                    }
                    ListItem listItem = (ListItem)arrayList.get(n2);
                    String[] stringArray = ((Object)listItem.label).toString().toLowerCase().split(" ");
                    int n4 = stringArray.length;
                    int n5 = 0;
                    while (true) {
                        block15: {
                            block14: {
                                if (n5 >= n4) break block14;
                                if (!stringArray[n5].startsWith(string2)) break block15;
                                boolean bl = arrayList4.add(listItem);
                            }
                            ++n2;
                            continue block6;
                        }
                        ++n5;
                    }
                    break;
                }
            }

            @Override
            protected void publishResults(CharSequence charSequence, Filter.FilterResults filterResults) {
                List list;
                ActivityAdapter activityAdapter = ActivityAdapter.this;
                activityAdapter.mActivitiesList = list = (List)filterResults.values;
                if (filterResults.count > 0) {
                    ActivityAdapter.this.notifyDataSetChanged();
                    return;
                }
                ActivityAdapter.this.notifyDataSetInvalidated();
            }
        }
    }

    public static class ListItem {
        public String className;
        public Bundle extras;
        public Drawable icon;
        public CharSequence label;
        public String packageName;
        public ResolveInfo resolveInfo;

        public ListItem() {
        }

        ListItem(PackageManager packageManager, ResolveInfo resolveInfo, IconResizer iconResizer) {
            String string2;
            String string3;
            CharSequence charSequence;
            this.resolveInfo = resolveInfo;
            this.label = charSequence = resolveInfo.loadLabel(packageManager);
            ComponentInfo componentInfo = resolveInfo.activityInfo;
            if (componentInfo == null) {
                componentInfo = resolveInfo.serviceInfo;
            }
            if (this.label == null && componentInfo != null) {
                String string4 = resolveInfo.activityInfo.name;
                this.label = string4;
            }
            if (iconResizer != null) {
                Drawable drawable2;
                Drawable drawable3 = resolveInfo.loadIcon(packageManager);
                this.icon = drawable2 = iconResizer.createIconThumbnail(drawable3);
            }
            this.packageName = string3 = componentInfo.applicationInfo.packageName;
            this.className = string2 = componentInfo.name;
        }
    }
}

