/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.ActivityThread;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.os.Binder;
import android.os.Bundle;
import android.util.Log;
import android.view.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class LocalActivityManager {
    static final int CREATED = 2;
    static final int DESTROYED = 5;
    static final int INITIALIZING = 1;
    static final int RESTORED = 0;
    static final int RESUMED = 4;
    static final int STARTED = 3;
    private static final String TAG = "LocalActivityManager";
    private static final boolean localLOGV;
    private final Map<String, LocalActivityRecord> mActivities;
    private final ArrayList<LocalActivityRecord> mActivityArray;
    private final ActivityThread mActivityThread;
    private int mCurState;
    private boolean mFinishing;
    private final Activity mParent;
    private LocalActivityRecord mResumed;
    private boolean mSingleMode;

    public LocalActivityManager(Activity activity, boolean bl) {
        ActivityThread activityThread;
        HashMap<String, LocalActivityRecord> hashMap = new HashMap<String, LocalActivityRecord>();
        this.mActivities = hashMap;
        ArrayList arrayList = new ArrayList();
        this.mActivityArray = arrayList;
        this.mCurState = 1;
        this.mActivityThread = activityThread = ActivityThread.currentActivityThread();
        this.mParent = activity;
        this.mSingleMode = bl;
    }

    private void moveToState(LocalActivityRecord localActivityRecord, int n) {
        if (localActivityRecord.curState == 0) {
            return;
        }
        if (localActivityRecord.curState == 5) {
            return;
        }
        if (localActivityRecord.curState == 1) {
            Window window;
            Activity activity;
            HashMap<String, Object> hashMap = this.mParent.getLastNonConfigurationChildInstances();
            Object object = null;
            if (hashMap != null) {
                String string2 = localActivityRecord.id;
                object = hashMap.get(string2);
            }
            if (localActivityRecord.activityInfo == null) {
                ActivityInfo activityInfo;
                ActivityThread activityThread = this.mActivityThread;
                Intent intent = localActivityRecord.intent;
                localActivityRecord.activityInfo = activityInfo = activityThread.resolveActivityInfo(intent);
            }
            ActivityThread activityThread = this.mActivityThread;
            Activity activity2 = this.mParent;
            String string3 = localActivityRecord.id;
            Intent intent = localActivityRecord.intent;
            ActivityInfo activityInfo = localActivityRecord.activityInfo;
            Bundle bundle = localActivityRecord.instanceState;
            LocalActivityRecord localActivityRecord2 = localActivityRecord;
            localActivityRecord.activity = activity = activityThread.startActivityNow(activity2, string3, intent, activityInfo, localActivityRecord2, bundle, object);
            if (localActivityRecord.activity == null) {
                return;
            }
            localActivityRecord.window = window = localActivityRecord.activity.getWindow();
            localActivityRecord.instanceState = null;
            localActivityRecord.curState = 3;
            if (n != 4) {
                return;
            }
            ActivityThread.ActivityClientRecord activityClientRecord = this.mActivityThread.performResumeActivity(localActivityRecord, true);
            localActivityRecord.curState = 4;
            return;
        }
        switch (localActivityRecord.curState) {
            default: {
                return;
            }
            case 2: {
                if (n == 3) {
                    this.mActivityThread.performRestartActivity(localActivityRecord);
                    localActivityRecord.curState = 3;
                }
                if (n != 4) {
                    return;
                }
                this.mActivityThread.performRestartActivity(localActivityRecord);
                ActivityThread.ActivityClientRecord activityClientRecord = this.mActivityThread.performResumeActivity(localActivityRecord, true);
                localActivityRecord.curState = 4;
                return;
            }
            case 3: {
                if (n == 4) {
                    ActivityThread.ActivityClientRecord activityClientRecord = this.mActivityThread.performResumeActivity(localActivityRecord, true);
                    localActivityRecord.instanceState = null;
                    localActivityRecord.curState = 4;
                }
                if (n != 2) {
                    return;
                }
                this.mActivityThread.performStopActivity(localActivityRecord);
                localActivityRecord.curState = 2;
                return;
            }
            case 4: 
        }
        if (n == 3) {
            boolean bl = this.mFinishing;
            this.performPause(localActivityRecord, bl);
            localActivityRecord.curState = 3;
        }
        if (n != 2) {
            return;
        }
        boolean bl = this.mFinishing;
        this.performPause(localActivityRecord, bl);
        this.mActivityThread.performStopActivity(localActivityRecord);
        localActivityRecord.curState = 2;
    }

    private Window performDestroy(LocalActivityRecord localActivityRecord, boolean bl) {
        Window window = localActivityRecord.window;
        if (localActivityRecord.curState == 4 && !bl) {
            this.performPause(localActivityRecord, bl);
        }
        ActivityThread.ActivityClientRecord activityClientRecord = this.mActivityThread.performDestroyActivity(localActivityRecord, bl);
        localActivityRecord.activity = null;
        localActivityRecord.window = null;
        if (bl) {
            localActivityRecord.instanceState = null;
        }
        localActivityRecord.curState = 5;
        return window;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void performPause(LocalActivityRecord localActivityRecord, boolean bl) {
        boolean bl2 = localActivityRecord.instanceState == null;
        Bundle bundle = this.mActivityThread.performPauseActivity(localActivityRecord, bl, bl2);
        if (!bl2) {
            return;
        }
        localActivityRecord.instanceState = bundle;
    }

    public Window destroyActivity(String string2, boolean bl) {
        LocalActivityRecord localActivityRecord = this.mActivities.get(string2);
        Window window = null;
        if (localActivityRecord != null) {
            window = this.performDestroy(localActivityRecord, bl);
            if (bl) {
                LocalActivityRecord localActivityRecord2 = this.mActivities.remove(localActivityRecord);
            }
        }
        return window;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispatchCreate(Bundle bundle) {
        if (bundle != null) {
            Iterator<String> iterator = bundle.keySet().iterator();
            while (iterator.hasNext()) {
                try {
                    String string2 = iterator.next();
                    Bundle bundle2 = bundle.getBundle(string2);
                    LocalActivityRecord localActivityRecord = this.mActivities.get(string2);
                    if (localActivityRecord != null) {
                        localActivityRecord.instanceState = bundle2;
                    }
                    LocalActivityRecord localActivityRecord2 = new LocalActivityRecord(string2, null);
                    localActivityRecord2.instanceState = bundle2;
                    LocalActivityRecord localActivityRecord3 = this.mActivities.put(string2, localActivityRecord2);
                    boolean bl = this.mActivityArray.add(localActivityRecord2);
                }
                catch (Exception exception) {
                    int n = Log.e(TAG, "Exception thrown when restoring LocalActivityManager state", exception);
                }
            }
        }
        this.mCurState = 2;
    }

    public void dispatchDestroy(boolean bl) {
        int n = this.mActivityArray.size();
        for (int i = 0; i < n; ++i) {
            LocalActivityRecord localActivityRecord = this.mActivityArray.get(i);
            ActivityThread.ActivityClientRecord activityClientRecord = this.mActivityThread.performDestroyActivity(localActivityRecord, bl);
        }
        this.mActivities.clear();
        this.mActivityArray.clear();
    }

    public void dispatchPause(boolean bl) {
        if (bl) {
            this.mFinishing = true;
        }
        this.mCurState = 3;
        if (this.mSingleMode) {
            if (this.mResumed == null) {
                return;
            }
            LocalActivityRecord localActivityRecord = this.mResumed;
            this.moveToState(localActivityRecord, 3);
            return;
        }
        int n = this.mActivityArray.size();
        int n2 = 0;
        while (n2 < n) {
            LocalActivityRecord localActivityRecord = this.mActivityArray.get(n2);
            if (localActivityRecord.curState == 4) {
                this.moveToState(localActivityRecord, 3);
            }
            ++n2;
        }
        return;
    }

    public void dispatchResume() {
        this.mCurState = 4;
        if (this.mSingleMode) {
            if (this.mResumed == null) {
                return;
            }
            LocalActivityRecord localActivityRecord = this.mResumed;
            this.moveToState(localActivityRecord, 4);
            return;
        }
        int n = this.mActivityArray.size();
        int n2 = 0;
        while (n2 < n) {
            LocalActivityRecord localActivityRecord = this.mActivityArray.get(n2);
            this.moveToState(localActivityRecord, 4);
            ++n2;
        }
        return;
    }

    public HashMap<String, Object> dispatchRetainNonConfigurationInstance() {
        HashMap<String, Object> hashMap = null;
        int n = this.mActivityArray.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            LocalActivityRecord localActivityRecord = this.mActivityArray.get(i);
            if (localActivityRecord == null || localActivityRecord.activity == null || (object = localActivityRecord.activity.onRetainNonConfigurationInstance()) == null) continue;
            if (hashMap == null) {
                hashMap = new HashMap<String, Object>();
            }
            String string2 = localActivityRecord.id;
            Object object2 = hashMap.put(string2, object);
        }
        return hashMap;
    }

    public void dispatchStop() {
        this.mCurState = 2;
        int n = this.mActivityArray.size();
        int n2 = 0;
        while (n2 < n) {
            LocalActivityRecord localActivityRecord = this.mActivityArray.get(n2);
            this.moveToState(localActivityRecord, 2);
            ++n2;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Activity getActivity(String string2) {
        LocalActivityRecord localActivityRecord = this.mActivities.get(string2);
        if (localActivityRecord == null) return null;
        return localActivityRecord.activity;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Activity getCurrentActivity() {
        if (this.mResumed == null) return null;
        return this.mResumed.activity;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getCurrentId() {
        if (this.mResumed == null) return null;
        return this.mResumed.id;
    }

    public void removeAllActivities() {
        this.dispatchDestroy(true);
    }

    public Bundle saveInstanceState() {
        Bundle bundle = null;
        int n = this.mActivityArray.size();
        for (int i = 0; i < n; ++i) {
            LocalActivityRecord localActivityRecord = this.mActivityArray.get(i);
            if (bundle == null) {
                bundle = new Bundle();
            }
            if ((localActivityRecord.instanceState != null || localActivityRecord.curState == 4) && localActivityRecord.activity != null) {
                Bundle bundle2 = new Bundle();
                localActivityRecord.activity.onSaveInstanceState(bundle2);
                localActivityRecord.instanceState = bundle2;
            }
            if (localActivityRecord.instanceState == null) continue;
            String string2 = localActivityRecord.id;
            Bundle bundle3 = localActivityRecord.instanceState;
            bundle.putBundle(string2, bundle3);
        }
        return bundle;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Window startActivity(String string2, Intent intent) {
        LocalActivityRecord localActivityRecord;
        if (this.mCurState == 1) {
            throw new IllegalStateException("Activities can't be added until the containing group has been created.");
        }
        boolean bl = false;
        boolean bl2 = false;
        ActivityInfo activityInfo = null;
        LocalActivityRecord localActivityRecord2 = this.mActivities.get(string2);
        if (localActivityRecord2 == null) {
            localActivityRecord2 = new LocalActivityRecord(string2, intent);
            bl = true;
        } else if (localActivityRecord2.intent != null && (bl2 = localActivityRecord2.intent.filterEquals(intent))) {
            activityInfo = localActivityRecord2.activityInfo;
        }
        if (activityInfo == null) {
            activityInfo = this.mActivityThread.resolveActivityInfo(intent);
        }
        if (this.mSingleMode && (localActivityRecord = this.mResumed) != null && localActivityRecord != localActivityRecord2 && this.mCurState == 4) {
            this.moveToState(localActivityRecord, 3);
        }
        if (bl) {
            LocalActivityRecord localActivityRecord3 = this.mActivities.put(string2, localActivityRecord2);
            boolean bl3 = this.mActivityArray.add(localActivityRecord2);
        } else if (localActivityRecord2.activityInfo != null) {
            String string3;
            String string4;
            String string5;
            String string6;
            ActivityInfo activityInfo2 = localActivityRecord2.activityInfo;
            if (activityInfo == activityInfo2 || (string6 = activityInfo.name).equals(string5 = localActivityRecord2.activityInfo.name) && (string4 = activityInfo.packageName).equals(string3 = localActivityRecord2.activityInfo.packageName)) {
                if (activityInfo.launchMode != 0 || (intent.getFlags() & 0x20000000) != 0) {
                    ArrayList<Intent> arrayList = new ArrayList<Intent>(1);
                    boolean bl4 = arrayList.add(intent);
                    this.mActivityThread.performNewIntents(localActivityRecord2, arrayList);
                    localActivityRecord2.intent = intent;
                    int n = this.mCurState;
                    this.moveToState(localActivityRecord2, n);
                    if (!this.mSingleMode) return localActivityRecord2.window;
                    this.mResumed = localActivityRecord2;
                    return localActivityRecord2.window;
                }
                if (bl2 && (intent.getFlags() & 0x4000000) == 0) {
                    localActivityRecord2.intent = intent;
                    int n = this.mCurState;
                    this.moveToState(localActivityRecord2, n);
                    if (!this.mSingleMode) return localActivityRecord2.window;
                    this.mResumed = localActivityRecord2;
                    return localActivityRecord2.window;
                }
            }
            Window window = this.performDestroy(localActivityRecord2, true);
        }
        localActivityRecord2.intent = intent;
        localActivityRecord2.curState = 1;
        localActivityRecord2.activityInfo = activityInfo;
        int n = this.mCurState;
        this.moveToState(localActivityRecord2, n);
        if (!this.mSingleMode) return localActivityRecord2.window;
        this.mResumed = localActivityRecord2;
        return localActivityRecord2.window;
    }

    private static class LocalActivityRecord
    extends Binder {
        Activity activity;
        ActivityInfo activityInfo;
        int curState = 0;
        final String id;
        Bundle instanceState;
        Intent intent;
        Window window;

        LocalActivityRecord(String string2, Intent intent) {
            this.id = string2;
            this.intent = intent;
        }
    }
}

