/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.IBinder;
import android.os.Looper;
import android.os.MessageQueue;
import android.util.AttributeSet;
import android.view.InputChannel;
import android.view.InputQueue;
import android.view.KeyEvent;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import com.android.internal.view.IInputMethodCallback;
import com.android.internal.view.IInputMethodSession;
import java.io.File;
import java.lang.ref.WeakReference;

public class NativeActivity
extends Activity
implements SurfaceHolder.Callback2,
InputQueue.Callback,
ViewTreeObserver.OnGlobalLayoutListener {
    private static final String KEY_NATIVE_SAVED_STATE = "android:native_state";
    public static final String META_DATA_FUNC_NAME = "android.app.func_name";
    public static final String META_DATA_LIB_NAME = "android.app.lib_name";
    private InputQueue mCurInputQueue;
    private SurfaceHolder mCurSurfaceHolder;
    private boolean mDestroyed;
    private boolean mDispatchingUnhandledKey;
    private InputMethodManager mIMM;
    private InputMethodCallback mInputMethodCallback;
    int mLastContentHeight;
    int mLastContentWidth;
    int mLastContentX;
    int mLastContentY;
    final int[] mLocation;
    private NativeContentView mNativeContentView;
    private int mNativeHandle;

    public NativeActivity() {
        int[] nArray = new int[2];
        this.mLocation = nArray;
    }

    private native void dispatchKeyEventNative(int var1, KeyEvent var2);

    private native void finishPreDispatchKeyEventNative(int var1, int var2, boolean var3);

    private native int loadNativeCode(String var1, String var2, MessageQueue var3, String var4, String var5, int var6, AssetManager var7, byte[] var8);

    private native void onConfigurationChangedNative(int var1);

    private native void onContentRectChangedNative(int var1, int var2, int var3, int var4, int var5);

    private native void onInputChannelCreatedNative(int var1, InputChannel var2);

    private native void onInputChannelDestroyedNative(int var1, InputChannel var2);

    private native void onLowMemoryNative(int var1);

    private native void onPauseNative(int var1);

    private native void onResumeNative(int var1);

    private native byte[] onSaveInstanceStateNative(int var1);

    private native void onStartNative(int var1);

    private native void onStopNative(int var1);

    private native void onSurfaceChangedNative(int var1, Surface var2, int var3, int var4, int var5);

    private native void onSurfaceCreatedNative(int var1, Surface var2);

    private native void onSurfaceDestroyedNative(int var1);

    private native void onSurfaceRedrawNeededNative(int var1, Surface var2);

    private native void onWindowFocusChangedNative(int var1, boolean var2);

    private native void unloadNativeCode(int var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (this.mDispatchingUnhandledKey) {
            return super.dispatchKeyEvent(keyEvent);
        }
        int n = this.mNativeHandle;
        this.dispatchKeyEventNative(n, keyEvent);
        return true;
    }

    void dispatchUnhandledKeyEvent(KeyEvent keyEvent) {
        try {
            this.mDispatchingUnhandledKey = true;
            View view = this.getWindow().getDecorView();
            if (view != null) {
                boolean bl = view.dispatchKeyEvent(keyEvent);
            }
            return;
        }
        finally {
            this.mDispatchingUnhandledKey = false;
        }
    }

    void hideIme(int n) {
        InputMethodManager inputMethodManager = this.mIMM;
        IBinder iBinder = this.mNativeContentView.getWindowToken();
        boolean bl = inputMethodManager.hideSoftInputFromWindow(iBinder, n);
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        if (this.mDestroyed) {
            return;
        }
        int n = this.mNativeHandle;
        this.onConfigurationChangedNative(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void onCreate(Bundle bundle) {
        int n;
        String string2;
        ActivityInfo activityInfo;
        NativeContentView nativeContentView;
        InputMethodCallback inputMethodCallback;
        InputMethodManager inputMethodManager;
        String string3 = "main";
        String string4 = "ANativeActivity_onCreate";
        this.mIMM = inputMethodManager = (InputMethodManager)this.getSystemService("input_method");
        this.mInputMethodCallback = inputMethodCallback = new InputMethodCallback(this);
        this.getWindow().takeSurface(this);
        this.getWindow().takeInputQueue(this);
        this.getWindow().setFormat(4);
        this.getWindow().setSoftInputMode(16);
        this.mNativeContentView = nativeContentView = new NativeContentView(this);
        this.mNativeContentView.mActivity = this;
        NativeContentView nativeContentView2 = this.mNativeContentView;
        this.setContentView(nativeContentView2);
        boolean bl = this.mNativeContentView.requestFocus();
        this.mNativeContentView.getViewTreeObserver().addOnGlobalLayoutListener(this);
        try {
            PackageManager packageManager = this.getPackageManager();
            ComponentName componentName = this.getIntent().getComponent();
            activityInfo = packageManager.getActivityInfo(componentName, 128);
            if (activityInfo.metaData != null) {
                String string5;
                String string6;
                String string7 = activityInfo.metaData.getString(META_DATA_LIB_NAME);
                if (string7 != null) {
                    string3 = string7;
                }
                if ((string6 = (string5 = activityInfo.metaData.getString(META_DATA_FUNC_NAME))) != null) {
                    string4 = string6;
                }
            }
            string2 = null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new RuntimeException("Error getting activity info", nameNotFoundException);
        }
        String string8 = activityInfo.applicationInfo.nativeLibraryDir;
        String string9 = System.mapLibraryName(string3);
        File file = new File(string8, string9);
        if (file.exists()) {
            string2 = file.getPath();
        }
        if (string2 == null) {
            String string10 = "Unable to find native library: " + string3;
            throw new IllegalArgumentException(string10);
        }
        byte[] byArray = bundle != null ? bundle.getByteArray(KEY_NATIVE_SAVED_STATE) : null;
        MessageQueue messageQueue = Looper.myQueue();
        String string11 = this.getFilesDir().toString();
        String string12 = Environment.getExternalStorageAppFilesDirectory(activityInfo.packageName).toString();
        int n2 = Build.VERSION.SDK_INT;
        AssetManager assetManager = this.getAssets();
        this.mNativeHandle = n = this.loadNativeCode(string2, string4, messageQueue, string11, string12, n2, assetManager, byArray);
        if (this.mNativeHandle == 0) {
            String string13 = "Unable to load native library: " + string2;
            throw new IllegalArgumentException(string13);
        }
        super.onCreate(bundle);
    }

    @Override
    protected void onDestroy() {
        this.mDestroyed = true;
        if (this.mCurSurfaceHolder != null) {
            int n = this.mNativeHandle;
            this.onSurfaceDestroyedNative(n);
            this.mCurSurfaceHolder = null;
        }
        if (this.mCurInputQueue != null) {
            int n = this.mNativeHandle;
            InputChannel inputChannel = this.mCurInputQueue.getInputChannel();
            this.onInputChannelDestroyedNative(n, inputChannel);
            this.mCurInputQueue = null;
        }
        int n = this.mNativeHandle;
        this.unloadNativeCode(n);
        super.onDestroy();
    }

    @Override
    public void onGlobalLayout() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        NativeContentView nativeContentView = this.mNativeContentView;
        int[] nArray = this.mLocation;
        nativeContentView.getLocationInWindow(nArray);
        int n7 = this.mNativeContentView.getWidth();
        int n8 = this.mNativeContentView.getHeight();
        int n9 = this.mLocation[0];
        int n10 = this.mLastContentX;
        if (n9 != n10 && (n6 = this.mLocation[1]) != (n5 = this.mLastContentY) && n7 != (n4 = this.mLastContentWidth) && n8 != (n3 = this.mLastContentHeight)) {
            return;
        }
        this.mLastContentX = n2 = this.mLocation[0];
        this.mLastContentY = n = this.mLocation[1];
        this.mLastContentWidth = n7;
        this.mLastContentHeight = n8;
        if (this.mDestroyed) {
            return;
        }
        int n11 = this.mNativeHandle;
        int n12 = this.mLastContentX;
        int n13 = this.mLastContentY;
        int n14 = this.mLastContentWidth;
        int n15 = this.mLastContentHeight;
        this.onContentRectChangedNative(n11, n12, n13, n14, n15);
    }

    @Override
    public void onInputQueueCreated(InputQueue inputQueue) {
        if (this.mDestroyed) {
            return;
        }
        this.mCurInputQueue = inputQueue;
        int n = this.mNativeHandle;
        InputChannel inputChannel = inputQueue.getInputChannel();
        this.onInputChannelCreatedNative(n, inputChannel);
    }

    @Override
    public void onInputQueueDestroyed(InputQueue inputQueue) {
        this.mCurInputQueue = null;
        if (this.mDestroyed) {
            return;
        }
        int n = this.mNativeHandle;
        InputChannel inputChannel = inputQueue.getInputChannel();
        this.onInputChannelDestroyedNative(n, inputChannel);
    }

    @Override
    public void onLowMemory() {
        super.onLowMemory();
        if (this.mDestroyed) {
            return;
        }
        int n = this.mNativeHandle;
        this.onLowMemoryNative(n);
    }

    @Override
    protected void onPause() {
        super.onPause();
        int n = this.mNativeHandle;
        this.onPauseNative(n);
    }

    @Override
    protected void onResume() {
        super.onResume();
        int n = this.mNativeHandle;
        this.onResumeNative(n);
    }

    @Override
    protected void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        int n = this.mNativeHandle;
        byte[] byArray = this.onSaveInstanceStateNative(n);
        if (byArray == null) {
            return;
        }
        bundle.putByteArray(KEY_NATIVE_SAVED_STATE, byArray);
    }

    @Override
    protected void onStart() {
        super.onStart();
        int n = this.mNativeHandle;
        this.onStartNative(n);
    }

    @Override
    protected void onStop() {
        super.onStop();
        int n = this.mNativeHandle;
        this.onStopNative(n);
    }

    @Override
    public void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        if (this.mDestroyed) {
            return;
        }
        int n = this.mNativeHandle;
        this.onWindowFocusChangedNative(n, bl);
    }

    void preDispatchKeyEvent(KeyEvent keyEvent, int n) {
        InputMethodManager inputMethodManager = this.mIMM;
        InputMethodCallback inputMethodCallback = this.mInputMethodCallback;
        inputMethodManager.dispatchKeyEvent(this, n, keyEvent, inputMethodCallback);
    }

    void setWindowFlags(int n, int n2) {
        this.getWindow().setFlags(n, n2);
    }

    void setWindowFormat(int n) {
        this.getWindow().setFormat(n);
    }

    void showIme(int n) {
        InputMethodManager inputMethodManager = this.mIMM;
        NativeContentView nativeContentView = this.mNativeContentView;
        boolean bl = inputMethodManager.showSoftInput(nativeContentView, n);
    }

    @Override
    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        if (this.mDestroyed) {
            return;
        }
        this.mCurSurfaceHolder = surfaceHolder;
        int n4 = this.mNativeHandle;
        Surface surface = surfaceHolder.getSurface();
        NativeActivity nativeActivity = this;
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        nativeActivity.onSurfaceChangedNative(n4, surface, n5, n6, n7);
    }

    @Override
    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        if (this.mDestroyed) {
            return;
        }
        this.mCurSurfaceHolder = surfaceHolder;
        int n = this.mNativeHandle;
        Surface surface = surfaceHolder.getSurface();
        this.onSurfaceCreatedNative(n, surface);
    }

    @Override
    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        this.mCurSurfaceHolder = null;
        if (this.mDestroyed) {
            return;
        }
        int n = this.mNativeHandle;
        this.onSurfaceDestroyedNative(n);
    }

    @Override
    public void surfaceRedrawNeeded(SurfaceHolder surfaceHolder) {
        if (this.mDestroyed) {
            return;
        }
        this.mCurSurfaceHolder = surfaceHolder;
        int n = this.mNativeHandle;
        Surface surface = surfaceHolder.getSurface();
        this.onSurfaceRedrawNeededNative(n, surface);
    }

    static class InputMethodCallback
    extends IInputMethodCallback.Stub {
        WeakReference<NativeActivity> mNa;

        InputMethodCallback(NativeActivity nativeActivity) {
            WeakReference<NativeActivity> weakReference = new WeakReference<NativeActivity>(nativeActivity);
            this.mNa = weakReference;
        }

        @Override
        public void finishedEvent(int n, boolean bl) {
            NativeActivity nativeActivity = (NativeActivity)this.mNa.get();
            if (nativeActivity == null) {
                return;
            }
            int n2 = nativeActivity.mNativeHandle;
            nativeActivity.finishPreDispatchKeyEventNative(n2, n, bl);
        }

        @Override
        public void sessionCreated(IInputMethodSession iInputMethodSession) {
        }
    }

    static class NativeContentView
    extends View {
        NativeActivity mActivity;

        public NativeContentView(Context context) {
            super(context);
        }

        public NativeContentView(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }
    }
}

