/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.INotificationManager;
import android.app.Notification;
import android.content.Context;
import android.os.Handler;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;

public class NotificationManager {
    private static boolean DEBUG;
    private static String TAG;
    private static boolean localLOGV;
    private static INotificationManager sService;
    private Context mContext;

    /*
     * Enabled aggressive block sorting
     */
    static {
        TAG = "NotificationManager";
        DEBUG = false;
        boolean bl = DEBUG;
        localLOGV = bl;
    }

    NotificationManager(Context context, Handler handler) {
        this.mContext = context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static INotificationManager getService() {
        if (sService == null) return sService = INotificationManager.Stub.asInterface(ServiceManager.getService("notification"));
        return sService;
    }

    public void cancel(int n) {
        this.cancel(null, n);
    }

    public void cancel(String string2, int n) {
        INotificationManager iNotificationManager = NotificationManager.getService();
        String string3 = this.mContext.getPackageName();
        if (localLOGV) {
            String string4 = TAG;
            String string5 = string3 + ": cancel(" + n + ")";
            int n2 = Log.v(string4, string5);
        }
        try {
            iNotificationManager.cancelNotificationWithTag(string3, string2, n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void cancelAll() {
        INotificationManager iNotificationManager = NotificationManager.getService();
        String string2 = this.mContext.getPackageName();
        if (localLOGV) {
            String string3 = TAG;
            String string4 = string2 + ": cancelAll()";
            int n = Log.v(string3, string4);
        }
        try {
            iNotificationManager.cancelAllNotifications(string2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void notify(int n, Notification notification) {
        this.notify(null, n, notification);
    }

    public void notify(String string2, int n, Notification notification) {
        int[] nArray = new int[1];
        INotificationManager iNotificationManager = NotificationManager.getService();
        String string3 = this.mContext.getPackageName();
        if (localLOGV) {
            String string4 = TAG;
            String string5 = string3 + ": notify(" + n + ", " + notification + ")";
            int n2 = Log.v(string4, string5);
        }
        String string6 = string2;
        int n3 = n;
        Notification notification2 = notification;
        try {
            iNotificationManager.enqueueNotificationWithTag(string3, string6, n3, notification2, nArray);
            int n4 = nArray[0];
            if (n != n4) {
                return;
            }
            String string7 = TAG;
            StringBuilder stringBuilder = new StringBuilder().append("notify: id corrupted: sent ").append(n).append(", got back ");
            int n5 = nArray[0];
            String string8 = stringBuilder.append(n5).toString();
            int n6 = Log.w(string7, string8);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }
}

