/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityManagerNative;
import android.app.IActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.IIntentReceiver;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.AndroidException;

public final class PendingIntent
implements Parcelable {
    public static final Parcelable.Creator<PendingIntent> CREATOR = new Parcelable.Creator<PendingIntent>(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public PendingIntent createFromParcel(Parcel parcel) {
            IBinder iBinder = parcel.readStrongBinder();
            if (iBinder == null) return null;
            return new PendingIntent(iBinder);
        }

        public PendingIntent[] newArray(int n) {
            return new PendingIntent[n];
        }
    };
    public static final int FLAG_CANCEL_CURRENT = 0x10000000;
    public static final int FLAG_NO_CREATE = 0x20000000;
    public static final int FLAG_ONE_SHOT = 0x40000000;
    public static final int FLAG_UPDATE_CURRENT = 0x8000000;
    private final IIntentSender mTarget;

    PendingIntent(IIntentSender iIntentSender) {
        this.mTarget = iIntentSender;
    }

    PendingIntent(IBinder iBinder) {
        IIntentSender iIntentSender;
        this.mTarget = iIntentSender = IIntentSender.Stub.asInterface(iBinder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PendingIntent getActivity(Context context, int n, Intent intent, int n2) {
        String string2;
        String string3 = context.getPackageName();
        if (intent != null) {
            ContentResolver contentResolver = context.getContentResolver();
            string2 = intent.resolveTypeIfNeeded(contentResolver);
        } else {
            string2 = null;
        }
        try {
            IActivityManager iActivityManager = ActivityManagerNative.getDefault();
            int n3 = n;
            Intent intent2 = intent;
            int n4 = n2;
            IIntentSender iIntentSender = iActivityManager.getIntentSender(2, string3, null, null, n3, intent2, string2, n4);
            if (iIntentSender == null) return null;
            return new PendingIntent(iIntentSender);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PendingIntent getBroadcast(Context context, int n, Intent intent, int n2) {
        String string2;
        String string3 = context.getPackageName();
        if (intent != null) {
            ContentResolver contentResolver = context.getContentResolver();
            string2 = intent.resolveTypeIfNeeded(contentResolver);
        } else {
            string2 = null;
        }
        try {
            IActivityManager iActivityManager = ActivityManagerNative.getDefault();
            int n3 = n;
            Intent intent2 = intent;
            int n4 = n2;
            IIntentSender iIntentSender = iActivityManager.getIntentSender(1, string3, null, null, n3, intent2, string2, n4);
            if (iIntentSender == null) return null;
            return new PendingIntent(iIntentSender);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PendingIntent getService(Context context, int n, Intent intent, int n2) {
        String string2;
        String string3 = context.getPackageName();
        if (intent != null) {
            ContentResolver contentResolver = context.getContentResolver();
            string2 = intent.resolveTypeIfNeeded(contentResolver);
        } else {
            string2 = null;
        }
        try {
            IActivityManager iActivityManager = ActivityManagerNative.getDefault();
            int n3 = n;
            Intent intent2 = intent;
            int n4 = n2;
            IIntentSender iIntentSender = iActivityManager.getIntentSender(4, string3, null, null, n3, intent2, string2, n4);
            if (iIntentSender == null) return null;
            return new PendingIntent(iIntentSender);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PendingIntent readPendingIntentOrNullFromParcel(Parcel parcel) {
        IBinder iBinder = parcel.readStrongBinder();
        if (iBinder == null) return null;
        return new PendingIntent(iBinder);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void writePendingIntentOrNullToParcel(PendingIntent pendingIntent, Parcel parcel) {
        IBinder iBinder = pendingIntent != null ? pendingIntent.mTarget.asBinder() : null;
        parcel.writeStrongBinder(iBinder);
    }

    public void cancel() {
        try {
            IActivityManager iActivityManager = ActivityManagerNative.getDefault();
            IIntentSender iIntentSender = this.mTarget;
            iActivityManager.cancelIntentSender(iIntentSender);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof PendingIntent)) return false;
        IBinder iBinder = this.mTarget.asBinder();
        IBinder iBinder2 = ((PendingIntent)object).mTarget.asBinder();
        return iBinder.equals(iBinder2);
    }

    public IntentSender getIntentSender() {
        IIntentSender iIntentSender = this.mTarget;
        return new IntentSender(iIntentSender);
    }

    public IIntentSender getTarget() {
        return this.mTarget;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getTargetPackage() {
        try {
            IActivityManager iActivityManager = ActivityManagerNative.getDefault();
            IIntentSender iIntentSender = this.mTarget;
            String string2 = iActivityManager.getPackageForIntentSender(iIntentSender);
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public int hashCode() {
        return this.mTarget.asBinder().hashCode();
    }

    public void send() throws CanceledException {
        PendingIntent pendingIntent = this;
        Intent intent = null;
        OnFinished onFinished = null;
        Handler handler = null;
        pendingIntent.send(null, 0, intent, onFinished, handler);
    }

    public void send(int n) throws CanceledException {
        PendingIntent pendingIntent = this;
        int n2 = n;
        Intent intent = null;
        OnFinished onFinished = null;
        Handler handler = null;
        pendingIntent.send(null, n2, intent, onFinished, handler);
    }

    public void send(int n, OnFinished onFinished, Handler handler) throws CanceledException {
        PendingIntent pendingIntent = this;
        int n2 = n;
        Intent intent = null;
        OnFinished onFinished2 = onFinished;
        Handler handler2 = handler;
        pendingIntent.send(null, n2, intent, onFinished2, handler2);
    }

    public void send(Context context, int n, Intent intent) throws CanceledException {
        PendingIntent pendingIntent = this;
        Context context2 = context;
        int n2 = n;
        Intent intent2 = intent;
        Handler handler = null;
        pendingIntent.send(context2, n2, intent2, null, handler);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send(Context context, int n, Intent intent, OnFinished onFinished, Handler handler) throws CanceledException {
        String string2;
        FinishedDispatcher finishedDispatcher = null;
        if (intent != null) {
            try {
                ContentResolver contentResolver = context.getContentResolver();
                string2 = intent.resolveTypeIfNeeded(contentResolver);
            }
            catch (RemoteException remoteException) {
                throw new CanceledException(remoteException);
            }
        } else {
            string2 = null;
        }
        IIntentSender iIntentSender = this.mTarget;
        if (onFinished != null) {
            finishedDispatcher = new FinishedDispatcher(this, onFinished, handler);
        }
        if (iIntentSender.send(n, intent, string2, finishedDispatcher) >= 0) {
            return;
        }
        throw new CanceledException();
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        StringBuilder stringBuilder2 = stringBuilder.append("PendingIntent{");
        String string2 = Integer.toHexString(System.identityHashCode(this));
        StringBuilder stringBuilder3 = stringBuilder.append(string2);
        StringBuilder stringBuilder4 = stringBuilder.append(": ");
        IBinder iBinder = this.mTarget != null ? this.mTarget.asBinder() : null;
        StringBuilder stringBuilder5 = stringBuilder.append(iBinder);
        StringBuilder stringBuilder6 = stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        IBinder iBinder = this.mTarget.asBinder();
        parcel.writeStrongBinder(iBinder);
    }

    private static class FinishedDispatcher
    extends IIntentReceiver.Stub
    implements Runnable {
        private final Handler mHandler;
        private Intent mIntent;
        private final PendingIntent mPendingIntent;
        private int mResultCode;
        private String mResultData;
        private Bundle mResultExtras;
        private final OnFinished mWho;

        FinishedDispatcher(PendingIntent pendingIntent, OnFinished onFinished, Handler handler) {
            this.mPendingIntent = pendingIntent;
            this.mWho = onFinished;
            this.mHandler = handler;
        }

        @Override
        public void performReceive(Intent intent, int n, String string2, Bundle bundle, boolean bl, boolean bl2) {
            this.mIntent = intent;
            this.mResultCode = n;
            this.mResultData = string2;
            this.mResultExtras = bundle;
            if (this.mHandler == null) {
                this.run();
                return;
            }
            boolean bl3 = this.mHandler.post(this);
        }

        @Override
        public void run() {
            OnFinished onFinished = this.mWho;
            PendingIntent pendingIntent = this.mPendingIntent;
            Intent intent = this.mIntent;
            int n = this.mResultCode;
            String string2 = this.mResultData;
            Bundle bundle = this.mResultExtras;
            onFinished.onSendFinished(pendingIntent, intent, n, string2, bundle);
        }
    }

    public static interface OnFinished {
        public void onSendFinished(PendingIntent var1, Intent var2, int var3, String var4, Bundle var5);
    }

    public static class CanceledException
    extends AndroidException {
        public CanceledException() {
        }

        public CanceledException(Exception exception) {
            super(exception);
        }

        public CanceledException(String string2) {
            super(string2);
        }
    }
}

