/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.SpannableString;
import android.text.style.StyleSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;
import java.text.NumberFormat;

public class ProgressDialog
extends AlertDialog {
    public static final int STYLE_HORIZONTAL = 1;
    public static final int STYLE_SPINNER;
    private boolean mHasStarted;
    private int mIncrementBy;
    private int mIncrementSecondaryBy;
    private boolean mIndeterminate;
    private Drawable mIndeterminateDrawable;
    private int mMax;
    private CharSequence mMessage;
    private TextView mMessageView;
    private ProgressBar mProgress;
    private Drawable mProgressDrawable;
    private TextView mProgressNumber;
    private String mProgressNumberFormat;
    private TextView mProgressPercent;
    private NumberFormat mProgressPercentFormat;
    private int mProgressStyle = 0;
    private int mProgressVal;
    private int mSecondaryProgressVal;
    private Handler mViewUpdateHandler;

    public ProgressDialog(Context context) {
        this(context, 16973987);
    }

    public ProgressDialog(Context context, int n) {
        super(context, n);
    }

    private void onProgressChanged() {
        if (this.mProgressStyle != 1) {
            return;
        }
        boolean bl = this.mViewUpdateHandler.sendEmptyMessage(0);
    }

    public static ProgressDialog show(Context context, CharSequence charSequence, CharSequence charSequence2) {
        return ProgressDialog.show(context, charSequence, charSequence2, false);
    }

    public static ProgressDialog show(Context context, CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        Context context2 = context;
        CharSequence charSequence3 = charSequence;
        CharSequence charSequence4 = charSequence2;
        boolean bl2 = bl;
        return ProgressDialog.show(context2, charSequence3, charSequence4, bl2, false, null);
    }

    public static ProgressDialog show(Context context, CharSequence charSequence, CharSequence charSequence2, boolean bl, boolean bl2) {
        Context context2 = context;
        CharSequence charSequence3 = charSequence;
        CharSequence charSequence4 = charSequence2;
        boolean bl3 = bl;
        boolean bl4 = bl2;
        return ProgressDialog.show(context2, charSequence3, charSequence4, bl3, bl4, null);
    }

    public static ProgressDialog show(Context context, CharSequence charSequence, CharSequence charSequence2, boolean bl, boolean bl2, DialogInterface.OnCancelListener onCancelListener) {
        ProgressDialog progressDialog = new ProgressDialog(context);
        progressDialog.setTitle(charSequence);
        progressDialog.setMessage(charSequence2);
        progressDialog.setIndeterminate(bl);
        progressDialog.setCancelable(bl2);
        progressDialog.setOnCancelListener(onCancelListener);
        progressDialog.show();
        return progressDialog;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getMax() {
        if (this.mProgress == null) return this.mMax;
        return this.mProgress.getMax();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getProgress() {
        if (this.mProgress == null) return this.mProgressVal;
        return this.mProgress.getProgress();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getSecondaryProgress() {
        if (this.mProgress == null) return this.mSecondaryProgressVal;
        return this.mProgress.getSecondaryProgress();
    }

    public void incrementProgressBy(int n) {
        int n2;
        if (this.mProgress != null) {
            this.mProgress.incrementProgressBy(n);
            this.onProgressChanged();
            return;
        }
        this.mIncrementBy = n2 = this.mIncrementBy + n;
    }

    public void incrementSecondaryProgressBy(int n) {
        int n2;
        if (this.mProgress != null) {
            this.mProgress.incrementSecondaryProgressBy(n);
            this.onProgressChanged();
            return;
        }
        this.mIncrementSecondaryBy = n2 = this.mIncrementSecondaryBy + n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isIndeterminate() {
        if (this.mProgress == null) return this.mIndeterminate;
        return this.mProgress.isIndeterminate();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onCreate(Bundle bundle) {
        LayoutInflater layoutInflater = LayoutInflater.from(this.mContext);
        if (this.mProgressStyle == 1) {
            NumberFormat numberFormat;
            TextView textView;
            TextView textView2;
            ProgressBar progressBar;
            Handler handler;
            this.mViewUpdateHandler = handler = new Handler(){

                @Override
                public void handleMessage(Message message) {
                    super.handleMessage(message);
                    int n = ProgressDialog.this.mProgress.getProgress();
                    int n2 = ProgressDialog.this.mProgress.getMax();
                    double d = n;
                    double d2 = n2;
                    double d3 = d / d2;
                    String string2 = ProgressDialog.this.mProgressNumberFormat;
                    TextView textView = ProgressDialog.this.mProgressNumber;
                    Object[] objectArray = new Object[2];
                    Integer n3 = n;
                    objectArray[0] = n3;
                    Integer n4 = n2;
                    objectArray[1] = n4;
                    String string3 = String.format(string2, objectArray);
                    textView.setText(string3);
                    String string4 = ProgressDialog.this.mProgressPercentFormat.format(d3);
                    SpannableString spannableString = new SpannableString(string4);
                    StyleSpan styleSpan = new StyleSpan(1);
                    int n5 = spannableString.length();
                    spannableString.setSpan(styleSpan, 0, n5, 33);
                    ProgressDialog.this.mProgressPercent.setText(spannableString);
                }
            };
            View view = layoutInflater.inflate(17367063, null);
            this.mProgress = progressBar = (ProgressBar)view.findViewById(16908301);
            this.mProgressNumber = textView2 = (TextView)view.findViewById(16908678);
            this.mProgressNumberFormat = "%d/%d";
            this.mProgressPercent = textView = (TextView)view.findViewById(16908677);
            this.mProgressPercentFormat = numberFormat = NumberFormat.getPercentInstance();
            this.mProgressPercentFormat.setMaximumFractionDigits(0);
            this.setView(view);
        } else {
            TextView textView;
            ProgressBar progressBar;
            View view = layoutInflater.inflate(17367119, null);
            this.mProgress = progressBar = (ProgressBar)view.findViewById(16908301);
            this.mMessageView = textView = (TextView)view.findViewById(16908299);
            this.setView(view);
        }
        if (this.mMax > 0) {
            int n = this.mMax;
            this.setMax(n);
        }
        if (this.mProgressVal > 0) {
            int n = this.mProgressVal;
            this.setProgress(n);
        }
        if (this.mSecondaryProgressVal > 0) {
            int n = this.mSecondaryProgressVal;
            this.setSecondaryProgress(n);
        }
        if (this.mIncrementBy > 0) {
            int n = this.mIncrementBy;
            this.incrementProgressBy(n);
        }
        if (this.mIncrementSecondaryBy > 0) {
            int n = this.mIncrementSecondaryBy;
            this.incrementSecondaryProgressBy(n);
        }
        if (this.mProgressDrawable != null) {
            Drawable drawable2 = this.mProgressDrawable;
            this.setProgressDrawable(drawable2);
        }
        if (this.mIndeterminateDrawable != null) {
            Drawable drawable3 = this.mIndeterminateDrawable;
            this.setIndeterminateDrawable(drawable3);
        }
        if (this.mMessage != null) {
            CharSequence charSequence = this.mMessage;
            this.setMessage(charSequence);
        }
        boolean bl = this.mIndeterminate;
        this.setIndeterminate(bl);
        this.onProgressChanged();
        super.onCreate(bundle);
    }

    @Override
    public void onStart() {
        super.onStart();
        this.mHasStarted = true;
    }

    @Override
    protected void onStop() {
        super.onStop();
        this.mHasStarted = false;
    }

    public void setIndeterminate(boolean bl) {
        if (this.mProgress != null) {
            this.mProgress.setIndeterminate(bl);
            return;
        }
        this.mIndeterminate = bl;
    }

    public void setIndeterminateDrawable(Drawable drawable2) {
        if (this.mProgress != null) {
            this.mProgress.setIndeterminateDrawable(drawable2);
            return;
        }
        this.mIndeterminateDrawable = drawable2;
    }

    public void setMax(int n) {
        if (this.mProgress != null) {
            this.mProgress.setMax(n);
            this.onProgressChanged();
            return;
        }
        this.mMax = n;
    }

    @Override
    public void setMessage(CharSequence charSequence) {
        if (this.mProgress != null) {
            if (this.mProgressStyle == 1) {
                super.setMessage(charSequence);
                return;
            }
            this.mMessageView.setText(charSequence);
            return;
        }
        this.mMessage = charSequence;
    }

    public void setProgress(int n) {
        if (this.mHasStarted) {
            this.mProgress.setProgress(n);
            this.onProgressChanged();
            return;
        }
        this.mProgressVal = n;
    }

    public void setProgressDrawable(Drawable drawable2) {
        if (this.mProgress != null) {
            this.mProgress.setProgressDrawable(drawable2);
            return;
        }
        this.mProgressDrawable = drawable2;
    }

    public void setProgressNumberFormat(String string2) {
        this.mProgressNumberFormat = string2;
    }

    public void setProgressStyle(int n) {
        this.mProgressStyle = n;
    }

    public void setSecondaryProgress(int n) {
        if (this.mProgress != null) {
            this.mProgress.setSecondaryProgress(n);
            this.onProgressChanged();
            return;
        }
        this.mSecondaryProgressVal = n;
    }
}

