/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Dialog;
import android.app.PendingIntent;
import android.app.SearchManager;
import android.app.SearchableInfo;
import android.app.SuggestionsAdapter;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.SystemClock;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class SearchDialog
extends Dialog
implements AdapterView.OnItemClickListener,
AdapterView.OnItemSelectedListener {
    private static final boolean DBG = false;
    private static final boolean DBG_LOG_TIMING = false;
    private static final String IME_OPTION_NO_MICROPHONE = "nm";
    private static final String INSTANCE_KEY_APPDATA = "data";
    private static final String INSTANCE_KEY_COMPONENT = "comp";
    private static final String INSTANCE_KEY_STORED_APPDATA = "sData";
    private static final String INSTANCE_KEY_USER_QUERY = "uQry";
    private static final String LOG_TAG = "SearchDialog";
    private static final boolean REWRITE_QUERIES = true;
    private static final int SEARCH_PLATE_LEFT_PADDING_GLOBAL = 12;
    private static final int SEARCH_PLATE_LEFT_PADDING_NON_GLOBAL = 7;
    private Context mActivityContext;
    private ImageView mAppIcon;
    private Bundle mAppSearchData;
    private TextView mBadgeLabel;
    View.OnKeyListener mButtonsKeyListener;
    private BroadcastReceiver mConfChangeListener;
    private Button mGoButton;
    View.OnClickListener mGoButtonClickListener;
    private String mInitialQuery;
    private AtomicLong mLastLogTime;
    private ComponentName mLaunchComponent;
    private final WeakHashMap<String, Drawable.ConstantState> mOutsideDrawablesCache;
    private SearchAutoComplete mSearchAutoComplete;
    private int mSearchAutoCompleteImeOptions;
    private SearchManager mSearchManager;
    private View mSearchPlate;
    private SearchableInfo mSearchable;
    private SuggestionsAdapter mSuggestionsAdapter;
    View.OnKeyListener mTextKeyListener;
    private TextWatcher mTextWatcher;
    private String mUserQuery;
    private final Intent mVoiceAppSearchIntent;
    private ImageButton mVoiceButton;
    View.OnClickListener mVoiceButtonClickListener;
    private final Intent mVoiceWebSearchIntent;
    private Drawable mWorkingSpinner;

    public SearchDialog(Context context, SearchManager searchManager) {
        super(context, 16973988);
        Intent intent;
        Intent intent2;
        AtomicLong atomicLong;
        View.OnKeyListener onKeyListener;
        View.OnClickListener onClickListener;
        View.OnClickListener onClickListener2;
        View.OnKeyListener onKeyListener2;
        TextWatcher textWatcher;
        BroadcastReceiver broadcastReceiver;
        WeakHashMap weakHashMap = new WeakHashMap();
        this.mOutsideDrawablesCache = weakHashMap;
        this.mConfChangeListener = broadcastReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                if (!intent.getAction().equals("android.intent.action.CONFIGURATION_CHANGED")) {
                    return;
                }
                SearchDialog.this.onConfigurationChanged();
            }
        };
        this.mTextWatcher = textWatcher = new TextWatcher(){

            @Override
            public void afterTextChanged(Editable editable) {
                int n;
                if (SearchDialog.this.mSearchable == null) {
                    return;
                }
                if (!SearchDialog.this.mSearchable.autoUrlDetect()) {
                    return;
                }
                if (SearchDialog.this.mSearchAutoComplete.isPerformingCompletion()) {
                    return;
                }
                int n2 = SearchDialog.this.mSearchAutoComplete.getImeOptions() & 0xFFFFFF00 | 2;
                if (n2 != (n = SearchDialog.this.mSearchAutoCompleteImeOptions)) {
                    return;
                }
                int n3 = SearchDialog.access$902(SearchDialog.this, n2);
                SearchDialog.this.mSearchAutoComplete.setImeOptions(n2);
                SearchAutoComplete searchAutoComplete = SearchDialog.this.mSearchAutoComplete;
                int n4 = SearchDialog.this.mSearchAutoComplete.getInputType();
                searchAutoComplete.setInputType(n4);
            }

            @Override
            public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                String string2;
                String string3;
                if (SearchDialog.this.mSearchable == null) {
                    return;
                }
                if (!SearchDialog.this.mSearchAutoComplete.isPerformingCompletion()) {
                    SearchDialog searchDialog = SearchDialog.this;
                    String string4 = charSequence == null ? "" : ((Object)charSequence).toString();
                    String string5 = SearchDialog.access$202(searchDialog, string4);
                }
                SearchDialog.this.updateWidgetState();
                SearchDialog searchDialog = SearchDialog.this;
                boolean bl = SearchDialog.this.mSearchAutoComplete.isEmpty() || SearchDialog.this.isBrowserSearch() && (string3 = SearchDialog.this.mInitialQuery).equals(string2 = SearchDialog.this.mUserQuery) || SearchDialog.this.mAppSearchData != null && SearchDialog.this.mAppSearchData.getBoolean("android.search.CONTEXT_IS_VOICE");
                searchDialog.updateVoiceButton(bl);
            }
        };
        this.mButtonsKeyListener = onKeyListener2 = new View.OnKeyListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean onKey(View view, int n, KeyEvent keyEvent) {
                if (SearchDialog.this.mSearchable == null) {
                    return false;
                }
                if (keyEvent.isSystem()) return false;
                if (n == 19) return false;
                if (n == 21) return false;
                if (n == 22) return false;
                if (n == 23) return false;
                if (!SearchDialog.this.mSearchAutoComplete.requestFocus()) return false;
                return SearchDialog.this.mSearchAutoComplete.dispatchKeyEvent(keyEvent);
            }
        };
        this.mGoButtonClickListener = onClickListener2 = new View.OnClickListener(){

            @Override
            public void onClick(View view) {
                if (SearchDialog.this.mSearchable == null) {
                    return;
                }
                SearchDialog.this.launchQuerySearch();
            }
        };
        this.mVoiceButtonClickListener = onClickListener = new View.OnClickListener(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onClick(View view) {
                block6: {
                    if (SearchDialog.this.mSearchable == null) {
                        return;
                    }
                    SearchableInfo searchableInfo = SearchDialog.this.mSearchable;
                    try {
                        if (searchableInfo.getVoiceSearchLaunchWebSearch()) {
                            SearchDialog searchDialog = SearchDialog.this;
                            Intent intent = SearchDialog.this.mVoiceWebSearchIntent;
                            Intent intent2 = searchDialog.createVoiceWebSearchIntent(intent, searchableInfo);
                            SearchDialog.this.getContext().startActivity(intent2);
                            break block6;
                        }
                        if (searchableInfo.getVoiceSearchLaunchRecognizer()) {
                            SearchDialog searchDialog = SearchDialog.this;
                            Intent intent = SearchDialog.this.mVoiceAppSearchIntent;
                            Intent intent3 = searchDialog.createVoiceAppSearchIntent(intent, searchableInfo);
                            SearchDialog.this.getContext().startActivity(intent3);
                        }
                    }
                    catch (ActivityNotFoundException activityNotFoundException) {
                        int n = Log.w(SearchDialog.LOG_TAG, "Could not find voice search activity");
                    }
                }
                SearchDialog.this.dismiss();
            }
        };
        this.mTextKeyListener = onKeyListener = new View.OnKeyListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean onKey(View view, int n, KeyEvent keyEvent) {
                if (SearchDialog.this.mSearchable == null) {
                    return false;
                }
                if (SearchDialog.this.mSearchAutoComplete.isPopupShowing() && SearchDialog.this.mSearchAutoComplete.getListSelection() != -1) {
                    return SearchDialog.this.onSuggestionsKey(view, n, keyEvent);
                }
                if (SearchDialog.this.mSearchAutoComplete.isEmpty()) return false;
                if (n == 66 && keyEvent.getAction() == 1) {
                    view.cancelLongPress();
                    if (SearchDialog.this.mSearchable.autoUrlDetect() && (SearchDialog.this.mSearchAutoCompleteImeOptions & 0xFF) == 2) {
                        SearchDialog searchDialog = SearchDialog.this;
                        String string2 = SearchDialog.this.mSearchAutoComplete.getText().toString();
                        Uri uri = Uri.parse(searchDialog.fixUrl(string2));
                        Intent intent = new Intent("android.intent.action.VIEW", uri);
                        Intent intent2 = intent.setFlags(0x10000000);
                        SearchDialog.this.launchIntent(intent);
                        return true;
                    }
                    SearchDialog.this.launchQuerySearch();
                    return true;
                }
                if (keyEvent.getAction() != 0) return false;
                SearchableInfo.ActionKeyInfo actionKeyInfo = SearchDialog.this.mSearchable.findActionKey(n);
                if (actionKeyInfo == null) return false;
                if (actionKeyInfo.getQueryActionMsg() == null) return false;
                SearchDialog searchDialog = SearchDialog.this;
                String string3 = actionKeyInfo.getQueryActionMsg();
                searchDialog.launchQuerySearch(n, string3);
                return true;
            }
        };
        long l = SystemClock.uptimeMillis();
        this.mLastLogTime = atomicLong = new AtomicLong(l);
        this.mVoiceWebSearchIntent = intent2 = new Intent("android.speech.action.WEB_SEARCH");
        Intent intent3 = this.mVoiceWebSearchIntent.addFlags(0x10000000);
        Intent intent4 = this.mVoiceWebSearchIntent.putExtra("android.speech.extra.LANGUAGE_MODEL", "web_search");
        this.mVoiceAppSearchIntent = intent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        Intent intent5 = this.mVoiceAppSearchIntent.addFlags(0x10000000);
        this.mSearchManager = searchManager;
    }

    static /* synthetic */ String access$202(SearchDialog searchDialog, String string2) {
        searchDialog.mUserQuery = string2;
        return string2;
    }

    static /* synthetic */ int access$902(SearchDialog searchDialog, int n) {
        searchDialog.mSearchAutoCompleteImeOptions = n;
        return n;
    }

    private void closeSuggestionsAdapter() {
        SearchAutoComplete searchAutoComplete = this.mSearchAutoComplete;
        SuggestionsAdapter suggestionsAdapter = null;
        searchAutoComplete.setAdapter(suggestionsAdapter);
        if (this.mSuggestionsAdapter != null) {
            this.mSuggestionsAdapter.close();
        }
        this.mSuggestionsAdapter = null;
    }

    private void createContentView() {
        int n;
        Drawable drawable2;
        View view;
        ImageButton imageButton;
        Button button;
        ImageView imageView;
        SearchAutoComplete searchAutoComplete;
        TextView textView;
        this.setContentView(17367130);
        ((SearchBar)this.findViewById(16908814)).setSearchDialog(this);
        this.mBadgeLabel = textView = (TextView)this.findViewById(0x1020210);
        this.mSearchAutoComplete = searchAutoComplete = (SearchAutoComplete)this.findViewById(16908819);
        this.mAppIcon = imageView = (ImageView)this.findViewById(0x1020212);
        this.mGoButton = button = (Button)this.findViewById(16908820);
        this.mVoiceButton = imageButton = (ImageButton)this.findViewById(16908821);
        this.mSearchPlate = view = this.findViewById(16908815);
        this.mWorkingSpinner = drawable2 = this.getContext().getResources().getDrawable(17302137);
        SearchAutoComplete searchAutoComplete2 = this.mSearchAutoComplete;
        Drawable drawable3 = this.mWorkingSpinner;
        searchAutoComplete2.setCompoundDrawablesWithIntrinsicBounds(null, null, drawable3, null);
        this.setWorking(false);
        SearchAutoComplete searchAutoComplete3 = this.mSearchAutoComplete;
        TextWatcher textWatcher = this.mTextWatcher;
        searchAutoComplete3.addTextChangedListener(textWatcher);
        SearchAutoComplete searchAutoComplete4 = this.mSearchAutoComplete;
        View.OnKeyListener onKeyListener = this.mTextKeyListener;
        searchAutoComplete4.setOnKeyListener(onKeyListener);
        this.mSearchAutoComplete.setOnItemClickListener(this);
        this.mSearchAutoComplete.setOnItemSelectedListener(this);
        Button button2 = this.mGoButton;
        View.OnClickListener onClickListener = this.mGoButtonClickListener;
        button2.setOnClickListener(onClickListener);
        Button button3 = this.mGoButton;
        View.OnKeyListener onKeyListener2 = this.mButtonsKeyListener;
        button3.setOnKeyListener(onKeyListener2);
        ImageButton imageButton2 = this.mVoiceButton;
        View.OnClickListener onClickListener2 = this.mVoiceButtonClickListener;
        imageButton2.setOnClickListener(onClickListener2);
        ImageButton imageButton3 = this.mVoiceButton;
        View.OnKeyListener onKeyListener3 = this.mButtonsKeyListener;
        imageButton3.setOnKeyListener(onKeyListener3);
        this.mBadgeLabel.setVisibility(8);
        this.mSearchAutoCompleteImeOptions = n = this.mSearchAutoComplete.getImeOptions();
    }

    private Intent createIntent(String string2, Uri uri, String string3, String string4, String string5, int n, String string6) {
        Intent intent = new Intent(string2);
        Intent intent2 = intent.addFlags(0x10000000);
        if (uri != null) {
            Intent intent3 = intent.setData(uri);
        }
        String string7 = this.mUserQuery;
        Intent intent4 = intent.putExtra("user_query", string7);
        if (string4 != null) {
            Intent intent5 = intent.putExtra("query", string4);
        }
        if (string3 != null) {
            Intent intent6 = intent.putExtra("intent_extra_data_key", string3);
        }
        if (this.mAppSearchData != null) {
            Bundle bundle = this.mAppSearchData;
            Intent intent7 = intent.putExtra("app_data", bundle);
        }
        if (n != 0) {
            Intent intent8 = intent.putExtra("action_key", n);
            Intent intent9 = intent.putExtra("action_msg", string6);
        }
        ComponentName componentName = this.mSearchable.getSearchActivity();
        Intent intent10 = intent.setComponent(componentName);
        return intent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Intent createIntentFromSuggestion(Cursor cursor, int n, String string2) {
        try {
            Uri uri;
            String string3;
            String string4;
            String string5 = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_action");
            if ("android.search.action.ZILCH".equals(string5)) {
                return null;
            }
            if (string5 == null) {
                string5 = this.mSearchable.getSuggestIntentAction();
            }
            if (string5 == null) {
                string5 = "android.intent.action.SEARCH";
            }
            if ((string4 = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_data")) == null) {
                string4 = this.mSearchable.getSuggestIntentData();
            }
            if (string4 != null && (string3 = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_data_id")) != null) {
                StringBuilder stringBuilder = new StringBuilder().append(string4).append("/");
                String string6 = Uri.encode(string3);
                string4 = stringBuilder.append(string6).toString();
            }
            Uri uri2 = string4 == null ? null : (uri = Uri.parse(string4));
            String string7 = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_component");
            String string8 = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_query");
            String string9 = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_extra_data");
            SearchDialog searchDialog = this;
            int n2 = n;
            String string10 = string2;
            return searchDialog.createIntent(string5, uri2, string9, string8, string7, n2, string10);
        }
        catch (RuntimeException runtimeException) {
            int n3;
            try {
                int n4;
                n3 = n4 = cursor.getPosition();
            }
            catch (RuntimeException runtimeException2) {
                n3 = -1;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Search Suggestions cursor at row ").append(n3).append(" returned exception");
            String string11 = runtimeException.toString();
            String string12 = stringBuilder.append(string11).toString();
            int n5 = Log.w(LOG_TAG, string12);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Intent createVoiceAppSearchIntent(Intent intent, SearchableInfo searchableInfo) {
        ComponentName componentName = searchableInfo.getSearchActivity();
        Intent intent2 = new Intent("android.intent.action.SEARCH");
        Intent intent3 = intent2.setComponent(componentName);
        PendingIntent pendingIntent = PendingIntent.getActivity(this.getContext(), 0, intent2, 0x40000000);
        Bundle bundle = new Bundle();
        if (this.mAppSearchData != null) {
            Bundle bundle2 = this.mAppSearchData;
            bundle.putBundle("app_data", bundle2);
        }
        Intent intent4 = new Intent(intent);
        String string2 = "free_form";
        String string3 = null;
        String string4 = null;
        int n = 1;
        Resources resources = this.mActivityContext.getResources();
        if (searchableInfo.getVoiceLanguageModeId() != 0) {
            int n2 = searchableInfo.getVoiceLanguageModeId();
            string2 = resources.getString(n2);
        }
        if (searchableInfo.getVoicePromptTextId() != 0) {
            int n3 = searchableInfo.getVoicePromptTextId();
            string3 = resources.getString(n3);
        }
        if (searchableInfo.getVoiceLanguageId() != 0) {
            int n4 = searchableInfo.getVoiceLanguageId();
            string4 = resources.getString(n4);
        }
        if (searchableInfo.getVoiceMaxResults() != 0) {
            n = searchableInfo.getVoiceMaxResults();
        }
        Intent intent5 = intent4.putExtra("android.speech.extra.LANGUAGE_MODEL", string2);
        Intent intent6 = intent4.putExtra("android.speech.extra.PROMPT", string3);
        Intent intent7 = intent4.putExtra("android.speech.extra.LANGUAGE", string4);
        Intent intent8 = intent4.putExtra("android.speech.extra.MAX_RESULTS", n);
        String string5 = "calling_package";
        String string6 = componentName == null ? null : componentName.flattenToShortString();
        Intent intent9 = intent4.putExtra(string5, string6);
        Intent intent10 = intent4.putExtra("android.speech.extra.RESULTS_PENDINGINTENT", pendingIntent);
        Intent intent11 = intent4.putExtra("android.speech.extra.RESULTS_PENDINGINTENT_BUNDLE", bundle);
        return intent4;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Intent createVoiceWebSearchIntent(Intent intent, SearchableInfo searchableInfo) {
        Intent intent2 = new Intent(intent);
        ComponentName componentName = searchableInfo.getSearchActivity();
        String string2 = componentName == null ? null : componentName.flattenToShortString();
        Intent intent3 = intent2.putExtra("calling_package", string2);
        return intent2;
    }

    private void dbgLogTiming(String string2) {
        long l = SystemClock.uptimeMillis();
        long l2 = this.mLastLogTime.getAndSet(l);
        long l3 = l - l2;
        String string3 = l + " (+" + l3 + ") ticks for Search keystroke in " + string2;
        int n = Log.d(LOG_TAG, string3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean doShow(String string2, boolean bl, ComponentName componentName, Bundle bundle) {
        if (!this.show(componentName, bundle)) {
            return false;
        }
        String string3 = string2 == null ? "" : string2;
        this.mInitialQuery = string3;
        this.setUserQuery(string2);
        if (!bl) return true;
        this.mSearchAutoComplete.selectAll();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String fixUrl(String string2) {
        if (string2.startsWith("http://")) return string2;
        if (string2.startsWith("https://")) {
            return string2;
        }
        if (string2.startsWith("http:") || string2.startsWith("https:")) {
            string2 = string2.startsWith("http:/") || string2.startsWith("https:/") ? string2.replaceFirst("/", "//") : string2.replaceFirst(":", "://");
        }
        if (string2.indexOf("://") != -1) return string2;
        string2 = "http://" + string2;
        return string2;
    }

    private static String getActionKeyMessage(Cursor cursor, SearchableInfo.ActionKeyInfo actionKeyInfo) {
        String string2 = null;
        String string3 = actionKeyInfo.getSuggestActionMsgColumn();
        if (string3 != null) {
            string2 = SuggestionsAdapter.getColumnString(cursor, string3);
        }
        if (string2 == null) {
            string2 = actionKeyInfo.getSuggestActionMsg();
        }
        return string2;
    }

    private boolean isBrowserSearch() {
        return this.mLaunchComponent.flattenToShortString().startsWith("com.android.browser/");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean isLandscapeMode(Context context) {
        if (context.getResources().getConfiguration().orientation != 2) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isOutOfBounds(View view, MotionEvent motionEvent) {
        int n = (int)motionEvent.getX();
        int n2 = (int)motionEvent.getY();
        int n3 = ViewConfiguration.get(this.mContext).getScaledWindowTouchSlop();
        int n4 = -n3;
        if (n < n4) return true;
        int n5 = -n3;
        if (n2 < n5) return true;
        int n6 = view.getWidth() + n3;
        if (n > n6) return true;
        int n7 = view.getHeight() + n3;
        if (n2 <= n7) return false;
        return true;
    }

    private void launchIntent(Intent intent) {
        if (intent == null) {
            return;
        }
        String string2 = "launching " + intent;
        int n = Log.d(LOG_TAG, string2);
        try {
            StringBuilder stringBuilder = new StringBuilder().append("Starting (as ourselves) ");
            String string3 = intent.toURI();
            String string4 = stringBuilder.append(string3).toString();
            int n2 = Log.i(LOG_TAG, string4);
            this.getContext().startActivity(intent);
            this.dismiss();
            return;
        }
        catch (RuntimeException runtimeException) {
            String string5 = "Failed launch activity: " + intent;
            int n3 = Log.e(LOG_TAG, string5, runtimeException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean onSuggestionsKey(View view, int n, KeyEvent keyEvent) {
        int n2;
        if (this.mSearchable == null) {
            return false;
        }
        if (this.mSuggestionsAdapter == null) {
            return false;
        }
        if (keyEvent.getAction() != 0) return false;
        if (n == 66 || n == 84) {
            int n3 = this.mSearchAutoComplete.getListSelection();
            return this.launchSuggestion(n3);
        }
        if (n == 21 || n == 22) {
            int n4 = n == 21 ? 0 : this.mSearchAutoComplete.length();
            this.mSearchAutoComplete.setSelection(n4);
            this.mSearchAutoComplete.setListSelection(0);
            this.mSearchAutoComplete.clearListSelection();
            this.mSearchAutoComplete.ensureImeVisible(true);
            return true;
        }
        if (n == 19 && this.mSearchAutoComplete.getListSelection() == 0) {
            this.restoreUserQuery();
            return false;
        }
        SearchableInfo.ActionKeyInfo actionKeyInfo = this.mSearchable.findActionKey(n);
        if (actionKeyInfo == null) return false;
        if (actionKeyInfo.getSuggestActionMsg() == null) {
            if (actionKeyInfo.getSuggestActionMsgColumn() == null) return false;
        }
        if ((n2 = this.mSearchAutoComplete.getListSelection()) == -1) return false;
        Cursor cursor = this.mSuggestionsAdapter.getCursor();
        if (!cursor.moveToPosition(n2)) return false;
        String string2 = SearchDialog.getActionKeyMessage(cursor, actionKeyInfo);
        if (string2 == null) return false;
        if (string2.length() <= 0) return false;
        return this.launchSuggestion(n2, n, string2);
    }

    private void restoreUserQuery() {
        String string2 = this.mUserQuery;
        this.setQuery(string2);
    }

    private void rewriteQueryFromSuggestion(int n) {
        Cursor cursor = this.mSuggestionsAdapter.getCursor();
        if (cursor == null) {
            return;
        }
        if (cursor.moveToPosition(n)) {
            CharSequence charSequence = this.mSuggestionsAdapter.convertToString(cursor);
            if (charSequence != null) {
                this.setQuery(charSequence);
                return;
            }
            this.restoreUserQuery();
            return;
        }
        String string2 = "Bad suggestion position: " + n;
        int n2 = Log.w(LOG_TAG, string2);
        this.restoreUserQuery();
    }

    private void setBrowserApplicationId(Intent intent) {
        Uri uri = intent.getData();
        String string2 = intent.getAction();
        if (!"android.intent.action.VIEW".equals(string2)) {
            return;
        }
        if (uri == null) {
            return;
        }
        String string3 = uri.getScheme();
        if (string3 == null) {
            return;
        }
        if (!string3.startsWith("http")) {
            return;
        }
        String string4 = uri.toString();
        Intent intent2 = intent.putExtra("com.android.browser.application_id", string4);
    }

    private void setQuery(CharSequence charSequence) {
        this.mSearchAutoComplete.setText(charSequence, false);
        if (charSequence == null) {
            return;
        }
        SearchAutoComplete searchAutoComplete = this.mSearchAutoComplete;
        int n = charSequence.length();
        searchAutoComplete.setSelection(n);
    }

    private void setUserQuery(String string2) {
        if (string2 == null) {
            string2 = "";
        }
        this.mUserQuery = string2;
        this.mSearchAutoComplete.setText(string2);
        SearchAutoComplete searchAutoComplete = this.mSearchAutoComplete;
        int n = string2.length();
        searchAutoComplete.setSelection(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean show(ComponentName componentName, Bundle bundle) {
        Context context;
        SearchableInfo searchableInfo;
        this.mSearchable = searchableInfo = ((SearchManager)this.mContext.getSystemService("search")).getSearchableInfo(componentName);
        if (this.mSearchable == null) {
            return false;
        }
        this.mLaunchComponent = componentName;
        this.mAppSearchData = bundle;
        SearchableInfo searchableInfo2 = this.mSearchable;
        Context context2 = this.getContext();
        this.mActivityContext = context = searchableInfo2.getActivityContext(context2);
        if (!this.isShowing()) {
            this.createContentView();
            this.show();
        }
        this.updateUI();
        return true;
    }

    private void updateQueryHint() {
        int n;
        if (!this.isShowing()) {
            return;
        }
        String string2 = null;
        if (this.mSearchable != null && (n = this.mSearchable.getHintId()) != 0) {
            string2 = this.mActivityContext.getString(n);
        }
        this.mSearchAutoComplete.setHint(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateSearchAppIcon() {
        Drawable drawable2;
        if (this.isBrowserSearch()) {
            this.mAppIcon.setImageResource(0);
            this.mAppIcon.setVisibility(8);
            View view = this.mSearchPlate;
            int n = this.mSearchPlate.getPaddingTop();
            int n2 = this.mSearchPlate.getPaddingRight();
            int n3 = this.mSearchPlate.getPaddingBottom();
            view.setPadding(12, n, n2, n3);
            return;
        }
        PackageManager packageManager = this.getContext().getPackageManager();
        try {
            Drawable drawable3;
            ComponentName componentName = this.mLaunchComponent;
            ApplicationInfo applicationInfo = packageManager.getActivityInfo((ComponentName)componentName, (int)0).applicationInfo;
            drawable2 = drawable3 = packageManager.getApplicationIcon(applicationInfo);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            drawable2 = packageManager.getDefaultActivityIcon();
            StringBuilder stringBuilder = new StringBuilder();
            ComponentName componentName = this.mLaunchComponent;
            String string2 = stringBuilder.append(componentName).append(" not found, using generic app icon").toString();
            int n = Log.w(LOG_TAG, string2);
        }
        this.mAppIcon.setImageDrawable(drawable2);
        this.mAppIcon.setVisibility(0);
        View view = this.mSearchPlate;
        int n = this.mSearchPlate.getPaddingTop();
        int n4 = this.mSearchPlate.getPaddingRight();
        int n5 = this.mSearchPlate.getPaddingBottom();
        view.setPadding(7, n, n4, n5);
    }

    private void updateSearchAutoComplete() {
        SuggestionsAdapter suggestionsAdapter;
        this.closeSuggestionsAdapter();
        this.mSearchAutoComplete.setDropDownAnimationStyle(0);
        SearchAutoComplete searchAutoComplete = this.mSearchAutoComplete;
        int n = this.mSearchable.getSuggestThreshold();
        searchAutoComplete.setThreshold(n);
        this.mSearchAutoComplete.setDropDownDismissedOnCompletion(false);
        this.mSearchAutoComplete.setForceIgnoreOutsideTouch(true);
        if (this.mSearchable.getSuggestAuthority() == null) {
            return;
        }
        Context context = this.getContext();
        SearchableInfo searchableInfo = this.mSearchable;
        WeakHashMap<String, Drawable.ConstantState> weakHashMap = this.mOutsideDrawablesCache;
        this.mSuggestionsAdapter = suggestionsAdapter = new SuggestionsAdapter(context, this, searchableInfo, weakHashMap);
        SearchAutoComplete searchAutoComplete2 = this.mSearchAutoComplete;
        SuggestionsAdapter suggestionsAdapter2 = this.mSuggestionsAdapter;
        searchAutoComplete2.setAdapter(suggestionsAdapter2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateSearchBadge() {
        int n = 8;
        Drawable drawable2 = null;
        String string2 = null;
        if (this.mSearchable.useBadgeIcon()) {
            Resources resources = this.mActivityContext.getResources();
            int n2 = this.mSearchable.getIconId();
            drawable2 = resources.getDrawable(n2);
            n = 0;
        } else if (this.mSearchable.useBadgeLabel()) {
            Resources resources = this.mActivityContext.getResources();
            int n3 = this.mSearchable.getLabelId();
            string2 = ((Object)resources.getText(n3)).toString();
            n = 0;
        }
        this.mBadgeLabel.setCompoundDrawablesWithIntrinsicBounds(drawable2, null, null, null);
        this.mBadgeLabel.setText(string2);
        this.mBadgeLabel.setVisibility(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateSearchButton() {
        String string2 = null;
        Drawable drawable2 = null;
        int n = this.mSearchable.getSearchButtonText();
        if (this.isBrowserSearch()) {
            drawable2 = this.getContext().getResources().getDrawable(17301897);
        } else if (n != 0) {
            string2 = this.mActivityContext.getResources().getString(n);
        } else {
            drawable2 = this.getContext().getResources().getDrawable(0x1080188);
        }
        this.mGoButton.setText(string2);
        this.mGoButton.setCompoundDrawablesWithIntrinsicBounds(drawable2, null, null, null);
    }

    private void updateUI() {
        int n;
        if (this.mSearchable == null) {
            return;
        }
        this.mDecor.setVisibility(0);
        this.updateSearchAutoComplete();
        this.updateSearchButton();
        this.updateSearchAppIcon();
        this.updateSearchBadge();
        this.updateQueryHint();
        boolean bl = TextUtils.isEmpty(this.mUserQuery);
        this.updateVoiceButton(bl);
        int n2 = this.mSearchable.getInputType();
        if ((n2 & 0xF) == 1) {
            n2 &= 0xFFFEFFFF;
            if (this.mSearchable.getSuggestAuthority() != null) {
                n2 |= 0x10000;
            }
        }
        this.mSearchAutoComplete.setInputType(n2);
        this.mSearchAutoCompleteImeOptions = n = this.mSearchable.getImeOptions();
        SearchAutoComplete searchAutoComplete = this.mSearchAutoComplete;
        int n3 = this.mSearchAutoCompleteImeOptions;
        searchAutoComplete.setImeOptions(n3);
        if (this.mSearchable.getVoiceSearchEnabled()) {
            this.mSearchAutoComplete.setPrivateImeOptions(IME_OPTION_NO_MICROPHONE);
            return;
        }
        this.mSearchAutoComplete.setPrivateImeOptions(null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateVoiceButton(boolean bl) {
        int n = 8;
        if ((this.mAppSearchData == null || !this.mAppSearchData.getBoolean("android.search.DISABLE_VOICE_SEARCH", false)) && this.mSearchable.getVoiceSearchEnabled() && bl) {
            Intent intent = null;
            if (this.mSearchable.getVoiceSearchLaunchWebSearch()) {
                intent = this.mVoiceWebSearchIntent;
            } else if (this.mSearchable.getVoiceSearchLaunchRecognizer()) {
                intent = this.mVoiceAppSearchIntent;
            }
            if (intent != null && this.getContext().getPackageManager().resolveActivity(intent, 65536) != null) {
                n = 0;
            }
        }
        this.mVoiceButton.setVisibility(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateWidgetState() {
        String string2;
        String string3;
        boolean bl = !this.mSearchAutoComplete.isEmpty();
        if (!this.isBrowserSearch()) {
            this.mGoButton.setEnabled(bl);
            this.mGoButton.setFocusable(bl);
            return;
        }
        if (bl && !(string3 = this.mInitialQuery).equals(string2 = this.mUserQuery)) {
            this.mSearchAutoComplete.setBackgroundResource(17302297);
            this.mGoButton.setVisibility(0);
            this.mGoButton.setEnabled(true);
            this.mGoButton.setFocusable(true);
            return;
        }
        this.mSearchAutoComplete.setBackgroundResource(17302299);
        this.mGoButton.setVisibility(8);
    }

    @Override
    public void hide() {
        if (!this.isShowing()) {
            return;
        }
        InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        if (inputMethodManager != null) {
            IBinder iBinder = this.getWindow().getDecorView().getWindowToken();
            boolean bl = inputMethodManager.hideSoftInputFromWindow(iBinder, 0);
        }
        super.hide();
    }

    public void launchQuerySearch() {
        this.launchQuerySearch(0, null);
    }

    protected void launchQuerySearch(int n, String string2) {
        String string3 = this.mSearchAutoComplete.getText().toString();
        SearchDialog searchDialog = this;
        String string4 = null;
        String string5 = null;
        int n2 = n;
        String string6 = string2;
        Intent intent = searchDialog.createIntent("android.intent.action.SEARCH", null, string4, string3, string5, n2, string6);
        this.launchIntent(intent);
    }

    protected boolean launchSuggestion(int n) {
        return this.launchSuggestion(n, 0, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean launchSuggestion(int n, int n2, String string2) {
        Cursor cursor = this.mSuggestionsAdapter.getCursor();
        if (cursor == null) return false;
        if (!cursor.moveToPosition(n)) return false;
        Intent intent = this.createIntentFromSuggestion(cursor, n2, string2);
        this.launchIntent(intent);
        return true;
    }

    @Override
    public void onBackPressed() {
        IBinder iBinder;
        InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        if (inputMethodManager != null && inputMethodManager.isFullscreenMode() && inputMethodManager.hideSoftInputFromWindow(iBinder = this.getWindow().getDecorView().getWindowToken(), 0)) {
            return;
        }
        this.cancel();
    }

    public void onConfigurationChanged() {
        if (this.mSearchable == null) {
            return;
        }
        if (!this.isShowing()) {
            return;
        }
        this.updateSearchButton();
        this.updateSearchAppIcon();
        this.updateSearchBadge();
        this.updateQueryHint();
        if (SearchDialog.isLandscapeMode(this.getContext())) {
            this.mSearchAutoComplete.ensureImeVisible(true);
        }
        this.mSearchAutoComplete.showDropDownAfterLayout();
    }

    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        Window window = this.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        layoutParams.width = -1;
        layoutParams.height = -1;
        layoutParams.gravity = 55;
        layoutParams.softInputMode = 16;
        window.setAttributes(layoutParams);
        this.setCanceledOnTouchOutside(true);
    }

    void onDataSetChanged() {
        if (this.mSearchAutoComplete == null) {
            return;
        }
        if (this.mSuggestionsAdapter == null) {
            return;
        }
        SearchAutoComplete searchAutoComplete = this.mSearchAutoComplete;
        int n = this.mSuggestionsAdapter.getCount();
        searchAutoComplete.onFilterComplete(n);
    }

    @Override
    public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
        boolean bl = this.launchSuggestion(n);
    }

    @Override
    public void onItemSelected(AdapterView<?> adapterView, View view, int n, long l) {
        this.rewriteQueryFromSuggestion(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (this.mSearchable == null) {
            return false;
        }
        SearchableInfo.ActionKeyInfo actionKeyInfo = this.mSearchable.findActionKey(n);
        if (actionKeyInfo == null) return super.onKeyDown(n, keyEvent);
        if (actionKeyInfo.getQueryActionMsg() == null) return super.onKeyDown(n, keyEvent);
        String string2 = actionKeyInfo.getQueryActionMsg();
        this.launchQuerySearch(n, string2);
        return true;
    }

    @Override
    public void onNothingSelected(AdapterView<?> adapterView) {
    }

    @Override
    public void onRestoreInstanceState(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        ComponentName componentName = (ComponentName)bundle.getParcelable(INSTANCE_KEY_COMPONENT);
        Bundle bundle2 = bundle.getBundle(INSTANCE_KEY_APPDATA);
        String string2 = bundle.getString(INSTANCE_KEY_USER_QUERY);
        if (this.doShow(string2, false, componentName, bundle2)) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Bundle onSaveInstanceState() {
        if (!this.isShowing()) {
            return null;
        }
        Bundle bundle = new Bundle();
        ComponentName componentName = this.mLaunchComponent;
        bundle.putParcelable(INSTANCE_KEY_COMPONENT, componentName);
        Bundle bundle2 = this.mAppSearchData;
        bundle.putBundle(INSTANCE_KEY_APPDATA, bundle2);
        String string2 = this.mUserQuery;
        bundle.putString(INSTANCE_KEY_USER_QUERY, string2);
        return bundle;
    }

    @Override
    public void onStart() {
        super.onStart();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.CONFIGURATION_CHANGED");
        Context context = this.getContext();
        BroadcastReceiver broadcastReceiver = this.mConfChangeListener;
        Intent intent = context.registerReceiver(broadcastReceiver, intentFilter);
    }

    @Override
    public void onStop() {
        super.onStop();
        Context context = this.getContext();
        BroadcastReceiver broadcastReceiver = this.mConfChangeListener;
        context.unregisterReceiver(broadcastReceiver);
        this.closeSuggestionsAdapter();
        this.mLaunchComponent = null;
        this.mAppSearchData = null;
        this.mSearchable = null;
        this.mUserQuery = null;
        this.mInitialQuery = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.mSearchAutoComplete.isPopupShowing()) return super.onTouchEvent(motionEvent);
        View view = this.mSearchPlate;
        if (!this.isOutOfBounds(view, motionEvent)) return super.onTouchEvent(motionEvent);
        this.cancel();
        return true;
    }

    public void setListSelection(int n) {
        this.mSearchAutoComplete.setListSelection(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setWorking(boolean bl) {
        Drawable drawable2 = this.mWorkingSpinner;
        int n = bl ? 255 : 0;
        drawable2.setAlpha(n);
        boolean bl2 = this.mWorkingSpinner.setVisible(bl, false);
        this.mWorkingSpinner.invalidateSelf();
    }

    public boolean show(String string2, boolean bl, ComponentName componentName, Bundle bundle) {
        boolean bl2 = this.doShow(string2, bl, componentName, bundle);
        if (bl2) {
            this.mSearchAutoComplete.showDropDownAfterLayout();
        }
        return bl2;
    }

    public static class SearchAutoComplete
    extends AutoCompleteTextView {
        private int mThreshold;

        public SearchAutoComplete(Context context) {
            super(context);
            int n;
            this.mThreshold = n = this.getThreshold();
        }

        public SearchAutoComplete(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            int n;
            this.mThreshold = n = this.getThreshold();
        }

        public SearchAutoComplete(Context context, AttributeSet attributeSet, int n) {
            super(context, attributeSet, n);
            int n2;
            this.mThreshold = n2 = this.getThreshold();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isEmpty() {
            if (TextUtils.getTrimmedLength(this.getText()) != 0) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean enoughToFilter() {
            if (this.mThreshold <= 0) return true;
            if (!super.enoughToFilter()) return false;
            return true;
        }

        @Override
        public void onWindowFocusChanged(boolean bl) {
            super.onWindowFocusChanged(bl);
            if (!bl) {
                return;
            }
            boolean bl2 = ((InputMethodManager)this.getContext().getSystemService("input_method")).showSoftInput(this, 0);
            if (!SearchDialog.isLandscapeMode(this.getContext())) {
                return;
            }
            this.ensureImeVisible(true);
        }

        @Override
        public void performCompletion() {
        }

        @Override
        protected void replaceText(CharSequence charSequence) {
        }

        @Override
        public void setThreshold(int n) {
            super.setThreshold(n);
            this.mThreshold = n;
        }
    }

    public static class SearchBar
    extends LinearLayout {
        private SearchDialog mSearchDialog;

        public SearchBar(Context context) {
            super(context);
        }

        public SearchBar(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean dispatchKeyEventPreIme(KeyEvent keyEvent) {
            if (this.mSearchDialog == null) return super.dispatchKeyEventPreIme(keyEvent);
            if (keyEvent.getKeyCode() != 4) return super.dispatchKeyEventPreIme(keyEvent);
            KeyEvent.DispatcherState dispatcherState = this.getKeyDispatcherState();
            if (dispatcherState == null) return super.dispatchKeyEventPreIme(keyEvent);
            if (keyEvent.getAction() == 0 && keyEvent.getRepeatCount() == 0) {
                dispatcherState.startTracking(keyEvent, this);
                return true;
            }
            if (keyEvent.getAction() != 1) return super.dispatchKeyEventPreIme(keyEvent);
            if (keyEvent.isCanceled()) return super.dispatchKeyEventPreIme(keyEvent);
            if (!dispatcherState.isTracking(keyEvent)) return super.dispatchKeyEventPreIme(keyEvent);
            this.mSearchDialog.onBackPressed();
            return true;
        }

        public void setSearchDialog(SearchDialog searchDialog) {
            this.mSearchDialog = searchDialog;
        }
    }
}

