/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ISearchManager;
import android.app.SearchDialog;
import android.app.SearchableInfo;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.text.TextUtils;
import android.util.Log;
import java.util.List;

public class SearchManager
implements DialogInterface.OnDismissListener,
DialogInterface.OnCancelListener {
    public static final String ACTION_KEY = "action_key";
    public static final String ACTION_MSG = "action_msg";
    public static final String APP_DATA = "app_data";
    public static final String CONTEXT_IS_VOICE = "android.search.CONTEXT_IS_VOICE";
    public static final String CURSOR_EXTRA_KEY_IN_PROGRESS = "in_progress";
    private static final boolean DBG = false;
    public static final String DISABLE_VOICE_SEARCH = "android.search.DISABLE_VOICE_SEARCH";
    public static final String EXTRA_DATA_KEY = "intent_extra_data_key";
    public static final String EXTRA_SELECT_QUERY = "select_query";
    public static final String INTENT_ACTION_GLOBAL_SEARCH = "android.search.action.GLOBAL_SEARCH";
    public static final String INTENT_ACTION_NONE = "android.search.action.ZILCH";
    public static final String INTENT_ACTION_SEARCHABLES_CHANGED = "android.search.action.SEARCHABLES_CHANGED";
    public static final String INTENT_ACTION_SEARCH_SETTINGS = "android.search.action.SEARCH_SETTINGS";
    public static final String INTENT_ACTION_SEARCH_SETTINGS_CHANGED = "android.search.action.SETTINGS_CHANGED";
    public static final String INTENT_ACTION_WEB_SEARCH_SETTINGS = "android.search.action.WEB_SEARCH_SETTINGS";
    public static final char MENU_KEY = 's';
    public static final int MENU_KEYCODE = 47;
    public static final String QUERY = "query";
    public static final String SEARCH_MODE = "search_mode";
    public static final String SHORTCUT_MIME_TYPE = "vnd.android.cursor.item/vnd.android.search.suggest";
    public static final String SUGGEST_COLUMN_BACKGROUND_COLOR = "suggest_background_color";
    public static final String SUGGEST_COLUMN_FORMAT = "suggest_format";
    public static final String SUGGEST_COLUMN_ICON_1 = "suggest_icon_1";
    public static final String SUGGEST_COLUMN_ICON_2 = "suggest_icon_2";
    public static final String SUGGEST_COLUMN_INTENT_ACTION = "suggest_intent_action";
    public static final String SUGGEST_COLUMN_INTENT_COMPONENT_NAME = "suggest_intent_component";
    public static final String SUGGEST_COLUMN_INTENT_DATA = "suggest_intent_data";
    public static final String SUGGEST_COLUMN_INTENT_DATA_ID = "suggest_intent_data_id";
    public static final String SUGGEST_COLUMN_INTENT_EXTRA_DATA = "suggest_intent_extra_data";
    public static final String SUGGEST_COLUMN_QUERY = "suggest_intent_query";
    public static final String SUGGEST_COLUMN_SHORTCUT_ID = "suggest_shortcut_id";
    public static final String SUGGEST_COLUMN_SPINNER_WHILE_REFRESHING = "suggest_spinner_while_refreshing";
    public static final String SUGGEST_COLUMN_TEXT_1 = "suggest_text_1";
    public static final String SUGGEST_COLUMN_TEXT_2 = "suggest_text_2";
    public static final String SUGGEST_COLUMN_TEXT_2_URL = "suggest_text_2_url";
    public static final String SUGGEST_MIME_TYPE = "vnd.android.cursor.dir/vnd.android.search.suggest";
    public static final String SUGGEST_NEVER_MAKE_SHORTCUT = "_-1";
    public static final String SUGGEST_PARAMETER_LIMIT = "limit";
    public static final String SUGGEST_URI_PATH_QUERY = "search_suggest_query";
    public static final String SUGGEST_URI_PATH_SHORTCUT = "search_suggest_shortcut";
    private static final String TAG = "SearchManager";
    public static final String USER_QUERY = "user_query";
    private static ISearchManager mService;
    private String mAssociatedPackage;
    OnCancelListener mCancelListener = null;
    private final Context mContext;
    OnDismissListener mDismissListener = null;
    final Handler mHandler;
    private SearchDialog mSearchDialog;

    SearchManager(Context context, Handler handler) {
        this.mContext = context;
        this.mHandler = handler;
        mService = ISearchManager.Stub.asInterface(ServiceManager.getService("search"));
    }

    private void ensureSearchDialog() {
        SearchDialog searchDialog;
        if (this.mSearchDialog != null) {
            return;
        }
        Context context = this.mContext;
        this.mSearchDialog = searchDialog = new SearchDialog(context, this);
        this.mSearchDialog.setOnCancelListener(this);
        this.mSearchDialog.setOnDismissListener(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ComponentName getGlobalSearchActivity() {
        try {
            ComponentName componentName = mService.getGlobalSearchActivity();
            return componentName;
        }
        catch (RemoteException remoteException) {
            String string2 = "getGlobalSearchActivity() failed: " + remoteException;
            int n = Log.e(TAG, string2);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SearchableInfo getSearchableInfo(ComponentName componentName) {
        try {
            SearchableInfo searchableInfo = mService.getSearchableInfo(componentName);
            return searchableInfo;
        }
        catch (RemoteException remoteException) {
            String string2 = "getSearchableInfo() failed: " + remoteException;
            int n = Log.e(TAG, string2);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<SearchableInfo> getSearchablesInGlobalSearch() {
        try {
            List<SearchableInfo> list = mService.getSearchablesInGlobalSearch();
            return list;
        }
        catch (RemoteException remoteException) {
            String string2 = "getSearchablesInGlobalSearch() failed: " + remoteException;
            int n = Log.e(TAG, string2);
            return null;
        }
    }

    public Cursor getSuggestions(SearchableInfo searchableInfo, String string2) {
        return this.getSuggestions(searchableInfo, string2, -1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Cursor getSuggestions(SearchableInfo searchableInfo, String string2, int n) {
        if (searchableInfo == null) {
            return null;
        }
        String string3 = searchableInfo.getSuggestAuthority();
        if (string3 == null) {
            return null;
        }
        Uri.Builder builder = new Uri.Builder().scheme("content").authority(string3).query("").fragment("");
        String string4 = searchableInfo.getSuggestPath();
        if (string4 != null) {
            Uri.Builder builder2 = builder.appendEncodedPath(string4);
        }
        Uri.Builder builder3 = builder.appendPath(SUGGEST_URI_PATH_QUERY);
        String string5 = searchableInfo.getSuggestSelection();
        String[] stringArray = null;
        if (string5 != null) {
            stringArray = new String[]{string2};
        } else {
            Uri.Builder builder4 = builder.appendPath(string2);
        }
        if (n > 0) {
            String string6 = String.valueOf(n);
            Uri.Builder builder5 = builder.appendQueryParameter(SUGGEST_PARAMETER_LIMIT, string6);
        }
        Uri uri = builder.build();
        ContentResolver contentResolver = this.mContext.getContentResolver();
        String string7 = null;
        return contentResolver.query(uri, null, string5, stringArray, string7);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ComponentName getWebSearchActivity() {
        try {
            ComponentName componentName = mService.getWebSearchActivity();
            return componentName;
        }
        catch (RemoteException remoteException) {
            String string2 = "getWebSearchActivity() failed: " + remoteException;
            int n = Log.e(TAG, string2);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isVisible() {
        if (this.mSearchDialog != null) return this.mSearchDialog.isShowing();
        return false;
    }

    @Override
    @Deprecated
    public void onCancel(DialogInterface dialogInterface) {
        if (this.mCancelListener == null) {
            return;
        }
        this.mCancelListener.onCancel();
    }

    @Override
    @Deprecated
    public void onDismiss(DialogInterface dialogInterface) {
        if (this.mDismissListener == null) {
            return;
        }
        this.mDismissListener.onDismiss();
    }

    public void setOnCancelListener(OnCancelListener onCancelListener) {
        this.mCancelListener = onCancelListener;
    }

    public void setOnDismissListener(OnDismissListener onDismissListener) {
        this.mDismissListener = onDismissListener;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void startGlobalSearch(String string2, boolean bl, Bundle bundle) {
        ComponentName componentName = this.getGlobalSearchActivity();
        if (componentName == null) {
            int n = Log.w(TAG, "No global search activity found.");
            return;
        }
        Intent intent = new Intent(INTENT_ACTION_GLOBAL_SEARCH);
        Intent intent2 = intent.addFlags(0x10000000);
        Intent intent3 = intent.setComponent(componentName);
        if (!(bundle = bundle == null ? new Bundle() : new Bundle(bundle)).containsKey("source")) {
            String string3 = this.mContext.getPackageName();
            bundle.putString("source", string3);
        }
        Intent intent4 = intent.putExtra(APP_DATA, bundle);
        if (!TextUtils.isEmpty(string2)) {
            Intent intent5 = intent.putExtra(QUERY, string2);
        }
        if (bl) {
            Intent intent6 = intent.putExtra(EXTRA_SELECT_QUERY, bl);
        }
        try {
            this.mContext.startActivity(intent);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            String string4 = "Global search activity not found: " + componentName;
            int n = Log.e(TAG, string4);
            return;
        }
    }

    public void startSearch(String string2, boolean bl, ComponentName componentName, Bundle bundle, boolean bl2) {
        if (bl2) {
            this.startGlobalSearch(string2, bl, bundle);
            return;
        }
        this.ensureSearchDialog();
        boolean bl3 = this.mSearchDialog.show(string2, bl, componentName, bundle);
    }

    public void stopSearch() {
        if (this.mSearchDialog == null) {
            return;
        }
        this.mSearchDialog.cancel();
    }

    public void triggerSearch(String string2, ComponentName componentName, Bundle bundle) {
        String string3 = this.mAssociatedPackage;
        String string4 = componentName.getPackageName();
        if (!string3.equals(string4)) {
            throw new IllegalArgumentException("invoking app search on a different package not associated with this search manager");
        }
        if (string2 == null || TextUtils.getTrimmedLength(string2) == 0) {
            int n = Log.w(TAG, "triggerSearch called with empty query, ignoring.");
            return;
        }
        SearchManager searchManager = this;
        String string5 = string2;
        ComponentName componentName2 = componentName;
        Bundle bundle2 = bundle;
        boolean bl = false;
        searchManager.startSearch(string5, false, componentName2, bundle2, bl);
        this.mSearchDialog.launchQuerySearch();
    }

    public static interface OnCancelListener {
        public void onCancel();
    }

    public static interface OnDismissListener {
        public void onDismiss();
    }
}

